/*
 * Decompiled with CFR 0.152.
 */
package test.ssh;

import ibis.smartsockets.util.ssh.LocalStreamForwarder;
import ibis.smartsockets.util.ssh.PasswordCredential;
import ibis.smartsockets.util.ssh.SSHConnection;
import ibis.smartsockets.util.ssh.SSHUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.sshd.client.SshClient;

public class Simple {
    private static String filename = "/home/jason/.ssh/id_rsa";

    public static void main(String[] args) {
        if (args.length == 3) {
            String user = args[0];
            String host = args[1];
            int port = Integer.parseInt(args[2]);
            Simple.client(user, host, port);
        } else {
            Simple.server();
        }
    }

    private static void server() {
        try {
            ServerSocket ss = new ServerSocket(0);
            System.out.println("Server listening on port: " + ss.getLocalPort());
            Socket s = ss.accept();
            DataInputStream in = new DataInputStream(s.getInputStream());
            DataOutputStream out = new DataOutputStream(s.getOutputStream());
            String reply = in.readUTF();
            System.out.println("Client says: " + reply);
            out.writeUTF("Hello");
            out.flush();
            out.close();
            in.close();
            s.close();
        }
        catch (Exception e) {
            System.err.println("Eek: " + e);
            e.printStackTrace(System.err);
        }
    }

    private static void client(String user, String host, int port) {
        try {
            SshClient client = SSHUtil.createSSHClient();
            SSHConnection connection = SSHUtil.connect("test", client, host, new PasswordCredential(user, new char[0]), 65536, 10000L);
            LocalStreamForwarder lsf = connection.createLocalStreamForwarder(host, port, 10000L);
            DataInputStream in = new DataInputStream(lsf.getInputStream());
            DataOutputStream out = new DataOutputStream(lsf.getOutputStream());
            out.writeUTF("Hello");
            out.flush();
            String reply = in.readUTF();
            System.out.println("Server says: " + reply);
            out.close();
            in.close();
            lsf.close();
        }
        catch (Exception e) {
            System.err.println("Eek: " + e);
            e.printStackTrace(System.err);
        }
    }
}

