/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.Array;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.beanutils.converters.BigIntegerConverter;
import org.apache.commons.beanutils.converters.BooleanArrayConverter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.ByteArrayConverter;
import org.apache.commons.beanutils.converters.ByteConverter;
import org.apache.commons.beanutils.converters.CharacterArrayConverter;
import org.apache.commons.beanutils.converters.CharacterConverter;
import org.apache.commons.beanutils.converters.ClassConverter;
import org.apache.commons.beanutils.converters.DoubleArrayConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FloatArrayConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.IntegerArrayConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongArrayConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.beanutils.converters.ShortArrayConverter;
import org.apache.commons.beanutils.converters.ShortConverter;
import org.apache.commons.beanutils.converters.SqlDateConverter;
import org.apache.commons.beanutils.converters.SqlTimeConverter;
import org.apache.commons.beanutils.converters.SqlTimestampConverter;
import org.apache.commons.beanutils.converters.StringArrayConverter;
import org.apache.commons.beanutils.converters.StringConverter;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConvertUtils {
    private static Boolean defaultBoolean = Boolean.FALSE;
    private static Byte defaultByte = new Byte(0);
    private static Character defaultCharacter = new Character(' ');
    private static Double defaultDouble = new Double(0.0);
    private static Float defaultFloat = new Float(0.0f);
    private static Integer defaultInteger = new Integer(0);
    private static Long defaultLong = new Long(0L);
    private static Short defaultShort = new Short(0);
    private static FastHashMap converters = new FastHashMap();
    private static Log log;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$org$apache$commons$beanutils$ConvertUtils;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public static boolean getDefaultBoolean() {
        return defaultBoolean;
    }

    public static void setDefaultBoolean(boolean newDefaultBoolean) {
        defaultBoolean = new Boolean(newDefaultBoolean);
        converters.put(Boolean.TYPE, new BooleanConverter(defaultBoolean));
        converters.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConvertUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean, new BooleanConverter(defaultBoolean));
    }

    public static byte getDefaultByte() {
        return defaultByte;
    }

    public static void setDefaultByte(byte newDefaultByte) {
        defaultByte = new Byte(newDefaultByte);
        converters.put(Byte.TYPE, new ByteConverter(defaultByte));
        converters.put(class$java$lang$Byte == null ? (class$java$lang$Byte = ConvertUtils.class$("java.lang.Byte")) : class$java$lang$Byte, new ByteConverter(defaultByte));
    }

    public static char getDefaultCharacter() {
        return defaultCharacter.charValue();
    }

    public static void setDefaultCharacter(char newDefaultCharacter) {
        defaultCharacter = new Character(newDefaultCharacter);
        converters.put(Character.TYPE, new CharacterConverter(defaultCharacter));
        converters.put(class$java$lang$Character == null ? (class$java$lang$Character = ConvertUtils.class$("java.lang.Character")) : class$java$lang$Character, new CharacterConverter(defaultCharacter));
    }

    public static double getDefaultDouble() {
        return defaultDouble;
    }

    public static void setDefaultDouble(double newDefaultDouble) {
        defaultDouble = new Double(newDefaultDouble);
        converters.put(Double.TYPE, new DoubleConverter(defaultDouble));
        converters.put(class$java$lang$Double == null ? (class$java$lang$Double = ConvertUtils.class$("java.lang.Double")) : class$java$lang$Double, new DoubleConverter(defaultDouble));
    }

    public static float getDefaultFloat() {
        return defaultFloat.floatValue();
    }

    public static void setDefaultFloat(float newDefaultFloat) {
        defaultFloat = new Float(newDefaultFloat);
        converters.put(Float.TYPE, new FloatConverter(defaultFloat));
        converters.put(class$java$lang$Float == null ? (class$java$lang$Float = ConvertUtils.class$("java.lang.Float")) : class$java$lang$Float, new FloatConverter(defaultFloat));
    }

    public static int getDefaultInteger() {
        return defaultInteger;
    }

    public static void setDefaultInteger(int newDefaultInteger) {
        defaultInteger = new Integer(newDefaultInteger);
        converters.put(Integer.TYPE, new IntegerConverter(defaultInteger));
        converters.put(class$java$lang$Integer == null ? (class$java$lang$Integer = ConvertUtils.class$("java.lang.Integer")) : class$java$lang$Integer, new IntegerConverter(defaultInteger));
    }

    public static long getDefaultLong() {
        return defaultLong;
    }

    public static void setDefaultLong(long newDefaultLong) {
        defaultLong = new Long(newDefaultLong);
        converters.put(Long.TYPE, new LongConverter(defaultLong));
        converters.put(class$java$lang$Long == null ? (class$java$lang$Long = ConvertUtils.class$("java.lang.Long")) : class$java$lang$Long, new LongConverter(defaultLong));
    }

    public static short getDefaultShort() {
        return defaultShort;
    }

    public static void setDefaultShort(short newDefaultShort) {
        defaultShort = new Short(newDefaultShort);
        converters.put(Short.TYPE, new ShortConverter(defaultShort));
        converters.put(class$java$lang$Short == null ? (class$java$lang$Short = ConvertUtils.class$("java.lang.Short")) : class$java$lang$Short, new ShortConverter(defaultShort));
    }

    public static String convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            if (Array.getLength(value) < 1) {
                return null;
            }
            if ((value = Array.get(value, 0)) == null) {
                return null;
            }
            return value.toString();
        }
        return value.toString();
    }

    public static Object convert(String value, Class clazz) {
        Converter converter;
        if (log.isDebugEnabled()) {
            log.debug("Convert string '" + value + "' to class '" + clazz.getName() + "'");
        }
        if ((converter = (Converter)converters.get(clazz)) == null) {
            converter = (Converter)converters.get(class$java$lang$String == null ? (class$java$lang$String = ConvertUtils.class$("java.lang.String")) : class$java$lang$String);
        }
        if (log.isTraceEnabled()) {
            log.trace("  Using converter " + converter);
        }
        return converter.convert(clazz, value);
    }

    public static Object convert(String[] values, Class clazz) {
        Converter converter;
        Class<?> type = clazz;
        if (clazz.isArray()) {
            type = clazz.getComponentType();
        }
        if (log.isDebugEnabled()) {
            log.debug("Convert String[" + values.length + "] to class '" + type.getName() + "[]'");
        }
        if ((converter = (Converter)converters.get(type)) == null) {
            converter = (Converter)converters.get(class$java$lang$String == null ? (class$java$lang$String = ConvertUtils.class$("java.lang.String")) : class$java$lang$String);
        }
        if (log.isTraceEnabled()) {
            log.trace("  Using converter " + converter);
        }
        Object array = Array.newInstance(type, values.length);
        int i = 0;
        while (i < values.length) {
            Array.set(array, i, converter.convert(type, values[i]));
            ++i;
        }
        return array;
    }

    public static void deregister() {
        boolean[] booleanArray = new boolean[]{};
        byte[] byteArray = new byte[]{};
        char[] charArray = new char[]{};
        double[] doubleArray = new double[]{};
        float[] floatArray = new float[]{};
        int[] intArray = new int[]{};
        long[] longArray = new long[]{};
        short[] shortArray = new short[]{};
        String[] stringArray = new String[]{};
        converters.clear();
        converters.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ConvertUtils.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new BigDecimalConverter());
        converters.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = ConvertUtils.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigIntegerConverter());
        converters.put(Boolean.TYPE, new BooleanConverter(defaultBoolean));
        converters.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConvertUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean, new BooleanConverter(defaultBoolean));
        converters.put(booleanArray.getClass(), new BooleanArrayConverter(booleanArray));
        converters.put(Byte.TYPE, new ByteConverter(defaultByte));
        converters.put(class$java$lang$Byte == null ? (class$java$lang$Byte = ConvertUtils.class$("java.lang.Byte")) : class$java$lang$Byte, new ByteConverter(defaultByte));
        converters.put(byteArray.getClass(), new ByteArrayConverter(byteArray));
        converters.put(Character.TYPE, new CharacterConverter(defaultCharacter));
        converters.put(class$java$lang$Character == null ? (class$java$lang$Character = ConvertUtils.class$("java.lang.Character")) : class$java$lang$Character, new CharacterConverter(defaultCharacter));
        converters.put(charArray.getClass(), new CharacterArrayConverter(charArray));
        converters.put(class$java$lang$Class == null ? (class$java$lang$Class = ConvertUtils.class$("java.lang.Class")) : class$java$lang$Class, new ClassConverter());
        converters.put(Double.TYPE, new DoubleConverter(defaultDouble));
        converters.put(class$java$lang$Double == null ? (class$java$lang$Double = ConvertUtils.class$("java.lang.Double")) : class$java$lang$Double, new DoubleConverter(defaultDouble));
        converters.put(doubleArray.getClass(), new DoubleArrayConverter(doubleArray));
        converters.put(Float.TYPE, new FloatConverter(defaultFloat));
        converters.put(class$java$lang$Float == null ? (class$java$lang$Float = ConvertUtils.class$("java.lang.Float")) : class$java$lang$Float, new FloatConverter(defaultFloat));
        converters.put(floatArray.getClass(), new FloatArrayConverter(floatArray));
        converters.put(Integer.TYPE, new IntegerConverter(defaultInteger));
        converters.put(class$java$lang$Integer == null ? (class$java$lang$Integer = ConvertUtils.class$("java.lang.Integer")) : class$java$lang$Integer, new IntegerConverter(defaultInteger));
        converters.put(intArray.getClass(), new IntegerArrayConverter(intArray));
        converters.put(Long.TYPE, new LongConverter(defaultLong));
        converters.put(class$java$lang$Long == null ? (class$java$lang$Long = ConvertUtils.class$("java.lang.Long")) : class$java$lang$Long, new LongConverter(defaultLong));
        converters.put(longArray.getClass(), new LongArrayConverter(longArray));
        converters.put(Short.TYPE, new ShortConverter(defaultShort));
        converters.put(class$java$lang$Short == null ? (class$java$lang$Short = ConvertUtils.class$("java.lang.Short")) : class$java$lang$Short, new ShortConverter(defaultShort));
        converters.put(shortArray.getClass(), new ShortArrayConverter(shortArray));
        converters.put(class$java$lang$String == null ? (class$java$lang$String = ConvertUtils.class$("java.lang.String")) : class$java$lang$String, new StringConverter());
        converters.put(stringArray.getClass(), new StringArrayConverter(stringArray));
        converters.put(class$java$sql$Date == null ? (class$java$sql$Date = ConvertUtils.class$("java.sql.Date")) : class$java$sql$Date, new SqlDateConverter());
        converters.put(class$java$sql$Time == null ? (class$java$sql$Time = ConvertUtils.class$("java.sql.Time")) : class$java$sql$Time, new SqlTimeConverter());
        converters.put(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = ConvertUtils.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, new SqlTimestampConverter());
    }

    public static void deregister(Class clazz) {
        converters.remove(clazz);
    }

    public static Converter lookup(Class clazz) {
        return (Converter)converters.get(clazz);
    }

    public static void register(Converter converter, Class clazz) {
        converters.put(clazz, converter);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        converters.setFast(false);
        ConvertUtils.deregister();
        converters.setFast(true);
        log = LogFactory.getLog(class$org$apache$commons$beanutils$ConvertUtils == null ? (class$org$apache$commons$beanutils$ConvertUtils = ConvertUtils.class$("org.apache.commons.beanutils.ConvertUtils")) : class$org$apache$commons$beanutils$ConvertUtils);
    }
}

