/*
 * Decompiled with CFR 0.152.
 */
package mx4j.server;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.WeakHashMap;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotificationBroadcaster;
import javax.management.loading.MLet;
import mx4j.MBeanDescription;
import mx4j.MBeanDescriptionAdapter;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.server.BCELMBeanInvoker;
import mx4j.server.CachingReflectionMBeanInvoker;
import mx4j.server.MBeanInvoker;
import mx4j.server.MBeanMetaData;
import mx4j.util.Utils;

public class MBeanIntrospector {
    private static final MBeanDescriptionAdapter DEFAULT_DESCRIPTION = new MBeanDescriptionAdapter();
    private static final MBeanConstructorInfo[] EMPTY_CONSTRUCTORS = new MBeanConstructorInfo[0];
    private static final MBeanParameterInfo[] EMPTY_PARAMETERS = new MBeanParameterInfo[0];
    private static final MBeanAttributeInfo[] EMPTY_ATTRIBUTES = new MBeanAttributeInfo[0];
    private static final MBeanNotificationInfo[] EMPTY_NOTIFICATIONS = new MBeanNotificationInfo[0];
    private static final MBeanOperationInfo[] EMPTY_OPERATIONS = new MBeanOperationInfo[0];
    private boolean extendedMBeanInterfaces = false;
    private boolean bcelAvailable = false;
    private String mbeanInvokerClass = null;
    private final WeakHashMap mbeanInfoCache = new WeakHashMap();
    private final WeakHashMap mbeanInvokerCache = new WeakHashMap();
    static /* synthetic */ Class class$javax$management$loading$MLet;

    public MBeanIntrospector() {
        String strict = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("mx4j.strict.mbean.interface");
            }
        });
        if (strict != null && !Boolean.valueOf(strict).booleanValue()) {
            this.extendedMBeanInterfaces = true;
        }
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            if (loader == null) {
                loader = Thread.currentThread().getContextClassLoader();
            }
            loader.loadClass("org.apache.bcelAvailable.generic.Type");
            this.bcelAvailable = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.mbeanInvokerClass = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("mx4j.mbean.invoker");
            }
        });
    }

    public void introspect(MBeanMetaData metadata) {
        this.introspectType(metadata);
        this.introspectMBeanInfo(metadata);
    }

    public boolean isMBeanCompliant(MBeanMetaData metadata) {
        return this.isMBeanClassCompliant(metadata) && this.isMBeanTypeCompliant(metadata) && this.isMBeanInfoCompliant(metadata);
    }

    private boolean testCompliance(MBeanMetaData metadata) {
        this.introspect(metadata);
        return this.isMBeanCompliant(metadata);
    }

    private boolean isMBeanClassCompliant(MBeanMetaData metadata) {
        Logger logger = this.getLogger();
        if (metadata.getMBeanInterface() != null) {
            boolean isPublic = Modifier.isPublic(metadata.getMBeanInterface().getModifiers());
            if (!isPublic && logger.isEnabledFor(10)) {
                logger.debug("MBean interface is not public");
            }
            return isPublic;
        }
        return true;
    }

    private boolean isMBeanTypeCompliant(MBeanMetaData metadata) {
        Logger logger = this.getLogger();
        if (metadata.isMBeanStandard() && metadata.isMBeanDynamic()) {
            if (logger.isEnabledFor(10)) {
                logger.debug("MBean is both standard and dynamic");
            }
            return false;
        }
        if (!metadata.isMBeanStandard() && !metadata.isMBeanDynamic()) {
            if (logger.isEnabledFor(10)) {
                logger.debug("MBean is not standard nor dynamic");
            }
            return false;
        }
        return true;
    }

    private boolean isMBeanInfoCompliant(MBeanMetaData metadata) {
        Logger logger = this.getLogger();
        if (metadata.getMBeanInfo() == null) {
            if (logger.isEnabledFor(10)) {
                logger.debug("MBeanInfo is null");
            }
            return false;
        }
        return true;
    }

    private void introspectType(MBeanMetaData metadata) {
        if (metadata.isMBeanStandard()) {
            this.introspectStandardMBean(metadata);
            return;
        }
        if (metadata.getMBean() instanceof DynamicMBean) {
            metadata.setMBeanDynamic(true);
            return;
        }
        metadata.setMBeanDynamic(false);
        this.introspectStandardMBean(metadata);
    }

    private void introspectStandardMBean(MBeanMetaData metadata) {
        Class<?> cls;
        Class management = metadata.getMBeanInterface();
        if (management != null) {
            if (management.isInstance(metadata.getMBean())) {
                metadata.setMBeanInvoker(this.createInvoker(metadata));
                return;
            }
            metadata.setMBeanStandard(false);
            metadata.setMBeanInterface(null);
            metadata.setMBeanInvoker(null);
            return;
        }
        for (Class<?> c = cls = metadata.getMBean().getClass(); c != null; c = c.getSuperclass()) {
            Class<?>[] intfs = c.getInterfaces();
            for (int i = 0; i < intfs.length; ++i) {
                Class<?> intf = intfs[i];
                if (!this.implementsMBean(c.getName(), intf.getName())) continue;
                metadata.setMBeanStandard(true);
                metadata.setMBeanInterface(intf);
                metadata.setMBeanInvoker(this.createInvoker(metadata));
                return;
            }
        }
        metadata.setMBeanStandard(false);
        metadata.setMBeanInterface(null);
        metadata.setMBeanInvoker(null);
    }

    private void introspectMBeanInfo(MBeanMetaData metadata) {
        if (metadata.isMBeanDynamic()) {
            metadata.setMBeanInfo(this.getDynamicMBeanInfo(metadata));
        } else if (metadata.isMBeanStandard()) {
            metadata.setMBeanInfo(this.createStandardMBeanInfo(metadata));
        } else {
            metadata.setMBeanInfo(null);
        }
    }

    private MBeanInfo getDynamicMBeanInfo(MBeanMetaData metadata) {
        MBeanInfo info;
        Logger logger;
        block5: {
            logger = this.getLogger();
            info = null;
            try {
                info = ((DynamicMBean)metadata.getMBean()).getMBeanInfo();
            }
            catch (Exception x) {
                if (!logger.isEnabledFor(10)) break block5;
                logger.debug("getMBeanInfo threw: " + x.toString());
            }
        }
        if (logger.isEnabledFor(0)) {
            logger.trace("Dynamic MBeanInfo is: " + info);
        }
        if (info == null) {
            if (logger.isEnabledFor(10)) {
                logger.debug("MBeanInfo cannot be null");
            }
            return null;
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MBeanInfo createStandardMBeanInfo(MBeanMetaData metadata) {
        WeakHashMap weakHashMap = this.mbeanInfoCache;
        synchronized (weakHashMap) {
            MBeanInfo info = (MBeanInfo)this.mbeanInfoCache.get(metadata.getMBean().getClass());
            if (info != null) {
                return info;
            }
        }
        MBeanDescription description = this.createMBeanDescription(metadata);
        MBeanConstructorInfo[] ctors = this.createMBeanConstructorInfo(metadata, description);
        if (ctors == null) {
            return null;
        }
        MBeanAttributeInfo[] attrs = this.createMBeanAttributeInfo(metadata, description);
        if (attrs == null) {
            return null;
        }
        MBeanOperationInfo[] opers = this.createMBeanOperationInfo(metadata, description);
        if (opers == null) {
            return null;
        }
        MBeanNotificationInfo[] notifs = this.createMBeanNotificationInfo(metadata);
        if (notifs == null) {
            return null;
        }
        MBeanInfo info = new MBeanInfo(metadata.getMBean().getClass().getName(), description.getMBeanDescription(), attrs, ctors, opers, notifs);
        WeakHashMap weakHashMap2 = this.mbeanInfoCache;
        synchronized (weakHashMap2) {
            this.mbeanInfoCache.put(metadata.getMBean().getClass(), info);
        }
        return info;
    }

    private MBeanDescription createMBeanDescription(MBeanMetaData metadata) {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.trace("Looking for standard MBean description...");
        }
        String descrClassName = metadata.getMBeanInterface().getName() + "Description";
        try {
            Object descrInstance;
            Class descrClass = null;
            ClassLoader loader = metadata.getClassLoader();
            if (loader == null) {
                loader = Thread.currentThread().getContextClassLoader();
            }
            if ((descrInstance = (descrClass = loader.getClass() == (class$javax$management$loading$MLet == null ? (class$javax$management$loading$MLet = MBeanIntrospector.class$("javax.management.loading.MLet")) : class$javax$management$loading$MLet) ? ((MLet)loader).loadClass(descrClassName, null) : loader.loadClass(descrClassName)).newInstance()) instanceof MBeanDescription) {
                MBeanDescription description = (MBeanDescription)descrInstance;
                if (logger.isEnabledFor(0)) {
                    logger.trace("Found provided standard MBean description: " + description);
                }
                return description;
            }
        }
        catch (ClassNotFoundException ignored) {
        }
        catch (InstantiationException ignored) {
        }
        catch (IllegalAccessException ignored) {
            // empty catch block
        }
        MBeanDescriptionAdapter description = DEFAULT_DESCRIPTION;
        if (logger.isEnabledFor(0)) {
            logger.trace("Cannot find standard MBean description, using default: " + description);
        }
        return description;
    }

    private MBeanOperationInfo[] createMBeanOperationInfo(MBeanMetaData metadata, MBeanDescription description) {
        ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>();
        Method[] methods = metadata.getMBeanInterface().getMethods();
        for (int j = 0; j < methods.length; ++j) {
            Method method = methods[j];
            if (Utils.isAttributeGetter(method) || Utils.isAttributeSetter(method)) continue;
            String descr = description == null ? null : description.getOperationDescription(method);
            Class<?>[] params = method.getParameterTypes();
            int paramsNumber = params.length;
            MBeanParameterInfo[] paramsInfo = paramsNumber == 0 ? EMPTY_PARAMETERS : new MBeanParameterInfo[paramsNumber];
            for (int k = 0; k < paramsNumber; ++k) {
                Class<?> param = params[k];
                String paramName = description == null ? null : description.getOperationParameterName(method, k);
                String paramDescr = description == null ? null : description.getOperationParameterDescription(method, k);
                paramsInfo[k] = new MBeanParameterInfo(paramName, param.getName(), paramDescr);
            }
            MBeanOperationInfo info = new MBeanOperationInfo(method.getName(), descr, paramsInfo, method.getReturnType().getName(), 3);
            operations.add(info);
        }
        int opersNumber = operations.size();
        return opersNumber == 0 ? EMPTY_OPERATIONS : operations.toArray(new MBeanOperationInfo[opersNumber]);
    }

    private MBeanAttributeInfo[] createMBeanAttributeInfo(MBeanMetaData metadata, MBeanDescription description) {
        Logger logger = this.getLogger();
        HashMap<String, MBeanAttributeInfo> attributes = new HashMap<String, MBeanAttributeInfo>();
        HashMap<String, Method> getterNames = new HashMap<String, Method>();
        Method[] methods = metadata.getMBeanInterface().getMethods();
        for (int j = 0; j < methods.length; ++j) {
            String name;
            Method method = methods[j];
            if (Utils.isAttributeGetter(method)) {
                name = method.getName();
                boolean isIs = name.startsWith("is");
                String attribute = null;
                attribute = isIs ? name.substring(2) : name.substring(3);
                String descr = description == null ? null : description.getAttributeDescription(attribute);
                MBeanAttributeInfo info = (MBeanAttributeInfo)attributes.get(attribute);
                if (info != null) {
                    if (!info.getType().equals(method.getReturnType().getName())) {
                        if (logger.isEnabledFor(10)) {
                            logger.debug("MBean is not compliant: has overloaded attribute " + attribute);
                        }
                        return null;
                    }
                    if (getterNames.get(name) != null) continue;
                    if (info.isReadable()) {
                        if (logger.isEnabledFor(10)) {
                            logger.debug("MBean is not compliant: has overloaded attribute " + attribute);
                        }
                        return null;
                    }
                    info = new MBeanAttributeInfo(attribute, info.getType(), info.getDescription(), true, info.isWritable(), isIs);
                } else {
                    info = new MBeanAttributeInfo(attribute, method.getReturnType().getName(), descr, true, false, isIs);
                }
                attributes.put(attribute, info);
                getterNames.put(name, method);
                continue;
            }
            if (!Utils.isAttributeSetter(method)) continue;
            name = method.getName();
            String attribute = name.substring(3);
            String descr = description == null ? null : description.getAttributeDescription(attribute);
            MBeanAttributeInfo info = (MBeanAttributeInfo)attributes.get(attribute);
            if (info != null) {
                if (!info.getType().equals(method.getParameterTypes()[0].getName())) {
                    if (logger.isEnabledFor(10)) {
                        logger.debug("MBean is not compliant: has overloaded attribute " + attribute);
                    }
                    return null;
                }
                info = new MBeanAttributeInfo(info.getName(), info.getType(), info.getDescription(), info.isReadable(), true, info.isIs());
            } else {
                info = new MBeanAttributeInfo(attribute, method.getParameterTypes()[0].getName(), descr, false, true, false);
            }
            attributes.put(attribute, info);
        }
        int size = attributes.size();
        return size == 0 ? EMPTY_ATTRIBUTES : attributes.values().toArray(new MBeanAttributeInfo[size]);
    }

    private MBeanNotificationInfo[] createMBeanNotificationInfo(MBeanMetaData metadata) {
        MBeanNotificationInfo[] notifs = null;
        Object mbean = metadata.getMBean();
        if (mbean instanceof NotificationBroadcaster) {
            notifs = ((NotificationBroadcaster)mbean).getNotificationInfo();
        }
        if (notifs == null || notifs.length == 0) {
            notifs = EMPTY_NOTIFICATIONS;
        }
        return notifs;
    }

    private MBeanConstructorInfo[] createMBeanConstructorInfo(MBeanMetaData metadata, MBeanDescription descrs) {
        Class<?> mbeanClass = metadata.getMBean().getClass();
        Constructor<?>[] ctors = mbeanClass.getConstructors();
        int ctorsNumber = ctors.length;
        MBeanConstructorInfo[] constructors = ctorsNumber == 0 ? EMPTY_CONSTRUCTORS : new MBeanConstructorInfo[ctorsNumber];
        for (int i = 0; i < ctorsNumber; ++i) {
            MBeanConstructorInfo info;
            Constructor<?> constructor = ctors[i];
            String descr = descrs == null ? null : descrs.getConstructorDescription(constructor);
            Class<?>[] params = constructor.getParameterTypes();
            int paramsNumber = params.length;
            MBeanParameterInfo[] paramsInfo = paramsNumber == 0 ? EMPTY_PARAMETERS : new MBeanParameterInfo[paramsNumber];
            for (int j = 0; j < paramsNumber; ++j) {
                Class<?> param = params[j];
                String paramName = descrs == null ? null : descrs.getConstructorParameterName(constructor, j);
                String paramDescr = descrs == null ? null : descrs.getConstructorParameterDescription(constructor, j);
                paramsInfo[j] = new MBeanParameterInfo(paramName, param.getName(), paramDescr);
            }
            String ctorName = constructor.getName();
            constructors[i] = info = new MBeanConstructorInfo(ctorName.substring(ctorName.lastIndexOf(46) + 1), descr, paramsInfo);
        }
        return constructors;
    }

    private boolean implementsMBean(String clsName, String intfName) {
        if (intfName.equals(clsName + "MBean")) {
            return true;
        }
        if (this.extendedMBeanInterfaces) {
            int intfDollar;
            int intfDot;
            int clsDot = clsName.lastIndexOf(46);
            if (clsDot > 0) {
                clsName = clsName.substring(clsDot + 1);
            }
            if ((intfDot = intfName.lastIndexOf(46)) > 0) {
                intfName = intfName.substring(intfDot + 1);
            }
            if (intfName.equals(clsName + "MBean")) {
                return true;
            }
            int clsDollar = clsName.lastIndexOf(36);
            if (clsDollar > 0) {
                clsName = clsName.substring(clsDollar + 1);
            }
            if ((intfDollar = intfName.lastIndexOf(36)) > 0) {
                intfName = intfName.substring(intfDollar + 1);
            }
            if (intfName.equals(clsName + "MBean")) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MBeanInvoker createInvoker(MBeanMetaData metadata) {
        Logger logger;
        MBeanInvoker invoker;
        block17: {
            invoker = null;
            WeakHashMap weakHashMap = this.mbeanInvokerCache;
            synchronized (weakHashMap) {
                invoker = (MBeanInvoker)this.mbeanInvokerCache.get(metadata.getMBeanInterface());
                if (invoker != null) {
                    return invoker;
                }
            }
            logger = this.getLogger();
            if (this.mbeanInvokerClass != null) {
                if (logger.isEnabledFor(0)) {
                    logger.trace("Custom MBeanInvoker class is: " + this.mbeanInvokerClass);
                }
                try {
                    invoker = (MBeanInvoker)Thread.currentThread().getContextClassLoader().loadClass(this.mbeanInvokerClass).newInstance();
                    if (logger.isEnabledFor(0)) {
                        logger.trace("Using custom MBeanInvoker: " + invoker);
                    }
                }
                catch (Exception x) {
                    if (!logger.isEnabledFor(10)) break block17;
                    logger.debug("Cannot instantiate custom MBeanInvoker, using default", x);
                }
            }
        }
        if (invoker == null) {
            if (this.bcelAvailable) {
                invoker = BCELMBeanInvoker.create(metadata);
                if (logger.isEnabledFor(0)) {
                    logger.trace("Using default BCEL MBeanInvoker for MBean " + metadata.getObjectName() + ", " + invoker);
                }
            } else {
                invoker = new CachingReflectionMBeanInvoker();
                if (logger.isEnabledFor(0)) {
                    logger.trace("Using default Reflection MBeanInvoker for MBean " + metadata.getObjectName() + ", " + invoker);
                }
            }
        }
        WeakHashMap weakHashMap = this.mbeanInvokerCache;
        synchronized (weakHashMap) {
            this.mbeanInvokerCache.put(metadata.getMBeanInterface(), invoker);
        }
        return invoker;
    }

    private Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

