/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.virtual.modules.reverse;

import ibis.smartsockets.virtual.VirtualSocket;
import ibis.smartsockets.virtual.modules.direct.DirectVirtualSocket;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.Map;

public class ReverseVirtualSocket
extends VirtualSocket {
    private final DirectVirtualSocket s;

    protected ReverseVirtualSocket(DirectVirtualSocket s) {
        this.s = s;
    }

    @Override
    protected void connectionAccepted(int timeout) throws IOException {
        int ack1 = -1;
        int ack2 = -1;
        try {
            this.s.setSoTimeout(timeout);
            this.s.setTcpNoDelay(true);
            OutputStream out = this.s.getOutputStream();
            InputStream in = this.s.getInputStream();
            out.write(1);
            out.write(1);
            out.flush();
            ack1 = in.read();
            ack2 = in.read();
            if (ack1 == -1 || ack2 == -1) {
                throw new EOFException("Reverse connection handshake failed:  Unexpected EOF");
            }
            if (ack1 != 1 || ack2 != 1) {
                throw new ConnectException("Client disconnected");
            }
            this.s.setSoTimeout(0);
            this.s.setTcpNoDelay(false);
        }
        catch (IOException e) {
            this.s.close();
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        this.s.close();
    }

    public void connectionRejected(int timeout, byte opcode) {
        this.s.connectionRejected(timeout, opcode);
    }

    @Override
    public void connectionRejected(int timeout) {
        this.s.connectionRejected(timeout);
    }

    public boolean equals(Object obj) {
        return this.s.equals(obj);
    }

    @Override
    public SocketChannel getChannel() {
        return this.s.getChannel();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.s.getInetAddress();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.s.getInputStream();
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.s.getKeepAlive();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.s.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.s.getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.s.getLocalSocketAddress();
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return this.s.getOOBInline();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.s.getOutputStream();
    }

    @Override
    public int getPort() {
        return this.s.getPort();
    }

    @Override
    public Object getProperty(String key) {
        return this.s.getProperty(key);
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.s.getReceiveBufferSize();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.s.getRemoteSocketAddress();
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.s.getReuseAddress();
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.s.getSendBufferSize();
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.s.getSoLinger();
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.s.getSoTimeout();
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.s.getTcpNoDelay();
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.s.getTrafficClass();
    }

    public int hashCode() {
        return this.s.hashCode();
    }

    @Override
    public boolean isBound() {
        return this.s.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.s.isClosed();
    }

    @Override
    public boolean isConnected() {
        return this.s.isConnected();
    }

    @Override
    public boolean isInputShutdown() {
        return this.s.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.s.isOutputShutdown();
    }

    @Override
    public Map<String, Object> properties() {
        return this.s.properties();
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        this.s.sendUrgentData(data);
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        this.s.setKeepAlive(on);
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        this.s.setOOBInline(on);
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.s.setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        this.s.setProperties(properties);
    }

    @Override
    public void setProperty(String key, Object val) {
        this.s.setProperty(key, val);
    }

    @Override
    public void setReceiveBufferSize(int sz) throws SocketException {
        this.s.setReceiveBufferSize(sz);
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.s.setReuseAddress(on);
    }

    @Override
    public void setSendBufferSize(int sz) throws SocketException {
        this.s.setSendBufferSize(sz);
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.s.setSoLinger(on, linger);
    }

    @Override
    public void setSoTimeout(int t) throws SocketException {
        this.s.setSoTimeout(t);
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.s.setTcpNoDelay(on);
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        this.s.setTrafficClass(tc);
    }

    @Override
    public void shutdownInput() throws IOException {
        this.s.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.s.shutdownOutput();
    }

    @Override
    public String toString() {
        return this.s.toString();
    }

    @Override
    public void waitForAccept(int timeout) throws IOException {
        this.s.waitForAccept(timeout);
    }
}

