/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.virtual.modules.hubrouted;

import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.hub.servicelink.VirtualConnectionCallBack;
import ibis.smartsockets.util.TypedProperties;
import ibis.smartsockets.virtual.NonFatalIOException;
import ibis.smartsockets.virtual.VirtualServerSocket;
import ibis.smartsockets.virtual.VirtualSocket;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import ibis.smartsockets.virtual.modules.ConnectModule;
import ibis.smartsockets.virtual.modules.hubrouted.HubRoutedVirtualSocket;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Hubrouted
extends ConnectModule
implements VirtualConnectionCallBack {
    private static final int DEFAULT_CONNECT_TIMEOUT = 5000;
    private final Map<Long, HubRoutedVirtualSocket> sockets = Collections.synchronizedMap(new HashMap());
    private int localFragmentation = 8176;
    private int localBufferSize = 0x100000;
    private int localMinimalACKSize = this.localBufferSize / 4;
    private int defaultConnectTimeout;

    public Hubrouted() {
        super("ConnectModule(HubRouted)", true);
    }

    @Override
    public void initModule(TypedProperties properties) throws Exception {
        int mod;
        this.localFragmentation = properties.getIntProperty("smartsockets.modules.hubrouted.size.fragment", this.localFragmentation);
        this.localBufferSize = properties.getIntProperty("smartsockets.modules.hubrouted.size.buffer", this.localBufferSize);
        this.defaultConnectTimeout = properties.getIntProperty("smartsockets.modules.hubrouted.connecttimeout", 5000);
        this.localMinimalACKSize = properties.getIntProperty("smartsockets.modules.hubrouted.size.ack", this.localBufferSize / 4);
        if (this.localFragmentation > this.localBufferSize) {
            this.logger.warn("Fragment size (" + this.localFragmentation + ") is larger than buffer size (" + this.localBufferSize + ") -> reducing fragment to: " + this.localBufferSize);
            this.localFragmentation = this.localBufferSize;
        } else if (this.localFragmentation < this.localBufferSize && (mod = this.localBufferSize % this.localFragmentation) != 0) {
            int div = this.localBufferSize / this.localFragmentation;
            this.localBufferSize = (div + 1) * this.localFragmentation;
        }
        if (this.localMinimalACKSize > this.localBufferSize) {
            this.logger.warn("Minimal ACK size (" + this.localMinimalACKSize + ") is larger than buffer size (" + this.localBufferSize + ") -> reducing minimal ACK size to: " + this.localBufferSize);
            this.localFragmentation = this.localBufferSize;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Using local fragment size: " + this.localFragmentation);
            this.logger.info("Using local buffer size  : " + this.localBufferSize);
            this.logger.info("Using minimal ACK size  : " + this.localMinimalACKSize);
        }
    }

    @Override
    public void startModule() throws Exception {
        if (this.serviceLink == null) {
            throw new Exception(this.module + ": no service link available!");
        }
        this.serviceLink.registerVCCallBack(this);
    }

    @Override
    public DirectSocketAddress getAddresses() {
        return null;
    }

    @Override
    public VirtualSocket connect(VirtualSocketAddress target, int timeout, Map<String, Object> properties) throws NonFatalIOException, IOException {
        DirectSocketAddress tm = target.machine();
        DirectSocketAddress hub = target.hub();
        if (timeout == 0) {
            timeout = this.defaultConnectTimeout;
        }
        long deadline = System.currentTimeMillis() + (long)timeout;
        int timeleft = timeout;
        HubRoutedVirtualSocket s = new HubRoutedVirtualSocket(this, this.localFragmentation, this.localBufferSize, this.localMinimalACKSize, target, this.serviceLink, null);
        while (true) {
            long index = this.serviceLink.getConnectionNumber();
            s.reset(index);
            this.sockets.put(index, s);
            try {
                this.serviceLink.createVirtualConnection(index, tm, hub, target.port(), this.localFragmentation, this.localBufferSize, timeleft);
            }
            catch (IOException e) {
                this.sockets.remove(index);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Failed to create virtual connection to " + target + " (unknown host -> will retry)!");
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                timeleft = (int)(deadline - System.currentTimeMillis());
                if (timeleft <= 0) {
                    throw new NonFatalIOException(new SocketTimeoutException("Failed to create virtual connection within " + timeout + " ms. (" + e + ")"));
                }
                index = -1L;
            }
            if (index == -1L) continue;
            int result = s.waitForACK(timeout);
            switch (result) {
                case 0: {
                    return s;
                }
                case 6: {
                    s.setTargetOverload();
                    return s;
                }
                case -1: {
                    throw new NonFatalIOException(new SocketTimeoutException("Failed to create virtual connection within " + timeout + " ms."));
                }
                case 4: {
                    throw new NonFatalIOException(new UnknownHostException("Failed to find host within " + timeout + " ms."));
                }
                case 2: {
                    throw new ConnectException("Remote port not found!");
                }
                case 3: {
                    throw new ConnectException("Connection refused by server!");
                }
                case 5: {
                    throw new NonFatalIOException("Attempting to connect to illegal target! (" + target + ")");
                }
            }
        }
    }

    @Override
    public boolean matchAdditionalRuntimeRequirements(Map<String, ?> requirements) {
        return true;
    }

    @Override
    public void connect(DirectSocketAddress src, DirectSocketAddress srcHub, int port, int remoteFragmentation, int remoteBufferSize, int timeout, long index) {
        VirtualServerSocket ss = this.parent.getServerSocket(port);
        if (ss == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Failed find VirtualServerSocket(" + port + ")");
            }
            this.serviceLink.nackVirtualConnection(index, (byte)2);
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Hubrouted got new connection: " + index);
        }
        VirtualSocketAddress sa = new VirtualSocketAddress(src, 0, srcHub, null);
        HubRoutedVirtualSocket s = new HubRoutedVirtualSocket(this, this.localFragmentation, this.localBufferSize, this.localMinimalACKSize, remoteFragmentation, remoteBufferSize, sa, this.serviceLink, index, null);
        this.sockets.put(index, s);
        int accept = ss.incomingConnection(s);
        if (accept != 0) {
            this.sockets.remove(index);
            if (accept == -1) {
                this.serviceLink.nackVirtualConnection(index, (byte)3);
            } else {
                this.serviceLink.nackVirtualConnection(index, (byte)6);
            }
        }
    }

    @Override
    public void disconnect(long vc) {
        HubRoutedVirtualSocket s = this.sockets.remove(vc);
        if (s == null) {
            return;
        }
        try {
            s.close(false);
        }
        catch (Exception e) {
            this.logger.warn("Failed to close socket!", (Throwable)e);
        }
    }

    public void close(long vc) {
        HubRoutedVirtualSocket s = this.sockets.remove(vc);
        if (s == null) {
            return;
        }
        try {
            this.serviceLink.closeVirtualConnection(vc);
        }
        catch (Exception e) {
            this.logger.warn("Failed to forward close for virtual socket: " + vc, (Throwable)e);
        }
    }

    @Override
    public void connectACK(long index, int fragment, int buffer) {
        HubRoutedVirtualSocket s = this.sockets.get(index);
        if (s == null) {
            this.serviceLink.ackAckVirtualConnection(index, false);
            return;
        }
        s.connectACK(fragment, buffer);
    }

    protected void sendAckAck(long index, boolean result) {
        this.serviceLink.ackAckVirtualConnection(index, result);
    }

    @Override
    public void connectNACK(long index, byte reason) {
        HubRoutedVirtualSocket s = this.sockets.remove(index);
        if (s != null) {
            s.connectNACK(reason);
        }
    }

    @Override
    public void connectACKACK(long index, boolean succes) {
        block4: {
            HubRoutedVirtualSocket s = this.sockets.get(index);
            boolean result = false;
            if (s != null) {
                result = s.connectACKACK(succes);
            }
            if (succes && !result) {
                try {
                    this.serviceLink.closeVirtualConnection(index);
                }
                catch (Exception e) {
                    if (!this.logger.isInfoEnabled()) break block4;
                    this.logger.info("Failed to process ACKACK for socket!: " + index, (Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean gotMessage(long index, int len, DataInputStream in) throws IOException {
        HubRoutedVirtualSocket s = this.sockets.get(index);
        if (s == null) {
            this.logger.warn("BAD!! Got message for already closed socket!: " + index + " size = " + len);
            return false;
        }
        s.message(len, in);
        return true;
    }

    @Override
    public void gotMessageACK(long index, int data) {
        HubRoutedVirtualSocket s = this.sockets.get(index);
        if (s == null) {
            return;
        }
        s.messageACK(data);
    }

    @Override
    public int getDefaultTimeout() {
        return this.defaultConnectTimeout;
    }
}

