/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.virtual.modules.direct;

import ibis.smartsockets.direct.DirectSocket;
import ibis.smartsockets.direct.DirectSocketFactory;
import ibis.smartsockets.util.CountingOutputStream;
import ibis.smartsockets.virtual.TargetOverloadedException;
import ibis.smartsockets.virtual.VirtualSocket;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.Map;

public class DirectVirtualSocket
extends VirtualSocket {
    protected final DirectSocket s;
    protected final OutputStream out;
    protected final InputStream in;
    protected final boolean count;

    protected DirectVirtualSocket(VirtualSocketAddress target, DirectSocket s, OutputStream out, InputStream in, boolean count, Map<String, ?> p) {
        super(target);
        this.s = s;
        this.count = count;
        if (count) {
            this.out = new CountingOutputStream(out);
            this.in = in;
        } else {
            this.out = out;
            this.in = in;
        }
    }

    @Override
    public long getBytesWritten() throws IOException {
        if (!this.count) {
            return -1L;
        }
        return ((CountingOutputStream)this.out).getBytesWritten();
    }

    @Override
    public long getBytesRead() throws IOException {
        return -1L;
    }

    @Override
    protected void connectionAccepted(int timeout) throws IOException {
        int ack = -1;
        try {
            this.s.setSoTimeout(timeout);
            this.s.setTcpNoDelay(true);
            this.out.write(1);
            this.out.flush();
            ack = this.in.read();
            if (ack == -1) {
                throw new EOFException("Unexpected EOF during handshake");
            }
            if (ack != 1) {
                throw new ConnectException("Client disconnected");
            }
            this.s.setTcpNoDelay(false);
            this.s.setSoTimeout(0);
        }
        catch (IOException e) {
            DirectSocketFactory.close(this.s, this.out, this.in);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionRejected(int timeout, byte opcode) {
        try {
            this.out.write(opcode);
            this.out.flush();
        }
        catch (Exception exception) {
        }
        finally {
            DirectSocketFactory.close(this.s, this.out, null);
        }
    }

    @Override
    public void connectionRejected(int timeout) {
        this.connectionRejected(timeout, (byte)4);
    }

    @Override
    public void waitForAccept(int timeout) throws IOException {
        try {
            this.s.setSoTimeout(timeout);
            this.s.setTcpNoDelay(true);
            int result = this.in.read();
            switch (result) {
                case 1: {
                    this.out.write(1);
                    this.out.flush();
                    this.s.setSoTimeout(0);
                    this.s.setTcpNoDelay(false);
                    return;
                }
                case 2: {
                    throw new SocketException("Remote port not found");
                }
                case 5: {
                    throw new TargetOverloadedException("Connection rejected (server overloaded)");
                }
                case 4: {
                    throw new SocketException("Connection rejected");
                }
                case -1: {
                    throw new EOFException("Unexpected EOF while waiting for accept");
                }
            }
            throw new SocketException("Got unknown reply (" + result + ") during connect!");
        }
        catch (IOException e) {
            DirectSocketFactory.close(this.s, this.out, this.in);
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        this.s.close();
    }

    @Override
    public SocketChannel getChannel() {
        return this.s.getChannel();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.out;
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.s.getReceiveBufferSize();
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.s.getReuseAddress();
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.s.getSendBufferSize();
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.s.getSoLinger();
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.s.getSoTimeout();
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.s.getTcpNoDelay();
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.s.getKeepAlive();
    }

    @Override
    public boolean isBound() {
        return true;
    }

    @Override
    public boolean isClosed() {
        return this.s.isClosed();
    }

    @Override
    public boolean isConnected() {
        return this.s.isConnected();
    }

    @Override
    public boolean isInputShutdown() {
        return this.s.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.s.isOutputShutdown();
    }

    @Override
    public void setReceiveBufferSize(int sz) throws SocketException {
        this.s.setReceiveBufferSize(sz);
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.s.setReuseAddress(on);
    }

    @Override
    public void setSendBufferSize(int sz) throws SocketException {
        this.s.setSendBufferSize(sz);
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.s.setSoLinger(on, linger);
    }

    @Override
    public void setSoTimeout(int t) throws SocketException {
        this.s.setSoTimeout(t);
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.s.setTcpNoDelay(on);
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        this.s.setKeepAlive(on);
    }

    @Override
    public void shutdownInput() throws IOException {
        this.s.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.s.shutdownOutput();
    }

    @Override
    public String toString() {
        return "DirectVirtualIbisSocket(" + this.s.toString() + ")";
    }
}

