/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.virtual;

import ibis.smartsockets.direct.IPAddressSet;
import ibis.smartsockets.virtual.VirtualSocket;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.ServerSocketChannel;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;

public class VirtualServerSocket {
    private final VirtualSocketFactory parent;
    private int port;
    private final LinkedList<VirtualSocket> incoming = new LinkedList();
    private int backlog;
    private final int defaultTimeout;
    private int timeout = 0;
    private boolean reuseAddress = true;
    private boolean closed = false;
    private VirtualSocketAddress localAddress;
    private Map<String, Object> properties;
    private boolean bound;
    private int receiveBufferSize = -1;

    protected VirtualServerSocket(VirtualSocketFactory parent, int defaultTimeout, Map<String, Object> p) {
        this.parent = parent;
        this.properties = p;
        this.bound = false;
        this.defaultTimeout = defaultTimeout;
    }

    protected VirtualServerSocket(VirtualSocketFactory parent, VirtualSocketAddress address, int port, int backlog, int defaultTimeout, Map<String, Object> p) {
        this.parent = parent;
        this.port = port;
        this.backlog = backlog;
        this.localAddress = address;
        this.properties = p;
        this.bound = true;
        this.defaultTimeout = defaultTimeout;
    }

    public synchronized int incomingConnection(VirtualSocket s) {
        if (VirtualSocketFactory.conlogger.isDebugEnabled()) {
            VirtualSocketFactory.conlogger.debug("Got connection " + s);
        }
        if (this.closed) {
            if (VirtualSocketFactory.conlogger.isDebugEnabled()) {
                VirtualSocketFactory.conlogger.debug("But the server socket was closed");
            }
            return -1;
        }
        if (this.incoming.size() < this.backlog) {
            this.incoming.addLast(s);
            this.notifyAll();
            return 0;
        }
        ListIterator itt = this.incoming.listIterator();
        while (itt.hasNext()) {
            VirtualSocket v = (VirtualSocket)itt.next();
            if (!v.isClosed()) continue;
            itt.remove();
        }
        if (this.incoming.size() < this.backlog) {
            this.incoming.addLast(s);
            this.notifyAll();
            return 0;
        }
        if (VirtualSocketFactory.conlogger.isInfoEnabled()) {
            VirtualSocketFactory.conlogger.info("Incoming connection on port " + this.port + " refused: QUEUE FULL (" + this.incoming.size() + ", " + System.currentTimeMillis() + ")");
        }
        return 1;
    }

    private synchronized VirtualSocket getConnection() throws SocketTimeoutException {
        while (this.incoming.size() == 0 && !this.closed) {
            try {
                this.wait(this.timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.timeout <= 0 || this.incoming.size() != 0 || this.closed) continue;
            throw new SocketTimeoutException("Time out during accept");
        }
        if (this.incoming.size() > 0) {
            return this.incoming.removeFirst();
        }
        return null;
    }

    public VirtualSocket accept() throws IOException {
        VirtualSocket result = null;
        while (result == null) {
            result = this.getConnection();
            if (VirtualSocketFactory.logger.isDebugEnabled()) {
                VirtualSocketFactory.logger.debug("VirtualServerPort got connection");
            }
            if (result == null) {
                if (VirtualSocketFactory.logger.isDebugEnabled()) {
                    VirtualSocketFactory.logger.debug("closed during accept");
                }
                throw new IOException("Socket closed during accept");
            }
            if (result.isClosed()) {
                if (VirtualSocketFactory.logger.isDebugEnabled()) {
                    VirtualSocketFactory.logger.debug("other side already closed");
                }
                result = null;
                continue;
            }
            try {
                int t = this.timeout;
                if (this.timeout <= 0) {
                    t = this.defaultTimeout;
                }
                if (VirtualSocketFactory.logger.isDebugEnabled()) {
                    VirtualSocketFactory.logger.debug("timeout = " + this.timeout);
                }
                result.connectionAccepted(t);
            }
            catch (IOException e) {
                if (VirtualSocketFactory.logger.isInfoEnabled()) {
                    VirtualSocketFactory.logger.info("VirtualServerPort( " + this.port + ") got exception during accept!", (Throwable)e);
                }
                result = null;
            }
        }
        result.setTcpNoDelay(true);
        return result;
    }

    public synchronized void close() throws IOException {
        this.closed = true;
        this.notifyAll();
        while (this.incoming.size() != 0) {
            this.incoming.removeFirst().connectionRejected(1000);
        }
        this.parent.closed(this.port);
    }

    public int getPort() {
        return this.port;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public ServerSocketChannel getChannel() {
        throw new RuntimeException("operation not implemented by " + this);
    }

    public IPAddressSet getIbisInetAddress() {
        throw new RuntimeException("operation not implemented by " + this);
    }

    public VirtualSocketAddress getLocalSocketAddress() {
        return this.localAddress;
    }

    public int getSoTimeout() throws IOException {
        return this.timeout;
    }

    public void setSoTimeout(int t) throws SocketException {
        if (VirtualSocketFactory.conlogger.isDebugEnabled()) {
            VirtualSocketFactory.conlogger.debug("setSoTimeout " + t, new Throwable());
        }
        this.timeout = t;
    }

    public boolean getReuseAddress() throws SocketException {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean v) throws SocketException {
        this.reuseAddress = v;
    }

    public String toString() {
        if (this.localAddress == null) {
            return "VirtualServerSocket(UNBOUND)";
        }
        return "VirtualServerSocket(" + this.localAddress.toString() + ")";
    }

    public Map<?, ?> properties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, Object val) {
        this.properties.put(key, val);
    }

    public boolean isBound() {
        return this.bound;
    }

    public void setReceiveBufferSize(int size) {
        this.receiveBufferSize = size;
    }

    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getLocalPort() {
        return this.port;
    }

    public InetAddress getInetAddress() {
        return null;
    }

    public void bind(SocketAddress endpoint, int backlog) throws IOException {
        if (!(endpoint instanceof VirtualSocketAddress)) {
            throw new IOException("Unsupported address type");
        }
        int tmp = ((VirtualSocketAddress)endpoint).port();
        this.parent.bindServerSocket(this, tmp);
        this.port = tmp;
        this.localAddress = (VirtualSocketAddress)endpoint;
    }
}

