/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.util.net;

import ibis.smartsockets.util.InetAddressCache;
import ibis.smartsockets.util.NetworkUtils;
import ibis.smartsockets.util.net.NetworkInfo;
import ibis.smartsockets.util.net.NetworkInfoParser;
import java.util.List;
import java.util.StringTokenizer;

public class LinuxNetworkInfoParser
extends NetworkInfoParser {
    private static final String[][] commands = new String[][]{{"ifconfig"}, {"/sbin/ifconfig"}, {"/bin/ifconfig"}};

    public LinuxNetworkInfoParser() {
        super("Linux");
    }

    @Override
    public boolean parse(byte[] output, List<NetworkInfo> info) {
        boolean result = false;
        StringBuffer tmp = new StringBuffer(new String(output));
        int start = 0;
        for (int i = 1; i < tmp.length(); ++i) {
            if (tmp.charAt(i) != '\n' || tmp.charAt(i - 1) != '\n') continue;
            result = this.parseBlock(tmp.substring(start, i), info) || result;
            start = i;
        }
        if (start < tmp.length() - 1) {
            result = this.parseBlock(tmp.substring(start, tmp.length()), info) || result;
        }
        return result;
    }

    private boolean parseBlock(String tmp, List<NetworkInfo> info) {
        StringTokenizer tokenizer = new StringTokenizer(tmp, "\n");
        NetworkInfo nw = new NetworkInfo();
        while (tokenizer.hasMoreTokens()) {
            String t;
            String mac;
            String line = tokenizer.nextToken().trim();
            int index = line.indexOf("HWaddr ");
            if (index > 0 && LinuxNetworkInfoParser.isMacAddress(mac = line.substring(index + 6).trim())) {
                nw.mac = NetworkUtils.MACStringToBytes(mac);
            }
            if ((t = LinuxNetworkInfoParser.getIPv4Field(line, "inet addr:")) != null) {
                try {
                    nw.ipv4 = InetAddressCache.getByName(t);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((t = LinuxNetworkInfoParser.getIPv4Field(line, "Bcast:")) != null) {
                nw.broadcast = LinuxNetworkInfoParser.ipStringToBytes(t);
            }
            if ((t = LinuxNetworkInfoParser.getIPv4Field(line, "Mask:")) != null) {
                nw.netmask = LinuxNetworkInfoParser.ipStringToBytes(t);
            }
            if ((t = LinuxNetworkInfoParser.getIPv6Field(line, "inet6 addr:")) == null) continue;
            try {
                nw.ipv6 = InetAddressCache.getByName(t);
            }
            catch (Exception exception) {}
        }
        info.add(nw);
        return true;
    }

    @Override
    String[] getCommand(int number) {
        return commands[number];
    }

    @Override
    int numberOfCommands() {
        return commands.length;
    }
}

