/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.util;

import ibis.smartsockets.util.InetAddressCache;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Random;
import java.util.StringTokenizer;
import net.sbbi.upnp.Discovery;
import net.sbbi.upnp.devices.UPNPDevice;
import net.sbbi.upnp.devices.UPNPRootDevice;
import net.sbbi.upnp.messages.ActionMessage;
import net.sbbi.upnp.messages.ActionResponse;
import net.sbbi.upnp.messages.UPNPMessageFactory;
import net.sbbi.upnp.messages.UPNPResponseException;
import net.sbbi.upnp.services.UPNPService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UPNP {
    private static Logger logger = LoggerFactory.getLogger((String)UPNP.class.getName());
    private static final String GATEWAY_DEVICE_URN = "urn:schemas-upnp-org:device:InternetGatewayDevice:1";
    private static final String WAN_CONNECTION_DEVICE_URN = "urn:schemas-upnp-org:device:WANConnectionDevice:1";
    private static final String WAN_CONNECTION_URN = "urn:schemas-upnp-org:service:WANIPConnection:1";
    private static final String LAN_DEVICE_URN = "urn:schemas-upnp-org:device:LANDevice:1";
    private static final String LAN_CONFIG_URN = "urn:schemas-upnp-org:service:LANHostConfigManagement:1";
    private static final int MAX_MAPPING_TRIES = 4;
    private static final int DISCOVERY_TIMEOUT = 1500;
    private static UPNPRootDevice root;
    private static UPNPDevice wanConnection;
    private static UPNPService wanConnectionService;
    private static UPNPDevice lan;
    private static UPNPService lanConfigService;
    private static Random random;

    private static boolean getRootDevice() {
        block8: {
            if (root == null) {
                try {
                    UPNPRootDevice[] devices = Discovery.discover(1500, GATEWAY_DEVICE_URN);
                    if (devices != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Found " + devices.length + " UPNP device(s).");
                        }
                        if (devices.length > 0) {
                            root = devices[0];
                        }
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("No UPNP devices found");
                    }
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block8;
                    logger.debug("No UPNP devices found");
                }
            }
        }
        return root != null;
    }

    private static boolean getWANConnectionDevice() {
        if (!UPNP.getRootDevice()) {
            return false;
        }
        if (wanConnection == null) {
            wanConnection = root.getChildDevice(WAN_CONNECTION_DEVICE_URN);
        }
        return wanConnection != null;
    }

    private static boolean getWANConnectionService() {
        if (!UPNP.getWANConnectionDevice()) {
            return false;
        }
        if (wanConnectionService == null) {
            wanConnectionService = wanConnection.getService(WAN_CONNECTION_URN);
        }
        return wanConnectionService != null;
    }

    private static boolean getLANDevice() {
        if (!UPNP.getRootDevice()) {
            return false;
        }
        if (lan == null) {
            lan = root.getChildDevice(LAN_DEVICE_URN);
        }
        return lan != null;
    }

    private static boolean getLANConfigService() {
        if (!UPNP.getLANDevice()) {
            return false;
        }
        if (lanConfigService == null) {
            lanConfigService = lan.getService(LAN_CONFIG_URN);
        }
        return lanConfigService != null;
    }

    private static String simpleStringInvocation(UPNPService service, String name) {
        UPNPMessageFactory factory = UPNPMessageFactory.getNewInstance(service);
        ActionMessage action = factory.getMessage("Get" + name);
        if (action != null) {
            try {
                ActionResponse r = action.service();
                return r.getOutActionArgumentValue("New" + name);
            }
            catch (Exception e) {
                System.out.println("Failed to perform invocation " + e);
            }
        } else {
            System.out.println("Action \"Get" + name + "\" not found");
        }
        return null;
    }

    public static InetAddress getExternalAddress() {
        if (!UPNP.getWANConnectionService()) {
            return null;
        }
        String tmp = UPNP.simpleStringInvocation(wanConnectionService, "ExternalIPAddress");
        try {
            return InetAddressCache.getByName(tmp);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static byte[] getSubnetMask() {
        if (!UPNP.getLANConfigService()) {
            return null;
        }
        String tmp = UPNP.simpleStringInvocation(lanConfigService, "SubnetMask");
        StringTokenizer tok = new StringTokenizer(tmp, ".");
        int tokens = tok.countTokens();
        if (tokens != 4 && tokens != 16) {
            return null;
        }
        byte[] result = new byte[tok.countTokens()];
        for (int i = 0; i < tokens; ++i) {
            result[i] = (byte)Integer.parseInt(tok.nextToken());
        }
        return result;
    }

    public static String getDomainName() {
        if (!UPNP.getLANConfigService()) {
            return null;
        }
        return UPNP.simpleStringInvocation(lanConfigService, "DomainName");
    }

    public static InetAddress[] getAddressRange() {
        if (!UPNP.getLANConfigService()) {
            return null;
        }
        UPNPMessageFactory factory = UPNPMessageFactory.getNewInstance(lanConfigService);
        ActionMessage action = factory.getMessage("GetAddressRange");
        if (action != null) {
            try {
                ActionResponse r = action.service();
                String min = r.getOutActionArgumentValue("NewMinAddress");
                String max = r.getOutActionArgumentValue("NewMaxAddress");
                InetAddress[] result = new InetAddress[]{InetAddressCache.getByName(min), InetAddressCache.getByName(max)};
                return result;
            }
            catch (Exception e) {
                System.out.println("Failed to perform invocation " + e);
            }
        } else {
            System.out.println("Action \"GetAddressRange\" not found");
        }
        return null;
    }

    private static boolean checkProtocol(String protocol) {
        return protocol != null && (protocol.equalsIgnoreCase("TCP") || protocol.equalsIgnoreCase("UDP"));
    }

    private static boolean checkPortRange(int port) {
        return port >= 1 || port <= 65535;
    }

    private static int performMapping(UPNPMessageFactory factory, int internalPort, int externalPort, String internalClient, int leaseDuration, String protocol) {
        ActionMessage action = factory.getMessage("AddPortMapping");
        if (action == null) {
            logger.warn("UPNP action \"AddPortMapping\" not found");
            return 1;
        }
        action.setInputParameter("NewRemoteHost", "");
        action.setInputParameter("NewExternalPort", externalPort);
        action.setInputParameter("NewInternalPort", internalPort);
        action.setInputParameter("NewInternalClient", internalClient);
        action.setInputParameter("NewProtocol", protocol);
        action.setInputParameter("NewEnabled", "1");
        action.setInputParameter("NewPortMappingDescription", "SmartNet");
        action.setInputParameter("NewLeaseDuration", leaseDuration);
        try {
            action.service();
            return 0;
        }
        catch (UPNPResponseException e) {
            return e.getDetailErrorCode();
        }
        catch (Exception e) {
            System.err.println("UPNP port fw exeception: " + e);
            e.printStackTrace(System.err);
            return 1;
        }
    }

    private static int getRandomPort() {
        return 1 + random.nextInt(65535);
    }

    public static int addPortMapping(int internalPort, int externalPort, String internalClient, int leaseDuration, String protocol) throws IOException {
        int result;
        UPNPMessageFactory factory;
        if (internalClient == null || internalClient.length() == 0) {
            logger.warn("Internal client not defined: " + internalClient);
            throw new IllegalArgumentException("Internal client not defined: " + internalClient);
        }
        if (externalPort != 0 && !UPNP.checkPortRange(externalPort)) {
            logger.warn("External port out of range: " + externalPort);
            throw new IllegalArgumentException("External port out of range: " + externalPort);
        }
        if (!UPNP.checkPortRange(internalPort)) {
            logger.warn("Internal port out of range: " + internalPort);
            throw new IllegalArgumentException("Internal port out of range: " + internalPort);
        }
        if (!UPNP.checkProtocol(protocol)) {
            logger.warn("Unsupported protocol: " + protocol);
            throw new IllegalArgumentException("Unsupported protocol");
        }
        if (leaseDuration < 0) {
            logger.warn("Invalid lease duration: " + leaseDuration);
            throw new IllegalArgumentException("Invalid lease duration: " + leaseDuration);
        }
        if (!UPNP.getWANConnectionDevice()) {
            logger.warn("Failed to contact WAN device");
            throw new IOException("Failed to connect to WAN device");
        }
        boolean anyExternal = false;
        if (externalPort == 0) {
            anyExternal = true;
            externalPort = internalPort;
        }
        if ((factory = UPNPMessageFactory.getNewInstance(wanConnectionService)) == null) {
            throw new IOException("Failed to create UPNPMessageFactory");
        }
        int loop = 0;
        block6: while (true) {
            if (loop++ > 4) {
                logger.warn("Port mapping did not succeed in 4 tries.");
                throw new IOException("Port mapping did not succeed in 4 tries.");
            }
            result = UPNP.performMapping(factory, internalPort, externalPort, internalClient, leaseDuration, protocol);
            switch (result) {
                case 0: {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Port forwarding activated from external port " + externalPort + " to " + internalClient + ":" + internalPort);
                    }
                    return externalPort;
                }
                case 718: {
                    if (!anyExternal) {
                        throw new BindException("External port already in use");
                    }
                    externalPort = UPNP.getRandomPort();
                    continue block6;
                }
                case 724: {
                    throw new BindException("NAT box can only use port " + internalClient + " which is already in use");
                }
                case 725: {
                    if (leaseDuration == 0) {
                        logger.warn("Got unexpected reply from NAT box");
                        throw new IOException("Got unexpected reply from NAT box");
                    }
                    leaseDuration = 0;
                    continue block6;
                }
            }
            break;
        }
        logger.warn("Port forwarding failed with error: " + result);
        throw new IOException("Port forwarding failed with error: " + result);
    }

    public static boolean deletePortMapping(int externalPort, String protocol) {
        if (!UPNP.checkPortRange(externalPort)) {
            logger.warn("External port out of range: " + externalPort);
            throw new IllegalArgumentException("External port out of range: " + externalPort);
        }
        if (!UPNP.checkProtocol(protocol)) {
            logger.warn("Unsupported protocol: " + protocol);
            throw new IllegalArgumentException("Unsupported protocol: " + protocol);
        }
        if (!UPNP.getWANConnectionDevice()) {
            logger.warn("Failed to contact WAN device");
            return false;
        }
        UPNPMessageFactory factory = UPNPMessageFactory.getNewInstance(wanConnectionService);
        ActionMessage action = factory.getMessage("DeletePortMapping");
        if (action != null) {
            action.setInputParameter("NewRemoteHost", "");
            action.setInputParameter("NewExternalPort", externalPort);
            action.setInputParameter("NewProtocol", protocol);
            try {
                action.service();
                return true;
            }
            catch (Exception e) {
                logger.warn("Failed to perform UPNP invocation " + e);
                System.out.println("Failed to perform UPNP invocation " + e);
            }
        } else {
            logger.warn("UPNP action \"DeletePortMapping\" not found");
            System.out.println("UPNP action \"DeletePortMapping\" not found");
        }
        return false;
    }

    static {
        random = new Random();
    }
}

