/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.util;

import de.javawi.jstun.test.DiscoveryInfo;
import de.javawi.jstun.test.DiscoveryTest;
import ibis.smartsockets.util.NetworkUtils;
import ibis.smartsockets.util.ThreadPool;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class STUN {
    private static Logger logger = LoggerFactory.getLogger((String)STUN.class.getName());
    private static String[] DEFAULT_SERVERS = new String[]{"stun.voipbuster.com", "stun.fwd.org", "iphone-stun.freenet.de", "stun.xten.net", "stun.fwdnet.net"};
    private static InetAddress external;

    /*
     * Unable to fully structure code
     */
    private static void getExternalAddress(String server, int timeout) {
        if (STUN.logger.isInfoEnabled()) {
            STUN.logger.info("Trying to determine external address using STUN server:" + server);
        }
        addresses = NetworkUtils.getAllHostAddresses();
        tmp = new Discovery[addresses.length];
        if (STUN.logger.isInfoEnabled()) {
            STUN.logger.info("Network addresses available: " + addresses.length);
        }
        wait = 25;
        count = 0;
        port = 3478;
        for (i = 0; i < addresses.length; ++i) {
            if (addresses[i].isLoopbackAddress()) continue;
            ++count;
            tmp[i] = new Discovery(addresses[i], port + i, server);
            ThreadPool.createNew(tmp[i], "STUN " + addresses[i]);
        }
        end = System.currentTimeMillis() + (long)timeout;
        while (true) {
            for (i = 0; i < tmp.length; ++i) {
                if (tmp[i] == null || !tmp[i].done()) continue;
                info = tmp[i].getResult();
                tmp[i] = null;
                --count;
                if (info == null) {
                    if (!STUN.logger.isInfoEnabled()) continue;
                    STUN.logger.info("STUN failed for " + addresses[i]);
                    continue;
                }
                if (STUN.logger.isInfoEnabled()) {
                    STUN.logger.info("STUN result for " + addresses[i] + ":\n" + info);
                }
                STUN.external = info.isOpenAccess() != false ? addresses[i] : info.getPublicIP();
                if (STUN.logger.isInfoEnabled()) {
                    STUN.logger.info("Found external address: " + STUN.external + " using server " + server);
                }
                return;
            }
            if (count == 0) {
                return;
            }
            if (timeout > 0 && System.currentTimeMillis() > end) {
                return;
            }
            try {
                Thread.sleep(wait);
            }
            catch (Exception var9_10) {
                // empty catch block
            }
            if (wait >= 1000) ** continue;
            wait *= 2;
        }
    }

    public static InetAddress getExternalAddress(String[] servers, int timeout) {
        if (external != null) {
            return external;
        }
        if (servers == null || servers.length == 0) {
            servers = DEFAULT_SERVERS;
        }
        for (int i = 0; i < servers.length; ++i) {
            STUN.getExternalAddress(servers[i], 0);
            if (external != null) break;
        }
        return external;
    }

    public static InetAddress getExternalAddress(int timeout) {
        return STUN.getExternalAddress((String[])null, timeout);
    }

    public static InetAddress getExternalAddress(String[] servers) {
        return STUN.getExternalAddress(servers, 0);
    }

    public static InetAddress getExternalAddress() {
        return STUN.getExternalAddress((String[])null, 0);
    }

    public static void main(String[] args) {
        System.out.println("Attempting to retrieve external address....");
        long start = System.currentTimeMillis();
        InetAddress ad = STUN.getExternalAddress();
        long end = System.currentTimeMillis();
        System.out.println("Got address " + NetworkUtils.ipToString(ad) + " after " + (end - start) + " ms.");
    }

    static class Discovery
    implements Runnable {
        private final InetAddress iaddress;
        private final int port;
        private final String server;
        private boolean done = false;
        private DiscoveryInfo result;

        public Discovery(InetAddress iaddress, int port, String server) {
            this.iaddress = iaddress;
            this.port = port;
            this.server = server;
        }

        public synchronized DiscoveryInfo getResult() {
            while (!this.done) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.result;
        }

        public synchronized boolean done() {
            return this.done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (logger.isInfoEnabled()) {
                    logger.info("STUN discovery initiated on: " + this.iaddress + ":" + this.port);
                }
                DiscoveryTest test = new DiscoveryTest(this.iaddress, this.port, this.server, 3478);
                Discovery discovery = this;
                synchronized (discovery) {
                    this.result = test.test();
                    if (logger.isInfoEnabled()) {
                        logger.info("STUN discovery done on: " + this.iaddress + ":" + this.port + "\n" + this.result);
                    }
                    this.done = true;
                    this.notifyAll();
                }
            }
            catch (Exception e) {
                logger.warn("STUN discovery on " + this.iaddress + " failed!", (Throwable)e);
            }
        }
    }
}

