/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.plugin;

import ibis.smartsockets.virtual.VirtualSocketAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;

public class SmartSocketAddress {
    public static SocketAddress create(String hostport, boolean smart) throws UnknownHostException {
        if (!smart) {
            int index = hostport.indexOf(58);
            if (index == -1) {
                throw new IllegalArgumentException("String does not contain a InetSocketAddress!");
            }
            try {
                int port = Integer.parseInt(hostport.substring(index + 1));
                return new InetSocketAddress(hostport.substring(0, index), port);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("String does not contain a InetSocketAddress! - cannot parse port!", e);
            }
        }
        return new VirtualSocketAddress(hostport);
    }

    public static SocketAddress create(String host, int port, boolean smart) throws UnknownHostException {
        if (!smart) {
            return new InetSocketAddress(host, port);
        }
        return new VirtualSocketAddress(host, port);
    }
}

