/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.hub.servicelink;

import ibis.smartsockets.direct.DirectSocketAddress;

public class HubInfo {
    public final DirectSocketAddress hubAddress;
    public final String name;
    public final long state;
    public final int clients;
    public final String vizInfo;
    public final DirectSocketAddress[] connectedTo;
    public final boolean[] usingSSH;

    public HubInfo(String info) {
        if (!info.startsWith("HubInfo(") || !info.endsWith(")")) {
            throw new IllegalArgumentException("String does not contain HubInfo!");
        }
        try {
            String[] strings = info.substring(8, info.length() - 1).split(",");
            this.hubAddress = DirectSocketAddress.getByAddress(strings[0]);
            this.name = strings[1];
            this.vizInfo = strings[2];
            this.state = Long.parseLong(strings[3]);
            this.clients = Integer.parseInt(strings[4]);
            int tmp = Integer.parseInt(strings[5]);
            this.connectedTo = new DirectSocketAddress[tmp];
            this.usingSSH = new boolean[tmp];
            for (int i = 0; i < this.connectedTo.length; ++i) {
                String address = strings[6 + i];
                if (address.endsWith(" (SSH)")) {
                    address = address.substring(0, address.length() - 6);
                    this.usingSSH[i] = true;
                } else {
                    this.usingSSH[i] = false;
                }
                this.connectedTo[i] = DirectSocketAddress.getByAddress(address);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("String does not contain HubInfo: \"" + info + "\"", e);
        }
    }
}

