/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.hub.servicelink;

import ibis.smartsockets.hub.servicelink.TimeOutException;

public class Credits {
    private final int MAX_CREDITS;
    private int credits;

    Credits(int max) {
        this.MAX_CREDITS = max;
        this.credits = max;
    }

    public void getCredit() {
        try {
            this.getCredit(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void getCredit(int time) throws TimeOutException {
        if (this.credits > 0) {
            --this.credits;
            return;
        }
        if (time < 0) {
            time = 0;
        }
        long endTime = 0L;
        long timeLeft = time;
        if (time > 0) {
            endTime = System.currentTimeMillis() + (long)time;
        }
        while (this.credits == 0) {
            try {
                this.wait(timeLeft);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.credits != 0 || time <= 0 || (timeLeft = endTime - System.currentTimeMillis()) > 0L) continue;
            throw new TimeOutException("Time limit " + time + " exceeded!");
        }
        --this.credits;
    }

    public synchronized void addCredit() {
        if (this.credits == 0) {
            this.notifyAll();
        }
        ++this.credits;
        if (this.credits > this.MAX_CREDITS) {
            System.err.println("EEK: credits exceeded " + this.MAX_CREDITS + "!");
        }
    }
}

