/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.hub.connections;

import ibis.smartsockets.direct.DirectSocket;
import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.direct.DirectSocketFactory;
import ibis.smartsockets.hub.Connections;
import ibis.smartsockets.hub.StatisticsCallback;
import ibis.smartsockets.hub.connections.MessageForwardingConnection;
import ibis.smartsockets.hub.connections.VirtualConnections;
import ibis.smartsockets.hub.state.AddressAsStringSelector;
import ibis.smartsockets.hub.state.ClientsByTagAsStringSelector;
import ibis.smartsockets.hub.state.DetailsSelector;
import ibis.smartsockets.hub.state.DirectionsAsStringSelector;
import ibis.smartsockets.hub.state.HubDescription;
import ibis.smartsockets.hub.state.HubList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConnection
extends MessageForwardingConnection {
    private static Logger conlogger = LoggerFactory.getLogger((String)"ibis.smartsockets.hub.connections.client");
    private static Logger reqlogger = LoggerFactory.getLogger((String)"ibis.smartsockets.hub.request");
    private static Logger reglogger = LoggerFactory.getLogger((String)"ibis.smartsockets.hub.registration");
    private final DirectSocketAddress clientAddress;
    private final String clientAddressAsString;
    private final String uniquePrefix;

    public ClientConnection(DirectSocketAddress clientAddress, DirectSocket s, DataInputStream in, DataOutputStream out, Connections connections, HubList hubs, VirtualConnections vcs, StatisticsCallback callback, long statisticsInterval) {
        super(s, in, out, connections, hubs, vcs, false, "Client(" + clientAddress.toString() + ")", callback, statisticsInterval);
        this.clientAddress = clientAddress;
        this.clientAddressAsString = clientAddress.toString();
        this.uniquePrefix = this.clientAddressAsString + "__";
        if (conlogger.isDebugEnabled()) {
            conlogger.debug("Created client connection: " + clientAddress);
        }
    }

    @Override
    protected String getUniqueID(long index) {
        return this.uniquePrefix + index;
    }

    @Override
    protected void handleDisconnect(Exception e) {
        if (this.knownHubs.getLocalDescription().removeClient(this.clientAddress)) {
            if (conlogger.isDebugEnabled()) {
                conlogger.debug("Removed client connection " + this.clientAddress);
            }
        } else if (conlogger.isDebugEnabled()) {
            conlogger.debug("Failed to removed client connection " + this.clientAddress + "!");
        }
        this.connections.removeClient(this.clientAddress);
        DirectSocketFactory.close(this.s, (OutputStream)this.out, (InputStream)this.in);
        this.closeAllVirtualConnections(this.uniquePrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleListHubs() throws IOException {
        int id = this.in.readInt();
        if (reqlogger.isDebugEnabled()) {
            reqlogger.debug("Connection " + this.clientAddress + " return id: " + id);
        }
        AddressAsStringSelector as = new AddressAsStringSelector();
        this.knownHubs.select(as);
        LinkedList<String> result = as.getResult();
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(49);
            this.out.writeInt(id);
            this.out.writeInt(result.size());
            for (String s : result) {
                this.out.writeUTF(s);
            }
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleListHubDetails() throws IOException {
        int id = this.in.readInt();
        if (reqlogger.isDebugEnabled()) {
            reqlogger.debug("Connection " + this.clientAddress + " return id: " + id);
        }
        DetailsSelector as = new DetailsSelector();
        this.knownHubs.select(as);
        LinkedList<String> result = as.getResult();
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(49);
            this.out.writeInt(id);
            this.out.writeInt(result.size());
            if (reqlogger.isDebugEnabled()) {
                reqlogger.debug("Connection " + this.clientAddress + " result: " + result.size() + " " + result);
            }
            for (String s : result) {
                this.out.writeUTF(s);
            }
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleListClientsForHub() throws IOException {
        int id = this.in.readInt();
        String hub = this.in.readUTF();
        String tag = this.in.readUTF();
        if (reqlogger.isDebugEnabled()) {
            reqlogger.debug("Connection " + this.clientAddress + " return id: " + id);
        }
        LinkedList<String> result = new LinkedList<String>();
        try {
            HubDescription d = this.knownHubs.get(DirectSocketAddress.getByAddress(hub));
            d.getClientsAsString(result, tag);
        }
        catch (UnknownHostException e) {
            reqlogger.warn("Connection " + this.clientAddress + " got illegal hub address: " + hub);
        }
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(49);
            this.out.writeInt(id);
            this.out.writeInt(result.size());
            for (String s : result) {
                this.out.writeUTF(s);
            }
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleListClients() throws IOException {
        int id = this.in.readInt();
        String tag = this.in.readUTF();
        if (reqlogger.isDebugEnabled()) {
            reqlogger.debug("Connection " + this.clientAddress + " return id: " + id);
        }
        ClientsByTagAsStringSelector css = new ClientsByTagAsStringSelector(tag);
        this.knownHubs.select(css);
        LinkedList<String> result = css.getResult();
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(49);
            this.out.writeInt(id);
            this.out.writeInt(result.size());
            if (reqlogger.isDebugEnabled()) {
                reqlogger.debug("Connection " + this.clientAddress + " returning : " + result.size() + " clients: " + result);
            }
            for (String s : result) {
                this.out.writeUTF(s);
            }
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGetDirectionsToClient() throws IOException {
        int id = this.in.readInt();
        String client = this.in.readUTF();
        if (reqlogger.isDebugEnabled()) {
            reqlogger.debug("Connection " + this.clientAddress + " return id: " + id);
        }
        DirectionsAsStringSelector ds = new DirectionsAsStringSelector(DirectSocketAddress.getByAddress(client));
        this.knownHubs.select(ds);
        LinkedList<String> result = ds.getResult();
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(49);
            this.out.writeInt(id);
            this.out.writeInt(result.size());
            if (reqlogger.isDebugEnabled()) {
                reqlogger.debug("Connection " + this.clientAddress + " returning : " + result.size() + " possible directions: " + result);
            }
            for (String tmp : result) {
                this.out.writeUTF(tmp);
            }
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerProperty() throws IOException {
        int id = this.in.readInt();
        String tag = this.in.readUTF();
        String info = this.in.readUTF();
        if (reglogger.isDebugEnabled()) {
            reglogger.debug("Connection " + this.clientAddress + " return id: " + id + " adding info: " + tag + " " + info);
        }
        HubDescription localHub = this.knownHubs.getLocalDescription();
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(33);
            this.out.writeInt(id);
            if (localHub.addService(this.clientAddress, tag, info)) {
                this.out.writeInt(34);
            } else {
                this.out.writeInt(35);
            }
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProperty() throws IOException {
        int id = this.in.readInt();
        String tag = this.in.readUTF();
        String info = this.in.readUTF();
        if (reglogger.isDebugEnabled()) {
            reglogger.debug("Connection " + this.clientAddress + " return id: " + id + " updating info: " + tag + " " + info);
        }
        HubDescription localHub = this.knownHubs.getLocalDescription();
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(33);
            this.out.writeInt(id);
            if (localHub.updateService(this.clientAddress, tag, info)) {
                this.out.writeInt(34);
            } else {
                this.out.writeInt(35);
            }
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRemoveProperty() throws IOException {
        int id = this.in.readInt();
        String tag = this.in.readUTF();
        if (reglogger.isDebugEnabled()) {
            reglogger.debug("Connection " + this.clientAddress + " return id: " + id + " removing info: " + tag);
        }
        HubDescription localHub = this.knownHubs.getLocalDescription();
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(33);
            this.out.writeInt(id);
            if (localHub.removeService(this.clientAddress, tag)) {
                this.out.writeInt(34);
            } else {
                this.out.writeInt(35);
            }
            this.out.flush();
        }
    }

    @Override
    protected String getName() {
        return "ClientConnection(" + this.clientAddress + ")";
    }

    @Override
    protected boolean handleOpcode(int opcode) {
        try {
            switch (opcode) {
                case 40: {
                    if (reqlogger.isDebugEnabled()) {
                        reqlogger.debug("Connection " + this.clientAddress + " requests hubs");
                    }
                    this.handleListHubs();
                    return true;
                }
                case 44: {
                    if (reqlogger.isDebugEnabled()) {
                        reqlogger.debug("Connection " + this.clientAddress + " requests hub details");
                    }
                    this.handleListHubDetails();
                    return true;
                }
                case 42: {
                    if (reqlogger.isDebugEnabled()) {
                        reqlogger.debug("Connection " + this.clientAddress + " requests local clients");
                    }
                    this.handleListClientsForHub();
                    return true;
                }
                case 43: {
                    if (reqlogger.isDebugEnabled()) {
                        reqlogger.debug("Connection " + this.clientAddress + " requests all clients");
                    }
                    this.handleListClients();
                    return true;
                }
                case 45: {
                    if (reqlogger.isDebugEnabled()) {
                        reqlogger.debug("Connection " + this.clientAddress + " requests direction to other client");
                    }
                    this.handleGetDirectionsToClient();
                    return true;
                }
                case 30: {
                    if (reglogger.isDebugEnabled()) {
                        reglogger.debug("Connection " + this.clientAddress + " requests info registration");
                    }
                    this.registerProperty();
                    return true;
                }
                case 31: {
                    if (reglogger.isDebugEnabled()) {
                        reglogger.debug("Connection " + this.clientAddress + " requests info update");
                    }
                    this.updateProperty();
                    return true;
                }
                case 32: {
                    if (reglogger.isDebugEnabled()) {
                        reglogger.debug("Connection " + this.clientAddress + " requests info removal");
                    }
                    this.handleRemoveProperty();
                    return true;
                }
            }
            conlogger.warn("Connection " + this.clientAddress + " got unknown opcode " + opcode + " -- disconnecting");
            this.handleDisconnect(null);
            return false;
        }
        catch (Exception e) {
            conlogger.warn("Connection to " + this.clientAddress + " is broken!", (Throwable)e);
            this.handleDisconnect(e);
            return false;
        }
    }
}

