/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.direct;

import ibis.smartsockets.direct.Network;
import ibis.smartsockets.util.NetworkUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Preference {
    private static final Logger logger = LoggerFactory.getLogger((String)"ibis.smartsockets.network.preference");
    private final String name;
    private final boolean strict;
    private ArrayList<Network> preferences = new ArrayList();
    private boolean noneAllowed = false;
    private boolean siteUsed = false;
    private boolean linkUsed = false;
    private boolean globalUsed = false;

    Preference(String name, boolean strict) {
        this.name = name;
        this.strict = strict;
    }

    int size() {
        return this.preferences.size();
    }

    void addSite() {
        if (this.siteUsed) {
            logger.warn("Preference(" + this.name + "): Site addresses already used.");
            throw new IllegalStateException(this.name + ": Site addresses already used.");
        }
        if (this.noneAllowed) {
            logger.warn("Preference(" + this.name + "): Cannot combine network rule 'site' with rule 'none'!");
            throw new IllegalStateException(this.name + ": Cannot combine network rule 'site' with rule 'none'!");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Preference(" + this.name + "): Adding site-local addresses to connection preference");
        }
        this.preferences.add(Network.SITE);
        this.siteUsed = true;
    }

    void addLink() {
        if (this.linkUsed) {
            logger.warn("Preference(" + this.name + "): Link addresses already used.");
            throw new IllegalStateException(this.name + ": Link addresses already used.");
        }
        if (this.noneAllowed) {
            logger.warn("Preference(" + this.name + "): Cannot combine network rule 'link' with rule 'none'!");
            throw new IllegalStateException(this.name + ": Cannot combine network rule 'link' with rule 'none'!");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Preference(" + this.name + "): Adding link-local addresses to connection preference");
        }
        this.preferences.add(Network.LINK);
        this.linkUsed = true;
    }

    void addGlobal() {
        if (this.noneAllowed) {
            logger.warn("Preference(" + this.name + "): Cannot combine network rule 'global' with rule 'none'!");
            throw new IllegalStateException(this.name + ": Cannot combine network rule 'global' with rule 'none'!");
        }
        if (this.globalUsed) {
            logger.warn("Preference(" + this.name + "): Global addresses already used.");
            throw new IllegalStateException(this.name + ": Global addresses already used.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Preference(" + this.name + "): Adding global addresses to connection preference");
        }
        this.preferences.add(Network.GLOBAL);
        this.globalUsed = true;
    }

    public void addNone() {
        if (this.siteUsed || this.linkUsed || this.globalUsed) {
            logger.warn("Preference(" + this.name + "): Cannot combine network rule 'none' with any rules that allow connection!");
            throw new IllegalStateException(this.name + ": network rule 'none' specified, while other rules already apply!.");
        }
        this.preferences.add(Network.NONE);
        this.noneAllowed = true;
    }

    void addNetwork(Network nw) {
        if (this.noneAllowed) {
            logger.warn("Preference(" + this.name + "): Cannot combine network rule with rule 'none'!");
            throw new IllegalStateException(this.name + ": Cannot combine network rule  with rule 'none'!");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Preference(" + this.name + "): Adding network " + nw + " to connection preference");
        }
        this.preferences.add(nw);
    }

    private int score(InetAddress ad) {
        int score = 0;
        for (Network nw : this.preferences) {
            if (nw.match(ad)) {
                return score;
            }
            ++score;
        }
        return score + 1;
    }

    private void sort(Object[] objects, int[] scores) {
        for (int i = 0; i < objects.length - 1; ++i) {
            for (int j = 0; j < objects.length - 1 - i; ++j) {
                if (scores[j + 1] >= scores[j]) continue;
                int tmp = scores[j + 1];
                scores[j + 1] = scores[j];
                scores[j] = tmp;
                Object ta = objects[j + 1];
                objects[j + 1] = objects[j];
                objects[j] = ta;
            }
        }
    }

    InetSocketAddress[] sort(InetSocketAddress[] ads, boolean inPlace) {
        if (this.preferences.size() == 0 || ads.length == 1) {
            if (logger.isDebugEnabled()) {
                logger.debug("Preference(" + this.name + "): No sorting required");
            }
            return ads;
        }
        int scored = 0;
        int[] scores = new int[ads.length];
        for (int i = 0; i < ads.length; ++i) {
            scores[i] = this.score(ads[i].getAddress());
            if (scores[i] >= this.preferences.size() + 1) continue;
            ++scored;
        }
        Object[] result = null;
        if (this.strict && !inPlace) {
            result = new InetSocketAddress[scored];
            int[] tmp = new int[scored];
            int next = 0;
            if (logger.isInfoEnabled()) {
                logger.info("Preference(" + this.name + "): Strict mode on. Removing unwanted addresses.");
            }
            for (int i = 0; i < ads.length; ++i) {
                if (scores[i] < this.preferences.size() + 1) {
                    result[next] = ads[i];
                    tmp[next] = scores[i];
                    ++next;
                    continue;
                }
                if (!logger.isInfoEnabled()) continue;
                logger.info("Preference(" + this.name + "): Removing address: " + NetworkUtils.ipToString(ads[i].getAddress()));
            }
            scores = tmp;
        } else {
            result = !inPlace ? (InetSocketAddress[])ads.clone() : ads;
        }
        this.sort(result, scores);
        return result;
    }

    InetAddress[] sort(InetAddress[] ads, boolean inPlace) {
        if (this.preferences.size() == 0 || ads.length == 1) {
            if (logger.isDebugEnabled()) {
                logger.debug("Preference(" + this.name + "): No sorting required");
            }
            return ads;
        }
        int scored = 0;
        int[] scores = new int[ads.length];
        for (int i = 0; i < ads.length; ++i) {
            scores[i] = this.score(ads[i]);
            if (scores[i] >= this.preferences.size() + 1) continue;
            ++scored;
        }
        Object[] result = null;
        if (this.strict && !inPlace) {
            if (logger.isInfoEnabled()) {
                logger.info("Preference(" + this.name + "): Strict mode on. Removing unwanted addresses.");
            }
            result = new InetAddress[scored];
            int[] tmp = new int[scored];
            int next = 0;
            for (int i = 0; i < ads.length; ++i) {
                if (scores[i] < this.preferences.size() + 1) {
                    result[next] = ads[i];
                    tmp[next] = scores[i];
                    ++next;
                    continue;
                }
                if (!logger.isInfoEnabled()) continue;
                logger.info("Preference(" + this.name + "): Removing address: " + NetworkUtils.ipToString(ads[i]));
            }
            scores = tmp;
        } else {
            result = !inPlace ? (InetAddress[])ads.clone() : ads;
        }
        this.sort(result, scores);
        return result;
    }

    public String toString() {
        if (this.preferences.size() == 0) {
            return this.name + ": Connection preference: none";
        }
        StringBuffer buf2 = new StringBuffer(this.name + ": Connection preference:");
        int i = 0;
        for (Network nw : this.preferences) {
            buf2.append(nw.toString());
            if (++i >= this.preferences.size()) continue;
            buf2.append(",");
        }
        return buf2.toString();
    }
}

