/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets;

import ibis.smartsockets.util.TypedProperties;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SmartSocketsProperties {
    public static final String DEFAULT_FILE = "smartsockets.properties";
    public static final String PREFIX = "smartsockets.";
    public static final String FILE = "smartsockets.file";
    public static final String START_HUB = "smartsockets.start.hub";
    public static final String STATISTICS_PRINT = "smartsockets.statistics";
    public static final String STATISTICS_PREFIX = "smartsockets.statistics.prefix";
    public static final String STATISTICS_INTERVAL = "smartsockets.statistics.interval";
    public static final String DETAILED_EXCEPTIONS = "smartsockets.detailed.exceptions";
    public static final String NIO = "smartsockets.nio";
    public static final String PORT_RANGE = "smartsockets.port.range";
    public static final String BACKLOG = "smartsockets.backlog";
    public static final String CONNECT_TIMEOUT = "smartsockets.timeout.connect";
    public static final String ACCEPT_TIMEOUT = "smartsockets.timeout.accept";
    public static final String EXTERNAL_PREFIX = "smartsockets.external.";
    public static final String UPNP = "smartsockets.external.upnp";
    public static final String UPNP_PORT_FORWARDING = "smartsockets.external.upnp.forwarding";
    public static final String STUN = "smartsockets.external.stun";
    public static final String STUN_SERVERS = "smartsockets.external.stun.servers";
    public static final String EXTERNAL_MANUAL = "smartsockets.external.manual";
    public static final String DISCOVERY_PREFIX = "smartsockets.discovery.";
    public static final String DISCOVERY_ALLOWED = "smartsockets.discovery.allowed";
    public static final String DISCOVERY_PREFERRED = "smartsockets.discovery.preferred";
    public static final String DISCOVERY_PORT = "smartsockets.discovery.port";
    public static final String DISCOVERY_TIMEOUT = "smartsockets.discovery.timeout";
    public static final String HUB_PREFIX = "smartsockets.hub.";
    public static final String HUB_ADDRESSES = "smartsockets.hub.addresses";
    public static final String HUB_NAME = "smartsockets.hub.name";
    public static final String HUB_VIZ_INFO = "smartsockets.hub.viz.info";
    public static final String HUB_CLUSTERS = "smartsockets.hub.clusters";
    public static final String HUB_PORT = "smartsockets.hub.port";
    public static final String HUB_SSH_ALLOWED = "smartsockets.hub.ssh";
    public static final String HUB_SEND_BUFFER = "smartsockets.hub.sendbuffer";
    public static final String HUB_RECEIVE_BUFFER = "smartsockets.hub.receivebuffer";
    public static final String HUB_STATISTICS = "smartsockets.hub.statistics";
    public static final String HUB_STATS_INTERVAL = "smartsockets.hub.statistics.interval";
    public static final String HUB_DELEGATE = "smartsockets.hub.delegate";
    public static final String HUB_DELEGATE_ADDRESS = "smartsockets.hub.delegate.address";
    public static final String HUB_VIRTUAL_PORT = "smartsockets.hub.virtualPort";
    public static final String HUB_ADDRESS_FILE = "smartsockets.hub.addressfile";
    public static final String SL_PREFIX = "smartsockets.servicelink.";
    public static final String SL_SEND_BUFFER = "smartsockets.servicelink.sendbuffer";
    public static final String SL_RECEIVE_BUFFER = "smartsockets.servicelink.receivebuffer";
    public static final String SL_KEEPALIVE = "smartsockets.servicelink.keepalive";
    public static final String SL_FORCE = "smartsockets.servicelink.force";
    public static final String SL_TIMEOUT = "smartsockets.servicelink.timeout";
    public static final String SL_RETRIES = "smartsockets.servicelink.retries";
    public static final String VIZ_PREFIX = "smartsockets.viz.";
    public static final String VIZ_TEXT_COLOR = "smartsockets.viz.text.color";
    public static final String VIZ_BACKGROUND_COLOR = "smartsockets.viz.background.color";
    public static final String MODULES_PREFIX = "smartsockets.modules.";
    public static final String MODULES_DEFINE = "smartsockets.modules.define";
    public static final String MODULES_ORDER = "smartsockets.modules.order";
    public static final String MODULES_SKIP = "smartsockets.modules.skip";
    public static final String DIRECT_PREFIX = "smartsockets.modules.direct.";
    public static final String DIRECT_BACKLOG = "smartsockets.modules.direct.backlog";
    public static final String DIRECT_TIMEOUT = "smartsockets.modules.direct.timeout";
    public static final String DIRECT_LOCAL_TIMEOUT = "smartsockets.modules.direct.timeout.local";
    public static final String DIRECT_SEND_BUFFER = "smartsockets.modules.direct.sendbuffer";
    public static final String DIRECT_RECEIVE_BUFFER = "smartsockets.modules.direct.receivebuffer";
    public static final String DIRECT_COUNT = "smartsockets.modules.direct.count";
    public static final String DIRECT_CACHE_IP = "smartsockets.modules.direct.cacheIP";
    public static final String SSH_PREFIX = "smartsockets.modules.direct.ssh.";
    public static final String SSH_IN = "smartsockets.modules.direct.ssh.in";
    public static final String SSH_OUT = "smartsockets.modules.direct.ssh.out";
    public static final String SSH_PORT = "smartsockets.modules.direct.ssh.port";
    public static final String FORCE_SSH_OUT = "smartsockets.modules.direct.ssh.out.force";
    public static final String SSH_PRIVATE_KEY = "smartsockets.modules.direct.ssh.privatekey";
    public static final String SSH_PASSPHRASE = "smartsockets.modules.direct.ssh.passphrase";
    public static final String REVERSE_PREFIX = "smartsockets.modules.reverse.";
    public static final String REVERSE_CONNECT_SELF = "smartsockets.modules.reverse.selfconnect";
    public static final String REVERSE_ACCEPT_TIMEOUT = "smartsockets.modules.reverse.accepttimeout";
    public static final String REVERSE_CONNECT_TIMEOUT = "smartsockets.modules.reverse.connecttimeout";
    public static final String ROUTED_PREFIX = "smartsockets.modules.hubrouted.";
    public static final String ROUTED_CONNECT_TIMEOUT = "smartsockets.modules.hubrouted.connecttimeout";
    public static final String ROUTED_BUFFER = "smartsockets.modules.hubrouted.size.buffer";
    public static final String ROUTED_FRAGMENT = "smartsockets.modules.hubrouted.size.fragment";
    public static final String ROUTED_MIN_ACK = "smartsockets.modules.hubrouted.size.ack";
    public static final String SPLICE_PREFIX = "smartsockets.modules.splice.";
    public static final String SPLICE_CONNECT_TIMEOUT = "smartsockets.modules.splice.connecttimeout";
    public static final String NETWORKS_PREFIX = "smartsockets.networks.";
    public static final String NETWORKS_DEFAULT = "smartsockets.networks.default";
    public static final String NETWORKS_DEFINE = "smartsockets.networks.define";
    public static final String NETWORKS_MEMBER = "smartsockets.networks.name";
    public static final String NW_RANGE = "range";
    public static final String NW_PREFERENCE_PREFIX = "preference.";
    public static final String NW_PREFERENCE_INSIDE = "preference.internal";
    public static final String NW_PREFERENCE_DEFAULT = "preference.default";
    public static final String NW_FIREWALL_PREFIX = "firewall.";
    public static final String NW_FIREWALL_ACCEPT = "firewall.accept";
    public static final String NW_FIREWALL_DENY = "firewall.deny";
    public static final String NW_FIREWALL_DEFAULT = "firewall.default";
    public static final String CLUSTER_PREFIX = "smartsockets.cluster.";
    public static final String CLUSTER_DEFINE = "smartsockets.cluster.define";
    public static final String CLUSTER_MEMBER = "smartsockets.cluster.member";
    public static final String CLUSTER_REORDER = "smartsockets.cluster.reorder";
    public static final String CLUSTER_PREFERENCE = "preference.";
    public static final String CLUSTER_MEMBERSHIP = "preference.membership";
    public static final String CLUSTER_INSIDE = "preference.inside";
    public static final String CLUSTER_DEFAULT = "preference.default";
    public static final String CLUSTER_SUB_REORDER = "preference.reorder";
    public static final String CONNECTIONS_SECURE = "smartsockets.modules.direct.connections.secure";
    public static final String CONNECTIONS_AUTHENTICATED = "smartsockets.modules.direct.connections.authenticate";
    public static final String TRUSTSTORE = "smartsockets.modules.direct.truststore";
    public static final String TRUSTSTORE_PASSWD = "smartsockets.modules.direct.truststore.password";
    public static final String KEYSTORE = "smartsockets.modules.direct.keystore";
    public static final String KEYSTORE_PASSWD = "smartsockets.modules.direct.keystore.password";
    private static final String[] DEFAULTS = new String[]{"smartsockets.modules.direct.backlog", "255", "smartsockets.backlog", "50", "smartsockets.timeout.accept", "60000", "smartsockets.modules.direct.timeout.local", "1000", "smartsockets.statistics", "false", "smartsockets.statistics.interval", "0", "smartsockets.modules.direct.ssh.out", "false", "smartsockets.modules.direct.ssh.in", "false", "smartsockets.modules.direct.ssh.port", "22", "smartsockets.nio", "false", "smartsockets.modules.direct.sendbuffer", "-1", "smartsockets.modules.direct.receivebuffer", "-1", "smartsockets.modules.direct.cacheIP", "true", "smartsockets.external.stun", "false", "smartsockets.external.upnp", "false", "smartsockets.external.upnp.forwarding", "false", "smartsockets.networks.default", "auto", "smartsockets.hub.port", "17878", "smartsockets.hub.sendbuffer", "-1", "smartsockets.hub.receivebuffer", "-1", "smartsockets.hub.statistics", "false", "smartsockets.hub.statistics.interval", "60000", "smartsockets.hub.virtualPort", "42", "smartsockets.modules.define", "direct,reverse,hubrouted", "smartsockets.modules.order", "direct,reverse,hubrouted", "smartsockets.discovery.allowed", "false", "smartsockets.discovery.preferred", "false", "smartsockets.discovery.port", "24545", "smartsockets.discovery.timeout", "5000", "smartsockets.servicelink.sendbuffer", "-1", "smartsockets.servicelink.receivebuffer", "-1", "smartsockets.servicelink.force", "false", "smartsockets.servicelink.timeout", "10000", "smartsockets.servicelink.retries", "6", "smartsockets.modules.hubrouted.size.buffer", "65536", "smartsockets.modules.hubrouted.size.fragment", "8176", "smartsockets.modules.direct.connections.authenticate", "false", "smartsockets.modules.direct.connections.secure", "false"};
    private static TypedProperties defaultProperties;
    protected static final Logger LOGGER;

    private SmartSocketsProperties() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TypedProperties getPropertyFile(String file) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Trying to load property file: " + file);
        }
        InputStream in = null;
        try {
            block26: {
                try {
                    in = new FileInputStream(file);
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("File: " + file + " found!");
                    }
                }
                catch (FileNotFoundException e) {
                    if (!LOGGER.isInfoEnabled()) break block26;
                    LOGGER.info("Property file \"" + file + "\" not found!");
                }
            }
            if (in == null) {
                ClassLoader loader = ClassLoader.getSystemClassLoader();
                in = loader.getResourceAsStream(file);
                if (in != null) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Found property file in classpath: \"" + loader.getResource(file) + "\"");
                    }
                } else {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Property file \"" + file + "\" not found in classpath, giving up!");
                    }
                    TypedProperties typedProperties = null;
                    return typedProperties;
                }
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Loading properties!");
            }
            TypedProperties p = new TypedProperties();
            p.load(in);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(p.toString());
            }
            TypedProperties typedProperties = p;
            return typedProperties;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception x) {
                LOGGER.warn("Failed to close property file: " + file, (Throwable)x);
            }
        }
    }

    public static TypedProperties getDefaultProperties() {
        if (defaultProperties == null) {
            defaultProperties = new TypedProperties();
            for (int i = 0; i < DEFAULTS.length; i += 2) {
                defaultProperties.put(DEFAULTS[i], DEFAULTS[i + 1]);
            }
            TypedProperties system = new TypedProperties(System.getProperties()).filter(PREFIX);
            String file = system.getProperty(FILE, DEFAULT_FILE);
            if (file != null) {
                TypedProperties fromFile = SmartSocketsProperties.getPropertyFile(file);
                if (fromFile != null) {
                    defaultProperties.putAll(fromFile);
                } else if (!file.equals(DEFAULT_FILE)) {
                    LOGGER.error("User specified preferences \"" + file + "\" not found!");
                }
            }
            defaultProperties.putAll(system);
        }
        return new TypedProperties(defaultProperties);
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)"ibis.smartsockets.properties");
    }
}

