/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.interaction;

import com.touchgraph.graphlayout.GraphListener;
import com.touchgraph.graphlayout.TGAbstractLens;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.TGPoint2D;
import com.touchgraph.graphlayout.interaction.TGAbstractDragUI;
import java.awt.event.MouseEvent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RotateScroll
implements GraphListener {
    RotateLens rotateLens;
    double rotateAngle;
    RotateDragUI rotateDragUI;
    private DoubleJSlider rotateSlider;
    boolean adjustmentIsInternal;
    private TGPanel tgPanel;

    public RotateScroll(TGPanel tgp) {
        this.tgPanel = tgp;
        this.rotateAngle = 0.0;
        this.rotateLens = new RotateLens();
        this.rotateDragUI = new RotateDragUI();
        this.rotateSlider = new DoubleJSlider(1, -314, 318, 0);
        this.rotateSlider.addChangeListener(new RotateChangeListener());
        this.adjustmentIsInternal = false;
        this.tgPanel.addGraphListener(this);
    }

    public RotateLens getLens() {
        return this.rotateLens;
    }

    public JSlider getRotateSlider() {
        return this.rotateSlider;
    }

    public RotateDragUI getRotateDragUI() {
        return this.rotateDragUI;
    }

    public int getRotationAngle() {
        double orientedValue = this.rotateSlider.getValue() - this.rotateSlider.getMinimum();
        double range = this.rotateSlider.getMaximum() - this.rotateSlider.getMinimum();
        return (int)(orientedValue / range * 359.0);
    }

    public void setRotationAngle(int angle) {
        double range = this.rotateSlider.getMaximum() - this.rotateSlider.getMinimum();
        this.rotateSlider.setValue((int)((double)angle / 359.0 * range + 0.5) + this.rotateSlider.getMinimum());
    }

    @Override
    public void graphMoved() {
    }

    @Override
    public void graphReset() {
        this.rotateAngle = 0.0;
        this.rotateSlider.setValue(0);
    }

    double computeAngle(double x, double y) {
        double angle = Math.atan(y / x);
        if (x == 0.0) {
            angle = y > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        if (x < 0.0) {
            angle += Math.PI;
        }
        return angle;
    }

    public void incrementRotateAngle(double inc) {
        this.rotateAngle += inc;
        if (this.rotateAngle > Math.PI) {
            this.rotateAngle -= Math.PI * 2;
        }
        if (this.rotateAngle < -Math.PI) {
            this.rotateAngle += Math.PI * 2;
        }
        this.adjustmentIsInternal = true;
        this.rotateSlider.setDValue(this.rotateAngle * 100.0);
        this.adjustmentIsInternal = false;
    }

    class RotateDragUI
    extends TGAbstractDragUI {
        double lastAngle;

        RotateDragUI() {
            super(RotateScroll.this.tgPanel);
        }

        double getMouseAngle(double x, double y) {
            return RotateScroll.this.computeAngle(x - this.tgPanel.getDrawCenter().x, y - this.tgPanel.getDrawCenter().y);
        }

        @Override
        public void preActivate() {
        }

        @Override
        public void preDeactivate() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.lastAngle = this.getMouseAngle(e.getX(), e.getY());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            double currentAngle = this.getMouseAngle(e.getX(), e.getY());
            RotateScroll.this.incrementRotateAngle(currentAngle - this.lastAngle);
            this.lastAngle = currentAngle;
            this.tgPanel.repaintAfterMove();
        }
    }

    class RotateLens
    extends TGAbstractLens {
        RotateLens() {
        }

        @Override
        protected void applyLens(TGPoint2D p) {
            double currentAngle = RotateScroll.this.computeAngle(p.x, p.y);
            double dist = Math.sqrt(p.x * p.x + p.y * p.y);
            p.x = dist * Math.cos(currentAngle + RotateScroll.this.rotateAngle);
            p.y = dist * Math.sin(currentAngle + RotateScroll.this.rotateAngle);
        }

        @Override
        protected void undoLens(TGPoint2D p) {
            double currentAngle = RotateScroll.this.computeAngle(p.x, p.y);
            double dist = Math.sqrt(p.x * p.x + p.y * p.y);
            p.x = dist * Math.cos(currentAngle - RotateScroll.this.rotateAngle);
            p.y = dist * Math.sin(currentAngle - RotateScroll.this.rotateAngle);
        }
    }

    class DoubleJSlider
    extends JSlider {
        private static final long serialVersionUID = 1L;
        private double doubleValue;

        DoubleJSlider(int orient, int min, int max, int val) {
            super(orient, min, max, val);
            this.doubleValue = val;
        }

        @Override
        public void setValue(int v) {
            this.doubleValue = v;
            super.setValue(v);
        }

        public void setIValue(int v) {
            super.setValue(v);
        }

        public void setDValue(double v) {
            this.doubleValue = Math.max((double)this.getMinimum(), Math.min((double)this.getMaximum(), v));
            this.setIValue((int)v);
        }

        public double getDValue() {
            return this.doubleValue;
        }
    }

    private class RotateChangeListener
    implements ChangeListener {
        private RotateChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!RotateScroll.this.adjustmentIsInternal) {
                RotateScroll.this.rotateAngle = RotateScroll.this.rotateSlider.getDValue() / 100.0;
                RotateScroll.this.tgPanel.repaintAfterMove();
            }
        }
    }
}

