/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.graphelements;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGException;
import com.touchgraph.graphlayout.graphelements.GraphEltSet;
import com.touchgraph.graphlayout.graphelements.Locality;

public class VisibleLocality
extends Locality {
    public VisibleLocality(GraphEltSet ges) {
        super(ges);
    }

    @Override
    public synchronized void addNode(Node node) throws TGException {
        super.addNode(node);
        node.setVisible(true);
    }

    @Override
    public void addEdge(Edge edge) {
        if (!this.contains(edge)) {
            super.addEdge(edge);
            ++edge.from.visibleEdgeCnt;
            ++edge.to.visibleEdgeCnt;
        }
    }

    @Override
    public boolean removeEdge(Edge edge) {
        boolean removed = super.removeEdge(edge);
        if (removed) {
            edge.setVisible(false);
            --edge.from.visibleEdgeCnt;
            --edge.to.visibleEdgeCnt;
        }
        return removed;
    }

    @Override
    public boolean removeNode(Node node) {
        boolean removed = super.removeNode(node);
        if (removed) {
            node.setVisible(false);
        }
        return removed;
    }

    @Override
    public synchronized void removeAll() {
        for (Node n : this.nodes) {
            n.setVisible(false);
        }
        for (Edge e : this.edges) {
            e.setVisible(false);
        }
        super.removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLocalityFromVisibility() throws TGException {
        GraphEltSet graphEltSet = this.completeEltSet;
        synchronized (graphEltSet) {
            for (Node node : this.completeEltSet.nodes) {
                try {
                    if (node.isVisible() && !this.contains(node)) {
                        this.addNode(node);
                        continue;
                    }
                    if (node.isVisible() || !this.contains(node)) continue;
                    this.removeNode(node);
                }
                catch (TGException ex) {
                    ex.printStackTrace();
                }
            }
            for (Edge edge : this.completeEltSet.edges) {
                if (edge.isVisible() && !this.contains(edge)) {
                    this.addEdge(edge);
                    continue;
                }
                if (edge.isVisible() || !this.contains(edge)) continue;
                this.removeEdge(edge);
            }
        }
    }
}

