/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout;

import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;

public class Edge {
    public static Color DEFAULT_COLOR = Color.decode("#006090");
    public static Color MOUSE_OVER_COLOR = Color.decode("#ccddff");
    public static int DEFAULT_LENGTH = 40;
    private static int[] point1X;
    private static int[] point2X;
    private static int[] point1Y;
    private static int[] point2Y;
    public Node from;
    public Node to;
    protected boolean arrowHead = false;
    protected Color col;
    private Color labelBackgroundColor = null;
    private Color labelTextColor = Color.BLACK;
    protected int length;
    protected boolean visible;
    protected String id = null;
    private String[] mouseOverText = null;
    private String lbl = null;
    private int lblLenHalf = 0;
    private static Stroke stroke;

    public Edge(Node f, Node t, int len, String lbl) {
        this.from = f;
        this.to = t;
        this.length = len;
        this.col = DEFAULT_COLOR;
        this.visible = false;
        this.lbl = lbl;
    }

    public Edge(Node f, Node t) {
        this(f, t, DEFAULT_LENGTH, null);
    }

    public Edge(Node f, Node t, String lbl) {
        this(f, t, DEFAULT_LENGTH, lbl);
    }

    public Edge(Node f, Node t, int length) {
        this(f, t, length, null);
    }

    public String getLbl() {
        return this.lbl;
    }

    public void setLbl(String lbl) {
        this.lbl = lbl;
        this.lblLenHalf = 0;
    }

    public Color getLabelBackgroundColor() {
        return this.labelBackgroundColor;
    }

    public void setLabelBackgroundColor(Color labelBackgroundColor) {
        this.labelBackgroundColor = labelBackgroundColor;
    }

    public Color getLabelTextColor() {
        return this.labelTextColor;
    }

    public void setLabelTextColor(Color labelTextColor) {
        this.labelTextColor = labelTextColor;
    }

    public static void setEdgeDefaultColor(Color color) {
        DEFAULT_COLOR = color;
    }

    public static void setEdgeMouseOverColor(Color color) {
        MOUSE_OVER_COLOR = color;
    }

    public static void setEdgeDefaultLength(int length) {
        DEFAULT_LENGTH = length;
    }

    public Node getFrom() {
        return this.from;
    }

    public Node getTo() {
        return this.to;
    }

    public Color getColor() {
        return this.col;
    }

    public void setColor(Color color) {
        this.col = color;
    }

    public void useArrowHead(boolean value) {
        this.arrowHead = value;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int len) {
        this.length = len;
    }

    public void setVisible(boolean v) {
        this.visible = v;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Node getOtherEndpt(Node n) {
        if (this.to != n) {
            return this.to;
        }
        return this.from;
    }

    public void reverse() {
        Node temp = this.to;
        this.to = this.from;
        this.from = temp;
    }

    public boolean intersects(Dimension d) {
        int x1 = (int)this.from.drawx;
        int y1 = (int)this.from.drawy;
        int x2 = (int)this.to.drawx;
        int y2 = (int)this.to.drawy;
        return !(x1 <= 0 && x2 <= 0 || x1 >= d.width && x2 >= d.width || y1 <= 0 && y2 <= 0 || y1 >= d.height && y2 >= d.height);
    }

    public double distFromPoint(double px, double py) {
        double x1 = this.from.drawx;
        double y1 = this.from.drawy;
        double x2 = this.to.drawx;
        double y2 = this.to.drawy;
        if (px < Math.min(x1, x2) - 8.0 || px > Math.max(x1, x2) + 8.0 || py < Math.min(y1, y2) - 8.0 || py > Math.max(y1, y2) + 8.0) {
            return 1000.0;
        }
        double dist = 1000.0;
        if (x1 - x2 != 0.0) {
            dist = Math.abs((y2 - y1) / (x2 - x1) * (px - x1) + (y1 - py));
        }
        if (y1 - y2 != 0.0) {
            dist = Math.min(dist, Math.abs((x2 - x1) / (y2 - y1) * (py - y1) + (x1 - px)));
        }
        return dist;
    }

    public boolean containsPoint(double px, double py) {
        return this.distFromPoint(px, py) < 10.0;
    }

    public static void drawArrowHead(Graphics g, double xCenter, double yCenter, double x, double y, double stroke) {
        double aDir = Math.atan2(xCenter - x, yCenter - y);
        Polygon tmpPoly = new Polygon();
        double i1 = 6.0 + stroke * 2.0;
        double i2 = 6.0 + stroke;
        tmpPoly.addPoint((int)Math.round(x), (int)Math.round(y));
        tmpPoly.addPoint((int)Math.round(x + Edge.xCor(i1, aDir + 0.5)), (int)Math.round(y + Edge.yCor(i1, aDir + 0.5)));
        tmpPoly.addPoint((int)Math.round(x + Edge.xCor(i1, aDir - 0.5)), (int)Math.round(y + Edge.yCor(i1, aDir - 0.5)));
        tmpPoly.addPoint((int)Math.round(x), (int)Math.round(y));
        g.drawPolygon(tmpPoly);
        g.fillPolygon(tmpPoly);
        g.drawLine((int)Math.round(xCenter), (int)Math.round(yCenter), (int)Math.round(x + Edge.xCor(i2, aDir)), (int)Math.round(y + Edge.yCor(i2, aDir)));
    }

    private static double yCor(double len, double dir) {
        return len * Math.cos(dir);
    }

    private static double xCor(double len, double dir) {
        return len * Math.sin(dir);
    }

    public static void paintArrow(Graphics g, int x1, int y1, int x2, int y2, Color c) {
        System.out.println("EEK");
        Edge.paintArrow((Graphics2D)g, x1, y1, x2, y2, false, c);
    }

    public static void paintArrow(Graphics2D g, int x1, int y1, int x2, int y2, boolean head, Color c) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(c);
        g.setStroke(stroke);
        g.drawLine(x1, y1, x2, y2);
        if (head) {
            double x3 = x1;
            double y3 = y1;
            int x3rounded = x1;
            int y3rounded = y1;
            double dist = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
            if (dist > 10.0) {
                double adjustDistRatio = (dist - 10.0) / dist;
                x3 = (double)x1 + (double)(x2 - x1) * adjustDistRatio;
                y3 = (double)y1 + (double)(y2 - y1) * adjustDistRatio;
                x3 = (x3 * 4.0 + (double)x1) / 5.0;
                y3 = (y3 * 4.0 + (double)y1) / 5.0;
                x3rounded = (int)Math.round(x3);
                y3rounded = (int)Math.round(y3);
            }
            int index = Edge.getIndex(Math.atan2(x2 - x1, y2 - y1));
            Polygon tmpPoly = new Polygon();
            tmpPoly.addPoint(x3rounded, y3rounded);
            tmpPoly.addPoint(x3rounded + point1X[index], y3rounded + point1Y[index]);
            tmpPoly.addPoint(x3rounded + point2X[index], y3rounded + point2Y[index]);
            tmpPoly.addPoint(x3rounded, y3rounded);
            g.drawPolygon(tmpPoly);
            g.fillPolygon(tmpPoly);
        }
    }

    private static void preComputeArrowPoints(int stroke) {
        point1X = new int[361];
        point2X = new int[361];
        point1Y = new int[361];
        point2Y = new int[361];
        for (int i = -180; i <= 180; ++i) {
            double arc = (double)i * Math.PI / 180.0;
            double x4 = (double)(-stroke) * Math.sin(arc);
            double y4 = (double)(-stroke) * Math.cos(arc);
            double xdiff = -x4 / 2.0;
            double ydiff = -y4 / 2.0;
            Edge.point1X[i + 180] = (int)Math.round(x4 + ydiff);
            Edge.point1Y[i + 180] = (int)Math.round(y4 - xdiff);
            Edge.point2X[i + 180] = (int)Math.round(x4 - ydiff);
            Edge.point2Y[i + 180] = (int)Math.round(y4 + xdiff);
        }
    }

    private static int getIndex(double arc) {
        int index = (int)((arc + Math.PI) * 180.0 / Math.PI);
        if (index < 0) {
            index = 0;
        }
        if (index > 360) {
            index = 360;
        }
        return index;
    }

    public void setMouseOverText(String[] text) {
        this.mouseOverText = text;
    }

    public void paint(Graphics g, TGPanel tgPanel) {
        this.paint(g, tgPanel, false);
    }

    public void paint(Graphics g, TGPanel tgPanel, boolean mouseOver) {
        Color c = tgPanel.getMouseOverE() == this ? MOUSE_OVER_COLOR : this.col;
        int x1 = (int)this.from.drawx;
        int y1 = (int)this.from.drawy;
        int x2 = (int)this.to.drawx;
        int y2 = (int)this.to.drawy;
        if (this.intersects(tgPanel.getSize())) {
            Edge.paintArrow((Graphics2D)g, x1, y1, x2, y2, this.arrowHead, c);
            if (mouseOver) {
                String[] text = this.mouseOverText;
                if (text != null) {
                    Point mouse = tgPanel.getMousePos();
                    this.paintTextTag(g, tgPanel, mouse.x, mouse.y, Color.white, Color.black, text);
                }
            } else if (this.lbl != null) {
                double dist = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
                int x = (x2 + x1) / 2;
                int y = (y2 + y1) / 2;
                if (dist > 20.0) {
                    x = (x1 * 5 + x2 * 3) / 8;
                    y = (y1 * 5 + y2 * 3) / 8;
                }
                this.paintLabel(g, x, y, c);
            }
        }
    }

    public void paintLabel(Graphics g, int x, int y, Color c) {
        g.setFont(Node.SMALL_TAG_FONT);
        if (this.lblLenHalf == 0) {
            FontRenderContext frc = ((Graphics2D)g).getFontRenderContext();
            TextLayout layout = new TextLayout(this.lbl, Node.SMALL_TAG_FONT, frc);
            this.lblLenHalf = (int)layout.getBounds().getWidth() / 2 + 2;
        }
        if (this.labelBackgroundColor != null) {
            g.setColor(this.labelBackgroundColor);
            g.fillRect(x - this.lblLenHalf, y - 5, 2 * this.lblLenHalf, 10);
        }
        g.setColor(this.labelTextColor);
        g.drawString(this.lbl, x - this.lblLenHalf, y + 3);
    }

    public void paintTextTag(Graphics g, TGPanel tgPanel, int tagX, int tagY, Color backCol, Color textCol, String[] text) {
        g.setFont(Node.SMALL_TAG_FONT);
        FontRenderContext frc = ((Graphics2D)g).getFontRenderContext();
        int maxX = 0;
        for (String s : text) {
            TextLayout layout = new TextLayout(s, Node.SMALL_TAG_FONT, frc);
            maxX = Math.max(maxX, (int)layout.getBounds().getWidth());
        }
        int w = maxX + 14;
        int h = text.length * 10 + 2;
        g.setColor(backCol);
        g.fillRect(tagX, tagY + 15, w, h);
        g.setColor(textCol);
        for (int i = 0; i < text.length; ++i) {
            g.drawString(text[i], tagX + 7, tagY + 25 + i * 10);
        }
    }

    protected void setStroke(Stroke stroke) {
        Edge.stroke = stroke;
    }

    static {
        Edge.preComputeArrowPoints(8);
        stroke = new BasicStroke(2.0f);
    }
}

