/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.stacking.lrmc;

import ibis.ipl.IbisIdentifier;
import ibis.ipl.MessageUpcall;
import ibis.ipl.PortType;
import ibis.ipl.ReadMessage;
import ibis.ipl.ReceivePort;
import ibis.ipl.SendPort;
import ibis.ipl.WriteMessage;
import ibis.ipl.impl.stacking.lrmc.LrmcIbis;
import ibis.ipl.impl.stacking.lrmc.io.MessageReceiver;
import ibis.ipl.impl.stacking.lrmc.util.DynamicObjectArray;
import ibis.ipl.impl.stacking.lrmc.util.IbisSorter;
import ibis.ipl.impl.stacking.lrmc.util.Message;
import ibis.ipl.impl.stacking.lrmc.util.MessageCache;
import ibis.ipl.impl.stacking.lrmc.util.MessageQueue;
import ibis.util.TypedProperties;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelRoutingMulticast
extends Thread
implements MessageUpcall {
    private static final int ZOMBIE_THRESHOLD = 100000;
    private static final Logger logger = LoggerFactory.getLogger(LabelRoutingMulticast.class);
    final LrmcIbis ibis;
    private final String name;
    ReceivePort receive;
    private MessageReceiver receiver;
    private final MessageCache cache;
    private final DynamicObjectArray<SendPort> sendports = new DynamicObjectArray();
    private final DynamicObjectArray<Long> diedmachines = new DynamicObjectArray();
    private boolean finish = false;
    private int[] destinations = null;
    private long bytes = 0L;
    private MessageQueue sendQueue;

    public LabelRoutingMulticast(LrmcIbis ibis, MessageReceiver m, MessageCache c, String name) throws IOException {
        this.ibis = ibis;
        this.receiver = m;
        this.name = name;
        this.cache = c;
        this.sendQueue = new MessageQueue(new TypedProperties(ibis.properties()).getIntProperty("lrmc.queueSize", 256));
        this.receive = ibis.base.createReceivePort(LrmcIbis.additionalPortType, "LRMCRing-" + name, (MessageUpcall)this);
        this.receive.enableConnections();
        this.receive.enableMessageUpcalls();
        super.setName("LabelRoutingMulticast:" + name);
        this.start();
    }

    public static PortType getPortType() {
        return new PortType(new String[]{"serialization.data", "communication.reliable", "connection.manytoone", "receive.autoupcalls"});
    }

    private synchronized SendPort getSendPort(int id) {
        if (id == -1) {
            logger.info("Ignoring " + id);
            return null;
        }
        SendPort sp = this.sendports.get(id);
        if (sp == null) {
            Long ripTime = this.diedmachines.get(id);
            if (ripTime != null) {
                long now = System.currentTimeMillis();
                if (now - ripTime > 100000L) {
                    this.diedmachines.remove(id);
                    logger.info("Sender insists that " + id + " is still allive, so I'll try again!");
                } else {
                    logger.info("Ignoring " + id + " since it's dead!");
                    return null;
                }
            }
            boolean failed = false;
            IbisIdentifier ibisID = null;
            try {
                sp = this.ibis.base.createSendPort(LrmcIbis.additionalPortType);
                ibisID = this.ibis.getId(id);
                if (ibisID != null) {
                    sp.connect(ibisID, "LRMCRing-" + this.name, 10000L, true);
                    this.sendports.put(id, sp);
                } else {
                    logger.info("No Ibis at position " + id);
                    failed = true;
                }
            }
            catch (IOException e) {
                failed = true;
                logger.info("Got exception ", (Throwable)e);
            }
            if (failed) {
                logger.info("Failed to connect to " + id + " - informing nameserver!");
                try {
                    if (ibisID != null) {
                        this.ibis.registry().maybeDead(ibisID);
                    }
                    this.diedmachines.put(id, new Long(System.currentTimeMillis()));
                }
                catch (Exception e2) {
                    logger.info("Failed to inform nameserver! " + e2);
                }
                logger.info("Done informing nameserver");
                return null;
            }
        }
        return sp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalSend(Message m) {
        SendPort sp = null;
        if (m.destinationsUsed == 0) {
            if (m.last) {
                sp = this.getSendPort(m.sender);
                if (sp != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Writing DONE message " + m.id + " to sender " + m.sender);
                    }
                    try {
                        WriteMessage wm = sp.newMessage();
                        wm.writeInt(-1);
                        wm.writeInt(m.id);
                        wm.finish();
                    }
                    catch (IOException e) {
                        logger.debug("Writing DONE message to " + m.sender + " failed");
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug("No sendport for sender " + m.sender);
                }
            }
            return;
        }
        int index = 0;
        int id = -1;
        do {
            if ((sp = this.getSendPort(id = m.destinations[index++])) != null) continue;
            LabelRoutingMulticast labelRoutingMulticast = this;
            synchronized (labelRoutingMulticast) {
                if (this.finish) {
                    return;
                }
            }
        } while (sp == null && index < m.destinationsUsed);
        try {
            if (sp == null) {
                logger.info("No working destinations found, giving up!");
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Writing message " + m.id + "/" + m.num + " to " + id + ", sender " + m.sender + ", destinations left = " + (m.destinationsUsed - index));
            }
            WriteMessage wm = sp.newMessage();
            m.write(wm, index);
            this.bytes += wm.finish();
        }
        catch (IOException e) {
            logger.info("Write to " + id + " failed! ", (Throwable)e);
            this.sendports.remove(id);
        }
    }

    public void setDestination(IbisIdentifier[] destinations) {
        logger.debug("setDestination called, destinations.length = " + destinations.length, new Throwable());
        IbisSorter.sort(this.ibis.identifier(), destinations);
        this.destinations = new int[destinations.length];
        for (int i = 0; i < destinations.length; ++i) {
            this.destinations[i] = this.ibis.getIbisID(destinations[i]);
            logger.debug("  " + i + " (" + destinations[i] + " at " + destinations[i].location().getParent() + ") -> " + this.destinations[i]);
        }
    }

    public long getBytes(boolean reset) {
        long tmp = this.bytes;
        if (reset) {
            this.bytes = 0L;
        }
        return tmp;
    }

    public boolean send(Message m) {
        int[] destOld = m.destinations;
        m.destinations = this.destinations;
        m.destinationsUsed = this.destinations.length;
        m.sender = this.ibis.myID;
        m.local = true;
        this.internalSend(m);
        m.destinations = destOld;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Message m;
        while ((m = this.sendQueue.dequeue()) != null) {
            try {
                this.internalSend(m);
                continue;
            }
            catch (Exception e) {
                logger.info("Sender thread got exception! ", (Throwable)e);
                continue;
            }
            finally {
                this.cache.put(m);
                continue;
            }
            break;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        LabelRoutingMulticast labelRoutingMulticast = this;
        synchronized (labelRoutingMulticast) {
            this.finish = true;
        }
        this.sendQueue.terminate();
        try {
            this.join(10000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.receive.disableConnections();
            int last = this.sendports.last();
            for (int i = 0; i < last; ++i) {
                SendPort tmp = this.sendports.get(i);
                if (tmp == null) continue;
                tmp.close();
            }
            this.receive.close(1000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void upcall(ReadMessage rm) throws IOException {
        block8: {
            Message message = null;
            try {
                int len = rm.readInt();
                if (len == -1) {
                    int id = rm.readInt();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Got DONE for message " + id);
                    }
                    this.receiver.gotDone(id);
                    return;
                }
                int dst = rm.readInt();
                message = this.cache.get(len);
                message.read(rm, len, dst);
                if (logger.isDebugEnabled()) {
                    logger.debug("Reading message " + message.id + "/" + message.num + " from " + message.sender);
                }
                if (!message.local) {
                    message.refcount = (short)(message.refcount + 1);
                    try {
                        this.receiver.gotMessage(message);
                    }
                    catch (Throwable e) {
                        logger.info("Delivery failed! ", e);
                    }
                }
                this.sendQueue.enqueue(message);
            }
            catch (IOException e) {
                logger.info("Failed to receive message: ", (Throwable)e);
                rm.finish(e);
                if (message == null) break block8;
                this.cache.put(message);
            }
        }
    }

    public int getPrefferedMessageSize() {
        return this.cache.getPrefferedMessageSize();
    }
}

