/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.jmx;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import net.sbbi.upnp.services.ServiceStateVariable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UPNPMBeanService {
    private static final Log log = LogFactory.getLog((Class)UPNPMBeanService.class);
    private String serviceType;
    private String serviceId;
    private String serviceUUID;
    private String deviceUUID;
    private String deviceSCDP;
    private Map operationsStateVariables;
    private MBeanServer targetServer;
    private ObjectName mbeanName;
    private Class targetBeanClass;

    protected UPNPMBeanService(String deviceUUID, String vendorDomain, String serviceId, String serviceType, int serviceVersion, MBeanInfo mbeanInfo, ObjectName mbeanName, MBeanServer targetServer) throws IOException {
        this.deviceUUID = deviceUUID;
        this.serviceUUID = deviceUUID + "/" + serviceId;
        this.serviceType = "urn:" + vendorDomain + ":service:" + serviceType + ":" + serviceVersion;
        this.serviceId = "urn:" + vendorDomain + ":serviceId:" + serviceId;
        this.deviceSCDP = this.getDeviceSSDP(mbeanInfo);
        try {
            this.targetBeanClass = Class.forName(mbeanInfo.getClassName());
        }
        catch (ClassNotFoundException ex) {
            IOException ex2 = new IOException("Unable to find target MBean class " + mbeanInfo.getClassName());
            ex2.initCause(ex);
            throw ex2;
        }
        this.mbeanName = mbeanName;
        this.targetServer = targetServer;
    }

    protected String getServiceUUID() {
        return this.serviceUUID;
    }

    protected String getDeviceUUID() {
        return this.deviceUUID;
    }

    protected String getServiceInfo() {
        StringBuffer rtrVal = new StringBuffer();
        rtrVal.append("<service>\r\n");
        rtrVal.append("<serviceType>").append(this.serviceType).append("</serviceType>\r\n");
        rtrVal.append("<serviceId>").append(this.serviceId).append("</serviceId>\r\n");
        rtrVal.append("<controlURL>").append("/").append(this.serviceUUID).append("/control").append("</controlURL>\r\n");
        rtrVal.append("<eventSubURL>").append("/").append(this.serviceUUID).append("/events").append("</eventSubURL>\r\n");
        rtrVal.append("<SCPDURL>").append("/").append(this.serviceUUID).append("/scpd.xml").append("</SCPDURL>\r\n");
        rtrVal.append("</service>\r\n");
        return rtrVal.toString();
    }

    protected Map getOperationsStateVariables() {
        return this.operationsStateVariables;
    }

    protected String getDeviceSCDP() {
        return this.deviceSCDP;
    }

    protected String getServiceType() {
        return this.serviceType;
    }

    protected Class getTargetBeanClass() {
        return this.targetBeanClass;
    }

    protected Object getAttribute(String attributeName) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException {
        return this.targetServer.getAttribute(this.mbeanName, attributeName);
    }

    protected Object invoke(String actionName, Object[] params, String[] signature) throws ReflectionException, InstanceNotFoundException, MBeanException {
        return this.targetServer.invoke(this.mbeanName, actionName, params, signature);
    }

    private String getDeviceSSDP(MBeanInfo info) throws IllegalArgumentException {
        MBeanOperationInfo[] ops = info.getOperations();
        MBeanAttributeInfo[] atts = info.getAttributes();
        if (!(ops != null && ops.length != 0 || atts != null && atts.length != 0)) {
            throw new IllegalArgumentException("MBean has no operation and no attribute and cannot be exposed as an UPNP device, provide at least one attribute");
        }
        this.operationsStateVariables = new HashMap();
        StringBuffer rtrVal = new StringBuffer();
        rtrVal.append("<?xml version=\"1.0\" ?>\r\n");
        rtrVal.append("<scpd xmlns=\"urn:schemas-upnp-org:service-1-0\">\r\n");
        rtrVal.append("<specVersion><major>1</major><minor>0</minor></specVersion>\r\n");
        if (ops != null && ops.length > 0) {
            rtrVal.append("<actionList>\r\n");
            for (int i = 0; i < ops.length; ++i) {
                MBeanOperationInfo op = ops[i];
                StringBuffer action = new StringBuffer();
                action.append("<action>\r\n");
                action.append("<name>");
                action.append(op.getName());
                action.append("</name>\r\n");
                action.append("<argumentList>\r\n");
                action.append("<argument>\r\n");
                action.append("<name>");
                String outVarName = op.getName() + "_out";
                String actionOutDataType = ServiceStateVariable.getUPNPDataTypeMapping(op.getReturnType());
                if (actionOutDataType == null) {
                    actionOutDataType = "string";
                }
                action.append(outVarName);
                action.append("</name>\r\n");
                action.append("<direction>out</direction>\r\n");
                action.append("<relatedStateVariable>");
                action.append(outVarName);
                action.append("</relatedStateVariable>\r\n");
                action.append("</argument>\r\n");
                boolean nonPrimitiveInputType = false;
                boolean duplicatedInputVarname = false;
                HashMap<String, String> operationsInputStateVariables = new HashMap<String, String>();
                if (op.getSignature() != null) {
                    for (int z = 0; z < op.getSignature().length; ++z) {
                        MBeanParameterInfo param = op.getSignature()[z];
                        action.append("<argument>\r\n");
                        action.append("<name>");
                        String inVarName = param.getName();
                        String actionInDataType = ServiceStateVariable.getUPNPDataTypeMapping(param.getType());
                        if (actionInDataType == null) {
                            nonPrimitiveInputType = true;
                            log.debug((Object)("The " + param.getType() + " type is not an UPNP compatible data type, use only primitives"));
                            break;
                        }
                        String existing = (String)this.operationsStateVariables.get(inVarName);
                        if (existing != null && !existing.equals(actionInDataType)) {
                            String msg = "The operation " + op.getName() + " " + inVarName + " parameter already exists for another method with another data type (" + existing + ") either match the data type or change the parameter name" + " in you MBeanParameterInfo object for this operation";
                            duplicatedInputVarname = true;
                            log.debug((Object)msg);
                            break;
                        }
                        operationsInputStateVariables.put(inVarName, actionInDataType);
                        action.append(inVarName);
                        action.append("</name>\r\n");
                        action.append("<direction>in</direction>\r\n");
                        action.append("<relatedStateVariable>");
                        action.append(inVarName);
                        action.append("</relatedStateVariable>\r\n");
                        action.append("</argument>\r\n");
                    }
                }
                action.append("</argumentList>\r\n");
                action.append("</action>\r\n");
                if (nonPrimitiveInputType || duplicatedInputVarname) continue;
                this.operationsStateVariables.putAll(operationsInputStateVariables);
                this.operationsStateVariables.put(outVarName, actionOutDataType);
                rtrVal.append(action.toString());
            }
            rtrVal.append("</actionList>\r\n");
        } else {
            rtrVal.append("<actionList/>\r\n");
        }
        rtrVal.append("<serviceStateTable>\r\n");
        Iterator i = this.operationsStateVariables.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            String type = (String)this.operationsStateVariables.get(name);
            rtrVal.append("<stateVariable sendEvents=\"no\">\r\n");
            rtrVal.append("<name>");
            rtrVal.append(name);
            rtrVal.append("</name>\r\n");
            rtrVal.append("<dataType>");
            rtrVal.append(type);
            rtrVal.append("</dataType>\r\n");
            rtrVal.append("</stateVariable>\r\n");
        }
        if (atts != null && atts.length > 0) {
            for (int i2 = 0; i2 < atts.length; ++i2) {
                MBeanAttributeInfo att = atts[i2];
                if (!att.isReadable()) continue;
                rtrVal.append("<stateVariable sendEvents=\"no\">\r\n");
                rtrVal.append("<name>");
                rtrVal.append(att.getName());
                rtrVal.append("</name>\r\n");
                rtrVal.append("<dataType>");
                rtrVal.append(ServiceStateVariable.getUPNPDataTypeMapping(att.getType()));
                rtrVal.append("</dataType>\r\n");
                rtrVal.append("</stateVariable>\r\n");
            }
        }
        rtrVal.append("</serviceStateTable>\r\n");
        rtrVal.append("</scpd>");
        return rtrVal.toString();
    }
}

