/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sbbi.upnp.HttpResponse;
import net.sbbi.upnp.ServiceEventHandler;
import net.sbbi.upnp.ServiceEventMessageParser;
import net.sbbi.upnp.services.UPNPService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class ServicesEventing
implements Runnable {
    private static final Log log = LogFactory.getLog((Class)ServicesEventing.class);
    private static final ServicesEventing singleton = new ServicesEventing();
    private boolean inService = false;
    private boolean daemon = true;
    private int daemonPort = 9999;
    private ServerSocket server = null;
    private List registered = new ArrayList();

    private ServicesEventing() {
    }

    public static final ServicesEventing getInstance() {
        return singleton;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public void setDaemonPort(int daemonPort) {
        this.daemonPort = daemonPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int register(UPNPService service, ServiceEventHandler handler, int subscriptionDuration) throws IOException {
        URL eventingLoc = service.getEventSubURL();
        if (eventingLoc != null) {
            HttpResponse resp;
            Subscription sub;
            if (!this.inService) {
                this.startServicesEventingThread();
            }
            String duration = Integer.toString(subscriptionDuration);
            if (subscriptionDuration == -1) {
                duration = "infinite";
            }
            if ((sub = this.lookupSubscriber(service, handler)) != null) {
                this.unRegister(service, handler);
            }
            StringBuffer packet = new StringBuffer(64);
            packet.append("SUBSCRIBE ").append(eventingLoc.getFile()).append(" HTTP/1.1\r\n");
            packet.append("HOST: ").append(eventingLoc.getHost()).append(":").append(eventingLoc.getPort()).append("\r\n");
            packet.append("CALLBACK: <http://").append(InetAddress.getLocalHost().getHostAddress()).append(":").append(this.daemonPort).append("").append(eventingLoc.getFile()).append(">\r\n");
            packet.append("NT: upnp:event\r\n");
            packet.append("TIMEOUT: Second-").append(duration).append("\r\n\r\n");
            Socket skt = new Socket(eventingLoc.getHost(), eventingLoc.getPort());
            skt.setSoTimeout(30000);
            if (log.isDebugEnabled()) {
                log.debug((Object)packet);
            }
            OutputStream out = skt.getOutputStream();
            out.write(packet.toString().getBytes());
            out.flush();
            InputStream in = skt.getInputStream();
            StringBuffer data = new StringBuffer();
            int readen = 0;
            byte[] buffer = new byte[256];
            while ((readen = in.read(buffer)) != -1) {
                data.append(new String(buffer, 0, readen));
            }
            in.close();
            out.close();
            skt.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)data.toString());
            }
            if (data.toString().trim().length() > 0 && (resp = new HttpResponse(data.toString())).getHeader().startsWith("HTTP/1.1 200 OK")) {
                String sid = resp.getHTTPHeaderField("SID");
                String actualTimeout = resp.getHTTPHeaderField("TIMEOUT");
                sub = new Subscription();
                sub.handler = handler;
                sub.serviceId = service.getServiceId();
                sub.serviceType = service.getServiceType();
                sub.serviceURL = service.getEventSubURL();
                sub.deviceIp = skt.getInetAddress();
                sub.SID = sid;
                List list = this.registered;
                synchronized (list) {
                    this.registered.add(sub);
                }
                return Integer.parseInt(actualTimeout.substring(7));
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Subscription lookupSubscriber(UPNPService service, ServiceEventHandler handler) {
        List list = this.registered;
        synchronized (list) {
            Iterator i = this.registered.iterator();
            while (i.hasNext()) {
                Subscription sub = (Subscription)i.next();
                if (sub.handler != handler || sub.serviceId.hashCode() != service.getServiceId().hashCode() || sub.serviceType.hashCode() != service.getServiceType().hashCode() || !sub.serviceURL.equals(service.getEventSubURL())) continue;
                return sub;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Subscription lookupSubscriber(String sid, InetAddress deviceIp) {
        List list = this.registered;
        synchronized (list) {
            Iterator i = this.registered.iterator();
            while (i.hasNext()) {
                Subscription sub = (Subscription)i.next();
                if (!sub.SID.equals(sid) || !sub.deviceIp.equals(deviceIp)) continue;
                return sub;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unRegister(UPNPService service, ServiceEventHandler handler) throws IOException {
        Subscription sub;
        URL eventingLoc = service.getEventSubURL();
        if (eventingLoc != null && (sub = this.lookupSubscriber(service, handler)) != null) {
            HttpResponse resp;
            List list = this.registered;
            synchronized (list) {
                this.registered.remove(sub);
            }
            if (this.registered.size() == 0) {
                this.stopServicesEventingThread();
            }
            StringBuffer packet = new StringBuffer(64);
            packet.append("UNSUBSCRIBE  ").append(eventingLoc.getFile()).append(" HTTP/1.1\r\n");
            packet.append("HOST: ").append(eventingLoc.getHost()).append(":").append(eventingLoc.getPort()).append("\r\n");
            packet.append("SID: ").append(sub.SID).append("\r\n\r\n");
            Socket skt = new Socket(eventingLoc.getHost(), eventingLoc.getPort());
            skt.setSoTimeout(30000);
            if (log.isDebugEnabled()) {
                log.debug((Object)packet);
            }
            OutputStream out = skt.getOutputStream();
            out.write(packet.toString().getBytes());
            out.flush();
            InputStream in = skt.getInputStream();
            StringBuffer data = new StringBuffer();
            int readen = 0;
            byte[] buffer = new byte[256];
            while ((readen = in.read(buffer)) != -1) {
                data.append(new String(buffer, 0, readen));
            }
            in.close();
            out.close();
            skt.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)data.toString());
            }
            if (data.toString().trim().length() > 0 && (resp = new HttpResponse(data.toString())).getHeader().startsWith("HTTP/1.1 200 OK")) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServicesEventingThread() {
        ServicesEventing servicesEventing = singleton;
        synchronized (servicesEventing) {
            if (!this.inService) {
                Thread deamon = new Thread((Runnable)singleton, "ServicesEventing daemon");
                deamon.setDaemon(this.daemon);
                this.inService = true;
                deamon.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopServicesEventingThread() {
        ServicesEventing servicesEventing = singleton;
        synchronized (servicesEventing) {
            this.inService = false;
            try {
                this.server.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void run() {
        if (!Thread.currentThread().getName().equals("ServicesEventing daemon")) {
            return;
        }
        try {
            this.server = new ServerSocket(this.daemonPort);
        }
        catch (IOException ex) {
            log.error((Object)("Error during daemon server socket on port " + this.daemonPort + " creation"), (Throwable)ex);
            return;
        }
        while (this.inService) {
            try {
                Socket skt = this.server.accept();
                new Thread(new RequestProcessor(skt)).start();
            }
            catch (IOException ioEx) {
                if (!this.inService) continue;
                log.error((Object)"IO Exception during UPNP messages listening thread", (Throwable)ioEx);
            }
        }
    }

    private class RequestProcessor
    implements Runnable {
        private Socket client;

        private RequestProcessor(Socket client) {
            this.client = client;
        }

        public void run() {
            try {
                this.client.setSoTimeout(30000);
                InputStream in = this.client.getInputStream();
                OutputStream out = this.client.getOutputStream();
                int readen = 0;
                StringBuffer data = new StringBuffer();
                byte[] buffer = new byte[256];
                while ((readen = in.read(buffer)) != -1) {
                    data.append(new String(buffer, 0, readen));
                }
                String packet = data.toString();
                if (packet.trim().length() > 0) {
                    HttpResponse resp;
                    if (packet.indexOf(0) != -1) {
                        packet = packet.replace('\u0000', ' ');
                    }
                    if ((resp = new HttpResponse(packet)).getHeader().startsWith("NOTIFY")) {
                        String sid = resp.getHTTPHeaderField("SID");
                        InetAddress deviceIp = this.client.getInetAddress();
                        String postURL = resp.getHTTPHeaderField("SID");
                        Subscription subscription = null;
                        if (sid != null && postURL != null) {
                            subscription = ServicesEventing.this.lookupSubscriber(sid, deviceIp);
                        }
                        if (subscription != null) {
                            out.write("HTTP/1.1 200 OK\r\n".getBytes());
                        } else {
                            out.write("HTTP/1.1 412 Precondition Failed\r\n".getBytes());
                        }
                        out.flush();
                        in.close();
                        out.close();
                        this.client.close();
                        if (subscription != null) {
                            SAXParserFactory saxParFact = SAXParserFactory.newInstance();
                            saxParFact.setValidating(false);
                            saxParFact.setNamespaceAware(true);
                            SAXParser parser = saxParFact.newSAXParser();
                            ServiceEventMessageParser msgParser = new ServiceEventMessageParser();
                            StringReader stringReader = new StringReader(resp.getBody());
                            InputSource src = new InputSource(stringReader);
                            parser.parse(src, (DefaultHandler)msgParser);
                            Map changedStateVars = msgParser.getChangedStateVars();
                            Iterator i = changedStateVars.keySet().iterator();
                            while (i.hasNext()) {
                                String stateVarName = (String)i.next();
                                String stateVarNewVal = (String)changedStateVars.get(stateVarName);
                                subscription.handler.handleStateVariableEvent(stateVarName, stateVarNewVal);
                            }
                        }
                    }
                }
            }
            catch (IOException ioEx) {
                log.error((Object)"IO Exception during client processing thread", (Throwable)ioEx);
            }
            catch (Exception ex) {
                log.error((Object)"Unexpected error during client processing thread", (Throwable)ex);
            }
        }
    }

    private class Subscription {
        private String serviceType = null;
        private String serviceId = null;
        private URL serviceURL = null;
        private ServiceEventHandler handler = null;
        private String SID = null;
        private InetAddress deviceIp = null;

        private Subscription() {
        }
    }
}

