/*
 * Decompiled with CFR 0.152.
 */
package ibis.io.rewriter;

import ibis.compile.ASMRepository;
import ibis.io.rewriter.ASMIOGenerator;
import ibis.io.rewriter.ASMRewriterConstants;
import ibis.io.rewriter.ASMSerializationInfo;
import java.util.Collections;
import java.util.List;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

class ASMCodeGenerator
implements ASMRewriterConstants,
Opcodes {
    protected ClassNode clazz;
    protected ClassNode super_class;
    protected boolean super_is_serializable;
    protected boolean super_is_ibis_serializable;
    protected boolean super_has_ibis_constructor;
    protected boolean is_externalizable;
    protected boolean has_serial_persistent_fields;
    protected boolean has_final_fields;
    protected List<FieldNode> fields;
    protected List<MethodNode> methods;
    protected List<String> interfaces;
    protected ASMIOGenerator generator;
    private boolean is_abstract;

    public static ClassNode lookupClass(String name) {
        try {
            return ASMRepository.findClass((String)name);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Warning: class " + name + " not found");
            e.printStackTrace(System.err);
            return null;
        }
    }

    public static String getPackageName(String name) {
        if (name.contains("/")) {
            return name.substring(0, name.lastIndexOf(47));
        }
        if (name.contains(".")) {
            return name.substring(0, name.lastIndexOf(46));
        }
        return "";
    }

    ASMCodeGenerator(ASMIOGenerator generator, ClassNode cl) {
        this.generator = generator;
        this.clazz = cl;
        if (this.clazz.superName != null) {
            this.super_class = ASMCodeGenerator.lookupClass(this.clazz.superName);
        }
        this.methods = this.clazz.methods;
        this.fields = this.clazz.fields;
        this.interfaces = this.clazz.interfaces;
        this.versionUID();
        Collections.sort(this.fields, ASMSerializationInfo.fieldComparator);
        this.super_is_serializable = ASMSerializationInfo.isSerializable(this.super_class);
        this.is_externalizable = ASMSerializationInfo.isExternalizable(cl);
        this.is_abstract = (cl.access & 0x400) == 1024;
        this.super_is_ibis_serializable = ASMSerializationInfo.isIbisSerializable(this.super_class);
        this.super_has_ibis_constructor = ASMSerializationInfo.hasIbisConstructor(this.super_class);
        this.has_serial_persistent_fields = ASMSerializationInfo.hasSerialPersistentFields(this.fields);
        this.has_final_fields = ASMSerializationInfo.hasFinalFields(this.fields);
    }

    private void versionUID() {
        for (FieldNode f : this.fields) {
            if (!f.name.equals("serialVersionUID") || (f.access & 0x18) != 24) continue;
            return;
        }
        long uid = 0L;
        uid = ASMSerializationInfo.getSerialVersionUID(this.clazz.name, this.clazz);
        if (uid != 0L) {
            this.fields.add(new FieldNode(26, "serialVersionUID", "J", null, (Object)new Long(uid)));
        }
    }

    private MethodInsnNode createGeneratedWriteObjectInvocation(String name, int invmode) {
        return new MethodInsnNode(invmode, name, "generated_WriteObject", "(Libis/io/IbisSerializationOutputStream;)V");
    }

    private MethodInsnNode createGeneratedDefaultReadObjectInvocation(String cl, int invmode) {
        return new MethodInsnNode(invmode, cl, "generated_DefaultReadObject", "(Libis/io/IbisSerializationInputStream;I)V");
    }

    private MethodInsnNode createInitInvocation(ClassNode cl) {
        return new MethodInsnNode(183, cl.name, "<init>", "(Libis/io/IbisSerializationInputStream;)V");
    }

    private MethodInsnNode createGeneratedDefaultWriteObjectInvocation(String name) {
        return new MethodInsnNode(183, name, "generated_DefaultWriteObject", "(Libis/io/IbisSerializationOutputStream;I)V");
    }

    private MethodInsnNode createWriteObjectInvocation() {
        return new MethodInsnNode(183, this.clazz.name, "writeObject", "(Ljava/io/ObjectOutputStream;)V");
    }

    private int getClassDepth(ClassNode cl) {
        if (!ASMSerializationInfo.isSerializable(cl)) {
            return 0;
        }
        return 1 + this.getClassDepth(ASMCodeGenerator.lookupClass(cl.superName));
    }

    void generateEmptyMethods() {
        if (this.generator.isVerbose()) {
            System.out.println("  Generating empty methods for class : " + this.clazz.name);
            System.out.println("    " + this.clazz.name + " implements java.io.Serializable -> adding " + "ibis/io/Serializable");
        }
        this.interfaces.add("ibis/io/Serializable");
        InsnList il = new InsnList();
        il.add((AbstractInsnNode)new InsnNode(177));
        int flags = 1 | ((this.clazz.access & 0x10) == 16 ? 16 : 0);
        MethodNode writeMethod = new MethodNode(262144, flags, "generated_WriteObject", "(Libis/io/IbisSerializationOutputStream;)V", "(Libis/io/IbisSerializationOutputStream;)V", new String[]{"java/io/IOException"});
        writeMethod.instructions = il;
        this.methods.add(writeMethod);
        il = new InsnList();
        il.add((AbstractInsnNode)new InsnNode(177));
        MethodNode defaultWriteMethod = new MethodNode(262144, flags, "generated_DefaultWriteObject", "(Libis/io/IbisSerializationOutputStream;I)V", "(Libis/io/IbisSerializationOutputStream;I)V", new String[]{"java/io/IOException"});
        defaultWriteMethod.instructions = il;
        this.methods.add(defaultWriteMethod);
        il = new InsnList();
        il.add((AbstractInsnNode)new InsnNode(177));
        MethodNode defaultReadMethod = new MethodNode(262144, flags, "generated_DefaultReadObject", "(Libis/io/IbisSerializationInputStream;I)V", "(Libis/io/IbisSerializationInputStream;I)V", new String[]{"java/io/IOException", "java/lang/ClassNotFoundException"});
        defaultReadMethod.instructions = il;
        this.methods.add(defaultReadMethod);
        if (this.is_externalizable || !this.super_is_serializable || this.generator.forceGeneratedCalls() || this.super_has_ibis_constructor) {
            il = new InsnList();
            il.add((AbstractInsnNode)new InsnNode(177));
            MethodNode readCons = new MethodNode(262144, 1, "<init>", "(Libis/io/IbisSerializationInputStream;)V", "(Libis/io/IbisSerializationInputStream;)V", new String[]{"java/io/IOException", "java/lang/ClassNotFoundException"});
            readCons.instructions = il;
            this.methods.add(readCons);
        } else if (ASMSerializationInfo.hasReadObject(this.methods)) {
            il = new InsnList();
            il.add((AbstractInsnNode)new InsnNode(177));
            MethodNode readObjectWrapper = new MethodNode(262144, 1, "$readObjectWrapper$", "(Libis/io/IbisSerializationInputStream;)V", "(Libis/io/IbisSerializationInputStream;)V", new String[]{"java/io/IOException", "java/lang/ClassNotFoundException"});
            readObjectWrapper.instructions = il;
            this.methods.add(readObjectWrapper);
        }
        this.generator.replace(this.clazz, this.clazz);
    }

    private InsnList writeInstructions(FieldNode field) {
        Type field_type = Type.getType((String)field.desc);
        ASMSerializationInfo info = ASMSerializationInfo.getSerializationInfo(field_type);
        InsnList temp = new InsnList();
        temp.add((AbstractInsnNode)new VarInsnNode(25, 1));
        temp.add((AbstractInsnNode)new VarInsnNode(25, 0));
        temp.add((AbstractInsnNode)new FieldInsnNode(180, this.clazz.name, field.name, field.desc));
        temp.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationOutputStream", info.write_name, Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType((String)info.signature)})));
        return temp;
    }

    private InsnList readInstructions(FieldNode field, boolean from_constructor) {
        Type field_type = Type.getType((String)field.desc);
        ASMSerializationInfo info = ASMSerializationInfo.getSerializationInfo(field_type);
        InsnList temp = new InsnList();
        if (from_constructor || (field.access & 0x10) == 0) {
            temp.add((AbstractInsnNode)new VarInsnNode(25, 0));
            temp.add((AbstractInsnNode)new VarInsnNode(25, 1));
            temp.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationInputStream", info.read_name, Type.getMethodDescriptor((Type)Type.getType((String)info.signature), (Type[])new Type[0])));
            if (!info.primitive) {
                temp.add((AbstractInsnNode)new TypeInsnNode(192, field_type.getInternalName()));
            }
            temp.add((AbstractInsnNode)new FieldInsnNode(181, this.clazz.name, field.name, field.desc));
        } else {
            String methodDescr;
            temp.add((AbstractInsnNode)new VarInsnNode(25, 1));
            temp.add((AbstractInsnNode)new VarInsnNode(25, 0));
            temp.add((AbstractInsnNode)new LdcInsnNode((Object)field.name));
            temp.add((AbstractInsnNode)new LdcInsnNode((Object)this.clazz.name.replaceAll("/", ".")));
            if (!info.primitive) {
                temp.add((AbstractInsnNode)new LdcInsnNode((Object)field.desc));
                methodDescr = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{TYPE_OBJECT, TYPE_STRING, TYPE_STRING, TYPE_STRING});
            } else {
                methodDescr = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{TYPE_OBJECT, TYPE_STRING, TYPE_STRING});
            }
            temp.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationInputStream", info.final_read_name, methodDescr));
        }
        return temp;
    }

    private String writeCallName(String name) {
        return "writeArray" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private InsnList writeReferenceField(FieldNode field) {
        Type tp;
        Type field_type = Type.getType((String)field.desc);
        InsnList write_il = new InsnList();
        boolean isfinal = false;
        boolean isarray = false;
        ClassNode field_class = null;
        String basicname = null;
        if (this.generator.isVerbose()) {
            System.out.println("    writing reference field " + field.name + " of type " + field.desc);
        }
        if ((tp = field_type).getSort() == 9) {
            isarray = true;
            tp = tp.getDimensions() > 1 ? Type.getType((String)tp.getDescriptor().substring(1)) : tp.getElementType();
        }
        if (tp.getSort() == 10) {
            field_class = ASMCodeGenerator.lookupClass(tp.getInternalName());
            if (field_class != null && (field_class.access & 0x10) == 16) {
                isfinal = true;
            }
        } else if (isarray) {
            switch (tp.getSort()) {
                case 1: {
                    basicname = "boolean";
                    break;
                }
                case 3: {
                    basicname = "byte";
                    break;
                }
                case 4: {
                    basicname = "short";
                    break;
                }
                case 2: {
                    basicname = "char";
                    break;
                }
                case 5: {
                    basicname = "int";
                    break;
                }
                case 6: {
                    basicname = "float";
                    break;
                }
                case 7: {
                    basicname = "long";
                    break;
                }
                case 8: {
                    basicname = "double";
                }
            }
        }
        if (basicname != null || isfinal && (ASMSerializationInfo.hasIbisConstructor(field_class) || ASMSerializationInfo.isSerializable(field_class) && this.generator.forceGeneratedCalls())) {
            write_il.add((AbstractInsnNode)new InsnNode(1));
            write_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
            write_il.add((AbstractInsnNode)new FieldInsnNode(180, "ibis/io/IbisSerializationOutputStream", "replacer", "Libis/io/Replacer;"));
            LabelNode target = new LabelNode();
            write_il.add((AbstractInsnNode)new JumpInsnNode(165, target));
            write_il.add(this.writeInstructions(field));
            LabelNode end = new LabelNode();
            write_il.add((AbstractInsnNode)new JumpInsnNode(167, end));
            write_il.add((AbstractInsnNode)target);
            write_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
            write_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
            write_il.add((AbstractInsnNode)new FieldInsnNode(180, this.clazz.name, field.name, field.desc));
            if (basicname != null) {
                write_il.add((AbstractInsnNode)new FieldInsnNode(178, "ibis/io/Constants", "TYPE_" + basicname.toUpperCase(), "I"));
                write_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationOutputStream", "writeKnownArrayHeader", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{TYPE_OBJECT, Type.INT_TYPE})));
            } else {
                write_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationOutputStream", "writeKnownObjectHeader", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{TYPE_OBJECT})));
            }
            write_il.add((AbstractInsnNode)new VarInsnNode(54, 2));
            write_il.add((AbstractInsnNode)new VarInsnNode(21, 2));
            write_il.add((AbstractInsnNode)new LdcInsnNode((Object)1));
            target = new LabelNode();
            write_il.add((AbstractInsnNode)new JumpInsnNode(160, target));
            if (isarray) {
                write_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
                write_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
                write_il.add((AbstractInsnNode)new FieldInsnNode(180, this.clazz.name, field.name, field.desc));
                write_il.add((AbstractInsnNode)new InsnNode(190));
                write_il.add((AbstractInsnNode)new InsnNode(89));
                write_il.add((AbstractInsnNode)new VarInsnNode(54, 4));
                write_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationOutputStream", "writeInt", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE})));
                if (basicname != null) {
                    write_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    write_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    write_il.add((AbstractInsnNode)new FieldInsnNode(180, this.clazz.name, field.name, field.desc));
                    write_il.add((AbstractInsnNode)new LdcInsnNode((Object)0));
                    write_il.add((AbstractInsnNode)new VarInsnNode(21, 4));
                    write_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationOutputStream", this.writeCallName(basicname), Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{field_type, Type.INT_TYPE, Type.INT_TYPE})));
                } else {
                    write_il.add((AbstractInsnNode)new LdcInsnNode((Object)0));
                    write_il.add((AbstractInsnNode)new VarInsnNode(54, 3));
                    LabelNode gto = new LabelNode();
                    write_il.add((AbstractInsnNode)new JumpInsnNode(167, gto));
                    LabelNode loop_body_start = new LabelNode();
                    write_il.add((AbstractInsnNode)loop_body_start);
                    write_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    write_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    write_il.add((AbstractInsnNode)new FieldInsnNode(180, this.clazz.name, field.name, field.desc));
                    write_il.add((AbstractInsnNode)new VarInsnNode(21, 3));
                    write_il.add((AbstractInsnNode)new InsnNode(50));
                    write_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationOutputStream", "writeKnownObjectHeader", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{TYPE_OBJECT})));
                    write_il.add((AbstractInsnNode)new VarInsnNode(54, 2));
                    write_il.add((AbstractInsnNode)new VarInsnNode(21, 2));
                    write_il.add((AbstractInsnNode)new LdcInsnNode((Object)1));
                    LabelNode ifcmp1 = new LabelNode();
                    write_il.add((AbstractInsnNode)new JumpInsnNode(160, ifcmp1));
                    write_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    write_il.add((AbstractInsnNode)new FieldInsnNode(180, this.clazz.name, field.name, field.desc));
                    write_il.add((AbstractInsnNode)new VarInsnNode(21, 3));
                    write_il.add((AbstractInsnNode)new InsnNode(50));
                    write_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    write_il.add((AbstractInsnNode)this.createGeneratedWriteObjectInvocation(field_class.name, 182));
                    write_il.add((AbstractInsnNode)ifcmp1);
                    write_il.add((AbstractInsnNode)new IincInsnNode(3, 1));
                    write_il.add((AbstractInsnNode)gto);
                    write_il.add((AbstractInsnNode)new VarInsnNode(21, 4));
                    write_il.add((AbstractInsnNode)new VarInsnNode(21, 3));
                    write_il.add((AbstractInsnNode)new JumpInsnNode(163, loop_body_start));
                }
            } else {
                write_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
                write_il.add((AbstractInsnNode)new FieldInsnNode(180, this.clazz.name, field.name, field.desc));
                write_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
                write_il.add((AbstractInsnNode)this.createGeneratedWriteObjectInvocation(field_class.name, 182));
            }
            write_il.add((AbstractInsnNode)target);
            write_il.add((AbstractInsnNode)end);
        } else {
            write_il.add(this.writeInstructions(field));
        }
        return write_il;
    }

    private InsnList serialPersistentWrites(MethodNode write_gen) {
        String serialPersistentFieldsSig = "[Ljava/io/ObjectStreamField;";
        InsnList write_il = new InsnList();
        int[] case_values = new int[]{66, 67, 68, 70, 73, 74, 83, 90};
        LabelNode[] case_handles = new LabelNode[case_values.length];
        for (int i = 0; i < case_handles.length; ++i) {
            case_handles[i] = new LabelNode();
        }
        LabelNode gotoTarget = new LabelNode();
        LabelNode defaultHandle = new LabelNode();
        write_il.add((AbstractInsnNode)new LdcInsnNode((Object)0));
        write_il.add((AbstractInsnNode)new VarInsnNode(54, 2));
        LabelNode gto = new LabelNode();
        write_il.add((AbstractInsnNode)new JumpInsnNode(167, gto));
        LabelNode loop_body_start = new LabelNode();
        write_il.add((AbstractInsnNode)loop_body_start);
        write_il.add((AbstractInsnNode)new FieldInsnNode(178, this.clazz.name, "serialPersistentFields", serialPersistentFieldsSig));
        write_il.add((AbstractInsnNode)new VarInsnNode(21, 2));
        write_il.add((AbstractInsnNode)new InsnNode(50));
        write_il.add((AbstractInsnNode)new MethodInsnNode(182, "java/io/ObjectStreamField", "getName", Type.getMethodDescriptor((Type)TYPE_STRING, (Type[])new Type[0])));
        write_il.add((AbstractInsnNode)new VarInsnNode(58, 3));
        LabelNode begin_try = new LabelNode();
        write_il.add((AbstractInsnNode)begin_try);
        write_il.add((AbstractInsnNode)new LdcInsnNode((Object)this.clazz.name.replaceAll("/", ".")));
        write_il.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Class", "forName", Type.getMethodDescriptor((Type)TYPE_CLASS, (Type[])new Type[]{TYPE_STRING})));
        write_il.add((AbstractInsnNode)new VarInsnNode(25, 3));
        write_il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Class", "getDeclaredField", Type.getMethodDescriptor((Type)Type.getObjectType((String)"java/lang/reflect/Field"), (Type[])new Type[]{TYPE_STRING})));
        write_il.add((AbstractInsnNode)new VarInsnNode(58, 4));
        write_il.add((AbstractInsnNode)new FieldInsnNode(178, this.clazz.name, "serialPersistentFields", serialPersistentFieldsSig));
        write_il.add((AbstractInsnNode)new VarInsnNode(21, 2));
        write_il.add((AbstractInsnNode)new InsnNode(50));
        write_il.add((AbstractInsnNode)new MethodInsnNode(182, "java/io/ObjectStreamField", "getTypeCode", Type.getMethodDescriptor((Type)Type.CHAR_TYPE, (Type[])new Type[0])));
        write_il.add((AbstractInsnNode)new LookupSwitchInsnNode(defaultHandle, case_values, case_handles));
        write_il.add((AbstractInsnNode)case_handles[0]);
        write_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
        write_il.add((AbstractInsnNode)new VarInsnNode(25, 4));
        write_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
        write_il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/reflect/Field", "getBoolean", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{TYPE_OBJECT})));
        write_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationOutputStream", "writeBoolean", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.BOOLEAN_TYPE})));
        write_il.add((AbstractInsnNode)new JumpInsnNode(167, gotoTarget));
        write_il.add((AbstractInsnNode)case_handles[1]);
        write_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
        write_il.add((AbstractInsnNode)new VarInsnNode(25, 4));
        write_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
        write_il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/reflect/Field", "getChar", Type.getMethodDescriptor((Type)Type.CHAR_TYPE, (Type[])new Type[]{TYPE_OBJECT})));
        write_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationOutputStream", "writeChar", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.CHAR_TYPE})));
        write_il.add((AbstractInsnNode)new JumpInsnNode(167, gotoTarget));
        write_il.add((AbstractInsnNode)case_handles[2]);
        write_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
        write_il.add((AbstractInsnNode)new VarInsnNode(25, 4));
        write_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
        write_il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/reflect/Field", "getDouble", Type.getMethodDescriptor((Type)Type.DOUBLE_TYPE, (Type[])new Type[]{TYPE_OBJECT})));
        write_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationOutputStream", "writeDouble", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.DOUBLE_TYPE})));
        write_il.add((AbstractInsnNode)new JumpInsnNode(167, gotoTarget));
        write_il.add((AbstractInsnNode)case_handles[3]);
        write_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
        write_il.add((AbstractInsnNode)new VarInsnNode(25, 4));
        write_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
        write_il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/reflect/Field", "getFloat", Type.getMethodDescriptor((Type)Type.FLOAT_TYPE, (Type[])new Type[]{TYPE_OBJECT})));
        write_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationOutputStream", "writeFloat", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.FLOAT_TYPE})));
        write_il.add((AbstractInsnNode)new JumpInsnNode(167, gotoTarget));
        write_il.add((AbstractInsnNode)case_handles[4]);
        write_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
        write_il.add((AbstractInsnNode)new VarInsnNode(25, 4));
        write_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
        write_il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/reflect/Field", "getInt", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{TYPE_OBJECT})));
        write_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationOutputStream", "writeInt", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE})));
        write_il.add((AbstractInsnNode)new JumpInsnNode(167, gotoTarget));
        write_il.add((AbstractInsnNode)case_handles[5]);
        write_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
        write_il.add((AbstractInsnNode)new VarInsnNode(25, 4));
        write_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
        write_il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/reflect/Field", "getLong", Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[]{TYPE_OBJECT})));
        write_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationOutputStream", "writeLong", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.LONG_TYPE})));
        write_il.add((AbstractInsnNode)new JumpInsnNode(167, gotoTarget));
        write_il.add((AbstractInsnNode)case_handles[6]);
        write_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
        write_il.add((AbstractInsnNode)new VarInsnNode(25, 4));
        write_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
        write_il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/reflect/Field", "getShort", Type.getMethodDescriptor((Type)Type.SHORT_TYPE, (Type[])new Type[]{TYPE_OBJECT})));
        write_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationOutputStream", "writeShort", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.SHORT_TYPE})));
        write_il.add((AbstractInsnNode)new JumpInsnNode(167, gotoTarget));
        write_il.add((AbstractInsnNode)case_handles[7]);
        write_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
        write_il.add((AbstractInsnNode)new VarInsnNode(25, 4));
        write_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
        write_il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/reflect/Field", "getBoolean", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{TYPE_OBJECT})));
        write_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationOutputStream", "writeBoolean", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.BOOLEAN_TYPE})));
        write_il.add((AbstractInsnNode)new JumpInsnNode(167, gotoTarget));
        write_il.add((AbstractInsnNode)defaultHandle);
        write_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
        write_il.add((AbstractInsnNode)new VarInsnNode(25, 4));
        write_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
        write_il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/reflect/Field", "get", Type.getMethodDescriptor((Type)TYPE_OBJECT, (Type[])new Type[]{TYPE_OBJECT})));
        write_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationOutputStream", "writeObject", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{TYPE_OBJECT})));
        write_il.add((AbstractInsnNode)new JumpInsnNode(167, gotoTarget));
        LabelNode handler = new LabelNode();
        write_il.add((AbstractInsnNode)handler);
        write_il.add((AbstractInsnNode)new VarInsnNode(58, 5));
        write_il.add((AbstractInsnNode)new TypeInsnNode(187, "java/io/IOException"));
        write_il.add((AbstractInsnNode)new InsnNode(89));
        write_il.add((AbstractInsnNode)new TypeInsnNode(187, "java/lang/StringBuffer"));
        write_il.add((AbstractInsnNode)new InsnNode(89));
        write_il.add((AbstractInsnNode)new MethodInsnNode(183, "java/lang/StringBuffer", "<init>", "()V"));
        write_il.add((AbstractInsnNode)new LdcInsnNode((Object)"Could not write field "));
        write_il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/StringBuffer", "append", Type.getMethodDescriptor((Type)TYPE_STRINGBUFFER, (Type[])new Type[]{TYPE_STRING})));
        write_il.add((AbstractInsnNode)new VarInsnNode(25, 3));
        write_il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/StringBuffer", "append", Type.getMethodDescriptor((Type)TYPE_STRINGBUFFER, (Type[])new Type[]{TYPE_STRING})));
        write_il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/StringBuffer", "toString", Type.getMethodDescriptor((Type)TYPE_STRING, (Type[])new Type[0])));
        write_il.add((AbstractInsnNode)new MethodInsnNode(183, "java/io/IOException", "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{TYPE_STRING})));
        write_il.add((AbstractInsnNode)new VarInsnNode(25, 5));
        write_il.add((AbstractInsnNode)new MethodInsnNode(182, "java/io/IOException", "initCause", Type.getMethodDescriptor((Type)TYPE_THROWABLE, (Type[])new Type[]{TYPE_THROWABLE})));
        write_il.add((AbstractInsnNode)new InsnNode(191));
        write_il.add((AbstractInsnNode)gotoTarget);
        write_il.add((AbstractInsnNode)new IincInsnNode(2, 1));
        write_il.add((AbstractInsnNode)gto);
        write_il.add((AbstractInsnNode)new VarInsnNode(21, 2));
        write_il.add((AbstractInsnNode)new FieldInsnNode(178, this.clazz.name, "serialPersistentFields", serialPersistentFieldsSig));
        write_il.add((AbstractInsnNode)new InsnNode(190));
        write_il.add((AbstractInsnNode)new JumpInsnNode(161, loop_body_start));
        write_gen.tryCatchBlocks.add(new TryCatchBlockNode(begin_try, handler, handler, "java/lang/Throwable"));
        return write_il;
    }

    private InsnList generateDefaultWrites(MethodNode write_gen) {
        Type field_type;
        InsnList write_il = new InsnList();
        if (this.has_serial_persistent_fields) {
            return this.serialPersistentWrites(write_gen);
        }
        for (FieldNode field : this.fields) {
            if ((field.access & 0x88) != 0 || (field_type = Type.getType((String)field.desc)).getSort() == 9 || field_type.getSort() == 10) continue;
            if (this.generator.isVerbose()) {
                System.out.println("    writing basic field " + field.name + " of type " + field.desc);
            }
            write_il.add(this.writeInstructions(field));
        }
        for (FieldNode field : this.fields) {
            if ((field.access & 0x88) != 0 || (field_type = Type.getType((String)field.desc)).getSort() != 9 && field_type.getSort() != 10) continue;
            if (this.generator.isVerbose()) {
                System.out.println("    writing field " + field.name + " of type " + field.desc);
            }
            if (!field.desc.equals("java/lang/String") && !field.desc.equals("java/lang/Class")) {
                write_il.add(this.writeReferenceField(field));
                continue;
            }
            write_il.add(this.writeInstructions(field));
        }
        return write_il;
    }

    private String readCallName(String name) {
        return "readArray" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private InsnList readReferenceField(FieldNode field, boolean from_constructor) {
        Type tp;
        Type field_type = Type.getType((String)field.desc);
        InsnList read_il = new InsnList();
        boolean isfinal = false;
        boolean isarray = false;
        ClassNode field_class = null;
        String basicname = null;
        if (this.generator.isVerbose()) {
            System.out.println("    reading reference field " + field.name + " of type " + field.desc);
        }
        if ((tp = field_type).getSort() == 9) {
            isarray = true;
            tp = tp.getDimensions() > 1 ? Type.getType((String)tp.getDescriptor().substring(1)) : tp.getElementType();
        }
        if (tp.getSort() == 10) {
            field_class = ASMCodeGenerator.lookupClass(tp.getInternalName());
            if (field_class != null && (field_class.access & 0x10) == 16) {
                isfinal = true;
            }
        } else if (isarray) {
            switch (tp.getSort()) {
                case 1: {
                    basicname = "boolean";
                    break;
                }
                case 3: {
                    basicname = "byte";
                    break;
                }
                case 4: {
                    basicname = "short";
                    break;
                }
                case 2: {
                    basicname = "char";
                    break;
                }
                case 5: {
                    basicname = "int";
                    break;
                }
                case 6: {
                    basicname = "float";
                    break;
                }
                case 7: {
                    basicname = "long";
                    break;
                }
                case 8: {
                    basicname = "double";
                }
            }
        }
        if (basicname != null || isfinal && (ASMSerializationInfo.hasIbisConstructor(field_class) || ASMSerializationInfo.isSerializable(field_class) && this.generator.forceGeneratedCalls())) {
            read_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
            read_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationInputStream", "readKnownTypeHeader", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0])));
            read_il.add((AbstractInsnNode)new VarInsnNode(54, 2));
            read_il.add((AbstractInsnNode)new VarInsnNode(21, 2));
            read_il.add((AbstractInsnNode)new LdcInsnNode((Object)-1));
            LabelNode ifcmp = new LabelNode();
            read_il.add((AbstractInsnNode)new JumpInsnNode(160, ifcmp));
            if (isarray) {
                if (basicname != null) {
                    String callname = this.readCallName(basicname);
                    read_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    read_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    read_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationInputStream", callname, Type.getMethodDescriptor((Type)field_type, (Type[])new Type[0])));
                    read_il.add((AbstractInsnNode)new FieldInsnNode(181, this.clazz.name, field.name, field.desc));
                } else {
                    Type el_type = field_type.getElementType();
                    read_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    read_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    read_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationInputStream", "readInt", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0])));
                    read_il.add((AbstractInsnNode)new InsnNode(89));
                    read_il.add((AbstractInsnNode)new VarInsnNode(54, 3));
                    read_il.add((AbstractInsnNode)new TypeInsnNode(189, el_type.getInternalName()));
                    read_il.add((AbstractInsnNode)new FieldInsnNode(181, this.clazz.name, field.name, field.desc));
                    read_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    read_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    read_il.add((AbstractInsnNode)new FieldInsnNode(180, this.clazz.name, field.name, field.desc));
                    read_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationInputStream", "addObjectToCycleCheck", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{TYPE_OBJECT})));
                    read_il.add((AbstractInsnNode)new LdcInsnNode((Object)0));
                    read_il.add((AbstractInsnNode)new VarInsnNode(54, 4));
                    LabelNode gto1 = new LabelNode();
                    read_il.add((AbstractInsnNode)new JumpInsnNode(167, gto1));
                    LabelNode loop_body_start = new LabelNode();
                    read_il.add((AbstractInsnNode)loop_body_start);
                    read_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    read_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationInputStream", "readKnownTypeHeader", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0])));
                    read_il.add((AbstractInsnNode)new VarInsnNode(54, 2));
                    read_il.add((AbstractInsnNode)new VarInsnNode(21, 2));
                    read_il.add((AbstractInsnNode)new LdcInsnNode((Object)-1));
                    LabelNode ifcmp1 = new LabelNode();
                    read_il.add((AbstractInsnNode)new JumpInsnNode(160, ifcmp1));
                    read_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    read_il.add((AbstractInsnNode)new FieldInsnNode(180, this.clazz.name, field.name, field.desc));
                    read_il.add((AbstractInsnNode)new VarInsnNode(21, 4));
                    read_il.add((AbstractInsnNode)new TypeInsnNode(187, el_type.getInternalName()));
                    read_il.add((AbstractInsnNode)new InsnNode(89));
                    read_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    read_il.add((AbstractInsnNode)new MethodInsnNode(183, field_class.name, "<init>", "(Libis/io/IbisSerializationInputStream;)V"));
                    read_il.add((AbstractInsnNode)new InsnNode(83));
                    LabelNode gto2 = new LabelNode();
                    read_il.add((AbstractInsnNode)new JumpInsnNode(167, gto2));
                    read_il.add((AbstractInsnNode)ifcmp1);
                    read_il.add((AbstractInsnNode)new VarInsnNode(21, 2));
                    read_il.add((AbstractInsnNode)new LdcInsnNode((Object)0));
                    LabelNode ifcmpeq2 = new LabelNode();
                    read_il.add((AbstractInsnNode)new JumpInsnNode(159, ifcmpeq2));
                    read_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    read_il.add((AbstractInsnNode)new FieldInsnNode(180, this.clazz.name, field.name, field.desc));
                    read_il.add((AbstractInsnNode)new VarInsnNode(21, 4));
                    read_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    read_il.add((AbstractInsnNode)new VarInsnNode(21, 2));
                    read_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationInputStream", "getObjectFromCycleCheck", Type.getMethodDescriptor((Type)TYPE_OBJECT, (Type[])new Type[]{Type.INT_TYPE})));
                    read_il.add((AbstractInsnNode)new TypeInsnNode(192, el_type.getInternalName()));
                    read_il.add((AbstractInsnNode)new InsnNode(83));
                    read_il.add((AbstractInsnNode)ifcmpeq2);
                    read_il.add((AbstractInsnNode)gto2);
                    read_il.add((AbstractInsnNode)new IincInsnNode(4, 1));
                    read_il.add((AbstractInsnNode)gto1);
                    read_il.add((AbstractInsnNode)new VarInsnNode(21, 3));
                    read_il.add((AbstractInsnNode)new VarInsnNode(21, 4));
                    read_il.add((AbstractInsnNode)new JumpInsnNode(163, loop_body_start));
                }
            } else {
                read_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
                read_il.add((AbstractInsnNode)new TypeInsnNode(187, field_type.getInternalName()));
                read_il.add((AbstractInsnNode)new InsnNode(89));
                read_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
                read_il.add((AbstractInsnNode)new MethodInsnNode(183, field_class.name, "<init>", "(Libis/io/IbisSerializationInputStream;)V"));
                read_il.add((AbstractInsnNode)new FieldInsnNode(181, this.clazz.name, field.name, field.desc));
            }
            LabelNode gto = new LabelNode();
            read_il.add((AbstractInsnNode)new JumpInsnNode(167, gto));
            read_il.add((AbstractInsnNode)ifcmp);
            read_il.add((AbstractInsnNode)new VarInsnNode(21, 2));
            read_il.add((AbstractInsnNode)new LdcInsnNode((Object)0));
            LabelNode ifcmpeq = new LabelNode();
            read_il.add((AbstractInsnNode)new JumpInsnNode(159, ifcmpeq));
            read_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
            read_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
            read_il.add((AbstractInsnNode)new VarInsnNode(21, 2));
            read_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationInputStream", "getObjectFromCycleCheck", Type.getMethodDescriptor((Type)TYPE_OBJECT, (Type[])new Type[]{Type.INT_TYPE})));
            read_il.add((AbstractInsnNode)new TypeInsnNode(192, field_type.getInternalName()));
            read_il.add((AbstractInsnNode)new FieldInsnNode(181, this.clazz.name, field.name, field.desc));
            read_il.add((AbstractInsnNode)ifcmpeq);
            read_il.add((AbstractInsnNode)gto);
        } else {
            read_il.add(this.readInstructions(field, from_constructor));
        }
        return read_il;
    }

    private void generateReadField(String tpname, Type tp, InsnList read_il, LabelNode gto, LabelNode caseLabel, boolean from_constructor) {
        read_il.add((AbstractInsnNode)caseLabel);
        if (from_constructor || !this.has_final_fields) {
            read_il.add((AbstractInsnNode)new VarInsnNode(25, 4));
            read_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
            read_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
            if (tpname.equals("")) {
                read_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationInputStream", "readObject", Type.getMethodDescriptor((Type)TYPE_OBJECT, (Type[])new Type[0])));
            } else {
                read_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationInputStream", "read" + tpname, Type.getMethodDescriptor((Type)tp, (Type[])new Type[0])));
            }
            read_il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/reflect/Field", "set" + tpname, Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{TYPE_OBJECT, tp})));
            read_il.add((AbstractInsnNode)new JumpInsnNode(167, gto));
            return;
        }
        read_il.add((AbstractInsnNode)new VarInsnNode(21, 5));
        read_il.add((AbstractInsnNode)new LdcInsnNode((Object)16));
        read_il.add((AbstractInsnNode)new InsnNode(126));
        LabelNode eq = new LabelNode();
        read_il.add((AbstractInsnNode)new JumpInsnNode(153, eq));
        read_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
        read_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
        read_il.add((AbstractInsnNode)new VarInsnNode(25, 3));
        if (tpname.equals("")) {
            read_il.add((AbstractInsnNode)new VarInsnNode(25, 4));
            read_il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/reflect/Field", "getType", Type.getMethodDescriptor((Type)TYPE_CLASS, (Type[])new Type[0])));
            read_il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Class", "getName", Type.getMethodDescriptor((Type)TYPE_STRING, (Type[])new Type[0])));
            read_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationInputStream", "readFieldObject", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{TYPE_OBJECT, TYPE_STRING, TYPE_STRING})));
        } else {
            read_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationInputStream", "readField" + tpname, Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{TYPE_OBJECT, TYPE_STRING})));
        }
        LabelNode gto2 = new LabelNode();
        read_il.add((AbstractInsnNode)new JumpInsnNode(167, gto2));
        read_il.add((AbstractInsnNode)eq);
        read_il.add((AbstractInsnNode)new VarInsnNode(25, 4));
        read_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
        read_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
        if (tpname.equals("")) {
            read_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationInputStream", "readObject", Type.getMethodDescriptor((Type)tp, (Type[])new Type[0])));
        } else {
            read_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationInputStream", "read" + tpname, Type.getMethodDescriptor((Type)tp, (Type[])new Type[0])));
        }
        read_il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/reflect/Field", "set" + tpname, Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{TYPE_OBJECT, tp})));
        read_il.add((AbstractInsnNode)gto2);
        read_il.add((AbstractInsnNode)new JumpInsnNode(167, gto));
    }

    private InsnList serialPersistentReads(boolean from_constructor, MethodNode read_gen) {
        InsnList read_il = new InsnList();
        int[] case_values = new int[]{66, 67, 68, 70, 73, 74, 83, 90};
        String serialPersistentFieldsSig = "[Ljava/io/ObjectStreamField;";
        LabelNode[] case_handles = new LabelNode[case_values.length];
        for (int i = 0; i < case_handles.length; ++i) {
            case_handles[i] = new LabelNode();
        }
        LabelNode gotoTarget = new LabelNode();
        LabelNode defaultHandle = new LabelNode();
        read_il.add((AbstractInsnNode)new LdcInsnNode((Object)0));
        read_il.add((AbstractInsnNode)new VarInsnNode(54, 2));
        LabelNode gto = new LabelNode();
        read_il.add((AbstractInsnNode)new JumpInsnNode(167, gto));
        LabelNode loop_body_start = new LabelNode();
        read_il.add((AbstractInsnNode)loop_body_start);
        read_il.add((AbstractInsnNode)new FieldInsnNode(178, this.clazz.name, "serialPersistentFields", serialPersistentFieldsSig));
        read_il.add((AbstractInsnNode)new VarInsnNode(21, 2));
        read_il.add((AbstractInsnNode)new InsnNode(50));
        read_il.add((AbstractInsnNode)new MethodInsnNode(182, "java/io/ObjectStreamField", "getName", Type.getMethodDescriptor((Type)TYPE_STRING, (Type[])new Type[0])));
        read_il.add((AbstractInsnNode)new VarInsnNode(58, 3));
        LabelNode begin_try = new LabelNode();
        read_il.add((AbstractInsnNode)begin_try);
        read_il.add((AbstractInsnNode)new LdcInsnNode((Object)this.clazz.name.replaceAll("/", ".")));
        read_il.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Class", "forName", Type.getMethodDescriptor((Type)TYPE_CLASS, (Type[])new Type[]{TYPE_STRING})));
        read_il.add((AbstractInsnNode)new VarInsnNode(25, 3));
        read_il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Class", "getDeclaredField", Type.getMethodDescriptor((Type)Type.getObjectType((String)"java/lang/reflect/Field"), (Type[])new Type[]{TYPE_STRING})));
        read_il.add((AbstractInsnNode)new VarInsnNode(58, 4));
        if (!from_constructor && this.has_final_fields) {
            read_il.add((AbstractInsnNode)new VarInsnNode(25, 4));
            read_il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/reflect/Field", "getModifiers", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0])));
            read_il.add((AbstractInsnNode)new VarInsnNode(54, 5));
        }
        read_il.add((AbstractInsnNode)new FieldInsnNode(178, this.clazz.name, "serialPersistentFields", serialPersistentFieldsSig));
        read_il.add((AbstractInsnNode)new VarInsnNode(21, 2));
        read_il.add((AbstractInsnNode)new InsnNode(50));
        read_il.add((AbstractInsnNode)new MethodInsnNode(182, "java/io/ObjectStreamField", "getTypeCode", Type.getMethodDescriptor((Type)Type.CHAR_TYPE, (Type[])new Type[0])));
        read_il.add((AbstractInsnNode)new LookupSwitchInsnNode(defaultHandle, case_values, case_handles));
        this.generateReadField("Byte", Type.BYTE_TYPE, read_il, gotoTarget, case_handles[0], from_constructor);
        this.generateReadField("Char", Type.CHAR_TYPE, read_il, gotoTarget, case_handles[1], from_constructor);
        this.generateReadField("Double", Type.DOUBLE_TYPE, read_il, gotoTarget, case_handles[2], from_constructor);
        this.generateReadField("Float", Type.FLOAT_TYPE, read_il, gotoTarget, case_handles[3], from_constructor);
        this.generateReadField("Int", Type.INT_TYPE, read_il, gotoTarget, case_handles[4], from_constructor);
        this.generateReadField("Long", Type.LONG_TYPE, read_il, gotoTarget, case_handles[5], from_constructor);
        this.generateReadField("Short", Type.SHORT_TYPE, read_il, gotoTarget, case_handles[6], from_constructor);
        this.generateReadField("Boolean", Type.BOOLEAN_TYPE, read_il, gotoTarget, case_handles[7], from_constructor);
        this.generateReadField("", TYPE_OBJECT, read_il, gotoTarget, defaultHandle, from_constructor);
        LabelNode end_try = new LabelNode();
        read_il.add((AbstractInsnNode)end_try);
        LabelNode handler = new LabelNode();
        read_il.add((AbstractInsnNode)handler);
        read_il.add((AbstractInsnNode)new VarInsnNode(58, 6));
        read_il.add((AbstractInsnNode)new TypeInsnNode(187, "java/io/IOException"));
        read_il.add((AbstractInsnNode)new InsnNode(89));
        read_il.add((AbstractInsnNode)new TypeInsnNode(187, "java/lang/StringBuffer"));
        read_il.add((AbstractInsnNode)new InsnNode(89));
        read_il.add((AbstractInsnNode)new MethodInsnNode(183, "java/lang/StringBuffer", "<init>", "()V"));
        read_il.add((AbstractInsnNode)new LdcInsnNode((Object)"Could not read field "));
        read_il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/StringBuffer", "append", Type.getMethodDescriptor((Type)TYPE_STRINGBUFFER, (Type[])new Type[]{TYPE_STRING})));
        read_il.add((AbstractInsnNode)new VarInsnNode(25, 3));
        read_il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/StringBuffer", "append", Type.getMethodDescriptor((Type)TYPE_STRINGBUFFER, (Type[])new Type[]{TYPE_STRING})));
        read_il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/StringBuffer", "toString", Type.getMethodDescriptor((Type)TYPE_STRING, (Type[])new Type[0])));
        read_il.add((AbstractInsnNode)new MethodInsnNode(183, "java/io/IOException", "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{TYPE_STRING})));
        read_il.add((AbstractInsnNode)new VarInsnNode(25, 6));
        read_il.add((AbstractInsnNode)new MethodInsnNode(182, "java/io/IOException", "initCause", Type.getMethodDescriptor((Type)TYPE_THROWABLE, (Type[])new Type[]{TYPE_THROWABLE})));
        read_il.add((AbstractInsnNode)new InsnNode(191));
        read_il.add((AbstractInsnNode)gotoTarget);
        read_il.add((AbstractInsnNode)new IincInsnNode(2, 1));
        read_il.add((AbstractInsnNode)gto);
        read_il.add((AbstractInsnNode)new VarInsnNode(21, 2));
        read_il.add((AbstractInsnNode)new FieldInsnNode(178, this.clazz.name, "serialPersistentFields", serialPersistentFieldsSig));
        read_il.add((AbstractInsnNode)new InsnNode(190));
        read_il.add((AbstractInsnNode)new JumpInsnNode(161, loop_body_start));
        read_gen.tryCatchBlocks.add(new TryCatchBlockNode(begin_try, end_try, handler, "java/lang/Throwable"));
        return read_il;
    }

    private InsnList generateDefaultReads(boolean from_constructor, MethodNode read_gen) {
        Type field_type;
        InsnList read_il = new InsnList();
        if (this.has_serial_persistent_fields) {
            return this.serialPersistentReads(from_constructor, read_gen);
        }
        for (FieldNode field : this.fields) {
            if ((field.access & 0x88) != 0 || (field_type = Type.getType((String)field.desc)).getSort() == 9 || field_type.getSort() == 10) continue;
            if (this.generator.isVerbose()) {
                System.out.println("    reading basic field " + field.name + " of type " + field.desc);
            }
            read_il.add(this.readInstructions(field, from_constructor));
        }
        for (FieldNode field : this.fields) {
            if ((field.access & 0x88) != 0 || (field_type = Type.getType((String)field.desc)).getSort() != 9 && field_type.getSort() != 10) continue;
            if (this.generator.isVerbose()) {
                System.out.println("    reading field " + field.name + " of type " + field.desc);
            }
            if (!field.desc.equals("java/lang/String") && !field.desc.equals("java/lang/Class")) {
                read_il.add(this.readReferenceField(field, from_constructor));
                continue;
            }
            read_il.add(this.readInstructions(field, from_constructor));
        }
        return read_il;
    }

    private ClassNode generateInstanceGenerator() {
        if (this.generator.isVerbose()) {
            System.out.println("  Generating InstanceGenerator class for " + this.clazz.name);
        }
        String name = this.clazz.name + "_ibis_io_Generator";
        Type class_type = Type.getObjectType((String)this.clazz.name);
        ClassNode iogenGen = new ClassNode();
        iogenGen.version = this.clazz.version;
        iogenGen.access = 49;
        iogenGen.superName = "ibis/io/Generator";
        iogenGen.name = name;
        InsnList il = new InsnList();
        if (!this.is_externalizable && this.super_is_serializable && !this.super_has_ibis_constructor && !this.generator.forceGeneratedCalls()) {
            il.add((AbstractInsnNode)new VarInsnNode(25, 1));
            il.add((AbstractInsnNode)new LdcInsnNode((Object)this.clazz.name.replaceAll("/", ".")));
            il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationInputStream", "create_uninitialized_object", Type.getMethodDescriptor((Type)TYPE_OBJECT, (Type[])new Type[]{TYPE_STRING})));
            il.add((AbstractInsnNode)new TypeInsnNode(192, class_type.getInternalName()));
            il.add((AbstractInsnNode)new VarInsnNode(58, 2));
            il.add((AbstractInsnNode)new VarInsnNode(25, 1));
            il.add((AbstractInsnNode)new VarInsnNode(25, 2));
            il.add((AbstractInsnNode)new LdcInsnNode((Object)this.clazz.superName.replaceAll("/", ".")));
            il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationInputStream", "readSerializableObject", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{TYPE_OBJECT, TYPE_STRING})));
            if (ASMSerializationInfo.hasReadObject(this.methods)) {
                il.add((AbstractInsnNode)new VarInsnNode(25, 2));
                il.add((AbstractInsnNode)new VarInsnNode(25, 1));
                il.add((AbstractInsnNode)new MethodInsnNode(182, this.clazz.name, "$readObjectWrapper$", "(Libis/io/IbisSerializationInputStream;)V"));
            } else {
                int dpth = this.getClassDepth(this.clazz);
                il.add((AbstractInsnNode)new VarInsnNode(25, 2));
                il.add((AbstractInsnNode)new VarInsnNode(25, 1));
                il.add((AbstractInsnNode)new LdcInsnNode((Object)dpth));
                il.add((AbstractInsnNode)new MethodInsnNode(182, this.clazz.name, "generated_DefaultReadObject", "(Libis/io/IbisSerializationInputStream;I)V"));
            }
            il.add((AbstractInsnNode)new VarInsnNode(25, 2));
        } else {
            il.add((AbstractInsnNode)new TypeInsnNode(187, this.clazz.name));
            il.add((AbstractInsnNode)new InsnNode(89));
            il.add((AbstractInsnNode)new VarInsnNode(25, 1));
            il.add((AbstractInsnNode)this.createInitInvocation(this.clazz));
        }
        il.add((AbstractInsnNode)new InsnNode(176));
        MethodNode method = new MethodNode(262144, 17, "generated_newInstance", Type.getMethodDescriptor((Type)TYPE_OBJECT, (Type[])new Type[]{TYPE_IBIS_IO_INPUT}), null, new String[]{"java/io/IOException", "java/lang/ClassNotFoundException"});
        method.instructions = il;
        iogenGen.methods.add(method);
        il = new InsnList();
        il.add((AbstractInsnNode)new VarInsnNode(25, 0));
        il.add((AbstractInsnNode)new MethodInsnNode(183, "ibis/io/Generator", "<init>", "()V"));
        il.add((AbstractInsnNode)new InsnNode(177));
        method = new MethodNode(262144, 1, "<init>", "()V", null, new String[0]);
        method.instructions = il;
        iogenGen.methods.add(method);
        return iogenGen;
    }

    void generateCode() {
        if (this.generator.isVerbose()) {
            System.out.println("  Generating method code class for class : " + this.clazz.name);
            System.out.println("    Number of fields " + this.fields.size());
        }
        int dpth = this.getClassDepth(this.clazz);
        this.fillInGeneratedDefaultWriteObjectMethod(dpth);
        this.fillInGeneratedDefaultReadObjectMethod(dpth);
        this.fillInGeneratedWriteObjectMethod(dpth);
        this.fillInGeneratedReadObjectMethod(dpth);
        ASMRepository.removeClass((String)this.clazz.name);
        ASMRepository.addClass((ClassNode)this.clazz);
        ClassNode instgen = null;
        if (!this.is_abstract) {
            instgen = this.generateInstanceGenerator();
            ASMRepository.addClass((ClassNode)instgen);
        }
        this.generator.markRewritten(this.clazz, instgen);
    }

    private void fillInGeneratedReadObjectMethod(int dpth) {
        MethodNode mgen = null;
        InsnList read_il = null;
        if (this.is_externalizable || this.super_has_ibis_constructor || !this.super_is_serializable || this.generator.forceGeneratedCalls()) {
            read_il = new InsnList();
            if (this.is_externalizable) {
                read_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
                read_il.add((AbstractInsnNode)new MethodInsnNode(183, this.clazz.name, "<init>", "()V"));
            } else if (!this.super_is_serializable) {
                read_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
                read_il.add((AbstractInsnNode)new MethodInsnNode(183, this.clazz.superName, "<init>", "()V"));
            } else {
                read_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
                read_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
                read_il.add((AbstractInsnNode)new MethodInsnNode(183, this.clazz.superName, "<init>", "(Libis/io/IbisSerializationInputStream;)V"));
            }
            if (this.is_externalizable || !this.super_is_serializable) {
                read_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
                read_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
                read_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationInputStream", "addObjectToCycleCheck", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{TYPE_OBJECT})));
            }
            mgen = ASMSerializationInfo.findMethod(this.methods, "<init>", "(Libis/io/IbisSerializationInputStream;)V");
        } else if (ASMSerializationInfo.hasReadObject(this.methods)) {
            mgen = ASMSerializationInfo.findMethod(this.methods, "$readObjectWrapper$", "(Libis/io/IbisSerializationInputStream;)V");
            read_il = new InsnList();
        }
        if (read_il != null) {
            if (this.is_externalizable || ASMSerializationInfo.hasReadObject(this.methods)) {
                read_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
                read_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
                read_il.add((AbstractInsnNode)new LdcInsnNode((Object)dpth));
                read_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationInputStream", "push_current_object", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{TYPE_OBJECT, Type.INT_TYPE})));
                read_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
                read_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
                read_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationInputStream", "getJavaObjectInputStream", Type.getMethodDescriptor((Type)TYPE_JAVA_IO_OBJECTINPUTSTREAM, (Type[])new Type[0])));
                if (this.is_externalizable) {
                    read_il.add((AbstractInsnNode)new MethodInsnNode(182, this.clazz.name, "readExternal", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{TYPE_JAVA_IO_OBJECTINPUT})));
                } else {
                    read_il.add((AbstractInsnNode)new MethodInsnNode(183, this.clazz.name, "readObject", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{TYPE_JAVA_IO_OBJECTINPUTSTREAM})));
                }
                read_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
                read_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationInputStream", "pop_current_object", "()V"));
            } else {
                read_il.add(this.generateDefaultReads(true, mgen));
            }
            read_il.add(mgen.instructions);
            mgen.instructions = read_il;
        }
    }

    private void fillInGeneratedWriteObjectMethod(int dpth) {
        InsnList write_il = new InsnList();
        MethodNode write_gen = ASMSerializationInfo.findMethod(this.methods, "generated_WriteObject", "(Libis/io/IbisSerializationOutputStream;)V");
        if (!this.is_externalizable) {
            if (this.super_is_ibis_serializable || this.generator.forceGeneratedCalls() && this.super_is_serializable) {
                write_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
                write_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
                write_il.add((AbstractInsnNode)this.createGeneratedWriteObjectInvocation(this.clazz.superName, 183));
            } else if (this.super_is_serializable) {
                write_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
                write_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
                write_il.add((AbstractInsnNode)new LdcInsnNode((Object)this.clazz.superName.replaceAll("/", ".")));
                write_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationOutputStream", "writeSerializableObject", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{TYPE_OBJECT, TYPE_STRING})));
            }
        }
        if (this.is_externalizable || ASMSerializationInfo.hasWriteObject(this.methods)) {
            write_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
            write_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
            write_il.add((AbstractInsnNode)new LdcInsnNode((Object)dpth));
            write_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationOutputStream", "push_current_object", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{TYPE_OBJECT, Type.INT_TYPE})));
            write_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
            write_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
            write_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationOutputStream", "getJavaObjectOutputStream", Type.getMethodDescriptor((Type)TYPE_JAVA_IO_OBJECTOUTPUTSTREAM, (Type[])new Type[0])));
            if (this.is_externalizable) {
                write_il.add((AbstractInsnNode)new MethodInsnNode(182, this.clazz.name, "writeExternal", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{TYPE_JAVA_IO_OBJECTOUTPUT})));
            } else {
                write_il.add((AbstractInsnNode)this.createWriteObjectInvocation());
            }
            write_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
            write_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationOutputStream", "pop_current_object", "()V"));
        } else {
            write_il.add(this.generateDefaultWrites(write_gen));
        }
        write_il.add(write_gen.instructions);
        write_gen.instructions = write_il;
    }

    private void fillInGeneratedDefaultWriteObjectMethod(int dpth) {
        MethodNode write_gen = ASMSerializationInfo.findMethod(this.methods, "generated_DefaultWriteObject", "(Libis/io/IbisSerializationOutputStream;I)V");
        InsnList write_il = new InsnList();
        LabelNode end = new LabelNode();
        write_il.add((AbstractInsnNode)new VarInsnNode(21, 2));
        write_il.add((AbstractInsnNode)new LdcInsnNode((Object)dpth));
        LabelNode ifcmpne = new LabelNode();
        write_il.add((AbstractInsnNode)new JumpInsnNode(160, ifcmpne));
        write_il.add(this.generateDefaultWrites(write_gen));
        write_il.add((AbstractInsnNode)new JumpInsnNode(167, end));
        if (this.super_is_ibis_serializable || this.super_is_serializable) {
            write_il.add((AbstractInsnNode)ifcmpne);
            write_il.add((AbstractInsnNode)new VarInsnNode(21, 2));
            write_il.add((AbstractInsnNode)new LdcInsnNode((Object)dpth));
            write_il.add((AbstractInsnNode)new JumpInsnNode(163, end));
            if (this.super_is_ibis_serializable || this.generator.forceGeneratedCalls()) {
                write_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
                write_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
                write_il.add((AbstractInsnNode)new VarInsnNode(21, 2));
                write_il.add((AbstractInsnNode)this.createGeneratedDefaultWriteObjectInvocation(this.clazz.superName));
            } else {
                write_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
                write_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
                write_il.add((AbstractInsnNode)new VarInsnNode(21, 2));
                write_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationOutputStream", "defaultWriteSerializableObject", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{TYPE_OBJECT, Type.INT_TYPE})));
            }
        } else {
            write_il.add((AbstractInsnNode)ifcmpne);
        }
        write_il.add((AbstractInsnNode)end);
        write_il.add(write_gen.instructions);
        write_gen.instructions = write_il;
    }

    private void fillInGeneratedDefaultReadObjectMethod(int dpth) {
        MethodNode read_gen = ASMSerializationInfo.findMethod(this.methods, "generated_DefaultReadObject", "(Libis/io/IbisSerializationInputStream;I)V");
        InsnList read_il = new InsnList();
        LabelNode end = new LabelNode();
        read_il.add((AbstractInsnNode)new VarInsnNode(21, 2));
        read_il.add((AbstractInsnNode)new LdcInsnNode((Object)dpth));
        LabelNode ifcmpne = new LabelNode();
        read_il.add((AbstractInsnNode)new JumpInsnNode(160, ifcmpne));
        read_il.add(this.generateDefaultReads(false, read_gen));
        read_il.add((AbstractInsnNode)new JumpInsnNode(167, end));
        read_il.add((AbstractInsnNode)ifcmpne);
        if (this.super_is_ibis_serializable || this.super_is_serializable) {
            read_il.add((AbstractInsnNode)new VarInsnNode(21, 2));
            read_il.add((AbstractInsnNode)new LdcInsnNode((Object)dpth));
            read_il.add((AbstractInsnNode)new JumpInsnNode(163, end));
            if (this.super_is_ibis_serializable || this.generator.forceGeneratedCalls()) {
                read_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
                read_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
                read_il.add((AbstractInsnNode)new VarInsnNode(21, 2));
                read_il.add((AbstractInsnNode)this.createGeneratedDefaultReadObjectInvocation(this.clazz.superName, 183));
            } else {
                read_il.add((AbstractInsnNode)new VarInsnNode(25, 1));
                read_il.add((AbstractInsnNode)new VarInsnNode(25, 0));
                read_il.add((AbstractInsnNode)new VarInsnNode(21, 2));
                read_il.add((AbstractInsnNode)new MethodInsnNode(182, "ibis/io/IbisSerializationInputStream", "defaultReadSerializableObject", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{TYPE_OBJECT, Type.INT_TYPE})));
            }
        }
        read_il.add((AbstractInsnNode)end);
        read_il.add(read_gen.instructions);
        read_gen.instructions = read_il;
    }
}

