/*
 * Decompiled with CFR 0.152.
 */
package ibis.io;

import ibis.util.Timer;
import java.io.PrintStream;
import java.util.Vector;

public class SerializationTimer {
    private static Vector<SerializationTimer> timerList = new Vector();
    private final String name;
    private int starts;
    private final Timer timer;
    private final Timer suspend;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerializationTimer(String name) {
        this.name = name;
        this.suspend = Timer.createTimer();
        this.timer = Timer.createTimer();
        Class<SerializationTimer> clazz = SerializationTimer.class;
        synchronized (SerializationTimer.class) {
            timerList.add(this);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void start() {
        if (this.starts++ == 0) {
            this.timer.start();
        }
    }

    public void stop() {
        if (--this.starts == 0) {
            this.timer.stop();
        }
    }

    public void suspend() {
        if (this.starts > 0) {
            this.timer.stop();
            this.suspend.start();
        }
    }

    public void resume() {
        if (this.starts > 0) {
            this.suspend.stop();
            this.timer.start();
        }
    }

    public void reset() {
        this.starts = 0;
        this.timer.reset();
        this.suspend.reset();
    }

    public void report(PrintStream s) {
        if (this.timer.nrTimes() > 0) {
            s.println("Timer \"" + this.name + "\" " + this.timer.totalTime() + " (" + this.timer.nrTimes() + ");" + " suspend " + this.suspend.totalTime() + " (" + this.suspend.nrTimes() + ")");
        }
    }

    public void report() {
        this.report(System.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetAllTimers() {
        Class<SerializationTimer> clazz = SerializationTimer.class;
        synchronized (SerializationTimer.class) {
            for (SerializationTimer t : timerList) {
                t.reset();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printAllTimers() {
        Class<SerializationTimer> clazz = SerializationTimer.class;
        synchronized (SerializationTimer.class) {
            for (SerializationTimer t : timerList) {
                t.report();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread("SerializationStreams ShutdownHook"){

            @Override
            public void run() {
                SerializationTimer.printAllTimers();
            }
        });
    }
}

