/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl;

import ibis.io.DataOutputStream;
import ibis.io.Replacer;
import ibis.io.SerializationFactory;
import ibis.io.SerializationOutput;
import ibis.ipl.AlreadyConnectedException;
import ibis.ipl.ConnectionClosedException;
import ibis.ipl.ConnectionFailedException;
import ibis.ipl.ConnectionTimedOutException;
import ibis.ipl.ConnectionsFailedException;
import ibis.ipl.IbisConfigurationException;
import ibis.ipl.PortType;
import ibis.ipl.ReceivePortIdentifier;
import ibis.ipl.SendPortDisconnectUpcall;
import ibis.ipl.SendPortIdentifier;
import ibis.ipl.impl.CollectedWriteException;
import ibis.ipl.impl.Ibis;
import ibis.ipl.impl.IbisIdentifier;
import ibis.ipl.impl.Manageable;
import ibis.ipl.impl.ReceivePort;
import ibis.ipl.impl.SendPortConnectionInfo;
import ibis.ipl.impl.WriteMessage;
import ibis.util.TypedProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SendPort
extends Manageable
implements ibis.ipl.SendPort {
    private static final Logger logger = LoggerFactory.getLogger((String)"ibis.ipl.impl.SendPort");
    private static final String ALLOW_COMM_IN_UPCALL = "ibis.upcall.communication";
    private static final String ALLOW_CONN_IN_UPCALL = "ibis.upcall.connections";
    private static final String[][] propertiesList = new String[][]{{"ibis.upcall.communication", "false", "Boolean: when set, communication is allowed from inside upcalls, without first calling finish()."}, {"ibis.upcall.connections", "false", "Boolean: when set, connection setup is allowed from inside upcalls, without first calling finish()."}};
    public final PortType type;
    public final String name;
    public final ibis.ipl.impl.SendPortIdentifier ident;
    private final boolean connectionDowncalls;
    public final SendPortDisconnectUpcall connectUpcall;
    protected ArrayList<ibis.ipl.impl.ReceivePortIdentifier> lostConnections = new ArrayList();
    protected HashMap<ibis.ipl.impl.ReceivePortIdentifier, SendPortConnectionInfo> receivers = new HashMap();
    private boolean aMessageIsAlive = false;
    private int waitingForMessage = 0;
    private boolean closed = false;
    protected Ibis ibis;
    private final Replacer replacer;
    protected SerializationOutput out;
    protected DataOutputStream dataOut;
    protected final WriteMessage w;
    private CollectedWriteException collectedExceptions;
    protected final Properties properties;
    private long nMessages = 0L;
    private long messageBytes = 0L;
    private long bytes = 0L;
    private long prevBytes = 0L;
    private long nConnections = 0L;
    private long nLostConnections = 0L;
    private long nClosedConnections = 0L;
    private final boolean allowCommunicationInUpcall;
    private final boolean allowConnectionsInUpcall;

    protected SendPort(Ibis ibis, PortType type, String name, SendPortDisconnectUpcall connectUpcall, Properties properties) throws IOException {
        String replacerName;
        this.ibis = ibis;
        this.type = type;
        this.name = name;
        this.ident = ibis.createSendPortIdentifier(name, ibis.ident);
        this.connectionDowncalls = type.hasCapability("connection.downcalls");
        this.connectUpcall = connectUpcall;
        this.properties = ibis.properties();
        if (properties != null) {
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = properties.getProperty(key);
                this.properties.setProperty(key, value);
            }
        }
        if ((replacerName = this.properties.getProperty("ibis.serialization.replacer")) != null) {
            try {
                Class<?> replacerClass = Class.forName(replacerName);
                this.replacer = (Replacer)replacerClass.newInstance();
            }
            catch (Throwable e) {
                throw new IOException("Could not instantiate replacer class " + replacerName);
            }
        } else {
            this.replacer = null;
        }
        TypedProperties tp = new TypedProperties(this.properties);
        this.allowCommunicationInUpcall = tp.getBooleanProperty(ALLOW_COMM_IN_UPCALL, false);
        this.allowConnectionsInUpcall = tp.getBooleanProperty(ALLOW_CONN_IN_UPCALL, false);
        ibis.register(this);
        if (logger.isDebugEnabled()) {
            logger.debug(ibis.identifier() + ": Sendport '" + name + "' created");
        }
        this.w = this.createWriteMessage();
        this.addValidKey("Messages");
        this.addValidKey("MessageBytes");
        this.addValidKey("Bytes");
        this.addValidKey("Connections");
        this.addValidKey("LostConnections");
        this.addValidKey("ClosedConnections");
    }

    public static Map<String, String> getDescriptions() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String[] element : propertiesList) {
            result.put(element[0], element[2]);
        }
        return result;
    }

    public synchronized Map<IbisIdentifier, Set<String>> getConnectionTypes() {
        HashMap<IbisIdentifier, Set<String>> result = new HashMap<IbisIdentifier, Set<String>>();
        for (ibis.ipl.impl.ReceivePortIdentifier port : this.receivers.keySet()) {
            SendPortConnectionInfo i = this.receivers.get(port);
            if (i == null) continue;
            IbisIdentifier id = port.ibis;
            Set<String> s = result.get(id);
            if (s == null) {
                s = new HashSet<String>();
            }
            s.add(i.connectionType());
            result.put(id, s);
        }
        return result;
    }

    public static List<String> getPropertyNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (String[] element : propertiesList) {
            result.add(element[0]);
        }
        return result;
    }

    @Override
    protected synchronized void updateProperties() {
        this.setProperty("ClosedConnections", "" + this.nClosedConnections);
        this.setProperty("LostConnections", "" + this.nLostConnections);
        this.setProperty("Connections", "" + this.nConnections);
        this.setProperty("Messages", "" + this.nMessages);
        this.setProperty("MessageBytes", "" + this.messageBytes);
        this.setProperty("Bytes", "" + this.bytes);
    }

    @Override
    protected void doProperties(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            this.doProperty(entry.getKey(), entry.getValue());
        }
    }

    @Override
    protected void doProperty(String key, String value) {
        if (key.equals("Bytes")) {
            this.bytes = Long.parseLong(value);
            this.prevBytes = Long.parseLong(value);
            this.resetWritten();
        } else if (key.equals("ClosedConnections")) {
            this.nClosedConnections = Long.parseLong(value);
        } else if (key.equals("nConnections")) {
            this.nConnections = Long.parseLong(value);
        } else if (key.equals("Messages")) {
            this.nMessages = Long.parseLong(value);
        } else if (key.equals("MessageBytes")) {
            this.messageBytes = Long.parseLong(value);
        } else if (key.equals("LostConnections")) {
            this.nLostConnections = Long.parseLong(value);
        }
    }

    protected WriteMessage createWriteMessage() {
        return new WriteMessage(this);
    }

    protected long totalWritten() {
        return this.dataOut.bytesWritten();
    }

    protected void resetWritten() {
        this.dataOut.resetBytesWritten();
    }

    private void createOut() throws IOException {
        String serialization = this.type.hasCapability("serialization.data") ? "data" : (this.type.hasCapability("serialization.object.sun") ? "sun" : (this.type.hasCapability("serialization.object.ibis") ? "ibis" : (this.type.hasCapability("serialization.object") ? "object" : "byte")));
        this.out = SerializationFactory.createSerializationOutput((String)serialization, (DataOutputStream)this.dataOut);
        if (this.replacer != null) {
            this.out.setReplacer(this.replacer);
        }
    }

    public PortType getPortType() {
        return this.type;
    }

    public synchronized ReceivePortIdentifier[] lostConnections() {
        if (!this.connectionDowncalls) {
            throw new IbisConfigurationException("SendPort.lostConnections() called but connectiondowncalls not configured");
        }
        ReceivePortIdentifier[] result = this.lostConnections.toArray(new ReceivePortIdentifier[this.lostConnections.size()]);
        this.lostConnections.clear();
        return result;
    }

    public String name() {
        return this.name;
    }

    public SendPortIdentifier identifier() {
        return this.ident;
    }

    public void connect(ReceivePortIdentifier receiver) throws ConnectionFailedException {
        this.connect(receiver, 0L, true);
    }

    public ReceivePortIdentifier connect(ibis.ipl.IbisIdentifier id, String name) throws ConnectionFailedException {
        if (logger.isDebugEnabled()) {
            logger.debug("Sendport '" + this.name + "' connecting to " + name + " at " + id);
        }
        return this.connect(id, name, 0L, true);
    }

    private void checkConnect(ibis.ipl.impl.ReceivePortIdentifier r) throws ConnectionFailedException {
        if (this.receivers.size() > 0 && !this.type.hasCapability("connection.onetomany") && !this.type.hasCapability("connection.manytomany")) {
            throw new IbisConfigurationException("Sendport already has a connection and OneToMany or ManyToMany not requested");
        }
        if (this.getInfo(r) != null) {
            throw new AlreadyConnectedException("Already connected", (ReceivePortIdentifier)r);
        }
    }

    public synchronized void connect(ReceivePortIdentifier receiver, long timeout, boolean fillTimeout) throws ConnectionFailedException {
        if (!this.allowConnectionsInUpcall && ReceivePort.threadsInUpcallSet.contains(Thread.currentThread())) {
            throw new ConnectionFailedException("Connection attempt in upcall is not allowed", receiver);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Sendport '" + this.name + "' connecting to " + receiver);
        }
        if (this.aMessageIsAlive) {
            throw new ConnectionFailedException("A message was alive while adding a new connection", receiver);
        }
        if (timeout < 0L) {
            throw new ConnectionFailedException("connect(): timeout must be >= 0", receiver);
        }
        ibis.ipl.impl.ReceivePortIdentifier r = (ibis.ipl.impl.ReceivePortIdentifier)receiver;
        this.checkConnect(r);
        try {
            this.addConnectionInfo(r, this.doConnect(r, timeout, fillTimeout));
        }
        catch (ConnectionFailedException e) {
            throw e;
        }
        catch (Throwable e1) {
            throw new ConnectionFailedException("Got unexpected exception", (ReceivePortIdentifier)r, e1);
        }
        ++this.nConnections;
    }

    public ReceivePortIdentifier[] connect(Map<ibis.ipl.IbisIdentifier, String> ports) throws ConnectionsFailedException {
        return this.connect(ports, 0L, true);
    }

    public ReceivePortIdentifier[] connect(Map<ibis.ipl.IbisIdentifier, String> ports, long timeout, boolean fillTimeout) throws ConnectionsFailedException {
        ReceivePortIdentifier[] ids = new ReceivePortIdentifier[ports.size()];
        int index = 0;
        for (Map.Entry<ibis.ipl.IbisIdentifier, String> entry : ports.entrySet()) {
            ids[index++] = this.ibis.createReceivePortIdentifier(entry.getValue(), (IbisIdentifier)entry.getKey());
        }
        this.connect(ids, timeout, fillTimeout);
        return ids;
    }

    public void connect(ReceivePortIdentifier[] ports) throws ConnectionsFailedException {
        this.connect(ports, 0L, true);
    }

    public synchronized void connect(ReceivePortIdentifier[] ports, long timeout, boolean fillTimeout) throws ConnectionsFailedException {
        ArrayList<ReceivePortIdentifier> succes = new ArrayList<ReceivePortIdentifier>();
        LinkedList<ReceivePortIdentifier> todo = new LinkedList<ReceivePortIdentifier>();
        HashMap<ReceivePortIdentifier, Throwable> results = new HashMap<ReceivePortIdentifier, Throwable>();
        long deadline = 0L;
        if (timeout > 0L) {
            deadline = System.currentTimeMillis() + timeout;
        }
        for (ReceivePortIdentifier rp : ports) {
            todo.add(rp);
        }
        if (todo.size() > 0 && !this.allowConnectionsInUpcall && ReceivePort.threadsInUpcallSet.contains(Thread.currentThread())) {
            throw new ConnectionsFailedException("Connection attempt in upcall is not allowed");
        }
        while (todo.size() > 0) {
            long time = 0L;
            if (deadline != 0L && (time = (deadline - System.currentTimeMillis()) / (long)todo.size()) <= 0L) break;
            ReceivePortIdentifier rp = (ReceivePortIdentifier)todo.removeFirst();
            try {
                this.connect(rp, time, false);
                succes.add(rp);
                results.remove(rp);
            }
            catch (Throwable e) {
                results.put(rp, e);
                if (!fillTimeout) continue;
                todo.addLast(rp);
            }
        }
        if (succes.size() != ports.length) {
            ConnectionsFailedException ex = new ConnectionsFailedException();
            for (ReceivePortIdentifier rp : todo) {
                Throwable tmp = (Throwable)results.get(rp);
                if (tmp == null) {
                    ex.add((ConnectionFailedException)new ConnectionTimedOutException("Out of time, connection not even tried", rp));
                    continue;
                }
                if (tmp instanceof ConnectionFailedException) {
                    ex.add((ConnectionFailedException)tmp);
                    continue;
                }
                ex.add(new ConnectionFailedException("Connection failed", rp, tmp));
            }
            ex.setObtainedConnections(succes.toArray(new ReceivePortIdentifier[succes.size()]));
            throw ex;
        }
    }

    public ReceivePortIdentifier connect(ibis.ipl.IbisIdentifier id, String name, long timeout, boolean fillTimeout) throws ConnectionFailedException {
        ibis.ipl.impl.ReceivePortIdentifier r = this.ibis.createReceivePortIdentifier(name, (IbisIdentifier)id);
        this.connect(r, timeout, fillTimeout);
        return r;
    }

    private synchronized void addConnectionInfo(ibis.ipl.impl.ReceivePortIdentifier ri, SendPortConnectionInfo connection) {
        if (logger.isDebugEnabled()) {
            logger.debug("SendPort '" + this.name + "': added connection to " + ri);
        }
        this.addInfo(ri, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ibis.ipl.WriteMessage newMessage() throws IOException {
        if (!this.allowCommunicationInUpcall && ReceivePort.threadsInUpcallSet.contains(Thread.currentThread())) {
            throw new IOException("Communication in upcall is not allowed");
        }
        SendPort sendPort = this;
        synchronized (sendPort) {
            if (this.closed) {
                throw new IOException("newMessage call on closed sendport");
            }
            if (this.out == null) {
                try {
                    this.createOut();
                }
                catch (Throwable t) {
                    throw new IOException("Lost connection!");
                }
            }
            while (this.aMessageIsAlive) {
                ++this.waitingForMessage;
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                --this.waitingForMessage;
                if (!this.closed) continue;
                throw new IOException("newMessage call on closed sendport");
            }
            this.aMessageIsAlive = true;
        }
        this.announceNewMessage();
        this.w.initMessage(this.out);
        return this.w;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        ibis.ipl.impl.ReceivePortIdentifier[] ports;
        SendPort sendPort = this;
        synchronized (sendPort) {
            boolean alive;
            ports = this.receivers.keySet().toArray(new ibis.ipl.impl.ReceivePortIdentifier[this.receivers.size()]);
            boolean bl = alive = this.receivers.size() > 0 && this.aMessageIsAlive;
            if (alive) {
                throw new ConnectionClosedException("Closed a sendport port while a message is alive!");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("SendPort '" + this.name + "': start close()");
            }
            if (this.closed) {
                throw new ConnectionClosedException("Port already closed");
            }
            this.closed = true;
            this.nClosedConnections += (long)ports.length;
        }
        try {
            if (this.out == null) {
                try {
                    this.createOut();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            this.closePort();
        }
        finally {
            for (int i = 0; i < ports.length; ++i) {
                SendPortConnectionInfo c = this.removeInfo(ports[i]);
                try {
                    c.closeConnection();
                    continue;
                }
                catch (Throwable e) {}
            }
            this.ibis.deRegister(this);
            if (logger.isDebugEnabled()) {
                logger.debug("SendPort '" + this.name + "': close() done");
            }
        }
    }

    public void disconnect(ibis.ipl.IbisIdentifier id, String name) throws IOException {
        this.disconnect(this.ibis.createReceivePortIdentifier(name, (IbisIdentifier)id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect(ReceivePortIdentifier receiver) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Sendport '" + this.name + "' disconnecting from " + receiver.name() + " at " + receiver.ibisIdentifier());
        }
        ibis.ipl.impl.ReceivePortIdentifier r = (ibis.ipl.impl.ReceivePortIdentifier)receiver;
        if (this.aMessageIsAlive) {
            throw new IOException("Trying to disconnect while a message is alive!");
        }
        SendPortConnectionInfo c = this.removeInfo(r);
        if (c == null) {
            throw new IOException("Cannot disconnect from " + r + " since we are not connected with it");
        }
        try {
            this.sendDisconnectMessage(r, c);
        }
        finally {
            c.closeConnection();
            if (this.receivers.size() == 0) {
                if (this.out != null) {
                    try {
                        this.out.close();
                    }
                    catch (Throwable e) {}
                }
                this.out = null;
            }
        }
        ++this.nClosedConnections;
    }

    public synchronized ReceivePortIdentifier[] connectedTo() {
        return this.receivers.keySet().toArray(new ReceivePortIdentifier[this.receivers.size()]);
    }

    protected synchronized void killConnectionsWith(ibis.ipl.IbisIdentifier id) {
        ibis.ipl.impl.ReceivePortIdentifier[] keys;
        for (ibis.ipl.impl.ReceivePortIdentifier r : keys = this.receivers.keySet().toArray(new ibis.ipl.impl.ReceivePortIdentifier[this.receivers.size()])) {
            if (!r.ibisIdentifier().equals(id)) continue;
            this.receivers.get(r).closeConnection();
            this.removeInfo(r);
        }
    }

    protected synchronized SendPortConnectionInfo getInfo(ibis.ipl.impl.ReceivePortIdentifier id) {
        return this.receivers.get(id);
    }

    private synchronized void addInfo(ibis.ipl.impl.ReceivePortIdentifier id, SendPortConnectionInfo info) {
        this.receivers.put(id, info);
    }

    protected synchronized SendPortConnectionInfo removeInfo(ibis.ipl.impl.ReceivePortIdentifier id) {
        return this.receivers.remove(id);
    }

    public synchronized SendPortConnectionInfo[] connections() {
        return this.receivers.values().toArray(new SendPortConnectionInfo[this.receivers.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishMessage(WriteMessage w, long cnt) throws IOException {
        ReceivePortIdentifier[] ports = null;
        try {
            SendPort sendPort = this;
            synchronized (sendPort) {
                this.aMessageIsAlive = false;
                ports = this.connectedTo();
                if (this.waitingForMessage > 0) {
                    this.notifyAll();
                }
                ++this.nMessages;
                this.messageBytes += cnt;
                this.bytes = this.prevBytes + this.totalWritten();
                if (this.collectedExceptions != null) {
                    CollectedWriteException e = this.collectedExceptions;
                    this.collectedExceptions = null;
                    throw e;
                }
            }
            this.ibis.addSentPerIbis(cnt, ports);
        }
        catch (Throwable throwable) {
            this.ibis.addSentPerIbis(cnt, ports);
            throw throwable;
        }
    }

    protected void finishMessage(WriteMessage w, IOException e) {
        try {
            this.finishMessage(w, 0L);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected long bytesWritten() {
        return this.dataOut.bytesWritten();
    }

    protected void gotSendException(WriteMessage w, IOException e) throws IOException {
        this.handleSendException(w, e);
        if (this.type.hasCapability("connection.onetoone") || this.type.hasCapability("connection.manytoone")) {
            throw e;
        }
        if (this.collectedExceptions == null) {
            this.collectedExceptions = new CollectedWriteException();
        }
        this.collectedExceptions.add(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lostConnection(ibis.ipl.impl.ReceivePortIdentifier id, Throwable cause) {
        SendPortConnectionInfo c;
        if (logger.isDebugEnabled() && cause != null) {
            logger.debug("lostConnection to " + id + ", cause " + cause, cause);
        }
        if (this.connectionDowncalls) {
            SendPort sendPort = this;
            synchronized (sendPort) {
                this.lostConnections.add(id);
            }
        }
        if (this.connectUpcall != null) {
            try {
                this.connectUpcall.lostConnection((ibis.ipl.SendPort)this, (ReceivePortIdentifier)id, cause);
            }
            catch (Throwable e) {
                logger.error("Unexpected exception in lostConnection(), this Java instance will be terminated", e);
                System.exit(1);
            }
        }
        if ((c = this.removeInfo(id)) != null) {
            try {
                ++this.nLostConnections;
                c.closeConnection();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
    }

    public void initStream(DataOutputStream dataOut) {
        this.dataOut = dataOut;
        this.prevBytes += this.totalWritten();
        this.resetWritten();
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.out = null;
    }

    protected abstract void announceNewMessage() throws IOException;

    protected abstract SendPortConnectionInfo doConnect(ibis.ipl.impl.ReceivePortIdentifier var1, long var2, boolean var4) throws IOException;

    protected abstract void sendDisconnectMessage(ibis.ipl.impl.ReceivePortIdentifier var1, SendPortConnectionInfo var2) throws IOException;

    protected abstract void closePort() throws IOException;

    protected abstract void handleSendException(WriteMessage var1, IOException var2);

    synchronized long getMessageCount() {
        return this.nMessages;
    }

    synchronized long getBytesWritten() {
        return this.messageBytes;
    }

    synchronized long getBytesSent() {
        return this.bytes;
    }
}

