/*
 * Decompiled with CFR 0.152.
 */
package de.pleumann.antenna.misc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.Vector;

public class JadFile {
    private Vector strings = new Vector();

    public int add(String s) {
        int result = this.size();
        this.insert(result, s);
        return result;
    }

    public void assign(JadFile jad) {
        this.assign(jad, false);
    }

    public void assign(JadFile jad, boolean manifest) {
        this.clear();
        for (int i = 0; i < jad.size(); ++i) {
            if (manifest) {
                this.add(jad.get(i));
                continue;
            }
            this.add(jad.get(i));
        }
    }

    public void clear() {
        this.strings = new Vector();
    }

    public void delete(int index) {
        this.strings.removeElementAt(index);
    }

    public String get(int index) {
        return (String)this.strings.elementAt(index);
    }

    public String getName(int i) {
        String result = this.get(i);
        int p = result.indexOf(58);
        result = p != -1 ? result.substring(0, p) : null;
        return result;
    }

    public String getValue(String name) {
        int i = this.indexOfName(name);
        if (i != -1) {
            String result = this.get(i);
            i = result.indexOf(58);
            result = result.substring(i + 1);
            return result.trim();
        }
        return null;
    }

    public int indexOf(String s) {
        String t = s.toLowerCase();
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).toLowerCase().equals(t)) continue;
            return i;
        }
        return -1;
    }

    public int indexOfName(String name) {
        String s = name.toLowerCase() + ':';
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).toLowerCase().startsWith(s)) continue;
            return i;
        }
        return -1;
    }

    public void insert(int index, String s) {
        this.strings.insertElementAt(s, index);
    }

    public void set(int index, String s) {
        this.strings.setElementAt(s, index);
    }

    public void setValue(String name, String value) {
        int i = this.indexOfName(name);
        if (i == -1) {
            if (value != null && !value.equals("")) {
                this.add(name + ": " + value);
            }
        } else if (value != null && !value.equals("")) {
            this.set(i, name + ": " + value);
        } else {
            this.delete(i);
        }
    }

    public int size() {
        return this.strings.size();
    }

    public int getMIDletCount() {
        int i = 1;
        while (this.indexOfName("MIDlet-" + i) != -1) {
            ++i;
        }
        return i - 1;
    }

    public MIDletData getMIDlet(int i) {
        String value = this.getValue("MIDlet-" + i);
        if (value == null) {
            return null;
        }
        int p1 = value.indexOf(44);
        String name = null;
        String icon = null;
        String cls = null;
        if (p1 != -1) {
            name = value.substring(0, p1).trim();
            int p2 = value.indexOf(44, p1 + 1);
            if (p2 != -1) {
                icon = value.substring(p1 + 1, p2).trim();
                cls = value.substring(p2 + 1).trim();
            } else {
                icon = value.substring(p1 + 1).trim();
            }
        } else {
            name = value.trim();
        }
        if ("".equals(name)) {
            name = null;
        }
        if ("".equals(cls)) {
            cls = null;
        }
        if ("".equals(icon)) {
            icon = null;
        }
        return new MIDletData(i, name, icon, cls);
    }

    private void load(Reader isr) throws IOException {
        this.clear();
        BufferedReader reader = new BufferedReader(isr);
        String s = reader.readLine();
        while (s != null) {
            if (!"".equals(s.trim())) {
                this.add(s);
            }
            s = reader.readLine();
        }
        reader.close();
    }

    public void load(String filename, String encoding) throws IOException {
        if (encoding != null) {
            this.load(new InputStreamReader((InputStream)new FileInputStream(filename), encoding));
        } else {
            this.load(new InputStreamReader(new FileInputStream(filename)));
        }
    }

    public void save(String filename, String encoding) throws IOException {
        OutputStreamWriter osw = encoding != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(filename), encoding) : new OutputStreamWriter(new FileOutputStream(filename));
        BufferedWriter writer = new BufferedWriter(osw);
        for (int i = 0; i < this.size(); ++i) {
            String s = this.get(i);
            if (s == null || s.length() == 0) continue;
            writer.write(this.get(i));
            writer.newLine();
        }
        writer.close();
    }

    public void save(OutputStream stream) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream));
        for (int i = 0; i < this.size(); ++i) {
            String s = this.get(i);
            if (s == null || s.length() == 0) continue;
            writer.write(this.get(i));
            writer.newLine();
        }
        writer.flush();
    }

    public class MIDletData {
        private int number;
        private String name;
        private String icon;
        private String cls;

        private MIDletData(int number, String name, String icon, String cls) {
            this.number = number;
            this.name = name;
            this.icon = icon;
            if (cls != null) {
                this.cls = cls.replace('/', '.');
            }
        }

        public int getNumber() {
            return this.number;
        }

        public String getName() {
            return this.name;
        }

        public String getClassName() {
            return this.cls;
        }

        public String getIcon() {
            return this.icon;
        }
    }
}

