/*
 * Decompiled with CFR 0.152.
 */
package com.github.sardine.impl;

import com.github.sardine.DavAce;
import com.github.sardine.DavAcl;
import com.github.sardine.DavPrincipal;
import com.github.sardine.DavQuota;
import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import com.github.sardine.Version;
import com.github.sardine.impl.SardineRedirectStrategy;
import com.github.sardine.impl.handler.ExistsResponseHandler;
import com.github.sardine.impl.handler.LockResponseHandler;
import com.github.sardine.impl.handler.MultiStatusResponseHandler;
import com.github.sardine.impl.handler.VoidResponseHandler;
import com.github.sardine.impl.io.ContentLengthInputStream;
import com.github.sardine.impl.io.HttpMethodReleaseInputStream;
import com.github.sardine.impl.methods.HttpAcl;
import com.github.sardine.impl.methods.HttpCopy;
import com.github.sardine.impl.methods.HttpLock;
import com.github.sardine.impl.methods.HttpMkCol;
import com.github.sardine.impl.methods.HttpMove;
import com.github.sardine.impl.methods.HttpPropFind;
import com.github.sardine.impl.methods.HttpPropPatch;
import com.github.sardine.impl.methods.HttpReport;
import com.github.sardine.impl.methods.HttpSearch;
import com.github.sardine.impl.methods.HttpUnlock;
import com.github.sardine.model.Ace;
import com.github.sardine.model.Acl;
import com.github.sardine.model.Allprop;
import com.github.sardine.model.Displayname;
import com.github.sardine.model.Exclusive;
import com.github.sardine.model.Group;
import com.github.sardine.model.Lockinfo;
import com.github.sardine.model.Lockscope;
import com.github.sardine.model.Locktype;
import com.github.sardine.model.Multistatus;
import com.github.sardine.model.ObjectFactory;
import com.github.sardine.model.Owner;
import com.github.sardine.model.PrincipalCollectionSet;
import com.github.sardine.model.PrincipalURL;
import com.github.sardine.model.Prop;
import com.github.sardine.model.Propertyupdate;
import com.github.sardine.model.Propfind;
import com.github.sardine.model.Propstat;
import com.github.sardine.model.QuotaAvailableBytes;
import com.github.sardine.model.QuotaUsedBytes;
import com.github.sardine.model.Remove;
import com.github.sardine.model.Resourcetype;
import com.github.sardine.model.Response;
import com.github.sardine.model.SearchRequest;
import com.github.sardine.model.Write;
import com.github.sardine.report.SardineReport;
import com.github.sardine.util.SardineUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.impl.cookie.IgnoreSpecProvider;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HTTP;
import org.apache.http.protocol.HttpContext;
import org.w3c.dom.Element;

public class SardineImpl
implements Sardine {
    private static final Logger log = Logger.getLogger(DavResource.class.getName());
    private static final String UTF_8 = "UTF-8";
    private CloseableHttpClient client;
    private HttpClientBuilder builder;
    protected HttpClientContext context = HttpClientContext.create();

    public SardineImpl() {
        this.builder = this.configure(null, null);
        this.client = this.builder.build();
    }

    public SardineImpl(String bearerAuth) {
        BasicHeader bearerHeader = new BasicHeader("Authorization", "Bearer " + bearerAuth);
        this.builder = this.configure(null, null).setDefaultHeaders(Collections.singletonList(bearerHeader));
        this.client = this.builder.build();
    }

    public SardineImpl(String username, String password) {
        this.builder = this.configure(null, this.getCredentialsProvider(username, password, null, null));
        this.client = this.builder.build();
    }

    public SardineImpl(String username, String password, ProxySelector selector) {
        this.builder = this.configure(selector, this.getCredentialsProvider(username, password, null, null));
        this.client = this.builder.build();
    }

    public SardineImpl(HttpClientBuilder builder) {
        this.builder = builder;
        this.client = this.builder.build();
    }

    public SardineImpl(HttpClientBuilder builder, String username, String password) {
        this.builder = builder;
        this.setCredentials(username, password);
        this.client = this.builder.build();
    }

    @Override
    public void setCredentials(String username, String password) {
        this.setCredentials(username, password, "", "");
    }

    @Override
    public void setCredentials(String username, String password, String domain, String workstation) {
        this.context.setCredentialsProvider(this.getCredentialsProvider(username, password, domain, workstation));
        this.context.setAttribute("http.auth.target-scope", (Object)new AuthState());
    }

    private CredentialsProvider getCredentialsProvider(String username, String password, String domain, String workstation) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        if (username != null) {
            provider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "NTLM"), (Credentials)new NTCredentials(username, password, workstation, domain));
            provider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Basic"), (Credentials)new UsernamePasswordCredentials(username, password));
            provider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Digest"), (Credentials)new UsernamePasswordCredentials(username, password));
            provider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Negotiate"), (Credentials)new UsernamePasswordCredentials(username, password));
            provider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Kerberos"), (Credentials)new UsernamePasswordCredentials(username, password));
        }
        return provider;
    }

    @Override
    public void enableCompression() {
        this.builder.addInterceptorLast((HttpRequestInterceptor)new RequestAcceptEncoding());
        this.builder.addInterceptorLast((HttpResponseInterceptor)new ResponseContentEncoding());
        this.client = this.builder.build();
    }

    @Override
    public void disableCompression() {
        this.builder.disableContentCompression();
        this.client = this.builder.build();
    }

    @Override
    public void ignoreCookies() {
        this.builder.setDefaultCookieSpecRegistry((Lookup)new Lookup<CookieSpecProvider>(){

            public CookieSpecProvider lookup(String name) {
                return new IgnoreSpecProvider();
            }
        });
        this.client = this.builder.build();
    }

    @Override
    public void enablePreemptiveAuthentication(String hostname) {
        this.enablePreemptiveAuthentication(hostname, -1, -1);
    }

    @Override
    public void enablePreemptiveAuthentication(URL url) {
        int httpPort;
        int httpsPort;
        String host = url.getHost();
        int port = url.getPort();
        String protocol = url.getProtocol();
        if ("https".equals(protocol)) {
            httpsPort = port;
            httpPort = -1;
        } else if ("http".equals(protocol)) {
            httpPort = port;
            httpsPort = -1;
        } else {
            throw new IllegalArgumentException("Unsupported protocol " + protocol);
        }
        this.enablePreemptiveAuthentication(host, httpPort, httpsPort);
    }

    @Override
    public void enablePreemptiveAuthentication(String hostname, int httpPort, int httpsPort) {
        AuthCache cache = this.context.getAuthCache();
        if (cache == null) {
            cache = new BasicAuthCache();
            this.context.setAuthCache(cache);
        }
        BasicScheme basicAuth = new BasicScheme();
        cache.put(new HttpHost(hostname, httpPort, "http"), (AuthScheme)basicAuth);
        cache.put(new HttpHost(hostname, httpsPort, "https"), (AuthScheme)basicAuth);
    }

    @Override
    public void disablePreemptiveAuthentication() {
        this.context.removeAttribute("http.auth.auth-cache");
    }

    @Override
    public List<DavResource> getResources(String url) throws IOException {
        return this.list(url);
    }

    @Override
    public List<DavResource> list(String url) throws IOException {
        return this.list(url, 1);
    }

    @Override
    public List<DavResource> list(String url, int depth) throws IOException {
        return this.list(url, depth, true);
    }

    @Override
    public List<DavResource> list(String url, int depth, boolean allProp) throws IOException {
        if (allProp) {
            Propfind body = new Propfind();
            body.setAllprop(new Allprop());
            return this.propfind(url, depth, body);
        }
        return this.list(url, depth, Collections.<QName>emptySet());
    }

    @Override
    public List<DavResource> list(String url, int depth, Set<QName> props) throws IOException {
        Propfind body = new Propfind();
        Prop prop = new Prop();
        ObjectFactory objectFactory = new ObjectFactory();
        prop.setGetcontentlength(objectFactory.createGetcontentlength());
        prop.setGetlastmodified(objectFactory.createGetlastmodified());
        prop.setCreationdate(objectFactory.createCreationdate());
        prop.setDisplayname(objectFactory.createDisplayname());
        prop.setGetcontenttype(objectFactory.createGetcontenttype());
        prop.setResourcetype(objectFactory.createResourcetype());
        prop.setGetetag(objectFactory.createGetetag());
        this.addCustomProperties(prop, props);
        body.setProp(prop);
        return this.propfind(url, depth, body);
    }

    @Override
    public List<DavResource> propfind(String url, int depth, Set<QName> props) throws IOException {
        Propfind body = new Propfind();
        Prop prop = new Prop();
        this.addCustomProperties(prop, props);
        body.setProp(prop);
        return this.propfind(url, depth, body);
    }

    private void addCustomProperties(Prop prop, Set<QName> props) {
        List<Element> any = prop.getAny();
        for (QName entry : props) {
            Element element = SardineUtil.createElement(entry);
            any.add(element);
        }
    }

    protected List<DavResource> propfind(String url, int depth, Propfind body) throws IOException {
        HttpPropFind entity = new HttpPropFind(url);
        entity.setDepth(depth < 0 ? "infinity" : Integer.toString(depth));
        entity.setEntity((HttpEntity)new StringEntity(SardineUtil.toXml(body), UTF_8));
        Multistatus multistatus = this.execute((HttpRequestBase)entity, new MultiStatusResponseHandler());
        List<Response> responses = multistatus.getResponse();
        ArrayList<DavResource> resources = new ArrayList<DavResource>(responses.size());
        for (Response response : responses) {
            try {
                resources.add(new DavResource(response));
            }
            catch (URISyntaxException e) {
                log.warning(String.format("Ignore resource with invalid URI %s", response.getHref().get(0)));
            }
        }
        return resources;
    }

    @Override
    public <T> T report(String url, int depth, SardineReport<T> report) throws IOException {
        HttpReport entity = new HttpReport(url);
        entity.setDepth(depth < 0 ? "infinity" : Integer.toString(depth));
        entity.setEntity((HttpEntity)new StringEntity(report.toXml(), UTF_8));
        Multistatus multistatus = this.execute((HttpRequestBase)entity, new MultiStatusResponseHandler());
        return report.fromMultistatus(multistatus);
    }

    @Override
    public List<DavResource> search(String url, String language, String query) throws IOException {
        HttpSearch search = new HttpSearch(url);
        SearchRequest searchBody = new SearchRequest(language, query);
        String body = SardineUtil.toXml(searchBody);
        search.setEntity((HttpEntity)new StringEntity(body, UTF_8));
        Multistatus multistatus = this.execute((HttpRequestBase)search, new MultiStatusResponseHandler());
        List<Response> responses = multistatus.getResponse();
        ArrayList<DavResource> resources = new ArrayList<DavResource>(responses.size());
        for (Response response : responses) {
            try {
                resources.add(new DavResource(response));
            }
            catch (URISyntaxException e) {
                log.warning(String.format("Ignore resource with invalid URI %s", response.getHref().get(0)));
            }
        }
        return resources;
    }

    @Override
    public void setCustomProps(String url, Map<String, String> set, List<String> remove) throws IOException {
        this.patch(url, SardineUtil.toQName(set), SardineUtil.toQName(remove));
    }

    @Override
    public List<DavResource> patch(String url, Map<QName, String> setProps) throws IOException {
        return this.patch(url, setProps, Collections.<QName>emptyList());
    }

    @Override
    public List<DavResource> patch(String url, Map<QName, String> setProps, List<QName> removeProps) throws IOException {
        ArrayList<Element> setPropsElements = new ArrayList<Element>();
        for (Map.Entry<QName, String> entry : setProps.entrySet()) {
            Element element = SardineUtil.createElement(entry.getKey());
            element.setTextContent(entry.getValue());
            setPropsElements.add(element);
        }
        return this.patch(url, setPropsElements, removeProps);
    }

    @Override
    public List<DavResource> patch(String url, List<Element> setProps, List<QName> removeProps) throws IOException {
        HttpPropPatch entity = new HttpPropPatch(url);
        Propertyupdate body = new Propertyupdate();
        com.github.sardine.model.Set set = new com.github.sardine.model.Set();
        body.getRemoveOrSet().add(set);
        Prop prop = new Prop();
        List<Element> any = prop.getAny();
        for (Element element : setProps) {
            any.add(element);
        }
        set.setProp(prop);
        Remove remove = new Remove();
        body.getRemoveOrSet().add(remove);
        prop = new Prop();
        any = prop.getAny();
        for (QName entry : removeProps) {
            Element element = SardineUtil.createElement(entry);
            any.add(element);
        }
        remove.setProp(prop);
        entity.setEntity((HttpEntity)new StringEntity(SardineUtil.toXml(body), UTF_8));
        Multistatus multistatus = this.execute((HttpRequestBase)entity, new MultiStatusResponseHandler());
        List<Response> responses = multistatus.getResponse();
        ArrayList<DavResource> resources = new ArrayList<DavResource>(responses.size());
        for (Response response : responses) {
            try {
                resources.add(new DavResource(response));
            }
            catch (URISyntaxException e) {
                log.warning(String.format("Ignore resource with invalid URI %s", response.getHref().get(0)));
            }
        }
        return resources;
    }

    @Override
    public String lock(String url) throws IOException {
        HttpLock entity = new HttpLock(url);
        Lockinfo body = new Lockinfo();
        Lockscope scopeType = new Lockscope();
        scopeType.setExclusive(new Exclusive());
        body.setLockscope(scopeType);
        Locktype lockType = new Locktype();
        lockType.setWrite(new Write());
        body.setLocktype(lockType);
        entity.setEntity((HttpEntity)new StringEntity(SardineUtil.toXml(body), UTF_8));
        return this.execute((HttpRequestBase)entity, new LockResponseHandler());
    }

    @Override
    public String refreshLock(String url, String token, String file) throws IOException {
        HttpLock entity = new HttpLock(url);
        entity.setHeader("If", "<" + file + "> (<" + token + ">)");
        return this.execute((HttpRequestBase)entity, new LockResponseHandler());
    }

    @Override
    public void unlock(String url, String token) throws IOException {
        HttpUnlock entity = new HttpUnlock(url, token);
        Lockinfo body = new Lockinfo();
        Lockscope scopeType = new Lockscope();
        scopeType.setExclusive(new Exclusive());
        body.setLockscope(scopeType);
        Locktype lockType = new Locktype();
        lockType.setWrite(new Write());
        body.setLocktype(lockType);
        this.execute(entity, new VoidResponseHandler());
    }

    @Override
    public void setAcl(String url, List<DavAce> aces) throws IOException {
        HttpAcl entity = new HttpAcl(url);
        Acl body = new Acl();
        body.setAce(new ArrayList<Ace>());
        for (DavAce davAce : aces) {
            if (davAce.getInherited() != null || davAce.isProtected()) continue;
            Ace ace = davAce.toModel();
            body.getAce().add(ace);
        }
        entity.setEntity((HttpEntity)new StringEntity(SardineUtil.toXml(body), UTF_8));
        this.execute((HttpRequestBase)entity, new VoidResponseHandler());
    }

    @Override
    public DavAcl getAcl(String url) throws IOException {
        HttpPropFind entity = new HttpPropFind(url);
        entity.setDepth("0");
        Propfind body = new Propfind();
        Prop prop = new Prop();
        prop.setOwner(new Owner());
        prop.setGroup(new Group());
        prop.setAcl(new Acl());
        body.setProp(prop);
        entity.setEntity((HttpEntity)new StringEntity(SardineUtil.toXml(body), UTF_8));
        Multistatus multistatus = this.execute((HttpRequestBase)entity, new MultiStatusResponseHandler());
        List<Response> responses = multistatus.getResponse();
        if (responses.isEmpty()) {
            return null;
        }
        return new DavAcl(responses.get(0));
    }

    @Override
    public DavQuota getQuota(String url) throws IOException {
        HttpPropFind entity = new HttpPropFind(url);
        entity.setDepth("0");
        Propfind body = new Propfind();
        Prop prop = new Prop();
        prop.setQuotaAvailableBytes(new QuotaAvailableBytes());
        prop.setQuotaUsedBytes(new QuotaUsedBytes());
        body.setProp(prop);
        entity.setEntity((HttpEntity)new StringEntity(SardineUtil.toXml(body), UTF_8));
        Multistatus multistatus = this.execute((HttpRequestBase)entity, new MultiStatusResponseHandler());
        List<Response> responses = multistatus.getResponse();
        if (responses.isEmpty()) {
            return null;
        }
        return new DavQuota(responses.get(0));
    }

    @Override
    public List<DavPrincipal> getPrincipals(String url) throws IOException {
        HttpPropFind entity = new HttpPropFind(url);
        entity.setDepth("1");
        Propfind body = new Propfind();
        Prop prop = new Prop();
        prop.setDisplayname(new Displayname());
        prop.setResourcetype(new Resourcetype());
        prop.setPrincipalURL(new PrincipalURL());
        body.setProp(prop);
        entity.setEntity((HttpEntity)new StringEntity(SardineUtil.toXml(body), UTF_8));
        Multistatus multistatus = this.execute((HttpRequestBase)entity, new MultiStatusResponseHandler());
        List<Response> responses = multistatus.getResponse();
        if (responses.isEmpty()) {
            return null;
        }
        ArrayList<DavPrincipal> collections = new ArrayList<DavPrincipal>();
        for (Response r : responses) {
            if (r.getPropstat() == null) continue;
            for (Propstat propstat : r.getPropstat()) {
                if (propstat.getProp() == null || propstat.getProp().getResourcetype() == null || propstat.getProp().getResourcetype().getPrincipal() == null) continue;
                collections.add(new DavPrincipal(DavPrincipal.PrincipalType.HREF, r.getHref().get(0), propstat.getProp().getDisplayname().getContent().get(0)));
            }
        }
        return collections;
    }

    @Override
    public List<String> getPrincipalCollectionSet(String url) throws IOException {
        HttpPropFind entity = new HttpPropFind(url);
        entity.setDepth("0");
        Propfind body = new Propfind();
        Prop prop = new Prop();
        prop.setPrincipalCollectionSet(new PrincipalCollectionSet());
        body.setProp(prop);
        entity.setEntity((HttpEntity)new StringEntity(SardineUtil.toXml(body), UTF_8));
        Multistatus multistatus = this.execute((HttpRequestBase)entity, new MultiStatusResponseHandler());
        List<Response> responses = multistatus.getResponse();
        if (responses.isEmpty()) {
            return null;
        }
        ArrayList<String> collections = new ArrayList<String>();
        for (Response r : responses) {
            if (r.getPropstat() == null) continue;
            for (Propstat propstat : r.getPropstat()) {
                if (propstat.getProp() == null || propstat.getProp().getPrincipalCollectionSet() == null || propstat.getProp().getPrincipalCollectionSet().getHref() == null) continue;
                collections.addAll(propstat.getProp().getPrincipalCollectionSet().getHref());
            }
        }
        return collections;
    }

    @Override
    public ContentLengthInputStream get(String url) throws IOException {
        return this.get(url, Collections.emptyMap());
    }

    @Override
    public ContentLengthInputStream get(String url, Map<String, String> headers) throws IOException {
        ArrayList<Header> list = new ArrayList<Header>();
        for (Map.Entry<String, String> h : headers.entrySet()) {
            list.add((Header)new BasicHeader(h.getKey(), h.getValue()));
        }
        return this.get(url, list);
    }

    public ContentLengthInputStream get(String url, List<Header> headers) throws IOException {
        HttpGet get = new HttpGet(url);
        for (Header header : headers) {
            get.addHeader(header);
        }
        HttpResponse response = this.execute((HttpRequestBase)get);
        VoidResponseHandler handler = new VoidResponseHandler();
        try {
            handler.handleResponse(response);
            return new ContentLengthInputStream(new HttpMethodReleaseInputStream(response), response.getEntity().getContentLength());
        }
        catch (IOException ex) {
            get.abort();
            throw ex;
        }
    }

    @Override
    public void put(String url, byte[] data) throws IOException {
        this.put(url, data, null);
    }

    @Override
    public void put(String url, byte[] data, String contentType) throws IOException {
        ByteArrayEntity entity = new ByteArrayEntity(data);
        this.put(url, (HttpEntity)entity, contentType, true);
    }

    @Override
    public void put(String url, InputStream dataStream) throws IOException {
        this.put(url, dataStream, (String)null);
    }

    @Override
    public void put(String url, InputStream dataStream, String contentType) throws IOException {
        this.put(url, dataStream, contentType, true);
    }

    @Override
    public void put(String url, InputStream dataStream, String contentType, boolean expectContinue) throws IOException {
        this.put(url, dataStream, contentType, expectContinue, -1L);
    }

    @Override
    public void put(String url, InputStream dataStream, String contentType, boolean expectContinue, long contentLength) throws IOException {
        InputStreamEntity entity = new InputStreamEntity(dataStream, contentLength);
        this.put(url, (HttpEntity)entity, contentType, expectContinue);
    }

    @Override
    public void put(String url, InputStream dataStream, Map<String, String> headers) throws IOException {
        ArrayList<Header> list = new ArrayList<Header>();
        for (Map.Entry<String, String> h : headers.entrySet()) {
            list.add((Header)new BasicHeader(h.getKey(), h.getValue()));
        }
        this.put(url, dataStream, list);
    }

    public void put(String url, InputStream dataStream, List<Header> headers) throws IOException {
        InputStreamEntity entity = new InputStreamEntity(dataStream, -1L);
        this.put(url, (HttpEntity)entity, headers);
    }

    public void put(String url, HttpEntity entity, String contentType, boolean expectContinue) throws IOException {
        ArrayList<Header> headers = new ArrayList<Header>();
        if (contentType != null) {
            headers.add((Header)new BasicHeader("Content-Type", contentType));
        }
        if (expectContinue) {
            headers.add((Header)new BasicHeader("Expect", "100-continue"));
        }
        this.put(url, entity, headers);
    }

    public void put(String url, HttpEntity entity, List<Header> headers) throws IOException {
        this.put(url, entity, headers, new VoidResponseHandler());
    }

    public <T> T put(String url, HttpEntity entity, List<Header> headers, ResponseHandler<T> handler) throws IOException {
        HttpPut put = new HttpPut(url);
        put.setEntity(entity);
        for (Header header : headers) {
            put.addHeader(header);
        }
        if (entity.getContentType() == null && !put.containsHeader("Content-Type")) {
            put.addHeader("Content-Type", HTTP.DEF_CONTENT_CHARSET.name());
        }
        try {
            return this.execute((HttpRequestBase)put, handler);
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 417) {
                put.removeHeaders("Expect");
                if (entity.isRepeatable()) {
                    return this.execute((HttpRequestBase)put, handler);
                }
            }
            throw e;
        }
    }

    @Override
    public void put(String url, File localFile, String contentType) throws IOException {
        this.put(url, localFile, contentType, false);
    }

    @Override
    public void put(String url, File localFile, String contentType, boolean expectContinue) throws IOException {
        FileEntity content = new FileEntity(localFile);
        this.put(url, (HttpEntity)content, contentType, expectContinue);
    }

    @Override
    public void delete(String url) throws IOException {
        HttpDelete delete = new HttpDelete(url);
        this.execute((HttpRequestBase)delete, new VoidResponseHandler());
    }

    @Override
    public void move(String sourceUrl, String destinationUrl) throws IOException {
        this.move(sourceUrl, destinationUrl, true);
    }

    @Override
    public void move(String sourceUrl, String destinationUrl, boolean overwrite) throws IOException {
        HttpMove move = new HttpMove(sourceUrl, destinationUrl, overwrite);
        this.execute(move, new VoidResponseHandler());
    }

    @Override
    public void copy(String sourceUrl, String destinationUrl) throws IOException {
        this.copy(sourceUrl, destinationUrl, true);
    }

    @Override
    public void copy(String sourceUrl, String destinationUrl, boolean overwrite) throws IOException {
        HttpCopy copy = new HttpCopy(sourceUrl, destinationUrl, overwrite);
        this.execute(copy, new VoidResponseHandler());
    }

    @Override
    public void createDirectory(String url) throws IOException {
        HttpMkCol mkcol = new HttpMkCol(url);
        this.execute((HttpRequestBase)mkcol, new VoidResponseHandler());
    }

    @Override
    public boolean exists(String url) throws IOException {
        HttpHead head = new HttpHead(url);
        return this.execute((HttpRequestBase)head, new ExistsResponseHandler());
    }

    protected <T> T execute(HttpRequestBase request, ResponseHandler<T> responseHandler) throws IOException {
        try {
            this.context.removeAttribute("http.protocol.redirect-locations");
            return (T)this.client.execute((HttpUriRequest)request, responseHandler, (HttpContext)this.context);
        }
        catch (HttpResponseException e) {
            throw e;
        }
        catch (IOException e) {
            request.abort();
            throw e;
        }
    }

    protected HttpResponse execute(HttpRequestBase request) throws IOException {
        try {
            this.context.removeAttribute("http.protocol.redirect-locations");
            return this.client.execute((HttpUriRequest)request, (HttpContext)this.context);
        }
        catch (HttpResponseException e) {
            throw e;
        }
        catch (IOException e) {
            request.abort();
            throw e;
        }
    }

    @Override
    public void shutdown() throws IOException {
        this.client.close();
    }

    protected HttpClientBuilder configure(ProxySelector selector, CredentialsProvider credentials) {
        Registry<ConnectionSocketFactory> schemeRegistry = this.createDefaultSchemeRegistry();
        HttpClientConnectionManager cm = this.createDefaultConnectionManager(schemeRegistry);
        String version = Version.getSpecification();
        if (version == null) {
            version = "UNAVAILABLE";
        }
        return HttpClients.custom().setUserAgent("Sardine/" + version).setDefaultCredentialsProvider(credentials).setRedirectStrategy((RedirectStrategy)this.createDefaultRedirectStrategy()).setDefaultRequestConfig(RequestConfig.custom().setExpectContinueEnabled(false).build()).setConnectionManager(cm).setRoutePlanner(this.createDefaultRoutePlanner((SchemePortResolver)this.createDefaultSchemePortResolver(), selector));
    }

    protected DefaultSchemePortResolver createDefaultSchemePortResolver() {
        return new DefaultSchemePortResolver();
    }

    protected SardineRedirectStrategy createDefaultRedirectStrategy() {
        return new SardineRedirectStrategy();
    }

    protected Registry<ConnectionSocketFactory> createDefaultSchemeRegistry() {
        return RegistryBuilder.create().register("http", (Object)this.createDefaultSocketFactory()).register("https", (Object)this.createDefaultSecureSocketFactory()).build();
    }

    protected ConnectionSocketFactory createDefaultSocketFactory() {
        return PlainConnectionSocketFactory.getSocketFactory();
    }

    protected ConnectionSocketFactory createDefaultSecureSocketFactory() {
        return SSLConnectionSocketFactory.getSocketFactory();
    }

    protected HttpClientConnectionManager createDefaultConnectionManager(Registry<ConnectionSocketFactory> schemeRegistry) {
        return new PoolingHttpClientConnectionManager(schemeRegistry);
    }

    protected HttpRoutePlanner createDefaultRoutePlanner(SchemePortResolver resolver, ProxySelector selector) {
        return new SystemDefaultRoutePlanner(resolver, selector);
    }
}

