/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.generator;

import java.nio.ByteBuffer;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.spdy.frames.ControlFrame;
import org.eclipse.jetty.spdy.frames.PingFrame;
import org.eclipse.jetty.spdy.generator.ControlFrameGenerator;
import org.eclipse.jetty.util.BufferUtil;

public class PingGenerator
extends ControlFrameGenerator {
    public PingGenerator(ByteBufferPool bufferPool) {
        super(bufferPool);
    }

    @Override
    public ByteBuffer generate(ControlFrame frame) {
        PingFrame ping = (PingFrame)frame;
        int frameBodyLength = 4;
        int totalLength = 8 + frameBodyLength;
        ByteBuffer buffer = this.getByteBufferPool().acquire(totalLength, true);
        BufferUtil.clearToFill(buffer);
        this.generateControlFrameHeader(ping, frameBodyLength, buffer);
        buffer.putInt(ping.getPingId());
        buffer.flip();
        return buffer;
    }
}

