/*
 * Decompiled with CFR 0.152.
 */
package ibis.compile.util;

import ibis.util.RunProcess;

public class RunJavac {
    private static String[] compiler;

    public static void setCompiler(String[] c) {
        compiler = c;
    }

    public static boolean runJavac(String[] compilerArgs, boolean verbose) {
        try {
            int i;
            String[] cmd = new String[compiler.length + compilerArgs.length];
            for (i = 0; i < compiler.length; ++i) {
                cmd[i] = compiler[i];
            }
            for (i = 0; i < compilerArgs.length; ++i) {
                cmd[RunJavac.compiler.length + i] = compilerArgs[i];
            }
            if (verbose) {
                System.out.print("Running: ");
                for (i = 0; i < cmd.length; ++i) {
                    System.out.print(cmd[i] + " ");
                }
                System.out.println("");
            }
            RunProcess p = new RunProcess(cmd);
            p.run();
            int res = p.getExitStatus();
            byte[] err = p.getStderr();
            byte[] out = p.getStdout();
            if (out.length != 0) {
                System.out.write(out, 0, out.length);
                System.out.println("");
            }
            if (err.length != 0) {
                System.err.write(err, 0, err.length);
                System.err.println("");
            }
            if (res != 0) {
                return false;
            }
        }
        catch (Exception e) {
            System.err.println("IO error: " + e);
            e.printStackTrace();
            System.exit(1);
        }
        return true;
    }

    static {
        String javahome = System.getProperty("java.home");
        String javapath = System.getProperty("java.class.path");
        String filesep = System.getProperty("file.separator");
        String pathsep = System.getProperty("path.separator");
        if (javahome.endsWith("jre")) {
            javahome = javahome.substring(0, javahome.length() - 4);
        }
        compiler = new String[]{javahome + filesep + "bin" + filesep + "javac", "-classpath", javapath + pathsep};
    }
}

