/*
 * Decompiled with CFR 0.152.
 */
package ibis.compile;

import ibis.compile.ClassInfo;
import ibis.compile.Ibisc;
import ibis.compile.IbiscEntry;
import ibis.compile.JarInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.zip.ZipOutputStream;

public class JarEntryInfo {
    private JarEntry jarEntry;
    private byte[] content;
    private JarInfo jarInfo;
    private IbiscEntry ibiscEntry;

    JarEntryInfo(JarEntry jarEntry, JarInfo jarInfo) throws IOException {
        this.jarEntry = jarEntry;
        this.jarInfo = jarInfo;
        this.content = this.getContent();
        this.ibiscEntry = this.getIbiscEntry();
    }

    JarEntryInfo(JarEntry jarEntry, JarInfo jarInfo, byte[] content) {
        this.jarEntry = jarEntry;
        this.jarInfo = jarInfo;
        this.content = content;
        this.ibiscEntry = this.getIbiscEntry();
    }

    JarEntryInfo(JarEntry jarEntry, JarInfo jarInfo, byte[] content, IbiscEntry ibiscEntry) {
        this.jarEntry = jarEntry;
        this.jarInfo = jarInfo;
        this.content = content;
        this.ibiscEntry = ibiscEntry;
    }

    private IbiscEntry getIbiscEntry() {
        String iname = this.jarEntry.getName();
        if (iname.endsWith(".class")) {
            try {
                ClassInfo cl = Ibisc.w.parseInputStream(this.getInputStream(), iname);
                IbiscEntry entry = new IbiscEntry(cl, iname, this.jarInfo);
                Ibisc.allClasses.put(cl.getClassName(), entry);
                return entry;
            }
            catch (IOException e) {
                System.err.println("Ibisc: warning: could not read class " + iname + " from jar file " + this.jarInfo.getName());
            }
        }
        return null;
    }

    private byte[] getContent() throws IOException {
        int cnt;
        ByteArrayOutputStream Bos = new ByteArrayOutputStream();
        byte[] buf = new byte[16384];
        InputStream in = this.jarInfo.getInputStream(this.jarEntry);
        do {
            if ((cnt = in.read(buf, 0, 16384)) < 0) continue;
            Bos.write(buf, 0, cnt);
        } while (cnt >= 0);
        in.close();
        buf = Bos.toByteArray();
        return buf;
    }

    void write(ZipOutputStream ozip) throws IOException {
        JarEntry je = new JarEntry(this.jarEntry.getName());
        byte[] extra = this.jarEntry.getExtra();
        if (extra != null) {
            je.setExtra(extra);
        }
        if (this.ibiscEntry != null && this.ibiscEntry.getModified()) {
            je.setTime(System.currentTimeMillis());
            this.content = this.ibiscEntry.getClassInfo().getBytes();
        }
        ozip.putNextEntry(je);
        ozip.write(this.content);
        ozip.closeEntry();
    }

    InputStream getInputStream() {
        return new ByteArrayInputStream(this.content);
    }

    public JarEntry getJarEntry() {
        return this.jarEntry;
    }

    public JarInfo getJarInfo() {
        return this.jarInfo;
    }
}

