/*
 * Decompiled with CFR 0.152.
 */
package ibis.compile;

import ibis.compile.ByteCodeWrapper;
import ibis.compile.ClassInfo;
import ibis.compile.Ibisc;
import ibis.compile.IbiscEntry;
import ibis.compile.JarInfo;
import ibis.compile.util.RunJavac;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public abstract class IbiscComponent {
    protected boolean verbose;
    protected boolean keep;
    protected boolean fromIbisc = false;
    protected ByteCodeWrapper wrapper;
    private HashMap<String, IbiscEntry> allClasses;
    private HashMap<String, IbiscEntry> newClasses = new HashMap();

    protected IbiscComponent() {
    }

    void setWrapper(ByteCodeWrapper w) {
        this.wrapper = w;
    }

    public abstract boolean processArgs(ArrayList<String> var1);

    public abstract String getUsageString();

    public abstract void process(Iterator<?> var1);

    public abstract String rewriterImpl();

    void processClasses(HashMap<String, IbiscEntry> classes) {
        this.allClasses = classes;
        this.process(new ClassIterator());
        for (IbiscEntry ie : this.newClasses.values()) {
            this.allClasses.put(ie.getClassInfo().getClassName(), ie);
        }
    }

    protected String getDirectory(String cl) {
        IbiscEntry ie = this.allClasses.get(cl);
        if (ie == null) {
            ie = this.newClasses.get(cl);
        }
        if (ie == null) {
            return null;
        }
        JarInfo ji = ie.getJarInfo();
        File f = ji == null ? new File(ie.fileName) : new File(ji.getName());
        return f.getParent();
    }

    void setVerbose(boolean v) {
        this.verbose = v;
    }

    void setKeep(boolean v) {
        this.keep = v;
    }

    protected void writeAll() {
        Ibisc.writeAll();
    }

    protected void setModified(ClassInfo cl) {
        String className = cl.getClassName();
        IbiscEntry e = this.allClasses.get(className);
        if (e == null) {
            e = this.newClasses.get(className);
        }
        if (e != null) {
            e.setClassInfo(cl);
        }
    }

    protected void addEntry(ClassInfo cl, String fromClass) {
        IbiscEntry from = this.allClasses.get(fromClass);
        String fn = from.fileName;
        String className = cl.getClassName();
        String baseDir = new File(fn).getParent();
        int n = className.lastIndexOf(".");
        String name = className;
        if (n != -1) {
            name = name.substring(n + 1, name.length());
        }
        String newFilename = baseDir == null ? name + ".class" : baseDir + File.separator + name + ".class";
        JarInfo fromInfo = from.getJarInfo();
        IbiscEntry newEntry = new IbiscEntry(cl, newFilename, fromInfo);
        newEntry.setModified(true);
        this.newClasses.put(className, newEntry);
        if (fromInfo != null) {
            fromInfo.addEntry(newEntry);
        }
    }

    protected void compile(ArrayList<String> args, String fromClass) {
        File f;
        int i;
        int sz = args.size();
        String[] compilerArgs = new String[sz + 1];
        compilerArgs[0] = "-g";
        for (i = 0; i < sz; ++i) {
            compilerArgs[i + 1] = args.get(i);
        }
        if (!RunJavac.runJavac(compilerArgs, this.verbose)) {
            System.exit(1);
        }
        for (i = 1; i <= sz; ++i) {
            if (this.keep) continue;
            f = new File(compilerArgs[i]);
            f.delete();
        }
        if (this.fromIbisc) {
            for (i = 1; i <= sz; ++i) {
                f = new File(compilerArgs[i]);
                File base = f.getParentFile();
                if (base == null) {
                    base = new File(".");
                }
                String fn = f.getName();
                fn = fn.substring(0, fn.length() - 5);
                String[] list = base.list();
                for (int j = 0; j < list.length; ++j) {
                    if (!list[j].startsWith(fn) || !list[j].endsWith(".class")) continue;
                    String name = base.getPath() + File.separator + list[j];
                    try {
                        ClassInfo cl = this.wrapper.parseClassFile(name);
                        this.addEntry(cl, fromClass);
                        new File(name).delete();
                        continue;
                    }
                    catch (Exception e) {
                        System.err.println("Could not read " + name);
                        System.exit(1);
                    }
                }
            }
        }
    }

    private class ClassIterator
    implements Iterator<Object> {
        Iterator<IbiscEntry> i;

        ClassIterator() {
            this.i = IbiscComponent.this.allClasses.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public Object next() {
            IbiscEntry e = this.i.next();
            return e.getClassInfo().getClassObject();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

