/*
 * Decompiled with CFR 0.152.
 */
package ibis.compile;

import ibis.compile.ClassInfo;
import ibis.compile.Ibisc;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.TraceClassVisitor;

public class ASMClassInfo
implements ClassInfo {
    private ClassNode n;

    public ASMClassInfo(ClassNode n) {
        this.n = n;
    }

    @Override
    public String getClassName() {
        return this.n.name.replaceAll("/", ".");
    }

    @Override
    public Object getClassObject() {
        return this.n;
    }

    void setClassObject(ClassNode n) {
        this.n = n;
    }

    @Override
    public void dump(String fileName) throws IOException {
        byte[] b = this.getBytes();
        FileOutputStream o = new FileOutputStream(fileName);
        o.write(b);
        o.close();
    }

    @Override
    public byte[] getBytes() {
        ClassWriter w = new ClassWriter(2);
        if (Ibisc.debug) {
            TraceClassVisitor tw = new TraceClassVisitor(new PrintWriter(System.out));
            CheckClassAdapter cw = new CheckClassAdapter((ClassVisitor)tw, false);
            this.n.accept((ClassVisitor)cw);
        }
        this.n.accept((ClassVisitor)w);
        return w.toByteArray();
    }

    @Override
    public boolean doVerify() {
        return true;
    }
}

