#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
A neuropsychological test often used to assess attention.

See also:
http://en.wikipedia.org/wiki/Posner_cueing_task

----

WARNING:
This test was generated by pyFlies (https://github.com/igordejanovic/pyFlies)
on 2020-10-31 11:44:48. The code is partially based on the PsychoPy Builder compiler code and demos.

If you are going to regenerate this file from the pyFlies model again
do not edit it manually or else your manual changes will be lost.

If you publish work using this script the most relevant publication is:

Peirce J, Gray JR, Simpson S, MacAskill M, Höchenberger R, Sogo H, Kastman E, Lindeløv JK. (2019)
    PsychoPy2: Experiments in behavior made easy Behav Res 51: 195.
    https://doi.org/10.3758/s13428-018-01193-y

"""
from __future__ import absolute_import, division

import os  # handy system and path functions
import sys  # to get file system encoding
import re
from random import sample

import numpy as np  # whole numpy lib is available, prepend 'np.'
from numpy import (sin, cos, tan, log, log10, pi, average,
                   sqrt, std, deg2rad, rad2deg, linspace, asarray)
from numpy.random import random, randint, normal, shuffle

from psychopy import locale_setup
from psychopy import prefs
from psychopy import gui, visual, sound, core, data, event, logging, clock
from psychopy.constants import (NOT_STARTED, STARTED, PLAYING, PAUSED,
                                STOPPED, FINISHED, PRESSED, RELEASED, FOREVER)
from psychopy.hardware import keyboard


# Ensure that relative paths start from the same directory as this script
_thisDir = os.path.dirname(os.path.abspath(__file__))
os.chdir(_thisDir)

# Store info about the experiment session
psychopyVersion = '2020.1.3'
expName = ''
expInfo = {'participant': '', 'session': '001'}
dlg = gui.DlgFromDict(dictionary=expInfo, sortKeys=False, title=expName)
if dlg.OK == False:
    core.quit()  # user pressed cancel
expInfo['date'] = data.getDateStr()  # add a simple timestamp
expInfo['expName'] = expName
expInfo['psychopyVersion'] = psychopyVersion

# Data file name stem = absolute path + name; later add .psyexp, .csv, .log, etc
filename = os.path.join(_thisDir, u'data',
                        u'%s_%s_%s' % (expInfo['participant'], expName, expInfo['date']))

# An ExperimentHandler isn't essential but helps with data saving
thisExp = data.ExperimentHandler(name=expName, version='',
    extraInfo=expInfo, runtimeInfo=None,
    originPath=__file__,
    savePickle=True, saveWideText=True,
    dataFileName=filename)
# save a log file for detail verbose info
logFile = logging.LogFile(filename+'.log', level=logging.EXP)
logging.console.setLevel(logging.WARNING)  # this outputs to the screen, not a file

endExpNow = False  # flag for 'escape' or other condition => quit the exp
frameTolerance = 0.001  # how close to onset before 'same' frame

# Setup the Window
win = visual.Window(
    size=(1024, 768), fullscr=False,
    color='black', units='height')
# store frame rate of monitor if we can measure it
expInfo['frameRate'] = win.getActualFrameRate()
if expInfo['frameRate'] != None:
    frameDur = 1.0 / round(expInfo['frameRate'])
else:
    frameDur = 1.0 / 60.0  # could not measure, so guess

# create a default keyboard (e.g. to check for escape)
defaultKeyboard = keyboard.Keyboard()

# Initialize components for Posner test
Posner_clock = core.Clock()
Posner_rectangle = visual.Rect(win=win, name='Posner_rectangle', pos=(-0.5, 0), size=0.2, lineColor='white', fillColor='black')
Posner_rectangle.model_name = None
Posner_rectangle.cname = 'Posner_rectangle'

Posner_rectangle_2 = visual.Rect(win=win, name='Posner_rectangle_2', pos=(0.5, 0), size=0.2, lineColor='white', fillColor='black')
Posner_rectangle_2.model_name = None
Posner_rectangle_2.cname = 'Posner_rectangle_2'

Posner_cue = visual.Rect(win=win, name='Posner_cue', size=0.18, lineColor='white', fillColor='black')
Posner_cue.model_name = 'cue'
Posner_cue.cname = 'Posner_cue'

Posner_target = visual.Rect(win=win, name='Posner_target', size=0.2, lineColor='white', fillColor='white')
Posner_target.model_name = 'target'
Posner_target.cname = 'Posner_target'

Posner_keyboard = keyboard.Keyboard()
Posner_keyboard.model_name = None
Posner_keyboard.cname = 'Posner_keyboard'
Posner_keyboard.valid_keys = ['left', 'right', 'quit']

Posner_circle = visual.Circle(win=win, name='Posner_circle', fillColor='green', lineColor='green', radius=1.0, pos=(0.0, 0.0), size=0.2)
Posner_circle.model_name = None
Posner_circle.cname = 'Posner_circle'

Posner_circle_2 = visual.Circle(win=win, name='Posner_circle_2', fillColor='red', lineColor='green', radius=1.0, pos=(0.0, 0.0), size=0.2)
Posner_circle_2.model_name = None
Posner_circle_2.cname = 'Posner_circle_2'


Posner_components = [
    Posner_rectangle,
    Posner_rectangle_2,
    Posner_cue,
    Posner_target,
    Posner_keyboard,
    Posner_circle,
    Posner_circle_2]

# Initialize components for Practice screen
Practice_clock = core.Clock()
Practice = visual.TextStim(win=win, name='Practice', height=0.08,
    text=r'''Posner Cueing
    -------------

    You will be presented with the two empty boxes positioned left and right from
    the center of the screen. You should concentrate on the center of the screen
    and wait for the cue. The cue will be presented as a box highlight. After some
    time a cross shaped object will be presented in some of the squares. React as
    fast as you can by pressing space button when you detect a cross shaped
    object.

    Press SPACE for practice block.
''')

# Initialize components for Real screen
Real_clock = core.Clock()
Real = visual.TextStim(win=win, name='Real', height=0.08,
    text=r'''Posner Cueing
    -------------

    Now a REAL testing will be performed.

    Press SPACE to start the test.
''')


# Content for screen Practice
Practice_1 = r'''Posner Cueing
    -------------

    You will be presented with the two empty boxes positioned left and right from
    the center of the screen. You should concentrate on the center of the screen
    and wait for the cue. The cue will be presented as a box highlight. After some
    time a cross shaped object will be presented in some of the squares. React as
    fast as you can by pressing space button when you detect a cross shaped
    object.

    Press SPACE for practice block.'''

# Trial component settings for Posner test
Posner_2 = [
       # Trial 1
      {'vars': {'cue_display': 1336,
            'target_display': 2716,
            'ord': 1,
            'cue_pos': 'left',
            'target_pos': 'right',
            'congruency': 'incongruent',
            'repeat_index': 1},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.245,
                'duration': 1.1,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.345,
                'duration': 0.0,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.345,
                'duration': 0.0,
                'params': {'correct': 'right'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 2
      {'vars': {'cue_display': 1166,
            'target_display': 2209,
            'ord': 1,
            'cue_pos': 'right',
            'target_pos': 'left',
            'congruency': 'incongruent',
            'repeat_index': 1},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.478,
                'duration': 1.451,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.929,
                'duration': 0.0,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.929,
                'duration': 0.0,
                'params': {'correct': 'left'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 3
      {'vars': {'cue_display': 1290,
            'target_display': 2735,
            'ord': 1,
            'cue_pos': 'left',
            'target_pos': 'left',
            'congruency': 'congruent',
            'repeat_index': 1},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.189,
                'duration': 1.18,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.369,
                'duration': 0.0,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.369,
                'duration': 0.0,
                'params': {'correct': 'left'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 4
      {'vars': {'cue_display': 1471,
            'target_display': 2891,
            'ord': 1,
            'cue_pos': 'right',
            'target_pos': 'right',
            'congruency': 'congruent',
            'repeat_index': 1},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.346,
                'duration': 1.256,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.602,
                'duration': 0.0,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.602,
                'duration': 0.0,
                'params': {'correct': 'right'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 5
      {'vars': {'cue_display': 1043,
            'target_display': 2242,
            'ord': 2,
            'cue_pos': 'left',
            'target_pos': 'left',
            'congruency': 'congruent',
            'repeat_index': 1},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.023,
                'duration': 1.244,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.267,
                'duration': 0.0,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.267,
                'duration': 0.0,
                'params': {'correct': 'left'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 6
      {'vars': {'cue_display': 1292,
            'target_display': 2422,
            'ord': 2,
            'cue_pos': 'right',
            'target_pos': 'right',
            'congruency': 'congruent',
            'repeat_index': 1},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.384,
                'duration': 1.499,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.883,
                'duration': 0.0,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.883,
                'duration': 0.0,
                'params': {'correct': 'right'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 7
      {'vars': {'cue_display': 1276,
            'target_display': 2626,
            'ord': 3,
            'cue_pos': 'left',
            'target_pos': 'left',
            'congruency': 'congruent',
            'repeat_index': 1},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.398,
                'duration': 1.285,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.683,
                'duration': 0.0,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.683,
                'duration': 0.0,
                'params': {'correct': 'left'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 8
      {'vars': {'cue_display': 1073,
            'target_display': 2436,
            'ord': 3,
            'cue_pos': 'right',
            'target_pos': 'right',
            'congruency': 'congruent',
            'repeat_index': 1},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.338,
                'duration': 1.015,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.353,
                'duration': 0.0,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.353,
                'duration': 0.0,
                'params': {'correct': 'right'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
]

# Content for screen Real
Real_3 = r'''Posner Cueing
    -------------

    Now a REAL testing will be performed.

    Press SPACE to start the test.'''

# Trial component settings for Posner test
Posner_4 = [
       # Trial 1
      {'vars': {'cue_display': 1254,
            'target_display': 2633,
            'ord': 1,
            'cue_pos': 'left',
            'target_pos': 'right',
            'congruency': 'incongruent',
            'repeat_index': 1},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.282,
                'duration': 1.103,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.385,
                'duration': 0.0,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.385,
                'duration': 0.0,
                'params': {'correct': 'right'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 2
      {'vars': {'cue_display': 1292,
            'target_display': 2561,
            'ord': 1,
            'cue_pos': 'right',
            'target_pos': 'left',
            'congruency': 'incongruent',
            'repeat_index': 1},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.107,
                'duration': 1.049,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.156,
                'duration': 0.0,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.156,
                'duration': 0.0,
                'params': {'correct': 'left'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 3
      {'vars': {'cue_display': 1169,
            'target_display': 2449,
            'ord': 1,
            'cue_pos': 'left',
            'target_pos': 'left',
            'congruency': 'congruent',
            'repeat_index': 1},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.12,
                'duration': 1.014,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.134,
                'duration': 0.0,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.134,
                'duration': 0.0,
                'params': {'correct': 'left'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 4
      {'vars': {'cue_display': 1484,
            'target_display': 2704,
            'ord': 1,
            'cue_pos': 'right',
            'target_pos': 'right',
            'congruency': 'congruent',
            'repeat_index': 1},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.469,
                'duration': 1.24,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.709,
                'duration': 0.0,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.709,
                'duration': 0.0,
                'params': {'correct': 'right'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 5
      {'vars': {'cue_display': 1179,
            'target_display': 2603,
            'ord': 2,
            'cue_pos': 'left',
            'target_pos': 'left',
            'congruency': 'congruent',
            'repeat_index': 1},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.484,
                'duration': 1.236,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.72,
                'duration': 0.0,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.72,
                'duration': 0.0,
                'params': {'correct': 'left'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 6
      {'vars': {'cue_display': 1280,
            'target_display': 2530,
            'ord': 2,
            'cue_pos': 'right',
            'target_pos': 'right',
            'congruency': 'congruent',
            'repeat_index': 1},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.21,
                'duration': 1.444,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.654,
                'duration': 0.0,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.654,
                'duration': 0.0,
                'params': {'correct': 'right'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 7
      {'vars': {'cue_display': 1482,
            'target_display': 2931,
            'ord': 3,
            'cue_pos': 'left',
            'target_pos': 'left',
            'congruency': 'congruent',
            'repeat_index': 1},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.063,
                'duration': 1.142,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.205,
                'duration': 0.0,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.205,
                'duration': 0.0,
                'params': {'correct': 'left'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 8
      {'vars': {'cue_display': 1109,
            'target_display': 2446,
            'ord': 3,
            'cue_pos': 'right',
            'target_pos': 'right',
            'congruency': 'congruent',
            'repeat_index': 1},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.038,
                'duration': 1.254,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.292,
                'duration': 0.0,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.292,
                'duration': 0.0,
                'params': {'correct': 'right'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
]

# Trial component settings for Posner test
Posner_5 = [
       # Trial 1
      {'vars': {'cue_display': 1312,
            'target_display': 2678,
            'ord': 1,
            'cue_pos': 'left',
            'target_pos': 'right',
            'congruency': 'incongruent',
            'repeat_index': 2},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.331,
                'duration': 1.019,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.35,
                'duration': 0.0,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.35,
                'duration': 0.0,
                'params': {'correct': 'right'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 2
      {'vars': {'cue_display': 1210,
            'target_display': 2440,
            'ord': 1,
            'cue_pos': 'right',
            'target_pos': 'left',
            'congruency': 'incongruent',
            'repeat_index': 2},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.148,
                'duration': 1.187,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.335,
                'duration': 0.0,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.335,
                'duration': 0.0,
                'params': {'correct': 'left'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 3
      {'vars': {'cue_display': 1113,
            'target_display': 2500,
            'ord': 1,
            'cue_pos': 'left',
            'target_pos': 'left',
            'congruency': 'congruent',
            'repeat_index': 2},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.137,
                'duration': 1.454,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.591,
                'duration': 0.0,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.591,
                'duration': 0.0,
                'params': {'correct': 'left'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 4
      {'vars': {'cue_display': 1418,
            'target_display': 2656,
            'ord': 1,
            'cue_pos': 'right',
            'target_pos': 'right',
            'congruency': 'congruent',
            'repeat_index': 2},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.472,
                'duration': 1.48,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.952,
                'duration': 0.0,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.952,
                'duration': 0.0,
                'params': {'correct': 'right'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 5
      {'vars': {'cue_display': 1118,
            'target_display': 2136,
            'ord': 2,
            'cue_pos': 'left',
            'target_pos': 'left',
            'congruency': 'congruent',
            'repeat_index': 2},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.29,
                'duration': 1.167,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.457,
                'duration': 0.0,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.457,
                'duration': 0.0,
                'params': {'correct': 'left'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 6
      {'vars': {'cue_display': 1450,
            'target_display': 2570,
            'ord': 2,
            'cue_pos': 'right',
            'target_pos': 'right',
            'congruency': 'congruent',
            'repeat_index': 2},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.231,
                'duration': 1.019,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.25,
                'duration': 0.0,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.25,
                'duration': 0.0,
                'params': {'correct': 'right'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 7
      {'vars': {'cue_display': 1333,
            'target_display': 2805,
            'ord': 3,
            'cue_pos': 'left',
            'target_pos': 'left',
            'congruency': 'congruent',
            'repeat_index': 2},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.241,
                'duration': 1.414,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.655,
                'duration': 0.0,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.655,
                'duration': 0.0,
                'params': {'correct': 'left'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 8
      {'vars': {'cue_display': 1186,
            'target_display': 2441,
            'ord': 3,
            'cue_pos': 'right',
            'target_pos': 'right',
            'congruency': 'congruent',
            'repeat_index': 2},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.48,
                'duration': 1.49,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.97,
                'duration': 0.0,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.97,
                'duration': 0.0,
                'params': {'correct': 'right'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
]

# Trial component settings for Posner test
Posner_6 = [
       # Trial 1
      {'vars': {'cue_display': 1049,
            'target_display': 2185,
            'ord': 1,
            'cue_pos': 'left',
            'target_pos': 'right',
            'congruency': 'incongruent',
            'repeat_index': 3},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.136,
                'duration': 1.31,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.446,
                'duration': 0.0,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.446,
                'duration': 0.0,
                'params': {'correct': 'right'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 2
      {'vars': {'cue_display': 1385,
            'target_display': 2850,
            'ord': 1,
            'cue_pos': 'right',
            'target_pos': 'left',
            'congruency': 'incongruent',
            'repeat_index': 3},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.038,
                'duration': 1.205,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.243,
                'duration': 0.0,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.243,
                'duration': 0.0,
                'params': {'correct': 'left'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 3
      {'vars': {'cue_display': 1140,
            'target_display': 2272,
            'ord': 1,
            'cue_pos': 'left',
            'target_pos': 'left',
            'congruency': 'congruent',
            'repeat_index': 3},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.445,
                'duration': 1.49,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.935,
                'duration': 0.0,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.935,
                'duration': 0.0,
                'params': {'correct': 'left'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 4
      {'vars': {'cue_display': 1430,
            'target_display': 2484,
            'ord': 1,
            'cue_pos': 'right',
            'target_pos': 'right',
            'congruency': 'congruent',
            'repeat_index': 3},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.459,
                'duration': 1.288,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.747,
                'duration': 0.0,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.747,
                'duration': 0.0,
                'params': {'correct': 'right'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 5
      {'vars': {'cue_display': 1204,
            'target_display': 2589,
            'ord': 2,
            'cue_pos': 'left',
            'target_pos': 'left',
            'congruency': 'congruent',
            'repeat_index': 3},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.203,
                'duration': 1.398,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.601,
                'duration': 0.0,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.601,
                'duration': 0.0,
                'params': {'correct': 'left'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 6
      {'vars': {'cue_display': 1260,
            'target_display': 2554,
            'ord': 2,
            'cue_pos': 'right',
            'target_pos': 'right',
            'congruency': 'congruent',
            'repeat_index': 3},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.217,
                'duration': 1.296,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.513,
                'duration': 0.0,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.513,
                'duration': 0.0,
                'params': {'correct': 'right'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 7
      {'vars': {'cue_display': 1043,
            'target_display': 2330,
            'ord': 3,
            'cue_pos': 'left',
            'target_pos': 'left',
            'congruency': 'congruent',
            'repeat_index': 3},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.431,
                'duration': 1.194,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.625,
                'duration': 0.0,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.625,
                'duration': 0.0,
                'params': {'correct': 'left'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 8
      {'vars': {'cue_display': 1471,
            'target_display': 2574,
            'ord': 3,
            'cue_pos': 'right',
            'target_pos': 'right',
            'congruency': 'congruent',
            'repeat_index': 3},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.008,
                'duration': 1.012,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.02,
                'duration': 0.0,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.02,
                'duration': 0.0,
                'params': {'correct': 'right'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
]

# Trial component settings for Posner test
Posner_7 = [
       # Trial 1
      {'vars': {'cue_display': 1144,
            'target_display': 2331,
            'ord': 1,
            'cue_pos': 'left',
            'target_pos': 'right',
            'congruency': 'incongruent',
            'repeat_index': 4},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.316,
                'duration': 1.204,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.52,
                'duration': 0.0,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.52,
                'duration': 0.0,
                'params': {'correct': 'right'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 2
      {'vars': {'cue_display': 1024,
            'target_display': 2358,
            'ord': 1,
            'cue_pos': 'right',
            'target_pos': 'left',
            'congruency': 'incongruent',
            'repeat_index': 4},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.436,
                'duration': 1.307,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.743,
                'duration': 0.0,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.743,
                'duration': 0.0,
                'params': {'correct': 'left'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 3
      {'vars': {'cue_display': 1360,
            'target_display': 2831,
            'ord': 1,
            'cue_pos': 'left',
            'target_pos': 'left',
            'congruency': 'congruent',
            'repeat_index': 4},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.382,
                'duration': 1.279,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.661,
                'duration': 0.0,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.661,
                'duration': 0.0,
                'params': {'correct': 'left'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 4
      {'vars': {'cue_display': 1135,
            'target_display': 2211,
            'ord': 1,
            'cue_pos': 'right',
            'target_pos': 'right',
            'congruency': 'congruent',
            'repeat_index': 4},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.136,
                'duration': 1.34,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.476,
                'duration': 0.0,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.476,
                'duration': 0.0,
                'params': {'correct': 'right'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 5
      {'vars': {'cue_display': 1070,
            'target_display': 2192,
            'ord': 2,
            'cue_pos': 'left',
            'target_pos': 'left',
            'congruency': 'congruent',
            'repeat_index': 4},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.472,
                'duration': 1.163,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.635,
                'duration': 0.0,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.635,
                'duration': 0.0,
                'params': {'correct': 'left'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 6
      {'vars': {'cue_display': 1087,
            'target_display': 2119,
            'ord': 2,
            'cue_pos': 'right',
            'target_pos': 'right',
            'congruency': 'congruent',
            'repeat_index': 4},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.33,
                'duration': 1.18,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.51,
                'duration': 0.0,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.51,
                'duration': 0.0,
                'params': {'correct': 'right'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 7
      {'vars': {'cue_display': 1131,
            'target_display': 2289,
            'ord': 3,
            'cue_pos': 'left',
            'target_pos': 'left',
            'congruency': 'congruent',
            'repeat_index': 4},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.398,
                'duration': 1.012,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.41,
                'duration': 0.0,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.41,
                'duration': 0.0,
                'params': {'correct': 'left'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 8
      {'vars': {'cue_display': 1181,
            'target_display': 2666,
            'ord': 3,
            'cue_pos': 'right',
            'target_pos': 'right',
            'congruency': 'congruent',
            'repeat_index': 4},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.291,
                'duration': 1.43,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.721,
                'duration': 0.0,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.721,
                'duration': 0.0,
                'params': {'correct': 'right'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
]

# Trial component settings for Posner test
Posner_8 = [
       # Trial 1
      {'vars': {'cue_display': 1265,
            'target_display': 2295,
            'ord': 1,
            'cue_pos': 'left',
            'target_pos': 'right',
            'congruency': 'incongruent',
            'repeat_index': 5},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.482,
                'duration': 1.308,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.79,
                'duration': 0.0,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.79,
                'duration': 0.0,
                'params': {'correct': 'right'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 2
      {'vars': {'cue_display': 1139,
            'target_display': 2239,
            'ord': 1,
            'cue_pos': 'right',
            'target_pos': 'left',
            'congruency': 'incongruent',
            'repeat_index': 5},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.157,
                'duration': 1.066,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.223,
                'duration': 0.0,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.223,
                'duration': 0.0,
                'params': {'correct': 'left'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 3
      {'vars': {'cue_display': 1072,
            'target_display': 2208,
            'ord': 1,
            'cue_pos': 'left',
            'target_pos': 'left',
            'congruency': 'congruent',
            'repeat_index': 5},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.439,
                'duration': 1.075,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.514,
                'duration': 0.0,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.514,
                'duration': 0.0,
                'params': {'correct': 'left'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 4
      {'vars': {'cue_display': 1191,
            'target_display': 2389,
            'ord': 1,
            'cue_pos': 'right',
            'target_pos': 'right',
            'congruency': 'congruent',
            'repeat_index': 5},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.118,
                'duration': 1.217,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.335,
                'duration': 0.0,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.335,
                'duration': 0.0,
                'params': {'correct': 'right'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 5
      {'vars': {'cue_display': 1116,
            'target_display': 2598,
            'ord': 2,
            'cue_pos': 'left',
            'target_pos': 'left',
            'congruency': 'congruent',
            'repeat_index': 5},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.284,
                'duration': 1.406,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.69,
                'duration': 0.0,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.69,
                'duration': 0.0,
                'params': {'correct': 'left'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 6
      {'vars': {'cue_display': 1359,
            'target_display': 2506,
            'ord': 2,
            'cue_pos': 'right',
            'target_pos': 'right',
            'congruency': 'congruent',
            'repeat_index': 5},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.155,
                'duration': 1.348,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.503,
                'duration': 0.0,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.503,
                'duration': 0.0,
                'params': {'correct': 'right'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 7
      {'vars': {'cue_display': 1249,
            'target_display': 2329,
            'ord': 3,
            'cue_pos': 'left',
            'target_pos': 'left',
            'congruency': 'congruent',
            'repeat_index': 5},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.091,
                'duration': 1.053,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.144,
                'duration': 0.0,
                'params': {'pos': (-0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.144,
                'duration': 0.0,
                'params': {'correct': 'left'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
       # Trial 8
      {'vars': {'cue_display': 1054,
            'target_display': 2388,
            'ord': 3,
            'cue_pos': 'right',
            'target_pos': 'right',
            'congruency': 'congruent',
            'repeat_index': 5},
        'ph_exec': [
            {'inst': Posner_rectangle,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_rectangle_2,
                'type': 'visual.rectangle',
                'at': 0.0,
                'duration': 0.0,
                'params': {}},
            {'inst': Posner_cue,
                'type': 'visual.rectangle',
                'at': 1.476,
                'duration': 1.146,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_target,
                'type': 'visual.rectangle',
                'at': 2.622,
                'duration': 0.0,
                'params': {'pos': (0.5, 0)}},
            {'inst': Posner_keyboard,
                'type': 'input.keyboard',
                'at': 2.622,
                'duration': 0.0,
                'params': {'correct': 'right'}}],
        'ph_error': [
            {'inst': Posner_circle_2,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}],
        'ph_correct': [
            {'inst': Posner_circle,
                'type': 'visual.circle',
                'at': 0.0,
                'duration': 0.3,
                'params': {}}]},
]



def unindent(s):
    """
    Remove whitespaces from the beginning of each line of the string s.
    """
    return re.sub(r'\n[\t ]+', r'\n', s)


def get_param(comp, param_name):
    """
    Returns component param for the given name
    """
    try:
        return [v for k, v in comp['params'].items() if k == param_name][0]
    except KeyError:
        return None


def execute_screen(screen, content, duration):
    "Displays the given screen"

    # Calculate font size based on the content number of lines
    screen.setHeight(min(0.5 / len(content.splitlines()), 0.08))

    screen.setText(unindent(content))
    screen.setAutoDraw(True)
    win.flip()

    # Wait for the duration. During wait check for key presses.
    key = event.waitKeys(maxWait=duration if duration > 0 else float('inf'))
    screen.setAutoDraw(False)

    if key in ['escape', 'q']:
        core.quit()


def execute_test(test_trials, test_components, random=False, practice=False):
    """
    Execute given test.  Run components with the given timing and collect
    responses.
    """

    def execute_phase(components, variables=None, should_record=False):
        if not components:
            return
        # reset timers
        t = 0
        _timeToFirstFrame = win.getFutureFlipTime(clock="now")
        trialClock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
        frameN = -1
        continueTest = True
        correct_response = True

        while continueTest:
            t = trialClock.getTime()
            tThisFlip = win.getFutureFlipTime(clock=trialClock)
            tThisFlipGlobal = win.getFutureFlipTime(clock=None)
            frameN = frameN + 1  # number of completed frames (so 0 is the first frame)

            # update/draw components on each frame
            for component in components:
                cinst = component['inst']
                ctype = component['type']

                if cinst.status == NOT_STARTED \
                    and tThisFlip >= component['at'] - frameTolerance:
                    # keep track of start time/frame for later
                    cinst.frameNStart = frameN  # exact frame index
                    cinst.tStart = t  # local t and not account for scr refresh
                    cinst.tStartRefresh = tThisFlipGlobal  # on global time
                    win.timeOnFlip(cinst, 'tStartRefresh')  # time at next scr refresh
                    cinst.status = STARTED

                    # Set component parameters for this trial
                    for pname, pval in component['params'].items():
                        setattr(cinst, pname, pval)

                    # If component is audible start playing
                    if 'audible' in ctype:
                        cinst.play()
                    elif 'mouse' in ctype:
                        cinst.mouseClock.reset()
                        # if button is down already this ISN'T a new click
                        prevButtonState = cinst.getPressed()
                    elif 'keyboard' in ctype:
                        cinst.getKeys()
                        cinst.clock.reset()
                        cinst.start()

                    # Display component on the next flip
                    if 'visual' in ctype:
                        cinst.setAutoDraw(True)

                if 'keyboard' in ctype and cinst.status == STARTED:
                    keys = cinst.getKeys(cinst.valid_keys, waitRelease=False)
                    if 'quit' in keys:
                        core.quit()
                    if keys:
                        correct_keys = get_param(component, 'correct')
                        correct_response = not correct_keys or keys[0].name in correct_keys
                        cinst.key_name = keys[0].name
                        cinst.key_rt = keys[0].rt
                        cinst.key_correct = correct_response
                        continueTest = False

                elif 'mouse' in ctype and cinst.status == STARTED:
                    buttons = cinst.getPressed()
                    if buttons != prevButtonState:  # button state changed?
                        prevButtonState = buttons
                        if sum(buttons) > 0:  # state changed to a new click
                            # If target object(s) are/is defined
                            # check if the mouse was inside our 'clickable' objects
                            # If we don't have targets, then any click is valid
                            x, y = cinst.getPos()
                            gotValidClick = not bool(cinst.targets)
                            for obj in cinst.targets:
                                if obj.contains(x, y):
                                    gotValidClick = True
                                    cinst.clicked_name.append(obj.name)
                            cinst.x.append(x)
                            cinst.y.append(y)
                            buttons = cinst.getPressed()
                            cinst.leftButton.append(buttons[0])
                            cinst.midButton.append(buttons[1])
                            cinst.rightButton.append(buttons[2])
                            cinst.time.append(cinst.mouseClock.getTime())
                            if gotValidClick:  # abort routine on response
                                continueTest = False

                if component['duration'] > 0 and cinst.status == STARTED:
                    # is it time to stop? (based on global clock, using actual start)
                    if tThisFlipGlobal > cinst.tStartRefresh \
                        + component['duration'] - frameTolerance:
                        # keep track of stop time/frame for later
                        cinst.tStop = t  # not accounting for scr refresh
                        cinst.frameNStop = frameN  # exact frame index
                        cinst.status = FINISHED
                        win.timeOnFlip(cinst, 'tStopRefresh')  # time at next scr refresh

                        # If component is audible stop playing
                        if 'audible' in ctype:
                            cinst.stop()
                        elif 'visual' in ctype:
                            cinst.setAutoDraw(False)

            # check for quit (typically the Esc key)
            if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
                core.quit()

            # check if all components have finished
            if not continueTest:
                break
            # will revert to True if at least one component still running
            continueTest = False
            for thisComponent in [c['inst'] for c in components]:
                if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
                    continueTest = True
                    # at least one component has not yet finished
                    break

            # refresh the screen
            # don't flip if this test is over or we'll get a blank screen
            if continueTest:
                win.flip()

        # At the end of the phase stop all components
        for component in components:
            cinst = component['inst']
            ctype = component['type']
            if 'visual' in ctype:
                cinst.setAutoDraw(False)
            # If component is audible stop playing
            elif 'audible' in ctype:
                cinst.stop()

        # Register interesting data if not a practice run
        if not practice and should_record:

            # Register trial variables values
            for k, v in variables.items():
                thisExp.addData(k, v) 

            for component in components:
                cinst = component['inst']
                ctype = component['type']

                def datap(attr, name=None):
                    name = attr if name is None else name
                    cname = cinst.model_name if cinst.model_name else cinst.cname
                    col_name = '{}.{}'.format(cname, name)
                    value = getattr(cinst, attr)
                    if type(value) is list:
                        value = value[0]
                    return (col_name, value)

                # component parameters for this trial
                for pname, pval in component['params'].items():
                    cname = cinst.model_name if cinst.model_name else cinst.cname
                    if type(pval) is tuple: pval = str(pval)
                    thisExp.addData('{}.{}'.format(cname, pname), pval)

                if 'keyboard' in ctype:
                    thisExp.addData(*datap('key_name', 'name'))
                    thisExp.addData(*datap('key_rt', 'rt'))
                    thisExp.addData(*datap('key_correct', 'correct'))
                elif 'mouse' in ctype:
                    for dname in ['x', 'y', 'leftButton', 'midButton',
                                  'rightButton', 'time', 'clicked_name']:
                        thisExp.addData(*datap(dname))
                    thisExp.addData(*datap('tStart', 'started'))
                    thisExp.addData(*datap('tStop', 'stopped'))

                elif cinst.model_name is not None:
                    # If we defined name for component in the model we shall record
                    # its start/stop times/frames
                    thisExp.addData(*datap('tStartRefresh', 'started'))
                    thisExp.addData(*datap('frameNStart', 'startFrame'))
                    thisExp.addData(*datap('tStopRefresh', 'stopped'))
                    thisExp.addData(*datap('frameNStop', 'stopFrame'))

            thisExp.nextEntry()

        return correct_response

    # Run trials
    phases = ['ph_fix', 'ph_exec', 'ph_correct', 'ph_error']
    for trial in sample(test_trials, len(test_trials)) if random else test_trials:
        # Initialize components for this trial
        for component in [c for phase in phases for c in trial.get(phase, [])]:
            cinst = component['inst']
            cparams = component['params']
            ctype = component['type']
            cinst.tStart = None
            cinst.tStop = None
            cinst.tStartRefresh = None
            cinst.tStopRefresh = None
            cinst.frameNStart = None
            cinst.frameNStop = None
            if hasattr(cinst, 'status'):
                cinst.status = NOT_STARTED

            # Set component parameters for this trial
            for pname, pval in cparams.items():
                setattr(cinst, pname, pval)

            # If component is audible set duration
            if 'audible' in ctype:
                cinst.secs = component['duration']
            elif 'mouse' in ctype:
                cinst.x = []
                cinst.y = []
                cinst.leftButton = []
                cinst.midButton = []
                cinst.rightButton = []
                cinst.time = []
                cinst.clicked_name = []

        for phase in ['ph_fix', 'ph_exec']:
            if phase in trial:
                correct = execute_phase(trial[phase], trial['vars'], should_record=phase=='ph_exec')

        if correct and 'ph_correct' in trial:
            execute_phase(trial['ph_correct'])
        elif 'ph_error' in trial:
            execute_phase(trial['ph_error'])

# Create some handy timers
globalClock = core.Clock()  # to track the time since experiment started
trialClock = core.Clock()
routineTimer = core.CountdownTimer()  # to track time remaining of each (non-slip) routine

# Experiment flow
execute_screen(Practice, Practice_1, 0.0)
execute_test(Posner_2, Posner_components, random=True, practice=True)
execute_screen(Real, Real_3, 0.0)
execute_test(Posner_4, Posner_components, random=True)
execute_test(Posner_5, Posner_components, random=True)
execute_test(Posner_6, Posner_components, random=True)
execute_test(Posner_7, Posner_components, random=True)
execute_test(Posner_8, Posner_components, random=True)

# Flip one final time so any remaining win.callOnFlip()
# and win.timeOnFlip() tasks get executed before quitting
win.flip()

# these shouldn't be strictly necessary (should auto-save)
thisExp.saveAsWideText(filename+'.csv', delim='auto')
thisExp.saveAsPickle(filename)
logging.flush()
# make sure everything is closed down
thisExp.abort()  # or data files will save again on exit
win.close()
core.quit()