"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = require("path");
const cdk = require("aws-cdk-lib");
const index_1 = require("./index");
// eslint-disable-next-line import/order
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'MyStack');
const lambdaFunction = new aws_lambda_1.Function(stack, 'sqs-pusher-lambda', {
    functionName: 'sqs-pusher-lambda',
    runtime: aws_lambda_1.Runtime.PYTHON_3_9,
    handler: 'index.handler',
    code: aws_lambda_1.Code.fromAsset(path_1.join(__dirname, 'lambda-handler')),
});
const apiGatewayToSqsToLambdaProps = {
    serviceName: 'sqs-pusher',
    domain: 'example.com',
    domainCertArn: 'arn:aws:acm:eu-central-1:1234567852354:certificate/123123sdf-dsf-sdfs-sdsad-sadsdasdasd',
    route53HostedZoneId: 'Z0633005JYFGNZXCT3BN',
    deployDeadLetterQueue: true,
    lambdaFunction: lambdaFunction,
};
new index_1.ApiGatewayToSqsToLambda(stack, 'ApiGateway-Sqs-Lambda', apiGatewayToSqsToLambdaProps);
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZGVmYXVsdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9pbnRlZy5kZWZhdWx0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsK0JBQTRCO0FBQzVCLG1DQUFtQztBQUNuQyxtQ0FBa0Q7QUFDbEQsd0NBQXdDO0FBQ3hDLHVEQUlnQztBQUVoQyxNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQztBQUMxQixNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsR0FBRyxFQUFFLFNBQVMsQ0FBQyxDQUFDO0FBRTVDLE1BQU0sY0FBYyxHQUFHLElBQUkscUJBQWMsQ0FBQyxLQUFLLEVBQUUsbUJBQW1CLEVBQUU7SUFDcEUsWUFBWSxFQUFFLG1CQUFtQjtJQUNqQyxPQUFPLEVBQUUsb0JBQU8sQ0FBQyxVQUFVO0lBQzNCLE9BQU8sRUFBRSxlQUFlO0lBQ3hCLElBQUksRUFBRSxpQkFBSSxDQUFDLFNBQVMsQ0FBQyxXQUFJLENBQUMsU0FBUyxFQUFFLGdCQUFnQixDQUFDLENBQUM7Q0FDeEQsQ0FBQyxDQUFDO0FBRUgsTUFBTSw0QkFBNEIsR0FBRztJQUNuQyxXQUFXLEVBQUUsWUFBWTtJQUN6QixNQUFNLEVBQUUsYUFBYTtJQUNyQixhQUFhLEVBQ1gseUZBQXlGO0lBQzNGLG1CQUFtQixFQUFFLHNCQUFzQjtJQUMzQyxxQkFBcUIsRUFBRSxJQUFJO0lBQzNCLGNBQWMsRUFBRSxjQUFjO0NBQy9CLENBQUM7QUFFRixJQUFJLCtCQUF1QixDQUN6QixLQUFLLEVBQ0wsdUJBQXVCLEVBQ3ZCLDRCQUE0QixDQUM3QixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgam9pbiB9IGZyb20gJ3BhdGgnO1xuaW1wb3J0ICogYXMgY2RrIGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IEFwaUdhdGV3YXlUb1Nxc1RvTGFtYmRhIH0gZnJvbSAnLi9pbmRleCc7XG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgaW1wb3J0L29yZGVyXG5pbXBvcnQge1xuICBSdW50aW1lLFxuICBDb2RlLFxuICBGdW5jdGlvbiBhcyBMYW1iZGFGdW5jdGlvbixcbn0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWxhbWJkYSc7XG5cbmNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5jb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soYXBwLCAnTXlTdGFjaycpO1xuXG5jb25zdCBsYW1iZGFGdW5jdGlvbiA9IG5ldyBMYW1iZGFGdW5jdGlvbihzdGFjaywgJ3Nxcy1wdXNoZXItbGFtYmRhJywge1xuICBmdW5jdGlvbk5hbWU6ICdzcXMtcHVzaGVyLWxhbWJkYScsXG4gIHJ1bnRpbWU6IFJ1bnRpbWUuUFlUSE9OXzNfOSxcbiAgaGFuZGxlcjogJ2luZGV4LmhhbmRsZXInLFxuICBjb2RlOiBDb2RlLmZyb21Bc3NldChqb2luKF9fZGlybmFtZSwgJ2xhbWJkYS1oYW5kbGVyJykpLFxufSk7XG5cbmNvbnN0IGFwaUdhdGV3YXlUb1Nxc1RvTGFtYmRhUHJvcHMgPSB7XG4gIHNlcnZpY2VOYW1lOiAnc3FzLXB1c2hlcicsXG4gIGRvbWFpbjogJ2V4YW1wbGUuY29tJyxcbiAgZG9tYWluQ2VydEFybjpcbiAgICAnYXJuOmF3czphY206ZXUtY2VudHJhbC0xOjEyMzQ1Njc4NTIzNTQ6Y2VydGlmaWNhdGUvMTIzMTIzc2RmLWRzZi1zZGZzLXNkc2FkLXNhZHNkYXNkYXNkJyxcbiAgcm91dGU1M0hvc3RlZFpvbmVJZDogJ1owNjMzMDA1SllGR05aWENUM0JOJyxcbiAgZGVwbG95RGVhZExldHRlclF1ZXVlOiB0cnVlLFxuICBsYW1iZGFGdW5jdGlvbjogbGFtYmRhRnVuY3Rpb24sXG59O1xuXG5uZXcgQXBpR2F0ZXdheVRvU3FzVG9MYW1iZGEoXG4gIHN0YWNrLFxuICAnQXBpR2F0ZXdheS1TcXMtTGFtYmRhJyxcbiAgYXBpR2F0ZXdheVRvU3FzVG9MYW1iZGFQcm9wcyxcbik7XG4iXX0=