# 示例代码

欢迎来到 EmailWidget 示例代码库！这里提供了丰富的实际应用示例，帮助您快速掌握 EmailWidget 的各种功能和最佳实践。

## 📚 示例分类

### 🚀 [基础示例](basic.md)
适合初学者，展示 EmailWidget 的基本功能和常用模式：
- **快速入门** - 创建第一个邮件报告
- **基本组件** - 文本、表格、图表的基础用法
- **样式设置** - 颜色、字体、对齐等样式配置
- **链式调用** - 优雅的方法链使用

### 📊 [数据报告](data-reports.md)
专注于数据展示和分析报告：
- **销售报告** - 业务数据可视化
- **财务报表** - 图表和表格结合
- **性能分析** - 进度条和状态展示
- **pandas集成** - DataFrame 无缝对接

### 🖥️ [系统监控](system-monitoring.md)
展示系统监控和运维场景的应用：
- **服务器监控** - 资源使用情况展示
- **应用状态** - 服务健康检查报告
- **告警通知** - 多级别警告系统
- **日志分析** - 日志信息结构化展示

### 🕷️ [爬虫报告](spider-reports.md)
针对数据采集和爬虫项目的报告需求：
- **采集统计** - 爬取数据量和成功率
- **异常监控** - 爬虫错误和异常处理
- **数据质量** - 数据验证和清洗结果
- **进度跟踪** - 大型采集任务进度展示

### 🔧 [高级示例](advanced.md)
深入的高级功能和自定义扩展：
- **自定义组件** - 继承 BaseWidget 创建新组件
- **主题系统** - 自定义样式和配色方案
- **模板扩展** - 高级模板技巧
- **性能优化** - 大数据量处理和缓存策略

### 🌍 [实际应用](real-world.md)
真实项目中的完整应用案例：
- **电商分析** - 完整的电商数据分析报告
- **DevOps仪表板** - 运维监控综合仪表板
- **数据科学** - 机器学习实验报告
- **业务看板** - 企业级业务指标看板

## 🎯 学习路径

### 初学者路径 (⭐)
1. 从 [基础示例](basic.md) 开始，掌握基本概念
2. 学习 [数据报告](data-reports.md)，了解数据展示
3. 尝试简单的 [系统监控](system-monitoring.md) 示例

### 进阶用户路径 (⭐⭐)
1. 深入 [爬虫报告](spider-reports.md) 的专业应用
2. 探索 [高级示例](advanced.md) 的扩展功能
3. 参考 [实际应用](real-world.md) 构建完整项目

### 专家级路径 (⭐⭐⭐)
1. 研究所有示例的设计模式
2. 自定义组件和主题系统
3. 贡献新的示例代码

## 💡 使用建议

### 代码运行
所有示例代码都可以直接运行，请确保已安装必要的依赖：

```bash
# 安装基础依赖
pip install email-widget pandas matplotlib

# 可选依赖（用于特定示例）
pip install requests beautifulsoup4 seaborn
```

### 示例结构
每个示例都包含：

- **功能说明** - 示例的用途和适用场景
- **核心代码** - 精简的示例代码
- **详细注释** - 代码的逐行解释
- **运行效果** - 预期的输出结果
- **扩展建议** - 进一步改进的方向

### 最佳实践
- 📖 **边看边练** - 复制代码到本地运行
- 🔄 **循序渐进** - 按推荐路径学习
- 🛠️ **动手修改** - 尝试修改示例参数
- 💬 **分享交流** - 在社区分享您的改进

## 🔍 快速查找

### 按需求查找示例

| 需求 | 推荐示例 | 文档位置 |
|------|----------|----------|
| 创建第一个邮件 | 快速入门 | [basic.md](basic.md#快速入门) |
| 显示数据表格 | 表格展示 | [basic.md](basic.md#表格展示) |
| 添加图表 | 图表集成 | [data-reports.md](data-reports.md#图表集成) |
| 监控服务状态 | 服务监控 | [system-monitoring.md](system-monitoring.md#服务监控) |
| 爬虫进度跟踪 | 采集统计 | [spider-reports.md](spider-reports.md#采集统计) |
| 自定义组件 | 组件扩展 | [advanced.md](advanced.md#组件扩展) |
| 完整项目案例 | 综合应用 | [real-world.md](real-world.md) |

### 按组件查找示例

| 组件 | 主要示例 | 特色功能 |
|------|----------|----------|
| TextWidget | 基础示例 | 各种文本样式 |
| TableWidget | 数据报告 | DataFrame 集成 |
| ChartWidget | 数据报告 | matplotlib 集成 |
| ProgressWidget | 系统监控 | 实时进度展示 |
| AlertWidget | 所有示例 | 多级别提醒 |
| StatusWidget | 系统监控 | 状态聚合展示 |
| CardWidget | 实际应用 | 信息卡片布局 |
| ColumnWidget | 高级示例 | 响应式布局 |

## 📋 示例列表

### 基础功能示例
- ✅ 文本样式设置
- ✅ 表格数据展示  
- ✅ 基础图表集成
- ✅ 进度条使用
- ✅ 警告框展示

### 数据处理示例
- ✅ pandas DataFrame 处理
- ✅ matplotlib 图表生成
- ✅ 数据统计和汇总
- ✅ 动态数据更新

### 系统集成示例
- ✅ 系统资源监控
- ✅ 日志信息展示
- ✅ 服务状态检查
- ✅ 告警信息汇总

### 高级应用示例
- ✅ 自定义 Widget 组件
- ✅ 主题和样式定制
- ✅ 模板系统扩展
- ✅ 性能优化技巧

## 🤝 贡献示例

我们欢迎社区贡献新的示例代码！如果您有好的应用案例：

1. **Fork 项目** - 在 GitHub 上 fork EmailWidget 项目
2. **编写示例** - 按照现有格式编写示例
3. **测试验证** - 确保示例代码可以正常运行
4. **提交 PR** - 提交 Pull Request 供审查

### 示例要求
- 代码简洁清晰，注释详细
- 功能完整，可以直接运行
- 遵循项目的代码规范
- 提供预期的输出结果

---

现在选择适合您水平的示例开始学习吧！建议从 [基础示例](basic.md) 开始。 