"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateProfile = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const consts_1 = require("./cluster-resource-handler/consts");
const cluster_resource_provider_1 = require("./cluster-resource-provider");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("@aws-cdk/core");
/**
 * Fargate profiles allows an administrator to declare which pods run on
 * Fargate. This declaration is done through the profile’s selectors. Each
 * profile can have up to five selectors that contain a namespace and optional
 * labels. You must define a namespace for every selector. The label field
 * consists of multiple optional key-value pairs. Pods that match a selector (by
 * matching a namespace for the selector and all of the labels specified in the
 * selector) are scheduled on Fargate. If a namespace selector is defined
 * without any labels, Amazon EKS will attempt to schedule all pods that run in
 * that namespace onto Fargate using the profile. If a to-be-scheduled pod
 * matches any of the selectors in the Fargate profile, then that pod is
 * scheduled on Fargate.
 *
 * If a pod matches multiple Fargate profiles, Amazon EKS picks one of the
 * matches at random. In this case, you can specify which profile a pod should
 * use by adding the following Kubernetes label to the pod specification:
 * eks.amazonaws.com/fargate-profile: profile_name. However, the pod must still
 * match a selector in that profile in order to be scheduled onto Fargate.
 */
class FargateProfile extends core_2.Construct {
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_eks_FargateProfileProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const provider = cluster_resource_provider_1.ClusterResourceProvider.getOrCreate(this, {
            adminRole: props.cluster.adminRole,
            onEventLayer: props.cluster.onEventLayer,
        });
        this.podExecutionRole = (_b = props.podExecutionRole) !== null && _b !== void 0 ? _b : new iam.Role(this, 'PodExecutionRole', {
            assumedBy: new iam.ServicePrincipal('eks-fargate-pods.amazonaws.com'),
            managedPolicies: [iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonEKSFargatePodExecutionRolePolicy')],
        });
        this.podExecutionRole.grantPassRole(props.cluster.adminRole);
        if (props.subnetSelection && !props.vpc) {
            core_1.Annotations.of(this).addWarning('Vpc must be defined to use a custom subnet selection. All private subnets belonging to the EKS cluster will be used by default');
        }
        let subnets;
        if (props.vpc) {
            const selection = (_c = props.subnetSelection) !== null && _c !== void 0 ? _c : { subnetType: ec2.SubnetType.PRIVATE };
            subnets = props.vpc.selectSubnets(selection).subnetIds;
        }
        if (props.selectors.length < 1) {
            throw new Error('Fargate profile requires at least one selector');
        }
        if (props.selectors.length > 5) {
            throw new Error('Fargate profile supports up to five selectors');
        }
        this.tags = new core_1.TagManager(core_1.TagType.MAP, 'AWS::EKS::FargateProfile');
        const resource = new core_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: consts_1.FARGATE_PROFILE_RESOURCE_TYPE,
            properties: {
                AssumeRoleArn: props.cluster.adminRole.roleArn,
                Config: {
                    clusterName: props.cluster.clusterName,
                    fargateProfileName: props.fargateProfileName,
                    podExecutionRoleArn: this.podExecutionRole.roleArn,
                    selectors: props.selectors,
                    subnets,
                    tags: core_1.Lazy.any({ produce: () => this.tags.renderTags() }),
                },
            },
        });
        this.fargateProfileArn = resource.getAttString('fargateProfileArn');
        this.fargateProfileName = resource.ref;
        // Fargate profiles must be created sequentially. If other profile(s) already
        // exist on the same cluster, create a dependency to force sequential creation.
        const clusterFargateProfiles = props.cluster._attachFargateProfile(this);
        if (clusterFargateProfiles.length > 1) {
            const previousProfile = clusterFargateProfiles[clusterFargateProfiles.length - 2];
            resource.node.addDependency(previousProfile);
        }
        // map the fargate pod execution role to the relevant groups in rbac
        // see https://github.com/aws/aws-cdk/issues/7981
        props.cluster.awsAuth.addRoleMapping(this.podExecutionRole, {
            username: 'system:node:{{SessionName}}',
            groups: [
                'system:bootstrappers',
                'system:nodes',
                'system:node-proxier',
            ],
        });
    }
}
exports.FargateProfile = FargateProfile;
_a = JSII_RTTI_SYMBOL_1;
FargateProfile[_a] = { fqn: "@aws-cdk/aws-eks.FargateProfile", version: "1.154.0" };
//# sourceMappingURL=data:application/json;base64,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