# coding: utf-8

"""
    Xero Finance API

    The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.  # noqa: E501

    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401

from xero_python.models import BaseModel


class ContactDetail(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "contact_id": "str",
        "name": "str",
        "total": "float",
        "total_detail": "ContactTotalDetail",
        "total_other": "ContactTotalOther",
        "account_codes": "list[str]",
    }

    attribute_map = {
        "contact_id": "contactId",
        "name": "name",
        "total": "total",
        "total_detail": "totalDetail",
        "total_other": "totalOther",
        "account_codes": "accountCodes",
    }

    def __init__(
        self,
        contact_id=None,
        name=None,
        total=None,
        total_detail=None,
        total_other=None,
        account_codes=None,
    ):  # noqa: E501
        """ContactDetail - a model defined in OpenAPI"""  # noqa: E501

        self._contact_id = None
        self._name = None
        self._total = None
        self._total_detail = None
        self._total_other = None
        self._account_codes = None
        self.discriminator = None

        if contact_id is not None:
            self.contact_id = contact_id
        if name is not None:
            self.name = name
        if total is not None:
            self.total = total
        if total_detail is not None:
            self.total_detail = total_detail
        if total_other is not None:
            self.total_other = total_other
        if account_codes is not None:
            self.account_codes = account_codes

    @property
    def contact_id(self):
        """Gets the contact_id of this ContactDetail.  # noqa: E501

        ID of the contact associated with the transactions.    Transactions with no contact will be grouped under the special ID: 86793108-198C-46D8-90A3-43C1D12686CE.    Transactions that are receive or spend bank transfers will be grouped under the special ID: 207322B3-6A58-4BE7-80F1-430123914AD6  # noqa: E501

        :return: The contact_id of this ContactDetail.  # noqa: E501
        :rtype: str
        """
        return self._contact_id

    @contact_id.setter
    def contact_id(self, contact_id):
        """Sets the contact_id of this ContactDetail.

        ID of the contact associated with the transactions.    Transactions with no contact will be grouped under the special ID: 86793108-198C-46D8-90A3-43C1D12686CE.    Transactions that are receive or spend bank transfers will be grouped under the special ID: 207322B3-6A58-4BE7-80F1-430123914AD6  # noqa: E501

        :param contact_id: The contact_id of this ContactDetail.  # noqa: E501
        :type: str
        """

        self._contact_id = contact_id

    @property
    def name(self):
        """Gets the name of this ContactDetail.  # noqa: E501

        Name of the contact associated with the transactions.    If no contact is associated with the transactions this will appear as “None Provided”,    For receive or spend bank transfer transactions, this will appear as “Bank Transfer”.  # noqa: E501

        :return: The name of this ContactDetail.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ContactDetail.

        Name of the contact associated with the transactions.    If no contact is associated with the transactions this will appear as “None Provided”,    For receive or spend bank transfer transactions, this will appear as “Bank Transfer”.  # noqa: E501

        :param name: The name of this ContactDetail.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def total(self):
        """Gets the total of this ContactDetail.  # noqa: E501

        Total value for the contact  # noqa: E501

        :return: The total of this ContactDetail.  # noqa: E501
        :rtype: float
        """
        return self._total

    @total.setter
    def total(self, total):
        """Sets the total of this ContactDetail.

        Total value for the contact  # noqa: E501

        :param total: The total of this ContactDetail.  # noqa: E501
        :type: float
        """

        self._total = total

    @property
    def total_detail(self):
        """Gets the total_detail of this ContactDetail.  # noqa: E501


        :return: The total_detail of this ContactDetail.  # noqa: E501
        :rtype: ContactTotalDetail
        """
        return self._total_detail

    @total_detail.setter
    def total_detail(self, total_detail):
        """Sets the total_detail of this ContactDetail.


        :param total_detail: The total_detail of this ContactDetail.  # noqa: E501
        :type: ContactTotalDetail
        """

        self._total_detail = total_detail

    @property
    def total_other(self):
        """Gets the total_other of this ContactDetail.  # noqa: E501


        :return: The total_other of this ContactDetail.  # noqa: E501
        :rtype: ContactTotalOther
        """
        return self._total_other

    @total_other.setter
    def total_other(self, total_other):
        """Sets the total_other of this ContactDetail.


        :param total_other: The total_other of this ContactDetail.  # noqa: E501
        :type: ContactTotalOther
        """

        self._total_other = total_other

    @property
    def account_codes(self):
        """Gets the account_codes of this ContactDetail.  # noqa: E501

        A list of account codes involved in transactions.  # noqa: E501

        :return: The account_codes of this ContactDetail.  # noqa: E501
        :rtype: list[str]
        """
        return self._account_codes

    @account_codes.setter
    def account_codes(self, account_codes):
        """Sets the account_codes of this ContactDetail.

        A list of account codes involved in transactions.  # noqa: E501

        :param account_codes: The account_codes of this ContactDetail.  # noqa: E501
        :type: list[str]
        """

        self._account_codes = account_codes
