"""Tests for the ldref module."""

import os
import pytest


from easyfinemap.ldref import LDRef

PWD = os.path.dirname(os.path.abspath(__file__))

class TestLDRef:
    """Tests for the LDRef class."""

    def test_init(self):
        """Test the initialization of the LDRef class."""
        ldref = LDRef()
        assert ldref.temp_dir_path.exists()

    def test_valid(self, dirty_ld_panel, clean_ld_panel):
        """Test the valid method of the LDRef class."""
        if os.path.exists(f"{clean_ld_panel}.chr1.bim"):
            os.remove(f"{clean_ld_panel}.chr1.bim")
        ldref = LDRef()
        ldref.valid(dirty_ld_panel, clean_ld_panel)
        assert os.path.exists(f"{clean_ld_panel}.chr1.bim")

    def test_extract(self, clean_ld_panel):
        """Test the extract method of the LDRef class."""
        if os.path.exists(f"{PWD}/exampledata/LDREF/extract.bim"):
            os.remove(f"{PWD}/exampledata/LDREF/extract.bim")
        ldref = LDRef()
        ldref.extract(f"{clean_ld_panel}.chr{{chrom}}", f"{PWD}/exampledata/LDREF/extract", chrom=1, start=1000000, end=2000000)
        assert os.path.exists(f"{PWD}/exampledata/LDREF/extract.bim")

    def test_clean(self):
        """Test the clean method of the LDRef class."""
        if os.path.exists(f"{PWD}/exampledata/LDREF/clean.bim"):
            os.remove(f"{PWD}/exampledata/LDREF/clean.bim")
        ldref = LDRef()
        ldref.clean(f"{PWD}/exampledata/LDREF/extract", f"{PWD}/exampledata/LDREF/clean", mac=10)
        assert os.path.exists(f"{PWD}/exampledata/LDREF/clean.bim")
        with pytest.raises(ValueError):
            ldref.clean(f"{PWD}/exampledata/LDREF/extract", f"{PWD}/exampledata/LDREF/clean", mac=0)