/* File: _internalmodule.c
 * This file is auto-generated with f2py (version:2).
 * f2py is a Fortran to Python Interface Generator (FPIG), Second Edition,
 * written by Pearu Peterson <pearu@cens.ioc.ee>.
 * Generation date: Tue Feb 23 01:19:36 2021
 * Do not edit this file directly unless you know what you are doing!!!
 */

#ifdef __cplusplus
extern "C" {
#endif

/*********************** See f2py2e/cfuncs.py: includes ***********************/
#include "Python.h"
#include <stdarg.h>
#include "fortranobject.h"
#include <math.h>

/**************** See f2py2e/rules.py: mod_rules['modulebody'] ****************/
static PyObject *_internal_error;
static PyObject *_internal_module;

/*********************** See f2py2e/cfuncs.py: typedefs ***********************/
typedef struct {double r,i;} complex_double;

/****************** See f2py2e/cfuncs.py: typedefs_generated ******************/
/*need_typedefs_generated*/

/********************** See f2py2e/cfuncs.py: cppmacros **********************/
#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F
#else
#define F_FUNC(f,F) _##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F##_
#else
#define F_FUNC(f,F) _##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F
#else
#define F_FUNC(f,F) f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F##_
#else
#define F_FUNC(f,F) f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_FUNC_US(f,F) F_FUNC(f##_,F##_)
#else
#define F_FUNC_US(f,F) F_FUNC(f,F)
#endif

#define pyobj_from_complex_double1(v) (PyComplex_FromDoubles(v.r,v.i))
#define rank(var) var ## _Rank
#define shape(var,dim) var ## _Dims[dim]
#define old_rank(var) (PyArray_NDIM((PyArrayObject *)(capi_ ## var ## _tmp)))
#define old_shape(var,dim) PyArray_DIM(((PyArrayObject *)(capi_ ## var ## _tmp)),dim)
#define fshape(var,dim) shape(var,rank(var)-dim-1)
#define len(var) shape(var,0)
#define flen(var) fshape(var,0)
#define old_size(var) PyArray_SIZE((PyArrayObject *)(capi_ ## var ## _tmp))
/* #define index(i) capi_i ## i */
#define slen(var) capi_ ## var ## _len
#define size(var, ...) f2py_size((PyArrayObject *)(capi_ ## var ## _tmp), ## __VA_ARGS__, -1)

#define CHECKSCALAR(check,tcheck,name,show,var)\
    if (!(check)) {\
        char errstring[256];\
        sprintf(errstring, "%s: "show, "("tcheck") failed for "name, var);\
        PyErr_SetString(_internal_error,errstring);\
        /*goto capi_fail;*/\
    } else 
#ifdef DEBUGCFUNCS
#define CFUNCSMESS(mess) fprintf(stderr,"debug-capi:"mess);
#define CFUNCSMESSPY(mess,obj) CFUNCSMESS(mess) \
    PyObject_Print((PyObject *)obj,stderr,Py_PRINT_RAW);\
    fprintf(stderr,"\n");
#else
#define CFUNCSMESS(mess)
#define CFUNCSMESSPY(mess,obj)
#endif

#ifndef max
#define max(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef min
#define min(a,b) ((a < b) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) ((a < b) ? (a) : (b))
#endif


/************************ See f2py2e/cfuncs.py: cfuncs ************************/
static int f2py_size(PyArrayObject* var, ...)
{
  npy_int sz = 0;
  npy_int dim;
  npy_int rank;
  va_list argp;
  va_start(argp, var);
  dim = va_arg(argp, npy_int);
  if (dim==-1)
    {
      sz = PyArray_SIZE(var);
    }
  else
    {
      rank = PyArray_NDIM(var);
      if (dim>=1 && dim<=rank)
        sz = PyArray_DIM(var, dim-1);
      else
        fprintf(stderr, "f2py_size: 2nd argument value=%d fails to satisfy 1<=value<=%d. Result will be 0.\n", dim, rank);
    }
  va_end(argp);
  return sz;
}

static int
int_from_pyobj(int* v, PyObject *obj, const char *errmess)
{
    PyObject* tmp = NULL;

    if (PyLong_Check(obj)) {
        *v = Npy__PyLong_AsInt(obj);
        return !(*v == -1 && PyErr_Occurred());
    }

    tmp = PyNumber_Long(obj);
    if (tmp) {
        *v = Npy__PyLong_AsInt(tmp);
        Py_DECREF(tmp);
        return !(*v == -1 && PyErr_Occurred());
    }

    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyBytes_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj, 0);
    if (tmp) {
        PyErr_Clear();
        if (int_from_pyobj(v, tmp, errmess)) {
            Py_DECREF(tmp);
            return 1;
        }
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err == NULL) {
            err = _internal_error;
        }
        PyErr_SetString(err, errmess);
    }
    return 0;
}

static int
complex_double_from_pyobj(complex_double* v, PyObject *obj, const char *errmess) {
    Py_complex c;
    if (PyComplex_Check(obj)) {
        c = PyComplex_AsCComplex(obj);
        (*v).r = c.real;
        (*v).i = c.imag;
        return 1;
    }
    if (PyArray_IsScalar(obj, ComplexFloating)) {
        if (PyArray_IsScalar(obj, CFloat)) {
            npy_cfloat new;
            PyArray_ScalarAsCtype(obj, &new);
            (*v).r = (double)new.real;
            (*v).i = (double)new.imag;
        }
        else if (PyArray_IsScalar(obj, CLongDouble)) {
            npy_clongdouble new;
            PyArray_ScalarAsCtype(obj, &new);
            (*v).r = (double)new.real;
            (*v).i = (double)new.imag;
        }
        else { /* if (PyArray_IsScalar(obj, CDouble)) */
            PyArray_ScalarAsCtype(obj, v);
        }
        return 1;
    }
    if (PyArray_CheckScalar(obj)) { /* 0-dim array or still array scalar */
        PyObject *arr;
        if (PyArray_Check(obj)) {
            arr = PyArray_Cast((PyArrayObject *)obj, NPY_CDOUBLE);
        }
        else {
            arr = PyArray_FromScalar(obj, PyArray_DescrFromType(NPY_CDOUBLE));
        }
        if (arr == NULL) {
            return 0;
        }
        (*v).r = ((npy_cdouble *)PyArray_DATA(arr))->real;
        (*v).i = ((npy_cdouble *)PyArray_DATA(arr))->imag;
        return 1;
    }
    /* Python does not provide PyNumber_Complex function :-( */
    (*v).i = 0.0;
    if (PyFloat_Check(obj)) {
        (*v).r = PyFloat_AsDouble(obj);
        return !((*v).r == -1.0 && PyErr_Occurred());
    }
    if (PyLong_Check(obj)) {
        (*v).r = PyLong_AsDouble(obj);
        return !((*v).r == -1.0 && PyErr_Occurred());
    }
    if (PySequence_Check(obj) && !(PyBytes_Check(obj) || PyUnicode_Check(obj))) {
        PyObject *tmp = PySequence_GetItem(obj,0);
        if (tmp) {
            if (complex_double_from_pyobj(v,tmp,errmess)) {
                Py_DECREF(tmp);
                return 1;
            }
            Py_DECREF(tmp);
        }
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL)
            err = PyExc_TypeError;
        PyErr_SetString(err,errmess);
    }
    return 0;
}

static int
double_from_pyobj(double* v, PyObject *obj, const char *errmess)
{
    PyObject* tmp = NULL;
    if (PyFloat_Check(obj)) {
        *v = PyFloat_AsDouble(obj);
        return !(*v == -1.0 && PyErr_Occurred());
    }

    tmp = PyNumber_Float(obj);
    if (tmp) {
        *v = PyFloat_AsDouble(tmp);
        Py_DECREF(tmp);
        return !(*v == -1.0 && PyErr_Occurred());
    }
    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyBytes_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj,0);
    if (tmp) {
        PyErr_Clear();
        if (double_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = _internal_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}


/********************* See f2py2e/cfuncs.py: userincludes *********************/
/*need_userincludes*/

/********************* See f2py2e/capi_rules.py: usercode *********************/


/* See f2py2e/rules.py */
extern void F_FUNC(jfuns2d,JFUNS2D)(int*,int*,complex_double*,double*,complex_double*,int*,complex_double*,int*,complex_double*,complex_double*);
extern void F_FUNC(legeexps,LEGEEXPS)(int*,int*,double*,double*,double*,double*);
extern void F_FUNC(legefder,LEGEFDER)(double*,double*,double*,double*,int*);
extern void F_FUNC(legewhts,LEGEWHTS)(int*,double*,double*,int*);
extern void F_FUNC(l2dformmp,L2DFORMMP)(int*,double*,double*,complex_double*,int*,double*,int*,complex_double*);
extern void F_FUNC(l2dformta,L2DFORMTA)(int*,double*,double*,complex_double*,int*,double*,int*,complex_double*);
extern void F_FUNC(h2dformmp,H2DFORMMP)(int*,complex_double*,double*,double*,complex_double*,int*,double*,int*,complex_double*);
extern void F_FUNC(h2dformta,H2DFORMTA)(int*,complex_double*,double*,double*,complex_double*,int*,double*,int*,complex_double*);
extern void F_FUNC(l3dformmp,L3DFORMMP)(int*,double*,double*,complex_double*,int*,double*,int*,complex_double*);
extern void F_FUNC(l3dformta,L3DFORMTA)(int*,double*,double*,complex_double*,int*,double*,int*,complex_double*);
extern void F_FUNC(h3dformmp,H3DFORMMP)(int*,complex_double*,double*,double*,complex_double*,int*,double*,int*,complex_double*);
extern void F_FUNC(h3dformta,H3DFORMTA)(int*,complex_double*,double*,double*,complex_double*,int*,double*,int*,complex_double*);
extern void F_FUNC_US(l2dformmp_dp,L2DFORMMP_DP)(int*,double*,double*,complex_double*,int*,double*,int*,complex_double*);
extern void F_FUNC_US(l2dformta_dp,L2DFORMTA_DP)(int*,double*,double*,complex_double*,int*,double*,int*,complex_double*);
extern void F_FUNC_US(h2dformmp_dp,H2DFORMMP_DP)(int*,complex_double*,double*,double*,complex_double*,double*,int*,double*,int*,complex_double*);
extern void F_FUNC_US(h2dformta_dp,H2DFORMTA_DP)(int*,complex_double*,double*,double*,complex_double*,double*,int*,double*,int*,complex_double*);
extern void F_FUNC_US(l3dformmp_dp,L3DFORMMP_DP)(int*,double*,double*,complex_double*,double*,int*,double*,int*,complex_double*);
extern void F_FUNC_US(l3dformta_dp,L3DFORMTA_DP)(int*,double*,double*,complex_double*,double*,int*,double*,int*,complex_double*);
extern void F_FUNC_US(h3dformmp_dp,H3DFORMMP_DP)(int*,complex_double*,double*,double*,complex_double*,double*,int*,double*,int*,complex_double*);
extern void F_FUNC_US(h3dformta_dp,H3DFORMTA_DP)(int*,complex_double*,double*,double*,complex_double*,double*,int*,double*,int*,complex_double*);
extern void F_FUNC(lfmm2dparttarg,LFMM2DPARTTARG)(int*,int*,int*,double*,int*,complex_double*,int*,complex_double*,double*,int*,complex_double*,int*,complex_double*,int*,complex_double*,int*,double*,int*,complex_double*,int*,complex_double*,int*,complex_double*);
extern void F_FUNC(hfmm2dparttarg,HFMM2DPARTTARG)(int*,int*,complex_double*,int*,double*,int*,complex_double*,int*,complex_double*,double*,int*,complex_double*,int*,complex_double*,int*,complex_double*,int*,double*,int*,complex_double*,int*,complex_double*,int*,complex_double*);
extern void F_FUNC(lfmm3dparttarg,LFMM3DPARTTARG)(int*,int*,int*,double*,int*,complex_double*,int*,complex_double*,double*,int*,complex_double*,int*,complex_double*,int*,double*,int*,complex_double*,int*,complex_double*);
extern void F_FUNC(hfmm3dparttarg,HFMM3DPARTTARG)(int*,int*,complex_double*,int*,double*,int*,complex_double*,int*,complex_double*,double*,int*,complex_double*,int*,complex_double*,int*,double*,int*,complex_double*,int*,complex_double*);
extern void F_FUNC(l3dtaevalhess,L3DTAEVALHESS)(double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,complex_double*,int*);
extern void F_FUNC(l2dterms,L2DTERMS)(double*,int*,int*);
extern void F_FUNC(h2dterms,H2DTERMS)(double*,complex_double*,double*,int*,int*);
extern void F_FUNC(l3dterms,L3DTERMS)(double*,int*,int*);
extern void F_FUNC(h3dterms,H3DTERMS)(double*,complex_double*,double*,int*,int*);
extern void F_FUNC_US(rotviarecur3p_init,ROTVIARECUR3P_INIT)(int*,double*,int*,double*);
extern void F_FUNC_US(triangle_norm_vec,TRIANGLE_NORM_VEC)(double*,double*,int*);
extern void F_FUNC_US(triangle_area_vec,TRIANGLE_AREA_VEC)(double*,double*,int*);
extern void F_FUNC_US(rotviarecur3p_init_vec,ROTVIARECUR3P_INIT_VEC)(int*,double*,int*,double*,int*);
extern void F_FUNC_US(ylgndr_vec,YLGNDR_VEC)(int*,double*,double*,int*);
extern void F_FUNC_US(hank103_vec,HANK103_VEC)(complex_double*,complex_double*,complex_double*,int*,int*);
extern void F_FUNC_US(legefder_vec,LEGEFDER_VEC)(double*,double*,double*,double*,int*,int*);
extern void F_FUNC_US(lpotgrad2dall_vec,LPOTGRAD2DALL_VEC)(int*,int*,double*,complex_double*,int*,double*,complex_double*,complex_double*,complex_double*,int*);
extern void F_FUNC_US(lpotfld3dall_vec,LPOTFLD3DALL_VEC)(int*,double*,complex_double*,int*,double*,complex_double*,complex_double*,int*);
extern void F_FUNC_US(hpotgrad2dall_vec,HPOTGRAD2DALL_VEC)(int*,int*,double*,complex_double*,int*,double*,complex_double*,complex_double*,complex_double*,complex_double*,int*);
extern void F_FUNC_US(hpotfld3dall_vec,HPOTFLD3DALL_VEC)(int*,double*,complex_double*,int*,double*,complex_double*,complex_double*,complex_double*,int*);
extern void F_FUNC_US(lpotgrad2dall_dp_vec,LPOTGRAD2DALL_DP_VEC)(int*,int*,double*,complex_double*,int*,double*,complex_double*,complex_double*,complex_double*,int*);
extern void F_FUNC_US(lpotfld3dall_dp_vec,LPOTFLD3DALL_DP_VEC)(int*,double*,complex_double*,double*,int*,double*,complex_double*,complex_double*,int*);
extern void F_FUNC_US(hpotgrad2dall_dp_vec,HPOTGRAD2DALL_DP_VEC)(int*,int*,double*,complex_double*,double*,int*,double*,complex_double*,complex_double*,complex_double*,complex_double*,int*);
extern void F_FUNC_US(hpotfld3dall_dp_vec,HPOTFLD3DALL_DP_VEC)(int*,double*,complex_double*,double*,int*,double*,complex_double*,complex_double*,complex_double*,int*);
extern void F_FUNC_US(l2dformta_imany,L2DFORMTA_IMANY)(int*,double*,double*,int*,int*,complex_double*,int*,int*,int*,int*,int*,double*,int*,int*,complex_double*,int*);
extern void F_FUNC_US(h2dformta_imany,H2DFORMTA_IMANY)(int*,complex_double*,double*,double*,int*,int*,complex_double*,int*,int*,int*,int*,int*,double*,int*,int*,complex_double*,int*);
extern void F_FUNC_US(l3dformta_imany,L3DFORMTA_IMANY)(int*,double*,double*,int*,int*,complex_double*,int*,int*,int*,int*,int*,double*,int*,int*,complex_double*,int*);
extern void F_FUNC_US(h3dformta_imany,H3DFORMTA_IMANY)(int*,complex_double*,double*,double*,int*,int*,complex_double*,int*,int*,int*,int*,int*,double*,int*,int*,complex_double*,int*);
extern void F_FUNC_US(l2dformta_dp_imany,L2DFORMTA_DP_IMANY)(int*,double*,double*,int*,int*,complex_double*,int*,int*,int*,int*,int*,double*,int*,int*,complex_double*,int*);
extern void F_FUNC_US(h2dformta_dp_imany,H2DFORMTA_DP_IMANY)(int*,complex_double*,double*,double*,int*,int*,complex_double*,int*,int*,double*,int*,int*,int*,int*,int*,double*,int*,int*,complex_double*,int*);
extern void F_FUNC_US(l3dformta_dp_imany,L3DFORMTA_DP_IMANY)(int*,double*,double*,int*,int*,complex_double*,int*,int*,double*,int*,int*,int*,int*,int*,double*,int*,int*,complex_double*,int*);
extern void F_FUNC_US(h3dformta_dp_imany,H3DFORMTA_DP_IMANY)(int*,complex_double*,double*,double*,int*,int*,complex_double*,int*,int*,double*,int*,int*,int*,int*,int*,double*,int*,int*,complex_double*,int*);
extern void F_FUNC_US(l2dformta_qbx,L2DFORMTA_QBX)(int*,int*,double*,complex_double*,int*,int*,double*,int*,double*,int*,int*,int*,int*,int*,int*,complex_double*);
extern void F_FUNC_US(h2dformta_qbx,H2DFORMTA_QBX)(int*,complex_double*,int*,double*,complex_double*,int*,int*,double*,int*,double*,int*,int*,int*,int*,int*,int*,complex_double*);
extern void F_FUNC_US(l3dformta_qbx,L3DFORMTA_QBX)(int*,int*,double*,complex_double*,int*,int*,double*,int*,double*,int*,int*,int*,int*,int*,int*,complex_double*);
extern void F_FUNC_US(h3dformta_qbx,H3DFORMTA_QBX)(int*,complex_double*,int*,double*,complex_double*,int*,int*,double*,int*,double*,int*,int*,int*,int*,int*,int*,complex_double*);
extern void F_FUNC_US(l2dformta_dp_qbx,L2DFORMTA_DP_QBX)(int*,int*,double*,complex_double*,int*,int*,double*,int*,double*,int*,int*,int*,int*,int*,int*,complex_double*);
extern void F_FUNC_US(h2dformta_dp_qbx,H2DFORMTA_DP_QBX)(int*,complex_double*,int*,double*,complex_double*,double*,int*,int*,double*,int*,double*,int*,int*,int*,int*,int*,int*,complex_double*);
extern void F_FUNC_US(l3dformta_dp_qbx,L3DFORMTA_DP_QBX)(int*,int*,double*,complex_double*,double*,int*,int*,double*,int*,double*,int*,int*,int*,int*,int*,int*,complex_double*);
extern void F_FUNC_US(h3dformta_dp_qbx,H3DFORMTA_DP_QBX)(int*,complex_double*,int*,double*,complex_double*,double*,int*,int*,double*,int*,double*,int*,int*,int*,int*,int*,int*,complex_double*);
extern void F_FUNC_US(l3dtaeval_vec,L3DTAEVAL_VEC)(double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,int*);
extern void F_FUNC_US(l3dmpeval_vec,L3DMPEVAL_VEC)(double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,int*);
extern void F_FUNC_US(h3dtaeval_vec,H3DTAEVAL_VEC)(complex_double*,double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,int*);
extern void F_FUNC_US(h3dmpeval_vec,H3DMPEVAL_VEC)(complex_double*,double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,int*);
extern void F_FUNC_US(l2dtaeval_vec,L2DTAEVAL_VEC)(double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,complex_double*,int*);
extern void F_FUNC_US(l2dmpeval_vec,L2DMPEVAL_VEC)(double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,complex_double*,int*);
extern void F_FUNC_US(h2dtaeval_vec,H2DTAEVAL_VEC)(complex_double*,double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,complex_double*,int*);
extern void F_FUNC_US(h2dmpeval_vec,H2DMPEVAL_VEC)(complex_double*,double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,complex_double*,int*);
extern void F_FUNC_US(l3dtaevalhess_1tgtperexp,L3DTAEVALHESS_1TGTPEREXP)(double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,complex_double*,int*,int*);
extern void F_FUNC_US(h3dtaeval_1tgtperexp,H3DTAEVAL_1TGTPEREXP)(complex_double*,double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,int*);
extern void F_FUNC_US(l2dmpmp_vec,L2DMPMP_VEC)(double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,int*);
extern void F_FUNC_US(l2dmploc_vec,L2DMPLOC_VEC)(double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,int*);
extern void F_FUNC_US(l2dlocloc_vec,L2DLOCLOC_VEC)(double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,int*);
extern void F_FUNC_US(h2dmpmp_vec,H2DMPMP_VEC)(complex_double*,double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,int*);
extern void F_FUNC_US(h2dmploc_vec,H2DMPLOC_VEC)(complex_double*,double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,int*);
extern void F_FUNC_US(h2dlocloc_vec,H2DLOCLOC_VEC)(complex_double*,double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,int*);
extern void F_FUNC_US(l3dmpmpquadu_vec,L3DMPMPQUADU_VEC)(double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,int*,int*);
extern void F_FUNC_US(l3dmplocquadu_vec,L3DMPLOCQUADU_VEC)(double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,int*,int*);
extern void F_FUNC_US(l3dloclocquadu_vec,L3DLOCLOCQUADU_VEC)(double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,int*,int*);
extern void F_FUNC_US(h3dmpmpquadu_vec,H3DMPMPQUADU_VEC)(complex_double*,double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,double*,double*,double*,int*,int*,int*);
extern void F_FUNC_US(h3dmplocquadu_vec,H3DMPLOCQUADU_VEC)(complex_double*,double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,double*,double*,double*,int*,int*,int*);
extern void F_FUNC_US(h3dloclocquadu_vec,H3DLOCLOCQUADU_VEC)(complex_double*,double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,double*,double*,double*,int*,int*,int*);
extern void F_FUNC_US(l2dmpmp_imany,L2DMPMP_IMANY)(double*,int*,int*,double*,int*,int*,complex_double*,int*,int*,int*,double*,double*,complex_double*,int*,int*);
extern void F_FUNC_US(l2dmploc_imany,L2DMPLOC_IMANY)(double*,int*,int*,double*,int*,int*,complex_double*,int*,int*,int*,double*,double*,complex_double*,int*,int*);
extern void F_FUNC_US(l2dlocloc_imany,L2DLOCLOC_IMANY)(double*,int*,int*,double*,int*,int*,complex_double*,int*,int*,int*,double*,double*,complex_double*,int*,int*);
extern void F_FUNC_US(h2dmpmp_imany,H2DMPMP_IMANY)(complex_double*,double*,int*,int*,double*,int*,int*,complex_double*,int*,int*,int*,double*,double*,complex_double*,int*,int*);
extern void F_FUNC_US(h2dmploc_imany,H2DMPLOC_IMANY)(complex_double*,double*,int*,int*,double*,int*,int*,complex_double*,int*,int*,int*,double*,double*,complex_double*,int*,int*);
extern void F_FUNC_US(h2dlocloc_imany,H2DLOCLOC_IMANY)(complex_double*,double*,int*,int*,double*,int*,int*,complex_double*,int*,int*,int*,double*,double*,complex_double*,int*,int*);
extern void F_FUNC_US(l3dmpmpquadu_imany,L3DMPMPQUADU_IMANY)(double*,int*,int*,double*,int*,int*,complex_double*,int*,int*,int*,double*,double*,complex_double*,int*,int*,int*);
extern void F_FUNC_US(l3dmplocquadu_imany,L3DMPLOCQUADU_IMANY)(double*,int*,int*,double*,int*,int*,complex_double*,int*,int*,int*,double*,double*,complex_double*,int*,int*,int*);
extern void F_FUNC_US(l3dloclocquadu_imany,L3DLOCLOCQUADU_IMANY)(double*,int*,int*,double*,int*,int*,complex_double*,int*,int*,int*,double*,double*,complex_double*,int*,int*,int*);
extern void F_FUNC_US(h3dmpmpquadu_imany,H3DMPMPQUADU_IMANY)(complex_double*,double*,int*,int*,double*,int*,int*,complex_double*,int*,int*,int*,double*,double*,complex_double*,int*,double*,double*,double*,int*,int*,int*);
extern void F_FUNC_US(h3dmplocquadu_imany,H3DMPLOCQUADU_IMANY)(complex_double*,double*,int*,int*,double*,int*,int*,complex_double*,int*,int*,int*,double*,double*,complex_double*,int*,double*,double*,double*,int*,int*,int*);
extern void F_FUNC_US(h3dloclocquadu_imany,H3DLOCLOCQUADU_IMANY)(complex_double*,double*,int*,int*,double*,int*,int*,complex_double*,int*,int*,int*,double*,double*,complex_double*,int*,double*,double*,double*,int*,int*,int*);
extern void F_FUNC_US(l2dlocloc_qbx,L2DLOCLOC_QBX)(double*,int*,double*,int*,complex_double*,int*,int*,double*,int*,double*,int*,complex_double*,int*,int*);
extern void F_FUNC_US(h2dlocloc_qbx,H2DLOCLOC_QBX)(complex_double*,double*,int*,double*,int*,complex_double*,int*,int*,double*,int*,double*,int*,complex_double*,int*,int*);
extern void F_FUNC_US(l3dloclocquadu_qbx,L3DLOCLOCQUADU_QBX)(double*,int*,double*,int*,complex_double*,int*,int*,double*,int*,double*,int*,complex_double*,int*,int*,int*);
extern void F_FUNC_US(h3dloclocquadu_qbx,H3DLOCLOCQUADU_QBX)(complex_double*,double*,int*,double*,int*,complex_double*,int*,int*,double*,int*,double*,int*,complex_double*,int*,double*,double*,double*,int*,int*,int*);
extern void F_FUNC_US(l3dmplocquadu2_trunc_imany,L3DMPLOCQUADU2_TRUNC_IMANY)(double*,int*,int*,double*,int*,int*,complex_double*,int*,int*,int*,int*,double*,double*,complex_double*,int*,int*,double*,int*,int*,double*,int*,int*,int*,int*);
extern void F_FUNC_US(h3dmplocquadu2_trunc_imany,H3DMPLOCQUADU2_TRUNC_IMANY)(complex_double*,double*,int*,int*,double*,int*,int*,complex_double*,int*,int*,int*,int*,double*,double*,complex_double*,int*,double*,double*,double*,int*,int*,double*,int*,int*,double*,int*,int*,int*,int*);
/*eof externroutines*/

/******************** See f2py2e/capi_rules.py: usercode1 ********************/


/******************* See f2py2e/cb_rules.py: buildcallback *******************/
/*need_callbacks*/

/*********************** See f2py2e/rules.py: buildapi ***********************/

/********************************** jfuns2d **********************************/
static char doc_f2py_rout__internal_jfuns2d[] = "\
ier,fjs,fjder,ntop = jfuns2d(nterms,z,scale,ifder,lwfjs)\n\nWrapper for ``jfuns2d``.\
\n\nParameters\n----------\n"
"nterms : input int\n"
"z : input complex\n"
"scale : input float\n"
"ifder : input int\n"
"lwfjs : input int\n"
"\nReturns\n-------\n"
"ier : int\n"
"fjs : rank-1 array('D') with bounds (lwfjs + 1)\n"
"fjder : rank-1 array('D') with bounds (lwfjs + 1)\n"
"ntop : complex";
/* extern void F_FUNC(jfuns2d,JFUNS2D)(int*,int*,complex_double*,double*,complex_double*,int*,complex_double*,int*,complex_double*,complex_double*); */
static PyObject *f2py_rout__internal_jfuns2d(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,complex_double*,double*,complex_double*,int*,complex_double*,int*,complex_double*,complex_double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ier = 0;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  complex_double z;
  PyObject *z_capi = Py_None;
  double scale = 0;
  PyObject *scale_capi = Py_None;
  complex_double *fjs = NULL;
  npy_intp fjs_Dims[1] = {-1};
  const int fjs_Rank = 1;
  PyArrayObject *capi_fjs_tmp = NULL;
  int capi_fjs_intent = 0;
  int ifder = 0;
  PyObject *ifder_capi = Py_None;
  complex_double *fjder = NULL;
  npy_intp fjder_Dims[1] = {-1};
  const int fjder_Rank = 1;
  PyArrayObject *capi_fjder_tmp = NULL;
  int capi_fjder_intent = 0;
  int lwfjs = 0;
  PyObject *lwfjs_capi = Py_None;
  complex_double *iscale = NULL;
  npy_intp iscale_Dims[1] = {-1};
  const int iscale_Rank = 1;
  PyArrayObject *capi_iscale_tmp = NULL;
  int capi_iscale_intent = 0;
  complex_double ntop;
  PyObject *ntop_capi = Py_None;
    static char *capi_kwlist[] = {"nterms","z","scale","ifder","lwfjs",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOO|:_internal.jfuns2d",\
        capi_kwlist,&nterms_capi,&z_capi,&scale_capi,&ifder_capi,&lwfjs_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable ier */
  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.jfuns2d() 1st argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable z */
    f2py_success = complex_double_from_pyobj(&z,z_capi,"_internal.jfuns2d() 2nd argument (z) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable scale */
    f2py_success = double_from_pyobj(&scale,scale_capi,"_internal.jfuns2d() 3rd argument (scale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable lwfjs */
    f2py_success = int_from_pyobj(&lwfjs,lwfjs_capi,"_internal.jfuns2d() 5th argument (lwfjs) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(lwfjs>=nterms+2,"lwfjs>=nterms+2","5th argument lwfjs","jfuns2d:lwfjs=%d",lwfjs) {
  /* Processing variable ifder */
    f2py_success = int_from_pyobj(&ifder,ifder_capi,"_internal.jfuns2d() 4th argument (ifder) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ntop */
  /* Processing variable fjs */
  fjs_Dims[0]=lwfjs + 1;
  capi_fjs_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_fjs_tmp = array_from_pyobj(NPY_CDOUBLE,fjs_Dims,fjs_Rank,capi_fjs_intent,Py_None);
  if (capi_fjs_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `fjs' of _internal.jfuns2d to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    fjs = (complex_double *)(PyArray_DATA(capi_fjs_tmp));

  /* Processing variable fjder */
  fjder_Dims[0]=lwfjs + 1;
  capi_fjder_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_fjder_tmp = array_from_pyobj(NPY_CDOUBLE,fjder_Dims,fjder_Rank,capi_fjder_intent,Py_None);
  if (capi_fjder_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `fjder' of _internal.jfuns2d to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    fjder = (complex_double *)(PyArray_DATA(capi_fjder_tmp));

  /* Processing variable iscale */
  iscale_Dims[0]=lwfjs + 1;
  capi_iscale_intent |= F2PY_INTENT_HIDE|F2PY_INTENT_CACHE;
  capi_iscale_tmp = array_from_pyobj(NPY_CDOUBLE,iscale_Dims,iscale_Rank,capi_iscale_intent,Py_None);
  if (capi_iscale_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `iscale' of _internal.jfuns2d to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    iscale = (complex_double *)(PyArray_DATA(capi_iscale_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ier,&nterms,&z,&scale,fjs,&ifder,fjder,&lwfjs,iscale,&ntop);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
  ntop_capi = pyobj_from_complex_double1(ntop);
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("iNNN",ier,capi_fjs_tmp,capi_fjder_tmp,ntop_capi);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    Py_XDECREF(capi_iscale_tmp);
  }  /*if (capi_iscale_tmp == NULL) ... else of iscale*/
  /* End of cleaning variable iscale */
  }  /*if (capi_fjder_tmp == NULL) ... else of fjder*/
  /* End of cleaning variable fjder */
  }  /*if (capi_fjs_tmp == NULL) ... else of fjs*/
  /* End of cleaning variable fjs */
  /* End of cleaning variable ntop */
  } /*if (f2py_success) of ifder*/
  /* End of cleaning variable ifder */
  } /*CHECKSCALAR(lwfjs>=nterms+2)*/
  } /*if (f2py_success) of lwfjs*/
  /* End of cleaning variable lwfjs */
  } /*if (f2py_success) of scale*/
  /* End of cleaning variable scale */
  }  /*if (f2py_success) of z frompyobj*/
  /* End of cleaning variable z */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  /* End of cleaning variable ier */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************* end of jfuns2d *******************************/

/********************************** legeexps **********************************/
static char doc_f2py_rout__internal_legeexps[] = "\
x,u,v,whts = legeexps(itype,n)\n\nWrapper for ``legeexps``.\
\n\nParameters\n----------\n"
"itype : input int\n"
"n : input int\n"
"\nReturns\n-------\n"
"x : rank-1 array('d') with bounds (n)\n"
"u : rank-2 array('d') with bounds (n,n)\n"
"v : rank-2 array('d') with bounds (n,n)\n"
"whts : rank-1 array('d') with bounds (n)";
/* extern void F_FUNC(legeexps,LEGEEXPS)(int*,int*,double*,double*,double*,double*); */
static PyObject *f2py_rout__internal_legeexps(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*,double*,double*,double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int itype = 0;
  PyObject *itype_capi = Py_None;
  int n = 0;
  PyObject *n_capi = Py_None;
  double *x = NULL;
  npy_intp x_Dims[1] = {-1};
  const int x_Rank = 1;
  PyArrayObject *capi_x_tmp = NULL;
  int capi_x_intent = 0;
  double *u = NULL;
  npy_intp u_Dims[2] = {-1, -1};
  const int u_Rank = 2;
  PyArrayObject *capi_u_tmp = NULL;
  int capi_u_intent = 0;
  double *v = NULL;
  npy_intp v_Dims[2] = {-1, -1};
  const int v_Rank = 2;
  PyArrayObject *capi_v_tmp = NULL;
  int capi_v_intent = 0;
  double *whts = NULL;
  npy_intp whts_Dims[1] = {-1};
  const int whts_Rank = 1;
  PyArrayObject *capi_whts_tmp = NULL;
  int capi_whts_intent = 0;
    static char *capi_kwlist[] = {"itype","n",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OO|:_internal.legeexps",\
        capi_kwlist,&itype_capi,&n_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable itype */
    f2py_success = int_from_pyobj(&itype,itype_capi,"_internal.legeexps() 1st argument (itype) can't be converted to int");
  if (f2py_success) {
  /* Processing variable n */
    f2py_success = int_from_pyobj(&n,n_capi,"_internal.legeexps() 2nd argument (n) can't be converted to int");
  if (f2py_success) {
  /* Processing variable x */
  x_Dims[0]=n;
  capi_x_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_x_tmp = array_from_pyobj(NPY_DOUBLE,x_Dims,x_Rank,capi_x_intent,Py_None);
  if (capi_x_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `x' of _internal.legeexps to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    x = (double *)(PyArray_DATA(capi_x_tmp));

  /* Processing variable whts */
  whts_Dims[0]=n;
  capi_whts_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_whts_tmp = array_from_pyobj(NPY_DOUBLE,whts_Dims,whts_Rank,capi_whts_intent,Py_None);
  if (capi_whts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `whts' of _internal.legeexps to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    whts = (double *)(PyArray_DATA(capi_whts_tmp));

  /* Processing variable u */
  u_Dims[0]=n,u_Dims[1]=n;
  capi_u_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_u_tmp = array_from_pyobj(NPY_DOUBLE,u_Dims,u_Rank,capi_u_intent,Py_None);
  if (capi_u_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `u' of _internal.legeexps to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    u = (double *)(PyArray_DATA(capi_u_tmp));

  /* Processing variable v */
  v_Dims[0]=n,v_Dims[1]=n;
  capi_v_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_v_tmp = array_from_pyobj(NPY_DOUBLE,v_Dims,v_Rank,capi_v_intent,Py_None);
  if (capi_v_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `v' of _internal.legeexps to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    v = (double *)(PyArray_DATA(capi_v_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&itype,&n,x,u,v,whts);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NNNN",capi_x_tmp,capi_u_tmp,capi_v_tmp,capi_whts_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_v_tmp == NULL) ... else of v*/
  /* End of cleaning variable v */
  }  /*if (capi_u_tmp == NULL) ... else of u*/
  /* End of cleaning variable u */
  }  /*if (capi_whts_tmp == NULL) ... else of whts*/
  /* End of cleaning variable whts */
  }  /*if (capi_x_tmp == NULL) ... else of x*/
  /* End of cleaning variable x */
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  } /*if (f2py_success) of itype*/
  /* End of cleaning variable itype */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/****************************** end of legeexps ******************************/

/********************************** legefder **********************************/
static char doc_f2py_rout__internal_legefder[] = "\
val,der = legefder(x,pexp,[n])\n\nWrapper for ``legefder``.\
\n\nParameters\n----------\n"
"x : input float\n"
"pexp : input rank-1 array('d') with bounds (n + 1)\n"
"\nOther Parameters\n----------------\n"
"n : input int, optional\n    Default: (len(pexp)-1)\n"
"\nReturns\n-------\n"
"val : float\n"
"der : float";
/* extern void F_FUNC(legefder,LEGEFDER)(double*,double*,double*,double*,int*); */
static PyObject *f2py_rout__internal_legefder(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,double*,double*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double x = 0;
  PyObject *x_capi = Py_None;
  double val = 0;
  double der = 0;
  double *pexp = NULL;
  npy_intp pexp_Dims[1] = {-1};
  const int pexp_Rank = 1;
  PyArrayObject *capi_pexp_tmp = NULL;
  int capi_pexp_intent = 0;
  PyObject *pexp_capi = Py_None;
  int n = 0;
  PyObject *n_capi = Py_None;
    static char *capi_kwlist[] = {"x","pexp","n",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OO|O:_internal.legefder",\
        capi_kwlist,&x_capi,&pexp_capi,&n_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable pexp */
  ;
  capi_pexp_intent |= F2PY_INTENT_IN;
  capi_pexp_tmp = array_from_pyobj(NPY_DOUBLE,pexp_Dims,pexp_Rank,capi_pexp_intent,pexp_capi);
  if (capi_pexp_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `pexp' of _internal.legefder to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    pexp = (double *)(PyArray_DATA(capi_pexp_tmp));

  /* Processing variable val */
  /* Processing variable der */
  /* Processing variable x */
    f2py_success = double_from_pyobj(&x,x_capi,"_internal.legefder() 1st argument (x) can't be converted to double");
  if (f2py_success) {
  /* Processing variable n */
  if (n_capi == Py_None) n = (len(pexp)-1); else
    f2py_success = int_from_pyobj(&n,n_capi,"_internal.legefder() 1st keyword (n) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((len(pexp)-1)>=n,"(len(pexp)-1)>=n","1st keyword n","legefder:n=%d",n) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&x,&val,&der,pexp,&n);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("dd",val,der);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*CHECKSCALAR((len(pexp)-1)>=n)*/
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  } /*if (f2py_success) of x*/
  /* End of cleaning variable x */
  /* End of cleaning variable der */
  /* End of cleaning variable val */
  if((PyObject *)capi_pexp_tmp!=pexp_capi) {
    Py_XDECREF(capi_pexp_tmp); }
  }  /*if (capi_pexp_tmp == NULL) ... else of pexp*/
  /* End of cleaning variable pexp */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/****************************** end of legefder ******************************/

/********************************** legewhts **********************************/
static char doc_f2py_rout__internal_legewhts[] = "\
ts,whts = legewhts(n,ifwhts)\n\nWrapper for ``legewhts``.\
\n\nParameters\n----------\n"
"n : input int\n"
"ifwhts : input int\n"
"\nReturns\n-------\n"
"ts : rank-1 array('d') with bounds (n)\n"
"whts : rank-1 array('d') with bounds (n)";
/* extern void F_FUNC(legewhts,LEGEWHTS)(int*,double*,double*,int*); */
static PyObject *f2py_rout__internal_legewhts(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int n = 0;
  PyObject *n_capi = Py_None;
  double *ts = NULL;
  npy_intp ts_Dims[1] = {-1};
  const int ts_Rank = 1;
  PyArrayObject *capi_ts_tmp = NULL;
  int capi_ts_intent = 0;
  double *whts = NULL;
  npy_intp whts_Dims[1] = {-1};
  const int whts_Rank = 1;
  PyArrayObject *capi_whts_tmp = NULL;
  int capi_whts_intent = 0;
  int ifwhts = 0;
  PyObject *ifwhts_capi = Py_None;
    static char *capi_kwlist[] = {"n","ifwhts",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OO|:_internal.legewhts",\
        capi_kwlist,&n_capi,&ifwhts_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable n */
    f2py_success = int_from_pyobj(&n,n_capi,"_internal.legewhts() 1st argument (n) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ifwhts */
    f2py_success = int_from_pyobj(&ifwhts,ifwhts_capi,"_internal.legewhts() 2nd argument (ifwhts) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ts */
  ts_Dims[0]=n;
  capi_ts_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_ts_tmp = array_from_pyobj(NPY_DOUBLE,ts_Dims,ts_Rank,capi_ts_intent,Py_None);
  if (capi_ts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `ts' of _internal.legewhts to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ts = (double *)(PyArray_DATA(capi_ts_tmp));

  /* Processing variable whts */
  whts_Dims[0]=n;
  capi_whts_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_whts_tmp = array_from_pyobj(NPY_DOUBLE,whts_Dims,whts_Rank,capi_whts_intent,Py_None);
  if (capi_whts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `whts' of _internal.legewhts to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    whts = (double *)(PyArray_DATA(capi_whts_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&n,ts,whts,&ifwhts);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NN",capi_ts_tmp,capi_whts_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_whts_tmp == NULL) ... else of whts*/
  /* End of cleaning variable whts */
  }  /*if (capi_ts_tmp == NULL) ... else of ts*/
  /* End of cleaning variable ts */
  } /*if (f2py_success) of ifwhts*/
  /* End of cleaning variable ifwhts */
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/****************************** end of legewhts ******************************/

/********************************* l2dformmp *********************************/
static char doc_f2py_rout__internal_l2dformmp[] = "\
ier,expn = l2dformmp(rscale,source,charge,center,nterms,[ns])\n\nWrapper for ``l2dformmp``.\
\n\nParameters\n----------\n"
"rscale : input float\n"
"source : input rank-2 array('d') with bounds (2,ns)\n"
"charge : input rank-1 array('D') with bounds (ns)\n"
"center : input rank-1 array('d') with bounds (2)\n"
"nterms : input int\n"
"\nOther Parameters\n----------------\n"
"ns : input int, optional\n    Default: shape(source,1)\n"
"\nReturns\n-------\n"
"ier : int\n"
"expn : rank-1 array('D') with bounds (nterms + 1)";
/* extern void F_FUNC(l2dformmp,L2DFORMMP)(int*,double*,double*,complex_double*,int*,double*,int*,complex_double*); */
static PyObject *f2py_rout__internal_l2dformmp(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*,complex_double*,int*,double*,int*,complex_double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ier = 0;
  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *source = NULL;
  npy_intp source_Dims[2] = {-1, -1};
  const int source_Rank = 2;
  PyArrayObject *capi_source_tmp = NULL;
  int capi_source_intent = 0;
  PyObject *source_capi = Py_None;
  complex_double *charge = NULL;
  npy_intp charge_Dims[1] = {-1};
  const int charge_Rank = 1;
  PyArrayObject *capi_charge_tmp = NULL;
  int capi_charge_intent = 0;
  PyObject *charge_capi = Py_None;
  int ns = 0;
  PyObject *ns_capi = Py_None;
  double *center = NULL;
  npy_intp center_Dims[1] = {-1};
  const int center_Rank = 1;
  PyArrayObject *capi_center_tmp = NULL;
  int capi_center_intent = 0;
  PyObject *center_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[1] = {-1};
  const int expn_Rank = 1;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
    static char *capi_kwlist[] = {"rscale","source","charge","center","nterms","ns",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOO|O:_internal.l2dformmp",\
        capi_kwlist,&rscale_capi,&source_capi,&charge_capi,&center_capi,&nterms_capi,&ns_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.l2dformmp() 1st argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable center */
  center_Dims[0]=2;
  capi_center_intent |= F2PY_INTENT_IN;
  capi_center_tmp = array_from_pyobj(NPY_DOUBLE,center_Dims,center_Rank,capi_center_intent,center_capi);
  if (capi_center_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `center' of _internal.l2dformmp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center = (double *)(PyArray_DATA(capi_center_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.l2dformmp() 5th argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ier */
  /* Processing variable source */
  source_Dims[0]=2;
  capi_source_intent |= F2PY_INTENT_IN;
  capi_source_tmp = array_from_pyobj(NPY_DOUBLE,source_Dims,source_Rank,capi_source_intent,source_capi);
  if (capi_source_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `source' of _internal.l2dformmp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source = (double *)(PyArray_DATA(capi_source_tmp));

  /* Processing variable ns */
  if (ns_capi == Py_None) ns = shape(source,1); else
    f2py_success = int_from_pyobj(&ns,ns_capi,"_internal.l2dformmp() 1st keyword (ns) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(source,1)==ns,"shape(source,1)==ns","1st keyword ns","l2dformmp:ns=%d",ns) {
  /* Processing variable expn */
  expn_Dims[0]=nterms + 1;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.l2dformmp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

  /* Processing variable charge */
  charge_Dims[0]=ns;
  capi_charge_intent |= F2PY_INTENT_IN;
  capi_charge_tmp = array_from_pyobj(NPY_CDOUBLE,charge_Dims,charge_Rank,capi_charge_intent,charge_capi);
  if (capi_charge_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `charge' of _internal.l2dformmp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge = (complex_double *)(PyArray_DATA(capi_charge_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ier,&rscale,source,charge,&ns,center,&nterms,expn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("iN",ier,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_charge_tmp!=charge_capi) {
    Py_XDECREF(capi_charge_tmp); }
  }  /*if (capi_charge_tmp == NULL) ... else of charge*/
  /* End of cleaning variable charge */
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  } /*CHECKSCALAR(shape(source,1)==ns)*/
  } /*if (f2py_success) of ns*/
  /* End of cleaning variable ns */
  if((PyObject *)capi_source_tmp!=source_capi) {
    Py_XDECREF(capi_source_tmp); }
  }  /*if (capi_source_tmp == NULL) ... else of source*/
  /* End of cleaning variable source */
  /* End of cleaning variable ier */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_center_tmp!=center_capi) {
    Py_XDECREF(capi_center_tmp); }
  }  /*if (capi_center_tmp == NULL) ... else of center*/
  /* End of cleaning variable center */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/****************************** end of l2dformmp ******************************/

/********************************* l2dformta *********************************/
static char doc_f2py_rout__internal_l2dformta[] = "\
ier,expn = l2dformta(rscale,source,charge,center,nterms,[ns])\n\nWrapper for ``l2dformta``.\
\n\nParameters\n----------\n"
"rscale : input float\n"
"source : input rank-2 array('d') with bounds (2,ns)\n"
"charge : input rank-1 array('D') with bounds (ns)\n"
"center : input rank-1 array('d') with bounds (2)\n"
"nterms : input int\n"
"\nOther Parameters\n----------------\n"
"ns : input int, optional\n    Default: shape(source,1)\n"
"\nReturns\n-------\n"
"ier : int\n"
"expn : rank-1 array('D') with bounds (nterms + 1)";
/* extern void F_FUNC(l2dformta,L2DFORMTA)(int*,double*,double*,complex_double*,int*,double*,int*,complex_double*); */
static PyObject *f2py_rout__internal_l2dformta(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*,complex_double*,int*,double*,int*,complex_double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ier = 0;
  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *source = NULL;
  npy_intp source_Dims[2] = {-1, -1};
  const int source_Rank = 2;
  PyArrayObject *capi_source_tmp = NULL;
  int capi_source_intent = 0;
  PyObject *source_capi = Py_None;
  complex_double *charge = NULL;
  npy_intp charge_Dims[1] = {-1};
  const int charge_Rank = 1;
  PyArrayObject *capi_charge_tmp = NULL;
  int capi_charge_intent = 0;
  PyObject *charge_capi = Py_None;
  int ns = 0;
  PyObject *ns_capi = Py_None;
  double *center = NULL;
  npy_intp center_Dims[1] = {-1};
  const int center_Rank = 1;
  PyArrayObject *capi_center_tmp = NULL;
  int capi_center_intent = 0;
  PyObject *center_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[1] = {-1};
  const int expn_Rank = 1;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
    static char *capi_kwlist[] = {"rscale","source","charge","center","nterms","ns",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOO|O:_internal.l2dformta",\
        capi_kwlist,&rscale_capi,&source_capi,&charge_capi,&center_capi,&nterms_capi,&ns_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.l2dformta() 1st argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable center */
  center_Dims[0]=2;
  capi_center_intent |= F2PY_INTENT_IN;
  capi_center_tmp = array_from_pyobj(NPY_DOUBLE,center_Dims,center_Rank,capi_center_intent,center_capi);
  if (capi_center_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `center' of _internal.l2dformta to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center = (double *)(PyArray_DATA(capi_center_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.l2dformta() 5th argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ier */
  /* Processing variable source */
  source_Dims[0]=2;
  capi_source_intent |= F2PY_INTENT_IN;
  capi_source_tmp = array_from_pyobj(NPY_DOUBLE,source_Dims,source_Rank,capi_source_intent,source_capi);
  if (capi_source_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `source' of _internal.l2dformta to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source = (double *)(PyArray_DATA(capi_source_tmp));

  /* Processing variable ns */
  if (ns_capi == Py_None) ns = shape(source,1); else
    f2py_success = int_from_pyobj(&ns,ns_capi,"_internal.l2dformta() 1st keyword (ns) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(source,1)==ns,"shape(source,1)==ns","1st keyword ns","l2dformta:ns=%d",ns) {
  /* Processing variable expn */
  expn_Dims[0]=nterms + 1;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.l2dformta to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

  /* Processing variable charge */
  charge_Dims[0]=ns;
  capi_charge_intent |= F2PY_INTENT_IN;
  capi_charge_tmp = array_from_pyobj(NPY_CDOUBLE,charge_Dims,charge_Rank,capi_charge_intent,charge_capi);
  if (capi_charge_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `charge' of _internal.l2dformta to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge = (complex_double *)(PyArray_DATA(capi_charge_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ier,&rscale,source,charge,&ns,center,&nterms,expn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("iN",ier,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_charge_tmp!=charge_capi) {
    Py_XDECREF(capi_charge_tmp); }
  }  /*if (capi_charge_tmp == NULL) ... else of charge*/
  /* End of cleaning variable charge */
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  } /*CHECKSCALAR(shape(source,1)==ns)*/
  } /*if (f2py_success) of ns*/
  /* End of cleaning variable ns */
  if((PyObject *)capi_source_tmp!=source_capi) {
    Py_XDECREF(capi_source_tmp); }
  }  /*if (capi_source_tmp == NULL) ... else of source*/
  /* End of cleaning variable source */
  /* End of cleaning variable ier */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_center_tmp!=center_capi) {
    Py_XDECREF(capi_center_tmp); }
  }  /*if (capi_center_tmp == NULL) ... else of center*/
  /* End of cleaning variable center */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/****************************** end of l2dformta ******************************/

/********************************* h2dformmp *********************************/
static char doc_f2py_rout__internal_h2dformmp[] = "\
ier,expn = h2dformmp(zk,rscale,source,charge,center,nterms,[ns])\n\nWrapper for ``h2dformmp``.\
\n\nParameters\n----------\n"
"zk : input complex\n"
"rscale : input float\n"
"source : input rank-2 array('d') with bounds (2,ns)\n"
"charge : input rank-1 array('D') with bounds (ns)\n"
"center : input rank-1 array('d') with bounds (2)\n"
"nterms : input int\n"
"\nOther Parameters\n----------------\n"
"ns : input int, optional\n    Default: shape(source,1)\n"
"\nReturns\n-------\n"
"ier : int\n"
"expn : rank-1 array('D') with bounds (2 * nterms + 1)";
/* extern void F_FUNC(h2dformmp,H2DFORMMP)(int*,complex_double*,double*,double*,complex_double*,int*,double*,int*,complex_double*); */
static PyObject *f2py_rout__internal_h2dformmp(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,complex_double*,double*,double*,complex_double*,int*,double*,int*,complex_double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ier = 0;
  complex_double zk;
  PyObject *zk_capi = Py_None;
  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *source = NULL;
  npy_intp source_Dims[2] = {-1, -1};
  const int source_Rank = 2;
  PyArrayObject *capi_source_tmp = NULL;
  int capi_source_intent = 0;
  PyObject *source_capi = Py_None;
  complex_double *charge = NULL;
  npy_intp charge_Dims[1] = {-1};
  const int charge_Rank = 1;
  PyArrayObject *capi_charge_tmp = NULL;
  int capi_charge_intent = 0;
  PyObject *charge_capi = Py_None;
  int ns = 0;
  PyObject *ns_capi = Py_None;
  double *center = NULL;
  npy_intp center_Dims[1] = {-1};
  const int center_Rank = 1;
  PyArrayObject *capi_center_tmp = NULL;
  int capi_center_intent = 0;
  PyObject *center_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[1] = {-1};
  const int expn_Rank = 1;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
    static char *capi_kwlist[] = {"zk","rscale","source","charge","center","nterms","ns",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOO|O:_internal.h2dformmp",\
        capi_kwlist,&zk_capi,&rscale_capi,&source_capi,&charge_capi,&center_capi,&nterms_capi,&ns_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.h2dformmp() 2nd argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable center */
  center_Dims[0]=2;
  capi_center_intent |= F2PY_INTENT_IN;
  capi_center_tmp = array_from_pyobj(NPY_DOUBLE,center_Dims,center_Rank,capi_center_intent,center_capi);
  if (capi_center_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `center' of _internal.h2dformmp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center = (double *)(PyArray_DATA(capi_center_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.h2dformmp() 6th argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ier */
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.h2dformmp() 1st argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable source */
  source_Dims[0]=2;
  capi_source_intent |= F2PY_INTENT_IN;
  capi_source_tmp = array_from_pyobj(NPY_DOUBLE,source_Dims,source_Rank,capi_source_intent,source_capi);
  if (capi_source_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `source' of _internal.h2dformmp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source = (double *)(PyArray_DATA(capi_source_tmp));

  /* Processing variable ns */
  if (ns_capi == Py_None) ns = shape(source,1); else
    f2py_success = int_from_pyobj(&ns,ns_capi,"_internal.h2dformmp() 1st keyword (ns) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(source,1)==ns,"shape(source,1)==ns","1st keyword ns","h2dformmp:ns=%d",ns) {
  /* Processing variable expn */
  expn_Dims[0]=2 * nterms + 1;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.h2dformmp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

  /* Processing variable charge */
  charge_Dims[0]=ns;
  capi_charge_intent |= F2PY_INTENT_IN;
  capi_charge_tmp = array_from_pyobj(NPY_CDOUBLE,charge_Dims,charge_Rank,capi_charge_intent,charge_capi);
  if (capi_charge_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `charge' of _internal.h2dformmp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge = (complex_double *)(PyArray_DATA(capi_charge_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ier,&zk,&rscale,source,charge,&ns,center,&nterms,expn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("iN",ier,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_charge_tmp!=charge_capi) {
    Py_XDECREF(capi_charge_tmp); }
  }  /*if (capi_charge_tmp == NULL) ... else of charge*/
  /* End of cleaning variable charge */
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  } /*CHECKSCALAR(shape(source,1)==ns)*/
  } /*if (f2py_success) of ns*/
  /* End of cleaning variable ns */
  if((PyObject *)capi_source_tmp!=source_capi) {
    Py_XDECREF(capi_source_tmp); }
  }  /*if (capi_source_tmp == NULL) ... else of source*/
  /* End of cleaning variable source */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
  /* End of cleaning variable ier */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_center_tmp!=center_capi) {
    Py_XDECREF(capi_center_tmp); }
  }  /*if (capi_center_tmp == NULL) ... else of center*/
  /* End of cleaning variable center */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/****************************** end of h2dformmp ******************************/

/********************************* h2dformta *********************************/
static char doc_f2py_rout__internal_h2dformta[] = "\
ier,expn = h2dformta(zk,rscale,source,charge,center,nterms,[ns])\n\nWrapper for ``h2dformta``.\
\n\nParameters\n----------\n"
"zk : input complex\n"
"rscale : input float\n"
"source : input rank-2 array('d') with bounds (2,ns)\n"
"charge : input rank-1 array('D') with bounds (ns)\n"
"center : input rank-1 array('d') with bounds (2)\n"
"nterms : input int\n"
"\nOther Parameters\n----------------\n"
"ns : input int, optional\n    Default: shape(source,1)\n"
"\nReturns\n-------\n"
"ier : int\n"
"expn : rank-1 array('D') with bounds (2 * nterms + 1)";
/* extern void F_FUNC(h2dformta,H2DFORMTA)(int*,complex_double*,double*,double*,complex_double*,int*,double*,int*,complex_double*); */
static PyObject *f2py_rout__internal_h2dformta(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,complex_double*,double*,double*,complex_double*,int*,double*,int*,complex_double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ier = 0;
  complex_double zk;
  PyObject *zk_capi = Py_None;
  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *source = NULL;
  npy_intp source_Dims[2] = {-1, -1};
  const int source_Rank = 2;
  PyArrayObject *capi_source_tmp = NULL;
  int capi_source_intent = 0;
  PyObject *source_capi = Py_None;
  complex_double *charge = NULL;
  npy_intp charge_Dims[1] = {-1};
  const int charge_Rank = 1;
  PyArrayObject *capi_charge_tmp = NULL;
  int capi_charge_intent = 0;
  PyObject *charge_capi = Py_None;
  int ns = 0;
  PyObject *ns_capi = Py_None;
  double *center = NULL;
  npy_intp center_Dims[1] = {-1};
  const int center_Rank = 1;
  PyArrayObject *capi_center_tmp = NULL;
  int capi_center_intent = 0;
  PyObject *center_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[1] = {-1};
  const int expn_Rank = 1;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
    static char *capi_kwlist[] = {"zk","rscale","source","charge","center","nterms","ns",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOO|O:_internal.h2dformta",\
        capi_kwlist,&zk_capi,&rscale_capi,&source_capi,&charge_capi,&center_capi,&nterms_capi,&ns_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.h2dformta() 2nd argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable center */
  center_Dims[0]=2;
  capi_center_intent |= F2PY_INTENT_IN;
  capi_center_tmp = array_from_pyobj(NPY_DOUBLE,center_Dims,center_Rank,capi_center_intent,center_capi);
  if (capi_center_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `center' of _internal.h2dformta to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center = (double *)(PyArray_DATA(capi_center_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.h2dformta() 6th argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ier */
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.h2dformta() 1st argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable source */
  source_Dims[0]=2;
  capi_source_intent |= F2PY_INTENT_IN;
  capi_source_tmp = array_from_pyobj(NPY_DOUBLE,source_Dims,source_Rank,capi_source_intent,source_capi);
  if (capi_source_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `source' of _internal.h2dformta to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source = (double *)(PyArray_DATA(capi_source_tmp));

  /* Processing variable ns */
  if (ns_capi == Py_None) ns = shape(source,1); else
    f2py_success = int_from_pyobj(&ns,ns_capi,"_internal.h2dformta() 1st keyword (ns) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(source,1)==ns,"shape(source,1)==ns","1st keyword ns","h2dformta:ns=%d",ns) {
  /* Processing variable expn */
  expn_Dims[0]=2 * nterms + 1;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.h2dformta to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

  /* Processing variable charge */
  charge_Dims[0]=ns;
  capi_charge_intent |= F2PY_INTENT_IN;
  capi_charge_tmp = array_from_pyobj(NPY_CDOUBLE,charge_Dims,charge_Rank,capi_charge_intent,charge_capi);
  if (capi_charge_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `charge' of _internal.h2dformta to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge = (complex_double *)(PyArray_DATA(capi_charge_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ier,&zk,&rscale,source,charge,&ns,center,&nterms,expn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("iN",ier,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_charge_tmp!=charge_capi) {
    Py_XDECREF(capi_charge_tmp); }
  }  /*if (capi_charge_tmp == NULL) ... else of charge*/
  /* End of cleaning variable charge */
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  } /*CHECKSCALAR(shape(source,1)==ns)*/
  } /*if (f2py_success) of ns*/
  /* End of cleaning variable ns */
  if((PyObject *)capi_source_tmp!=source_capi) {
    Py_XDECREF(capi_source_tmp); }
  }  /*if (capi_source_tmp == NULL) ... else of source*/
  /* End of cleaning variable source */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
  /* End of cleaning variable ier */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_center_tmp!=center_capi) {
    Py_XDECREF(capi_center_tmp); }
  }  /*if (capi_center_tmp == NULL) ... else of center*/
  /* End of cleaning variable center */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/****************************** end of h2dformta ******************************/

/********************************* l3dformmp *********************************/
static char doc_f2py_rout__internal_l3dformmp[] = "\
ier,expn = l3dformmp(rscale,source,charge,center,nterms,[ns])\n\nWrapper for ``l3dformmp``.\
\n\nParameters\n----------\n"
"rscale : input float\n"
"source : input rank-2 array('d') with bounds (3,ns)\n"
"charge : input rank-1 array('D') with bounds (ns)\n"
"center : input rank-1 array('d') with bounds (3)\n"
"nterms : input int\n"
"\nOther Parameters\n----------------\n"
"ns : input int, optional\n    Default: shape(source,1)\n"
"\nReturns\n-------\n"
"ier : int\n"
"expn : rank-2 array('D') with bounds (nterms + 1,2 * nterms + 1)";
/* extern void F_FUNC(l3dformmp,L3DFORMMP)(int*,double*,double*,complex_double*,int*,double*,int*,complex_double*); */
static PyObject *f2py_rout__internal_l3dformmp(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*,complex_double*,int*,double*,int*,complex_double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ier = 0;
  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *source = NULL;
  npy_intp source_Dims[2] = {-1, -1};
  const int source_Rank = 2;
  PyArrayObject *capi_source_tmp = NULL;
  int capi_source_intent = 0;
  PyObject *source_capi = Py_None;
  complex_double *charge = NULL;
  npy_intp charge_Dims[1] = {-1};
  const int charge_Rank = 1;
  PyArrayObject *capi_charge_tmp = NULL;
  int capi_charge_intent = 0;
  PyObject *charge_capi = Py_None;
  int ns = 0;
  PyObject *ns_capi = Py_None;
  double *center = NULL;
  npy_intp center_Dims[1] = {-1};
  const int center_Rank = 1;
  PyArrayObject *capi_center_tmp = NULL;
  int capi_center_intent = 0;
  PyObject *center_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[2] = {-1, -1};
  const int expn_Rank = 2;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
    static char *capi_kwlist[] = {"rscale","source","charge","center","nterms","ns",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOO|O:_internal.l3dformmp",\
        capi_kwlist,&rscale_capi,&source_capi,&charge_capi,&center_capi,&nterms_capi,&ns_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.l3dformmp() 1st argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable center */
  center_Dims[0]=3;
  capi_center_intent |= F2PY_INTENT_IN;
  capi_center_tmp = array_from_pyobj(NPY_DOUBLE,center_Dims,center_Rank,capi_center_intent,center_capi);
  if (capi_center_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `center' of _internal.l3dformmp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center = (double *)(PyArray_DATA(capi_center_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.l3dformmp() 5th argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ier */
  /* Processing variable source */
  source_Dims[0]=3;
  capi_source_intent |= F2PY_INTENT_IN;
  capi_source_tmp = array_from_pyobj(NPY_DOUBLE,source_Dims,source_Rank,capi_source_intent,source_capi);
  if (capi_source_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `source' of _internal.l3dformmp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source = (double *)(PyArray_DATA(capi_source_tmp));

  /* Processing variable ns */
  if (ns_capi == Py_None) ns = shape(source,1); else
    f2py_success = int_from_pyobj(&ns,ns_capi,"_internal.l3dformmp() 1st keyword (ns) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(source,1)==ns,"shape(source,1)==ns","1st keyword ns","l3dformmp:ns=%d",ns) {
  /* Processing variable expn */
  expn_Dims[0]=nterms + 1,expn_Dims[1]=2 * nterms + 1;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.l3dformmp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

  /* Processing variable charge */
  charge_Dims[0]=ns;
  capi_charge_intent |= F2PY_INTENT_IN;
  capi_charge_tmp = array_from_pyobj(NPY_CDOUBLE,charge_Dims,charge_Rank,capi_charge_intent,charge_capi);
  if (capi_charge_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `charge' of _internal.l3dformmp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge = (complex_double *)(PyArray_DATA(capi_charge_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ier,&rscale,source,charge,&ns,center,&nterms,expn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("iN",ier,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_charge_tmp!=charge_capi) {
    Py_XDECREF(capi_charge_tmp); }
  }  /*if (capi_charge_tmp == NULL) ... else of charge*/
  /* End of cleaning variable charge */
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  } /*CHECKSCALAR(shape(source,1)==ns)*/
  } /*if (f2py_success) of ns*/
  /* End of cleaning variable ns */
  if((PyObject *)capi_source_tmp!=source_capi) {
    Py_XDECREF(capi_source_tmp); }
  }  /*if (capi_source_tmp == NULL) ... else of source*/
  /* End of cleaning variable source */
  /* End of cleaning variable ier */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_center_tmp!=center_capi) {
    Py_XDECREF(capi_center_tmp); }
  }  /*if (capi_center_tmp == NULL) ... else of center*/
  /* End of cleaning variable center */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/****************************** end of l3dformmp ******************************/

/********************************* l3dformta *********************************/
static char doc_f2py_rout__internal_l3dformta[] = "\
ier,expn = l3dformta(rscale,source,charge,center,nterms,[ns])\n\nWrapper for ``l3dformta``.\
\n\nParameters\n----------\n"
"rscale : input float\n"
"source : input rank-2 array('d') with bounds (3,ns)\n"
"charge : input rank-1 array('D') with bounds (ns)\n"
"center : input rank-1 array('d') with bounds (3)\n"
"nterms : input int\n"
"\nOther Parameters\n----------------\n"
"ns : input int, optional\n    Default: shape(source,1)\n"
"\nReturns\n-------\n"
"ier : int\n"
"expn : rank-2 array('D') with bounds (nterms + 1,2 * nterms + 1)";
/* extern void F_FUNC(l3dformta,L3DFORMTA)(int*,double*,double*,complex_double*,int*,double*,int*,complex_double*); */
static PyObject *f2py_rout__internal_l3dformta(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*,complex_double*,int*,double*,int*,complex_double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ier = 0;
  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *source = NULL;
  npy_intp source_Dims[2] = {-1, -1};
  const int source_Rank = 2;
  PyArrayObject *capi_source_tmp = NULL;
  int capi_source_intent = 0;
  PyObject *source_capi = Py_None;
  complex_double *charge = NULL;
  npy_intp charge_Dims[1] = {-1};
  const int charge_Rank = 1;
  PyArrayObject *capi_charge_tmp = NULL;
  int capi_charge_intent = 0;
  PyObject *charge_capi = Py_None;
  int ns = 0;
  PyObject *ns_capi = Py_None;
  double *center = NULL;
  npy_intp center_Dims[1] = {-1};
  const int center_Rank = 1;
  PyArrayObject *capi_center_tmp = NULL;
  int capi_center_intent = 0;
  PyObject *center_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[2] = {-1, -1};
  const int expn_Rank = 2;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
    static char *capi_kwlist[] = {"rscale","source","charge","center","nterms","ns",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOO|O:_internal.l3dformta",\
        capi_kwlist,&rscale_capi,&source_capi,&charge_capi,&center_capi,&nterms_capi,&ns_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.l3dformta() 1st argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable center */
  center_Dims[0]=3;
  capi_center_intent |= F2PY_INTENT_IN;
  capi_center_tmp = array_from_pyobj(NPY_DOUBLE,center_Dims,center_Rank,capi_center_intent,center_capi);
  if (capi_center_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `center' of _internal.l3dformta to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center = (double *)(PyArray_DATA(capi_center_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.l3dformta() 5th argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ier */
  /* Processing variable source */
  source_Dims[0]=3;
  capi_source_intent |= F2PY_INTENT_IN;
  capi_source_tmp = array_from_pyobj(NPY_DOUBLE,source_Dims,source_Rank,capi_source_intent,source_capi);
  if (capi_source_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `source' of _internal.l3dformta to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source = (double *)(PyArray_DATA(capi_source_tmp));

  /* Processing variable ns */
  if (ns_capi == Py_None) ns = shape(source,1); else
    f2py_success = int_from_pyobj(&ns,ns_capi,"_internal.l3dformta() 1st keyword (ns) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(source,1)==ns,"shape(source,1)==ns","1st keyword ns","l3dformta:ns=%d",ns) {
  /* Processing variable expn */
  expn_Dims[0]=nterms + 1,expn_Dims[1]=2 * nterms + 1;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.l3dformta to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

  /* Processing variable charge */
  charge_Dims[0]=ns;
  capi_charge_intent |= F2PY_INTENT_IN;
  capi_charge_tmp = array_from_pyobj(NPY_CDOUBLE,charge_Dims,charge_Rank,capi_charge_intent,charge_capi);
  if (capi_charge_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `charge' of _internal.l3dformta to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge = (complex_double *)(PyArray_DATA(capi_charge_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ier,&rscale,source,charge,&ns,center,&nterms,expn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("iN",ier,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_charge_tmp!=charge_capi) {
    Py_XDECREF(capi_charge_tmp); }
  }  /*if (capi_charge_tmp == NULL) ... else of charge*/
  /* End of cleaning variable charge */
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  } /*CHECKSCALAR(shape(source,1)==ns)*/
  } /*if (f2py_success) of ns*/
  /* End of cleaning variable ns */
  if((PyObject *)capi_source_tmp!=source_capi) {
    Py_XDECREF(capi_source_tmp); }
  }  /*if (capi_source_tmp == NULL) ... else of source*/
  /* End of cleaning variable source */
  /* End of cleaning variable ier */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_center_tmp!=center_capi) {
    Py_XDECREF(capi_center_tmp); }
  }  /*if (capi_center_tmp == NULL) ... else of center*/
  /* End of cleaning variable center */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/****************************** end of l3dformta ******************************/

/********************************* h3dformmp *********************************/
static char doc_f2py_rout__internal_h3dformmp[] = "\
ier,expn = h3dformmp(zk,rscale,source,charge,center,nterms,[ns])\n\nWrapper for ``h3dformmp``.\
\n\nParameters\n----------\n"
"zk : input complex\n"
"rscale : input float\n"
"source : input rank-2 array('d') with bounds (3,ns)\n"
"charge : input rank-1 array('D') with bounds (ns)\n"
"center : input rank-1 array('d') with bounds (3)\n"
"nterms : input int\n"
"\nOther Parameters\n----------------\n"
"ns : input int, optional\n    Default: shape(source,1)\n"
"\nReturns\n-------\n"
"ier : int\n"
"expn : rank-2 array('D') with bounds (nterms + 1,2 * nterms + 1)";
/* extern void F_FUNC(h3dformmp,H3DFORMMP)(int*,complex_double*,double*,double*,complex_double*,int*,double*,int*,complex_double*); */
static PyObject *f2py_rout__internal_h3dformmp(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,complex_double*,double*,double*,complex_double*,int*,double*,int*,complex_double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ier = 0;
  complex_double zk;
  PyObject *zk_capi = Py_None;
  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *source = NULL;
  npy_intp source_Dims[2] = {-1, -1};
  const int source_Rank = 2;
  PyArrayObject *capi_source_tmp = NULL;
  int capi_source_intent = 0;
  PyObject *source_capi = Py_None;
  complex_double *charge = NULL;
  npy_intp charge_Dims[1] = {-1};
  const int charge_Rank = 1;
  PyArrayObject *capi_charge_tmp = NULL;
  int capi_charge_intent = 0;
  PyObject *charge_capi = Py_None;
  int ns = 0;
  PyObject *ns_capi = Py_None;
  double *center = NULL;
  npy_intp center_Dims[1] = {-1};
  const int center_Rank = 1;
  PyArrayObject *capi_center_tmp = NULL;
  int capi_center_intent = 0;
  PyObject *center_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[2] = {-1, -1};
  const int expn_Rank = 2;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
    static char *capi_kwlist[] = {"zk","rscale","source","charge","center","nterms","ns",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOO|O:_internal.h3dformmp",\
        capi_kwlist,&zk_capi,&rscale_capi,&source_capi,&charge_capi,&center_capi,&nterms_capi,&ns_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.h3dformmp() 2nd argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable center */
  center_Dims[0]=3;
  capi_center_intent |= F2PY_INTENT_IN;
  capi_center_tmp = array_from_pyobj(NPY_DOUBLE,center_Dims,center_Rank,capi_center_intent,center_capi);
  if (capi_center_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `center' of _internal.h3dformmp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center = (double *)(PyArray_DATA(capi_center_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.h3dformmp() 6th argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ier */
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.h3dformmp() 1st argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable source */
  source_Dims[0]=3;
  capi_source_intent |= F2PY_INTENT_IN;
  capi_source_tmp = array_from_pyobj(NPY_DOUBLE,source_Dims,source_Rank,capi_source_intent,source_capi);
  if (capi_source_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `source' of _internal.h3dformmp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source = (double *)(PyArray_DATA(capi_source_tmp));

  /* Processing variable ns */
  if (ns_capi == Py_None) ns = shape(source,1); else
    f2py_success = int_from_pyobj(&ns,ns_capi,"_internal.h3dformmp() 1st keyword (ns) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(source,1)==ns,"shape(source,1)==ns","1st keyword ns","h3dformmp:ns=%d",ns) {
  /* Processing variable expn */
  expn_Dims[0]=nterms + 1,expn_Dims[1]=2 * nterms + 1;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.h3dformmp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

  /* Processing variable charge */
  charge_Dims[0]=ns;
  capi_charge_intent |= F2PY_INTENT_IN;
  capi_charge_tmp = array_from_pyobj(NPY_CDOUBLE,charge_Dims,charge_Rank,capi_charge_intent,charge_capi);
  if (capi_charge_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `charge' of _internal.h3dformmp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge = (complex_double *)(PyArray_DATA(capi_charge_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ier,&zk,&rscale,source,charge,&ns,center,&nterms,expn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("iN",ier,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_charge_tmp!=charge_capi) {
    Py_XDECREF(capi_charge_tmp); }
  }  /*if (capi_charge_tmp == NULL) ... else of charge*/
  /* End of cleaning variable charge */
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  } /*CHECKSCALAR(shape(source,1)==ns)*/
  } /*if (f2py_success) of ns*/
  /* End of cleaning variable ns */
  if((PyObject *)capi_source_tmp!=source_capi) {
    Py_XDECREF(capi_source_tmp); }
  }  /*if (capi_source_tmp == NULL) ... else of source*/
  /* End of cleaning variable source */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
  /* End of cleaning variable ier */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_center_tmp!=center_capi) {
    Py_XDECREF(capi_center_tmp); }
  }  /*if (capi_center_tmp == NULL) ... else of center*/
  /* End of cleaning variable center */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/****************************** end of h3dformmp ******************************/

/********************************* h3dformta *********************************/
static char doc_f2py_rout__internal_h3dformta[] = "\
ier,expn = h3dformta(zk,rscale,source,charge,center,nterms,[ns])\n\nWrapper for ``h3dformta``.\
\n\nParameters\n----------\n"
"zk : input complex\n"
"rscale : input float\n"
"source : input rank-2 array('d') with bounds (3,ns)\n"
"charge : input rank-1 array('D') with bounds (ns)\n"
"center : input rank-1 array('d') with bounds (3)\n"
"nterms : input int\n"
"\nOther Parameters\n----------------\n"
"ns : input int, optional\n    Default: shape(source,1)\n"
"\nReturns\n-------\n"
"ier : int\n"
"expn : rank-2 array('D') with bounds (nterms + 1,2 * nterms + 1)";
/* extern void F_FUNC(h3dformta,H3DFORMTA)(int*,complex_double*,double*,double*,complex_double*,int*,double*,int*,complex_double*); */
static PyObject *f2py_rout__internal_h3dformta(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,complex_double*,double*,double*,complex_double*,int*,double*,int*,complex_double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ier = 0;
  complex_double zk;
  PyObject *zk_capi = Py_None;
  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *source = NULL;
  npy_intp source_Dims[2] = {-1, -1};
  const int source_Rank = 2;
  PyArrayObject *capi_source_tmp = NULL;
  int capi_source_intent = 0;
  PyObject *source_capi = Py_None;
  complex_double *charge = NULL;
  npy_intp charge_Dims[1] = {-1};
  const int charge_Rank = 1;
  PyArrayObject *capi_charge_tmp = NULL;
  int capi_charge_intent = 0;
  PyObject *charge_capi = Py_None;
  int ns = 0;
  PyObject *ns_capi = Py_None;
  double *center = NULL;
  npy_intp center_Dims[1] = {-1};
  const int center_Rank = 1;
  PyArrayObject *capi_center_tmp = NULL;
  int capi_center_intent = 0;
  PyObject *center_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[2] = {-1, -1};
  const int expn_Rank = 2;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
    static char *capi_kwlist[] = {"zk","rscale","source","charge","center","nterms","ns",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOO|O:_internal.h3dformta",\
        capi_kwlist,&zk_capi,&rscale_capi,&source_capi,&charge_capi,&center_capi,&nterms_capi,&ns_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.h3dformta() 2nd argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable center */
  center_Dims[0]=3;
  capi_center_intent |= F2PY_INTENT_IN;
  capi_center_tmp = array_from_pyobj(NPY_DOUBLE,center_Dims,center_Rank,capi_center_intent,center_capi);
  if (capi_center_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `center' of _internal.h3dformta to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center = (double *)(PyArray_DATA(capi_center_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.h3dformta() 6th argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ier */
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.h3dformta() 1st argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable source */
  source_Dims[0]=3;
  capi_source_intent |= F2PY_INTENT_IN;
  capi_source_tmp = array_from_pyobj(NPY_DOUBLE,source_Dims,source_Rank,capi_source_intent,source_capi);
  if (capi_source_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `source' of _internal.h3dformta to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source = (double *)(PyArray_DATA(capi_source_tmp));

  /* Processing variable ns */
  if (ns_capi == Py_None) ns = shape(source,1); else
    f2py_success = int_from_pyobj(&ns,ns_capi,"_internal.h3dformta() 1st keyword (ns) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(source,1)==ns,"shape(source,1)==ns","1st keyword ns","h3dformta:ns=%d",ns) {
  /* Processing variable expn */
  expn_Dims[0]=nterms + 1,expn_Dims[1]=2 * nterms + 1;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.h3dformta to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

  /* Processing variable charge */
  charge_Dims[0]=ns;
  capi_charge_intent |= F2PY_INTENT_IN;
  capi_charge_tmp = array_from_pyobj(NPY_CDOUBLE,charge_Dims,charge_Rank,capi_charge_intent,charge_capi);
  if (capi_charge_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `charge' of _internal.h3dformta to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge = (complex_double *)(PyArray_DATA(capi_charge_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ier,&zk,&rscale,source,charge,&ns,center,&nterms,expn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("iN",ier,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_charge_tmp!=charge_capi) {
    Py_XDECREF(capi_charge_tmp); }
  }  /*if (capi_charge_tmp == NULL) ... else of charge*/
  /* End of cleaning variable charge */
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  } /*CHECKSCALAR(shape(source,1)==ns)*/
  } /*if (f2py_success) of ns*/
  /* End of cleaning variable ns */
  if((PyObject *)capi_source_tmp!=source_capi) {
    Py_XDECREF(capi_source_tmp); }
  }  /*if (capi_source_tmp == NULL) ... else of source*/
  /* End of cleaning variable source */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
  /* End of cleaning variable ier */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_center_tmp!=center_capi) {
    Py_XDECREF(capi_center_tmp); }
  }  /*if (capi_center_tmp == NULL) ... else of center*/
  /* End of cleaning variable center */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/****************************** end of h3dformta ******************************/

/******************************** l2dformmp_dp ********************************/
static char doc_f2py_rout__internal_l2dformmp_dp[] = "\
ier,expn = l2dformmp_dp(rscale,source,dipstr,center,nterms,[ns])\n\nWrapper for ``l2dformmp_dp``.\
\n\nParameters\n----------\n"
"rscale : input float\n"
"source : input rank-2 array('d') with bounds (2,ns)\n"
"dipstr : input rank-1 array('D') with bounds (ns)\n"
"center : input rank-1 array('d') with bounds (2)\n"
"nterms : input int\n"
"\nOther Parameters\n----------------\n"
"ns : input int, optional\n    Default: shape(source,1)\n"
"\nReturns\n-------\n"
"ier : int\n"
"expn : rank-1 array('D') with bounds (nterms + 1)";
/* extern void F_FUNC_US(l2dformmp_dp,L2DFORMMP_DP)(int*,double*,double*,complex_double*,int*,double*,int*,complex_double*); */
static PyObject *f2py_rout__internal_l2dformmp_dp(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*,complex_double*,int*,double*,int*,complex_double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ier = 0;
  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *source = NULL;
  npy_intp source_Dims[2] = {-1, -1};
  const int source_Rank = 2;
  PyArrayObject *capi_source_tmp = NULL;
  int capi_source_intent = 0;
  PyObject *source_capi = Py_None;
  complex_double *dipstr = NULL;
  npy_intp dipstr_Dims[1] = {-1};
  const int dipstr_Rank = 1;
  PyArrayObject *capi_dipstr_tmp = NULL;
  int capi_dipstr_intent = 0;
  PyObject *dipstr_capi = Py_None;
  int ns = 0;
  PyObject *ns_capi = Py_None;
  double *center = NULL;
  npy_intp center_Dims[1] = {-1};
  const int center_Rank = 1;
  PyArrayObject *capi_center_tmp = NULL;
  int capi_center_intent = 0;
  PyObject *center_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[1] = {-1};
  const int expn_Rank = 1;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
    static char *capi_kwlist[] = {"rscale","source","dipstr","center","nterms","ns",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOO|O:_internal.l2dformmp_dp",\
        capi_kwlist,&rscale_capi,&source_capi,&dipstr_capi,&center_capi,&nterms_capi,&ns_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.l2dformmp_dp() 1st argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable center */
  center_Dims[0]=2;
  capi_center_intent |= F2PY_INTENT_IN;
  capi_center_tmp = array_from_pyobj(NPY_DOUBLE,center_Dims,center_Rank,capi_center_intent,center_capi);
  if (capi_center_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `center' of _internal.l2dformmp_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center = (double *)(PyArray_DATA(capi_center_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.l2dformmp_dp() 5th argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ier */
  /* Processing variable source */
  source_Dims[0]=2;
  capi_source_intent |= F2PY_INTENT_IN;
  capi_source_tmp = array_from_pyobj(NPY_DOUBLE,source_Dims,source_Rank,capi_source_intent,source_capi);
  if (capi_source_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `source' of _internal.l2dformmp_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source = (double *)(PyArray_DATA(capi_source_tmp));

  /* Processing variable ns */
  if (ns_capi == Py_None) ns = shape(source,1); else
    f2py_success = int_from_pyobj(&ns,ns_capi,"_internal.l2dformmp_dp() 1st keyword (ns) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(source,1)==ns,"shape(source,1)==ns","1st keyword ns","l2dformmp_dp:ns=%d",ns) {
  /* Processing variable expn */
  expn_Dims[0]=nterms + 1;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.l2dformmp_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

  /* Processing variable dipstr */
  dipstr_Dims[0]=ns;
  capi_dipstr_intent |= F2PY_INTENT_IN;
  capi_dipstr_tmp = array_from_pyobj(NPY_CDOUBLE,dipstr_Dims,dipstr_Rank,capi_dipstr_intent,dipstr_capi);
  if (capi_dipstr_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `dipstr' of _internal.l2dformmp_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr = (complex_double *)(PyArray_DATA(capi_dipstr_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ier,&rscale,source,dipstr,&ns,center,&nterms,expn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("iN",ier,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_dipstr_tmp!=dipstr_capi) {
    Py_XDECREF(capi_dipstr_tmp); }
  }  /*if (capi_dipstr_tmp == NULL) ... else of dipstr*/
  /* End of cleaning variable dipstr */
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  } /*CHECKSCALAR(shape(source,1)==ns)*/
  } /*if (f2py_success) of ns*/
  /* End of cleaning variable ns */
  if((PyObject *)capi_source_tmp!=source_capi) {
    Py_XDECREF(capi_source_tmp); }
  }  /*if (capi_source_tmp == NULL) ... else of source*/
  /* End of cleaning variable source */
  /* End of cleaning variable ier */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_center_tmp!=center_capi) {
    Py_XDECREF(capi_center_tmp); }
  }  /*if (capi_center_tmp == NULL) ... else of center*/
  /* End of cleaning variable center */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/**************************** end of l2dformmp_dp ****************************/

/******************************** l2dformta_dp ********************************/
static char doc_f2py_rout__internal_l2dformta_dp[] = "\
ier,expn = l2dformta_dp(rscale,source,dipstr,center,nterms,[ns])\n\nWrapper for ``l2dformta_dp``.\
\n\nParameters\n----------\n"
"rscale : input float\n"
"source : input rank-2 array('d') with bounds (2,ns)\n"
"dipstr : input rank-1 array('D') with bounds (ns)\n"
"center : input rank-1 array('d') with bounds (2)\n"
"nterms : input int\n"
"\nOther Parameters\n----------------\n"
"ns : input int, optional\n    Default: shape(source,1)\n"
"\nReturns\n-------\n"
"ier : int\n"
"expn : rank-1 array('D') with bounds (nterms + 1)";
/* extern void F_FUNC_US(l2dformta_dp,L2DFORMTA_DP)(int*,double*,double*,complex_double*,int*,double*,int*,complex_double*); */
static PyObject *f2py_rout__internal_l2dformta_dp(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*,complex_double*,int*,double*,int*,complex_double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ier = 0;
  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *source = NULL;
  npy_intp source_Dims[2] = {-1, -1};
  const int source_Rank = 2;
  PyArrayObject *capi_source_tmp = NULL;
  int capi_source_intent = 0;
  PyObject *source_capi = Py_None;
  complex_double *dipstr = NULL;
  npy_intp dipstr_Dims[1] = {-1};
  const int dipstr_Rank = 1;
  PyArrayObject *capi_dipstr_tmp = NULL;
  int capi_dipstr_intent = 0;
  PyObject *dipstr_capi = Py_None;
  int ns = 0;
  PyObject *ns_capi = Py_None;
  double *center = NULL;
  npy_intp center_Dims[1] = {-1};
  const int center_Rank = 1;
  PyArrayObject *capi_center_tmp = NULL;
  int capi_center_intent = 0;
  PyObject *center_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[1] = {-1};
  const int expn_Rank = 1;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
    static char *capi_kwlist[] = {"rscale","source","dipstr","center","nterms","ns",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOO|O:_internal.l2dformta_dp",\
        capi_kwlist,&rscale_capi,&source_capi,&dipstr_capi,&center_capi,&nterms_capi,&ns_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.l2dformta_dp() 1st argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable center */
  center_Dims[0]=2;
  capi_center_intent |= F2PY_INTENT_IN;
  capi_center_tmp = array_from_pyobj(NPY_DOUBLE,center_Dims,center_Rank,capi_center_intent,center_capi);
  if (capi_center_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `center' of _internal.l2dformta_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center = (double *)(PyArray_DATA(capi_center_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.l2dformta_dp() 5th argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ier */
  /* Processing variable source */
  source_Dims[0]=2;
  capi_source_intent |= F2PY_INTENT_IN;
  capi_source_tmp = array_from_pyobj(NPY_DOUBLE,source_Dims,source_Rank,capi_source_intent,source_capi);
  if (capi_source_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `source' of _internal.l2dformta_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source = (double *)(PyArray_DATA(capi_source_tmp));

  /* Processing variable ns */
  if (ns_capi == Py_None) ns = shape(source,1); else
    f2py_success = int_from_pyobj(&ns,ns_capi,"_internal.l2dformta_dp() 1st keyword (ns) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(source,1)==ns,"shape(source,1)==ns","1st keyword ns","l2dformta_dp:ns=%d",ns) {
  /* Processing variable expn */
  expn_Dims[0]=nterms + 1;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.l2dformta_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

  /* Processing variable dipstr */
  dipstr_Dims[0]=ns;
  capi_dipstr_intent |= F2PY_INTENT_IN;
  capi_dipstr_tmp = array_from_pyobj(NPY_CDOUBLE,dipstr_Dims,dipstr_Rank,capi_dipstr_intent,dipstr_capi);
  if (capi_dipstr_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `dipstr' of _internal.l2dformta_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr = (complex_double *)(PyArray_DATA(capi_dipstr_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ier,&rscale,source,dipstr,&ns,center,&nterms,expn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("iN",ier,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_dipstr_tmp!=dipstr_capi) {
    Py_XDECREF(capi_dipstr_tmp); }
  }  /*if (capi_dipstr_tmp == NULL) ... else of dipstr*/
  /* End of cleaning variable dipstr */
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  } /*CHECKSCALAR(shape(source,1)==ns)*/
  } /*if (f2py_success) of ns*/
  /* End of cleaning variable ns */
  if((PyObject *)capi_source_tmp!=source_capi) {
    Py_XDECREF(capi_source_tmp); }
  }  /*if (capi_source_tmp == NULL) ... else of source*/
  /* End of cleaning variable source */
  /* End of cleaning variable ier */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_center_tmp!=center_capi) {
    Py_XDECREF(capi_center_tmp); }
  }  /*if (capi_center_tmp == NULL) ... else of center*/
  /* End of cleaning variable center */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/**************************** end of l2dformta_dp ****************************/

/******************************** h2dformmp_dp ********************************/
static char doc_f2py_rout__internal_h2dformmp_dp[] = "\
ier,expn = h2dformmp_dp(zk,rscale,source,dipstr,dipvec,center,nterms,[ns])\n\nWrapper for ``h2dformmp_dp``.\
\n\nParameters\n----------\n"
"zk : input complex\n"
"rscale : input float\n"
"source : input rank-2 array('d') with bounds (2,ns)\n"
"dipstr : input rank-1 array('D') with bounds (ns)\n"
"dipvec : input rank-2 array('d') with bounds (2,ns)\n"
"center : input rank-1 array('d') with bounds (2)\n"
"nterms : input int\n"
"\nOther Parameters\n----------------\n"
"ns : input int, optional\n    Default: shape(source,1)\n"
"\nReturns\n-------\n"
"ier : int\n"
"expn : rank-1 array('D') with bounds (2 * nterms + 1)";
/* extern void F_FUNC_US(h2dformmp_dp,H2DFORMMP_DP)(int*,complex_double*,double*,double*,complex_double*,double*,int*,double*,int*,complex_double*); */
static PyObject *f2py_rout__internal_h2dformmp_dp(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,complex_double*,double*,double*,complex_double*,double*,int*,double*,int*,complex_double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ier = 0;
  complex_double zk;
  PyObject *zk_capi = Py_None;
  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *source = NULL;
  npy_intp source_Dims[2] = {-1, -1};
  const int source_Rank = 2;
  PyArrayObject *capi_source_tmp = NULL;
  int capi_source_intent = 0;
  PyObject *source_capi = Py_None;
  complex_double *dipstr = NULL;
  npy_intp dipstr_Dims[1] = {-1};
  const int dipstr_Rank = 1;
  PyArrayObject *capi_dipstr_tmp = NULL;
  int capi_dipstr_intent = 0;
  PyObject *dipstr_capi = Py_None;
  double *dipvec = NULL;
  npy_intp dipvec_Dims[2] = {-1, -1};
  const int dipvec_Rank = 2;
  PyArrayObject *capi_dipvec_tmp = NULL;
  int capi_dipvec_intent = 0;
  PyObject *dipvec_capi = Py_None;
  int ns = 0;
  PyObject *ns_capi = Py_None;
  double *center = NULL;
  npy_intp center_Dims[1] = {-1};
  const int center_Rank = 1;
  PyArrayObject *capi_center_tmp = NULL;
  int capi_center_intent = 0;
  PyObject *center_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[1] = {-1};
  const int expn_Rank = 1;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
    static char *capi_kwlist[] = {"zk","rscale","source","dipstr","dipvec","center","nterms","ns",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOO|O:_internal.h2dformmp_dp",\
        capi_kwlist,&zk_capi,&rscale_capi,&source_capi,&dipstr_capi,&dipvec_capi,&center_capi,&nterms_capi,&ns_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.h2dformmp_dp() 2nd argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable center */
  center_Dims[0]=2;
  capi_center_intent |= F2PY_INTENT_IN;
  capi_center_tmp = array_from_pyobj(NPY_DOUBLE,center_Dims,center_Rank,capi_center_intent,center_capi);
  if (capi_center_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `center' of _internal.h2dformmp_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center = (double *)(PyArray_DATA(capi_center_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.h2dformmp_dp() 7th argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ier */
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.h2dformmp_dp() 1st argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable source */
  source_Dims[0]=2;
  capi_source_intent |= F2PY_INTENT_IN;
  capi_source_tmp = array_from_pyobj(NPY_DOUBLE,source_Dims,source_Rank,capi_source_intent,source_capi);
  if (capi_source_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `source' of _internal.h2dformmp_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source = (double *)(PyArray_DATA(capi_source_tmp));

  /* Processing variable ns */
  if (ns_capi == Py_None) ns = shape(source,1); else
    f2py_success = int_from_pyobj(&ns,ns_capi,"_internal.h2dformmp_dp() 1st keyword (ns) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(source,1)==ns,"shape(source,1)==ns","1st keyword ns","h2dformmp_dp:ns=%d",ns) {
  /* Processing variable expn */
  expn_Dims[0]=2 * nterms + 1;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.h2dformmp_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

  /* Processing variable dipvec */
  dipvec_Dims[0]=2,dipvec_Dims[1]=ns;
  capi_dipvec_intent |= F2PY_INTENT_IN;
  capi_dipvec_tmp = array_from_pyobj(NPY_DOUBLE,dipvec_Dims,dipvec_Rank,capi_dipvec_intent,dipvec_capi);
  if (capi_dipvec_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `dipvec' of _internal.h2dformmp_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipvec = (double *)(PyArray_DATA(capi_dipvec_tmp));

  /* Processing variable dipstr */
  dipstr_Dims[0]=ns;
  capi_dipstr_intent |= F2PY_INTENT_IN;
  capi_dipstr_tmp = array_from_pyobj(NPY_CDOUBLE,dipstr_Dims,dipstr_Rank,capi_dipstr_intent,dipstr_capi);
  if (capi_dipstr_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `dipstr' of _internal.h2dformmp_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr = (complex_double *)(PyArray_DATA(capi_dipstr_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ier,&zk,&rscale,source,dipstr,dipvec,&ns,center,&nterms,expn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("iN",ier,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_dipstr_tmp!=dipstr_capi) {
    Py_XDECREF(capi_dipstr_tmp); }
  }  /*if (capi_dipstr_tmp == NULL) ... else of dipstr*/
  /* End of cleaning variable dipstr */
  if((PyObject *)capi_dipvec_tmp!=dipvec_capi) {
    Py_XDECREF(capi_dipvec_tmp); }
  }  /*if (capi_dipvec_tmp == NULL) ... else of dipvec*/
  /* End of cleaning variable dipvec */
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  } /*CHECKSCALAR(shape(source,1)==ns)*/
  } /*if (f2py_success) of ns*/
  /* End of cleaning variable ns */
  if((PyObject *)capi_source_tmp!=source_capi) {
    Py_XDECREF(capi_source_tmp); }
  }  /*if (capi_source_tmp == NULL) ... else of source*/
  /* End of cleaning variable source */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
  /* End of cleaning variable ier */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_center_tmp!=center_capi) {
    Py_XDECREF(capi_center_tmp); }
  }  /*if (capi_center_tmp == NULL) ... else of center*/
  /* End of cleaning variable center */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/**************************** end of h2dformmp_dp ****************************/

/******************************** h2dformta_dp ********************************/
static char doc_f2py_rout__internal_h2dformta_dp[] = "\
ier,expn = h2dformta_dp(zk,rscale,source,dipstr,dipvec,center,nterms,[ns])\n\nWrapper for ``h2dformta_dp``.\
\n\nParameters\n----------\n"
"zk : input complex\n"
"rscale : input float\n"
"source : input rank-2 array('d') with bounds (2,ns)\n"
"dipstr : input rank-1 array('D') with bounds (ns)\n"
"dipvec : input rank-2 array('d') with bounds (2,ns)\n"
"center : input rank-1 array('d') with bounds (2)\n"
"nterms : input int\n"
"\nOther Parameters\n----------------\n"
"ns : input int, optional\n    Default: shape(source,1)\n"
"\nReturns\n-------\n"
"ier : int\n"
"expn : rank-1 array('D') with bounds (2 * nterms + 1)";
/* extern void F_FUNC_US(h2dformta_dp,H2DFORMTA_DP)(int*,complex_double*,double*,double*,complex_double*,double*,int*,double*,int*,complex_double*); */
static PyObject *f2py_rout__internal_h2dformta_dp(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,complex_double*,double*,double*,complex_double*,double*,int*,double*,int*,complex_double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ier = 0;
  complex_double zk;
  PyObject *zk_capi = Py_None;
  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *source = NULL;
  npy_intp source_Dims[2] = {-1, -1};
  const int source_Rank = 2;
  PyArrayObject *capi_source_tmp = NULL;
  int capi_source_intent = 0;
  PyObject *source_capi = Py_None;
  complex_double *dipstr = NULL;
  npy_intp dipstr_Dims[1] = {-1};
  const int dipstr_Rank = 1;
  PyArrayObject *capi_dipstr_tmp = NULL;
  int capi_dipstr_intent = 0;
  PyObject *dipstr_capi = Py_None;
  double *dipvec = NULL;
  npy_intp dipvec_Dims[2] = {-1, -1};
  const int dipvec_Rank = 2;
  PyArrayObject *capi_dipvec_tmp = NULL;
  int capi_dipvec_intent = 0;
  PyObject *dipvec_capi = Py_None;
  int ns = 0;
  PyObject *ns_capi = Py_None;
  double *center = NULL;
  npy_intp center_Dims[1] = {-1};
  const int center_Rank = 1;
  PyArrayObject *capi_center_tmp = NULL;
  int capi_center_intent = 0;
  PyObject *center_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[1] = {-1};
  const int expn_Rank = 1;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
    static char *capi_kwlist[] = {"zk","rscale","source","dipstr","dipvec","center","nterms","ns",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOO|O:_internal.h2dformta_dp",\
        capi_kwlist,&zk_capi,&rscale_capi,&source_capi,&dipstr_capi,&dipvec_capi,&center_capi,&nterms_capi,&ns_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.h2dformta_dp() 2nd argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable center */
  center_Dims[0]=2;
  capi_center_intent |= F2PY_INTENT_IN;
  capi_center_tmp = array_from_pyobj(NPY_DOUBLE,center_Dims,center_Rank,capi_center_intent,center_capi);
  if (capi_center_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `center' of _internal.h2dformta_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center = (double *)(PyArray_DATA(capi_center_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.h2dformta_dp() 7th argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ier */
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.h2dformta_dp() 1st argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable source */
  source_Dims[0]=2;
  capi_source_intent |= F2PY_INTENT_IN;
  capi_source_tmp = array_from_pyobj(NPY_DOUBLE,source_Dims,source_Rank,capi_source_intent,source_capi);
  if (capi_source_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `source' of _internal.h2dformta_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source = (double *)(PyArray_DATA(capi_source_tmp));

  /* Processing variable ns */
  if (ns_capi == Py_None) ns = shape(source,1); else
    f2py_success = int_from_pyobj(&ns,ns_capi,"_internal.h2dformta_dp() 1st keyword (ns) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(source,1)==ns,"shape(source,1)==ns","1st keyword ns","h2dformta_dp:ns=%d",ns) {
  /* Processing variable expn */
  expn_Dims[0]=2 * nterms + 1;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.h2dformta_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

  /* Processing variable dipvec */
  dipvec_Dims[0]=2,dipvec_Dims[1]=ns;
  capi_dipvec_intent |= F2PY_INTENT_IN;
  capi_dipvec_tmp = array_from_pyobj(NPY_DOUBLE,dipvec_Dims,dipvec_Rank,capi_dipvec_intent,dipvec_capi);
  if (capi_dipvec_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `dipvec' of _internal.h2dformta_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipvec = (double *)(PyArray_DATA(capi_dipvec_tmp));

  /* Processing variable dipstr */
  dipstr_Dims[0]=ns;
  capi_dipstr_intent |= F2PY_INTENT_IN;
  capi_dipstr_tmp = array_from_pyobj(NPY_CDOUBLE,dipstr_Dims,dipstr_Rank,capi_dipstr_intent,dipstr_capi);
  if (capi_dipstr_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `dipstr' of _internal.h2dformta_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr = (complex_double *)(PyArray_DATA(capi_dipstr_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ier,&zk,&rscale,source,dipstr,dipvec,&ns,center,&nterms,expn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("iN",ier,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_dipstr_tmp!=dipstr_capi) {
    Py_XDECREF(capi_dipstr_tmp); }
  }  /*if (capi_dipstr_tmp == NULL) ... else of dipstr*/
  /* End of cleaning variable dipstr */
  if((PyObject *)capi_dipvec_tmp!=dipvec_capi) {
    Py_XDECREF(capi_dipvec_tmp); }
  }  /*if (capi_dipvec_tmp == NULL) ... else of dipvec*/
  /* End of cleaning variable dipvec */
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  } /*CHECKSCALAR(shape(source,1)==ns)*/
  } /*if (f2py_success) of ns*/
  /* End of cleaning variable ns */
  if((PyObject *)capi_source_tmp!=source_capi) {
    Py_XDECREF(capi_source_tmp); }
  }  /*if (capi_source_tmp == NULL) ... else of source*/
  /* End of cleaning variable source */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
  /* End of cleaning variable ier */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_center_tmp!=center_capi) {
    Py_XDECREF(capi_center_tmp); }
  }  /*if (capi_center_tmp == NULL) ... else of center*/
  /* End of cleaning variable center */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/**************************** end of h2dformta_dp ****************************/

/******************************** l3dformmp_dp ********************************/
static char doc_f2py_rout__internal_l3dformmp_dp[] = "\
ier,expn = l3dformmp_dp(rscale,source,dipstr,dipvec,center,nterms,[ns])\n\nWrapper for ``l3dformmp_dp``.\
\n\nParameters\n----------\n"
"rscale : input float\n"
"source : input rank-2 array('d') with bounds (3,ns)\n"
"dipstr : input rank-1 array('D') with bounds (ns)\n"
"dipvec : input rank-2 array('d') with bounds (3,ns)\n"
"center : input rank-1 array('d') with bounds (3)\n"
"nterms : input int\n"
"\nOther Parameters\n----------------\n"
"ns : input int, optional\n    Default: shape(source,1)\n"
"\nReturns\n-------\n"
"ier : int\n"
"expn : rank-2 array('D') with bounds (nterms + 1,2 * nterms + 1)";
/* extern void F_FUNC_US(l3dformmp_dp,L3DFORMMP_DP)(int*,double*,double*,complex_double*,double*,int*,double*,int*,complex_double*); */
static PyObject *f2py_rout__internal_l3dformmp_dp(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*,complex_double*,double*,int*,double*,int*,complex_double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ier = 0;
  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *source = NULL;
  npy_intp source_Dims[2] = {-1, -1};
  const int source_Rank = 2;
  PyArrayObject *capi_source_tmp = NULL;
  int capi_source_intent = 0;
  PyObject *source_capi = Py_None;
  complex_double *dipstr = NULL;
  npy_intp dipstr_Dims[1] = {-1};
  const int dipstr_Rank = 1;
  PyArrayObject *capi_dipstr_tmp = NULL;
  int capi_dipstr_intent = 0;
  PyObject *dipstr_capi = Py_None;
  double *dipvec = NULL;
  npy_intp dipvec_Dims[2] = {-1, -1};
  const int dipvec_Rank = 2;
  PyArrayObject *capi_dipvec_tmp = NULL;
  int capi_dipvec_intent = 0;
  PyObject *dipvec_capi = Py_None;
  int ns = 0;
  PyObject *ns_capi = Py_None;
  double *center = NULL;
  npy_intp center_Dims[1] = {-1};
  const int center_Rank = 1;
  PyArrayObject *capi_center_tmp = NULL;
  int capi_center_intent = 0;
  PyObject *center_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[2] = {-1, -1};
  const int expn_Rank = 2;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
    static char *capi_kwlist[] = {"rscale","source","dipstr","dipvec","center","nterms","ns",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOO|O:_internal.l3dformmp_dp",\
        capi_kwlist,&rscale_capi,&source_capi,&dipstr_capi,&dipvec_capi,&center_capi,&nterms_capi,&ns_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.l3dformmp_dp() 1st argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable center */
  center_Dims[0]=3;
  capi_center_intent |= F2PY_INTENT_IN;
  capi_center_tmp = array_from_pyobj(NPY_DOUBLE,center_Dims,center_Rank,capi_center_intent,center_capi);
  if (capi_center_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `center' of _internal.l3dformmp_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center = (double *)(PyArray_DATA(capi_center_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.l3dformmp_dp() 6th argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ier */
  /* Processing variable source */
  source_Dims[0]=3;
  capi_source_intent |= F2PY_INTENT_IN;
  capi_source_tmp = array_from_pyobj(NPY_DOUBLE,source_Dims,source_Rank,capi_source_intent,source_capi);
  if (capi_source_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `source' of _internal.l3dformmp_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source = (double *)(PyArray_DATA(capi_source_tmp));

  /* Processing variable ns */
  if (ns_capi == Py_None) ns = shape(source,1); else
    f2py_success = int_from_pyobj(&ns,ns_capi,"_internal.l3dformmp_dp() 1st keyword (ns) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(source,1)==ns,"shape(source,1)==ns","1st keyword ns","l3dformmp_dp:ns=%d",ns) {
  /* Processing variable expn */
  expn_Dims[0]=nterms + 1,expn_Dims[1]=2 * nterms + 1;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.l3dformmp_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

  /* Processing variable dipvec */
  dipvec_Dims[0]=3,dipvec_Dims[1]=ns;
  capi_dipvec_intent |= F2PY_INTENT_IN;
  capi_dipvec_tmp = array_from_pyobj(NPY_DOUBLE,dipvec_Dims,dipvec_Rank,capi_dipvec_intent,dipvec_capi);
  if (capi_dipvec_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `dipvec' of _internal.l3dformmp_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipvec = (double *)(PyArray_DATA(capi_dipvec_tmp));

  /* Processing variable dipstr */
  dipstr_Dims[0]=ns;
  capi_dipstr_intent |= F2PY_INTENT_IN;
  capi_dipstr_tmp = array_from_pyobj(NPY_CDOUBLE,dipstr_Dims,dipstr_Rank,capi_dipstr_intent,dipstr_capi);
  if (capi_dipstr_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `dipstr' of _internal.l3dformmp_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr = (complex_double *)(PyArray_DATA(capi_dipstr_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ier,&rscale,source,dipstr,dipvec,&ns,center,&nterms,expn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("iN",ier,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_dipstr_tmp!=dipstr_capi) {
    Py_XDECREF(capi_dipstr_tmp); }
  }  /*if (capi_dipstr_tmp == NULL) ... else of dipstr*/
  /* End of cleaning variable dipstr */
  if((PyObject *)capi_dipvec_tmp!=dipvec_capi) {
    Py_XDECREF(capi_dipvec_tmp); }
  }  /*if (capi_dipvec_tmp == NULL) ... else of dipvec*/
  /* End of cleaning variable dipvec */
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  } /*CHECKSCALAR(shape(source,1)==ns)*/
  } /*if (f2py_success) of ns*/
  /* End of cleaning variable ns */
  if((PyObject *)capi_source_tmp!=source_capi) {
    Py_XDECREF(capi_source_tmp); }
  }  /*if (capi_source_tmp == NULL) ... else of source*/
  /* End of cleaning variable source */
  /* End of cleaning variable ier */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_center_tmp!=center_capi) {
    Py_XDECREF(capi_center_tmp); }
  }  /*if (capi_center_tmp == NULL) ... else of center*/
  /* End of cleaning variable center */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/**************************** end of l3dformmp_dp ****************************/

/******************************** l3dformta_dp ********************************/
static char doc_f2py_rout__internal_l3dformta_dp[] = "\
ier,expn = l3dformta_dp(rscale,source,dipstr,dipvec,center,nterms,[ns])\n\nWrapper for ``l3dformta_dp``.\
\n\nParameters\n----------\n"
"rscale : input float\n"
"source : input rank-2 array('d') with bounds (3,ns)\n"
"dipstr : input rank-1 array('D') with bounds (ns)\n"
"dipvec : input rank-2 array('d') with bounds (3,ns)\n"
"center : input rank-1 array('d') with bounds (3)\n"
"nterms : input int\n"
"\nOther Parameters\n----------------\n"
"ns : input int, optional\n    Default: shape(source,1)\n"
"\nReturns\n-------\n"
"ier : int\n"
"expn : rank-2 array('D') with bounds (nterms + 1,2 * nterms + 1)";
/* extern void F_FUNC_US(l3dformta_dp,L3DFORMTA_DP)(int*,double*,double*,complex_double*,double*,int*,double*,int*,complex_double*); */
static PyObject *f2py_rout__internal_l3dformta_dp(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*,complex_double*,double*,int*,double*,int*,complex_double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ier = 0;
  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *source = NULL;
  npy_intp source_Dims[2] = {-1, -1};
  const int source_Rank = 2;
  PyArrayObject *capi_source_tmp = NULL;
  int capi_source_intent = 0;
  PyObject *source_capi = Py_None;
  complex_double *dipstr = NULL;
  npy_intp dipstr_Dims[1] = {-1};
  const int dipstr_Rank = 1;
  PyArrayObject *capi_dipstr_tmp = NULL;
  int capi_dipstr_intent = 0;
  PyObject *dipstr_capi = Py_None;
  double *dipvec = NULL;
  npy_intp dipvec_Dims[2] = {-1, -1};
  const int dipvec_Rank = 2;
  PyArrayObject *capi_dipvec_tmp = NULL;
  int capi_dipvec_intent = 0;
  PyObject *dipvec_capi = Py_None;
  int ns = 0;
  PyObject *ns_capi = Py_None;
  double *center = NULL;
  npy_intp center_Dims[1] = {-1};
  const int center_Rank = 1;
  PyArrayObject *capi_center_tmp = NULL;
  int capi_center_intent = 0;
  PyObject *center_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[2] = {-1, -1};
  const int expn_Rank = 2;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
    static char *capi_kwlist[] = {"rscale","source","dipstr","dipvec","center","nterms","ns",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOO|O:_internal.l3dformta_dp",\
        capi_kwlist,&rscale_capi,&source_capi,&dipstr_capi,&dipvec_capi,&center_capi,&nterms_capi,&ns_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.l3dformta_dp() 1st argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable center */
  center_Dims[0]=3;
  capi_center_intent |= F2PY_INTENT_IN;
  capi_center_tmp = array_from_pyobj(NPY_DOUBLE,center_Dims,center_Rank,capi_center_intent,center_capi);
  if (capi_center_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `center' of _internal.l3dformta_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center = (double *)(PyArray_DATA(capi_center_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.l3dformta_dp() 6th argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ier */
  /* Processing variable source */
  source_Dims[0]=3;
  capi_source_intent |= F2PY_INTENT_IN;
  capi_source_tmp = array_from_pyobj(NPY_DOUBLE,source_Dims,source_Rank,capi_source_intent,source_capi);
  if (capi_source_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `source' of _internal.l3dformta_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source = (double *)(PyArray_DATA(capi_source_tmp));

  /* Processing variable ns */
  if (ns_capi == Py_None) ns = shape(source,1); else
    f2py_success = int_from_pyobj(&ns,ns_capi,"_internal.l3dformta_dp() 1st keyword (ns) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(source,1)==ns,"shape(source,1)==ns","1st keyword ns","l3dformta_dp:ns=%d",ns) {
  /* Processing variable expn */
  expn_Dims[0]=nterms + 1,expn_Dims[1]=2 * nterms + 1;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.l3dformta_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

  /* Processing variable dipvec */
  dipvec_Dims[0]=3,dipvec_Dims[1]=ns;
  capi_dipvec_intent |= F2PY_INTENT_IN;
  capi_dipvec_tmp = array_from_pyobj(NPY_DOUBLE,dipvec_Dims,dipvec_Rank,capi_dipvec_intent,dipvec_capi);
  if (capi_dipvec_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `dipvec' of _internal.l3dformta_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipvec = (double *)(PyArray_DATA(capi_dipvec_tmp));

  /* Processing variable dipstr */
  dipstr_Dims[0]=ns;
  capi_dipstr_intent |= F2PY_INTENT_IN;
  capi_dipstr_tmp = array_from_pyobj(NPY_CDOUBLE,dipstr_Dims,dipstr_Rank,capi_dipstr_intent,dipstr_capi);
  if (capi_dipstr_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `dipstr' of _internal.l3dformta_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr = (complex_double *)(PyArray_DATA(capi_dipstr_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ier,&rscale,source,dipstr,dipvec,&ns,center,&nterms,expn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("iN",ier,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_dipstr_tmp!=dipstr_capi) {
    Py_XDECREF(capi_dipstr_tmp); }
  }  /*if (capi_dipstr_tmp == NULL) ... else of dipstr*/
  /* End of cleaning variable dipstr */
  if((PyObject *)capi_dipvec_tmp!=dipvec_capi) {
    Py_XDECREF(capi_dipvec_tmp); }
  }  /*if (capi_dipvec_tmp == NULL) ... else of dipvec*/
  /* End of cleaning variable dipvec */
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  } /*CHECKSCALAR(shape(source,1)==ns)*/
  } /*if (f2py_success) of ns*/
  /* End of cleaning variable ns */
  if((PyObject *)capi_source_tmp!=source_capi) {
    Py_XDECREF(capi_source_tmp); }
  }  /*if (capi_source_tmp == NULL) ... else of source*/
  /* End of cleaning variable source */
  /* End of cleaning variable ier */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_center_tmp!=center_capi) {
    Py_XDECREF(capi_center_tmp); }
  }  /*if (capi_center_tmp == NULL) ... else of center*/
  /* End of cleaning variable center */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/**************************** end of l3dformta_dp ****************************/

/******************************** h3dformmp_dp ********************************/
static char doc_f2py_rout__internal_h3dformmp_dp[] = "\
ier,expn = h3dformmp_dp(zk,rscale,source,dipstr,dipvec,center,nterms,[ns])\n\nWrapper for ``h3dformmp_dp``.\
\n\nParameters\n----------\n"
"zk : input complex\n"
"rscale : input float\n"
"source : input rank-2 array('d') with bounds (3,ns)\n"
"dipstr : input rank-1 array('D') with bounds (ns)\n"
"dipvec : input rank-2 array('d') with bounds (3,ns)\n"
"center : input rank-1 array('d') with bounds (3)\n"
"nterms : input int\n"
"\nOther Parameters\n----------------\n"
"ns : input int, optional\n    Default: shape(source,1)\n"
"\nReturns\n-------\n"
"ier : int\n"
"expn : rank-2 array('D') with bounds (nterms + 1,2 * nterms + 1)";
/* extern void F_FUNC_US(h3dformmp_dp,H3DFORMMP_DP)(int*,complex_double*,double*,double*,complex_double*,double*,int*,double*,int*,complex_double*); */
static PyObject *f2py_rout__internal_h3dformmp_dp(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,complex_double*,double*,double*,complex_double*,double*,int*,double*,int*,complex_double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ier = 0;
  complex_double zk;
  PyObject *zk_capi = Py_None;
  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *source = NULL;
  npy_intp source_Dims[2] = {-1, -1};
  const int source_Rank = 2;
  PyArrayObject *capi_source_tmp = NULL;
  int capi_source_intent = 0;
  PyObject *source_capi = Py_None;
  complex_double *dipstr = NULL;
  npy_intp dipstr_Dims[1] = {-1};
  const int dipstr_Rank = 1;
  PyArrayObject *capi_dipstr_tmp = NULL;
  int capi_dipstr_intent = 0;
  PyObject *dipstr_capi = Py_None;
  double *dipvec = NULL;
  npy_intp dipvec_Dims[2] = {-1, -1};
  const int dipvec_Rank = 2;
  PyArrayObject *capi_dipvec_tmp = NULL;
  int capi_dipvec_intent = 0;
  PyObject *dipvec_capi = Py_None;
  int ns = 0;
  PyObject *ns_capi = Py_None;
  double *center = NULL;
  npy_intp center_Dims[1] = {-1};
  const int center_Rank = 1;
  PyArrayObject *capi_center_tmp = NULL;
  int capi_center_intent = 0;
  PyObject *center_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[2] = {-1, -1};
  const int expn_Rank = 2;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
    static char *capi_kwlist[] = {"zk","rscale","source","dipstr","dipvec","center","nterms","ns",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOO|O:_internal.h3dformmp_dp",\
        capi_kwlist,&zk_capi,&rscale_capi,&source_capi,&dipstr_capi,&dipvec_capi,&center_capi,&nterms_capi,&ns_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.h3dformmp_dp() 2nd argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable center */
  center_Dims[0]=3;
  capi_center_intent |= F2PY_INTENT_IN;
  capi_center_tmp = array_from_pyobj(NPY_DOUBLE,center_Dims,center_Rank,capi_center_intent,center_capi);
  if (capi_center_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `center' of _internal.h3dformmp_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center = (double *)(PyArray_DATA(capi_center_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.h3dformmp_dp() 7th argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ier */
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.h3dformmp_dp() 1st argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable source */
  source_Dims[0]=3;
  capi_source_intent |= F2PY_INTENT_IN;
  capi_source_tmp = array_from_pyobj(NPY_DOUBLE,source_Dims,source_Rank,capi_source_intent,source_capi);
  if (capi_source_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `source' of _internal.h3dformmp_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source = (double *)(PyArray_DATA(capi_source_tmp));

  /* Processing variable ns */
  if (ns_capi == Py_None) ns = shape(source,1); else
    f2py_success = int_from_pyobj(&ns,ns_capi,"_internal.h3dformmp_dp() 1st keyword (ns) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(source,1)==ns,"shape(source,1)==ns","1st keyword ns","h3dformmp_dp:ns=%d",ns) {
  /* Processing variable expn */
  expn_Dims[0]=nterms + 1,expn_Dims[1]=2 * nterms + 1;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.h3dformmp_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

  /* Processing variable dipvec */
  dipvec_Dims[0]=3,dipvec_Dims[1]=ns;
  capi_dipvec_intent |= F2PY_INTENT_IN;
  capi_dipvec_tmp = array_from_pyobj(NPY_DOUBLE,dipvec_Dims,dipvec_Rank,capi_dipvec_intent,dipvec_capi);
  if (capi_dipvec_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `dipvec' of _internal.h3dformmp_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipvec = (double *)(PyArray_DATA(capi_dipvec_tmp));

  /* Processing variable dipstr */
  dipstr_Dims[0]=ns;
  capi_dipstr_intent |= F2PY_INTENT_IN;
  capi_dipstr_tmp = array_from_pyobj(NPY_CDOUBLE,dipstr_Dims,dipstr_Rank,capi_dipstr_intent,dipstr_capi);
  if (capi_dipstr_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `dipstr' of _internal.h3dformmp_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr = (complex_double *)(PyArray_DATA(capi_dipstr_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ier,&zk,&rscale,source,dipstr,dipvec,&ns,center,&nterms,expn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("iN",ier,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_dipstr_tmp!=dipstr_capi) {
    Py_XDECREF(capi_dipstr_tmp); }
  }  /*if (capi_dipstr_tmp == NULL) ... else of dipstr*/
  /* End of cleaning variable dipstr */
  if((PyObject *)capi_dipvec_tmp!=dipvec_capi) {
    Py_XDECREF(capi_dipvec_tmp); }
  }  /*if (capi_dipvec_tmp == NULL) ... else of dipvec*/
  /* End of cleaning variable dipvec */
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  } /*CHECKSCALAR(shape(source,1)==ns)*/
  } /*if (f2py_success) of ns*/
  /* End of cleaning variable ns */
  if((PyObject *)capi_source_tmp!=source_capi) {
    Py_XDECREF(capi_source_tmp); }
  }  /*if (capi_source_tmp == NULL) ... else of source*/
  /* End of cleaning variable source */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
  /* End of cleaning variable ier */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_center_tmp!=center_capi) {
    Py_XDECREF(capi_center_tmp); }
  }  /*if (capi_center_tmp == NULL) ... else of center*/
  /* End of cleaning variable center */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/**************************** end of h3dformmp_dp ****************************/

/******************************** h3dformta_dp ********************************/
static char doc_f2py_rout__internal_h3dformta_dp[] = "\
ier,expn = h3dformta_dp(zk,rscale,source,dipstr,dipvec,center,nterms,[ns])\n\nWrapper for ``h3dformta_dp``.\
\n\nParameters\n----------\n"
"zk : input complex\n"
"rscale : input float\n"
"source : input rank-2 array('d') with bounds (3,ns)\n"
"dipstr : input rank-1 array('D') with bounds (ns)\n"
"dipvec : input rank-2 array('d') with bounds (3,ns)\n"
"center : input rank-1 array('d') with bounds (3)\n"
"nterms : input int\n"
"\nOther Parameters\n----------------\n"
"ns : input int, optional\n    Default: shape(source,1)\n"
"\nReturns\n-------\n"
"ier : int\n"
"expn : rank-2 array('D') with bounds (nterms + 1,2 * nterms + 1)";
/* extern void F_FUNC_US(h3dformta_dp,H3DFORMTA_DP)(int*,complex_double*,double*,double*,complex_double*,double*,int*,double*,int*,complex_double*); */
static PyObject *f2py_rout__internal_h3dformta_dp(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,complex_double*,double*,double*,complex_double*,double*,int*,double*,int*,complex_double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ier = 0;
  complex_double zk;
  PyObject *zk_capi = Py_None;
  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *source = NULL;
  npy_intp source_Dims[2] = {-1, -1};
  const int source_Rank = 2;
  PyArrayObject *capi_source_tmp = NULL;
  int capi_source_intent = 0;
  PyObject *source_capi = Py_None;
  complex_double *dipstr = NULL;
  npy_intp dipstr_Dims[1] = {-1};
  const int dipstr_Rank = 1;
  PyArrayObject *capi_dipstr_tmp = NULL;
  int capi_dipstr_intent = 0;
  PyObject *dipstr_capi = Py_None;
  double *dipvec = NULL;
  npy_intp dipvec_Dims[2] = {-1, -1};
  const int dipvec_Rank = 2;
  PyArrayObject *capi_dipvec_tmp = NULL;
  int capi_dipvec_intent = 0;
  PyObject *dipvec_capi = Py_None;
  int ns = 0;
  PyObject *ns_capi = Py_None;
  double *center = NULL;
  npy_intp center_Dims[1] = {-1};
  const int center_Rank = 1;
  PyArrayObject *capi_center_tmp = NULL;
  int capi_center_intent = 0;
  PyObject *center_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[2] = {-1, -1};
  const int expn_Rank = 2;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
    static char *capi_kwlist[] = {"zk","rscale","source","dipstr","dipvec","center","nterms","ns",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOO|O:_internal.h3dformta_dp",\
        capi_kwlist,&zk_capi,&rscale_capi,&source_capi,&dipstr_capi,&dipvec_capi,&center_capi,&nterms_capi,&ns_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.h3dformta_dp() 2nd argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable center */
  center_Dims[0]=3;
  capi_center_intent |= F2PY_INTENT_IN;
  capi_center_tmp = array_from_pyobj(NPY_DOUBLE,center_Dims,center_Rank,capi_center_intent,center_capi);
  if (capi_center_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `center' of _internal.h3dformta_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center = (double *)(PyArray_DATA(capi_center_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.h3dformta_dp() 7th argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ier */
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.h3dformta_dp() 1st argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable source */
  source_Dims[0]=3;
  capi_source_intent |= F2PY_INTENT_IN;
  capi_source_tmp = array_from_pyobj(NPY_DOUBLE,source_Dims,source_Rank,capi_source_intent,source_capi);
  if (capi_source_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `source' of _internal.h3dformta_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source = (double *)(PyArray_DATA(capi_source_tmp));

  /* Processing variable ns */
  if (ns_capi == Py_None) ns = shape(source,1); else
    f2py_success = int_from_pyobj(&ns,ns_capi,"_internal.h3dformta_dp() 1st keyword (ns) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(source,1)==ns,"shape(source,1)==ns","1st keyword ns","h3dformta_dp:ns=%d",ns) {
  /* Processing variable expn */
  expn_Dims[0]=nterms + 1,expn_Dims[1]=2 * nterms + 1;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.h3dformta_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

  /* Processing variable dipvec */
  dipvec_Dims[0]=3,dipvec_Dims[1]=ns;
  capi_dipvec_intent |= F2PY_INTENT_IN;
  capi_dipvec_tmp = array_from_pyobj(NPY_DOUBLE,dipvec_Dims,dipvec_Rank,capi_dipvec_intent,dipvec_capi);
  if (capi_dipvec_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `dipvec' of _internal.h3dformta_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipvec = (double *)(PyArray_DATA(capi_dipvec_tmp));

  /* Processing variable dipstr */
  dipstr_Dims[0]=ns;
  capi_dipstr_intent |= F2PY_INTENT_IN;
  capi_dipstr_tmp = array_from_pyobj(NPY_CDOUBLE,dipstr_Dims,dipstr_Rank,capi_dipstr_intent,dipstr_capi);
  if (capi_dipstr_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `dipstr' of _internal.h3dformta_dp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr = (complex_double *)(PyArray_DATA(capi_dipstr_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ier,&zk,&rscale,source,dipstr,dipvec,&ns,center,&nterms,expn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("iN",ier,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_dipstr_tmp!=dipstr_capi) {
    Py_XDECREF(capi_dipstr_tmp); }
  }  /*if (capi_dipstr_tmp == NULL) ... else of dipstr*/
  /* End of cleaning variable dipstr */
  if((PyObject *)capi_dipvec_tmp!=dipvec_capi) {
    Py_XDECREF(capi_dipvec_tmp); }
  }  /*if (capi_dipvec_tmp == NULL) ... else of dipvec*/
  /* End of cleaning variable dipvec */
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  } /*CHECKSCALAR(shape(source,1)==ns)*/
  } /*if (f2py_success) of ns*/
  /* End of cleaning variable ns */
  if((PyObject *)capi_source_tmp!=source_capi) {
    Py_XDECREF(capi_source_tmp); }
  }  /*if (capi_source_tmp == NULL) ... else of source*/
  /* End of cleaning variable source */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
  /* End of cleaning variable ier */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_center_tmp!=center_capi) {
    Py_XDECREF(capi_center_tmp); }
  }  /*if (capi_center_tmp == NULL) ... else of center*/
  /* End of cleaning variable center */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/**************************** end of h3dformta_dp ****************************/

/******************************* lfmm2dparttarg *******************************/
static char doc_f2py_rout__internal_lfmm2dparttarg[] = "\
ier,pot,fld,hess,pottarg,fldtarg,hesstarg = lfmm2dparttarg(iprec,source,ifcharge,charge,ifdipole,dipstr,dipvec,ifpot,iffld,ifhess,ntarget,target,ifpottarg,pottarg,iffldtarg,fldtarg,ifhesstarg,hesstarg,[nsource])\n\nWrapper for ``lfmm2dparttarg``.\
\n\nParameters\n----------\n"
"iprec : input int\n"
"source : input rank-2 array('d') with bounds (2,nsource)\n"
"ifcharge : input int\n"
"charge : input rank-1 array('D') with bounds (nsource)\n"
"ifdipole : input int\n"
"dipstr : input rank-1 array('D') with bounds (nsource)\n"
"dipvec : input rank-2 array('d') with bounds (2,nsource)\n"
"ifpot : input int\n"
"iffld : input int\n"
"ifhess : input int\n"
"ntarget : input int, optional\n    Default: shape(target,1)\n"
"target : input rank-2 array('d') with bounds (2,ntarget)\n"
"ifpottarg : input int\n"
"pottarg : input rank-1 array('D') with bounds (ntarget)\n"
"iffldtarg : input int\n"
"fldtarg : input rank-2 array('D') with bounds (2,ntarget)\n"
"ifhesstarg : input int\n"
"hesstarg : input rank-2 array('D') with bounds (3,ntarget)\n"
"\nOther Parameters\n----------------\n"
"nsource : input int, optional\n    Default: shape(source,1)\n"
"\nReturns\n-------\n"
"ier : int\n"
"pot : rank-1 array('D') with bounds (nsource)\n"
"fld : rank-2 array('D') with bounds (2,nsource)\n"
"hess : rank-2 array('D') with bounds (3,nsource)\n"
"pottarg : rank-1 array('D') with bounds (ntarget)\n"
"fldtarg : rank-2 array('D') with bounds (2,ntarget)\n"
"hesstarg : rank-2 array('D') with bounds (3,ntarget)";
/* extern void F_FUNC(lfmm2dparttarg,LFMM2DPARTTARG)(int*,int*,int*,double*,int*,complex_double*,int*,complex_double*,double*,int*,complex_double*,int*,complex_double*,int*,complex_double*,int*,double*,int*,complex_double*,int*,complex_double*,int*,complex_double*); */
static PyObject *f2py_rout__internal_lfmm2dparttarg(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,int*,double*,int*,complex_double*,int*,complex_double*,double*,int*,complex_double*,int*,complex_double*,int*,complex_double*,int*,double*,int*,complex_double*,int*,complex_double*,int*,complex_double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ier = 0;
  int iprec = 0;
  PyObject *iprec_capi = Py_None;
  int nsource = 0;
  PyObject *nsource_capi = Py_None;
  double *source = NULL;
  npy_intp source_Dims[2] = {-1, -1};
  const int source_Rank = 2;
  PyArrayObject *capi_source_tmp = NULL;
  int capi_source_intent = 0;
  PyObject *source_capi = Py_None;
  int ifcharge = 0;
  PyObject *ifcharge_capi = Py_None;
  complex_double *charge = NULL;
  npy_intp charge_Dims[1] = {-1};
  const int charge_Rank = 1;
  PyArrayObject *capi_charge_tmp = NULL;
  int capi_charge_intent = 0;
  PyObject *charge_capi = Py_None;
  int ifdipole = 0;
  PyObject *ifdipole_capi = Py_None;
  complex_double *dipstr = NULL;
  npy_intp dipstr_Dims[1] = {-1};
  const int dipstr_Rank = 1;
  PyArrayObject *capi_dipstr_tmp = NULL;
  int capi_dipstr_intent = 0;
  PyObject *dipstr_capi = Py_None;
  double *dipvec = NULL;
  npy_intp dipvec_Dims[2] = {-1, -1};
  const int dipvec_Rank = 2;
  PyArrayObject *capi_dipvec_tmp = NULL;
  int capi_dipvec_intent = 0;
  PyObject *dipvec_capi = Py_None;
  int ifpot = 0;
  PyObject *ifpot_capi = Py_None;
  complex_double *pot = NULL;
  npy_intp pot_Dims[1] = {-1};
  const int pot_Rank = 1;
  PyArrayObject *capi_pot_tmp = NULL;
  int capi_pot_intent = 0;
  int iffld = 0;
  PyObject *iffld_capi = Py_None;
  complex_double *fld = NULL;
  npy_intp fld_Dims[2] = {-1, -1};
  const int fld_Rank = 2;
  PyArrayObject *capi_fld_tmp = NULL;
  int capi_fld_intent = 0;
  int ifhess = 0;
  PyObject *ifhess_capi = Py_None;
  complex_double *hess = NULL;
  npy_intp hess_Dims[2] = {-1, -1};
  const int hess_Rank = 2;
  PyArrayObject *capi_hess_tmp = NULL;
  int capi_hess_intent = 0;
  int ntarget = 0;
  PyObject *ntarget_capi = Py_None;
  double *target = NULL;
  npy_intp target_Dims[2] = {-1, -1};
  const int target_Rank = 2;
  PyArrayObject *capi_target_tmp = NULL;
  int capi_target_intent = 0;
  PyObject *target_capi = Py_None;
  int ifpottarg = 0;
  PyObject *ifpottarg_capi = Py_None;
  complex_double *pottarg = NULL;
  npy_intp pottarg_Dims[1] = {-1};
  const int pottarg_Rank = 1;
  PyArrayObject *capi_pottarg_tmp = NULL;
  int capi_pottarg_intent = 0;
  PyObject *pottarg_capi = Py_None;
  int iffldtarg = 0;
  PyObject *iffldtarg_capi = Py_None;
  complex_double *fldtarg = NULL;
  npy_intp fldtarg_Dims[2] = {-1, -1};
  const int fldtarg_Rank = 2;
  PyArrayObject *capi_fldtarg_tmp = NULL;
  int capi_fldtarg_intent = 0;
  PyObject *fldtarg_capi = Py_None;
  int ifhesstarg = 0;
  PyObject *ifhesstarg_capi = Py_None;
  complex_double *hesstarg = NULL;
  npy_intp hesstarg_Dims[2] = {-1, -1};
  const int hesstarg_Rank = 2;
  PyArrayObject *capi_hesstarg_tmp = NULL;
  int capi_hesstarg_intent = 0;
  PyObject *hesstarg_capi = Py_None;
    static char *capi_kwlist[] = {"iprec","source","ifcharge","charge","ifdipole","dipstr","dipvec","ifpot","iffld","ifhess","ntarget","target","ifpottarg","pottarg","iffldtarg","fldtarg","ifhesstarg","hesstarg","nsource",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOOOOOOOOOO|O:_internal.lfmm2dparttarg",\
        capi_kwlist,&iprec_capi,&source_capi,&ifcharge_capi,&charge_capi,&ifdipole_capi,&dipstr_capi,&dipvec_capi,&ifpot_capi,&iffld_capi,&ifhess_capi,&ntarget_capi,&target_capi,&ifpottarg_capi,&pottarg_capi,&iffldtarg_capi,&fldtarg_capi,&ifhesstarg_capi,&hesstarg_capi,&nsource_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable ier */
  /* Processing variable iprec */
    f2py_success = int_from_pyobj(&iprec,iprec_capi,"_internal.lfmm2dparttarg() 1st argument (iprec) can't be converted to int");
  if (f2py_success) {
  /* Processing variable source */
  source_Dims[0]=2;
  capi_source_intent |= F2PY_INTENT_IN;
  capi_source_tmp = array_from_pyobj(NPY_DOUBLE,source_Dims,source_Rank,capi_source_intent,source_capi);
  if (capi_source_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `source' of _internal.lfmm2dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source = (double *)(PyArray_DATA(capi_source_tmp));

  /* Processing variable ifcharge */
    f2py_success = int_from_pyobj(&ifcharge,ifcharge_capi,"_internal.lfmm2dparttarg() 3rd argument (ifcharge) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ifdipole */
    f2py_success = int_from_pyobj(&ifdipole,ifdipole_capi,"_internal.lfmm2dparttarg() 5th argument (ifdipole) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ifpot */
    f2py_success = int_from_pyobj(&ifpot,ifpot_capi,"_internal.lfmm2dparttarg() 8th argument (ifpot) can't be converted to int");
  if (f2py_success) {
  /* Processing variable iffld */
    f2py_success = int_from_pyobj(&iffld,iffld_capi,"_internal.lfmm2dparttarg() 9th argument (iffld) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ifhess */
    f2py_success = int_from_pyobj(&ifhess,ifhess_capi,"_internal.lfmm2dparttarg() 10th argument (ifhess) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ifpottarg */
    f2py_success = int_from_pyobj(&ifpottarg,ifpottarg_capi,"_internal.lfmm2dparttarg() 13rd argument (ifpottarg) can't be converted to int");
  if (f2py_success) {
  /* Processing variable iffldtarg */
    f2py_success = int_from_pyobj(&iffldtarg,iffldtarg_capi,"_internal.lfmm2dparttarg() 15th argument (iffldtarg) can't be converted to int");
  if (f2py_success) {
  /* Processing variable target */
  target_Dims[0]=2;
  capi_target_intent |= F2PY_INTENT_IN;
  capi_target_tmp = array_from_pyobj(NPY_DOUBLE,target_Dims,target_Rank,capi_target_intent,target_capi);
  if (capi_target_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 12nd argument `target' of _internal.lfmm2dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    target = (double *)(PyArray_DATA(capi_target_tmp));

  /* Processing variable ifhesstarg */
    f2py_success = int_from_pyobj(&ifhesstarg,ifhesstarg_capi,"_internal.lfmm2dparttarg() 17th argument (ifhesstarg) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nsource */
  if (nsource_capi == Py_None) nsource = shape(source,1); else
    f2py_success = int_from_pyobj(&nsource,nsource_capi,"_internal.lfmm2dparttarg() 1st keyword (nsource) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(source,1)==nsource,"shape(source,1)==nsource","1st keyword nsource","lfmm2dparttarg:nsource=%d",nsource) {
  /* Processing variable charge */
  charge_Dims[0]=nsource;
  capi_charge_intent |= F2PY_INTENT_IN;
  capi_charge_tmp = array_from_pyobj(NPY_CDOUBLE,charge_Dims,charge_Rank,capi_charge_intent,charge_capi);
  if (capi_charge_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `charge' of _internal.lfmm2dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge = (complex_double *)(PyArray_DATA(capi_charge_tmp));

  /* Processing variable dipstr */
  dipstr_Dims[0]=nsource;
  capi_dipstr_intent |= F2PY_INTENT_IN;
  capi_dipstr_tmp = array_from_pyobj(NPY_CDOUBLE,dipstr_Dims,dipstr_Rank,capi_dipstr_intent,dipstr_capi);
  if (capi_dipstr_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `dipstr' of _internal.lfmm2dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr = (complex_double *)(PyArray_DATA(capi_dipstr_tmp));

  /* Processing variable dipvec */
  dipvec_Dims[0]=2,dipvec_Dims[1]=nsource;
  capi_dipvec_intent |= F2PY_INTENT_IN;
  capi_dipvec_tmp = array_from_pyobj(NPY_DOUBLE,dipvec_Dims,dipvec_Rank,capi_dipvec_intent,dipvec_capi);
  if (capi_dipvec_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 7th argument `dipvec' of _internal.lfmm2dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipvec = (double *)(PyArray_DATA(capi_dipvec_tmp));

  /* Processing variable pot */
  pot_Dims[0]=nsource;
  capi_pot_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_pot_tmp = array_from_pyobj(NPY_CDOUBLE,pot_Dims,pot_Rank,capi_pot_intent,Py_None);
  if (capi_pot_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `pot' of _internal.lfmm2dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    pot = (complex_double *)(PyArray_DATA(capi_pot_tmp));

  /* Processing variable fld */
  fld_Dims[0]=2,fld_Dims[1]=nsource;
  capi_fld_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_fld_tmp = array_from_pyobj(NPY_CDOUBLE,fld_Dims,fld_Rank,capi_fld_intent,Py_None);
  if (capi_fld_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `fld' of _internal.lfmm2dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    fld = (complex_double *)(PyArray_DATA(capi_fld_tmp));

  /* Processing variable hess */
  hess_Dims[0]=3,hess_Dims[1]=nsource;
  capi_hess_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_hess_tmp = array_from_pyobj(NPY_CDOUBLE,hess_Dims,hess_Rank,capi_hess_intent,Py_None);
  if (capi_hess_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `hess' of _internal.lfmm2dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    hess = (complex_double *)(PyArray_DATA(capi_hess_tmp));

  /* Processing variable ntarget */
  if (ntarget_capi == Py_None) ntarget = shape(target,1); else
    f2py_success = int_from_pyobj(&ntarget,ntarget_capi,"_internal.lfmm2dparttarg() 11st argument (ntarget) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(1,"1","11st argument ntarget","lfmm2dparttarg:ntarget=%d",ntarget) {
  /* Processing variable pottarg */
  pottarg_Dims[0]=ntarget;
  capi_pottarg_intent |= F2PY_INTENT_IN|F2PY_INTENT_OUT;
  capi_pottarg_tmp = array_from_pyobj(NPY_CDOUBLE,pottarg_Dims,pottarg_Rank,capi_pottarg_intent,pottarg_capi);
  if (capi_pottarg_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 14th argument `pottarg' of _internal.lfmm2dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    pottarg = (complex_double *)(PyArray_DATA(capi_pottarg_tmp));

  /* Processing variable fldtarg */
  fldtarg_Dims[0]=2,fldtarg_Dims[1]=ntarget;
  capi_fldtarg_intent |= F2PY_INTENT_IN|F2PY_INTENT_OUT;
  capi_fldtarg_tmp = array_from_pyobj(NPY_CDOUBLE,fldtarg_Dims,fldtarg_Rank,capi_fldtarg_intent,fldtarg_capi);
  if (capi_fldtarg_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 16th argument `fldtarg' of _internal.lfmm2dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    fldtarg = (complex_double *)(PyArray_DATA(capi_fldtarg_tmp));

  /* Processing variable hesstarg */
  hesstarg_Dims[0]=3,hesstarg_Dims[1]=ntarget;
  capi_hesstarg_intent |= F2PY_INTENT_IN|F2PY_INTENT_OUT;
  capi_hesstarg_tmp = array_from_pyobj(NPY_CDOUBLE,hesstarg_Dims,hesstarg_Rank,capi_hesstarg_intent,hesstarg_capi);
  if (capi_hesstarg_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 18th argument `hesstarg' of _internal.lfmm2dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    hesstarg = (complex_double *)(PyArray_DATA(capi_hesstarg_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ier,&iprec,&nsource,source,&ifcharge,charge,&ifdipole,dipstr,dipvec,&ifpot,pot,&iffld,fld,&ifhess,hess,&ntarget,target,&ifpottarg,pottarg,&iffldtarg,fldtarg,&ifhesstarg,hesstarg);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("iNNNNNN",ier,capi_pot_tmp,capi_fld_tmp,capi_hess_tmp,capi_pottarg_tmp,capi_fldtarg_tmp,capi_hesstarg_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_hesstarg_tmp == NULL) ... else of hesstarg*/
  /* End of cleaning variable hesstarg */
  }  /*if (capi_fldtarg_tmp == NULL) ... else of fldtarg*/
  /* End of cleaning variable fldtarg */
  }  /*if (capi_pottarg_tmp == NULL) ... else of pottarg*/
  /* End of cleaning variable pottarg */
  } /*CHECKSCALAR(1)*/
  } /*if (f2py_success) of ntarget*/
  /* End of cleaning variable ntarget */
  }  /*if (capi_hess_tmp == NULL) ... else of hess*/
  /* End of cleaning variable hess */
  }  /*if (capi_fld_tmp == NULL) ... else of fld*/
  /* End of cleaning variable fld */
  }  /*if (capi_pot_tmp == NULL) ... else of pot*/
  /* End of cleaning variable pot */
  if((PyObject *)capi_dipvec_tmp!=dipvec_capi) {
    Py_XDECREF(capi_dipvec_tmp); }
  }  /*if (capi_dipvec_tmp == NULL) ... else of dipvec*/
  /* End of cleaning variable dipvec */
  if((PyObject *)capi_dipstr_tmp!=dipstr_capi) {
    Py_XDECREF(capi_dipstr_tmp); }
  }  /*if (capi_dipstr_tmp == NULL) ... else of dipstr*/
  /* End of cleaning variable dipstr */
  if((PyObject *)capi_charge_tmp!=charge_capi) {
    Py_XDECREF(capi_charge_tmp); }
  }  /*if (capi_charge_tmp == NULL) ... else of charge*/
  /* End of cleaning variable charge */
  } /*CHECKSCALAR(shape(source,1)==nsource)*/
  } /*if (f2py_success) of nsource*/
  /* End of cleaning variable nsource */
  } /*if (f2py_success) of ifhesstarg*/
  /* End of cleaning variable ifhesstarg */
  if((PyObject *)capi_target_tmp!=target_capi) {
    Py_XDECREF(capi_target_tmp); }
  }  /*if (capi_target_tmp == NULL) ... else of target*/
  /* End of cleaning variable target */
  } /*if (f2py_success) of iffldtarg*/
  /* End of cleaning variable iffldtarg */
  } /*if (f2py_success) of ifpottarg*/
  /* End of cleaning variable ifpottarg */
  } /*if (f2py_success) of ifhess*/
  /* End of cleaning variable ifhess */
  } /*if (f2py_success) of iffld*/
  /* End of cleaning variable iffld */
  } /*if (f2py_success) of ifpot*/
  /* End of cleaning variable ifpot */
  } /*if (f2py_success) of ifdipole*/
  /* End of cleaning variable ifdipole */
  } /*if (f2py_success) of ifcharge*/
  /* End of cleaning variable ifcharge */
  if((PyObject *)capi_source_tmp!=source_capi) {
    Py_XDECREF(capi_source_tmp); }
  }  /*if (capi_source_tmp == NULL) ... else of source*/
  /* End of cleaning variable source */
  } /*if (f2py_success) of iprec*/
  /* End of cleaning variable iprec */
  /* End of cleaning variable ier */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/*************************** end of lfmm2dparttarg ***************************/

/******************************* hfmm2dparttarg *******************************/
static char doc_f2py_rout__internal_hfmm2dparttarg[] = "\
ier,pot,fld,hess,pottarg,fldtarg,hesstarg = hfmm2dparttarg(iprec,zk,source,ifcharge,charge,ifdipole,dipstr,dipvec,ifpot,iffld,ifhess,ntarget,target,ifpottarg,pottarg,iffldtarg,fldtarg,ifhesstarg,hesstarg,[nsource])\n\nWrapper for ``hfmm2dparttarg``.\
\n\nParameters\n----------\n"
"iprec : input int\n"
"zk : input complex\n"
"source : input rank-2 array('d') with bounds (2,nsource)\n"
"ifcharge : input int\n"
"charge : input rank-1 array('D') with bounds (nsource)\n"
"ifdipole : input int\n"
"dipstr : input rank-1 array('D') with bounds (nsource)\n"
"dipvec : input rank-2 array('d') with bounds (2,nsource)\n"
"ifpot : input int\n"
"iffld : input int\n"
"ifhess : input int\n"
"ntarget : input int, optional\n    Default: shape(target,1)\n"
"target : input rank-2 array('d') with bounds (2,ntarget)\n"
"ifpottarg : input int\n"
"pottarg : input rank-1 array('D') with bounds (ntarget)\n"
"iffldtarg : input int\n"
"fldtarg : input rank-2 array('D') with bounds (2,ntarget)\n"
"ifhesstarg : input int\n"
"hesstarg : input rank-2 array('D') with bounds (3,ntarget)\n"
"\nOther Parameters\n----------------\n"
"nsource : input int, optional\n    Default: shape(source,1)\n"
"\nReturns\n-------\n"
"ier : int\n"
"pot : rank-1 array('D') with bounds (nsource)\n"
"fld : rank-2 array('D') with bounds (2,nsource)\n"
"hess : rank-2 array('D') with bounds (3,nsource)\n"
"pottarg : rank-1 array('D') with bounds (ntarget)\n"
"fldtarg : rank-2 array('D') with bounds (2,ntarget)\n"
"hesstarg : rank-2 array('D') with bounds (3,ntarget)";
/* extern void F_FUNC(hfmm2dparttarg,HFMM2DPARTTARG)(int*,int*,complex_double*,int*,double*,int*,complex_double*,int*,complex_double*,double*,int*,complex_double*,int*,complex_double*,int*,complex_double*,int*,double*,int*,complex_double*,int*,complex_double*,int*,complex_double*); */
static PyObject *f2py_rout__internal_hfmm2dparttarg(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,complex_double*,int*,double*,int*,complex_double*,int*,complex_double*,double*,int*,complex_double*,int*,complex_double*,int*,complex_double*,int*,double*,int*,complex_double*,int*,complex_double*,int*,complex_double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ier = 0;
  int iprec = 0;
  PyObject *iprec_capi = Py_None;
  complex_double zk;
  PyObject *zk_capi = Py_None;
  int nsource = 0;
  PyObject *nsource_capi = Py_None;
  double *source = NULL;
  npy_intp source_Dims[2] = {-1, -1};
  const int source_Rank = 2;
  PyArrayObject *capi_source_tmp = NULL;
  int capi_source_intent = 0;
  PyObject *source_capi = Py_None;
  int ifcharge = 0;
  PyObject *ifcharge_capi = Py_None;
  complex_double *charge = NULL;
  npy_intp charge_Dims[1] = {-1};
  const int charge_Rank = 1;
  PyArrayObject *capi_charge_tmp = NULL;
  int capi_charge_intent = 0;
  PyObject *charge_capi = Py_None;
  int ifdipole = 0;
  PyObject *ifdipole_capi = Py_None;
  complex_double *dipstr = NULL;
  npy_intp dipstr_Dims[1] = {-1};
  const int dipstr_Rank = 1;
  PyArrayObject *capi_dipstr_tmp = NULL;
  int capi_dipstr_intent = 0;
  PyObject *dipstr_capi = Py_None;
  double *dipvec = NULL;
  npy_intp dipvec_Dims[2] = {-1, -1};
  const int dipvec_Rank = 2;
  PyArrayObject *capi_dipvec_tmp = NULL;
  int capi_dipvec_intent = 0;
  PyObject *dipvec_capi = Py_None;
  int ifpot = 0;
  PyObject *ifpot_capi = Py_None;
  complex_double *pot = NULL;
  npy_intp pot_Dims[1] = {-1};
  const int pot_Rank = 1;
  PyArrayObject *capi_pot_tmp = NULL;
  int capi_pot_intent = 0;
  int iffld = 0;
  PyObject *iffld_capi = Py_None;
  complex_double *fld = NULL;
  npy_intp fld_Dims[2] = {-1, -1};
  const int fld_Rank = 2;
  PyArrayObject *capi_fld_tmp = NULL;
  int capi_fld_intent = 0;
  int ifhess = 0;
  PyObject *ifhess_capi = Py_None;
  complex_double *hess = NULL;
  npy_intp hess_Dims[2] = {-1, -1};
  const int hess_Rank = 2;
  PyArrayObject *capi_hess_tmp = NULL;
  int capi_hess_intent = 0;
  int ntarget = 0;
  PyObject *ntarget_capi = Py_None;
  double *target = NULL;
  npy_intp target_Dims[2] = {-1, -1};
  const int target_Rank = 2;
  PyArrayObject *capi_target_tmp = NULL;
  int capi_target_intent = 0;
  PyObject *target_capi = Py_None;
  int ifpottarg = 0;
  PyObject *ifpottarg_capi = Py_None;
  complex_double *pottarg = NULL;
  npy_intp pottarg_Dims[1] = {-1};
  const int pottarg_Rank = 1;
  PyArrayObject *capi_pottarg_tmp = NULL;
  int capi_pottarg_intent = 0;
  PyObject *pottarg_capi = Py_None;
  int iffldtarg = 0;
  PyObject *iffldtarg_capi = Py_None;
  complex_double *fldtarg = NULL;
  npy_intp fldtarg_Dims[2] = {-1, -1};
  const int fldtarg_Rank = 2;
  PyArrayObject *capi_fldtarg_tmp = NULL;
  int capi_fldtarg_intent = 0;
  PyObject *fldtarg_capi = Py_None;
  int ifhesstarg = 0;
  PyObject *ifhesstarg_capi = Py_None;
  complex_double *hesstarg = NULL;
  npy_intp hesstarg_Dims[2] = {-1, -1};
  const int hesstarg_Rank = 2;
  PyArrayObject *capi_hesstarg_tmp = NULL;
  int capi_hesstarg_intent = 0;
  PyObject *hesstarg_capi = Py_None;
    static char *capi_kwlist[] = {"iprec","zk","source","ifcharge","charge","ifdipole","dipstr","dipvec","ifpot","iffld","ifhess","ntarget","target","ifpottarg","pottarg","iffldtarg","fldtarg","ifhesstarg","hesstarg","nsource",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOOOOOOOOOOO|O:_internal.hfmm2dparttarg",\
        capi_kwlist,&iprec_capi,&zk_capi,&source_capi,&ifcharge_capi,&charge_capi,&ifdipole_capi,&dipstr_capi,&dipvec_capi,&ifpot_capi,&iffld_capi,&ifhess_capi,&ntarget_capi,&target_capi,&ifpottarg_capi,&pottarg_capi,&iffldtarg_capi,&fldtarg_capi,&ifhesstarg_capi,&hesstarg_capi,&nsource_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable ier */
  /* Processing variable iprec */
    f2py_success = int_from_pyobj(&iprec,iprec_capi,"_internal.hfmm2dparttarg() 1st argument (iprec) can't be converted to int");
  if (f2py_success) {
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.hfmm2dparttarg() 2nd argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable source */
  source_Dims[0]=2;
  capi_source_intent |= F2PY_INTENT_IN;
  capi_source_tmp = array_from_pyobj(NPY_DOUBLE,source_Dims,source_Rank,capi_source_intent,source_capi);
  if (capi_source_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `source' of _internal.hfmm2dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source = (double *)(PyArray_DATA(capi_source_tmp));

  /* Processing variable ifcharge */
    f2py_success = int_from_pyobj(&ifcharge,ifcharge_capi,"_internal.hfmm2dparttarg() 4th argument (ifcharge) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ifdipole */
    f2py_success = int_from_pyobj(&ifdipole,ifdipole_capi,"_internal.hfmm2dparttarg() 6th argument (ifdipole) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ifpot */
    f2py_success = int_from_pyobj(&ifpot,ifpot_capi,"_internal.hfmm2dparttarg() 9th argument (ifpot) can't be converted to int");
  if (f2py_success) {
  /* Processing variable iffld */
    f2py_success = int_from_pyobj(&iffld,iffld_capi,"_internal.hfmm2dparttarg() 10th argument (iffld) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ifhess */
    f2py_success = int_from_pyobj(&ifhess,ifhess_capi,"_internal.hfmm2dparttarg() 11st argument (ifhess) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ifpottarg */
    f2py_success = int_from_pyobj(&ifpottarg,ifpottarg_capi,"_internal.hfmm2dparttarg() 14th argument (ifpottarg) can't be converted to int");
  if (f2py_success) {
  /* Processing variable iffldtarg */
    f2py_success = int_from_pyobj(&iffldtarg,iffldtarg_capi,"_internal.hfmm2dparttarg() 16th argument (iffldtarg) can't be converted to int");
  if (f2py_success) {
  /* Processing variable target */
  target_Dims[0]=2;
  capi_target_intent |= F2PY_INTENT_IN;
  capi_target_tmp = array_from_pyobj(NPY_DOUBLE,target_Dims,target_Rank,capi_target_intent,target_capi);
  if (capi_target_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 13rd argument `target' of _internal.hfmm2dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    target = (double *)(PyArray_DATA(capi_target_tmp));

  /* Processing variable ifhesstarg */
    f2py_success = int_from_pyobj(&ifhesstarg,ifhesstarg_capi,"_internal.hfmm2dparttarg() 18th argument (ifhesstarg) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nsource */
  if (nsource_capi == Py_None) nsource = shape(source,1); else
    f2py_success = int_from_pyobj(&nsource,nsource_capi,"_internal.hfmm2dparttarg() 1st keyword (nsource) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(source,1)==nsource,"shape(source,1)==nsource","1st keyword nsource","hfmm2dparttarg:nsource=%d",nsource) {
  /* Processing variable charge */
  charge_Dims[0]=nsource;
  capi_charge_intent |= F2PY_INTENT_IN;
  capi_charge_tmp = array_from_pyobj(NPY_CDOUBLE,charge_Dims,charge_Rank,capi_charge_intent,charge_capi);
  if (capi_charge_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `charge' of _internal.hfmm2dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge = (complex_double *)(PyArray_DATA(capi_charge_tmp));

  /* Processing variable dipstr */
  dipstr_Dims[0]=nsource;
  capi_dipstr_intent |= F2PY_INTENT_IN;
  capi_dipstr_tmp = array_from_pyobj(NPY_CDOUBLE,dipstr_Dims,dipstr_Rank,capi_dipstr_intent,dipstr_capi);
  if (capi_dipstr_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 7th argument `dipstr' of _internal.hfmm2dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr = (complex_double *)(PyArray_DATA(capi_dipstr_tmp));

  /* Processing variable dipvec */
  dipvec_Dims[0]=2,dipvec_Dims[1]=nsource;
  capi_dipvec_intent |= F2PY_INTENT_IN;
  capi_dipvec_tmp = array_from_pyobj(NPY_DOUBLE,dipvec_Dims,dipvec_Rank,capi_dipvec_intent,dipvec_capi);
  if (capi_dipvec_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 8th argument `dipvec' of _internal.hfmm2dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipvec = (double *)(PyArray_DATA(capi_dipvec_tmp));

  /* Processing variable pot */
  pot_Dims[0]=nsource;
  capi_pot_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_pot_tmp = array_from_pyobj(NPY_CDOUBLE,pot_Dims,pot_Rank,capi_pot_intent,Py_None);
  if (capi_pot_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `pot' of _internal.hfmm2dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    pot = (complex_double *)(PyArray_DATA(capi_pot_tmp));

  /* Processing variable fld */
  fld_Dims[0]=2,fld_Dims[1]=nsource;
  capi_fld_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_fld_tmp = array_from_pyobj(NPY_CDOUBLE,fld_Dims,fld_Rank,capi_fld_intent,Py_None);
  if (capi_fld_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `fld' of _internal.hfmm2dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    fld = (complex_double *)(PyArray_DATA(capi_fld_tmp));

  /* Processing variable hess */
  hess_Dims[0]=3,hess_Dims[1]=nsource;
  capi_hess_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_hess_tmp = array_from_pyobj(NPY_CDOUBLE,hess_Dims,hess_Rank,capi_hess_intent,Py_None);
  if (capi_hess_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `hess' of _internal.hfmm2dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    hess = (complex_double *)(PyArray_DATA(capi_hess_tmp));

  /* Processing variable ntarget */
  if (ntarget_capi == Py_None) ntarget = shape(target,1); else
    f2py_success = int_from_pyobj(&ntarget,ntarget_capi,"_internal.hfmm2dparttarg() 12nd argument (ntarget) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(1,"1","12nd argument ntarget","hfmm2dparttarg:ntarget=%d",ntarget) {
  /* Processing variable pottarg */
  pottarg_Dims[0]=ntarget;
  capi_pottarg_intent |= F2PY_INTENT_IN|F2PY_INTENT_OUT;
  capi_pottarg_tmp = array_from_pyobj(NPY_CDOUBLE,pottarg_Dims,pottarg_Rank,capi_pottarg_intent,pottarg_capi);
  if (capi_pottarg_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 15th argument `pottarg' of _internal.hfmm2dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    pottarg = (complex_double *)(PyArray_DATA(capi_pottarg_tmp));

  /* Processing variable fldtarg */
  fldtarg_Dims[0]=2,fldtarg_Dims[1]=ntarget;
  capi_fldtarg_intent |= F2PY_INTENT_IN|F2PY_INTENT_OUT;
  capi_fldtarg_tmp = array_from_pyobj(NPY_CDOUBLE,fldtarg_Dims,fldtarg_Rank,capi_fldtarg_intent,fldtarg_capi);
  if (capi_fldtarg_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 17th argument `fldtarg' of _internal.hfmm2dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    fldtarg = (complex_double *)(PyArray_DATA(capi_fldtarg_tmp));

  /* Processing variable hesstarg */
  hesstarg_Dims[0]=3,hesstarg_Dims[1]=ntarget;
  capi_hesstarg_intent |= F2PY_INTENT_IN|F2PY_INTENT_OUT;
  capi_hesstarg_tmp = array_from_pyobj(NPY_CDOUBLE,hesstarg_Dims,hesstarg_Rank,capi_hesstarg_intent,hesstarg_capi);
  if (capi_hesstarg_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 19th argument `hesstarg' of _internal.hfmm2dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    hesstarg = (complex_double *)(PyArray_DATA(capi_hesstarg_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ier,&iprec,&zk,&nsource,source,&ifcharge,charge,&ifdipole,dipstr,dipvec,&ifpot,pot,&iffld,fld,&ifhess,hess,&ntarget,target,&ifpottarg,pottarg,&iffldtarg,fldtarg,&ifhesstarg,hesstarg);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("iNNNNNN",ier,capi_pot_tmp,capi_fld_tmp,capi_hess_tmp,capi_pottarg_tmp,capi_fldtarg_tmp,capi_hesstarg_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_hesstarg_tmp == NULL) ... else of hesstarg*/
  /* End of cleaning variable hesstarg */
  }  /*if (capi_fldtarg_tmp == NULL) ... else of fldtarg*/
  /* End of cleaning variable fldtarg */
  }  /*if (capi_pottarg_tmp == NULL) ... else of pottarg*/
  /* End of cleaning variable pottarg */
  } /*CHECKSCALAR(1)*/
  } /*if (f2py_success) of ntarget*/
  /* End of cleaning variable ntarget */
  }  /*if (capi_hess_tmp == NULL) ... else of hess*/
  /* End of cleaning variable hess */
  }  /*if (capi_fld_tmp == NULL) ... else of fld*/
  /* End of cleaning variable fld */
  }  /*if (capi_pot_tmp == NULL) ... else of pot*/
  /* End of cleaning variable pot */
  if((PyObject *)capi_dipvec_tmp!=dipvec_capi) {
    Py_XDECREF(capi_dipvec_tmp); }
  }  /*if (capi_dipvec_tmp == NULL) ... else of dipvec*/
  /* End of cleaning variable dipvec */
  if((PyObject *)capi_dipstr_tmp!=dipstr_capi) {
    Py_XDECREF(capi_dipstr_tmp); }
  }  /*if (capi_dipstr_tmp == NULL) ... else of dipstr*/
  /* End of cleaning variable dipstr */
  if((PyObject *)capi_charge_tmp!=charge_capi) {
    Py_XDECREF(capi_charge_tmp); }
  }  /*if (capi_charge_tmp == NULL) ... else of charge*/
  /* End of cleaning variable charge */
  } /*CHECKSCALAR(shape(source,1)==nsource)*/
  } /*if (f2py_success) of nsource*/
  /* End of cleaning variable nsource */
  } /*if (f2py_success) of ifhesstarg*/
  /* End of cleaning variable ifhesstarg */
  if((PyObject *)capi_target_tmp!=target_capi) {
    Py_XDECREF(capi_target_tmp); }
  }  /*if (capi_target_tmp == NULL) ... else of target*/
  /* End of cleaning variable target */
  } /*if (f2py_success) of iffldtarg*/
  /* End of cleaning variable iffldtarg */
  } /*if (f2py_success) of ifpottarg*/
  /* End of cleaning variable ifpottarg */
  } /*if (f2py_success) of ifhess*/
  /* End of cleaning variable ifhess */
  } /*if (f2py_success) of iffld*/
  /* End of cleaning variable iffld */
  } /*if (f2py_success) of ifpot*/
  /* End of cleaning variable ifpot */
  } /*if (f2py_success) of ifdipole*/
  /* End of cleaning variable ifdipole */
  } /*if (f2py_success) of ifcharge*/
  /* End of cleaning variable ifcharge */
  if((PyObject *)capi_source_tmp!=source_capi) {
    Py_XDECREF(capi_source_tmp); }
  }  /*if (capi_source_tmp == NULL) ... else of source*/
  /* End of cleaning variable source */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
  } /*if (f2py_success) of iprec*/
  /* End of cleaning variable iprec */
  /* End of cleaning variable ier */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/*************************** end of hfmm2dparttarg ***************************/

/******************************* lfmm3dparttarg *******************************/
static char doc_f2py_rout__internal_lfmm3dparttarg[] = "\
ier,pot,fld,pottarg,fldtarg = lfmm3dparttarg(iprec,source,ifcharge,charge,ifdipole,dipstr,dipvec,ifpot,iffld,ntarget,target,ifpottarg,pottarg,iffldtarg,fldtarg,[nsource])\n\nWrapper for ``lfmm3dparttarg``.\
\n\nParameters\n----------\n"
"iprec : input int\n"
"source : input rank-2 array('d') with bounds (3,nsource)\n"
"ifcharge : input int\n"
"charge : input rank-1 array('D') with bounds (nsource)\n"
"ifdipole : input int\n"
"dipstr : input rank-1 array('D') with bounds (nsource)\n"
"dipvec : input rank-2 array('d') with bounds (3,nsource)\n"
"ifpot : input int\n"
"iffld : input int\n"
"ntarget : input int, optional\n    Default: shape(target,1)\n"
"target : input rank-2 array('d') with bounds (3,ntarget)\n"
"ifpottarg : input int\n"
"pottarg : input rank-1 array('D') with bounds (ntarget)\n"
"iffldtarg : input int\n"
"fldtarg : input rank-2 array('D') with bounds (3,ntarget)\n"
"\nOther Parameters\n----------------\n"
"nsource : input int, optional\n    Default: shape(source,1)\n"
"\nReturns\n-------\n"
"ier : int\n"
"pot : rank-1 array('D') with bounds (nsource)\n"
"fld : rank-2 array('D') with bounds (3,nsource)\n"
"pottarg : rank-1 array('D') with bounds (ntarget)\n"
"fldtarg : rank-2 array('D') with bounds (3,ntarget)";
/* extern void F_FUNC(lfmm3dparttarg,LFMM3DPARTTARG)(int*,int*,int*,double*,int*,complex_double*,int*,complex_double*,double*,int*,complex_double*,int*,complex_double*,int*,double*,int*,complex_double*,int*,complex_double*); */
static PyObject *f2py_rout__internal_lfmm3dparttarg(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,int*,double*,int*,complex_double*,int*,complex_double*,double*,int*,complex_double*,int*,complex_double*,int*,double*,int*,complex_double*,int*,complex_double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ier = 0;
  int iprec = 0;
  PyObject *iprec_capi = Py_None;
  int nsource = 0;
  PyObject *nsource_capi = Py_None;
  double *source = NULL;
  npy_intp source_Dims[2] = {-1, -1};
  const int source_Rank = 2;
  PyArrayObject *capi_source_tmp = NULL;
  int capi_source_intent = 0;
  PyObject *source_capi = Py_None;
  int ifcharge = 0;
  PyObject *ifcharge_capi = Py_None;
  complex_double *charge = NULL;
  npy_intp charge_Dims[1] = {-1};
  const int charge_Rank = 1;
  PyArrayObject *capi_charge_tmp = NULL;
  int capi_charge_intent = 0;
  PyObject *charge_capi = Py_None;
  int ifdipole = 0;
  PyObject *ifdipole_capi = Py_None;
  complex_double *dipstr = NULL;
  npy_intp dipstr_Dims[1] = {-1};
  const int dipstr_Rank = 1;
  PyArrayObject *capi_dipstr_tmp = NULL;
  int capi_dipstr_intent = 0;
  PyObject *dipstr_capi = Py_None;
  double *dipvec = NULL;
  npy_intp dipvec_Dims[2] = {-1, -1};
  const int dipvec_Rank = 2;
  PyArrayObject *capi_dipvec_tmp = NULL;
  int capi_dipvec_intent = 0;
  PyObject *dipvec_capi = Py_None;
  int ifpot = 0;
  PyObject *ifpot_capi = Py_None;
  complex_double *pot = NULL;
  npy_intp pot_Dims[1] = {-1};
  const int pot_Rank = 1;
  PyArrayObject *capi_pot_tmp = NULL;
  int capi_pot_intent = 0;
  int iffld = 0;
  PyObject *iffld_capi = Py_None;
  complex_double *fld = NULL;
  npy_intp fld_Dims[2] = {-1, -1};
  const int fld_Rank = 2;
  PyArrayObject *capi_fld_tmp = NULL;
  int capi_fld_intent = 0;
  int ntarget = 0;
  PyObject *ntarget_capi = Py_None;
  double *target = NULL;
  npy_intp target_Dims[2] = {-1, -1};
  const int target_Rank = 2;
  PyArrayObject *capi_target_tmp = NULL;
  int capi_target_intent = 0;
  PyObject *target_capi = Py_None;
  int ifpottarg = 0;
  PyObject *ifpottarg_capi = Py_None;
  complex_double *pottarg = NULL;
  npy_intp pottarg_Dims[1] = {-1};
  const int pottarg_Rank = 1;
  PyArrayObject *capi_pottarg_tmp = NULL;
  int capi_pottarg_intent = 0;
  PyObject *pottarg_capi = Py_None;
  int iffldtarg = 0;
  PyObject *iffldtarg_capi = Py_None;
  complex_double *fldtarg = NULL;
  npy_intp fldtarg_Dims[2] = {-1, -1};
  const int fldtarg_Rank = 2;
  PyArrayObject *capi_fldtarg_tmp = NULL;
  int capi_fldtarg_intent = 0;
  PyObject *fldtarg_capi = Py_None;
    static char *capi_kwlist[] = {"iprec","source","ifcharge","charge","ifdipole","dipstr","dipvec","ifpot","iffld","ntarget","target","ifpottarg","pottarg","iffldtarg","fldtarg","nsource",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOOOOOOO|O:_internal.lfmm3dparttarg",\
        capi_kwlist,&iprec_capi,&source_capi,&ifcharge_capi,&charge_capi,&ifdipole_capi,&dipstr_capi,&dipvec_capi,&ifpot_capi,&iffld_capi,&ntarget_capi,&target_capi,&ifpottarg_capi,&pottarg_capi,&iffldtarg_capi,&fldtarg_capi,&nsource_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable ier */
  /* Processing variable iprec */
    f2py_success = int_from_pyobj(&iprec,iprec_capi,"_internal.lfmm3dparttarg() 1st argument (iprec) can't be converted to int");
  if (f2py_success) {
  /* Processing variable source */
  source_Dims[0]=3;
  capi_source_intent |= F2PY_INTENT_IN;
  capi_source_tmp = array_from_pyobj(NPY_DOUBLE,source_Dims,source_Rank,capi_source_intent,source_capi);
  if (capi_source_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `source' of _internal.lfmm3dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source = (double *)(PyArray_DATA(capi_source_tmp));

  /* Processing variable ifcharge */
    f2py_success = int_from_pyobj(&ifcharge,ifcharge_capi,"_internal.lfmm3dparttarg() 3rd argument (ifcharge) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ifdipole */
    f2py_success = int_from_pyobj(&ifdipole,ifdipole_capi,"_internal.lfmm3dparttarg() 5th argument (ifdipole) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ifpot */
    f2py_success = int_from_pyobj(&ifpot,ifpot_capi,"_internal.lfmm3dparttarg() 8th argument (ifpot) can't be converted to int");
  if (f2py_success) {
  /* Processing variable iffld */
    f2py_success = int_from_pyobj(&iffld,iffld_capi,"_internal.lfmm3dparttarg() 9th argument (iffld) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ifpottarg */
    f2py_success = int_from_pyobj(&ifpottarg,ifpottarg_capi,"_internal.lfmm3dparttarg() 12nd argument (ifpottarg) can't be converted to int");
  if (f2py_success) {
  /* Processing variable iffldtarg */
    f2py_success = int_from_pyobj(&iffldtarg,iffldtarg_capi,"_internal.lfmm3dparttarg() 14th argument (iffldtarg) can't be converted to int");
  if (f2py_success) {
  /* Processing variable target */
  target_Dims[0]=3;
  capi_target_intent |= F2PY_INTENT_IN;
  capi_target_tmp = array_from_pyobj(NPY_DOUBLE,target_Dims,target_Rank,capi_target_intent,target_capi);
  if (capi_target_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 11st argument `target' of _internal.lfmm3dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    target = (double *)(PyArray_DATA(capi_target_tmp));

  /* Processing variable nsource */
  if (nsource_capi == Py_None) nsource = shape(source,1); else
    f2py_success = int_from_pyobj(&nsource,nsource_capi,"_internal.lfmm3dparttarg() 1st keyword (nsource) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(source,1)==nsource,"shape(source,1)==nsource","1st keyword nsource","lfmm3dparttarg:nsource=%d",nsource) {
  /* Processing variable charge */
  charge_Dims[0]=nsource;
  capi_charge_intent |= F2PY_INTENT_IN;
  capi_charge_tmp = array_from_pyobj(NPY_CDOUBLE,charge_Dims,charge_Rank,capi_charge_intent,charge_capi);
  if (capi_charge_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `charge' of _internal.lfmm3dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge = (complex_double *)(PyArray_DATA(capi_charge_tmp));

  /* Processing variable dipstr */
  dipstr_Dims[0]=nsource;
  capi_dipstr_intent |= F2PY_INTENT_IN;
  capi_dipstr_tmp = array_from_pyobj(NPY_CDOUBLE,dipstr_Dims,dipstr_Rank,capi_dipstr_intent,dipstr_capi);
  if (capi_dipstr_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `dipstr' of _internal.lfmm3dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr = (complex_double *)(PyArray_DATA(capi_dipstr_tmp));

  /* Processing variable dipvec */
  dipvec_Dims[0]=3,dipvec_Dims[1]=nsource;
  capi_dipvec_intent |= F2PY_INTENT_IN;
  capi_dipvec_tmp = array_from_pyobj(NPY_DOUBLE,dipvec_Dims,dipvec_Rank,capi_dipvec_intent,dipvec_capi);
  if (capi_dipvec_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 7th argument `dipvec' of _internal.lfmm3dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipvec = (double *)(PyArray_DATA(capi_dipvec_tmp));

  /* Processing variable pot */
  pot_Dims[0]=nsource;
  capi_pot_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_pot_tmp = array_from_pyobj(NPY_CDOUBLE,pot_Dims,pot_Rank,capi_pot_intent,Py_None);
  if (capi_pot_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `pot' of _internal.lfmm3dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    pot = (complex_double *)(PyArray_DATA(capi_pot_tmp));

  /* Processing variable fld */
  fld_Dims[0]=3,fld_Dims[1]=nsource;
  capi_fld_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_fld_tmp = array_from_pyobj(NPY_CDOUBLE,fld_Dims,fld_Rank,capi_fld_intent,Py_None);
  if (capi_fld_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `fld' of _internal.lfmm3dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    fld = (complex_double *)(PyArray_DATA(capi_fld_tmp));

  /* Processing variable ntarget */
  if (ntarget_capi == Py_None) ntarget = shape(target,1); else
    f2py_success = int_from_pyobj(&ntarget,ntarget_capi,"_internal.lfmm3dparttarg() 10th argument (ntarget) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(1,"1","10th argument ntarget","lfmm3dparttarg:ntarget=%d",ntarget) {
  /* Processing variable pottarg */
  pottarg_Dims[0]=ntarget;
  capi_pottarg_intent |= F2PY_INTENT_IN|F2PY_INTENT_OUT;
  capi_pottarg_tmp = array_from_pyobj(NPY_CDOUBLE,pottarg_Dims,pottarg_Rank,capi_pottarg_intent,pottarg_capi);
  if (capi_pottarg_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 13rd argument `pottarg' of _internal.lfmm3dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    pottarg = (complex_double *)(PyArray_DATA(capi_pottarg_tmp));

  /* Processing variable fldtarg */
  fldtarg_Dims[0]=3,fldtarg_Dims[1]=ntarget;
  capi_fldtarg_intent |= F2PY_INTENT_IN|F2PY_INTENT_OUT;
  capi_fldtarg_tmp = array_from_pyobj(NPY_CDOUBLE,fldtarg_Dims,fldtarg_Rank,capi_fldtarg_intent,fldtarg_capi);
  if (capi_fldtarg_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 15th argument `fldtarg' of _internal.lfmm3dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    fldtarg = (complex_double *)(PyArray_DATA(capi_fldtarg_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ier,&iprec,&nsource,source,&ifcharge,charge,&ifdipole,dipstr,dipvec,&ifpot,pot,&iffld,fld,&ntarget,target,&ifpottarg,pottarg,&iffldtarg,fldtarg);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("iNNNN",ier,capi_pot_tmp,capi_fld_tmp,capi_pottarg_tmp,capi_fldtarg_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_fldtarg_tmp == NULL) ... else of fldtarg*/
  /* End of cleaning variable fldtarg */
  }  /*if (capi_pottarg_tmp == NULL) ... else of pottarg*/
  /* End of cleaning variable pottarg */
  } /*CHECKSCALAR(1)*/
  } /*if (f2py_success) of ntarget*/
  /* End of cleaning variable ntarget */
  }  /*if (capi_fld_tmp == NULL) ... else of fld*/
  /* End of cleaning variable fld */
  }  /*if (capi_pot_tmp == NULL) ... else of pot*/
  /* End of cleaning variable pot */
  if((PyObject *)capi_dipvec_tmp!=dipvec_capi) {
    Py_XDECREF(capi_dipvec_tmp); }
  }  /*if (capi_dipvec_tmp == NULL) ... else of dipvec*/
  /* End of cleaning variable dipvec */
  if((PyObject *)capi_dipstr_tmp!=dipstr_capi) {
    Py_XDECREF(capi_dipstr_tmp); }
  }  /*if (capi_dipstr_tmp == NULL) ... else of dipstr*/
  /* End of cleaning variable dipstr */
  if((PyObject *)capi_charge_tmp!=charge_capi) {
    Py_XDECREF(capi_charge_tmp); }
  }  /*if (capi_charge_tmp == NULL) ... else of charge*/
  /* End of cleaning variable charge */
  } /*CHECKSCALAR(shape(source,1)==nsource)*/
  } /*if (f2py_success) of nsource*/
  /* End of cleaning variable nsource */
  if((PyObject *)capi_target_tmp!=target_capi) {
    Py_XDECREF(capi_target_tmp); }
  }  /*if (capi_target_tmp == NULL) ... else of target*/
  /* End of cleaning variable target */
  } /*if (f2py_success) of iffldtarg*/
  /* End of cleaning variable iffldtarg */
  } /*if (f2py_success) of ifpottarg*/
  /* End of cleaning variable ifpottarg */
  } /*if (f2py_success) of iffld*/
  /* End of cleaning variable iffld */
  } /*if (f2py_success) of ifpot*/
  /* End of cleaning variable ifpot */
  } /*if (f2py_success) of ifdipole*/
  /* End of cleaning variable ifdipole */
  } /*if (f2py_success) of ifcharge*/
  /* End of cleaning variable ifcharge */
  if((PyObject *)capi_source_tmp!=source_capi) {
    Py_XDECREF(capi_source_tmp); }
  }  /*if (capi_source_tmp == NULL) ... else of source*/
  /* End of cleaning variable source */
  } /*if (f2py_success) of iprec*/
  /* End of cleaning variable iprec */
  /* End of cleaning variable ier */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/*************************** end of lfmm3dparttarg ***************************/

/******************************* hfmm3dparttarg *******************************/
static char doc_f2py_rout__internal_hfmm3dparttarg[] = "\
ier,pot,fld,pottarg,fldtarg = hfmm3dparttarg(iprec,zk,source,ifcharge,charge,ifdipole,dipstr,dipvec,ifpot,iffld,ntarget,target,ifpottarg,pottarg,iffldtarg,fldtarg,[nsource])\n\nWrapper for ``hfmm3dparttarg``.\
\n\nParameters\n----------\n"
"iprec : input int\n"
"zk : input complex\n"
"source : input rank-2 array('d') with bounds (3,nsource)\n"
"ifcharge : input int\n"
"charge : input rank-1 array('D') with bounds (nsource)\n"
"ifdipole : input int\n"
"dipstr : input rank-1 array('D') with bounds (nsource)\n"
"dipvec : input rank-2 array('d') with bounds (3,nsource)\n"
"ifpot : input int\n"
"iffld : input int\n"
"ntarget : input int, optional\n    Default: shape(target,1)\n"
"target : input rank-2 array('d') with bounds (3,ntarget)\n"
"ifpottarg : input int\n"
"pottarg : input rank-1 array('D') with bounds (ntarget)\n"
"iffldtarg : input int\n"
"fldtarg : input rank-2 array('D') with bounds (3,ntarget)\n"
"\nOther Parameters\n----------------\n"
"nsource : input int, optional\n    Default: shape(source,1)\n"
"\nReturns\n-------\n"
"ier : int\n"
"pot : rank-1 array('D') with bounds (nsource)\n"
"fld : rank-2 array('D') with bounds (3,nsource)\n"
"pottarg : rank-1 array('D') with bounds (ntarget)\n"
"fldtarg : rank-2 array('D') with bounds (3,ntarget)";
/* extern void F_FUNC(hfmm3dparttarg,HFMM3DPARTTARG)(int*,int*,complex_double*,int*,double*,int*,complex_double*,int*,complex_double*,double*,int*,complex_double*,int*,complex_double*,int*,double*,int*,complex_double*,int*,complex_double*); */
static PyObject *f2py_rout__internal_hfmm3dparttarg(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,complex_double*,int*,double*,int*,complex_double*,int*,complex_double*,double*,int*,complex_double*,int*,complex_double*,int*,double*,int*,complex_double*,int*,complex_double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ier = 0;
  int iprec = 0;
  PyObject *iprec_capi = Py_None;
  complex_double zk;
  PyObject *zk_capi = Py_None;
  int nsource = 0;
  PyObject *nsource_capi = Py_None;
  double *source = NULL;
  npy_intp source_Dims[2] = {-1, -1};
  const int source_Rank = 2;
  PyArrayObject *capi_source_tmp = NULL;
  int capi_source_intent = 0;
  PyObject *source_capi = Py_None;
  int ifcharge = 0;
  PyObject *ifcharge_capi = Py_None;
  complex_double *charge = NULL;
  npy_intp charge_Dims[1] = {-1};
  const int charge_Rank = 1;
  PyArrayObject *capi_charge_tmp = NULL;
  int capi_charge_intent = 0;
  PyObject *charge_capi = Py_None;
  int ifdipole = 0;
  PyObject *ifdipole_capi = Py_None;
  complex_double *dipstr = NULL;
  npy_intp dipstr_Dims[1] = {-1};
  const int dipstr_Rank = 1;
  PyArrayObject *capi_dipstr_tmp = NULL;
  int capi_dipstr_intent = 0;
  PyObject *dipstr_capi = Py_None;
  double *dipvec = NULL;
  npy_intp dipvec_Dims[2] = {-1, -1};
  const int dipvec_Rank = 2;
  PyArrayObject *capi_dipvec_tmp = NULL;
  int capi_dipvec_intent = 0;
  PyObject *dipvec_capi = Py_None;
  int ifpot = 0;
  PyObject *ifpot_capi = Py_None;
  complex_double *pot = NULL;
  npy_intp pot_Dims[1] = {-1};
  const int pot_Rank = 1;
  PyArrayObject *capi_pot_tmp = NULL;
  int capi_pot_intent = 0;
  int iffld = 0;
  PyObject *iffld_capi = Py_None;
  complex_double *fld = NULL;
  npy_intp fld_Dims[2] = {-1, -1};
  const int fld_Rank = 2;
  PyArrayObject *capi_fld_tmp = NULL;
  int capi_fld_intent = 0;
  int ntarget = 0;
  PyObject *ntarget_capi = Py_None;
  double *target = NULL;
  npy_intp target_Dims[2] = {-1, -1};
  const int target_Rank = 2;
  PyArrayObject *capi_target_tmp = NULL;
  int capi_target_intent = 0;
  PyObject *target_capi = Py_None;
  int ifpottarg = 0;
  PyObject *ifpottarg_capi = Py_None;
  complex_double *pottarg = NULL;
  npy_intp pottarg_Dims[1] = {-1};
  const int pottarg_Rank = 1;
  PyArrayObject *capi_pottarg_tmp = NULL;
  int capi_pottarg_intent = 0;
  PyObject *pottarg_capi = Py_None;
  int iffldtarg = 0;
  PyObject *iffldtarg_capi = Py_None;
  complex_double *fldtarg = NULL;
  npy_intp fldtarg_Dims[2] = {-1, -1};
  const int fldtarg_Rank = 2;
  PyArrayObject *capi_fldtarg_tmp = NULL;
  int capi_fldtarg_intent = 0;
  PyObject *fldtarg_capi = Py_None;
    static char *capi_kwlist[] = {"iprec","zk","source","ifcharge","charge","ifdipole","dipstr","dipvec","ifpot","iffld","ntarget","target","ifpottarg","pottarg","iffldtarg","fldtarg","nsource",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOOOOOOOO|O:_internal.hfmm3dparttarg",\
        capi_kwlist,&iprec_capi,&zk_capi,&source_capi,&ifcharge_capi,&charge_capi,&ifdipole_capi,&dipstr_capi,&dipvec_capi,&ifpot_capi,&iffld_capi,&ntarget_capi,&target_capi,&ifpottarg_capi,&pottarg_capi,&iffldtarg_capi,&fldtarg_capi,&nsource_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable ier */
  /* Processing variable iprec */
    f2py_success = int_from_pyobj(&iprec,iprec_capi,"_internal.hfmm3dparttarg() 1st argument (iprec) can't be converted to int");
  if (f2py_success) {
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.hfmm3dparttarg() 2nd argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable source */
  source_Dims[0]=3;
  capi_source_intent |= F2PY_INTENT_IN;
  capi_source_tmp = array_from_pyobj(NPY_DOUBLE,source_Dims,source_Rank,capi_source_intent,source_capi);
  if (capi_source_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `source' of _internal.hfmm3dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source = (double *)(PyArray_DATA(capi_source_tmp));

  /* Processing variable ifcharge */
    f2py_success = int_from_pyobj(&ifcharge,ifcharge_capi,"_internal.hfmm3dparttarg() 4th argument (ifcharge) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ifdipole */
    f2py_success = int_from_pyobj(&ifdipole,ifdipole_capi,"_internal.hfmm3dparttarg() 6th argument (ifdipole) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ifpot */
    f2py_success = int_from_pyobj(&ifpot,ifpot_capi,"_internal.hfmm3dparttarg() 9th argument (ifpot) can't be converted to int");
  if (f2py_success) {
  /* Processing variable iffld */
    f2py_success = int_from_pyobj(&iffld,iffld_capi,"_internal.hfmm3dparttarg() 10th argument (iffld) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ifpottarg */
    f2py_success = int_from_pyobj(&ifpottarg,ifpottarg_capi,"_internal.hfmm3dparttarg() 13rd argument (ifpottarg) can't be converted to int");
  if (f2py_success) {
  /* Processing variable iffldtarg */
    f2py_success = int_from_pyobj(&iffldtarg,iffldtarg_capi,"_internal.hfmm3dparttarg() 15th argument (iffldtarg) can't be converted to int");
  if (f2py_success) {
  /* Processing variable target */
  target_Dims[0]=3;
  capi_target_intent |= F2PY_INTENT_IN;
  capi_target_tmp = array_from_pyobj(NPY_DOUBLE,target_Dims,target_Rank,capi_target_intent,target_capi);
  if (capi_target_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 12nd argument `target' of _internal.hfmm3dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    target = (double *)(PyArray_DATA(capi_target_tmp));

  /* Processing variable nsource */
  if (nsource_capi == Py_None) nsource = shape(source,1); else
    f2py_success = int_from_pyobj(&nsource,nsource_capi,"_internal.hfmm3dparttarg() 1st keyword (nsource) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(source,1)==nsource,"shape(source,1)==nsource","1st keyword nsource","hfmm3dparttarg:nsource=%d",nsource) {
  /* Processing variable charge */
  charge_Dims[0]=nsource;
  capi_charge_intent |= F2PY_INTENT_IN;
  capi_charge_tmp = array_from_pyobj(NPY_CDOUBLE,charge_Dims,charge_Rank,capi_charge_intent,charge_capi);
  if (capi_charge_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `charge' of _internal.hfmm3dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge = (complex_double *)(PyArray_DATA(capi_charge_tmp));

  /* Processing variable dipstr */
  dipstr_Dims[0]=nsource;
  capi_dipstr_intent |= F2PY_INTENT_IN;
  capi_dipstr_tmp = array_from_pyobj(NPY_CDOUBLE,dipstr_Dims,dipstr_Rank,capi_dipstr_intent,dipstr_capi);
  if (capi_dipstr_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 7th argument `dipstr' of _internal.hfmm3dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr = (complex_double *)(PyArray_DATA(capi_dipstr_tmp));

  /* Processing variable dipvec */
  dipvec_Dims[0]=3,dipvec_Dims[1]=nsource;
  capi_dipvec_intent |= F2PY_INTENT_IN;
  capi_dipvec_tmp = array_from_pyobj(NPY_DOUBLE,dipvec_Dims,dipvec_Rank,capi_dipvec_intent,dipvec_capi);
  if (capi_dipvec_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 8th argument `dipvec' of _internal.hfmm3dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipvec = (double *)(PyArray_DATA(capi_dipvec_tmp));

  /* Processing variable pot */
  pot_Dims[0]=nsource;
  capi_pot_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_pot_tmp = array_from_pyobj(NPY_CDOUBLE,pot_Dims,pot_Rank,capi_pot_intent,Py_None);
  if (capi_pot_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `pot' of _internal.hfmm3dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    pot = (complex_double *)(PyArray_DATA(capi_pot_tmp));

  /* Processing variable fld */
  fld_Dims[0]=3,fld_Dims[1]=nsource;
  capi_fld_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_fld_tmp = array_from_pyobj(NPY_CDOUBLE,fld_Dims,fld_Rank,capi_fld_intent,Py_None);
  if (capi_fld_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `fld' of _internal.hfmm3dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    fld = (complex_double *)(PyArray_DATA(capi_fld_tmp));

  /* Processing variable ntarget */
  if (ntarget_capi == Py_None) ntarget = shape(target,1); else
    f2py_success = int_from_pyobj(&ntarget,ntarget_capi,"_internal.hfmm3dparttarg() 11st argument (ntarget) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(1,"1","11st argument ntarget","hfmm3dparttarg:ntarget=%d",ntarget) {
  /* Processing variable pottarg */
  pottarg_Dims[0]=ntarget;
  capi_pottarg_intent |= F2PY_INTENT_IN|F2PY_INTENT_OUT;
  capi_pottarg_tmp = array_from_pyobj(NPY_CDOUBLE,pottarg_Dims,pottarg_Rank,capi_pottarg_intent,pottarg_capi);
  if (capi_pottarg_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 14th argument `pottarg' of _internal.hfmm3dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    pottarg = (complex_double *)(PyArray_DATA(capi_pottarg_tmp));

  /* Processing variable fldtarg */
  fldtarg_Dims[0]=3,fldtarg_Dims[1]=ntarget;
  capi_fldtarg_intent |= F2PY_INTENT_IN|F2PY_INTENT_OUT;
  capi_fldtarg_tmp = array_from_pyobj(NPY_CDOUBLE,fldtarg_Dims,fldtarg_Rank,capi_fldtarg_intent,fldtarg_capi);
  if (capi_fldtarg_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 16th argument `fldtarg' of _internal.hfmm3dparttarg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    fldtarg = (complex_double *)(PyArray_DATA(capi_fldtarg_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ier,&iprec,&zk,&nsource,source,&ifcharge,charge,&ifdipole,dipstr,dipvec,&ifpot,pot,&iffld,fld,&ntarget,target,&ifpottarg,pottarg,&iffldtarg,fldtarg);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("iNNNN",ier,capi_pot_tmp,capi_fld_tmp,capi_pottarg_tmp,capi_fldtarg_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_fldtarg_tmp == NULL) ... else of fldtarg*/
  /* End of cleaning variable fldtarg */
  }  /*if (capi_pottarg_tmp == NULL) ... else of pottarg*/
  /* End of cleaning variable pottarg */
  } /*CHECKSCALAR(1)*/
  } /*if (f2py_success) of ntarget*/
  /* End of cleaning variable ntarget */
  }  /*if (capi_fld_tmp == NULL) ... else of fld*/
  /* End of cleaning variable fld */
  }  /*if (capi_pot_tmp == NULL) ... else of pot*/
  /* End of cleaning variable pot */
  if((PyObject *)capi_dipvec_tmp!=dipvec_capi) {
    Py_XDECREF(capi_dipvec_tmp); }
  }  /*if (capi_dipvec_tmp == NULL) ... else of dipvec*/
  /* End of cleaning variable dipvec */
  if((PyObject *)capi_dipstr_tmp!=dipstr_capi) {
    Py_XDECREF(capi_dipstr_tmp); }
  }  /*if (capi_dipstr_tmp == NULL) ... else of dipstr*/
  /* End of cleaning variable dipstr */
  if((PyObject *)capi_charge_tmp!=charge_capi) {
    Py_XDECREF(capi_charge_tmp); }
  }  /*if (capi_charge_tmp == NULL) ... else of charge*/
  /* End of cleaning variable charge */
  } /*CHECKSCALAR(shape(source,1)==nsource)*/
  } /*if (f2py_success) of nsource*/
  /* End of cleaning variable nsource */
  if((PyObject *)capi_target_tmp!=target_capi) {
    Py_XDECREF(capi_target_tmp); }
  }  /*if (capi_target_tmp == NULL) ... else of target*/
  /* End of cleaning variable target */
  } /*if (f2py_success) of iffldtarg*/
  /* End of cleaning variable iffldtarg */
  } /*if (f2py_success) of ifpottarg*/
  /* End of cleaning variable ifpottarg */
  } /*if (f2py_success) of iffld*/
  /* End of cleaning variable iffld */
  } /*if (f2py_success) of ifpot*/
  /* End of cleaning variable ifpot */
  } /*if (f2py_success) of ifdipole*/
  /* End of cleaning variable ifdipole */
  } /*if (f2py_success) of ifcharge*/
  /* End of cleaning variable ifcharge */
  if((PyObject *)capi_source_tmp!=source_capi) {
    Py_XDECREF(capi_source_tmp); }
  }  /*if (capi_source_tmp == NULL) ... else of source*/
  /* End of cleaning variable source */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
  } /*if (f2py_success) of iprec*/
  /* End of cleaning variable iprec */
  /* End of cleaning variable ier */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/*************************** end of hfmm3dparttarg ***************************/

/******************************* l3dtaevalhess *******************************/
static char doc_f2py_rout__internal_l3dtaevalhess[] = "\
pot,fld,hess,ier = l3dtaevalhess(rscale,center,mpole,ztarg,iffld,ifhess,ier,[nterms])\n\nWrapper for ``l3dtaevalhess``.\
\n\nParameters\n----------\n"
"rscale : input float\n"
"center : input rank-1 array('d') with bounds (3)\n"
"mpole : input rank-2 array('D') with bounds (nterms + 1,2 * nterms + 1)\n"
"ztarg : input rank-1 array('d') with bounds (3)\n"
"iffld : input int\n"
"ifhess : input int\n"
"ier : input int\n"
"\nOther Parameters\n----------------\n"
"nterms : input int, optional\n    Default: (shape(mpole,0)-1)\n"
"\nReturns\n-------\n"
"pot : complex\n"
"fld : rank-1 array('D') with bounds (3)\n"
"hess : rank-1 array('D') with bounds (6)\n"
"ier : int";
/* extern void F_FUNC(l3dtaevalhess,L3DTAEVALHESS)(double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,complex_double*,int*); */
static PyObject *f2py_rout__internal_l3dtaevalhess(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,complex_double*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *center = NULL;
  npy_intp center_Dims[1] = {-1};
  const int center_Rank = 1;
  PyArrayObject *capi_center_tmp = NULL;
  int capi_center_intent = 0;
  PyObject *center_capi = Py_None;
  complex_double *mpole = NULL;
  npy_intp mpole_Dims[2] = {-1, -1};
  const int mpole_Rank = 2;
  PyArrayObject *capi_mpole_tmp = NULL;
  int capi_mpole_intent = 0;
  PyObject *mpole_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  double *ztarg = NULL;
  npy_intp ztarg_Dims[1] = {-1};
  const int ztarg_Rank = 1;
  PyArrayObject *capi_ztarg_tmp = NULL;
  int capi_ztarg_intent = 0;
  PyObject *ztarg_capi = Py_None;
  complex_double pot;
  PyObject *pot_capi = Py_None;
  int iffld = 0;
  PyObject *iffld_capi = Py_None;
  complex_double *fld = NULL;
  npy_intp fld_Dims[1] = {-1};
  const int fld_Rank = 1;
  PyArrayObject *capi_fld_tmp = NULL;
  int capi_fld_intent = 0;
  int ifhess = 0;
  PyObject *ifhess_capi = Py_None;
  complex_double *hess = NULL;
  npy_intp hess_Dims[1] = {-1};
  const int hess_Rank = 1;
  PyArrayObject *capi_hess_tmp = NULL;
  int capi_hess_intent = 0;
  int ier = 0;
  PyObject *ier_capi = Py_None;
    static char *capi_kwlist[] = {"rscale","center","mpole","ztarg","iffld","ifhess","ier","nterms",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOO|O:_internal.l3dtaevalhess",\
        capi_kwlist,&rscale_capi,&center_capi,&mpole_capi,&ztarg_capi,&iffld_capi,&ifhess_capi,&ier_capi,&nterms_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable ier */
    f2py_success = int_from_pyobj(&ier,ier_capi,"_internal.l3dtaevalhess() 7th argument (ier) can't be converted to int");
  if (f2py_success) {
  /* Processing variable iffld */
    f2py_success = int_from_pyobj(&iffld,iffld_capi,"_internal.l3dtaevalhess() 5th argument (iffld) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ifhess */
    f2py_success = int_from_pyobj(&ifhess,ifhess_capi,"_internal.l3dtaevalhess() 6th argument (ifhess) can't be converted to int");
  if (f2py_success) {
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.l3dtaevalhess() 1st argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable center */
  center_Dims[0]=3;
  capi_center_intent |= F2PY_INTENT_IN;
  capi_center_tmp = array_from_pyobj(NPY_DOUBLE,center_Dims,center_Rank,capi_center_intent,center_capi);
  if (capi_center_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `center' of _internal.l3dtaevalhess to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center = (double *)(PyArray_DATA(capi_center_tmp));

  /* Processing variable ztarg */
  ztarg_Dims[0]=3;
  capi_ztarg_intent |= F2PY_INTENT_IN;
  capi_ztarg_tmp = array_from_pyobj(NPY_DOUBLE,ztarg_Dims,ztarg_Rank,capi_ztarg_intent,ztarg_capi);
  if (capi_ztarg_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `ztarg' of _internal.l3dtaevalhess to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ztarg = (double *)(PyArray_DATA(capi_ztarg_tmp));

  /* Processing variable mpole */
  ;
  capi_mpole_intent |= F2PY_INTENT_IN;
  capi_mpole_tmp = array_from_pyobj(NPY_CDOUBLE,mpole_Dims,mpole_Rank,capi_mpole_intent,mpole_capi);
  if (capi_mpole_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `mpole' of _internal.l3dtaevalhess to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    mpole = (complex_double *)(PyArray_DATA(capi_mpole_tmp));

  /* Processing variable pot */
  /* Processing variable fld */
  fld_Dims[0]=3;
  capi_fld_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_fld_tmp = array_from_pyobj(NPY_CDOUBLE,fld_Dims,fld_Rank,capi_fld_intent,Py_None);
  if (capi_fld_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `fld' of _internal.l3dtaevalhess to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    fld = (complex_double *)(PyArray_DATA(capi_fld_tmp));

  /* Processing variable hess */
  hess_Dims[0]=6;
  capi_hess_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_hess_tmp = array_from_pyobj(NPY_CDOUBLE,hess_Dims,hess_Rank,capi_hess_intent,Py_None);
  if (capi_hess_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `hess' of _internal.l3dtaevalhess to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    hess = (complex_double *)(PyArray_DATA(capi_hess_tmp));

  /* Processing variable nterms */
  if (nterms_capi == Py_None) nterms = (shape(mpole,0)-1); else
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.l3dtaevalhess() 1st keyword (nterms) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((shape(mpole,0)-1)==nterms,"(shape(mpole,0)-1)==nterms","1st keyword nterms","l3dtaevalhess:nterms=%d",nterms) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&rscale,center,mpole,&nterms,ztarg,&pot,&iffld,fld,&ifhess,hess,&ier);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
  pot_capi = pyobj_from_complex_double1(pot);
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NNNi",pot_capi,capi_fld_tmp,capi_hess_tmp,ier);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*CHECKSCALAR((shape(mpole,0)-1)==nterms)*/
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  }  /*if (capi_hess_tmp == NULL) ... else of hess*/
  /* End of cleaning variable hess */
  }  /*if (capi_fld_tmp == NULL) ... else of fld*/
  /* End of cleaning variable fld */
  /* End of cleaning variable pot */
  if((PyObject *)capi_mpole_tmp!=mpole_capi) {
    Py_XDECREF(capi_mpole_tmp); }
  }  /*if (capi_mpole_tmp == NULL) ... else of mpole*/
  /* End of cleaning variable mpole */
  if((PyObject *)capi_ztarg_tmp!=ztarg_capi) {
    Py_XDECREF(capi_ztarg_tmp); }
  }  /*if (capi_ztarg_tmp == NULL) ... else of ztarg*/
  /* End of cleaning variable ztarg */
  if((PyObject *)capi_center_tmp!=center_capi) {
    Py_XDECREF(capi_center_tmp); }
  }  /*if (capi_center_tmp == NULL) ... else of center*/
  /* End of cleaning variable center */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
  } /*if (f2py_success) of ifhess*/
  /* End of cleaning variable ifhess */
  } /*if (f2py_success) of iffld*/
  /* End of cleaning variable iffld */
  } /*if (f2py_success) of ier*/
  /* End of cleaning variable ier */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/**************************** end of l3dtaevalhess ****************************/

/********************************** l2dterms **********************************/
static char doc_f2py_rout__internal_l2dterms[] = "\
nterms,ier = l2dterms(eps)\n\nWrapper for ``l2dterms``.\
\n\nParameters\n----------\n"
"eps : input float\n"
"\nReturns\n-------\n"
"nterms : int\n"
"ier : int";
/* extern void F_FUNC(l2dterms,L2DTERMS)(double*,int*,int*); */
static PyObject *f2py_rout__internal_l2dterms(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double eps = 0;
  PyObject *eps_capi = Py_None;
  int nterms = 0;
  int ier = 0;
    static char *capi_kwlist[] = {"eps",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "O|:_internal.l2dterms",\
        capi_kwlist,&eps_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable eps */
    f2py_success = double_from_pyobj(&eps,eps_capi,"_internal.l2dterms() 1st argument (eps) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nterms */
  /* Processing variable ier */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&eps,&nterms,&ier);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("ii",nterms,ier);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable ier */
  /* End of cleaning variable nterms */
  } /*if (f2py_success) of eps*/
  /* End of cleaning variable eps */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/****************************** end of l2dterms ******************************/

/********************************** h2dterms **********************************/
static char doc_f2py_rout__internal_h2dterms[] = "\
nterms,ier = h2dterms(size_bn,zk,eps)\n\nWrapper for ``h2dterms``.\
\n\nParameters\n----------\n"
"size_bn : input float\n"
"zk : input complex\n"
"eps : input float\n"
"\nReturns\n-------\n"
"nterms : int\n"
"ier : int";
/* extern void F_FUNC(h2dterms,H2DTERMS)(double*,complex_double*,double*,int*,int*); */
static PyObject *f2py_rout__internal_h2dterms(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,complex_double*,double*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double size_bn = 0;
  PyObject *size_bn_capi = Py_None;
  complex_double zk;
  PyObject *zk_capi = Py_None;
  double eps = 0;
  PyObject *eps_capi = Py_None;
  int nterms = 0;
  int ier = 0;
    static char *capi_kwlist[] = {"size_bn","zk","eps",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOO|:_internal.h2dterms",\
        capi_kwlist,&size_bn_capi,&zk_capi,&eps_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable size_bn */
    f2py_success = double_from_pyobj(&size_bn,size_bn_capi,"_internal.h2dterms() 1st argument (size_bn) can't be converted to double");
  if (f2py_success) {
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.h2dterms() 2nd argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable eps */
    f2py_success = double_from_pyobj(&eps,eps_capi,"_internal.h2dterms() 3rd argument (eps) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nterms */
  /* Processing variable ier */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&size_bn,&zk,&eps,&nterms,&ier);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("ii",nterms,ier);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable ier */
  /* End of cleaning variable nterms */
  } /*if (f2py_success) of eps*/
  /* End of cleaning variable eps */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
  } /*if (f2py_success) of size_bn*/
  /* End of cleaning variable size_bn */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/****************************** end of h2dterms ******************************/

/********************************** l3dterms **********************************/
static char doc_f2py_rout__internal_l3dterms[] = "\
nterms,ier = l3dterms(eps)\n\nWrapper for ``l3dterms``.\
\n\nParameters\n----------\n"
"eps : input float\n"
"\nReturns\n-------\n"
"nterms : int\n"
"ier : int";
/* extern void F_FUNC(l3dterms,L3DTERMS)(double*,int*,int*); */
static PyObject *f2py_rout__internal_l3dterms(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double eps = 0;
  PyObject *eps_capi = Py_None;
  int nterms = 0;
  int ier = 0;
    static char *capi_kwlist[] = {"eps",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "O|:_internal.l3dterms",\
        capi_kwlist,&eps_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable eps */
    f2py_success = double_from_pyobj(&eps,eps_capi,"_internal.l3dterms() 1st argument (eps) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nterms */
  /* Processing variable ier */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&eps,&nterms,&ier);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("ii",nterms,ier);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable ier */
  /* End of cleaning variable nterms */
  } /*if (f2py_success) of eps*/
  /* End of cleaning variable eps */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/****************************** end of l3dterms ******************************/

/********************************** h3dterms **********************************/
static char doc_f2py_rout__internal_h3dterms[] = "\
nterms,ier = h3dterms(size_bn,zk,eps)\n\nWrapper for ``h3dterms``.\
\n\nParameters\n----------\n"
"size_bn : input float\n"
"zk : input complex\n"
"eps : input float\n"
"\nReturns\n-------\n"
"nterms : int\n"
"ier : int";
/* extern void F_FUNC(h3dterms,H3DTERMS)(double*,complex_double*,double*,int*,int*); */
static PyObject *f2py_rout__internal_h3dterms(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,complex_double*,double*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double size_bn = 0;
  PyObject *size_bn_capi = Py_None;
  complex_double zk;
  PyObject *zk_capi = Py_None;
  double eps = 0;
  PyObject *eps_capi = Py_None;
  int nterms = 0;
  int ier = 0;
    static char *capi_kwlist[] = {"size_bn","zk","eps",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOO|:_internal.h3dterms",\
        capi_kwlist,&size_bn_capi,&zk_capi,&eps_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable size_bn */
    f2py_success = double_from_pyobj(&size_bn,size_bn_capi,"_internal.h3dterms() 1st argument (size_bn) can't be converted to double");
  if (f2py_success) {
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.h3dterms() 2nd argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable eps */
    f2py_success = double_from_pyobj(&eps,eps_capi,"_internal.h3dterms() 3rd argument (eps) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nterms */
  /* Processing variable ier */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&size_bn,&zk,&eps,&nterms,&ier);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("ii",nterms,ier);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable ier */
  /* End of cleaning variable nterms */
  } /*if (f2py_success) of eps*/
  /* End of cleaning variable eps */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
  } /*if (f2py_success) of size_bn*/
  /* End of cleaning variable size_bn */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/****************************** end of h3dterms ******************************/

/***************************** rotviarecur3p_init *****************************/
static char doc_f2py_rout__internal_rotviarecur3p_init[] = "\
ier,rotmat = rotviarecur3p_init(ldc,theta)\n\nWrapper for ``rotviarecur3p_init``.\
\n\nParameters\n----------\n"
"ldc : input int\n"
"theta : input float\n"
"\nReturns\n-------\n"
"ier : int\n"
"rotmat : rank-3 array('d') with bounds (ldc + 1,ldc + 1,2 * ldc + 1)";
/* extern void F_FUNC_US(rotviarecur3p_init,ROTVIARECUR3P_INIT)(int*,double*,int*,double*); */
static PyObject *f2py_rout__internal_rotviarecur3p_init(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,int*,double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ier = 0;
  double *rotmat = NULL;
  npy_intp rotmat_Dims[3] = {-1, -1, -1};
  const int rotmat_Rank = 3;
  PyArrayObject *capi_rotmat_tmp = NULL;
  int capi_rotmat_intent = 0;
  int ldc = 0;
  PyObject *ldc_capi = Py_None;
  double theta = 0;
  PyObject *theta_capi = Py_None;
    static char *capi_kwlist[] = {"ldc","theta",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OO|:_internal.rotviarecur3p_init",\
        capi_kwlist,&ldc_capi,&theta_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable ier */
  /* Processing variable ldc */
    f2py_success = int_from_pyobj(&ldc,ldc_capi,"_internal.rotviarecur3p_init() 1st argument (ldc) can't be converted to int");
  if (f2py_success) {
  /* Processing variable theta */
    f2py_success = double_from_pyobj(&theta,theta_capi,"_internal.rotviarecur3p_init() 2nd argument (theta) can't be converted to double");
  if (f2py_success) {
  /* Processing variable rotmat */
  rotmat_Dims[0]=ldc + 1,rotmat_Dims[1]=ldc + 1,rotmat_Dims[2]=2 * ldc + 1;
  capi_rotmat_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_rotmat_tmp = array_from_pyobj(NPY_DOUBLE,rotmat_Dims,rotmat_Rank,capi_rotmat_intent,Py_None);
  if (capi_rotmat_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `rotmat' of _internal.rotviarecur3p_init to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rotmat = (double *)(PyArray_DATA(capi_rotmat_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ier,rotmat,&ldc,&theta);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("iN",ier,capi_rotmat_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_rotmat_tmp == NULL) ... else of rotmat*/
  /* End of cleaning variable rotmat */
  } /*if (f2py_success) of theta*/
  /* End of cleaning variable theta */
  } /*if (f2py_success) of ldc*/
  /* End of cleaning variable ldc */
  /* End of cleaning variable ier */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/************************* end of rotviarecur3p_init *************************/

/***************************** triangle_norm_vec *****************************/
static char doc_f2py_rout__internal_triangle_norm_vec[] = "\
trinorm = triangle_norm_vec(triangles,[nvcount])\n\nWrapper for ``triangle_norm_vec``.\
\n\nParameters\n----------\n"
"triangles : input rank-3 array('d') with bounds (3,3,nvcount)\n"
"\nOther Parameters\n----------------\n"
"nvcount : input int, optional\n    Default: shape(triangles,2)\n"
"\nReturns\n-------\n"
"trinorm : rank-2 array('d') with bounds (3,nvcount)";
/* extern void F_FUNC_US(triangle_norm_vec,TRIANGLE_NORM_VEC)(double*,double*,int*); */
static PyObject *f2py_rout__internal_triangle_norm_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double *triangles = NULL;
  npy_intp triangles_Dims[3] = {-1, -1, -1};
  const int triangles_Rank = 3;
  PyArrayObject *capi_triangles_tmp = NULL;
  int capi_triangles_intent = 0;
  PyObject *triangles_capi = Py_None;
  double *trinorm = NULL;
  npy_intp trinorm_Dims[2] = {-1, -1};
  const int trinorm_Rank = 2;
  PyArrayObject *capi_trinorm_tmp = NULL;
  int capi_trinorm_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"triangles","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "O|O:_internal.triangle_norm_vec",\
        capi_kwlist,&triangles_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable triangles */
  triangles_Dims[0]=3,triangles_Dims[1]=3;
  capi_triangles_intent |= F2PY_INTENT_IN;
  capi_triangles_tmp = array_from_pyobj(NPY_DOUBLE,triangles_Dims,triangles_Rank,capi_triangles_intent,triangles_capi);
  if (capi_triangles_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 1st argument `triangles' of _internal.triangle_norm_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    triangles = (double *)(PyArray_DATA(capi_triangles_tmp));

  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = shape(triangles,2); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.triangle_norm_vec() 1st keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(triangles,2)==nvcount,"shape(triangles,2)==nvcount","1st keyword nvcount","triangle_norm_vec:nvcount=%d",nvcount) {
  /* Processing variable trinorm */
  trinorm_Dims[0]=3,trinorm_Dims[1]=nvcount;
  capi_trinorm_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_trinorm_tmp = array_from_pyobj(NPY_DOUBLE,trinorm_Dims,trinorm_Rank,capi_trinorm_intent,Py_None);
  if (capi_trinorm_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `trinorm' of _internal.triangle_norm_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    trinorm = (double *)(PyArray_DATA(capi_trinorm_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(triangles,trinorm,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("N",capi_trinorm_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_trinorm_tmp == NULL) ... else of trinorm*/
  /* End of cleaning variable trinorm */
  } /*CHECKSCALAR(shape(triangles,2)==nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  if((PyObject *)capi_triangles_tmp!=triangles_capi) {
    Py_XDECREF(capi_triangles_tmp); }
  }  /*if (capi_triangles_tmp == NULL) ... else of triangles*/
  /* End of cleaning variable triangles */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/************************** end of triangle_norm_vec **************************/

/***************************** triangle_area_vec *****************************/
static char doc_f2py_rout__internal_triangle_area_vec[] = "\
triarea = triangle_area_vec(triangles,[nvcount])\n\nWrapper for ``triangle_area_vec``.\
\n\nParameters\n----------\n"
"triangles : input rank-3 array('d') with bounds (3,3,nvcount)\n"
"\nOther Parameters\n----------------\n"
"nvcount : input int, optional\n    Default: shape(triangles,2)\n"
"\nReturns\n-------\n"
"triarea : rank-1 array('d') with bounds (nvcount)";
/* extern void F_FUNC_US(triangle_area_vec,TRIANGLE_AREA_VEC)(double*,double*,int*); */
static PyObject *f2py_rout__internal_triangle_area_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double *triangles = NULL;
  npy_intp triangles_Dims[3] = {-1, -1, -1};
  const int triangles_Rank = 3;
  PyArrayObject *capi_triangles_tmp = NULL;
  int capi_triangles_intent = 0;
  PyObject *triangles_capi = Py_None;
  double *triarea = NULL;
  npy_intp triarea_Dims[1] = {-1};
  const int triarea_Rank = 1;
  PyArrayObject *capi_triarea_tmp = NULL;
  int capi_triarea_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"triangles","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "O|O:_internal.triangle_area_vec",\
        capi_kwlist,&triangles_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable triangles */
  triangles_Dims[0]=3,triangles_Dims[1]=3;
  capi_triangles_intent |= F2PY_INTENT_IN;
  capi_triangles_tmp = array_from_pyobj(NPY_DOUBLE,triangles_Dims,triangles_Rank,capi_triangles_intent,triangles_capi);
  if (capi_triangles_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 1st argument `triangles' of _internal.triangle_area_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    triangles = (double *)(PyArray_DATA(capi_triangles_tmp));

  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = shape(triangles,2); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.triangle_area_vec() 1st keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(triangles,2)==nvcount,"shape(triangles,2)==nvcount","1st keyword nvcount","triangle_area_vec:nvcount=%d",nvcount) {
  /* Processing variable triarea */
  triarea_Dims[0]=nvcount;
  capi_triarea_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_triarea_tmp = array_from_pyobj(NPY_DOUBLE,triarea_Dims,triarea_Rank,capi_triarea_intent,Py_None);
  if (capi_triarea_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `triarea' of _internal.triangle_area_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    triarea = (double *)(PyArray_DATA(capi_triarea_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(triangles,triarea,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("N",capi_triarea_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_triarea_tmp == NULL) ... else of triarea*/
  /* End of cleaning variable triarea */
  } /*CHECKSCALAR(shape(triangles,2)==nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  if((PyObject *)capi_triangles_tmp!=triangles_capi) {
    Py_XDECREF(capi_triangles_tmp); }
  }  /*if (capi_triangles_tmp == NULL) ... else of triangles*/
  /* End of cleaning variable triangles */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/************************** end of triangle_area_vec **************************/

/*************************** rotviarecur3p_init_vec ***************************/
static char doc_f2py_rout__internal_rotviarecur3p_init_vec[] = "\
ier,rotmat = rotviarecur3p_init_vec(ldc,theta,[nvcount])\n\nWrapper for ``rotviarecur3p_init_vec``.\
\n\nParameters\n----------\n"
"ldc : input int\n"
"theta : input rank-1 array('d') with bounds (nvcount)\n"
"\nOther Parameters\n----------------\n"
"nvcount : input int, optional\n    Default: len(theta)\n"
"\nReturns\n-------\n"
"ier : rank-1 array('i') with bounds (nvcount)\n"
"rotmat : rank-4 array('d') with bounds (ldc + 1,ldc + 1,2 * ldc + 1,nvcount)";
/* extern void F_FUNC_US(rotviarecur3p_init_vec,ROTVIARECUR3P_INIT_VEC)(int*,double*,int*,double*,int*); */
static PyObject *f2py_rout__internal_rotviarecur3p_init_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,int*,double*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int *ier = NULL;
  npy_intp ier_Dims[1] = {-1};
  const int ier_Rank = 1;
  PyArrayObject *capi_ier_tmp = NULL;
  int capi_ier_intent = 0;
  double *rotmat = NULL;
  npy_intp rotmat_Dims[4] = {-1, -1, -1, -1};
  const int rotmat_Rank = 4;
  PyArrayObject *capi_rotmat_tmp = NULL;
  int capi_rotmat_intent = 0;
  int ldc = 0;
  PyObject *ldc_capi = Py_None;
  double *theta = NULL;
  npy_intp theta_Dims[1] = {-1};
  const int theta_Rank = 1;
  PyArrayObject *capi_theta_tmp = NULL;
  int capi_theta_intent = 0;
  PyObject *theta_capi = Py_None;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"ldc","theta","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OO|O:_internal.rotviarecur3p_init_vec",\
        capi_kwlist,&ldc_capi,&theta_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable ldc */
    f2py_success = int_from_pyobj(&ldc,ldc_capi,"_internal.rotviarecur3p_init_vec() 1st argument (ldc) can't be converted to int");
  if (f2py_success) {
  /* Processing variable theta */
  ;
  capi_theta_intent |= F2PY_INTENT_IN;
  capi_theta_tmp = array_from_pyobj(NPY_DOUBLE,theta_Dims,theta_Rank,capi_theta_intent,theta_capi);
  if (capi_theta_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `theta' of _internal.rotviarecur3p_init_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    theta = (double *)(PyArray_DATA(capi_theta_tmp));

  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = len(theta); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.rotviarecur3p_init_vec() 1st keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(theta)>=nvcount,"len(theta)>=nvcount","1st keyword nvcount","rotviarecur3p_init_vec:nvcount=%d",nvcount) {
  /* Processing variable ier */
  ier_Dims[0]=nvcount;
  capi_ier_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_ier_tmp = array_from_pyobj(NPY_INT,ier_Dims,ier_Rank,capi_ier_intent,Py_None);
  if (capi_ier_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `ier' of _internal.rotviarecur3p_init_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ier = (int *)(PyArray_DATA(capi_ier_tmp));

  /* Processing variable rotmat */
  rotmat_Dims[0]=ldc + 1,rotmat_Dims[1]=ldc + 1,rotmat_Dims[2]=2 * ldc + 1,rotmat_Dims[3]=nvcount;
  capi_rotmat_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_rotmat_tmp = array_from_pyobj(NPY_DOUBLE,rotmat_Dims,rotmat_Rank,capi_rotmat_intent,Py_None);
  if (capi_rotmat_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `rotmat' of _internal.rotviarecur3p_init_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rotmat = (double *)(PyArray_DATA(capi_rotmat_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(ier,rotmat,&ldc,theta,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NN",capi_ier_tmp,capi_rotmat_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_rotmat_tmp == NULL) ... else of rotmat*/
  /* End of cleaning variable rotmat */
  }  /*if (capi_ier_tmp == NULL) ... else of ier*/
  /* End of cleaning variable ier */
  } /*CHECKSCALAR(len(theta)>=nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  if((PyObject *)capi_theta_tmp!=theta_capi) {
    Py_XDECREF(capi_theta_tmp); }
  }  /*if (capi_theta_tmp == NULL) ... else of theta*/
  /* End of cleaning variable theta */
  } /*if (f2py_success) of ldc*/
  /* End of cleaning variable ldc */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/*********************** end of rotviarecur3p_init_vec ***********************/

/********************************* ylgndr_vec *********************************/
static char doc_f2py_rout__internal_ylgndr_vec[] = "\
y = ylgndr_vec(nmax,x,[nvcount])\n\nWrapper for ``ylgndr_vec``.\
\n\nParameters\n----------\n"
"nmax : input int\n"
"x : input rank-1 array('d') with bounds (nvcount)\n"
"\nOther Parameters\n----------------\n"
"nvcount : input int, optional\n    Default: len(x)\n"
"\nReturns\n-------\n"
"y : rank-3 array('d') with bounds (nmax + 1,nmax + 1,nvcount)";
/* extern void F_FUNC_US(ylgndr_vec,YLGNDR_VEC)(int*,double*,double*,int*); */
static PyObject *f2py_rout__internal_ylgndr_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int nmax = 0;
  PyObject *nmax_capi = Py_None;
  double *x = NULL;
  npy_intp x_Dims[1] = {-1};
  const int x_Rank = 1;
  PyArrayObject *capi_x_tmp = NULL;
  int capi_x_intent = 0;
  PyObject *x_capi = Py_None;
  double *y = NULL;
  npy_intp y_Dims[3] = {-1, -1, -1};
  const int y_Rank = 3;
  PyArrayObject *capi_y_tmp = NULL;
  int capi_y_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"nmax","x","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OO|O:_internal.ylgndr_vec",\
        capi_kwlist,&nmax_capi,&x_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable nmax */
    f2py_success = int_from_pyobj(&nmax,nmax_capi,"_internal.ylgndr_vec() 1st argument (nmax) can't be converted to int");
  if (f2py_success) {
  /* Processing variable x */
  ;
  capi_x_intent |= F2PY_INTENT_IN;
  capi_x_tmp = array_from_pyobj(NPY_DOUBLE,x_Dims,x_Rank,capi_x_intent,x_capi);
  if (capi_x_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `x' of _internal.ylgndr_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    x = (double *)(PyArray_DATA(capi_x_tmp));

  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = len(x); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.ylgndr_vec() 1st keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(x)>=nvcount,"len(x)>=nvcount","1st keyword nvcount","ylgndr_vec:nvcount=%d",nvcount) {
  /* Processing variable y */
  y_Dims[0]=nmax + 1,y_Dims[1]=nmax + 1,y_Dims[2]=nvcount;
  capi_y_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_y_tmp = array_from_pyobj(NPY_DOUBLE,y_Dims,y_Rank,capi_y_intent,Py_None);
  if (capi_y_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `y' of _internal.ylgndr_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    y = (double *)(PyArray_DATA(capi_y_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&nmax,x,y,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("N",capi_y_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_y_tmp == NULL) ... else of y*/
  /* End of cleaning variable y */
  } /*CHECKSCALAR(len(x)>=nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  if((PyObject *)capi_x_tmp!=x_capi) {
    Py_XDECREF(capi_x_tmp); }
  }  /*if (capi_x_tmp == NULL) ... else of x*/
  /* End of cleaning variable x */
  } /*if (f2py_success) of nmax*/
  /* End of cleaning variable nmax */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/***************************** end of ylgndr_vec *****************************/

/******************************** hank103_vec ********************************/
static char doc_f2py_rout__internal_hank103_vec[] = "\
h0,h1 = hank103_vec(z,ifexpon,[nvcount])\n\nWrapper for ``hank103_vec``.\
\n\nParameters\n----------\n"
"z : input rank-1 array('D') with bounds (nvcount)\n"
"ifexpon : input int\n"
"\nOther Parameters\n----------------\n"
"nvcount : input int, optional\n    Default: len(z)\n"
"\nReturns\n-------\n"
"h0 : rank-1 array('D') with bounds (nvcount)\n"
"h1 : rank-1 array('D') with bounds (nvcount)";
/* extern void F_FUNC_US(hank103_vec,HANK103_VEC)(complex_double*,complex_double*,complex_double*,int*,int*); */
static PyObject *f2py_rout__internal_hank103_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(complex_double*,complex_double*,complex_double*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  complex_double *z = NULL;
  npy_intp z_Dims[1] = {-1};
  const int z_Rank = 1;
  PyArrayObject *capi_z_tmp = NULL;
  int capi_z_intent = 0;
  PyObject *z_capi = Py_None;
  complex_double *h0 = NULL;
  npy_intp h0_Dims[1] = {-1};
  const int h0_Rank = 1;
  PyArrayObject *capi_h0_tmp = NULL;
  int capi_h0_intent = 0;
  complex_double *h1 = NULL;
  npy_intp h1_Dims[1] = {-1};
  const int h1_Rank = 1;
  PyArrayObject *capi_h1_tmp = NULL;
  int capi_h1_intent = 0;
  int ifexpon = 0;
  PyObject *ifexpon_capi = Py_None;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"z","ifexpon","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OO|O:_internal.hank103_vec",\
        capi_kwlist,&z_capi,&ifexpon_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable z */
  ;
  capi_z_intent |= F2PY_INTENT_IN;
  capi_z_tmp = array_from_pyobj(NPY_CDOUBLE,z_Dims,z_Rank,capi_z_intent,z_capi);
  if (capi_z_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 1st argument `z' of _internal.hank103_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    z = (complex_double *)(PyArray_DATA(capi_z_tmp));

  /* Processing variable ifexpon */
    f2py_success = int_from_pyobj(&ifexpon,ifexpon_capi,"_internal.hank103_vec() 2nd argument (ifexpon) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = len(z); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.hank103_vec() 1st keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(z)>=nvcount,"len(z)>=nvcount","1st keyword nvcount","hank103_vec:nvcount=%d",nvcount) {
  /* Processing variable h0 */
  h0_Dims[0]=nvcount;
  capi_h0_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_h0_tmp = array_from_pyobj(NPY_CDOUBLE,h0_Dims,h0_Rank,capi_h0_intent,Py_None);
  if (capi_h0_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `h0' of _internal.hank103_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    h0 = (complex_double *)(PyArray_DATA(capi_h0_tmp));

  /* Processing variable h1 */
  h1_Dims[0]=nvcount;
  capi_h1_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_h1_tmp = array_from_pyobj(NPY_CDOUBLE,h1_Dims,h1_Rank,capi_h1_intent,Py_None);
  if (capi_h1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `h1' of _internal.hank103_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    h1 = (complex_double *)(PyArray_DATA(capi_h1_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(z,h0,h1,&ifexpon,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NN",capi_h0_tmp,capi_h1_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_h1_tmp == NULL) ... else of h1*/
  /* End of cleaning variable h1 */
  }  /*if (capi_h0_tmp == NULL) ... else of h0*/
  /* End of cleaning variable h0 */
  } /*CHECKSCALAR(len(z)>=nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  } /*if (f2py_success) of ifexpon*/
  /* End of cleaning variable ifexpon */
  if((PyObject *)capi_z_tmp!=z_capi) {
    Py_XDECREF(capi_z_tmp); }
  }  /*if (capi_z_tmp == NULL) ... else of z*/
  /* End of cleaning variable z */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/***************************** end of hank103_vec *****************************/

/******************************** legefder_vec ********************************/
static char doc_f2py_rout__internal_legefder_vec[] = "\
val,der = legefder_vec(x,pexp,[n,nvcount])\n\nWrapper for ``legefder_vec``.\
\n\nParameters\n----------\n"
"x : input rank-1 array('d') with bounds (nvcount)\n"
"pexp : input rank-1 array('d') with bounds (n + 1)\n"
"\nOther Parameters\n----------------\n"
"n : input int, optional\n    Default: (len(pexp)-1)\n"
"nvcount : input int, optional\n    Default: len(x)\n"
"\nReturns\n-------\n"
"val : rank-1 array('d') with bounds (nvcount)\n"
"der : rank-1 array('d') with bounds (nvcount)";
/* extern void F_FUNC_US(legefder_vec,LEGEFDER_VEC)(double*,double*,double*,double*,int*,int*); */
static PyObject *f2py_rout__internal_legefder_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,double*,double*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double *x = NULL;
  npy_intp x_Dims[1] = {-1};
  const int x_Rank = 1;
  PyArrayObject *capi_x_tmp = NULL;
  int capi_x_intent = 0;
  PyObject *x_capi = Py_None;
  double *val = NULL;
  npy_intp val_Dims[1] = {-1};
  const int val_Rank = 1;
  PyArrayObject *capi_val_tmp = NULL;
  int capi_val_intent = 0;
  double *der = NULL;
  npy_intp der_Dims[1] = {-1};
  const int der_Rank = 1;
  PyArrayObject *capi_der_tmp = NULL;
  int capi_der_intent = 0;
  double *pexp = NULL;
  npy_intp pexp_Dims[1] = {-1};
  const int pexp_Rank = 1;
  PyArrayObject *capi_pexp_tmp = NULL;
  int capi_pexp_intent = 0;
  PyObject *pexp_capi = Py_None;
  int n = 0;
  PyObject *n_capi = Py_None;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"x","pexp","n","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OO|OO:_internal.legefder_vec",\
        capi_kwlist,&x_capi,&pexp_capi,&n_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable x */
  ;
  capi_x_intent |= F2PY_INTENT_IN;
  capi_x_tmp = array_from_pyobj(NPY_DOUBLE,x_Dims,x_Rank,capi_x_intent,x_capi);
  if (capi_x_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 1st argument `x' of _internal.legefder_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    x = (double *)(PyArray_DATA(capi_x_tmp));

  /* Processing variable pexp */
  ;
  capi_pexp_intent |= F2PY_INTENT_IN;
  capi_pexp_tmp = array_from_pyobj(NPY_DOUBLE,pexp_Dims,pexp_Rank,capi_pexp_intent,pexp_capi);
  if (capi_pexp_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `pexp' of _internal.legefder_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    pexp = (double *)(PyArray_DATA(capi_pexp_tmp));

  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = len(x); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.legefder_vec() 2nd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(x)>=nvcount,"len(x)>=nvcount","2nd keyword nvcount","legefder_vec:nvcount=%d",nvcount) {
  /* Processing variable val */
  val_Dims[0]=nvcount;
  capi_val_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_val_tmp = array_from_pyobj(NPY_DOUBLE,val_Dims,val_Rank,capi_val_intent,Py_None);
  if (capi_val_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `val' of _internal.legefder_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    val = (double *)(PyArray_DATA(capi_val_tmp));

  /* Processing variable der */
  der_Dims[0]=nvcount;
  capi_der_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_der_tmp = array_from_pyobj(NPY_DOUBLE,der_Dims,der_Rank,capi_der_intent,Py_None);
  if (capi_der_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `der' of _internal.legefder_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    der = (double *)(PyArray_DATA(capi_der_tmp));

  /* Processing variable n */
  if (n_capi == Py_None) n = (len(pexp)-1); else
    f2py_success = int_from_pyobj(&n,n_capi,"_internal.legefder_vec() 1st keyword (n) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((len(pexp)-1)>=n,"(len(pexp)-1)>=n","1st keyword n","legefder_vec:n=%d",n) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(x,val,der,pexp,&n,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NN",capi_val_tmp,capi_der_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*CHECKSCALAR((len(pexp)-1)>=n)*/
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  }  /*if (capi_der_tmp == NULL) ... else of der*/
  /* End of cleaning variable der */
  }  /*if (capi_val_tmp == NULL) ... else of val*/
  /* End of cleaning variable val */
  } /*CHECKSCALAR(len(x)>=nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  if((PyObject *)capi_pexp_tmp!=pexp_capi) {
    Py_XDECREF(capi_pexp_tmp); }
  }  /*if (capi_pexp_tmp == NULL) ... else of pexp*/
  /* End of cleaning variable pexp */
  if((PyObject *)capi_x_tmp!=x_capi) {
    Py_XDECREF(capi_x_tmp); }
  }  /*if (capi_x_tmp == NULL) ... else of x*/
  /* End of cleaning variable x */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/**************************** end of legefder_vec ****************************/

/***************************** lpotgrad2dall_vec *****************************/
static char doc_f2py_rout__internal_lpotgrad2dall_vec[] = "\
pot,grad,hess = lpotgrad2dall_vec(ifgrad,ifhess,sources,charge,targets,[nsources,nvcount])\n\nWrapper for ``lpotgrad2dall_vec``.\
\n\nParameters\n----------\n"
"ifgrad : input int\n"
"ifhess : input int\n"
"sources : input rank-2 array('d') with bounds (2,nsources)\n"
"charge : input rank-1 array('D') with bounds (nsources)\n"
"targets : input rank-2 array('d') with bounds (2,nvcount)\n"
"\nOther Parameters\n----------------\n"
"nsources : input int, optional\n    Default: shape(sources,1)\n"
"nvcount : input int, optional\n    Default: shape(targets,1)\n"
"\nReturns\n-------\n"
"pot : rank-1 array('D') with bounds (nvcount)\n"
"grad : rank-2 array('D') with bounds (2,nvcount)\n"
"hess : rank-2 array('D') with bounds (3,nvcount)";
/* extern void F_FUNC_US(lpotgrad2dall_vec,LPOTGRAD2DALL_VEC)(int*,int*,double*,complex_double*,int*,double*,complex_double*,complex_double*,complex_double*,int*); */
static PyObject *f2py_rout__internal_lpotgrad2dall_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*,complex_double*,int*,double*,complex_double*,complex_double*,complex_double*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ifgrad = 0;
  PyObject *ifgrad_capi = Py_None;
  int ifhess = 0;
  PyObject *ifhess_capi = Py_None;
  double *sources = NULL;
  npy_intp sources_Dims[2] = {-1, -1};
  const int sources_Rank = 2;
  PyArrayObject *capi_sources_tmp = NULL;
  int capi_sources_intent = 0;
  PyObject *sources_capi = Py_None;
  complex_double *charge = NULL;
  npy_intp charge_Dims[1] = {-1};
  const int charge_Rank = 1;
  PyArrayObject *capi_charge_tmp = NULL;
  int capi_charge_intent = 0;
  PyObject *charge_capi = Py_None;
  int nsources = 0;
  PyObject *nsources_capi = Py_None;
  double *targets = NULL;
  npy_intp targets_Dims[2] = {-1, -1};
  const int targets_Rank = 2;
  PyArrayObject *capi_targets_tmp = NULL;
  int capi_targets_intent = 0;
  PyObject *targets_capi = Py_None;
  complex_double *pot = NULL;
  npy_intp pot_Dims[1] = {-1};
  const int pot_Rank = 1;
  PyArrayObject *capi_pot_tmp = NULL;
  int capi_pot_intent = 0;
  complex_double *grad = NULL;
  npy_intp grad_Dims[2] = {-1, -1};
  const int grad_Rank = 2;
  PyArrayObject *capi_grad_tmp = NULL;
  int capi_grad_intent = 0;
  complex_double *hess = NULL;
  npy_intp hess_Dims[2] = {-1, -1};
  const int hess_Rank = 2;
  PyArrayObject *capi_hess_tmp = NULL;
  int capi_hess_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"ifgrad","ifhess","sources","charge","targets","nsources","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOO|OO:_internal.lpotgrad2dall_vec",\
        capi_kwlist,&ifgrad_capi,&ifhess_capi,&sources_capi,&charge_capi,&targets_capi,&nsources_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable ifgrad */
    f2py_success = int_from_pyobj(&ifgrad,ifgrad_capi,"_internal.lpotgrad2dall_vec() 1st argument (ifgrad) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ifhess */
    f2py_success = int_from_pyobj(&ifhess,ifhess_capi,"_internal.lpotgrad2dall_vec() 2nd argument (ifhess) can't be converted to int");
  if (f2py_success) {
  /* Processing variable sources */
  sources_Dims[0]=2;
  capi_sources_intent |= F2PY_INTENT_IN;
  capi_sources_tmp = array_from_pyobj(NPY_DOUBLE,sources_Dims,sources_Rank,capi_sources_intent,sources_capi);
  if (capi_sources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `sources' of _internal.lpotgrad2dall_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources = (double *)(PyArray_DATA(capi_sources_tmp));

  /* Processing variable targets */
  targets_Dims[0]=2;
  capi_targets_intent |= F2PY_INTENT_IN;
  capi_targets_tmp = array_from_pyobj(NPY_DOUBLE,targets_Dims,targets_Rank,capi_targets_intent,targets_capi);
  if (capi_targets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `targets' of _internal.lpotgrad2dall_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    targets = (double *)(PyArray_DATA(capi_targets_tmp));

  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = shape(targets,1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.lpotgrad2dall_vec() 2nd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(targets,1)==nvcount,"shape(targets,1)==nvcount","2nd keyword nvcount","lpotgrad2dall_vec:nvcount=%d",nvcount) {
  /* Processing variable nsources */
  if (nsources_capi == Py_None) nsources = shape(sources,1); else
    f2py_success = int_from_pyobj(&nsources,nsources_capi,"_internal.lpotgrad2dall_vec() 1st keyword (nsources) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(sources,1)==nsources,"shape(sources,1)==nsources","1st keyword nsources","lpotgrad2dall_vec:nsources=%d",nsources) {
  /* Processing variable pot */
  pot_Dims[0]=nvcount;
  capi_pot_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_pot_tmp = array_from_pyobj(NPY_CDOUBLE,pot_Dims,pot_Rank,capi_pot_intent,Py_None);
  if (capi_pot_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `pot' of _internal.lpotgrad2dall_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    pot = (complex_double *)(PyArray_DATA(capi_pot_tmp));

  /* Processing variable grad */
  grad_Dims[0]=2,grad_Dims[1]=nvcount;
  capi_grad_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_grad_tmp = array_from_pyobj(NPY_CDOUBLE,grad_Dims,grad_Rank,capi_grad_intent,Py_None);
  if (capi_grad_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `grad' of _internal.lpotgrad2dall_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    grad = (complex_double *)(PyArray_DATA(capi_grad_tmp));

  /* Processing variable hess */
  hess_Dims[0]=3,hess_Dims[1]=nvcount;
  capi_hess_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_hess_tmp = array_from_pyobj(NPY_CDOUBLE,hess_Dims,hess_Rank,capi_hess_intent,Py_None);
  if (capi_hess_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `hess' of _internal.lpotgrad2dall_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    hess = (complex_double *)(PyArray_DATA(capi_hess_tmp));

  /* Processing variable charge */
  charge_Dims[0]=nsources;
  capi_charge_intent |= F2PY_INTENT_IN;
  capi_charge_tmp = array_from_pyobj(NPY_CDOUBLE,charge_Dims,charge_Rank,capi_charge_intent,charge_capi);
  if (capi_charge_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `charge' of _internal.lpotgrad2dall_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge = (complex_double *)(PyArray_DATA(capi_charge_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ifgrad,&ifhess,sources,charge,&nsources,targets,pot,grad,hess,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NNN",capi_pot_tmp,capi_grad_tmp,capi_hess_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_charge_tmp!=charge_capi) {
    Py_XDECREF(capi_charge_tmp); }
  }  /*if (capi_charge_tmp == NULL) ... else of charge*/
  /* End of cleaning variable charge */
  }  /*if (capi_hess_tmp == NULL) ... else of hess*/
  /* End of cleaning variable hess */
  }  /*if (capi_grad_tmp == NULL) ... else of grad*/
  /* End of cleaning variable grad */
  }  /*if (capi_pot_tmp == NULL) ... else of pot*/
  /* End of cleaning variable pot */
  } /*CHECKSCALAR(shape(sources,1)==nsources)*/
  } /*if (f2py_success) of nsources*/
  /* End of cleaning variable nsources */
  } /*CHECKSCALAR(shape(targets,1)==nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  if((PyObject *)capi_targets_tmp!=targets_capi) {
    Py_XDECREF(capi_targets_tmp); }
  }  /*if (capi_targets_tmp == NULL) ... else of targets*/
  /* End of cleaning variable targets */
  if((PyObject *)capi_sources_tmp!=sources_capi) {
    Py_XDECREF(capi_sources_tmp); }
  }  /*if (capi_sources_tmp == NULL) ... else of sources*/
  /* End of cleaning variable sources */
  } /*if (f2py_success) of ifhess*/
  /* End of cleaning variable ifhess */
  } /*if (f2py_success) of ifgrad*/
  /* End of cleaning variable ifgrad */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/************************** end of lpotgrad2dall_vec **************************/

/****************************** lpotfld3dall_vec ******************************/
static char doc_f2py_rout__internal_lpotfld3dall_vec[] = "\
pot,fld = lpotfld3dall_vec(iffld,sources,charge,targets,[nsources,nvcount])\n\nWrapper for ``lpotfld3dall_vec``.\
\n\nParameters\n----------\n"
"iffld : input int\n"
"sources : input rank-2 array('d') with bounds (3,nsources)\n"
"charge : input rank-1 array('D') with bounds (nsources)\n"
"targets : input rank-2 array('d') with bounds (3,nvcount)\n"
"\nOther Parameters\n----------------\n"
"nsources : input int, optional\n    Default: shape(sources,1)\n"
"nvcount : input int, optional\n    Default: shape(targets,1)\n"
"\nReturns\n-------\n"
"pot : rank-1 array('D') with bounds (nvcount)\n"
"fld : rank-2 array('D') with bounds (3,nvcount)";
/* extern void F_FUNC_US(lpotfld3dall_vec,LPOTFLD3DALL_VEC)(int*,double*,complex_double*,int*,double*,complex_double*,complex_double*,int*); */
static PyObject *f2py_rout__internal_lpotfld3dall_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,complex_double*,int*,double*,complex_double*,complex_double*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int iffld = 0;
  PyObject *iffld_capi = Py_None;
  double *sources = NULL;
  npy_intp sources_Dims[2] = {-1, -1};
  const int sources_Rank = 2;
  PyArrayObject *capi_sources_tmp = NULL;
  int capi_sources_intent = 0;
  PyObject *sources_capi = Py_None;
  complex_double *charge = NULL;
  npy_intp charge_Dims[1] = {-1};
  const int charge_Rank = 1;
  PyArrayObject *capi_charge_tmp = NULL;
  int capi_charge_intent = 0;
  PyObject *charge_capi = Py_None;
  int nsources = 0;
  PyObject *nsources_capi = Py_None;
  double *targets = NULL;
  npy_intp targets_Dims[2] = {-1, -1};
  const int targets_Rank = 2;
  PyArrayObject *capi_targets_tmp = NULL;
  int capi_targets_intent = 0;
  PyObject *targets_capi = Py_None;
  complex_double *pot = NULL;
  npy_intp pot_Dims[1] = {-1};
  const int pot_Rank = 1;
  PyArrayObject *capi_pot_tmp = NULL;
  int capi_pot_intent = 0;
  complex_double *fld = NULL;
  npy_intp fld_Dims[2] = {-1, -1};
  const int fld_Rank = 2;
  PyArrayObject *capi_fld_tmp = NULL;
  int capi_fld_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"iffld","sources","charge","targets","nsources","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOO|OO:_internal.lpotfld3dall_vec",\
        capi_kwlist,&iffld_capi,&sources_capi,&charge_capi,&targets_capi,&nsources_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable iffld */
    f2py_success = int_from_pyobj(&iffld,iffld_capi,"_internal.lpotfld3dall_vec() 1st argument (iffld) can't be converted to int");
  if (f2py_success) {
  /* Processing variable sources */
  sources_Dims[0]=3;
  capi_sources_intent |= F2PY_INTENT_IN;
  capi_sources_tmp = array_from_pyobj(NPY_DOUBLE,sources_Dims,sources_Rank,capi_sources_intent,sources_capi);
  if (capi_sources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `sources' of _internal.lpotfld3dall_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources = (double *)(PyArray_DATA(capi_sources_tmp));

  /* Processing variable targets */
  targets_Dims[0]=3;
  capi_targets_intent |= F2PY_INTENT_IN;
  capi_targets_tmp = array_from_pyobj(NPY_DOUBLE,targets_Dims,targets_Rank,capi_targets_intent,targets_capi);
  if (capi_targets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `targets' of _internal.lpotfld3dall_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    targets = (double *)(PyArray_DATA(capi_targets_tmp));

  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = shape(targets,1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.lpotfld3dall_vec() 2nd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(targets,1)==nvcount,"shape(targets,1)==nvcount","2nd keyword nvcount","lpotfld3dall_vec:nvcount=%d",nvcount) {
  /* Processing variable nsources */
  if (nsources_capi == Py_None) nsources = shape(sources,1); else
    f2py_success = int_from_pyobj(&nsources,nsources_capi,"_internal.lpotfld3dall_vec() 1st keyword (nsources) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(sources,1)==nsources,"shape(sources,1)==nsources","1st keyword nsources","lpotfld3dall_vec:nsources=%d",nsources) {
  /* Processing variable pot */
  pot_Dims[0]=nvcount;
  capi_pot_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_pot_tmp = array_from_pyobj(NPY_CDOUBLE,pot_Dims,pot_Rank,capi_pot_intent,Py_None);
  if (capi_pot_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `pot' of _internal.lpotfld3dall_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    pot = (complex_double *)(PyArray_DATA(capi_pot_tmp));

  /* Processing variable fld */
  fld_Dims[0]=3,fld_Dims[1]=nvcount;
  capi_fld_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_fld_tmp = array_from_pyobj(NPY_CDOUBLE,fld_Dims,fld_Rank,capi_fld_intent,Py_None);
  if (capi_fld_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `fld' of _internal.lpotfld3dall_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    fld = (complex_double *)(PyArray_DATA(capi_fld_tmp));

  /* Processing variable charge */
  charge_Dims[0]=nsources;
  capi_charge_intent |= F2PY_INTENT_IN;
  capi_charge_tmp = array_from_pyobj(NPY_CDOUBLE,charge_Dims,charge_Rank,capi_charge_intent,charge_capi);
  if (capi_charge_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `charge' of _internal.lpotfld3dall_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge = (complex_double *)(PyArray_DATA(capi_charge_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&iffld,sources,charge,&nsources,targets,pot,fld,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NN",capi_pot_tmp,capi_fld_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_charge_tmp!=charge_capi) {
    Py_XDECREF(capi_charge_tmp); }
  }  /*if (capi_charge_tmp == NULL) ... else of charge*/
  /* End of cleaning variable charge */
  }  /*if (capi_fld_tmp == NULL) ... else of fld*/
  /* End of cleaning variable fld */
  }  /*if (capi_pot_tmp == NULL) ... else of pot*/
  /* End of cleaning variable pot */
  } /*CHECKSCALAR(shape(sources,1)==nsources)*/
  } /*if (f2py_success) of nsources*/
  /* End of cleaning variable nsources */
  } /*CHECKSCALAR(shape(targets,1)==nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  if((PyObject *)capi_targets_tmp!=targets_capi) {
    Py_XDECREF(capi_targets_tmp); }
  }  /*if (capi_targets_tmp == NULL) ... else of targets*/
  /* End of cleaning variable targets */
  if((PyObject *)capi_sources_tmp!=sources_capi) {
    Py_XDECREF(capi_sources_tmp); }
  }  /*if (capi_sources_tmp == NULL) ... else of sources*/
  /* End of cleaning variable sources */
  } /*if (f2py_success) of iffld*/
  /* End of cleaning variable iffld */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/************************** end of lpotfld3dall_vec **************************/

/***************************** hpotgrad2dall_vec *****************************/
static char doc_f2py_rout__internal_hpotgrad2dall_vec[] = "\
pot,grad,hess = hpotgrad2dall_vec(ifgrad,ifhess,sources,charge,targets,zk,[nsources,nvcount])\n\nWrapper for ``hpotgrad2dall_vec``.\
\n\nParameters\n----------\n"
"ifgrad : input int\n"
"ifhess : input int\n"
"sources : input rank-2 array('d') with bounds (2,nsources)\n"
"charge : input rank-1 array('D') with bounds (nsources)\n"
"targets : input rank-2 array('d') with bounds (2,nvcount)\n"
"zk : input complex\n"
"\nOther Parameters\n----------------\n"
"nsources : input int, optional\n    Default: shape(sources,1)\n"
"nvcount : input int, optional\n    Default: shape(targets,1)\n"
"\nReturns\n-------\n"
"pot : rank-1 array('D') with bounds (nvcount)\n"
"grad : rank-2 array('D') with bounds (2,nvcount)\n"
"hess : rank-2 array('D') with bounds (3,nvcount)";
/* extern void F_FUNC_US(hpotgrad2dall_vec,HPOTGRAD2DALL_VEC)(int*,int*,double*,complex_double*,int*,double*,complex_double*,complex_double*,complex_double*,complex_double*,int*); */
static PyObject *f2py_rout__internal_hpotgrad2dall_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*,complex_double*,int*,double*,complex_double*,complex_double*,complex_double*,complex_double*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ifgrad = 0;
  PyObject *ifgrad_capi = Py_None;
  int ifhess = 0;
  PyObject *ifhess_capi = Py_None;
  double *sources = NULL;
  npy_intp sources_Dims[2] = {-1, -1};
  const int sources_Rank = 2;
  PyArrayObject *capi_sources_tmp = NULL;
  int capi_sources_intent = 0;
  PyObject *sources_capi = Py_None;
  complex_double *charge = NULL;
  npy_intp charge_Dims[1] = {-1};
  const int charge_Rank = 1;
  PyArrayObject *capi_charge_tmp = NULL;
  int capi_charge_intent = 0;
  PyObject *charge_capi = Py_None;
  int nsources = 0;
  PyObject *nsources_capi = Py_None;
  double *targets = NULL;
  npy_intp targets_Dims[2] = {-1, -1};
  const int targets_Rank = 2;
  PyArrayObject *capi_targets_tmp = NULL;
  int capi_targets_intent = 0;
  PyObject *targets_capi = Py_None;
  complex_double zk;
  PyObject *zk_capi = Py_None;
  complex_double *pot = NULL;
  npy_intp pot_Dims[1] = {-1};
  const int pot_Rank = 1;
  PyArrayObject *capi_pot_tmp = NULL;
  int capi_pot_intent = 0;
  complex_double *grad = NULL;
  npy_intp grad_Dims[2] = {-1, -1};
  const int grad_Rank = 2;
  PyArrayObject *capi_grad_tmp = NULL;
  int capi_grad_intent = 0;
  complex_double *hess = NULL;
  npy_intp hess_Dims[2] = {-1, -1};
  const int hess_Rank = 2;
  PyArrayObject *capi_hess_tmp = NULL;
  int capi_hess_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"ifgrad","ifhess","sources","charge","targets","zk","nsources","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOO|OO:_internal.hpotgrad2dall_vec",\
        capi_kwlist,&ifgrad_capi,&ifhess_capi,&sources_capi,&charge_capi,&targets_capi,&zk_capi,&nsources_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable ifgrad */
    f2py_success = int_from_pyobj(&ifgrad,ifgrad_capi,"_internal.hpotgrad2dall_vec() 1st argument (ifgrad) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ifhess */
    f2py_success = int_from_pyobj(&ifhess,ifhess_capi,"_internal.hpotgrad2dall_vec() 2nd argument (ifhess) can't be converted to int");
  if (f2py_success) {
  /* Processing variable sources */
  sources_Dims[0]=2;
  capi_sources_intent |= F2PY_INTENT_IN;
  capi_sources_tmp = array_from_pyobj(NPY_DOUBLE,sources_Dims,sources_Rank,capi_sources_intent,sources_capi);
  if (capi_sources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `sources' of _internal.hpotgrad2dall_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources = (double *)(PyArray_DATA(capi_sources_tmp));

  /* Processing variable targets */
  targets_Dims[0]=2;
  capi_targets_intent |= F2PY_INTENT_IN;
  capi_targets_tmp = array_from_pyobj(NPY_DOUBLE,targets_Dims,targets_Rank,capi_targets_intent,targets_capi);
  if (capi_targets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `targets' of _internal.hpotgrad2dall_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    targets = (double *)(PyArray_DATA(capi_targets_tmp));

  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.hpotgrad2dall_vec() 6th argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = shape(targets,1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.hpotgrad2dall_vec() 2nd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(targets,1)==nvcount,"shape(targets,1)==nvcount","2nd keyword nvcount","hpotgrad2dall_vec:nvcount=%d",nvcount) {
  /* Processing variable nsources */
  if (nsources_capi == Py_None) nsources = shape(sources,1); else
    f2py_success = int_from_pyobj(&nsources,nsources_capi,"_internal.hpotgrad2dall_vec() 1st keyword (nsources) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(sources,1)==nsources,"shape(sources,1)==nsources","1st keyword nsources","hpotgrad2dall_vec:nsources=%d",nsources) {
  /* Processing variable pot */
  pot_Dims[0]=nvcount;
  capi_pot_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_pot_tmp = array_from_pyobj(NPY_CDOUBLE,pot_Dims,pot_Rank,capi_pot_intent,Py_None);
  if (capi_pot_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `pot' of _internal.hpotgrad2dall_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    pot = (complex_double *)(PyArray_DATA(capi_pot_tmp));

  /* Processing variable grad */
  grad_Dims[0]=2,grad_Dims[1]=nvcount;
  capi_grad_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_grad_tmp = array_from_pyobj(NPY_CDOUBLE,grad_Dims,grad_Rank,capi_grad_intent,Py_None);
  if (capi_grad_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `grad' of _internal.hpotgrad2dall_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    grad = (complex_double *)(PyArray_DATA(capi_grad_tmp));

  /* Processing variable hess */
  hess_Dims[0]=3,hess_Dims[1]=nvcount;
  capi_hess_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_hess_tmp = array_from_pyobj(NPY_CDOUBLE,hess_Dims,hess_Rank,capi_hess_intent,Py_None);
  if (capi_hess_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `hess' of _internal.hpotgrad2dall_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    hess = (complex_double *)(PyArray_DATA(capi_hess_tmp));

  /* Processing variable charge */
  charge_Dims[0]=nsources;
  capi_charge_intent |= F2PY_INTENT_IN;
  capi_charge_tmp = array_from_pyobj(NPY_CDOUBLE,charge_Dims,charge_Rank,capi_charge_intent,charge_capi);
  if (capi_charge_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `charge' of _internal.hpotgrad2dall_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge = (complex_double *)(PyArray_DATA(capi_charge_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ifgrad,&ifhess,sources,charge,&nsources,targets,&zk,pot,grad,hess,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NNN",capi_pot_tmp,capi_grad_tmp,capi_hess_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_charge_tmp!=charge_capi) {
    Py_XDECREF(capi_charge_tmp); }
  }  /*if (capi_charge_tmp == NULL) ... else of charge*/
  /* End of cleaning variable charge */
  }  /*if (capi_hess_tmp == NULL) ... else of hess*/
  /* End of cleaning variable hess */
  }  /*if (capi_grad_tmp == NULL) ... else of grad*/
  /* End of cleaning variable grad */
  }  /*if (capi_pot_tmp == NULL) ... else of pot*/
  /* End of cleaning variable pot */
  } /*CHECKSCALAR(shape(sources,1)==nsources)*/
  } /*if (f2py_success) of nsources*/
  /* End of cleaning variable nsources */
  } /*CHECKSCALAR(shape(targets,1)==nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
  if((PyObject *)capi_targets_tmp!=targets_capi) {
    Py_XDECREF(capi_targets_tmp); }
  }  /*if (capi_targets_tmp == NULL) ... else of targets*/
  /* End of cleaning variable targets */
  if((PyObject *)capi_sources_tmp!=sources_capi) {
    Py_XDECREF(capi_sources_tmp); }
  }  /*if (capi_sources_tmp == NULL) ... else of sources*/
  /* End of cleaning variable sources */
  } /*if (f2py_success) of ifhess*/
  /* End of cleaning variable ifhess */
  } /*if (f2py_success) of ifgrad*/
  /* End of cleaning variable ifgrad */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/************************** end of hpotgrad2dall_vec **************************/

/****************************** hpotfld3dall_vec ******************************/
static char doc_f2py_rout__internal_hpotfld3dall_vec[] = "\
pot,fld = hpotfld3dall_vec(iffld,sources,charge,targets,zk,[nsources,nvcount])\n\nWrapper for ``hpotfld3dall_vec``.\
\n\nParameters\n----------\n"
"iffld : input int\n"
"sources : input rank-2 array('d') with bounds (3,nsources)\n"
"charge : input rank-1 array('D') with bounds (nsources)\n"
"targets : input rank-2 array('d') with bounds (3,nvcount)\n"
"zk : input complex\n"
"\nOther Parameters\n----------------\n"
"nsources : input int, optional\n    Default: shape(sources,1)\n"
"nvcount : input int, optional\n    Default: shape(targets,1)\n"
"\nReturns\n-------\n"
"pot : rank-1 array('D') with bounds (nvcount)\n"
"fld : rank-2 array('D') with bounds (3,nvcount)";
/* extern void F_FUNC_US(hpotfld3dall_vec,HPOTFLD3DALL_VEC)(int*,double*,complex_double*,int*,double*,complex_double*,complex_double*,complex_double*,int*); */
static PyObject *f2py_rout__internal_hpotfld3dall_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,complex_double*,int*,double*,complex_double*,complex_double*,complex_double*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int iffld = 0;
  PyObject *iffld_capi = Py_None;
  double *sources = NULL;
  npy_intp sources_Dims[2] = {-1, -1};
  const int sources_Rank = 2;
  PyArrayObject *capi_sources_tmp = NULL;
  int capi_sources_intent = 0;
  PyObject *sources_capi = Py_None;
  complex_double *charge = NULL;
  npy_intp charge_Dims[1] = {-1};
  const int charge_Rank = 1;
  PyArrayObject *capi_charge_tmp = NULL;
  int capi_charge_intent = 0;
  PyObject *charge_capi = Py_None;
  int nsources = 0;
  PyObject *nsources_capi = Py_None;
  double *targets = NULL;
  npy_intp targets_Dims[2] = {-1, -1};
  const int targets_Rank = 2;
  PyArrayObject *capi_targets_tmp = NULL;
  int capi_targets_intent = 0;
  PyObject *targets_capi = Py_None;
  complex_double zk;
  PyObject *zk_capi = Py_None;
  complex_double *pot = NULL;
  npy_intp pot_Dims[1] = {-1};
  const int pot_Rank = 1;
  PyArrayObject *capi_pot_tmp = NULL;
  int capi_pot_intent = 0;
  complex_double *fld = NULL;
  npy_intp fld_Dims[2] = {-1, -1};
  const int fld_Rank = 2;
  PyArrayObject *capi_fld_tmp = NULL;
  int capi_fld_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"iffld","sources","charge","targets","zk","nsources","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOO|OO:_internal.hpotfld3dall_vec",\
        capi_kwlist,&iffld_capi,&sources_capi,&charge_capi,&targets_capi,&zk_capi,&nsources_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable iffld */
    f2py_success = int_from_pyobj(&iffld,iffld_capi,"_internal.hpotfld3dall_vec() 1st argument (iffld) can't be converted to int");
  if (f2py_success) {
  /* Processing variable sources */
  sources_Dims[0]=3;
  capi_sources_intent |= F2PY_INTENT_IN;
  capi_sources_tmp = array_from_pyobj(NPY_DOUBLE,sources_Dims,sources_Rank,capi_sources_intent,sources_capi);
  if (capi_sources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `sources' of _internal.hpotfld3dall_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources = (double *)(PyArray_DATA(capi_sources_tmp));

  /* Processing variable targets */
  targets_Dims[0]=3;
  capi_targets_intent |= F2PY_INTENT_IN;
  capi_targets_tmp = array_from_pyobj(NPY_DOUBLE,targets_Dims,targets_Rank,capi_targets_intent,targets_capi);
  if (capi_targets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `targets' of _internal.hpotfld3dall_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    targets = (double *)(PyArray_DATA(capi_targets_tmp));

  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.hpotfld3dall_vec() 5th argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = shape(targets,1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.hpotfld3dall_vec() 2nd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(targets,1)==nvcount,"shape(targets,1)==nvcount","2nd keyword nvcount","hpotfld3dall_vec:nvcount=%d",nvcount) {
  /* Processing variable nsources */
  if (nsources_capi == Py_None) nsources = shape(sources,1); else
    f2py_success = int_from_pyobj(&nsources,nsources_capi,"_internal.hpotfld3dall_vec() 1st keyword (nsources) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(sources,1)==nsources,"shape(sources,1)==nsources","1st keyword nsources","hpotfld3dall_vec:nsources=%d",nsources) {
  /* Processing variable pot */
  pot_Dims[0]=nvcount;
  capi_pot_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_pot_tmp = array_from_pyobj(NPY_CDOUBLE,pot_Dims,pot_Rank,capi_pot_intent,Py_None);
  if (capi_pot_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `pot' of _internal.hpotfld3dall_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    pot = (complex_double *)(PyArray_DATA(capi_pot_tmp));

  /* Processing variable fld */
  fld_Dims[0]=3,fld_Dims[1]=nvcount;
  capi_fld_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_fld_tmp = array_from_pyobj(NPY_CDOUBLE,fld_Dims,fld_Rank,capi_fld_intent,Py_None);
  if (capi_fld_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `fld' of _internal.hpotfld3dall_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    fld = (complex_double *)(PyArray_DATA(capi_fld_tmp));

  /* Processing variable charge */
  charge_Dims[0]=nsources;
  capi_charge_intent |= F2PY_INTENT_IN;
  capi_charge_tmp = array_from_pyobj(NPY_CDOUBLE,charge_Dims,charge_Rank,capi_charge_intent,charge_capi);
  if (capi_charge_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `charge' of _internal.hpotfld3dall_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge = (complex_double *)(PyArray_DATA(capi_charge_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&iffld,sources,charge,&nsources,targets,&zk,pot,fld,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NN",capi_pot_tmp,capi_fld_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_charge_tmp!=charge_capi) {
    Py_XDECREF(capi_charge_tmp); }
  }  /*if (capi_charge_tmp == NULL) ... else of charge*/
  /* End of cleaning variable charge */
  }  /*if (capi_fld_tmp == NULL) ... else of fld*/
  /* End of cleaning variable fld */
  }  /*if (capi_pot_tmp == NULL) ... else of pot*/
  /* End of cleaning variable pot */
  } /*CHECKSCALAR(shape(sources,1)==nsources)*/
  } /*if (f2py_success) of nsources*/
  /* End of cleaning variable nsources */
  } /*CHECKSCALAR(shape(targets,1)==nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
  if((PyObject *)capi_targets_tmp!=targets_capi) {
    Py_XDECREF(capi_targets_tmp); }
  }  /*if (capi_targets_tmp == NULL) ... else of targets*/
  /* End of cleaning variable targets */
  if((PyObject *)capi_sources_tmp!=sources_capi) {
    Py_XDECREF(capi_sources_tmp); }
  }  /*if (capi_sources_tmp == NULL) ... else of sources*/
  /* End of cleaning variable sources */
  } /*if (f2py_success) of iffld*/
  /* End of cleaning variable iffld */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/************************** end of hpotfld3dall_vec **************************/

/**************************** lpotgrad2dall_dp_vec ****************************/
static char doc_f2py_rout__internal_lpotgrad2dall_dp_vec[] = "\
pot,grad,hess = lpotgrad2dall_dp_vec(ifgrad,ifhess,sources,dipstr,targets,[nsources,nvcount])\n\nWrapper for ``lpotgrad2dall_dp_vec``.\
\n\nParameters\n----------\n"
"ifgrad : input int\n"
"ifhess : input int\n"
"sources : input rank-2 array('d') with bounds (2,nsources)\n"
"dipstr : input rank-1 array('D') with bounds (nsources)\n"
"targets : input rank-2 array('d') with bounds (2,nvcount)\n"
"\nOther Parameters\n----------------\n"
"nsources : input int, optional\n    Default: shape(sources,1)\n"
"nvcount : input int, optional\n    Default: shape(targets,1)\n"
"\nReturns\n-------\n"
"pot : rank-1 array('D') with bounds (nvcount)\n"
"grad : rank-2 array('D') with bounds (2,nvcount)\n"
"hess : rank-2 array('D') with bounds (3,nvcount)";
/* extern void F_FUNC_US(lpotgrad2dall_dp_vec,LPOTGRAD2DALL_DP_VEC)(int*,int*,double*,complex_double*,int*,double*,complex_double*,complex_double*,complex_double*,int*); */
static PyObject *f2py_rout__internal_lpotgrad2dall_dp_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*,complex_double*,int*,double*,complex_double*,complex_double*,complex_double*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ifgrad = 0;
  PyObject *ifgrad_capi = Py_None;
  int ifhess = 0;
  PyObject *ifhess_capi = Py_None;
  double *sources = NULL;
  npy_intp sources_Dims[2] = {-1, -1};
  const int sources_Rank = 2;
  PyArrayObject *capi_sources_tmp = NULL;
  int capi_sources_intent = 0;
  PyObject *sources_capi = Py_None;
  complex_double *dipstr = NULL;
  npy_intp dipstr_Dims[1] = {-1};
  const int dipstr_Rank = 1;
  PyArrayObject *capi_dipstr_tmp = NULL;
  int capi_dipstr_intent = 0;
  PyObject *dipstr_capi = Py_None;
  int nsources = 0;
  PyObject *nsources_capi = Py_None;
  double *targets = NULL;
  npy_intp targets_Dims[2] = {-1, -1};
  const int targets_Rank = 2;
  PyArrayObject *capi_targets_tmp = NULL;
  int capi_targets_intent = 0;
  PyObject *targets_capi = Py_None;
  complex_double *pot = NULL;
  npy_intp pot_Dims[1] = {-1};
  const int pot_Rank = 1;
  PyArrayObject *capi_pot_tmp = NULL;
  int capi_pot_intent = 0;
  complex_double *grad = NULL;
  npy_intp grad_Dims[2] = {-1, -1};
  const int grad_Rank = 2;
  PyArrayObject *capi_grad_tmp = NULL;
  int capi_grad_intent = 0;
  complex_double *hess = NULL;
  npy_intp hess_Dims[2] = {-1, -1};
  const int hess_Rank = 2;
  PyArrayObject *capi_hess_tmp = NULL;
  int capi_hess_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"ifgrad","ifhess","sources","dipstr","targets","nsources","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOO|OO:_internal.lpotgrad2dall_dp_vec",\
        capi_kwlist,&ifgrad_capi,&ifhess_capi,&sources_capi,&dipstr_capi,&targets_capi,&nsources_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable ifgrad */
    f2py_success = int_from_pyobj(&ifgrad,ifgrad_capi,"_internal.lpotgrad2dall_dp_vec() 1st argument (ifgrad) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ifhess */
    f2py_success = int_from_pyobj(&ifhess,ifhess_capi,"_internal.lpotgrad2dall_dp_vec() 2nd argument (ifhess) can't be converted to int");
  if (f2py_success) {
  /* Processing variable sources */
  sources_Dims[0]=2;
  capi_sources_intent |= F2PY_INTENT_IN;
  capi_sources_tmp = array_from_pyobj(NPY_DOUBLE,sources_Dims,sources_Rank,capi_sources_intent,sources_capi);
  if (capi_sources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `sources' of _internal.lpotgrad2dall_dp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources = (double *)(PyArray_DATA(capi_sources_tmp));

  /* Processing variable targets */
  targets_Dims[0]=2;
  capi_targets_intent |= F2PY_INTENT_IN;
  capi_targets_tmp = array_from_pyobj(NPY_DOUBLE,targets_Dims,targets_Rank,capi_targets_intent,targets_capi);
  if (capi_targets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `targets' of _internal.lpotgrad2dall_dp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    targets = (double *)(PyArray_DATA(capi_targets_tmp));

  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = shape(targets,1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.lpotgrad2dall_dp_vec() 2nd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(targets,1)==nvcount,"shape(targets,1)==nvcount","2nd keyword nvcount","lpotgrad2dall_dp_vec:nvcount=%d",nvcount) {
  /* Processing variable nsources */
  if (nsources_capi == Py_None) nsources = shape(sources,1); else
    f2py_success = int_from_pyobj(&nsources,nsources_capi,"_internal.lpotgrad2dall_dp_vec() 1st keyword (nsources) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(sources,1)==nsources,"shape(sources,1)==nsources","1st keyword nsources","lpotgrad2dall_dp_vec:nsources=%d",nsources) {
  /* Processing variable pot */
  pot_Dims[0]=nvcount;
  capi_pot_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_pot_tmp = array_from_pyobj(NPY_CDOUBLE,pot_Dims,pot_Rank,capi_pot_intent,Py_None);
  if (capi_pot_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `pot' of _internal.lpotgrad2dall_dp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    pot = (complex_double *)(PyArray_DATA(capi_pot_tmp));

  /* Processing variable grad */
  grad_Dims[0]=2,grad_Dims[1]=nvcount;
  capi_grad_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_grad_tmp = array_from_pyobj(NPY_CDOUBLE,grad_Dims,grad_Rank,capi_grad_intent,Py_None);
  if (capi_grad_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `grad' of _internal.lpotgrad2dall_dp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    grad = (complex_double *)(PyArray_DATA(capi_grad_tmp));

  /* Processing variable hess */
  hess_Dims[0]=3,hess_Dims[1]=nvcount;
  capi_hess_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_hess_tmp = array_from_pyobj(NPY_CDOUBLE,hess_Dims,hess_Rank,capi_hess_intent,Py_None);
  if (capi_hess_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `hess' of _internal.lpotgrad2dall_dp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    hess = (complex_double *)(PyArray_DATA(capi_hess_tmp));

  /* Processing variable dipstr */
  dipstr_Dims[0]=nsources;
  capi_dipstr_intent |= F2PY_INTENT_IN;
  capi_dipstr_tmp = array_from_pyobj(NPY_CDOUBLE,dipstr_Dims,dipstr_Rank,capi_dipstr_intent,dipstr_capi);
  if (capi_dipstr_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `dipstr' of _internal.lpotgrad2dall_dp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr = (complex_double *)(PyArray_DATA(capi_dipstr_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ifgrad,&ifhess,sources,dipstr,&nsources,targets,pot,grad,hess,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NNN",capi_pot_tmp,capi_grad_tmp,capi_hess_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_dipstr_tmp!=dipstr_capi) {
    Py_XDECREF(capi_dipstr_tmp); }
  }  /*if (capi_dipstr_tmp == NULL) ... else of dipstr*/
  /* End of cleaning variable dipstr */
  }  /*if (capi_hess_tmp == NULL) ... else of hess*/
  /* End of cleaning variable hess */
  }  /*if (capi_grad_tmp == NULL) ... else of grad*/
  /* End of cleaning variable grad */
  }  /*if (capi_pot_tmp == NULL) ... else of pot*/
  /* End of cleaning variable pot */
  } /*CHECKSCALAR(shape(sources,1)==nsources)*/
  } /*if (f2py_success) of nsources*/
  /* End of cleaning variable nsources */
  } /*CHECKSCALAR(shape(targets,1)==nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  if((PyObject *)capi_targets_tmp!=targets_capi) {
    Py_XDECREF(capi_targets_tmp); }
  }  /*if (capi_targets_tmp == NULL) ... else of targets*/
  /* End of cleaning variable targets */
  if((PyObject *)capi_sources_tmp!=sources_capi) {
    Py_XDECREF(capi_sources_tmp); }
  }  /*if (capi_sources_tmp == NULL) ... else of sources*/
  /* End of cleaning variable sources */
  } /*if (f2py_success) of ifhess*/
  /* End of cleaning variable ifhess */
  } /*if (f2py_success) of ifgrad*/
  /* End of cleaning variable ifgrad */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/************************ end of lpotgrad2dall_dp_vec ************************/

/**************************** lpotfld3dall_dp_vec ****************************/
static char doc_f2py_rout__internal_lpotfld3dall_dp_vec[] = "\
pot,fld = lpotfld3dall_dp_vec(iffld,sources,dipstr,dipvec,targets,[nsources,nvcount])\n\nWrapper for ``lpotfld3dall_dp_vec``.\
\n\nParameters\n----------\n"
"iffld : input int\n"
"sources : input rank-2 array('d') with bounds (3,nsources)\n"
"dipstr : input rank-1 array('D') with bounds (nsources)\n"
"dipvec : input rank-2 array('d') with bounds (3,nsources)\n"
"targets : input rank-2 array('d') with bounds (3,nvcount)\n"
"\nOther Parameters\n----------------\n"
"nsources : input int, optional\n    Default: shape(sources,1)\n"
"nvcount : input int, optional\n    Default: shape(targets,1)\n"
"\nReturns\n-------\n"
"pot : rank-1 array('D') with bounds (nvcount)\n"
"fld : rank-2 array('D') with bounds (3,nvcount)";
/* extern void F_FUNC_US(lpotfld3dall_dp_vec,LPOTFLD3DALL_DP_VEC)(int*,double*,complex_double*,double*,int*,double*,complex_double*,complex_double*,int*); */
static PyObject *f2py_rout__internal_lpotfld3dall_dp_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,complex_double*,double*,int*,double*,complex_double*,complex_double*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int iffld = 0;
  PyObject *iffld_capi = Py_None;
  double *sources = NULL;
  npy_intp sources_Dims[2] = {-1, -1};
  const int sources_Rank = 2;
  PyArrayObject *capi_sources_tmp = NULL;
  int capi_sources_intent = 0;
  PyObject *sources_capi = Py_None;
  complex_double *dipstr = NULL;
  npy_intp dipstr_Dims[1] = {-1};
  const int dipstr_Rank = 1;
  PyArrayObject *capi_dipstr_tmp = NULL;
  int capi_dipstr_intent = 0;
  PyObject *dipstr_capi = Py_None;
  double *dipvec = NULL;
  npy_intp dipvec_Dims[2] = {-1, -1};
  const int dipvec_Rank = 2;
  PyArrayObject *capi_dipvec_tmp = NULL;
  int capi_dipvec_intent = 0;
  PyObject *dipvec_capi = Py_None;
  int nsources = 0;
  PyObject *nsources_capi = Py_None;
  double *targets = NULL;
  npy_intp targets_Dims[2] = {-1, -1};
  const int targets_Rank = 2;
  PyArrayObject *capi_targets_tmp = NULL;
  int capi_targets_intent = 0;
  PyObject *targets_capi = Py_None;
  complex_double *pot = NULL;
  npy_intp pot_Dims[1] = {-1};
  const int pot_Rank = 1;
  PyArrayObject *capi_pot_tmp = NULL;
  int capi_pot_intent = 0;
  complex_double *fld = NULL;
  npy_intp fld_Dims[2] = {-1, -1};
  const int fld_Rank = 2;
  PyArrayObject *capi_fld_tmp = NULL;
  int capi_fld_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"iffld","sources","dipstr","dipvec","targets","nsources","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOO|OO:_internal.lpotfld3dall_dp_vec",\
        capi_kwlist,&iffld_capi,&sources_capi,&dipstr_capi,&dipvec_capi,&targets_capi,&nsources_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable iffld */
    f2py_success = int_from_pyobj(&iffld,iffld_capi,"_internal.lpotfld3dall_dp_vec() 1st argument (iffld) can't be converted to int");
  if (f2py_success) {
  /* Processing variable sources */
  sources_Dims[0]=3;
  capi_sources_intent |= F2PY_INTENT_IN;
  capi_sources_tmp = array_from_pyobj(NPY_DOUBLE,sources_Dims,sources_Rank,capi_sources_intent,sources_capi);
  if (capi_sources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `sources' of _internal.lpotfld3dall_dp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources = (double *)(PyArray_DATA(capi_sources_tmp));

  /* Processing variable targets */
  targets_Dims[0]=3;
  capi_targets_intent |= F2PY_INTENT_IN;
  capi_targets_tmp = array_from_pyobj(NPY_DOUBLE,targets_Dims,targets_Rank,capi_targets_intent,targets_capi);
  if (capi_targets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `targets' of _internal.lpotfld3dall_dp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    targets = (double *)(PyArray_DATA(capi_targets_tmp));

  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = shape(targets,1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.lpotfld3dall_dp_vec() 2nd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(targets,1)==nvcount,"shape(targets,1)==nvcount","2nd keyword nvcount","lpotfld3dall_dp_vec:nvcount=%d",nvcount) {
  /* Processing variable nsources */
  if (nsources_capi == Py_None) nsources = shape(sources,1); else
    f2py_success = int_from_pyobj(&nsources,nsources_capi,"_internal.lpotfld3dall_dp_vec() 1st keyword (nsources) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(sources,1)==nsources,"shape(sources,1)==nsources","1st keyword nsources","lpotfld3dall_dp_vec:nsources=%d",nsources) {
  /* Processing variable pot */
  pot_Dims[0]=nvcount;
  capi_pot_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_pot_tmp = array_from_pyobj(NPY_CDOUBLE,pot_Dims,pot_Rank,capi_pot_intent,Py_None);
  if (capi_pot_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `pot' of _internal.lpotfld3dall_dp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    pot = (complex_double *)(PyArray_DATA(capi_pot_tmp));

  /* Processing variable fld */
  fld_Dims[0]=3,fld_Dims[1]=nvcount;
  capi_fld_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_fld_tmp = array_from_pyobj(NPY_CDOUBLE,fld_Dims,fld_Rank,capi_fld_intent,Py_None);
  if (capi_fld_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `fld' of _internal.lpotfld3dall_dp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    fld = (complex_double *)(PyArray_DATA(capi_fld_tmp));

  /* Processing variable dipstr */
  dipstr_Dims[0]=nsources;
  capi_dipstr_intent |= F2PY_INTENT_IN;
  capi_dipstr_tmp = array_from_pyobj(NPY_CDOUBLE,dipstr_Dims,dipstr_Rank,capi_dipstr_intent,dipstr_capi);
  if (capi_dipstr_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `dipstr' of _internal.lpotfld3dall_dp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr = (complex_double *)(PyArray_DATA(capi_dipstr_tmp));

  /* Processing variable dipvec */
  dipvec_Dims[0]=3,dipvec_Dims[1]=nsources;
  capi_dipvec_intent |= F2PY_INTENT_IN;
  capi_dipvec_tmp = array_from_pyobj(NPY_DOUBLE,dipvec_Dims,dipvec_Rank,capi_dipvec_intent,dipvec_capi);
  if (capi_dipvec_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `dipvec' of _internal.lpotfld3dall_dp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipvec = (double *)(PyArray_DATA(capi_dipvec_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&iffld,sources,dipstr,dipvec,&nsources,targets,pot,fld,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NN",capi_pot_tmp,capi_fld_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_dipvec_tmp!=dipvec_capi) {
    Py_XDECREF(capi_dipvec_tmp); }
  }  /*if (capi_dipvec_tmp == NULL) ... else of dipvec*/
  /* End of cleaning variable dipvec */
  if((PyObject *)capi_dipstr_tmp!=dipstr_capi) {
    Py_XDECREF(capi_dipstr_tmp); }
  }  /*if (capi_dipstr_tmp == NULL) ... else of dipstr*/
  /* End of cleaning variable dipstr */
  }  /*if (capi_fld_tmp == NULL) ... else of fld*/
  /* End of cleaning variable fld */
  }  /*if (capi_pot_tmp == NULL) ... else of pot*/
  /* End of cleaning variable pot */
  } /*CHECKSCALAR(shape(sources,1)==nsources)*/
  } /*if (f2py_success) of nsources*/
  /* End of cleaning variable nsources */
  } /*CHECKSCALAR(shape(targets,1)==nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  if((PyObject *)capi_targets_tmp!=targets_capi) {
    Py_XDECREF(capi_targets_tmp); }
  }  /*if (capi_targets_tmp == NULL) ... else of targets*/
  /* End of cleaning variable targets */
  if((PyObject *)capi_sources_tmp!=sources_capi) {
    Py_XDECREF(capi_sources_tmp); }
  }  /*if (capi_sources_tmp == NULL) ... else of sources*/
  /* End of cleaning variable sources */
  } /*if (f2py_success) of iffld*/
  /* End of cleaning variable iffld */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/************************* end of lpotfld3dall_dp_vec *************************/

/**************************** hpotgrad2dall_dp_vec ****************************/
static char doc_f2py_rout__internal_hpotgrad2dall_dp_vec[] = "\
pot,grad,hess = hpotgrad2dall_dp_vec(ifgrad,ifhess,sources,dipstr,dipvec,targets,zk,[nsources,nvcount])\n\nWrapper for ``hpotgrad2dall_dp_vec``.\
\n\nParameters\n----------\n"
"ifgrad : input int\n"
"ifhess : input int\n"
"sources : input rank-2 array('d') with bounds (2,nsources)\n"
"dipstr : input rank-1 array('D') with bounds (nsources)\n"
"dipvec : input rank-2 array('d') with bounds (2,nsources)\n"
"targets : input rank-2 array('d') with bounds (2,nvcount)\n"
"zk : input complex\n"
"\nOther Parameters\n----------------\n"
"nsources : input int, optional\n    Default: shape(sources,1)\n"
"nvcount : input int, optional\n    Default: shape(targets,1)\n"
"\nReturns\n-------\n"
"pot : rank-1 array('D') with bounds (nvcount)\n"
"grad : rank-2 array('D') with bounds (2,nvcount)\n"
"hess : rank-2 array('D') with bounds (3,nvcount)";
/* extern void F_FUNC_US(hpotgrad2dall_dp_vec,HPOTGRAD2DALL_DP_VEC)(int*,int*,double*,complex_double*,double*,int*,double*,complex_double*,complex_double*,complex_double*,complex_double*,int*); */
static PyObject *f2py_rout__internal_hpotgrad2dall_dp_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*,complex_double*,double*,int*,double*,complex_double*,complex_double*,complex_double*,complex_double*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ifgrad = 0;
  PyObject *ifgrad_capi = Py_None;
  int ifhess = 0;
  PyObject *ifhess_capi = Py_None;
  double *sources = NULL;
  npy_intp sources_Dims[2] = {-1, -1};
  const int sources_Rank = 2;
  PyArrayObject *capi_sources_tmp = NULL;
  int capi_sources_intent = 0;
  PyObject *sources_capi = Py_None;
  complex_double *dipstr = NULL;
  npy_intp dipstr_Dims[1] = {-1};
  const int dipstr_Rank = 1;
  PyArrayObject *capi_dipstr_tmp = NULL;
  int capi_dipstr_intent = 0;
  PyObject *dipstr_capi = Py_None;
  double *dipvec = NULL;
  npy_intp dipvec_Dims[2] = {-1, -1};
  const int dipvec_Rank = 2;
  PyArrayObject *capi_dipvec_tmp = NULL;
  int capi_dipvec_intent = 0;
  PyObject *dipvec_capi = Py_None;
  int nsources = 0;
  PyObject *nsources_capi = Py_None;
  double *targets = NULL;
  npy_intp targets_Dims[2] = {-1, -1};
  const int targets_Rank = 2;
  PyArrayObject *capi_targets_tmp = NULL;
  int capi_targets_intent = 0;
  PyObject *targets_capi = Py_None;
  complex_double zk;
  PyObject *zk_capi = Py_None;
  complex_double *pot = NULL;
  npy_intp pot_Dims[1] = {-1};
  const int pot_Rank = 1;
  PyArrayObject *capi_pot_tmp = NULL;
  int capi_pot_intent = 0;
  complex_double *grad = NULL;
  npy_intp grad_Dims[2] = {-1, -1};
  const int grad_Rank = 2;
  PyArrayObject *capi_grad_tmp = NULL;
  int capi_grad_intent = 0;
  complex_double *hess = NULL;
  npy_intp hess_Dims[2] = {-1, -1};
  const int hess_Rank = 2;
  PyArrayObject *capi_hess_tmp = NULL;
  int capi_hess_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"ifgrad","ifhess","sources","dipstr","dipvec","targets","zk","nsources","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOO|OO:_internal.hpotgrad2dall_dp_vec",\
        capi_kwlist,&ifgrad_capi,&ifhess_capi,&sources_capi,&dipstr_capi,&dipvec_capi,&targets_capi,&zk_capi,&nsources_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable ifgrad */
    f2py_success = int_from_pyobj(&ifgrad,ifgrad_capi,"_internal.hpotgrad2dall_dp_vec() 1st argument (ifgrad) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ifhess */
    f2py_success = int_from_pyobj(&ifhess,ifhess_capi,"_internal.hpotgrad2dall_dp_vec() 2nd argument (ifhess) can't be converted to int");
  if (f2py_success) {
  /* Processing variable sources */
  sources_Dims[0]=2;
  capi_sources_intent |= F2PY_INTENT_IN;
  capi_sources_tmp = array_from_pyobj(NPY_DOUBLE,sources_Dims,sources_Rank,capi_sources_intent,sources_capi);
  if (capi_sources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `sources' of _internal.hpotgrad2dall_dp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources = (double *)(PyArray_DATA(capi_sources_tmp));

  /* Processing variable targets */
  targets_Dims[0]=2;
  capi_targets_intent |= F2PY_INTENT_IN;
  capi_targets_tmp = array_from_pyobj(NPY_DOUBLE,targets_Dims,targets_Rank,capi_targets_intent,targets_capi);
  if (capi_targets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `targets' of _internal.hpotgrad2dall_dp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    targets = (double *)(PyArray_DATA(capi_targets_tmp));

  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.hpotgrad2dall_dp_vec() 7th argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = shape(targets,1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.hpotgrad2dall_dp_vec() 2nd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(targets,1)==nvcount,"shape(targets,1)==nvcount","2nd keyword nvcount","hpotgrad2dall_dp_vec:nvcount=%d",nvcount) {
  /* Processing variable nsources */
  if (nsources_capi == Py_None) nsources = shape(sources,1); else
    f2py_success = int_from_pyobj(&nsources,nsources_capi,"_internal.hpotgrad2dall_dp_vec() 1st keyword (nsources) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(sources,1)==nsources,"shape(sources,1)==nsources","1st keyword nsources","hpotgrad2dall_dp_vec:nsources=%d",nsources) {
  /* Processing variable pot */
  pot_Dims[0]=nvcount;
  capi_pot_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_pot_tmp = array_from_pyobj(NPY_CDOUBLE,pot_Dims,pot_Rank,capi_pot_intent,Py_None);
  if (capi_pot_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `pot' of _internal.hpotgrad2dall_dp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    pot = (complex_double *)(PyArray_DATA(capi_pot_tmp));

  /* Processing variable grad */
  grad_Dims[0]=2,grad_Dims[1]=nvcount;
  capi_grad_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_grad_tmp = array_from_pyobj(NPY_CDOUBLE,grad_Dims,grad_Rank,capi_grad_intent,Py_None);
  if (capi_grad_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `grad' of _internal.hpotgrad2dall_dp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    grad = (complex_double *)(PyArray_DATA(capi_grad_tmp));

  /* Processing variable hess */
  hess_Dims[0]=3,hess_Dims[1]=nvcount;
  capi_hess_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_hess_tmp = array_from_pyobj(NPY_CDOUBLE,hess_Dims,hess_Rank,capi_hess_intent,Py_None);
  if (capi_hess_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `hess' of _internal.hpotgrad2dall_dp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    hess = (complex_double *)(PyArray_DATA(capi_hess_tmp));

  /* Processing variable dipstr */
  dipstr_Dims[0]=nsources;
  capi_dipstr_intent |= F2PY_INTENT_IN;
  capi_dipstr_tmp = array_from_pyobj(NPY_CDOUBLE,dipstr_Dims,dipstr_Rank,capi_dipstr_intent,dipstr_capi);
  if (capi_dipstr_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `dipstr' of _internal.hpotgrad2dall_dp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr = (complex_double *)(PyArray_DATA(capi_dipstr_tmp));

  /* Processing variable dipvec */
  dipvec_Dims[0]=2,dipvec_Dims[1]=nsources;
  capi_dipvec_intent |= F2PY_INTENT_IN;
  capi_dipvec_tmp = array_from_pyobj(NPY_DOUBLE,dipvec_Dims,dipvec_Rank,capi_dipvec_intent,dipvec_capi);
  if (capi_dipvec_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `dipvec' of _internal.hpotgrad2dall_dp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipvec = (double *)(PyArray_DATA(capi_dipvec_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ifgrad,&ifhess,sources,dipstr,dipvec,&nsources,targets,&zk,pot,grad,hess,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NNN",capi_pot_tmp,capi_grad_tmp,capi_hess_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_dipvec_tmp!=dipvec_capi) {
    Py_XDECREF(capi_dipvec_tmp); }
  }  /*if (capi_dipvec_tmp == NULL) ... else of dipvec*/
  /* End of cleaning variable dipvec */
  if((PyObject *)capi_dipstr_tmp!=dipstr_capi) {
    Py_XDECREF(capi_dipstr_tmp); }
  }  /*if (capi_dipstr_tmp == NULL) ... else of dipstr*/
  /* End of cleaning variable dipstr */
  }  /*if (capi_hess_tmp == NULL) ... else of hess*/
  /* End of cleaning variable hess */
  }  /*if (capi_grad_tmp == NULL) ... else of grad*/
  /* End of cleaning variable grad */
  }  /*if (capi_pot_tmp == NULL) ... else of pot*/
  /* End of cleaning variable pot */
  } /*CHECKSCALAR(shape(sources,1)==nsources)*/
  } /*if (f2py_success) of nsources*/
  /* End of cleaning variable nsources */
  } /*CHECKSCALAR(shape(targets,1)==nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
  if((PyObject *)capi_targets_tmp!=targets_capi) {
    Py_XDECREF(capi_targets_tmp); }
  }  /*if (capi_targets_tmp == NULL) ... else of targets*/
  /* End of cleaning variable targets */
  if((PyObject *)capi_sources_tmp!=sources_capi) {
    Py_XDECREF(capi_sources_tmp); }
  }  /*if (capi_sources_tmp == NULL) ... else of sources*/
  /* End of cleaning variable sources */
  } /*if (f2py_success) of ifhess*/
  /* End of cleaning variable ifhess */
  } /*if (f2py_success) of ifgrad*/
  /* End of cleaning variable ifgrad */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/************************ end of hpotgrad2dall_dp_vec ************************/

/**************************** hpotfld3dall_dp_vec ****************************/
static char doc_f2py_rout__internal_hpotfld3dall_dp_vec[] = "\
pot,fld = hpotfld3dall_dp_vec(iffld,sources,dipstr,dipvec,targets,zk,[nsources,nvcount])\n\nWrapper for ``hpotfld3dall_dp_vec``.\
\n\nParameters\n----------\n"
"iffld : input int\n"
"sources : input rank-2 array('d') with bounds (3,nsources)\n"
"dipstr : input rank-1 array('D') with bounds (nsources)\n"
"dipvec : input rank-2 array('d') with bounds (3,nsources)\n"
"targets : input rank-2 array('d') with bounds (3,nvcount)\n"
"zk : input complex\n"
"\nOther Parameters\n----------------\n"
"nsources : input int, optional\n    Default: shape(sources,1)\n"
"nvcount : input int, optional\n    Default: shape(targets,1)\n"
"\nReturns\n-------\n"
"pot : rank-1 array('D') with bounds (nvcount)\n"
"fld : rank-2 array('D') with bounds (3,nvcount)";
/* extern void F_FUNC_US(hpotfld3dall_dp_vec,HPOTFLD3DALL_DP_VEC)(int*,double*,complex_double*,double*,int*,double*,complex_double*,complex_double*,complex_double*,int*); */
static PyObject *f2py_rout__internal_hpotfld3dall_dp_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,complex_double*,double*,int*,double*,complex_double*,complex_double*,complex_double*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int iffld = 0;
  PyObject *iffld_capi = Py_None;
  double *sources = NULL;
  npy_intp sources_Dims[2] = {-1, -1};
  const int sources_Rank = 2;
  PyArrayObject *capi_sources_tmp = NULL;
  int capi_sources_intent = 0;
  PyObject *sources_capi = Py_None;
  complex_double *dipstr = NULL;
  npy_intp dipstr_Dims[1] = {-1};
  const int dipstr_Rank = 1;
  PyArrayObject *capi_dipstr_tmp = NULL;
  int capi_dipstr_intent = 0;
  PyObject *dipstr_capi = Py_None;
  double *dipvec = NULL;
  npy_intp dipvec_Dims[2] = {-1, -1};
  const int dipvec_Rank = 2;
  PyArrayObject *capi_dipvec_tmp = NULL;
  int capi_dipvec_intent = 0;
  PyObject *dipvec_capi = Py_None;
  int nsources = 0;
  PyObject *nsources_capi = Py_None;
  double *targets = NULL;
  npy_intp targets_Dims[2] = {-1, -1};
  const int targets_Rank = 2;
  PyArrayObject *capi_targets_tmp = NULL;
  int capi_targets_intent = 0;
  PyObject *targets_capi = Py_None;
  complex_double zk;
  PyObject *zk_capi = Py_None;
  complex_double *pot = NULL;
  npy_intp pot_Dims[1] = {-1};
  const int pot_Rank = 1;
  PyArrayObject *capi_pot_tmp = NULL;
  int capi_pot_intent = 0;
  complex_double *fld = NULL;
  npy_intp fld_Dims[2] = {-1, -1};
  const int fld_Rank = 2;
  PyArrayObject *capi_fld_tmp = NULL;
  int capi_fld_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"iffld","sources","dipstr","dipvec","targets","zk","nsources","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOO|OO:_internal.hpotfld3dall_dp_vec",\
        capi_kwlist,&iffld_capi,&sources_capi,&dipstr_capi,&dipvec_capi,&targets_capi,&zk_capi,&nsources_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable iffld */
    f2py_success = int_from_pyobj(&iffld,iffld_capi,"_internal.hpotfld3dall_dp_vec() 1st argument (iffld) can't be converted to int");
  if (f2py_success) {
  /* Processing variable sources */
  sources_Dims[0]=3;
  capi_sources_intent |= F2PY_INTENT_IN;
  capi_sources_tmp = array_from_pyobj(NPY_DOUBLE,sources_Dims,sources_Rank,capi_sources_intent,sources_capi);
  if (capi_sources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `sources' of _internal.hpotfld3dall_dp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources = (double *)(PyArray_DATA(capi_sources_tmp));

  /* Processing variable targets */
  targets_Dims[0]=3;
  capi_targets_intent |= F2PY_INTENT_IN;
  capi_targets_tmp = array_from_pyobj(NPY_DOUBLE,targets_Dims,targets_Rank,capi_targets_intent,targets_capi);
  if (capi_targets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `targets' of _internal.hpotfld3dall_dp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    targets = (double *)(PyArray_DATA(capi_targets_tmp));

  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.hpotfld3dall_dp_vec() 6th argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = shape(targets,1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.hpotfld3dall_dp_vec() 2nd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(targets,1)==nvcount,"shape(targets,1)==nvcount","2nd keyword nvcount","hpotfld3dall_dp_vec:nvcount=%d",nvcount) {
  /* Processing variable nsources */
  if (nsources_capi == Py_None) nsources = shape(sources,1); else
    f2py_success = int_from_pyobj(&nsources,nsources_capi,"_internal.hpotfld3dall_dp_vec() 1st keyword (nsources) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(sources,1)==nsources,"shape(sources,1)==nsources","1st keyword nsources","hpotfld3dall_dp_vec:nsources=%d",nsources) {
  /* Processing variable pot */
  pot_Dims[0]=nvcount;
  capi_pot_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_pot_tmp = array_from_pyobj(NPY_CDOUBLE,pot_Dims,pot_Rank,capi_pot_intent,Py_None);
  if (capi_pot_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `pot' of _internal.hpotfld3dall_dp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    pot = (complex_double *)(PyArray_DATA(capi_pot_tmp));

  /* Processing variable fld */
  fld_Dims[0]=3,fld_Dims[1]=nvcount;
  capi_fld_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_fld_tmp = array_from_pyobj(NPY_CDOUBLE,fld_Dims,fld_Rank,capi_fld_intent,Py_None);
  if (capi_fld_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `fld' of _internal.hpotfld3dall_dp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    fld = (complex_double *)(PyArray_DATA(capi_fld_tmp));

  /* Processing variable dipstr */
  dipstr_Dims[0]=nsources;
  capi_dipstr_intent |= F2PY_INTENT_IN;
  capi_dipstr_tmp = array_from_pyobj(NPY_CDOUBLE,dipstr_Dims,dipstr_Rank,capi_dipstr_intent,dipstr_capi);
  if (capi_dipstr_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `dipstr' of _internal.hpotfld3dall_dp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr = (complex_double *)(PyArray_DATA(capi_dipstr_tmp));

  /* Processing variable dipvec */
  dipvec_Dims[0]=3,dipvec_Dims[1]=nsources;
  capi_dipvec_intent |= F2PY_INTENT_IN;
  capi_dipvec_tmp = array_from_pyobj(NPY_DOUBLE,dipvec_Dims,dipvec_Rank,capi_dipvec_intent,dipvec_capi);
  if (capi_dipvec_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `dipvec' of _internal.hpotfld3dall_dp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipvec = (double *)(PyArray_DATA(capi_dipvec_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&iffld,sources,dipstr,dipvec,&nsources,targets,&zk,pot,fld,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NN",capi_pot_tmp,capi_fld_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_dipvec_tmp!=dipvec_capi) {
    Py_XDECREF(capi_dipvec_tmp); }
  }  /*if (capi_dipvec_tmp == NULL) ... else of dipvec*/
  /* End of cleaning variable dipvec */
  if((PyObject *)capi_dipstr_tmp!=dipstr_capi) {
    Py_XDECREF(capi_dipstr_tmp); }
  }  /*if (capi_dipstr_tmp == NULL) ... else of dipstr*/
  /* End of cleaning variable dipstr */
  }  /*if (capi_fld_tmp == NULL) ... else of fld*/
  /* End of cleaning variable fld */
  }  /*if (capi_pot_tmp == NULL) ... else of pot*/
  /* End of cleaning variable pot */
  } /*CHECKSCALAR(shape(sources,1)==nsources)*/
  } /*if (f2py_success) of nsources*/
  /* End of cleaning variable nsources */
  } /*CHECKSCALAR(shape(targets,1)==nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
  if((PyObject *)capi_targets_tmp!=targets_capi) {
    Py_XDECREF(capi_targets_tmp); }
  }  /*if (capi_targets_tmp == NULL) ... else of targets*/
  /* End of cleaning variable targets */
  if((PyObject *)capi_sources_tmp!=sources_capi) {
    Py_XDECREF(capi_sources_tmp); }
  }  /*if (capi_sources_tmp == NULL) ... else of sources*/
  /* End of cleaning variable sources */
  } /*if (f2py_success) of iffld*/
  /* End of cleaning variable iffld */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/************************* end of hpotfld3dall_dp_vec *************************/

/****************************** l2dformta_imany ******************************/
static char doc_f2py_rout__internal_l2dformta_imany[] = "\
ier,expn = l2dformta_imany(rscale,sources,sources_offsets,sources_starts,charge,charge_offsets,charge_starts,nsources,nsources_offsets,nsources_starts,centers,centers_offsets,nterms,[nvcount])\n\nWrapper for ``l2dformta_imany``.\
\n\nParameters\n----------\n"
"rscale : input float\n"
"sources : input rank-2 array('d') with bounds (2,*)\n"
"sources_offsets : input rank-1 array('i') with bounds (*)\n"
"sources_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"charge : input rank-1 array('D') with bounds (*)\n"
"charge_offsets : input rank-1 array('i') with bounds (*)\n"
"charge_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"nsources : input rank-1 array('i') with bounds (*)\n"
"nsources_offsets : input rank-1 array('i') with bounds (*)\n"
"nsources_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"centers : input rank-2 array('d') with bounds (2,*)\n"
"centers_offsets : input rank-1 array('i') with bounds (nvcount)\n"
"nterms : input int\n"
"\nOther Parameters\n----------------\n"
"nvcount : input int, optional\n    Default: (len(sources_starts)-1)\n"
"\nReturns\n-------\n"
"ier : rank-1 array('i') with bounds (nvcount)\n"
"expn : rank-2 array('D') with bounds (nterms + 1,nvcount)";
/* extern void F_FUNC_US(l2dformta_imany,L2DFORMTA_IMANY)(int*,double*,double*,int*,int*,complex_double*,int*,int*,int*,int*,int*,double*,int*,int*,complex_double*,int*); */
static PyObject *f2py_rout__internal_l2dformta_imany(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*,int*,int*,complex_double*,int*,int*,int*,int*,int*,double*,int*,int*,complex_double*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int *ier = NULL;
  npy_intp ier_Dims[1] = {-1};
  const int ier_Rank = 1;
  PyArrayObject *capi_ier_tmp = NULL;
  int capi_ier_intent = 0;
  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *sources = NULL;
  npy_intp sources_Dims[2] = {-1, -1};
  const int sources_Rank = 2;
  PyArrayObject *capi_sources_tmp = NULL;
  int capi_sources_intent = 0;
  PyObject *sources_capi = Py_None;
  int *sources_offsets = NULL;
  npy_intp sources_offsets_Dims[1] = {-1};
  const int sources_offsets_Rank = 1;
  PyArrayObject *capi_sources_offsets_tmp = NULL;
  int capi_sources_offsets_intent = 0;
  PyObject *sources_offsets_capi = Py_None;
  int *sources_starts = NULL;
  npy_intp sources_starts_Dims[1] = {-1};
  const int sources_starts_Rank = 1;
  PyArrayObject *capi_sources_starts_tmp = NULL;
  int capi_sources_starts_intent = 0;
  PyObject *sources_starts_capi = Py_None;
  complex_double *charge = NULL;
  npy_intp charge_Dims[1] = {-1};
  const int charge_Rank = 1;
  PyArrayObject *capi_charge_tmp = NULL;
  int capi_charge_intent = 0;
  PyObject *charge_capi = Py_None;
  int *charge_offsets = NULL;
  npy_intp charge_offsets_Dims[1] = {-1};
  const int charge_offsets_Rank = 1;
  PyArrayObject *capi_charge_offsets_tmp = NULL;
  int capi_charge_offsets_intent = 0;
  PyObject *charge_offsets_capi = Py_None;
  int *charge_starts = NULL;
  npy_intp charge_starts_Dims[1] = {-1};
  const int charge_starts_Rank = 1;
  PyArrayObject *capi_charge_starts_tmp = NULL;
  int capi_charge_starts_intent = 0;
  PyObject *charge_starts_capi = Py_None;
  int *nsources = NULL;
  npy_intp nsources_Dims[1] = {-1};
  const int nsources_Rank = 1;
  PyArrayObject *capi_nsources_tmp = NULL;
  int capi_nsources_intent = 0;
  PyObject *nsources_capi = Py_None;
  int *nsources_offsets = NULL;
  npy_intp nsources_offsets_Dims[1] = {-1};
  const int nsources_offsets_Rank = 1;
  PyArrayObject *capi_nsources_offsets_tmp = NULL;
  int capi_nsources_offsets_intent = 0;
  PyObject *nsources_offsets_capi = Py_None;
  int *nsources_starts = NULL;
  npy_intp nsources_starts_Dims[1] = {-1};
  const int nsources_starts_Rank = 1;
  PyArrayObject *capi_nsources_starts_tmp = NULL;
  int capi_nsources_starts_intent = 0;
  PyObject *nsources_starts_capi = Py_None;
  double *centers = NULL;
  npy_intp centers_Dims[2] = {-1, -1};
  const int centers_Rank = 2;
  PyArrayObject *capi_centers_tmp = NULL;
  int capi_centers_intent = 0;
  PyObject *centers_capi = Py_None;
  int *centers_offsets = NULL;
  npy_intp centers_offsets_Dims[1] = {-1};
  const int centers_offsets_Rank = 1;
  PyArrayObject *capi_centers_offsets_tmp = NULL;
  int capi_centers_offsets_intent = 0;
  PyObject *centers_offsets_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[2] = {-1, -1};
  const int expn_Rank = 2;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"rscale","sources","sources_offsets","sources_starts","charge","charge_offsets","charge_starts","nsources","nsources_offsets","nsources_starts","centers","centers_offsets","nterms","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOOOOO|O:_internal.l2dformta_imany",\
        capi_kwlist,&rscale_capi,&sources_capi,&sources_offsets_capi,&sources_starts_capi,&charge_capi,&charge_offsets_capi,&charge_starts_capi,&nsources_capi,&nsources_offsets_capi,&nsources_starts_capi,&centers_capi,&centers_offsets_capi,&nterms_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.l2dformta_imany() 1st argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable sources */
  sources_Dims[0]=2;
  capi_sources_intent |= F2PY_INTENT_IN;
  capi_sources_tmp = array_from_pyobj(NPY_DOUBLE,sources_Dims,sources_Rank,capi_sources_intent,sources_capi);
  if (capi_sources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `sources' of _internal.l2dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources = (double *)(PyArray_DATA(capi_sources_tmp));

  /* Processing variable sources_offsets */
  ;
  capi_sources_offsets_intent |= F2PY_INTENT_IN;
  capi_sources_offsets_tmp = array_from_pyobj(NPY_INT,sources_offsets_Dims,sources_offsets_Rank,capi_sources_offsets_intent,sources_offsets_capi);
  if (capi_sources_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `sources_offsets' of _internal.l2dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources_offsets = (int *)(PyArray_DATA(capi_sources_offsets_tmp));

  /* Processing variable sources_starts */
  ;
  capi_sources_starts_intent |= F2PY_INTENT_IN;
  capi_sources_starts_tmp = array_from_pyobj(NPY_INT,sources_starts_Dims,sources_starts_Rank,capi_sources_starts_intent,sources_starts_capi);
  if (capi_sources_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `sources_starts' of _internal.l2dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources_starts = (int *)(PyArray_DATA(capi_sources_starts_tmp));

  /* Processing variable charge */
  ;
  capi_charge_intent |= F2PY_INTENT_IN;
  capi_charge_tmp = array_from_pyobj(NPY_CDOUBLE,charge_Dims,charge_Rank,capi_charge_intent,charge_capi);
  if (capi_charge_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `charge' of _internal.l2dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge = (complex_double *)(PyArray_DATA(capi_charge_tmp));

  /* Processing variable charge_offsets */
  ;
  capi_charge_offsets_intent |= F2PY_INTENT_IN;
  capi_charge_offsets_tmp = array_from_pyobj(NPY_INT,charge_offsets_Dims,charge_offsets_Rank,capi_charge_offsets_intent,charge_offsets_capi);
  if (capi_charge_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `charge_offsets' of _internal.l2dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge_offsets = (int *)(PyArray_DATA(capi_charge_offsets_tmp));

  /* Processing variable nsources */
  ;
  capi_nsources_intent |= F2PY_INTENT_IN;
  capi_nsources_tmp = array_from_pyobj(NPY_INT,nsources_Dims,nsources_Rank,capi_nsources_intent,nsources_capi);
  if (capi_nsources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 8th argument `nsources' of _internal.l2dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    nsources = (int *)(PyArray_DATA(capi_nsources_tmp));

  /* Processing variable nsources_offsets */
  ;
  capi_nsources_offsets_intent |= F2PY_INTENT_IN;
  capi_nsources_offsets_tmp = array_from_pyobj(NPY_INT,nsources_offsets_Dims,nsources_offsets_Rank,capi_nsources_offsets_intent,nsources_offsets_capi);
  if (capi_nsources_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 9th argument `nsources_offsets' of _internal.l2dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    nsources_offsets = (int *)(PyArray_DATA(capi_nsources_offsets_tmp));

  /* Processing variable centers */
  centers_Dims[0]=2;
  capi_centers_intent |= F2PY_INTENT_IN;
  capi_centers_tmp = array_from_pyobj(NPY_DOUBLE,centers_Dims,centers_Rank,capi_centers_intent,centers_capi);
  if (capi_centers_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 11st argument `centers' of _internal.l2dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    centers = (double *)(PyArray_DATA(capi_centers_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.l2dformta_imany() 13rd argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = (len(sources_starts)-1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.l2dformta_imany() 1st keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((len(sources_starts)-1)>=nvcount,"(len(sources_starts)-1)>=nvcount","1st keyword nvcount","l2dformta_imany:nvcount=%d",nvcount) {
  /* Processing variable ier */
  ier_Dims[0]=nvcount;
  capi_ier_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_ier_tmp = array_from_pyobj(NPY_INT,ier_Dims,ier_Rank,capi_ier_intent,Py_None);
  if (capi_ier_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `ier' of _internal.l2dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ier = (int *)(PyArray_DATA(capi_ier_tmp));

  /* Processing variable charge_starts */
  charge_starts_Dims[0]=nvcount + 1;
  capi_charge_starts_intent |= F2PY_INTENT_IN;
  capi_charge_starts_tmp = array_from_pyobj(NPY_INT,charge_starts_Dims,charge_starts_Rank,capi_charge_starts_intent,charge_starts_capi);
  if (capi_charge_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 7th argument `charge_starts' of _internal.l2dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge_starts = (int *)(PyArray_DATA(capi_charge_starts_tmp));

  /* Processing variable nsources_starts */
  nsources_starts_Dims[0]=nvcount + 1;
  capi_nsources_starts_intent |= F2PY_INTENT_IN;
  capi_nsources_starts_tmp = array_from_pyobj(NPY_INT,nsources_starts_Dims,nsources_starts_Rank,capi_nsources_starts_intent,nsources_starts_capi);
  if (capi_nsources_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 10th argument `nsources_starts' of _internal.l2dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    nsources_starts = (int *)(PyArray_DATA(capi_nsources_starts_tmp));

  /* Processing variable centers_offsets */
  centers_offsets_Dims[0]=nvcount;
  capi_centers_offsets_intent |= F2PY_INTENT_IN;
  capi_centers_offsets_tmp = array_from_pyobj(NPY_INT,centers_offsets_Dims,centers_offsets_Rank,capi_centers_offsets_intent,centers_offsets_capi);
  if (capi_centers_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 12nd argument `centers_offsets' of _internal.l2dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    centers_offsets = (int *)(PyArray_DATA(capi_centers_offsets_tmp));

  /* Processing variable expn */
  expn_Dims[0]=nterms + 1,expn_Dims[1]=nvcount;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.l2dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(ier,&rscale,sources,sources_offsets,sources_starts,charge,charge_offsets,charge_starts,nsources,nsources_offsets,nsources_starts,centers,centers_offsets,&nterms,expn,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NN",capi_ier_tmp,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  if((PyObject *)capi_centers_offsets_tmp!=centers_offsets_capi) {
    Py_XDECREF(capi_centers_offsets_tmp); }
  }  /*if (capi_centers_offsets_tmp == NULL) ... else of centers_offsets*/
  /* End of cleaning variable centers_offsets */
  if((PyObject *)capi_nsources_starts_tmp!=nsources_starts_capi) {
    Py_XDECREF(capi_nsources_starts_tmp); }
  }  /*if (capi_nsources_starts_tmp == NULL) ... else of nsources_starts*/
  /* End of cleaning variable nsources_starts */
  if((PyObject *)capi_charge_starts_tmp!=charge_starts_capi) {
    Py_XDECREF(capi_charge_starts_tmp); }
  }  /*if (capi_charge_starts_tmp == NULL) ... else of charge_starts*/
  /* End of cleaning variable charge_starts */
  }  /*if (capi_ier_tmp == NULL) ... else of ier*/
  /* End of cleaning variable ier */
  } /*CHECKSCALAR((len(sources_starts)-1)>=nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_centers_tmp!=centers_capi) {
    Py_XDECREF(capi_centers_tmp); }
  }  /*if (capi_centers_tmp == NULL) ... else of centers*/
  /* End of cleaning variable centers */
  if((PyObject *)capi_nsources_offsets_tmp!=nsources_offsets_capi) {
    Py_XDECREF(capi_nsources_offsets_tmp); }
  }  /*if (capi_nsources_offsets_tmp == NULL) ... else of nsources_offsets*/
  /* End of cleaning variable nsources_offsets */
  if((PyObject *)capi_nsources_tmp!=nsources_capi) {
    Py_XDECREF(capi_nsources_tmp); }
  }  /*if (capi_nsources_tmp == NULL) ... else of nsources*/
  /* End of cleaning variable nsources */
  if((PyObject *)capi_charge_offsets_tmp!=charge_offsets_capi) {
    Py_XDECREF(capi_charge_offsets_tmp); }
  }  /*if (capi_charge_offsets_tmp == NULL) ... else of charge_offsets*/
  /* End of cleaning variable charge_offsets */
  if((PyObject *)capi_charge_tmp!=charge_capi) {
    Py_XDECREF(capi_charge_tmp); }
  }  /*if (capi_charge_tmp == NULL) ... else of charge*/
  /* End of cleaning variable charge */
  if((PyObject *)capi_sources_starts_tmp!=sources_starts_capi) {
    Py_XDECREF(capi_sources_starts_tmp); }
  }  /*if (capi_sources_starts_tmp == NULL) ... else of sources_starts*/
  /* End of cleaning variable sources_starts */
  if((PyObject *)capi_sources_offsets_tmp!=sources_offsets_capi) {
    Py_XDECREF(capi_sources_offsets_tmp); }
  }  /*if (capi_sources_offsets_tmp == NULL) ... else of sources_offsets*/
  /* End of cleaning variable sources_offsets */
  if((PyObject *)capi_sources_tmp!=sources_capi) {
    Py_XDECREF(capi_sources_tmp); }
  }  /*if (capi_sources_tmp == NULL) ... else of sources*/
  /* End of cleaning variable sources */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/*************************** end of l2dformta_imany ***************************/

/****************************** h2dformta_imany ******************************/
static char doc_f2py_rout__internal_h2dformta_imany[] = "\
ier,expn = h2dformta_imany(zk,rscale,sources,sources_offsets,sources_starts,charge,charge_offsets,charge_starts,nsources,nsources_offsets,nsources_starts,centers,centers_offsets,nterms,[nvcount])\n\nWrapper for ``h2dformta_imany``.\
\n\nParameters\n----------\n"
"zk : input complex\n"
"rscale : input float\n"
"sources : input rank-2 array('d') with bounds (2,*)\n"
"sources_offsets : input rank-1 array('i') with bounds (*)\n"
"sources_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"charge : input rank-1 array('D') with bounds (*)\n"
"charge_offsets : input rank-1 array('i') with bounds (*)\n"
"charge_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"nsources : input rank-1 array('i') with bounds (*)\n"
"nsources_offsets : input rank-1 array('i') with bounds (*)\n"
"nsources_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"centers : input rank-2 array('d') with bounds (2,*)\n"
"centers_offsets : input rank-1 array('i') with bounds (nvcount)\n"
"nterms : input int\n"
"\nOther Parameters\n----------------\n"
"nvcount : input int, optional\n    Default: (len(sources_starts)-1)\n"
"\nReturns\n-------\n"
"ier : rank-1 array('i') with bounds (nvcount)\n"
"expn : rank-2 array('D') with bounds (2 * nterms + 1,nvcount)";
/* extern void F_FUNC_US(h2dformta_imany,H2DFORMTA_IMANY)(int*,complex_double*,double*,double*,int*,int*,complex_double*,int*,int*,int*,int*,int*,double*,int*,int*,complex_double*,int*); */
static PyObject *f2py_rout__internal_h2dformta_imany(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,complex_double*,double*,double*,int*,int*,complex_double*,int*,int*,int*,int*,int*,double*,int*,int*,complex_double*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int *ier = NULL;
  npy_intp ier_Dims[1] = {-1};
  const int ier_Rank = 1;
  PyArrayObject *capi_ier_tmp = NULL;
  int capi_ier_intent = 0;
  complex_double zk;
  PyObject *zk_capi = Py_None;
  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *sources = NULL;
  npy_intp sources_Dims[2] = {-1, -1};
  const int sources_Rank = 2;
  PyArrayObject *capi_sources_tmp = NULL;
  int capi_sources_intent = 0;
  PyObject *sources_capi = Py_None;
  int *sources_offsets = NULL;
  npy_intp sources_offsets_Dims[1] = {-1};
  const int sources_offsets_Rank = 1;
  PyArrayObject *capi_sources_offsets_tmp = NULL;
  int capi_sources_offsets_intent = 0;
  PyObject *sources_offsets_capi = Py_None;
  int *sources_starts = NULL;
  npy_intp sources_starts_Dims[1] = {-1};
  const int sources_starts_Rank = 1;
  PyArrayObject *capi_sources_starts_tmp = NULL;
  int capi_sources_starts_intent = 0;
  PyObject *sources_starts_capi = Py_None;
  complex_double *charge = NULL;
  npy_intp charge_Dims[1] = {-1};
  const int charge_Rank = 1;
  PyArrayObject *capi_charge_tmp = NULL;
  int capi_charge_intent = 0;
  PyObject *charge_capi = Py_None;
  int *charge_offsets = NULL;
  npy_intp charge_offsets_Dims[1] = {-1};
  const int charge_offsets_Rank = 1;
  PyArrayObject *capi_charge_offsets_tmp = NULL;
  int capi_charge_offsets_intent = 0;
  PyObject *charge_offsets_capi = Py_None;
  int *charge_starts = NULL;
  npy_intp charge_starts_Dims[1] = {-1};
  const int charge_starts_Rank = 1;
  PyArrayObject *capi_charge_starts_tmp = NULL;
  int capi_charge_starts_intent = 0;
  PyObject *charge_starts_capi = Py_None;
  int *nsources = NULL;
  npy_intp nsources_Dims[1] = {-1};
  const int nsources_Rank = 1;
  PyArrayObject *capi_nsources_tmp = NULL;
  int capi_nsources_intent = 0;
  PyObject *nsources_capi = Py_None;
  int *nsources_offsets = NULL;
  npy_intp nsources_offsets_Dims[1] = {-1};
  const int nsources_offsets_Rank = 1;
  PyArrayObject *capi_nsources_offsets_tmp = NULL;
  int capi_nsources_offsets_intent = 0;
  PyObject *nsources_offsets_capi = Py_None;
  int *nsources_starts = NULL;
  npy_intp nsources_starts_Dims[1] = {-1};
  const int nsources_starts_Rank = 1;
  PyArrayObject *capi_nsources_starts_tmp = NULL;
  int capi_nsources_starts_intent = 0;
  PyObject *nsources_starts_capi = Py_None;
  double *centers = NULL;
  npy_intp centers_Dims[2] = {-1, -1};
  const int centers_Rank = 2;
  PyArrayObject *capi_centers_tmp = NULL;
  int capi_centers_intent = 0;
  PyObject *centers_capi = Py_None;
  int *centers_offsets = NULL;
  npy_intp centers_offsets_Dims[1] = {-1};
  const int centers_offsets_Rank = 1;
  PyArrayObject *capi_centers_offsets_tmp = NULL;
  int capi_centers_offsets_intent = 0;
  PyObject *centers_offsets_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[2] = {-1, -1};
  const int expn_Rank = 2;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"zk","rscale","sources","sources_offsets","sources_starts","charge","charge_offsets","charge_starts","nsources","nsources_offsets","nsources_starts","centers","centers_offsets","nterms","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOOOOOO|O:_internal.h2dformta_imany",\
        capi_kwlist,&zk_capi,&rscale_capi,&sources_capi,&sources_offsets_capi,&sources_starts_capi,&charge_capi,&charge_offsets_capi,&charge_starts_capi,&nsources_capi,&nsources_offsets_capi,&nsources_starts_capi,&centers_capi,&centers_offsets_capi,&nterms_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.h2dformta_imany() 1st argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.h2dformta_imany() 2nd argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable sources */
  sources_Dims[0]=2;
  capi_sources_intent |= F2PY_INTENT_IN;
  capi_sources_tmp = array_from_pyobj(NPY_DOUBLE,sources_Dims,sources_Rank,capi_sources_intent,sources_capi);
  if (capi_sources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `sources' of _internal.h2dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources = (double *)(PyArray_DATA(capi_sources_tmp));

  /* Processing variable sources_offsets */
  ;
  capi_sources_offsets_intent |= F2PY_INTENT_IN;
  capi_sources_offsets_tmp = array_from_pyobj(NPY_INT,sources_offsets_Dims,sources_offsets_Rank,capi_sources_offsets_intent,sources_offsets_capi);
  if (capi_sources_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `sources_offsets' of _internal.h2dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources_offsets = (int *)(PyArray_DATA(capi_sources_offsets_tmp));

  /* Processing variable sources_starts */
  ;
  capi_sources_starts_intent |= F2PY_INTENT_IN;
  capi_sources_starts_tmp = array_from_pyobj(NPY_INT,sources_starts_Dims,sources_starts_Rank,capi_sources_starts_intent,sources_starts_capi);
  if (capi_sources_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `sources_starts' of _internal.h2dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources_starts = (int *)(PyArray_DATA(capi_sources_starts_tmp));

  /* Processing variable charge */
  ;
  capi_charge_intent |= F2PY_INTENT_IN;
  capi_charge_tmp = array_from_pyobj(NPY_CDOUBLE,charge_Dims,charge_Rank,capi_charge_intent,charge_capi);
  if (capi_charge_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `charge' of _internal.h2dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge = (complex_double *)(PyArray_DATA(capi_charge_tmp));

  /* Processing variable charge_offsets */
  ;
  capi_charge_offsets_intent |= F2PY_INTENT_IN;
  capi_charge_offsets_tmp = array_from_pyobj(NPY_INT,charge_offsets_Dims,charge_offsets_Rank,capi_charge_offsets_intent,charge_offsets_capi);
  if (capi_charge_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 7th argument `charge_offsets' of _internal.h2dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge_offsets = (int *)(PyArray_DATA(capi_charge_offsets_tmp));

  /* Processing variable nsources */
  ;
  capi_nsources_intent |= F2PY_INTENT_IN;
  capi_nsources_tmp = array_from_pyobj(NPY_INT,nsources_Dims,nsources_Rank,capi_nsources_intent,nsources_capi);
  if (capi_nsources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 9th argument `nsources' of _internal.h2dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    nsources = (int *)(PyArray_DATA(capi_nsources_tmp));

  /* Processing variable nsources_offsets */
  ;
  capi_nsources_offsets_intent |= F2PY_INTENT_IN;
  capi_nsources_offsets_tmp = array_from_pyobj(NPY_INT,nsources_offsets_Dims,nsources_offsets_Rank,capi_nsources_offsets_intent,nsources_offsets_capi);
  if (capi_nsources_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 10th argument `nsources_offsets' of _internal.h2dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    nsources_offsets = (int *)(PyArray_DATA(capi_nsources_offsets_tmp));

  /* Processing variable centers */
  centers_Dims[0]=2;
  capi_centers_intent |= F2PY_INTENT_IN;
  capi_centers_tmp = array_from_pyobj(NPY_DOUBLE,centers_Dims,centers_Rank,capi_centers_intent,centers_capi);
  if (capi_centers_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 12nd argument `centers' of _internal.h2dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    centers = (double *)(PyArray_DATA(capi_centers_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.h2dformta_imany() 14th argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = (len(sources_starts)-1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.h2dformta_imany() 1st keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((len(sources_starts)-1)>=nvcount,"(len(sources_starts)-1)>=nvcount","1st keyword nvcount","h2dformta_imany:nvcount=%d",nvcount) {
  /* Processing variable ier */
  ier_Dims[0]=nvcount;
  capi_ier_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_ier_tmp = array_from_pyobj(NPY_INT,ier_Dims,ier_Rank,capi_ier_intent,Py_None);
  if (capi_ier_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `ier' of _internal.h2dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ier = (int *)(PyArray_DATA(capi_ier_tmp));

  /* Processing variable charge_starts */
  charge_starts_Dims[0]=nvcount + 1;
  capi_charge_starts_intent |= F2PY_INTENT_IN;
  capi_charge_starts_tmp = array_from_pyobj(NPY_INT,charge_starts_Dims,charge_starts_Rank,capi_charge_starts_intent,charge_starts_capi);
  if (capi_charge_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 8th argument `charge_starts' of _internal.h2dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge_starts = (int *)(PyArray_DATA(capi_charge_starts_tmp));

  /* Processing variable nsources_starts */
  nsources_starts_Dims[0]=nvcount + 1;
  capi_nsources_starts_intent |= F2PY_INTENT_IN;
  capi_nsources_starts_tmp = array_from_pyobj(NPY_INT,nsources_starts_Dims,nsources_starts_Rank,capi_nsources_starts_intent,nsources_starts_capi);
  if (capi_nsources_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 11st argument `nsources_starts' of _internal.h2dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    nsources_starts = (int *)(PyArray_DATA(capi_nsources_starts_tmp));

  /* Processing variable centers_offsets */
  centers_offsets_Dims[0]=nvcount;
  capi_centers_offsets_intent |= F2PY_INTENT_IN;
  capi_centers_offsets_tmp = array_from_pyobj(NPY_INT,centers_offsets_Dims,centers_offsets_Rank,capi_centers_offsets_intent,centers_offsets_capi);
  if (capi_centers_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 13rd argument `centers_offsets' of _internal.h2dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    centers_offsets = (int *)(PyArray_DATA(capi_centers_offsets_tmp));

  /* Processing variable expn */
  expn_Dims[0]=2 * nterms + 1,expn_Dims[1]=nvcount;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.h2dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(ier,&zk,&rscale,sources,sources_offsets,sources_starts,charge,charge_offsets,charge_starts,nsources,nsources_offsets,nsources_starts,centers,centers_offsets,&nterms,expn,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NN",capi_ier_tmp,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  if((PyObject *)capi_centers_offsets_tmp!=centers_offsets_capi) {
    Py_XDECREF(capi_centers_offsets_tmp); }
  }  /*if (capi_centers_offsets_tmp == NULL) ... else of centers_offsets*/
  /* End of cleaning variable centers_offsets */
  if((PyObject *)capi_nsources_starts_tmp!=nsources_starts_capi) {
    Py_XDECREF(capi_nsources_starts_tmp); }
  }  /*if (capi_nsources_starts_tmp == NULL) ... else of nsources_starts*/
  /* End of cleaning variable nsources_starts */
  if((PyObject *)capi_charge_starts_tmp!=charge_starts_capi) {
    Py_XDECREF(capi_charge_starts_tmp); }
  }  /*if (capi_charge_starts_tmp == NULL) ... else of charge_starts*/
  /* End of cleaning variable charge_starts */
  }  /*if (capi_ier_tmp == NULL) ... else of ier*/
  /* End of cleaning variable ier */
  } /*CHECKSCALAR((len(sources_starts)-1)>=nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_centers_tmp!=centers_capi) {
    Py_XDECREF(capi_centers_tmp); }
  }  /*if (capi_centers_tmp == NULL) ... else of centers*/
  /* End of cleaning variable centers */
  if((PyObject *)capi_nsources_offsets_tmp!=nsources_offsets_capi) {
    Py_XDECREF(capi_nsources_offsets_tmp); }
  }  /*if (capi_nsources_offsets_tmp == NULL) ... else of nsources_offsets*/
  /* End of cleaning variable nsources_offsets */
  if((PyObject *)capi_nsources_tmp!=nsources_capi) {
    Py_XDECREF(capi_nsources_tmp); }
  }  /*if (capi_nsources_tmp == NULL) ... else of nsources*/
  /* End of cleaning variable nsources */
  if((PyObject *)capi_charge_offsets_tmp!=charge_offsets_capi) {
    Py_XDECREF(capi_charge_offsets_tmp); }
  }  /*if (capi_charge_offsets_tmp == NULL) ... else of charge_offsets*/
  /* End of cleaning variable charge_offsets */
  if((PyObject *)capi_charge_tmp!=charge_capi) {
    Py_XDECREF(capi_charge_tmp); }
  }  /*if (capi_charge_tmp == NULL) ... else of charge*/
  /* End of cleaning variable charge */
  if((PyObject *)capi_sources_starts_tmp!=sources_starts_capi) {
    Py_XDECREF(capi_sources_starts_tmp); }
  }  /*if (capi_sources_starts_tmp == NULL) ... else of sources_starts*/
  /* End of cleaning variable sources_starts */
  if((PyObject *)capi_sources_offsets_tmp!=sources_offsets_capi) {
    Py_XDECREF(capi_sources_offsets_tmp); }
  }  /*if (capi_sources_offsets_tmp == NULL) ... else of sources_offsets*/
  /* End of cleaning variable sources_offsets */
  if((PyObject *)capi_sources_tmp!=sources_capi) {
    Py_XDECREF(capi_sources_tmp); }
  }  /*if (capi_sources_tmp == NULL) ... else of sources*/
  /* End of cleaning variable sources */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/*************************** end of h2dformta_imany ***************************/

/****************************** l3dformta_imany ******************************/
static char doc_f2py_rout__internal_l3dformta_imany[] = "\
ier,expn = l3dformta_imany(rscale,sources,sources_offsets,sources_starts,charge,charge_offsets,charge_starts,nsources,nsources_offsets,nsources_starts,centers,centers_offsets,nterms,[nvcount])\n\nWrapper for ``l3dformta_imany``.\
\n\nParameters\n----------\n"
"rscale : input float\n"
"sources : input rank-2 array('d') with bounds (3,*)\n"
"sources_offsets : input rank-1 array('i') with bounds (*)\n"
"sources_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"charge : input rank-1 array('D') with bounds (*)\n"
"charge_offsets : input rank-1 array('i') with bounds (*)\n"
"charge_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"nsources : input rank-1 array('i') with bounds (*)\n"
"nsources_offsets : input rank-1 array('i') with bounds (*)\n"
"nsources_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"centers : input rank-2 array('d') with bounds (3,*)\n"
"centers_offsets : input rank-1 array('i') with bounds (nvcount)\n"
"nterms : input int\n"
"\nOther Parameters\n----------------\n"
"nvcount : input int, optional\n    Default: (len(sources_starts)-1)\n"
"\nReturns\n-------\n"
"ier : rank-1 array('i') with bounds (nvcount)\n"
"expn : rank-3 array('D') with bounds (nterms + 1,2 * nterms + 1,nvcount)";
/* extern void F_FUNC_US(l3dformta_imany,L3DFORMTA_IMANY)(int*,double*,double*,int*,int*,complex_double*,int*,int*,int*,int*,int*,double*,int*,int*,complex_double*,int*); */
static PyObject *f2py_rout__internal_l3dformta_imany(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*,int*,int*,complex_double*,int*,int*,int*,int*,int*,double*,int*,int*,complex_double*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int *ier = NULL;
  npy_intp ier_Dims[1] = {-1};
  const int ier_Rank = 1;
  PyArrayObject *capi_ier_tmp = NULL;
  int capi_ier_intent = 0;
  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *sources = NULL;
  npy_intp sources_Dims[2] = {-1, -1};
  const int sources_Rank = 2;
  PyArrayObject *capi_sources_tmp = NULL;
  int capi_sources_intent = 0;
  PyObject *sources_capi = Py_None;
  int *sources_offsets = NULL;
  npy_intp sources_offsets_Dims[1] = {-1};
  const int sources_offsets_Rank = 1;
  PyArrayObject *capi_sources_offsets_tmp = NULL;
  int capi_sources_offsets_intent = 0;
  PyObject *sources_offsets_capi = Py_None;
  int *sources_starts = NULL;
  npy_intp sources_starts_Dims[1] = {-1};
  const int sources_starts_Rank = 1;
  PyArrayObject *capi_sources_starts_tmp = NULL;
  int capi_sources_starts_intent = 0;
  PyObject *sources_starts_capi = Py_None;
  complex_double *charge = NULL;
  npy_intp charge_Dims[1] = {-1};
  const int charge_Rank = 1;
  PyArrayObject *capi_charge_tmp = NULL;
  int capi_charge_intent = 0;
  PyObject *charge_capi = Py_None;
  int *charge_offsets = NULL;
  npy_intp charge_offsets_Dims[1] = {-1};
  const int charge_offsets_Rank = 1;
  PyArrayObject *capi_charge_offsets_tmp = NULL;
  int capi_charge_offsets_intent = 0;
  PyObject *charge_offsets_capi = Py_None;
  int *charge_starts = NULL;
  npy_intp charge_starts_Dims[1] = {-1};
  const int charge_starts_Rank = 1;
  PyArrayObject *capi_charge_starts_tmp = NULL;
  int capi_charge_starts_intent = 0;
  PyObject *charge_starts_capi = Py_None;
  int *nsources = NULL;
  npy_intp nsources_Dims[1] = {-1};
  const int nsources_Rank = 1;
  PyArrayObject *capi_nsources_tmp = NULL;
  int capi_nsources_intent = 0;
  PyObject *nsources_capi = Py_None;
  int *nsources_offsets = NULL;
  npy_intp nsources_offsets_Dims[1] = {-1};
  const int nsources_offsets_Rank = 1;
  PyArrayObject *capi_nsources_offsets_tmp = NULL;
  int capi_nsources_offsets_intent = 0;
  PyObject *nsources_offsets_capi = Py_None;
  int *nsources_starts = NULL;
  npy_intp nsources_starts_Dims[1] = {-1};
  const int nsources_starts_Rank = 1;
  PyArrayObject *capi_nsources_starts_tmp = NULL;
  int capi_nsources_starts_intent = 0;
  PyObject *nsources_starts_capi = Py_None;
  double *centers = NULL;
  npy_intp centers_Dims[2] = {-1, -1};
  const int centers_Rank = 2;
  PyArrayObject *capi_centers_tmp = NULL;
  int capi_centers_intent = 0;
  PyObject *centers_capi = Py_None;
  int *centers_offsets = NULL;
  npy_intp centers_offsets_Dims[1] = {-1};
  const int centers_offsets_Rank = 1;
  PyArrayObject *capi_centers_offsets_tmp = NULL;
  int capi_centers_offsets_intent = 0;
  PyObject *centers_offsets_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[3] = {-1, -1, -1};
  const int expn_Rank = 3;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"rscale","sources","sources_offsets","sources_starts","charge","charge_offsets","charge_starts","nsources","nsources_offsets","nsources_starts","centers","centers_offsets","nterms","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOOOOO|O:_internal.l3dformta_imany",\
        capi_kwlist,&rscale_capi,&sources_capi,&sources_offsets_capi,&sources_starts_capi,&charge_capi,&charge_offsets_capi,&charge_starts_capi,&nsources_capi,&nsources_offsets_capi,&nsources_starts_capi,&centers_capi,&centers_offsets_capi,&nterms_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.l3dformta_imany() 1st argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable sources */
  sources_Dims[0]=3;
  capi_sources_intent |= F2PY_INTENT_IN;
  capi_sources_tmp = array_from_pyobj(NPY_DOUBLE,sources_Dims,sources_Rank,capi_sources_intent,sources_capi);
  if (capi_sources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `sources' of _internal.l3dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources = (double *)(PyArray_DATA(capi_sources_tmp));

  /* Processing variable sources_offsets */
  ;
  capi_sources_offsets_intent |= F2PY_INTENT_IN;
  capi_sources_offsets_tmp = array_from_pyobj(NPY_INT,sources_offsets_Dims,sources_offsets_Rank,capi_sources_offsets_intent,sources_offsets_capi);
  if (capi_sources_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `sources_offsets' of _internal.l3dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources_offsets = (int *)(PyArray_DATA(capi_sources_offsets_tmp));

  /* Processing variable sources_starts */
  ;
  capi_sources_starts_intent |= F2PY_INTENT_IN;
  capi_sources_starts_tmp = array_from_pyobj(NPY_INT,sources_starts_Dims,sources_starts_Rank,capi_sources_starts_intent,sources_starts_capi);
  if (capi_sources_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `sources_starts' of _internal.l3dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources_starts = (int *)(PyArray_DATA(capi_sources_starts_tmp));

  /* Processing variable charge */
  ;
  capi_charge_intent |= F2PY_INTENT_IN;
  capi_charge_tmp = array_from_pyobj(NPY_CDOUBLE,charge_Dims,charge_Rank,capi_charge_intent,charge_capi);
  if (capi_charge_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `charge' of _internal.l3dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge = (complex_double *)(PyArray_DATA(capi_charge_tmp));

  /* Processing variable charge_offsets */
  ;
  capi_charge_offsets_intent |= F2PY_INTENT_IN;
  capi_charge_offsets_tmp = array_from_pyobj(NPY_INT,charge_offsets_Dims,charge_offsets_Rank,capi_charge_offsets_intent,charge_offsets_capi);
  if (capi_charge_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `charge_offsets' of _internal.l3dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge_offsets = (int *)(PyArray_DATA(capi_charge_offsets_tmp));

  /* Processing variable nsources */
  ;
  capi_nsources_intent |= F2PY_INTENT_IN;
  capi_nsources_tmp = array_from_pyobj(NPY_INT,nsources_Dims,nsources_Rank,capi_nsources_intent,nsources_capi);
  if (capi_nsources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 8th argument `nsources' of _internal.l3dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    nsources = (int *)(PyArray_DATA(capi_nsources_tmp));

  /* Processing variable nsources_offsets */
  ;
  capi_nsources_offsets_intent |= F2PY_INTENT_IN;
  capi_nsources_offsets_tmp = array_from_pyobj(NPY_INT,nsources_offsets_Dims,nsources_offsets_Rank,capi_nsources_offsets_intent,nsources_offsets_capi);
  if (capi_nsources_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 9th argument `nsources_offsets' of _internal.l3dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    nsources_offsets = (int *)(PyArray_DATA(capi_nsources_offsets_tmp));

  /* Processing variable centers */
  centers_Dims[0]=3;
  capi_centers_intent |= F2PY_INTENT_IN;
  capi_centers_tmp = array_from_pyobj(NPY_DOUBLE,centers_Dims,centers_Rank,capi_centers_intent,centers_capi);
  if (capi_centers_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 11st argument `centers' of _internal.l3dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    centers = (double *)(PyArray_DATA(capi_centers_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.l3dformta_imany() 13rd argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = (len(sources_starts)-1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.l3dformta_imany() 1st keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((len(sources_starts)-1)>=nvcount,"(len(sources_starts)-1)>=nvcount","1st keyword nvcount","l3dformta_imany:nvcount=%d",nvcount) {
  /* Processing variable ier */
  ier_Dims[0]=nvcount;
  capi_ier_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_ier_tmp = array_from_pyobj(NPY_INT,ier_Dims,ier_Rank,capi_ier_intent,Py_None);
  if (capi_ier_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `ier' of _internal.l3dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ier = (int *)(PyArray_DATA(capi_ier_tmp));

  /* Processing variable charge_starts */
  charge_starts_Dims[0]=nvcount + 1;
  capi_charge_starts_intent |= F2PY_INTENT_IN;
  capi_charge_starts_tmp = array_from_pyobj(NPY_INT,charge_starts_Dims,charge_starts_Rank,capi_charge_starts_intent,charge_starts_capi);
  if (capi_charge_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 7th argument `charge_starts' of _internal.l3dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge_starts = (int *)(PyArray_DATA(capi_charge_starts_tmp));

  /* Processing variable nsources_starts */
  nsources_starts_Dims[0]=nvcount + 1;
  capi_nsources_starts_intent |= F2PY_INTENT_IN;
  capi_nsources_starts_tmp = array_from_pyobj(NPY_INT,nsources_starts_Dims,nsources_starts_Rank,capi_nsources_starts_intent,nsources_starts_capi);
  if (capi_nsources_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 10th argument `nsources_starts' of _internal.l3dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    nsources_starts = (int *)(PyArray_DATA(capi_nsources_starts_tmp));

  /* Processing variable centers_offsets */
  centers_offsets_Dims[0]=nvcount;
  capi_centers_offsets_intent |= F2PY_INTENT_IN;
  capi_centers_offsets_tmp = array_from_pyobj(NPY_INT,centers_offsets_Dims,centers_offsets_Rank,capi_centers_offsets_intent,centers_offsets_capi);
  if (capi_centers_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 12nd argument `centers_offsets' of _internal.l3dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    centers_offsets = (int *)(PyArray_DATA(capi_centers_offsets_tmp));

  /* Processing variable expn */
  expn_Dims[0]=nterms + 1,expn_Dims[1]=2 * nterms + 1,expn_Dims[2]=nvcount;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.l3dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(ier,&rscale,sources,sources_offsets,sources_starts,charge,charge_offsets,charge_starts,nsources,nsources_offsets,nsources_starts,centers,centers_offsets,&nterms,expn,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NN",capi_ier_tmp,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  if((PyObject *)capi_centers_offsets_tmp!=centers_offsets_capi) {
    Py_XDECREF(capi_centers_offsets_tmp); }
  }  /*if (capi_centers_offsets_tmp == NULL) ... else of centers_offsets*/
  /* End of cleaning variable centers_offsets */
  if((PyObject *)capi_nsources_starts_tmp!=nsources_starts_capi) {
    Py_XDECREF(capi_nsources_starts_tmp); }
  }  /*if (capi_nsources_starts_tmp == NULL) ... else of nsources_starts*/
  /* End of cleaning variable nsources_starts */
  if((PyObject *)capi_charge_starts_tmp!=charge_starts_capi) {
    Py_XDECREF(capi_charge_starts_tmp); }
  }  /*if (capi_charge_starts_tmp == NULL) ... else of charge_starts*/
  /* End of cleaning variable charge_starts */
  }  /*if (capi_ier_tmp == NULL) ... else of ier*/
  /* End of cleaning variable ier */
  } /*CHECKSCALAR((len(sources_starts)-1)>=nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_centers_tmp!=centers_capi) {
    Py_XDECREF(capi_centers_tmp); }
  }  /*if (capi_centers_tmp == NULL) ... else of centers*/
  /* End of cleaning variable centers */
  if((PyObject *)capi_nsources_offsets_tmp!=nsources_offsets_capi) {
    Py_XDECREF(capi_nsources_offsets_tmp); }
  }  /*if (capi_nsources_offsets_tmp == NULL) ... else of nsources_offsets*/
  /* End of cleaning variable nsources_offsets */
  if((PyObject *)capi_nsources_tmp!=nsources_capi) {
    Py_XDECREF(capi_nsources_tmp); }
  }  /*if (capi_nsources_tmp == NULL) ... else of nsources*/
  /* End of cleaning variable nsources */
  if((PyObject *)capi_charge_offsets_tmp!=charge_offsets_capi) {
    Py_XDECREF(capi_charge_offsets_tmp); }
  }  /*if (capi_charge_offsets_tmp == NULL) ... else of charge_offsets*/
  /* End of cleaning variable charge_offsets */
  if((PyObject *)capi_charge_tmp!=charge_capi) {
    Py_XDECREF(capi_charge_tmp); }
  }  /*if (capi_charge_tmp == NULL) ... else of charge*/
  /* End of cleaning variable charge */
  if((PyObject *)capi_sources_starts_tmp!=sources_starts_capi) {
    Py_XDECREF(capi_sources_starts_tmp); }
  }  /*if (capi_sources_starts_tmp == NULL) ... else of sources_starts*/
  /* End of cleaning variable sources_starts */
  if((PyObject *)capi_sources_offsets_tmp!=sources_offsets_capi) {
    Py_XDECREF(capi_sources_offsets_tmp); }
  }  /*if (capi_sources_offsets_tmp == NULL) ... else of sources_offsets*/
  /* End of cleaning variable sources_offsets */
  if((PyObject *)capi_sources_tmp!=sources_capi) {
    Py_XDECREF(capi_sources_tmp); }
  }  /*if (capi_sources_tmp == NULL) ... else of sources*/
  /* End of cleaning variable sources */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/*************************** end of l3dformta_imany ***************************/

/****************************** h3dformta_imany ******************************/
static char doc_f2py_rout__internal_h3dformta_imany[] = "\
ier,expn = h3dformta_imany(zk,rscale,sources,sources_offsets,sources_starts,charge,charge_offsets,charge_starts,nsources,nsources_offsets,nsources_starts,centers,centers_offsets,nterms,[nvcount])\n\nWrapper for ``h3dformta_imany``.\
\n\nParameters\n----------\n"
"zk : input complex\n"
"rscale : input float\n"
"sources : input rank-2 array('d') with bounds (3,*)\n"
"sources_offsets : input rank-1 array('i') with bounds (*)\n"
"sources_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"charge : input rank-1 array('D') with bounds (*)\n"
"charge_offsets : input rank-1 array('i') with bounds (*)\n"
"charge_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"nsources : input rank-1 array('i') with bounds (*)\n"
"nsources_offsets : input rank-1 array('i') with bounds (*)\n"
"nsources_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"centers : input rank-2 array('d') with bounds (3,*)\n"
"centers_offsets : input rank-1 array('i') with bounds (nvcount)\n"
"nterms : input int\n"
"\nOther Parameters\n----------------\n"
"nvcount : input int, optional\n    Default: (len(sources_starts)-1)\n"
"\nReturns\n-------\n"
"ier : rank-1 array('i') with bounds (nvcount)\n"
"expn : rank-3 array('D') with bounds (nterms + 1,2 * nterms + 1,nvcount)";
/* extern void F_FUNC_US(h3dformta_imany,H3DFORMTA_IMANY)(int*,complex_double*,double*,double*,int*,int*,complex_double*,int*,int*,int*,int*,int*,double*,int*,int*,complex_double*,int*); */
static PyObject *f2py_rout__internal_h3dformta_imany(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,complex_double*,double*,double*,int*,int*,complex_double*,int*,int*,int*,int*,int*,double*,int*,int*,complex_double*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int *ier = NULL;
  npy_intp ier_Dims[1] = {-1};
  const int ier_Rank = 1;
  PyArrayObject *capi_ier_tmp = NULL;
  int capi_ier_intent = 0;
  complex_double zk;
  PyObject *zk_capi = Py_None;
  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *sources = NULL;
  npy_intp sources_Dims[2] = {-1, -1};
  const int sources_Rank = 2;
  PyArrayObject *capi_sources_tmp = NULL;
  int capi_sources_intent = 0;
  PyObject *sources_capi = Py_None;
  int *sources_offsets = NULL;
  npy_intp sources_offsets_Dims[1] = {-1};
  const int sources_offsets_Rank = 1;
  PyArrayObject *capi_sources_offsets_tmp = NULL;
  int capi_sources_offsets_intent = 0;
  PyObject *sources_offsets_capi = Py_None;
  int *sources_starts = NULL;
  npy_intp sources_starts_Dims[1] = {-1};
  const int sources_starts_Rank = 1;
  PyArrayObject *capi_sources_starts_tmp = NULL;
  int capi_sources_starts_intent = 0;
  PyObject *sources_starts_capi = Py_None;
  complex_double *charge = NULL;
  npy_intp charge_Dims[1] = {-1};
  const int charge_Rank = 1;
  PyArrayObject *capi_charge_tmp = NULL;
  int capi_charge_intent = 0;
  PyObject *charge_capi = Py_None;
  int *charge_offsets = NULL;
  npy_intp charge_offsets_Dims[1] = {-1};
  const int charge_offsets_Rank = 1;
  PyArrayObject *capi_charge_offsets_tmp = NULL;
  int capi_charge_offsets_intent = 0;
  PyObject *charge_offsets_capi = Py_None;
  int *charge_starts = NULL;
  npy_intp charge_starts_Dims[1] = {-1};
  const int charge_starts_Rank = 1;
  PyArrayObject *capi_charge_starts_tmp = NULL;
  int capi_charge_starts_intent = 0;
  PyObject *charge_starts_capi = Py_None;
  int *nsources = NULL;
  npy_intp nsources_Dims[1] = {-1};
  const int nsources_Rank = 1;
  PyArrayObject *capi_nsources_tmp = NULL;
  int capi_nsources_intent = 0;
  PyObject *nsources_capi = Py_None;
  int *nsources_offsets = NULL;
  npy_intp nsources_offsets_Dims[1] = {-1};
  const int nsources_offsets_Rank = 1;
  PyArrayObject *capi_nsources_offsets_tmp = NULL;
  int capi_nsources_offsets_intent = 0;
  PyObject *nsources_offsets_capi = Py_None;
  int *nsources_starts = NULL;
  npy_intp nsources_starts_Dims[1] = {-1};
  const int nsources_starts_Rank = 1;
  PyArrayObject *capi_nsources_starts_tmp = NULL;
  int capi_nsources_starts_intent = 0;
  PyObject *nsources_starts_capi = Py_None;
  double *centers = NULL;
  npy_intp centers_Dims[2] = {-1, -1};
  const int centers_Rank = 2;
  PyArrayObject *capi_centers_tmp = NULL;
  int capi_centers_intent = 0;
  PyObject *centers_capi = Py_None;
  int *centers_offsets = NULL;
  npy_intp centers_offsets_Dims[1] = {-1};
  const int centers_offsets_Rank = 1;
  PyArrayObject *capi_centers_offsets_tmp = NULL;
  int capi_centers_offsets_intent = 0;
  PyObject *centers_offsets_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[3] = {-1, -1, -1};
  const int expn_Rank = 3;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"zk","rscale","sources","sources_offsets","sources_starts","charge","charge_offsets","charge_starts","nsources","nsources_offsets","nsources_starts","centers","centers_offsets","nterms","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOOOOOO|O:_internal.h3dformta_imany",\
        capi_kwlist,&zk_capi,&rscale_capi,&sources_capi,&sources_offsets_capi,&sources_starts_capi,&charge_capi,&charge_offsets_capi,&charge_starts_capi,&nsources_capi,&nsources_offsets_capi,&nsources_starts_capi,&centers_capi,&centers_offsets_capi,&nterms_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.h3dformta_imany() 1st argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.h3dformta_imany() 2nd argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable sources */
  sources_Dims[0]=3;
  capi_sources_intent |= F2PY_INTENT_IN;
  capi_sources_tmp = array_from_pyobj(NPY_DOUBLE,sources_Dims,sources_Rank,capi_sources_intent,sources_capi);
  if (capi_sources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `sources' of _internal.h3dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources = (double *)(PyArray_DATA(capi_sources_tmp));

  /* Processing variable sources_offsets */
  ;
  capi_sources_offsets_intent |= F2PY_INTENT_IN;
  capi_sources_offsets_tmp = array_from_pyobj(NPY_INT,sources_offsets_Dims,sources_offsets_Rank,capi_sources_offsets_intent,sources_offsets_capi);
  if (capi_sources_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `sources_offsets' of _internal.h3dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources_offsets = (int *)(PyArray_DATA(capi_sources_offsets_tmp));

  /* Processing variable sources_starts */
  ;
  capi_sources_starts_intent |= F2PY_INTENT_IN;
  capi_sources_starts_tmp = array_from_pyobj(NPY_INT,sources_starts_Dims,sources_starts_Rank,capi_sources_starts_intent,sources_starts_capi);
  if (capi_sources_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `sources_starts' of _internal.h3dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources_starts = (int *)(PyArray_DATA(capi_sources_starts_tmp));

  /* Processing variable charge */
  ;
  capi_charge_intent |= F2PY_INTENT_IN;
  capi_charge_tmp = array_from_pyobj(NPY_CDOUBLE,charge_Dims,charge_Rank,capi_charge_intent,charge_capi);
  if (capi_charge_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `charge' of _internal.h3dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge = (complex_double *)(PyArray_DATA(capi_charge_tmp));

  /* Processing variable charge_offsets */
  ;
  capi_charge_offsets_intent |= F2PY_INTENT_IN;
  capi_charge_offsets_tmp = array_from_pyobj(NPY_INT,charge_offsets_Dims,charge_offsets_Rank,capi_charge_offsets_intent,charge_offsets_capi);
  if (capi_charge_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 7th argument `charge_offsets' of _internal.h3dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge_offsets = (int *)(PyArray_DATA(capi_charge_offsets_tmp));

  /* Processing variable nsources */
  ;
  capi_nsources_intent |= F2PY_INTENT_IN;
  capi_nsources_tmp = array_from_pyobj(NPY_INT,nsources_Dims,nsources_Rank,capi_nsources_intent,nsources_capi);
  if (capi_nsources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 9th argument `nsources' of _internal.h3dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    nsources = (int *)(PyArray_DATA(capi_nsources_tmp));

  /* Processing variable nsources_offsets */
  ;
  capi_nsources_offsets_intent |= F2PY_INTENT_IN;
  capi_nsources_offsets_tmp = array_from_pyobj(NPY_INT,nsources_offsets_Dims,nsources_offsets_Rank,capi_nsources_offsets_intent,nsources_offsets_capi);
  if (capi_nsources_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 10th argument `nsources_offsets' of _internal.h3dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    nsources_offsets = (int *)(PyArray_DATA(capi_nsources_offsets_tmp));

  /* Processing variable centers */
  centers_Dims[0]=3;
  capi_centers_intent |= F2PY_INTENT_IN;
  capi_centers_tmp = array_from_pyobj(NPY_DOUBLE,centers_Dims,centers_Rank,capi_centers_intent,centers_capi);
  if (capi_centers_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 12nd argument `centers' of _internal.h3dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    centers = (double *)(PyArray_DATA(capi_centers_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.h3dformta_imany() 14th argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = (len(sources_starts)-1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.h3dformta_imany() 1st keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((len(sources_starts)-1)>=nvcount,"(len(sources_starts)-1)>=nvcount","1st keyword nvcount","h3dformta_imany:nvcount=%d",nvcount) {
  /* Processing variable ier */
  ier_Dims[0]=nvcount;
  capi_ier_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_ier_tmp = array_from_pyobj(NPY_INT,ier_Dims,ier_Rank,capi_ier_intent,Py_None);
  if (capi_ier_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `ier' of _internal.h3dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ier = (int *)(PyArray_DATA(capi_ier_tmp));

  /* Processing variable charge_starts */
  charge_starts_Dims[0]=nvcount + 1;
  capi_charge_starts_intent |= F2PY_INTENT_IN;
  capi_charge_starts_tmp = array_from_pyobj(NPY_INT,charge_starts_Dims,charge_starts_Rank,capi_charge_starts_intent,charge_starts_capi);
  if (capi_charge_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 8th argument `charge_starts' of _internal.h3dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge_starts = (int *)(PyArray_DATA(capi_charge_starts_tmp));

  /* Processing variable nsources_starts */
  nsources_starts_Dims[0]=nvcount + 1;
  capi_nsources_starts_intent |= F2PY_INTENT_IN;
  capi_nsources_starts_tmp = array_from_pyobj(NPY_INT,nsources_starts_Dims,nsources_starts_Rank,capi_nsources_starts_intent,nsources_starts_capi);
  if (capi_nsources_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 11st argument `nsources_starts' of _internal.h3dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    nsources_starts = (int *)(PyArray_DATA(capi_nsources_starts_tmp));

  /* Processing variable centers_offsets */
  centers_offsets_Dims[0]=nvcount;
  capi_centers_offsets_intent |= F2PY_INTENT_IN;
  capi_centers_offsets_tmp = array_from_pyobj(NPY_INT,centers_offsets_Dims,centers_offsets_Rank,capi_centers_offsets_intent,centers_offsets_capi);
  if (capi_centers_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 13rd argument `centers_offsets' of _internal.h3dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    centers_offsets = (int *)(PyArray_DATA(capi_centers_offsets_tmp));

  /* Processing variable expn */
  expn_Dims[0]=nterms + 1,expn_Dims[1]=2 * nterms + 1,expn_Dims[2]=nvcount;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.h3dformta_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(ier,&zk,&rscale,sources,sources_offsets,sources_starts,charge,charge_offsets,charge_starts,nsources,nsources_offsets,nsources_starts,centers,centers_offsets,&nterms,expn,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NN",capi_ier_tmp,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  if((PyObject *)capi_centers_offsets_tmp!=centers_offsets_capi) {
    Py_XDECREF(capi_centers_offsets_tmp); }
  }  /*if (capi_centers_offsets_tmp == NULL) ... else of centers_offsets*/
  /* End of cleaning variable centers_offsets */
  if((PyObject *)capi_nsources_starts_tmp!=nsources_starts_capi) {
    Py_XDECREF(capi_nsources_starts_tmp); }
  }  /*if (capi_nsources_starts_tmp == NULL) ... else of nsources_starts*/
  /* End of cleaning variable nsources_starts */
  if((PyObject *)capi_charge_starts_tmp!=charge_starts_capi) {
    Py_XDECREF(capi_charge_starts_tmp); }
  }  /*if (capi_charge_starts_tmp == NULL) ... else of charge_starts*/
  /* End of cleaning variable charge_starts */
  }  /*if (capi_ier_tmp == NULL) ... else of ier*/
  /* End of cleaning variable ier */
  } /*CHECKSCALAR((len(sources_starts)-1)>=nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_centers_tmp!=centers_capi) {
    Py_XDECREF(capi_centers_tmp); }
  }  /*if (capi_centers_tmp == NULL) ... else of centers*/
  /* End of cleaning variable centers */
  if((PyObject *)capi_nsources_offsets_tmp!=nsources_offsets_capi) {
    Py_XDECREF(capi_nsources_offsets_tmp); }
  }  /*if (capi_nsources_offsets_tmp == NULL) ... else of nsources_offsets*/
  /* End of cleaning variable nsources_offsets */
  if((PyObject *)capi_nsources_tmp!=nsources_capi) {
    Py_XDECREF(capi_nsources_tmp); }
  }  /*if (capi_nsources_tmp == NULL) ... else of nsources*/
  /* End of cleaning variable nsources */
  if((PyObject *)capi_charge_offsets_tmp!=charge_offsets_capi) {
    Py_XDECREF(capi_charge_offsets_tmp); }
  }  /*if (capi_charge_offsets_tmp == NULL) ... else of charge_offsets*/
  /* End of cleaning variable charge_offsets */
  if((PyObject *)capi_charge_tmp!=charge_capi) {
    Py_XDECREF(capi_charge_tmp); }
  }  /*if (capi_charge_tmp == NULL) ... else of charge*/
  /* End of cleaning variable charge */
  if((PyObject *)capi_sources_starts_tmp!=sources_starts_capi) {
    Py_XDECREF(capi_sources_starts_tmp); }
  }  /*if (capi_sources_starts_tmp == NULL) ... else of sources_starts*/
  /* End of cleaning variable sources_starts */
  if((PyObject *)capi_sources_offsets_tmp!=sources_offsets_capi) {
    Py_XDECREF(capi_sources_offsets_tmp); }
  }  /*if (capi_sources_offsets_tmp == NULL) ... else of sources_offsets*/
  /* End of cleaning variable sources_offsets */
  if((PyObject *)capi_sources_tmp!=sources_capi) {
    Py_XDECREF(capi_sources_tmp); }
  }  /*if (capi_sources_tmp == NULL) ... else of sources*/
  /* End of cleaning variable sources */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/*************************** end of h3dformta_imany ***************************/

/***************************** l2dformta_dp_imany *****************************/
static char doc_f2py_rout__internal_l2dformta_dp_imany[] = "\
ier,expn = l2dformta_dp_imany(rscale,sources,sources_offsets,sources_starts,dipstr,dipstr_offsets,dipstr_starts,nsources,nsources_offsets,nsources_starts,centers,centers_offsets,nterms,[nvcount])\n\nWrapper for ``l2dformta_dp_imany``.\
\n\nParameters\n----------\n"
"rscale : input float\n"
"sources : input rank-2 array('d') with bounds (2,*)\n"
"sources_offsets : input rank-1 array('i') with bounds (*)\n"
"sources_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"dipstr : input rank-1 array('D') with bounds (*)\n"
"dipstr_offsets : input rank-1 array('i') with bounds (*)\n"
"dipstr_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"nsources : input rank-1 array('i') with bounds (*)\n"
"nsources_offsets : input rank-1 array('i') with bounds (*)\n"
"nsources_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"centers : input rank-2 array('d') with bounds (2,*)\n"
"centers_offsets : input rank-1 array('i') with bounds (nvcount)\n"
"nterms : input int\n"
"\nOther Parameters\n----------------\n"
"nvcount : input int, optional\n    Default: (len(sources_starts)-1)\n"
"\nReturns\n-------\n"
"ier : rank-1 array('i') with bounds (nvcount)\n"
"expn : rank-2 array('D') with bounds (nterms + 1,nvcount)";
/* extern void F_FUNC_US(l2dformta_dp_imany,L2DFORMTA_DP_IMANY)(int*,double*,double*,int*,int*,complex_double*,int*,int*,int*,int*,int*,double*,int*,int*,complex_double*,int*); */
static PyObject *f2py_rout__internal_l2dformta_dp_imany(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*,int*,int*,complex_double*,int*,int*,int*,int*,int*,double*,int*,int*,complex_double*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int *ier = NULL;
  npy_intp ier_Dims[1] = {-1};
  const int ier_Rank = 1;
  PyArrayObject *capi_ier_tmp = NULL;
  int capi_ier_intent = 0;
  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *sources = NULL;
  npy_intp sources_Dims[2] = {-1, -1};
  const int sources_Rank = 2;
  PyArrayObject *capi_sources_tmp = NULL;
  int capi_sources_intent = 0;
  PyObject *sources_capi = Py_None;
  int *sources_offsets = NULL;
  npy_intp sources_offsets_Dims[1] = {-1};
  const int sources_offsets_Rank = 1;
  PyArrayObject *capi_sources_offsets_tmp = NULL;
  int capi_sources_offsets_intent = 0;
  PyObject *sources_offsets_capi = Py_None;
  int *sources_starts = NULL;
  npy_intp sources_starts_Dims[1] = {-1};
  const int sources_starts_Rank = 1;
  PyArrayObject *capi_sources_starts_tmp = NULL;
  int capi_sources_starts_intent = 0;
  PyObject *sources_starts_capi = Py_None;
  complex_double *dipstr = NULL;
  npy_intp dipstr_Dims[1] = {-1};
  const int dipstr_Rank = 1;
  PyArrayObject *capi_dipstr_tmp = NULL;
  int capi_dipstr_intent = 0;
  PyObject *dipstr_capi = Py_None;
  int *dipstr_offsets = NULL;
  npy_intp dipstr_offsets_Dims[1] = {-1};
  const int dipstr_offsets_Rank = 1;
  PyArrayObject *capi_dipstr_offsets_tmp = NULL;
  int capi_dipstr_offsets_intent = 0;
  PyObject *dipstr_offsets_capi = Py_None;
  int *dipstr_starts = NULL;
  npy_intp dipstr_starts_Dims[1] = {-1};
  const int dipstr_starts_Rank = 1;
  PyArrayObject *capi_dipstr_starts_tmp = NULL;
  int capi_dipstr_starts_intent = 0;
  PyObject *dipstr_starts_capi = Py_None;
  int *nsources = NULL;
  npy_intp nsources_Dims[1] = {-1};
  const int nsources_Rank = 1;
  PyArrayObject *capi_nsources_tmp = NULL;
  int capi_nsources_intent = 0;
  PyObject *nsources_capi = Py_None;
  int *nsources_offsets = NULL;
  npy_intp nsources_offsets_Dims[1] = {-1};
  const int nsources_offsets_Rank = 1;
  PyArrayObject *capi_nsources_offsets_tmp = NULL;
  int capi_nsources_offsets_intent = 0;
  PyObject *nsources_offsets_capi = Py_None;
  int *nsources_starts = NULL;
  npy_intp nsources_starts_Dims[1] = {-1};
  const int nsources_starts_Rank = 1;
  PyArrayObject *capi_nsources_starts_tmp = NULL;
  int capi_nsources_starts_intent = 0;
  PyObject *nsources_starts_capi = Py_None;
  double *centers = NULL;
  npy_intp centers_Dims[2] = {-1, -1};
  const int centers_Rank = 2;
  PyArrayObject *capi_centers_tmp = NULL;
  int capi_centers_intent = 0;
  PyObject *centers_capi = Py_None;
  int *centers_offsets = NULL;
  npy_intp centers_offsets_Dims[1] = {-1};
  const int centers_offsets_Rank = 1;
  PyArrayObject *capi_centers_offsets_tmp = NULL;
  int capi_centers_offsets_intent = 0;
  PyObject *centers_offsets_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[2] = {-1, -1};
  const int expn_Rank = 2;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"rscale","sources","sources_offsets","sources_starts","dipstr","dipstr_offsets","dipstr_starts","nsources","nsources_offsets","nsources_starts","centers","centers_offsets","nterms","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOOOOO|O:_internal.l2dformta_dp_imany",\
        capi_kwlist,&rscale_capi,&sources_capi,&sources_offsets_capi,&sources_starts_capi,&dipstr_capi,&dipstr_offsets_capi,&dipstr_starts_capi,&nsources_capi,&nsources_offsets_capi,&nsources_starts_capi,&centers_capi,&centers_offsets_capi,&nterms_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.l2dformta_dp_imany() 1st argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable sources */
  sources_Dims[0]=2;
  capi_sources_intent |= F2PY_INTENT_IN;
  capi_sources_tmp = array_from_pyobj(NPY_DOUBLE,sources_Dims,sources_Rank,capi_sources_intent,sources_capi);
  if (capi_sources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `sources' of _internal.l2dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources = (double *)(PyArray_DATA(capi_sources_tmp));

  /* Processing variable sources_offsets */
  ;
  capi_sources_offsets_intent |= F2PY_INTENT_IN;
  capi_sources_offsets_tmp = array_from_pyobj(NPY_INT,sources_offsets_Dims,sources_offsets_Rank,capi_sources_offsets_intent,sources_offsets_capi);
  if (capi_sources_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `sources_offsets' of _internal.l2dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources_offsets = (int *)(PyArray_DATA(capi_sources_offsets_tmp));

  /* Processing variable sources_starts */
  ;
  capi_sources_starts_intent |= F2PY_INTENT_IN;
  capi_sources_starts_tmp = array_from_pyobj(NPY_INT,sources_starts_Dims,sources_starts_Rank,capi_sources_starts_intent,sources_starts_capi);
  if (capi_sources_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `sources_starts' of _internal.l2dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources_starts = (int *)(PyArray_DATA(capi_sources_starts_tmp));

  /* Processing variable dipstr */
  ;
  capi_dipstr_intent |= F2PY_INTENT_IN;
  capi_dipstr_tmp = array_from_pyobj(NPY_CDOUBLE,dipstr_Dims,dipstr_Rank,capi_dipstr_intent,dipstr_capi);
  if (capi_dipstr_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `dipstr' of _internal.l2dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr = (complex_double *)(PyArray_DATA(capi_dipstr_tmp));

  /* Processing variable dipstr_offsets */
  ;
  capi_dipstr_offsets_intent |= F2PY_INTENT_IN;
  capi_dipstr_offsets_tmp = array_from_pyobj(NPY_INT,dipstr_offsets_Dims,dipstr_offsets_Rank,capi_dipstr_offsets_intent,dipstr_offsets_capi);
  if (capi_dipstr_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `dipstr_offsets' of _internal.l2dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr_offsets = (int *)(PyArray_DATA(capi_dipstr_offsets_tmp));

  /* Processing variable nsources */
  ;
  capi_nsources_intent |= F2PY_INTENT_IN;
  capi_nsources_tmp = array_from_pyobj(NPY_INT,nsources_Dims,nsources_Rank,capi_nsources_intent,nsources_capi);
  if (capi_nsources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 8th argument `nsources' of _internal.l2dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    nsources = (int *)(PyArray_DATA(capi_nsources_tmp));

  /* Processing variable nsources_offsets */
  ;
  capi_nsources_offsets_intent |= F2PY_INTENT_IN;
  capi_nsources_offsets_tmp = array_from_pyobj(NPY_INT,nsources_offsets_Dims,nsources_offsets_Rank,capi_nsources_offsets_intent,nsources_offsets_capi);
  if (capi_nsources_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 9th argument `nsources_offsets' of _internal.l2dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    nsources_offsets = (int *)(PyArray_DATA(capi_nsources_offsets_tmp));

  /* Processing variable centers */
  centers_Dims[0]=2;
  capi_centers_intent |= F2PY_INTENT_IN;
  capi_centers_tmp = array_from_pyobj(NPY_DOUBLE,centers_Dims,centers_Rank,capi_centers_intent,centers_capi);
  if (capi_centers_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 11st argument `centers' of _internal.l2dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    centers = (double *)(PyArray_DATA(capi_centers_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.l2dformta_dp_imany() 13rd argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = (len(sources_starts)-1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.l2dformta_dp_imany() 1st keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((len(sources_starts)-1)>=nvcount,"(len(sources_starts)-1)>=nvcount","1st keyword nvcount","l2dformta_dp_imany:nvcount=%d",nvcount) {
  /* Processing variable ier */
  ier_Dims[0]=nvcount;
  capi_ier_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_ier_tmp = array_from_pyobj(NPY_INT,ier_Dims,ier_Rank,capi_ier_intent,Py_None);
  if (capi_ier_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `ier' of _internal.l2dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ier = (int *)(PyArray_DATA(capi_ier_tmp));

  /* Processing variable dipstr_starts */
  dipstr_starts_Dims[0]=nvcount + 1;
  capi_dipstr_starts_intent |= F2PY_INTENT_IN;
  capi_dipstr_starts_tmp = array_from_pyobj(NPY_INT,dipstr_starts_Dims,dipstr_starts_Rank,capi_dipstr_starts_intent,dipstr_starts_capi);
  if (capi_dipstr_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 7th argument `dipstr_starts' of _internal.l2dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr_starts = (int *)(PyArray_DATA(capi_dipstr_starts_tmp));

  /* Processing variable nsources_starts */
  nsources_starts_Dims[0]=nvcount + 1;
  capi_nsources_starts_intent |= F2PY_INTENT_IN;
  capi_nsources_starts_tmp = array_from_pyobj(NPY_INT,nsources_starts_Dims,nsources_starts_Rank,capi_nsources_starts_intent,nsources_starts_capi);
  if (capi_nsources_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 10th argument `nsources_starts' of _internal.l2dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    nsources_starts = (int *)(PyArray_DATA(capi_nsources_starts_tmp));

  /* Processing variable centers_offsets */
  centers_offsets_Dims[0]=nvcount;
  capi_centers_offsets_intent |= F2PY_INTENT_IN;
  capi_centers_offsets_tmp = array_from_pyobj(NPY_INT,centers_offsets_Dims,centers_offsets_Rank,capi_centers_offsets_intent,centers_offsets_capi);
  if (capi_centers_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 12nd argument `centers_offsets' of _internal.l2dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    centers_offsets = (int *)(PyArray_DATA(capi_centers_offsets_tmp));

  /* Processing variable expn */
  expn_Dims[0]=nterms + 1,expn_Dims[1]=nvcount;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.l2dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(ier,&rscale,sources,sources_offsets,sources_starts,dipstr,dipstr_offsets,dipstr_starts,nsources,nsources_offsets,nsources_starts,centers,centers_offsets,&nterms,expn,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NN",capi_ier_tmp,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  if((PyObject *)capi_centers_offsets_tmp!=centers_offsets_capi) {
    Py_XDECREF(capi_centers_offsets_tmp); }
  }  /*if (capi_centers_offsets_tmp == NULL) ... else of centers_offsets*/
  /* End of cleaning variable centers_offsets */
  if((PyObject *)capi_nsources_starts_tmp!=nsources_starts_capi) {
    Py_XDECREF(capi_nsources_starts_tmp); }
  }  /*if (capi_nsources_starts_tmp == NULL) ... else of nsources_starts*/
  /* End of cleaning variable nsources_starts */
  if((PyObject *)capi_dipstr_starts_tmp!=dipstr_starts_capi) {
    Py_XDECREF(capi_dipstr_starts_tmp); }
  }  /*if (capi_dipstr_starts_tmp == NULL) ... else of dipstr_starts*/
  /* End of cleaning variable dipstr_starts */
  }  /*if (capi_ier_tmp == NULL) ... else of ier*/
  /* End of cleaning variable ier */
  } /*CHECKSCALAR((len(sources_starts)-1)>=nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_centers_tmp!=centers_capi) {
    Py_XDECREF(capi_centers_tmp); }
  }  /*if (capi_centers_tmp == NULL) ... else of centers*/
  /* End of cleaning variable centers */
  if((PyObject *)capi_nsources_offsets_tmp!=nsources_offsets_capi) {
    Py_XDECREF(capi_nsources_offsets_tmp); }
  }  /*if (capi_nsources_offsets_tmp == NULL) ... else of nsources_offsets*/
  /* End of cleaning variable nsources_offsets */
  if((PyObject *)capi_nsources_tmp!=nsources_capi) {
    Py_XDECREF(capi_nsources_tmp); }
  }  /*if (capi_nsources_tmp == NULL) ... else of nsources*/
  /* End of cleaning variable nsources */
  if((PyObject *)capi_dipstr_offsets_tmp!=dipstr_offsets_capi) {
    Py_XDECREF(capi_dipstr_offsets_tmp); }
  }  /*if (capi_dipstr_offsets_tmp == NULL) ... else of dipstr_offsets*/
  /* End of cleaning variable dipstr_offsets */
  if((PyObject *)capi_dipstr_tmp!=dipstr_capi) {
    Py_XDECREF(capi_dipstr_tmp); }
  }  /*if (capi_dipstr_tmp == NULL) ... else of dipstr*/
  /* End of cleaning variable dipstr */
  if((PyObject *)capi_sources_starts_tmp!=sources_starts_capi) {
    Py_XDECREF(capi_sources_starts_tmp); }
  }  /*if (capi_sources_starts_tmp == NULL) ... else of sources_starts*/
  /* End of cleaning variable sources_starts */
  if((PyObject *)capi_sources_offsets_tmp!=sources_offsets_capi) {
    Py_XDECREF(capi_sources_offsets_tmp); }
  }  /*if (capi_sources_offsets_tmp == NULL) ... else of sources_offsets*/
  /* End of cleaning variable sources_offsets */
  if((PyObject *)capi_sources_tmp!=sources_capi) {
    Py_XDECREF(capi_sources_tmp); }
  }  /*if (capi_sources_tmp == NULL) ... else of sources*/
  /* End of cleaning variable sources */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/************************* end of l2dformta_dp_imany *************************/

/***************************** h2dformta_dp_imany *****************************/
static char doc_f2py_rout__internal_h2dformta_dp_imany[] = "\
ier,expn = h2dformta_dp_imany(zk,rscale,sources,sources_offsets,sources_starts,dipstr,dipstr_offsets,dipstr_starts,dipvec,dipvec_offsets,dipvec_starts,nsources,nsources_offsets,nsources_starts,centers,centers_offsets,nterms,[nvcount])\n\nWrapper for ``h2dformta_dp_imany``.\
\n\nParameters\n----------\n"
"zk : input complex\n"
"rscale : input float\n"
"sources : input rank-2 array('d') with bounds (2,*)\n"
"sources_offsets : input rank-1 array('i') with bounds (*)\n"
"sources_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"dipstr : input rank-1 array('D') with bounds (*)\n"
"dipstr_offsets : input rank-1 array('i') with bounds (*)\n"
"dipstr_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"dipvec : input rank-2 array('d') with bounds (2,*)\n"
"dipvec_offsets : input rank-1 array('i') with bounds (*)\n"
"dipvec_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"nsources : input rank-1 array('i') with bounds (*)\n"
"nsources_offsets : input rank-1 array('i') with bounds (*)\n"
"nsources_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"centers : input rank-2 array('d') with bounds (2,*)\n"
"centers_offsets : input rank-1 array('i') with bounds (nvcount)\n"
"nterms : input int\n"
"\nOther Parameters\n----------------\n"
"nvcount : input int, optional\n    Default: (len(sources_starts)-1)\n"
"\nReturns\n-------\n"
"ier : rank-1 array('i') with bounds (nvcount)\n"
"expn : rank-2 array('D') with bounds (2 * nterms + 1,nvcount)";
/* extern void F_FUNC_US(h2dformta_dp_imany,H2DFORMTA_DP_IMANY)(int*,complex_double*,double*,double*,int*,int*,complex_double*,int*,int*,double*,int*,int*,int*,int*,int*,double*,int*,int*,complex_double*,int*); */
static PyObject *f2py_rout__internal_h2dformta_dp_imany(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,complex_double*,double*,double*,int*,int*,complex_double*,int*,int*,double*,int*,int*,int*,int*,int*,double*,int*,int*,complex_double*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int *ier = NULL;
  npy_intp ier_Dims[1] = {-1};
  const int ier_Rank = 1;
  PyArrayObject *capi_ier_tmp = NULL;
  int capi_ier_intent = 0;
  complex_double zk;
  PyObject *zk_capi = Py_None;
  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *sources = NULL;
  npy_intp sources_Dims[2] = {-1, -1};
  const int sources_Rank = 2;
  PyArrayObject *capi_sources_tmp = NULL;
  int capi_sources_intent = 0;
  PyObject *sources_capi = Py_None;
  int *sources_offsets = NULL;
  npy_intp sources_offsets_Dims[1] = {-1};
  const int sources_offsets_Rank = 1;
  PyArrayObject *capi_sources_offsets_tmp = NULL;
  int capi_sources_offsets_intent = 0;
  PyObject *sources_offsets_capi = Py_None;
  int *sources_starts = NULL;
  npy_intp sources_starts_Dims[1] = {-1};
  const int sources_starts_Rank = 1;
  PyArrayObject *capi_sources_starts_tmp = NULL;
  int capi_sources_starts_intent = 0;
  PyObject *sources_starts_capi = Py_None;
  complex_double *dipstr = NULL;
  npy_intp dipstr_Dims[1] = {-1};
  const int dipstr_Rank = 1;
  PyArrayObject *capi_dipstr_tmp = NULL;
  int capi_dipstr_intent = 0;
  PyObject *dipstr_capi = Py_None;
  int *dipstr_offsets = NULL;
  npy_intp dipstr_offsets_Dims[1] = {-1};
  const int dipstr_offsets_Rank = 1;
  PyArrayObject *capi_dipstr_offsets_tmp = NULL;
  int capi_dipstr_offsets_intent = 0;
  PyObject *dipstr_offsets_capi = Py_None;
  int *dipstr_starts = NULL;
  npy_intp dipstr_starts_Dims[1] = {-1};
  const int dipstr_starts_Rank = 1;
  PyArrayObject *capi_dipstr_starts_tmp = NULL;
  int capi_dipstr_starts_intent = 0;
  PyObject *dipstr_starts_capi = Py_None;
  double *dipvec = NULL;
  npy_intp dipvec_Dims[2] = {-1, -1};
  const int dipvec_Rank = 2;
  PyArrayObject *capi_dipvec_tmp = NULL;
  int capi_dipvec_intent = 0;
  PyObject *dipvec_capi = Py_None;
  int *dipvec_offsets = NULL;
  npy_intp dipvec_offsets_Dims[1] = {-1};
  const int dipvec_offsets_Rank = 1;
  PyArrayObject *capi_dipvec_offsets_tmp = NULL;
  int capi_dipvec_offsets_intent = 0;
  PyObject *dipvec_offsets_capi = Py_None;
  int *dipvec_starts = NULL;
  npy_intp dipvec_starts_Dims[1] = {-1};
  const int dipvec_starts_Rank = 1;
  PyArrayObject *capi_dipvec_starts_tmp = NULL;
  int capi_dipvec_starts_intent = 0;
  PyObject *dipvec_starts_capi = Py_None;
  int *nsources = NULL;
  npy_intp nsources_Dims[1] = {-1};
  const int nsources_Rank = 1;
  PyArrayObject *capi_nsources_tmp = NULL;
  int capi_nsources_intent = 0;
  PyObject *nsources_capi = Py_None;
  int *nsources_offsets = NULL;
  npy_intp nsources_offsets_Dims[1] = {-1};
  const int nsources_offsets_Rank = 1;
  PyArrayObject *capi_nsources_offsets_tmp = NULL;
  int capi_nsources_offsets_intent = 0;
  PyObject *nsources_offsets_capi = Py_None;
  int *nsources_starts = NULL;
  npy_intp nsources_starts_Dims[1] = {-1};
  const int nsources_starts_Rank = 1;
  PyArrayObject *capi_nsources_starts_tmp = NULL;
  int capi_nsources_starts_intent = 0;
  PyObject *nsources_starts_capi = Py_None;
  double *centers = NULL;
  npy_intp centers_Dims[2] = {-1, -1};
  const int centers_Rank = 2;
  PyArrayObject *capi_centers_tmp = NULL;
  int capi_centers_intent = 0;
  PyObject *centers_capi = Py_None;
  int *centers_offsets = NULL;
  npy_intp centers_offsets_Dims[1] = {-1};
  const int centers_offsets_Rank = 1;
  PyArrayObject *capi_centers_offsets_tmp = NULL;
  int capi_centers_offsets_intent = 0;
  PyObject *centers_offsets_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[2] = {-1, -1};
  const int expn_Rank = 2;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"zk","rscale","sources","sources_offsets","sources_starts","dipstr","dipstr_offsets","dipstr_starts","dipvec","dipvec_offsets","dipvec_starts","nsources","nsources_offsets","nsources_starts","centers","centers_offsets","nterms","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOOOOOOOOO|O:_internal.h2dformta_dp_imany",\
        capi_kwlist,&zk_capi,&rscale_capi,&sources_capi,&sources_offsets_capi,&sources_starts_capi,&dipstr_capi,&dipstr_offsets_capi,&dipstr_starts_capi,&dipvec_capi,&dipvec_offsets_capi,&dipvec_starts_capi,&nsources_capi,&nsources_offsets_capi,&nsources_starts_capi,&centers_capi,&centers_offsets_capi,&nterms_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.h2dformta_dp_imany() 1st argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.h2dformta_dp_imany() 2nd argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable sources */
  sources_Dims[0]=2;
  capi_sources_intent |= F2PY_INTENT_IN;
  capi_sources_tmp = array_from_pyobj(NPY_DOUBLE,sources_Dims,sources_Rank,capi_sources_intent,sources_capi);
  if (capi_sources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `sources' of _internal.h2dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources = (double *)(PyArray_DATA(capi_sources_tmp));

  /* Processing variable sources_offsets */
  ;
  capi_sources_offsets_intent |= F2PY_INTENT_IN;
  capi_sources_offsets_tmp = array_from_pyobj(NPY_INT,sources_offsets_Dims,sources_offsets_Rank,capi_sources_offsets_intent,sources_offsets_capi);
  if (capi_sources_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `sources_offsets' of _internal.h2dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources_offsets = (int *)(PyArray_DATA(capi_sources_offsets_tmp));

  /* Processing variable sources_starts */
  ;
  capi_sources_starts_intent |= F2PY_INTENT_IN;
  capi_sources_starts_tmp = array_from_pyobj(NPY_INT,sources_starts_Dims,sources_starts_Rank,capi_sources_starts_intent,sources_starts_capi);
  if (capi_sources_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `sources_starts' of _internal.h2dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources_starts = (int *)(PyArray_DATA(capi_sources_starts_tmp));

  /* Processing variable dipstr */
  ;
  capi_dipstr_intent |= F2PY_INTENT_IN;
  capi_dipstr_tmp = array_from_pyobj(NPY_CDOUBLE,dipstr_Dims,dipstr_Rank,capi_dipstr_intent,dipstr_capi);
  if (capi_dipstr_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `dipstr' of _internal.h2dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr = (complex_double *)(PyArray_DATA(capi_dipstr_tmp));

  /* Processing variable dipstr_offsets */
  ;
  capi_dipstr_offsets_intent |= F2PY_INTENT_IN;
  capi_dipstr_offsets_tmp = array_from_pyobj(NPY_INT,dipstr_offsets_Dims,dipstr_offsets_Rank,capi_dipstr_offsets_intent,dipstr_offsets_capi);
  if (capi_dipstr_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 7th argument `dipstr_offsets' of _internal.h2dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr_offsets = (int *)(PyArray_DATA(capi_dipstr_offsets_tmp));

  /* Processing variable dipvec */
  dipvec_Dims[0]=2;
  capi_dipvec_intent |= F2PY_INTENT_IN;
  capi_dipvec_tmp = array_from_pyobj(NPY_DOUBLE,dipvec_Dims,dipvec_Rank,capi_dipvec_intent,dipvec_capi);
  if (capi_dipvec_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 9th argument `dipvec' of _internal.h2dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipvec = (double *)(PyArray_DATA(capi_dipvec_tmp));

  /* Processing variable dipvec_offsets */
  ;
  capi_dipvec_offsets_intent |= F2PY_INTENT_IN;
  capi_dipvec_offsets_tmp = array_from_pyobj(NPY_INT,dipvec_offsets_Dims,dipvec_offsets_Rank,capi_dipvec_offsets_intent,dipvec_offsets_capi);
  if (capi_dipvec_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 10th argument `dipvec_offsets' of _internal.h2dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipvec_offsets = (int *)(PyArray_DATA(capi_dipvec_offsets_tmp));

  /* Processing variable nsources */
  ;
  capi_nsources_intent |= F2PY_INTENT_IN;
  capi_nsources_tmp = array_from_pyobj(NPY_INT,nsources_Dims,nsources_Rank,capi_nsources_intent,nsources_capi);
  if (capi_nsources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 12nd argument `nsources' of _internal.h2dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    nsources = (int *)(PyArray_DATA(capi_nsources_tmp));

  /* Processing variable nsources_offsets */
  ;
  capi_nsources_offsets_intent |= F2PY_INTENT_IN;
  capi_nsources_offsets_tmp = array_from_pyobj(NPY_INT,nsources_offsets_Dims,nsources_offsets_Rank,capi_nsources_offsets_intent,nsources_offsets_capi);
  if (capi_nsources_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 13rd argument `nsources_offsets' of _internal.h2dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    nsources_offsets = (int *)(PyArray_DATA(capi_nsources_offsets_tmp));

  /* Processing variable centers */
  centers_Dims[0]=2;
  capi_centers_intent |= F2PY_INTENT_IN;
  capi_centers_tmp = array_from_pyobj(NPY_DOUBLE,centers_Dims,centers_Rank,capi_centers_intent,centers_capi);
  if (capi_centers_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 15th argument `centers' of _internal.h2dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    centers = (double *)(PyArray_DATA(capi_centers_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.h2dformta_dp_imany() 17th argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = (len(sources_starts)-1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.h2dformta_dp_imany() 1st keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((len(sources_starts)-1)>=nvcount,"(len(sources_starts)-1)>=nvcount","1st keyword nvcount","h2dformta_dp_imany:nvcount=%d",nvcount) {
  /* Processing variable ier */
  ier_Dims[0]=nvcount;
  capi_ier_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_ier_tmp = array_from_pyobj(NPY_INT,ier_Dims,ier_Rank,capi_ier_intent,Py_None);
  if (capi_ier_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `ier' of _internal.h2dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ier = (int *)(PyArray_DATA(capi_ier_tmp));

  /* Processing variable dipstr_starts */
  dipstr_starts_Dims[0]=nvcount + 1;
  capi_dipstr_starts_intent |= F2PY_INTENT_IN;
  capi_dipstr_starts_tmp = array_from_pyobj(NPY_INT,dipstr_starts_Dims,dipstr_starts_Rank,capi_dipstr_starts_intent,dipstr_starts_capi);
  if (capi_dipstr_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 8th argument `dipstr_starts' of _internal.h2dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr_starts = (int *)(PyArray_DATA(capi_dipstr_starts_tmp));

  /* Processing variable dipvec_starts */
  dipvec_starts_Dims[0]=nvcount + 1;
  capi_dipvec_starts_intent |= F2PY_INTENT_IN;
  capi_dipvec_starts_tmp = array_from_pyobj(NPY_INT,dipvec_starts_Dims,dipvec_starts_Rank,capi_dipvec_starts_intent,dipvec_starts_capi);
  if (capi_dipvec_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 11st argument `dipvec_starts' of _internal.h2dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipvec_starts = (int *)(PyArray_DATA(capi_dipvec_starts_tmp));

  /* Processing variable nsources_starts */
  nsources_starts_Dims[0]=nvcount + 1;
  capi_nsources_starts_intent |= F2PY_INTENT_IN;
  capi_nsources_starts_tmp = array_from_pyobj(NPY_INT,nsources_starts_Dims,nsources_starts_Rank,capi_nsources_starts_intent,nsources_starts_capi);
  if (capi_nsources_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 14th argument `nsources_starts' of _internal.h2dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    nsources_starts = (int *)(PyArray_DATA(capi_nsources_starts_tmp));

  /* Processing variable centers_offsets */
  centers_offsets_Dims[0]=nvcount;
  capi_centers_offsets_intent |= F2PY_INTENT_IN;
  capi_centers_offsets_tmp = array_from_pyobj(NPY_INT,centers_offsets_Dims,centers_offsets_Rank,capi_centers_offsets_intent,centers_offsets_capi);
  if (capi_centers_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 16th argument `centers_offsets' of _internal.h2dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    centers_offsets = (int *)(PyArray_DATA(capi_centers_offsets_tmp));

  /* Processing variable expn */
  expn_Dims[0]=2 * nterms + 1,expn_Dims[1]=nvcount;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.h2dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(ier,&zk,&rscale,sources,sources_offsets,sources_starts,dipstr,dipstr_offsets,dipstr_starts,dipvec,dipvec_offsets,dipvec_starts,nsources,nsources_offsets,nsources_starts,centers,centers_offsets,&nterms,expn,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NN",capi_ier_tmp,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  if((PyObject *)capi_centers_offsets_tmp!=centers_offsets_capi) {
    Py_XDECREF(capi_centers_offsets_tmp); }
  }  /*if (capi_centers_offsets_tmp == NULL) ... else of centers_offsets*/
  /* End of cleaning variable centers_offsets */
  if((PyObject *)capi_nsources_starts_tmp!=nsources_starts_capi) {
    Py_XDECREF(capi_nsources_starts_tmp); }
  }  /*if (capi_nsources_starts_tmp == NULL) ... else of nsources_starts*/
  /* End of cleaning variable nsources_starts */
  if((PyObject *)capi_dipvec_starts_tmp!=dipvec_starts_capi) {
    Py_XDECREF(capi_dipvec_starts_tmp); }
  }  /*if (capi_dipvec_starts_tmp == NULL) ... else of dipvec_starts*/
  /* End of cleaning variable dipvec_starts */
  if((PyObject *)capi_dipstr_starts_tmp!=dipstr_starts_capi) {
    Py_XDECREF(capi_dipstr_starts_tmp); }
  }  /*if (capi_dipstr_starts_tmp == NULL) ... else of dipstr_starts*/
  /* End of cleaning variable dipstr_starts */
  }  /*if (capi_ier_tmp == NULL) ... else of ier*/
  /* End of cleaning variable ier */
  } /*CHECKSCALAR((len(sources_starts)-1)>=nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_centers_tmp!=centers_capi) {
    Py_XDECREF(capi_centers_tmp); }
  }  /*if (capi_centers_tmp == NULL) ... else of centers*/
  /* End of cleaning variable centers */
  if((PyObject *)capi_nsources_offsets_tmp!=nsources_offsets_capi) {
    Py_XDECREF(capi_nsources_offsets_tmp); }
  }  /*if (capi_nsources_offsets_tmp == NULL) ... else of nsources_offsets*/
  /* End of cleaning variable nsources_offsets */
  if((PyObject *)capi_nsources_tmp!=nsources_capi) {
    Py_XDECREF(capi_nsources_tmp); }
  }  /*if (capi_nsources_tmp == NULL) ... else of nsources*/
  /* End of cleaning variable nsources */
  if((PyObject *)capi_dipvec_offsets_tmp!=dipvec_offsets_capi) {
    Py_XDECREF(capi_dipvec_offsets_tmp); }
  }  /*if (capi_dipvec_offsets_tmp == NULL) ... else of dipvec_offsets*/
  /* End of cleaning variable dipvec_offsets */
  if((PyObject *)capi_dipvec_tmp!=dipvec_capi) {
    Py_XDECREF(capi_dipvec_tmp); }
  }  /*if (capi_dipvec_tmp == NULL) ... else of dipvec*/
  /* End of cleaning variable dipvec */
  if((PyObject *)capi_dipstr_offsets_tmp!=dipstr_offsets_capi) {
    Py_XDECREF(capi_dipstr_offsets_tmp); }
  }  /*if (capi_dipstr_offsets_tmp == NULL) ... else of dipstr_offsets*/
  /* End of cleaning variable dipstr_offsets */
  if((PyObject *)capi_dipstr_tmp!=dipstr_capi) {
    Py_XDECREF(capi_dipstr_tmp); }
  }  /*if (capi_dipstr_tmp == NULL) ... else of dipstr*/
  /* End of cleaning variable dipstr */
  if((PyObject *)capi_sources_starts_tmp!=sources_starts_capi) {
    Py_XDECREF(capi_sources_starts_tmp); }
  }  /*if (capi_sources_starts_tmp == NULL) ... else of sources_starts*/
  /* End of cleaning variable sources_starts */
  if((PyObject *)capi_sources_offsets_tmp!=sources_offsets_capi) {
    Py_XDECREF(capi_sources_offsets_tmp); }
  }  /*if (capi_sources_offsets_tmp == NULL) ... else of sources_offsets*/
  /* End of cleaning variable sources_offsets */
  if((PyObject *)capi_sources_tmp!=sources_capi) {
    Py_XDECREF(capi_sources_tmp); }
  }  /*if (capi_sources_tmp == NULL) ... else of sources*/
  /* End of cleaning variable sources */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/************************* end of h2dformta_dp_imany *************************/

/***************************** l3dformta_dp_imany *****************************/
static char doc_f2py_rout__internal_l3dformta_dp_imany[] = "\
ier,expn = l3dformta_dp_imany(rscale,sources,sources_offsets,sources_starts,dipstr,dipstr_offsets,dipstr_starts,dipvec,dipvec_offsets,dipvec_starts,nsources,nsources_offsets,nsources_starts,centers,centers_offsets,nterms,[nvcount])\n\nWrapper for ``l3dformta_dp_imany``.\
\n\nParameters\n----------\n"
"rscale : input float\n"
"sources : input rank-2 array('d') with bounds (3,*)\n"
"sources_offsets : input rank-1 array('i') with bounds (*)\n"
"sources_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"dipstr : input rank-1 array('D') with bounds (*)\n"
"dipstr_offsets : input rank-1 array('i') with bounds (*)\n"
"dipstr_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"dipvec : input rank-2 array('d') with bounds (3,*)\n"
"dipvec_offsets : input rank-1 array('i') with bounds (*)\n"
"dipvec_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"nsources : input rank-1 array('i') with bounds (*)\n"
"nsources_offsets : input rank-1 array('i') with bounds (*)\n"
"nsources_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"centers : input rank-2 array('d') with bounds (3,*)\n"
"centers_offsets : input rank-1 array('i') with bounds (nvcount)\n"
"nterms : input int\n"
"\nOther Parameters\n----------------\n"
"nvcount : input int, optional\n    Default: (len(sources_starts)-1)\n"
"\nReturns\n-------\n"
"ier : rank-1 array('i') with bounds (nvcount)\n"
"expn : rank-3 array('D') with bounds (nterms + 1,2 * nterms + 1,nvcount)";
/* extern void F_FUNC_US(l3dformta_dp_imany,L3DFORMTA_DP_IMANY)(int*,double*,double*,int*,int*,complex_double*,int*,int*,double*,int*,int*,int*,int*,int*,double*,int*,int*,complex_double*,int*); */
static PyObject *f2py_rout__internal_l3dformta_dp_imany(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*,int*,int*,complex_double*,int*,int*,double*,int*,int*,int*,int*,int*,double*,int*,int*,complex_double*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int *ier = NULL;
  npy_intp ier_Dims[1] = {-1};
  const int ier_Rank = 1;
  PyArrayObject *capi_ier_tmp = NULL;
  int capi_ier_intent = 0;
  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *sources = NULL;
  npy_intp sources_Dims[2] = {-1, -1};
  const int sources_Rank = 2;
  PyArrayObject *capi_sources_tmp = NULL;
  int capi_sources_intent = 0;
  PyObject *sources_capi = Py_None;
  int *sources_offsets = NULL;
  npy_intp sources_offsets_Dims[1] = {-1};
  const int sources_offsets_Rank = 1;
  PyArrayObject *capi_sources_offsets_tmp = NULL;
  int capi_sources_offsets_intent = 0;
  PyObject *sources_offsets_capi = Py_None;
  int *sources_starts = NULL;
  npy_intp sources_starts_Dims[1] = {-1};
  const int sources_starts_Rank = 1;
  PyArrayObject *capi_sources_starts_tmp = NULL;
  int capi_sources_starts_intent = 0;
  PyObject *sources_starts_capi = Py_None;
  complex_double *dipstr = NULL;
  npy_intp dipstr_Dims[1] = {-1};
  const int dipstr_Rank = 1;
  PyArrayObject *capi_dipstr_tmp = NULL;
  int capi_dipstr_intent = 0;
  PyObject *dipstr_capi = Py_None;
  int *dipstr_offsets = NULL;
  npy_intp dipstr_offsets_Dims[1] = {-1};
  const int dipstr_offsets_Rank = 1;
  PyArrayObject *capi_dipstr_offsets_tmp = NULL;
  int capi_dipstr_offsets_intent = 0;
  PyObject *dipstr_offsets_capi = Py_None;
  int *dipstr_starts = NULL;
  npy_intp dipstr_starts_Dims[1] = {-1};
  const int dipstr_starts_Rank = 1;
  PyArrayObject *capi_dipstr_starts_tmp = NULL;
  int capi_dipstr_starts_intent = 0;
  PyObject *dipstr_starts_capi = Py_None;
  double *dipvec = NULL;
  npy_intp dipvec_Dims[2] = {-1, -1};
  const int dipvec_Rank = 2;
  PyArrayObject *capi_dipvec_tmp = NULL;
  int capi_dipvec_intent = 0;
  PyObject *dipvec_capi = Py_None;
  int *dipvec_offsets = NULL;
  npy_intp dipvec_offsets_Dims[1] = {-1};
  const int dipvec_offsets_Rank = 1;
  PyArrayObject *capi_dipvec_offsets_tmp = NULL;
  int capi_dipvec_offsets_intent = 0;
  PyObject *dipvec_offsets_capi = Py_None;
  int *dipvec_starts = NULL;
  npy_intp dipvec_starts_Dims[1] = {-1};
  const int dipvec_starts_Rank = 1;
  PyArrayObject *capi_dipvec_starts_tmp = NULL;
  int capi_dipvec_starts_intent = 0;
  PyObject *dipvec_starts_capi = Py_None;
  int *nsources = NULL;
  npy_intp nsources_Dims[1] = {-1};
  const int nsources_Rank = 1;
  PyArrayObject *capi_nsources_tmp = NULL;
  int capi_nsources_intent = 0;
  PyObject *nsources_capi = Py_None;
  int *nsources_offsets = NULL;
  npy_intp nsources_offsets_Dims[1] = {-1};
  const int nsources_offsets_Rank = 1;
  PyArrayObject *capi_nsources_offsets_tmp = NULL;
  int capi_nsources_offsets_intent = 0;
  PyObject *nsources_offsets_capi = Py_None;
  int *nsources_starts = NULL;
  npy_intp nsources_starts_Dims[1] = {-1};
  const int nsources_starts_Rank = 1;
  PyArrayObject *capi_nsources_starts_tmp = NULL;
  int capi_nsources_starts_intent = 0;
  PyObject *nsources_starts_capi = Py_None;
  double *centers = NULL;
  npy_intp centers_Dims[2] = {-1, -1};
  const int centers_Rank = 2;
  PyArrayObject *capi_centers_tmp = NULL;
  int capi_centers_intent = 0;
  PyObject *centers_capi = Py_None;
  int *centers_offsets = NULL;
  npy_intp centers_offsets_Dims[1] = {-1};
  const int centers_offsets_Rank = 1;
  PyArrayObject *capi_centers_offsets_tmp = NULL;
  int capi_centers_offsets_intent = 0;
  PyObject *centers_offsets_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[3] = {-1, -1, -1};
  const int expn_Rank = 3;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"rscale","sources","sources_offsets","sources_starts","dipstr","dipstr_offsets","dipstr_starts","dipvec","dipvec_offsets","dipvec_starts","nsources","nsources_offsets","nsources_starts","centers","centers_offsets","nterms","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOOOOOOOO|O:_internal.l3dformta_dp_imany",\
        capi_kwlist,&rscale_capi,&sources_capi,&sources_offsets_capi,&sources_starts_capi,&dipstr_capi,&dipstr_offsets_capi,&dipstr_starts_capi,&dipvec_capi,&dipvec_offsets_capi,&dipvec_starts_capi,&nsources_capi,&nsources_offsets_capi,&nsources_starts_capi,&centers_capi,&centers_offsets_capi,&nterms_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.l3dformta_dp_imany() 1st argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable sources */
  sources_Dims[0]=3;
  capi_sources_intent |= F2PY_INTENT_IN;
  capi_sources_tmp = array_from_pyobj(NPY_DOUBLE,sources_Dims,sources_Rank,capi_sources_intent,sources_capi);
  if (capi_sources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `sources' of _internal.l3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources = (double *)(PyArray_DATA(capi_sources_tmp));

  /* Processing variable sources_offsets */
  ;
  capi_sources_offsets_intent |= F2PY_INTENT_IN;
  capi_sources_offsets_tmp = array_from_pyobj(NPY_INT,sources_offsets_Dims,sources_offsets_Rank,capi_sources_offsets_intent,sources_offsets_capi);
  if (capi_sources_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `sources_offsets' of _internal.l3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources_offsets = (int *)(PyArray_DATA(capi_sources_offsets_tmp));

  /* Processing variable sources_starts */
  ;
  capi_sources_starts_intent |= F2PY_INTENT_IN;
  capi_sources_starts_tmp = array_from_pyobj(NPY_INT,sources_starts_Dims,sources_starts_Rank,capi_sources_starts_intent,sources_starts_capi);
  if (capi_sources_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `sources_starts' of _internal.l3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources_starts = (int *)(PyArray_DATA(capi_sources_starts_tmp));

  /* Processing variable dipstr */
  ;
  capi_dipstr_intent |= F2PY_INTENT_IN;
  capi_dipstr_tmp = array_from_pyobj(NPY_CDOUBLE,dipstr_Dims,dipstr_Rank,capi_dipstr_intent,dipstr_capi);
  if (capi_dipstr_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `dipstr' of _internal.l3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr = (complex_double *)(PyArray_DATA(capi_dipstr_tmp));

  /* Processing variable dipstr_offsets */
  ;
  capi_dipstr_offsets_intent |= F2PY_INTENT_IN;
  capi_dipstr_offsets_tmp = array_from_pyobj(NPY_INT,dipstr_offsets_Dims,dipstr_offsets_Rank,capi_dipstr_offsets_intent,dipstr_offsets_capi);
  if (capi_dipstr_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `dipstr_offsets' of _internal.l3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr_offsets = (int *)(PyArray_DATA(capi_dipstr_offsets_tmp));

  /* Processing variable dipvec */
  dipvec_Dims[0]=3;
  capi_dipvec_intent |= F2PY_INTENT_IN;
  capi_dipvec_tmp = array_from_pyobj(NPY_DOUBLE,dipvec_Dims,dipvec_Rank,capi_dipvec_intent,dipvec_capi);
  if (capi_dipvec_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 8th argument `dipvec' of _internal.l3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipvec = (double *)(PyArray_DATA(capi_dipvec_tmp));

  /* Processing variable dipvec_offsets */
  ;
  capi_dipvec_offsets_intent |= F2PY_INTENT_IN;
  capi_dipvec_offsets_tmp = array_from_pyobj(NPY_INT,dipvec_offsets_Dims,dipvec_offsets_Rank,capi_dipvec_offsets_intent,dipvec_offsets_capi);
  if (capi_dipvec_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 9th argument `dipvec_offsets' of _internal.l3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipvec_offsets = (int *)(PyArray_DATA(capi_dipvec_offsets_tmp));

  /* Processing variable nsources */
  ;
  capi_nsources_intent |= F2PY_INTENT_IN;
  capi_nsources_tmp = array_from_pyobj(NPY_INT,nsources_Dims,nsources_Rank,capi_nsources_intent,nsources_capi);
  if (capi_nsources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 11st argument `nsources' of _internal.l3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    nsources = (int *)(PyArray_DATA(capi_nsources_tmp));

  /* Processing variable nsources_offsets */
  ;
  capi_nsources_offsets_intent |= F2PY_INTENT_IN;
  capi_nsources_offsets_tmp = array_from_pyobj(NPY_INT,nsources_offsets_Dims,nsources_offsets_Rank,capi_nsources_offsets_intent,nsources_offsets_capi);
  if (capi_nsources_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 12nd argument `nsources_offsets' of _internal.l3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    nsources_offsets = (int *)(PyArray_DATA(capi_nsources_offsets_tmp));

  /* Processing variable centers */
  centers_Dims[0]=3;
  capi_centers_intent |= F2PY_INTENT_IN;
  capi_centers_tmp = array_from_pyobj(NPY_DOUBLE,centers_Dims,centers_Rank,capi_centers_intent,centers_capi);
  if (capi_centers_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 14th argument `centers' of _internal.l3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    centers = (double *)(PyArray_DATA(capi_centers_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.l3dformta_dp_imany() 16th argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = (len(sources_starts)-1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.l3dformta_dp_imany() 1st keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((len(sources_starts)-1)>=nvcount,"(len(sources_starts)-1)>=nvcount","1st keyword nvcount","l3dformta_dp_imany:nvcount=%d",nvcount) {
  /* Processing variable ier */
  ier_Dims[0]=nvcount;
  capi_ier_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_ier_tmp = array_from_pyobj(NPY_INT,ier_Dims,ier_Rank,capi_ier_intent,Py_None);
  if (capi_ier_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `ier' of _internal.l3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ier = (int *)(PyArray_DATA(capi_ier_tmp));

  /* Processing variable dipstr_starts */
  dipstr_starts_Dims[0]=nvcount + 1;
  capi_dipstr_starts_intent |= F2PY_INTENT_IN;
  capi_dipstr_starts_tmp = array_from_pyobj(NPY_INT,dipstr_starts_Dims,dipstr_starts_Rank,capi_dipstr_starts_intent,dipstr_starts_capi);
  if (capi_dipstr_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 7th argument `dipstr_starts' of _internal.l3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr_starts = (int *)(PyArray_DATA(capi_dipstr_starts_tmp));

  /* Processing variable dipvec_starts */
  dipvec_starts_Dims[0]=nvcount + 1;
  capi_dipvec_starts_intent |= F2PY_INTENT_IN;
  capi_dipvec_starts_tmp = array_from_pyobj(NPY_INT,dipvec_starts_Dims,dipvec_starts_Rank,capi_dipvec_starts_intent,dipvec_starts_capi);
  if (capi_dipvec_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 10th argument `dipvec_starts' of _internal.l3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipvec_starts = (int *)(PyArray_DATA(capi_dipvec_starts_tmp));

  /* Processing variable nsources_starts */
  nsources_starts_Dims[0]=nvcount + 1;
  capi_nsources_starts_intent |= F2PY_INTENT_IN;
  capi_nsources_starts_tmp = array_from_pyobj(NPY_INT,nsources_starts_Dims,nsources_starts_Rank,capi_nsources_starts_intent,nsources_starts_capi);
  if (capi_nsources_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 13rd argument `nsources_starts' of _internal.l3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    nsources_starts = (int *)(PyArray_DATA(capi_nsources_starts_tmp));

  /* Processing variable centers_offsets */
  centers_offsets_Dims[0]=nvcount;
  capi_centers_offsets_intent |= F2PY_INTENT_IN;
  capi_centers_offsets_tmp = array_from_pyobj(NPY_INT,centers_offsets_Dims,centers_offsets_Rank,capi_centers_offsets_intent,centers_offsets_capi);
  if (capi_centers_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 15th argument `centers_offsets' of _internal.l3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    centers_offsets = (int *)(PyArray_DATA(capi_centers_offsets_tmp));

  /* Processing variable expn */
  expn_Dims[0]=nterms + 1,expn_Dims[1]=2 * nterms + 1,expn_Dims[2]=nvcount;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.l3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(ier,&rscale,sources,sources_offsets,sources_starts,dipstr,dipstr_offsets,dipstr_starts,dipvec,dipvec_offsets,dipvec_starts,nsources,nsources_offsets,nsources_starts,centers,centers_offsets,&nterms,expn,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NN",capi_ier_tmp,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  if((PyObject *)capi_centers_offsets_tmp!=centers_offsets_capi) {
    Py_XDECREF(capi_centers_offsets_tmp); }
  }  /*if (capi_centers_offsets_tmp == NULL) ... else of centers_offsets*/
  /* End of cleaning variable centers_offsets */
  if((PyObject *)capi_nsources_starts_tmp!=nsources_starts_capi) {
    Py_XDECREF(capi_nsources_starts_tmp); }
  }  /*if (capi_nsources_starts_tmp == NULL) ... else of nsources_starts*/
  /* End of cleaning variable nsources_starts */
  if((PyObject *)capi_dipvec_starts_tmp!=dipvec_starts_capi) {
    Py_XDECREF(capi_dipvec_starts_tmp); }
  }  /*if (capi_dipvec_starts_tmp == NULL) ... else of dipvec_starts*/
  /* End of cleaning variable dipvec_starts */
  if((PyObject *)capi_dipstr_starts_tmp!=dipstr_starts_capi) {
    Py_XDECREF(capi_dipstr_starts_tmp); }
  }  /*if (capi_dipstr_starts_tmp == NULL) ... else of dipstr_starts*/
  /* End of cleaning variable dipstr_starts */
  }  /*if (capi_ier_tmp == NULL) ... else of ier*/
  /* End of cleaning variable ier */
  } /*CHECKSCALAR((len(sources_starts)-1)>=nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_centers_tmp!=centers_capi) {
    Py_XDECREF(capi_centers_tmp); }
  }  /*if (capi_centers_tmp == NULL) ... else of centers*/
  /* End of cleaning variable centers */
  if((PyObject *)capi_nsources_offsets_tmp!=nsources_offsets_capi) {
    Py_XDECREF(capi_nsources_offsets_tmp); }
  }  /*if (capi_nsources_offsets_tmp == NULL) ... else of nsources_offsets*/
  /* End of cleaning variable nsources_offsets */
  if((PyObject *)capi_nsources_tmp!=nsources_capi) {
    Py_XDECREF(capi_nsources_tmp); }
  }  /*if (capi_nsources_tmp == NULL) ... else of nsources*/
  /* End of cleaning variable nsources */
  if((PyObject *)capi_dipvec_offsets_tmp!=dipvec_offsets_capi) {
    Py_XDECREF(capi_dipvec_offsets_tmp); }
  }  /*if (capi_dipvec_offsets_tmp == NULL) ... else of dipvec_offsets*/
  /* End of cleaning variable dipvec_offsets */
  if((PyObject *)capi_dipvec_tmp!=dipvec_capi) {
    Py_XDECREF(capi_dipvec_tmp); }
  }  /*if (capi_dipvec_tmp == NULL) ... else of dipvec*/
  /* End of cleaning variable dipvec */
  if((PyObject *)capi_dipstr_offsets_tmp!=dipstr_offsets_capi) {
    Py_XDECREF(capi_dipstr_offsets_tmp); }
  }  /*if (capi_dipstr_offsets_tmp == NULL) ... else of dipstr_offsets*/
  /* End of cleaning variable dipstr_offsets */
  if((PyObject *)capi_dipstr_tmp!=dipstr_capi) {
    Py_XDECREF(capi_dipstr_tmp); }
  }  /*if (capi_dipstr_tmp == NULL) ... else of dipstr*/
  /* End of cleaning variable dipstr */
  if((PyObject *)capi_sources_starts_tmp!=sources_starts_capi) {
    Py_XDECREF(capi_sources_starts_tmp); }
  }  /*if (capi_sources_starts_tmp == NULL) ... else of sources_starts*/
  /* End of cleaning variable sources_starts */
  if((PyObject *)capi_sources_offsets_tmp!=sources_offsets_capi) {
    Py_XDECREF(capi_sources_offsets_tmp); }
  }  /*if (capi_sources_offsets_tmp == NULL) ... else of sources_offsets*/
  /* End of cleaning variable sources_offsets */
  if((PyObject *)capi_sources_tmp!=sources_capi) {
    Py_XDECREF(capi_sources_tmp); }
  }  /*if (capi_sources_tmp == NULL) ... else of sources*/
  /* End of cleaning variable sources */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/************************* end of l3dformta_dp_imany *************************/

/***************************** h3dformta_dp_imany *****************************/
static char doc_f2py_rout__internal_h3dformta_dp_imany[] = "\
ier,expn = h3dformta_dp_imany(zk,rscale,sources,sources_offsets,sources_starts,dipstr,dipstr_offsets,dipstr_starts,dipvec,dipvec_offsets,dipvec_starts,nsources,nsources_offsets,nsources_starts,centers,centers_offsets,nterms,[nvcount])\n\nWrapper for ``h3dformta_dp_imany``.\
\n\nParameters\n----------\n"
"zk : input complex\n"
"rscale : input float\n"
"sources : input rank-2 array('d') with bounds (3,*)\n"
"sources_offsets : input rank-1 array('i') with bounds (*)\n"
"sources_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"dipstr : input rank-1 array('D') with bounds (*)\n"
"dipstr_offsets : input rank-1 array('i') with bounds (*)\n"
"dipstr_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"dipvec : input rank-2 array('d') with bounds (3,*)\n"
"dipvec_offsets : input rank-1 array('i') with bounds (*)\n"
"dipvec_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"nsources : input rank-1 array('i') with bounds (*)\n"
"nsources_offsets : input rank-1 array('i') with bounds (*)\n"
"nsources_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"centers : input rank-2 array('d') with bounds (3,*)\n"
"centers_offsets : input rank-1 array('i') with bounds (nvcount)\n"
"nterms : input int\n"
"\nOther Parameters\n----------------\n"
"nvcount : input int, optional\n    Default: (len(sources_starts)-1)\n"
"\nReturns\n-------\n"
"ier : rank-1 array('i') with bounds (nvcount)\n"
"expn : rank-3 array('D') with bounds (nterms + 1,2 * nterms + 1,nvcount)";
/* extern void F_FUNC_US(h3dformta_dp_imany,H3DFORMTA_DP_IMANY)(int*,complex_double*,double*,double*,int*,int*,complex_double*,int*,int*,double*,int*,int*,int*,int*,int*,double*,int*,int*,complex_double*,int*); */
static PyObject *f2py_rout__internal_h3dformta_dp_imany(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,complex_double*,double*,double*,int*,int*,complex_double*,int*,int*,double*,int*,int*,int*,int*,int*,double*,int*,int*,complex_double*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int *ier = NULL;
  npy_intp ier_Dims[1] = {-1};
  const int ier_Rank = 1;
  PyArrayObject *capi_ier_tmp = NULL;
  int capi_ier_intent = 0;
  complex_double zk;
  PyObject *zk_capi = Py_None;
  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *sources = NULL;
  npy_intp sources_Dims[2] = {-1, -1};
  const int sources_Rank = 2;
  PyArrayObject *capi_sources_tmp = NULL;
  int capi_sources_intent = 0;
  PyObject *sources_capi = Py_None;
  int *sources_offsets = NULL;
  npy_intp sources_offsets_Dims[1] = {-1};
  const int sources_offsets_Rank = 1;
  PyArrayObject *capi_sources_offsets_tmp = NULL;
  int capi_sources_offsets_intent = 0;
  PyObject *sources_offsets_capi = Py_None;
  int *sources_starts = NULL;
  npy_intp sources_starts_Dims[1] = {-1};
  const int sources_starts_Rank = 1;
  PyArrayObject *capi_sources_starts_tmp = NULL;
  int capi_sources_starts_intent = 0;
  PyObject *sources_starts_capi = Py_None;
  complex_double *dipstr = NULL;
  npy_intp dipstr_Dims[1] = {-1};
  const int dipstr_Rank = 1;
  PyArrayObject *capi_dipstr_tmp = NULL;
  int capi_dipstr_intent = 0;
  PyObject *dipstr_capi = Py_None;
  int *dipstr_offsets = NULL;
  npy_intp dipstr_offsets_Dims[1] = {-1};
  const int dipstr_offsets_Rank = 1;
  PyArrayObject *capi_dipstr_offsets_tmp = NULL;
  int capi_dipstr_offsets_intent = 0;
  PyObject *dipstr_offsets_capi = Py_None;
  int *dipstr_starts = NULL;
  npy_intp dipstr_starts_Dims[1] = {-1};
  const int dipstr_starts_Rank = 1;
  PyArrayObject *capi_dipstr_starts_tmp = NULL;
  int capi_dipstr_starts_intent = 0;
  PyObject *dipstr_starts_capi = Py_None;
  double *dipvec = NULL;
  npy_intp dipvec_Dims[2] = {-1, -1};
  const int dipvec_Rank = 2;
  PyArrayObject *capi_dipvec_tmp = NULL;
  int capi_dipvec_intent = 0;
  PyObject *dipvec_capi = Py_None;
  int *dipvec_offsets = NULL;
  npy_intp dipvec_offsets_Dims[1] = {-1};
  const int dipvec_offsets_Rank = 1;
  PyArrayObject *capi_dipvec_offsets_tmp = NULL;
  int capi_dipvec_offsets_intent = 0;
  PyObject *dipvec_offsets_capi = Py_None;
  int *dipvec_starts = NULL;
  npy_intp dipvec_starts_Dims[1] = {-1};
  const int dipvec_starts_Rank = 1;
  PyArrayObject *capi_dipvec_starts_tmp = NULL;
  int capi_dipvec_starts_intent = 0;
  PyObject *dipvec_starts_capi = Py_None;
  int *nsources = NULL;
  npy_intp nsources_Dims[1] = {-1};
  const int nsources_Rank = 1;
  PyArrayObject *capi_nsources_tmp = NULL;
  int capi_nsources_intent = 0;
  PyObject *nsources_capi = Py_None;
  int *nsources_offsets = NULL;
  npy_intp nsources_offsets_Dims[1] = {-1};
  const int nsources_offsets_Rank = 1;
  PyArrayObject *capi_nsources_offsets_tmp = NULL;
  int capi_nsources_offsets_intent = 0;
  PyObject *nsources_offsets_capi = Py_None;
  int *nsources_starts = NULL;
  npy_intp nsources_starts_Dims[1] = {-1};
  const int nsources_starts_Rank = 1;
  PyArrayObject *capi_nsources_starts_tmp = NULL;
  int capi_nsources_starts_intent = 0;
  PyObject *nsources_starts_capi = Py_None;
  double *centers = NULL;
  npy_intp centers_Dims[2] = {-1, -1};
  const int centers_Rank = 2;
  PyArrayObject *capi_centers_tmp = NULL;
  int capi_centers_intent = 0;
  PyObject *centers_capi = Py_None;
  int *centers_offsets = NULL;
  npy_intp centers_offsets_Dims[1] = {-1};
  const int centers_offsets_Rank = 1;
  PyArrayObject *capi_centers_offsets_tmp = NULL;
  int capi_centers_offsets_intent = 0;
  PyObject *centers_offsets_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[3] = {-1, -1, -1};
  const int expn_Rank = 3;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"zk","rscale","sources","sources_offsets","sources_starts","dipstr","dipstr_offsets","dipstr_starts","dipvec","dipvec_offsets","dipvec_starts","nsources","nsources_offsets","nsources_starts","centers","centers_offsets","nterms","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOOOOOOOOO|O:_internal.h3dformta_dp_imany",\
        capi_kwlist,&zk_capi,&rscale_capi,&sources_capi,&sources_offsets_capi,&sources_starts_capi,&dipstr_capi,&dipstr_offsets_capi,&dipstr_starts_capi,&dipvec_capi,&dipvec_offsets_capi,&dipvec_starts_capi,&nsources_capi,&nsources_offsets_capi,&nsources_starts_capi,&centers_capi,&centers_offsets_capi,&nterms_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.h3dformta_dp_imany() 1st argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.h3dformta_dp_imany() 2nd argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable sources */
  sources_Dims[0]=3;
  capi_sources_intent |= F2PY_INTENT_IN;
  capi_sources_tmp = array_from_pyobj(NPY_DOUBLE,sources_Dims,sources_Rank,capi_sources_intent,sources_capi);
  if (capi_sources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `sources' of _internal.h3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources = (double *)(PyArray_DATA(capi_sources_tmp));

  /* Processing variable sources_offsets */
  ;
  capi_sources_offsets_intent |= F2PY_INTENT_IN;
  capi_sources_offsets_tmp = array_from_pyobj(NPY_INT,sources_offsets_Dims,sources_offsets_Rank,capi_sources_offsets_intent,sources_offsets_capi);
  if (capi_sources_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `sources_offsets' of _internal.h3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources_offsets = (int *)(PyArray_DATA(capi_sources_offsets_tmp));

  /* Processing variable sources_starts */
  ;
  capi_sources_starts_intent |= F2PY_INTENT_IN;
  capi_sources_starts_tmp = array_from_pyobj(NPY_INT,sources_starts_Dims,sources_starts_Rank,capi_sources_starts_intent,sources_starts_capi);
  if (capi_sources_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `sources_starts' of _internal.h3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources_starts = (int *)(PyArray_DATA(capi_sources_starts_tmp));

  /* Processing variable dipstr */
  ;
  capi_dipstr_intent |= F2PY_INTENT_IN;
  capi_dipstr_tmp = array_from_pyobj(NPY_CDOUBLE,dipstr_Dims,dipstr_Rank,capi_dipstr_intent,dipstr_capi);
  if (capi_dipstr_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `dipstr' of _internal.h3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr = (complex_double *)(PyArray_DATA(capi_dipstr_tmp));

  /* Processing variable dipstr_offsets */
  ;
  capi_dipstr_offsets_intent |= F2PY_INTENT_IN;
  capi_dipstr_offsets_tmp = array_from_pyobj(NPY_INT,dipstr_offsets_Dims,dipstr_offsets_Rank,capi_dipstr_offsets_intent,dipstr_offsets_capi);
  if (capi_dipstr_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 7th argument `dipstr_offsets' of _internal.h3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr_offsets = (int *)(PyArray_DATA(capi_dipstr_offsets_tmp));

  /* Processing variable dipvec */
  dipvec_Dims[0]=3;
  capi_dipvec_intent |= F2PY_INTENT_IN;
  capi_dipvec_tmp = array_from_pyobj(NPY_DOUBLE,dipvec_Dims,dipvec_Rank,capi_dipvec_intent,dipvec_capi);
  if (capi_dipvec_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 9th argument `dipvec' of _internal.h3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipvec = (double *)(PyArray_DATA(capi_dipvec_tmp));

  /* Processing variable dipvec_offsets */
  ;
  capi_dipvec_offsets_intent |= F2PY_INTENT_IN;
  capi_dipvec_offsets_tmp = array_from_pyobj(NPY_INT,dipvec_offsets_Dims,dipvec_offsets_Rank,capi_dipvec_offsets_intent,dipvec_offsets_capi);
  if (capi_dipvec_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 10th argument `dipvec_offsets' of _internal.h3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipvec_offsets = (int *)(PyArray_DATA(capi_dipvec_offsets_tmp));

  /* Processing variable nsources */
  ;
  capi_nsources_intent |= F2PY_INTENT_IN;
  capi_nsources_tmp = array_from_pyobj(NPY_INT,nsources_Dims,nsources_Rank,capi_nsources_intent,nsources_capi);
  if (capi_nsources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 12nd argument `nsources' of _internal.h3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    nsources = (int *)(PyArray_DATA(capi_nsources_tmp));

  /* Processing variable nsources_offsets */
  ;
  capi_nsources_offsets_intent |= F2PY_INTENT_IN;
  capi_nsources_offsets_tmp = array_from_pyobj(NPY_INT,nsources_offsets_Dims,nsources_offsets_Rank,capi_nsources_offsets_intent,nsources_offsets_capi);
  if (capi_nsources_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 13rd argument `nsources_offsets' of _internal.h3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    nsources_offsets = (int *)(PyArray_DATA(capi_nsources_offsets_tmp));

  /* Processing variable centers */
  centers_Dims[0]=3;
  capi_centers_intent |= F2PY_INTENT_IN;
  capi_centers_tmp = array_from_pyobj(NPY_DOUBLE,centers_Dims,centers_Rank,capi_centers_intent,centers_capi);
  if (capi_centers_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 15th argument `centers' of _internal.h3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    centers = (double *)(PyArray_DATA(capi_centers_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.h3dformta_dp_imany() 17th argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = (len(sources_starts)-1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.h3dformta_dp_imany() 1st keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((len(sources_starts)-1)>=nvcount,"(len(sources_starts)-1)>=nvcount","1st keyword nvcount","h3dformta_dp_imany:nvcount=%d",nvcount) {
  /* Processing variable ier */
  ier_Dims[0]=nvcount;
  capi_ier_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_ier_tmp = array_from_pyobj(NPY_INT,ier_Dims,ier_Rank,capi_ier_intent,Py_None);
  if (capi_ier_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `ier' of _internal.h3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ier = (int *)(PyArray_DATA(capi_ier_tmp));

  /* Processing variable dipstr_starts */
  dipstr_starts_Dims[0]=nvcount + 1;
  capi_dipstr_starts_intent |= F2PY_INTENT_IN;
  capi_dipstr_starts_tmp = array_from_pyobj(NPY_INT,dipstr_starts_Dims,dipstr_starts_Rank,capi_dipstr_starts_intent,dipstr_starts_capi);
  if (capi_dipstr_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 8th argument `dipstr_starts' of _internal.h3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr_starts = (int *)(PyArray_DATA(capi_dipstr_starts_tmp));

  /* Processing variable dipvec_starts */
  dipvec_starts_Dims[0]=nvcount + 1;
  capi_dipvec_starts_intent |= F2PY_INTENT_IN;
  capi_dipvec_starts_tmp = array_from_pyobj(NPY_INT,dipvec_starts_Dims,dipvec_starts_Rank,capi_dipvec_starts_intent,dipvec_starts_capi);
  if (capi_dipvec_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 11st argument `dipvec_starts' of _internal.h3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipvec_starts = (int *)(PyArray_DATA(capi_dipvec_starts_tmp));

  /* Processing variable nsources_starts */
  nsources_starts_Dims[0]=nvcount + 1;
  capi_nsources_starts_intent |= F2PY_INTENT_IN;
  capi_nsources_starts_tmp = array_from_pyobj(NPY_INT,nsources_starts_Dims,nsources_starts_Rank,capi_nsources_starts_intent,nsources_starts_capi);
  if (capi_nsources_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 14th argument `nsources_starts' of _internal.h3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    nsources_starts = (int *)(PyArray_DATA(capi_nsources_starts_tmp));

  /* Processing variable centers_offsets */
  centers_offsets_Dims[0]=nvcount;
  capi_centers_offsets_intent |= F2PY_INTENT_IN;
  capi_centers_offsets_tmp = array_from_pyobj(NPY_INT,centers_offsets_Dims,centers_offsets_Rank,capi_centers_offsets_intent,centers_offsets_capi);
  if (capi_centers_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 16th argument `centers_offsets' of _internal.h3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    centers_offsets = (int *)(PyArray_DATA(capi_centers_offsets_tmp));

  /* Processing variable expn */
  expn_Dims[0]=nterms + 1,expn_Dims[1]=2 * nterms + 1,expn_Dims[2]=nvcount;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.h3dformta_dp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(ier,&zk,&rscale,sources,sources_offsets,sources_starts,dipstr,dipstr_offsets,dipstr_starts,dipvec,dipvec_offsets,dipvec_starts,nsources,nsources_offsets,nsources_starts,centers,centers_offsets,&nterms,expn,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NN",capi_ier_tmp,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  if((PyObject *)capi_centers_offsets_tmp!=centers_offsets_capi) {
    Py_XDECREF(capi_centers_offsets_tmp); }
  }  /*if (capi_centers_offsets_tmp == NULL) ... else of centers_offsets*/
  /* End of cleaning variable centers_offsets */
  if((PyObject *)capi_nsources_starts_tmp!=nsources_starts_capi) {
    Py_XDECREF(capi_nsources_starts_tmp); }
  }  /*if (capi_nsources_starts_tmp == NULL) ... else of nsources_starts*/
  /* End of cleaning variable nsources_starts */
  if((PyObject *)capi_dipvec_starts_tmp!=dipvec_starts_capi) {
    Py_XDECREF(capi_dipvec_starts_tmp); }
  }  /*if (capi_dipvec_starts_tmp == NULL) ... else of dipvec_starts*/
  /* End of cleaning variable dipvec_starts */
  if((PyObject *)capi_dipstr_starts_tmp!=dipstr_starts_capi) {
    Py_XDECREF(capi_dipstr_starts_tmp); }
  }  /*if (capi_dipstr_starts_tmp == NULL) ... else of dipstr_starts*/
  /* End of cleaning variable dipstr_starts */
  }  /*if (capi_ier_tmp == NULL) ... else of ier*/
  /* End of cleaning variable ier */
  } /*CHECKSCALAR((len(sources_starts)-1)>=nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_centers_tmp!=centers_capi) {
    Py_XDECREF(capi_centers_tmp); }
  }  /*if (capi_centers_tmp == NULL) ... else of centers*/
  /* End of cleaning variable centers */
  if((PyObject *)capi_nsources_offsets_tmp!=nsources_offsets_capi) {
    Py_XDECREF(capi_nsources_offsets_tmp); }
  }  /*if (capi_nsources_offsets_tmp == NULL) ... else of nsources_offsets*/
  /* End of cleaning variable nsources_offsets */
  if((PyObject *)capi_nsources_tmp!=nsources_capi) {
    Py_XDECREF(capi_nsources_tmp); }
  }  /*if (capi_nsources_tmp == NULL) ... else of nsources*/
  /* End of cleaning variable nsources */
  if((PyObject *)capi_dipvec_offsets_tmp!=dipvec_offsets_capi) {
    Py_XDECREF(capi_dipvec_offsets_tmp); }
  }  /*if (capi_dipvec_offsets_tmp == NULL) ... else of dipvec_offsets*/
  /* End of cleaning variable dipvec_offsets */
  if((PyObject *)capi_dipvec_tmp!=dipvec_capi) {
    Py_XDECREF(capi_dipvec_tmp); }
  }  /*if (capi_dipvec_tmp == NULL) ... else of dipvec*/
  /* End of cleaning variable dipvec */
  if((PyObject *)capi_dipstr_offsets_tmp!=dipstr_offsets_capi) {
    Py_XDECREF(capi_dipstr_offsets_tmp); }
  }  /*if (capi_dipstr_offsets_tmp == NULL) ... else of dipstr_offsets*/
  /* End of cleaning variable dipstr_offsets */
  if((PyObject *)capi_dipstr_tmp!=dipstr_capi) {
    Py_XDECREF(capi_dipstr_tmp); }
  }  /*if (capi_dipstr_tmp == NULL) ... else of dipstr*/
  /* End of cleaning variable dipstr */
  if((PyObject *)capi_sources_starts_tmp!=sources_starts_capi) {
    Py_XDECREF(capi_sources_starts_tmp); }
  }  /*if (capi_sources_starts_tmp == NULL) ... else of sources_starts*/
  /* End of cleaning variable sources_starts */
  if((PyObject *)capi_sources_offsets_tmp!=sources_offsets_capi) {
    Py_XDECREF(capi_sources_offsets_tmp); }
  }  /*if (capi_sources_offsets_tmp == NULL) ... else of sources_offsets*/
  /* End of cleaning variable sources_offsets */
  if((PyObject *)capi_sources_tmp!=sources_capi) {
    Py_XDECREF(capi_sources_tmp); }
  }  /*if (capi_sources_tmp == NULL) ... else of sources*/
  /* End of cleaning variable sources */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/************************* end of h3dformta_dp_imany *************************/

/******************************* l2dformta_qbx *******************************/
static char doc_f2py_rout__internal_l2dformta_qbx[] = "\
ier,expn = l2dformta_qbx(sources,charge,qbx_centers,global_qbx_centers,qbx_expansion_radii,qbx_center_to_target_box,nterms,source_box_starts,source_box_lists,box_source_starts,box_source_counts_nonchild,[nsources,ntgt_centers,nqbx_centers])\n\nWrapper for ``l2dformta_qbx``.\
\n\nParameters\n----------\n"
"sources : input rank-2 array('d') with bounds (2,nsources)\n"
"charge : input rank-1 array('D') with bounds (*)\n"
"qbx_centers : input rank-2 array('d') with bounds (nqbx_centers,2)\n"
"global_qbx_centers : input rank-1 array('i') with bounds (ntgt_centers)\n"
"qbx_expansion_radii : input rank-1 array('d') with bounds (nqbx_centers)\n"
"qbx_center_to_target_box : input rank-1 array('i') with bounds (nqbx_centers)\n"
"nterms : input int\n"
"source_box_starts : input rank-1 array('i') with bounds (*)\n"
"source_box_lists : input rank-1 array('i') with bounds (*)\n"
"box_source_starts : input rank-1 array('i') with bounds (*)\n"
"box_source_counts_nonchild : input rank-1 array('i') with bounds (*)\n"
"\nOther Parameters\n----------------\n"
"nsources : input int, optional\n    Default: shape(sources,1)\n"
"ntgt_centers : input int, optional\n    Default: len(global_qbx_centers)\n"
"nqbx_centers : input int, optional\n    Default: shape(qbx_centers,0)\n"
"\nReturns\n-------\n"
"ier : int\n"
"expn : rank-2 array('D') with bounds (nterms + 1,nqbx_centers)";
/* extern void F_FUNC_US(l2dformta_qbx,L2DFORMTA_QBX)(int*,int*,double*,complex_double*,int*,int*,double*,int*,double*,int*,int*,int*,int*,int*,int*,complex_double*); */
static PyObject *f2py_rout__internal_l2dformta_qbx(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*,complex_double*,int*,int*,double*,int*,double*,int*,int*,int*,int*,int*,int*,complex_double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ier = 0;
  int nsources = 0;
  PyObject *nsources_capi = Py_None;
  double *sources = NULL;
  npy_intp sources_Dims[2] = {-1, -1};
  const int sources_Rank = 2;
  PyArrayObject *capi_sources_tmp = NULL;
  int capi_sources_intent = 0;
  PyObject *sources_capi = Py_None;
  complex_double *charge = NULL;
  npy_intp charge_Dims[1] = {-1};
  const int charge_Rank = 1;
  PyArrayObject *capi_charge_tmp = NULL;
  int capi_charge_intent = 0;
  PyObject *charge_capi = Py_None;
  int ntgt_centers = 0;
  PyObject *ntgt_centers_capi = Py_None;
  int nqbx_centers = 0;
  PyObject *nqbx_centers_capi = Py_None;
  double *qbx_centers = NULL;
  npy_intp qbx_centers_Dims[2] = {-1, -1};
  const int qbx_centers_Rank = 2;
  PyArrayObject *capi_qbx_centers_tmp = NULL;
  int capi_qbx_centers_intent = 0;
  PyObject *qbx_centers_capi = Py_None;
  int *global_qbx_centers = NULL;
  npy_intp global_qbx_centers_Dims[1] = {-1};
  const int global_qbx_centers_Rank = 1;
  PyArrayObject *capi_global_qbx_centers_tmp = NULL;
  int capi_global_qbx_centers_intent = 0;
  PyObject *global_qbx_centers_capi = Py_None;
  double *qbx_expansion_radii = NULL;
  npy_intp qbx_expansion_radii_Dims[1] = {-1};
  const int qbx_expansion_radii_Rank = 1;
  PyArrayObject *capi_qbx_expansion_radii_tmp = NULL;
  int capi_qbx_expansion_radii_intent = 0;
  PyObject *qbx_expansion_radii_capi = Py_None;
  int *qbx_center_to_target_box = NULL;
  npy_intp qbx_center_to_target_box_Dims[1] = {-1};
  const int qbx_center_to_target_box_Rank = 1;
  PyArrayObject *capi_qbx_center_to_target_box_tmp = NULL;
  int capi_qbx_center_to_target_box_intent = 0;
  PyObject *qbx_center_to_target_box_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  int *source_box_starts = NULL;
  npy_intp source_box_starts_Dims[1] = {-1};
  const int source_box_starts_Rank = 1;
  PyArrayObject *capi_source_box_starts_tmp = NULL;
  int capi_source_box_starts_intent = 0;
  PyObject *source_box_starts_capi = Py_None;
  int *source_box_lists = NULL;
  npy_intp source_box_lists_Dims[1] = {-1};
  const int source_box_lists_Rank = 1;
  PyArrayObject *capi_source_box_lists_tmp = NULL;
  int capi_source_box_lists_intent = 0;
  PyObject *source_box_lists_capi = Py_None;
  int *box_source_starts = NULL;
  npy_intp box_source_starts_Dims[1] = {-1};
  const int box_source_starts_Rank = 1;
  PyArrayObject *capi_box_source_starts_tmp = NULL;
  int capi_box_source_starts_intent = 0;
  PyObject *box_source_starts_capi = Py_None;
  int *box_source_counts_nonchild = NULL;
  npy_intp box_source_counts_nonchild_Dims[1] = {-1};
  const int box_source_counts_nonchild_Rank = 1;
  PyArrayObject *capi_box_source_counts_nonchild_tmp = NULL;
  int capi_box_source_counts_nonchild_intent = 0;
  PyObject *box_source_counts_nonchild_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[2] = {-1, -1};
  const int expn_Rank = 2;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
    static char *capi_kwlist[] = {"sources","charge","qbx_centers","global_qbx_centers","qbx_expansion_radii","qbx_center_to_target_box","nterms","source_box_starts","source_box_lists","box_source_starts","box_source_counts_nonchild","nsources","ntgt_centers","nqbx_centers",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOOO|OOO:_internal.l2dformta_qbx",\
        capi_kwlist,&sources_capi,&charge_capi,&qbx_centers_capi,&global_qbx_centers_capi,&qbx_expansion_radii_capi,&qbx_center_to_target_box_capi,&nterms_capi,&source_box_starts_capi,&source_box_lists_capi,&box_source_starts_capi,&box_source_counts_nonchild_capi,&nsources_capi,&ntgt_centers_capi,&nqbx_centers_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable ier */
  /* Processing variable sources */
  sources_Dims[0]=2;
  capi_sources_intent |= F2PY_INTENT_IN;
  capi_sources_tmp = array_from_pyobj(NPY_DOUBLE,sources_Dims,sources_Rank,capi_sources_intent,sources_capi);
  if (capi_sources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 1st argument `sources' of _internal.l2dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources = (double *)(PyArray_DATA(capi_sources_tmp));

  /* Processing variable charge */
  ;
  capi_charge_intent |= F2PY_INTENT_IN;
  capi_charge_tmp = array_from_pyobj(NPY_CDOUBLE,charge_Dims,charge_Rank,capi_charge_intent,charge_capi);
  if (capi_charge_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `charge' of _internal.l2dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge = (complex_double *)(PyArray_DATA(capi_charge_tmp));

  /* Processing variable global_qbx_centers */
  ;
  capi_global_qbx_centers_intent |= F2PY_INTENT_IN;
  capi_global_qbx_centers_tmp = array_from_pyobj(NPY_INT,global_qbx_centers_Dims,global_qbx_centers_Rank,capi_global_qbx_centers_intent,global_qbx_centers_capi);
  if (capi_global_qbx_centers_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `global_qbx_centers' of _internal.l2dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    global_qbx_centers = (int *)(PyArray_DATA(capi_global_qbx_centers_tmp));

  /* Processing variable qbx_centers */
  qbx_centers_Dims[1]=2;
  capi_qbx_centers_intent |= F2PY_INTENT_IN;
  capi_qbx_centers_tmp = array_from_pyobj(NPY_DOUBLE,qbx_centers_Dims,qbx_centers_Rank,capi_qbx_centers_intent,qbx_centers_capi);
  if (capi_qbx_centers_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `qbx_centers' of _internal.l2dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    qbx_centers = (double *)(PyArray_DATA(capi_qbx_centers_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.l2dformta_qbx() 7th argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable source_box_starts */
  ;
  capi_source_box_starts_intent |= F2PY_INTENT_IN;
  capi_source_box_starts_tmp = array_from_pyobj(NPY_INT,source_box_starts_Dims,source_box_starts_Rank,capi_source_box_starts_intent,source_box_starts_capi);
  if (capi_source_box_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 8th argument `source_box_starts' of _internal.l2dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source_box_starts = (int *)(PyArray_DATA(capi_source_box_starts_tmp));

  /* Processing variable source_box_lists */
  ;
  capi_source_box_lists_intent |= F2PY_INTENT_IN;
  capi_source_box_lists_tmp = array_from_pyobj(NPY_INT,source_box_lists_Dims,source_box_lists_Rank,capi_source_box_lists_intent,source_box_lists_capi);
  if (capi_source_box_lists_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 9th argument `source_box_lists' of _internal.l2dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source_box_lists = (int *)(PyArray_DATA(capi_source_box_lists_tmp));

  /* Processing variable box_source_starts */
  ;
  capi_box_source_starts_intent |= F2PY_INTENT_IN;
  capi_box_source_starts_tmp = array_from_pyobj(NPY_INT,box_source_starts_Dims,box_source_starts_Rank,capi_box_source_starts_intent,box_source_starts_capi);
  if (capi_box_source_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 10th argument `box_source_starts' of _internal.l2dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    box_source_starts = (int *)(PyArray_DATA(capi_box_source_starts_tmp));

  /* Processing variable box_source_counts_nonchild */
  ;
  capi_box_source_counts_nonchild_intent |= F2PY_INTENT_IN;
  capi_box_source_counts_nonchild_tmp = array_from_pyobj(NPY_INT,box_source_counts_nonchild_Dims,box_source_counts_nonchild_Rank,capi_box_source_counts_nonchild_intent,box_source_counts_nonchild_capi);
  if (capi_box_source_counts_nonchild_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 11st argument `box_source_counts_nonchild' of _internal.l2dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    box_source_counts_nonchild = (int *)(PyArray_DATA(capi_box_source_counts_nonchild_tmp));

  /* Processing variable nsources */
  if (nsources_capi == Py_None) nsources = shape(sources,1); else
    f2py_success = int_from_pyobj(&nsources,nsources_capi,"_internal.l2dformta_qbx() 1st keyword (nsources) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(sources,1)==nsources,"shape(sources,1)==nsources","1st keyword nsources","l2dformta_qbx:nsources=%d",nsources) {
  /* Processing variable ntgt_centers */
  if (ntgt_centers_capi == Py_None) ntgt_centers = len(global_qbx_centers); else
    f2py_success = int_from_pyobj(&ntgt_centers,ntgt_centers_capi,"_internal.l2dformta_qbx() 2nd keyword (ntgt_centers) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(global_qbx_centers)>=ntgt_centers,"len(global_qbx_centers)>=ntgt_centers","2nd keyword ntgt_centers","l2dformta_qbx:ntgt_centers=%d",ntgt_centers) {
  /* Processing variable nqbx_centers */
  if (nqbx_centers_capi == Py_None) nqbx_centers = shape(qbx_centers,0); else
    f2py_success = int_from_pyobj(&nqbx_centers,nqbx_centers_capi,"_internal.l2dformta_qbx() 3rd keyword (nqbx_centers) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(qbx_centers,0)==nqbx_centers,"shape(qbx_centers,0)==nqbx_centers","3rd keyword nqbx_centers","l2dformta_qbx:nqbx_centers=%d",nqbx_centers) {
  /* Processing variable qbx_expansion_radii */
  qbx_expansion_radii_Dims[0]=nqbx_centers;
  capi_qbx_expansion_radii_intent |= F2PY_INTENT_IN;
  capi_qbx_expansion_radii_tmp = array_from_pyobj(NPY_DOUBLE,qbx_expansion_radii_Dims,qbx_expansion_radii_Rank,capi_qbx_expansion_radii_intent,qbx_expansion_radii_capi);
  if (capi_qbx_expansion_radii_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `qbx_expansion_radii' of _internal.l2dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    qbx_expansion_radii = (double *)(PyArray_DATA(capi_qbx_expansion_radii_tmp));

  /* Processing variable qbx_center_to_target_box */
  qbx_center_to_target_box_Dims[0]=nqbx_centers;
  capi_qbx_center_to_target_box_intent |= F2PY_INTENT_IN;
  capi_qbx_center_to_target_box_tmp = array_from_pyobj(NPY_INT,qbx_center_to_target_box_Dims,qbx_center_to_target_box_Rank,capi_qbx_center_to_target_box_intent,qbx_center_to_target_box_capi);
  if (capi_qbx_center_to_target_box_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `qbx_center_to_target_box' of _internal.l2dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    qbx_center_to_target_box = (int *)(PyArray_DATA(capi_qbx_center_to_target_box_tmp));

  /* Processing variable expn */
  expn_Dims[0]=nterms + 1,expn_Dims[1]=nqbx_centers;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.l2dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ier,&nsources,sources,charge,&ntgt_centers,&nqbx_centers,qbx_centers,global_qbx_centers,qbx_expansion_radii,qbx_center_to_target_box,&nterms,source_box_starts,source_box_lists,box_source_starts,box_source_counts_nonchild,expn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("iN",ier,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  if((PyObject *)capi_qbx_center_to_target_box_tmp!=qbx_center_to_target_box_capi) {
    Py_XDECREF(capi_qbx_center_to_target_box_tmp); }
  }  /*if (capi_qbx_center_to_target_box_tmp == NULL) ... else of qbx_center_to_target_box*/
  /* End of cleaning variable qbx_center_to_target_box */
  if((PyObject *)capi_qbx_expansion_radii_tmp!=qbx_expansion_radii_capi) {
    Py_XDECREF(capi_qbx_expansion_radii_tmp); }
  }  /*if (capi_qbx_expansion_radii_tmp == NULL) ... else of qbx_expansion_radii*/
  /* End of cleaning variable qbx_expansion_radii */
  } /*CHECKSCALAR(shape(qbx_centers,0)==nqbx_centers)*/
  } /*if (f2py_success) of nqbx_centers*/
  /* End of cleaning variable nqbx_centers */
  } /*CHECKSCALAR(len(global_qbx_centers)>=ntgt_centers)*/
  } /*if (f2py_success) of ntgt_centers*/
  /* End of cleaning variable ntgt_centers */
  } /*CHECKSCALAR(shape(sources,1)==nsources)*/
  } /*if (f2py_success) of nsources*/
  /* End of cleaning variable nsources */
  if((PyObject *)capi_box_source_counts_nonchild_tmp!=box_source_counts_nonchild_capi) {
    Py_XDECREF(capi_box_source_counts_nonchild_tmp); }
  }  /*if (capi_box_source_counts_nonchild_tmp == NULL) ... else of box_source_counts_nonchild*/
  /* End of cleaning variable box_source_counts_nonchild */
  if((PyObject *)capi_box_source_starts_tmp!=box_source_starts_capi) {
    Py_XDECREF(capi_box_source_starts_tmp); }
  }  /*if (capi_box_source_starts_tmp == NULL) ... else of box_source_starts*/
  /* End of cleaning variable box_source_starts */
  if((PyObject *)capi_source_box_lists_tmp!=source_box_lists_capi) {
    Py_XDECREF(capi_source_box_lists_tmp); }
  }  /*if (capi_source_box_lists_tmp == NULL) ... else of source_box_lists*/
  /* End of cleaning variable source_box_lists */
  if((PyObject *)capi_source_box_starts_tmp!=source_box_starts_capi) {
    Py_XDECREF(capi_source_box_starts_tmp); }
  }  /*if (capi_source_box_starts_tmp == NULL) ... else of source_box_starts*/
  /* End of cleaning variable source_box_starts */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_qbx_centers_tmp!=qbx_centers_capi) {
    Py_XDECREF(capi_qbx_centers_tmp); }
  }  /*if (capi_qbx_centers_tmp == NULL) ... else of qbx_centers*/
  /* End of cleaning variable qbx_centers */
  if((PyObject *)capi_global_qbx_centers_tmp!=global_qbx_centers_capi) {
    Py_XDECREF(capi_global_qbx_centers_tmp); }
  }  /*if (capi_global_qbx_centers_tmp == NULL) ... else of global_qbx_centers*/
  /* End of cleaning variable global_qbx_centers */
  if((PyObject *)capi_charge_tmp!=charge_capi) {
    Py_XDECREF(capi_charge_tmp); }
  }  /*if (capi_charge_tmp == NULL) ... else of charge*/
  /* End of cleaning variable charge */
  if((PyObject *)capi_sources_tmp!=sources_capi) {
    Py_XDECREF(capi_sources_tmp); }
  }  /*if (capi_sources_tmp == NULL) ... else of sources*/
  /* End of cleaning variable sources */
  /* End of cleaning variable ier */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/**************************** end of l2dformta_qbx ****************************/

/******************************* h2dformta_qbx *******************************/
static char doc_f2py_rout__internal_h2dformta_qbx[] = "\
ier,expn = h2dformta_qbx(zk,sources,charge,qbx_centers,global_qbx_centers,qbx_expansion_radii,qbx_center_to_target_box,nterms,source_box_starts,source_box_lists,box_source_starts,box_source_counts_nonchild,[nsources,ntgt_centers,nqbx_centers])\n\nWrapper for ``h2dformta_qbx``.\
\n\nParameters\n----------\n"
"zk : input complex\n"
"sources : input rank-2 array('d') with bounds (2,nsources)\n"
"charge : input rank-1 array('D') with bounds (*)\n"
"qbx_centers : input rank-2 array('d') with bounds (nqbx_centers,2)\n"
"global_qbx_centers : input rank-1 array('i') with bounds (ntgt_centers)\n"
"qbx_expansion_radii : input rank-1 array('d') with bounds (nqbx_centers)\n"
"qbx_center_to_target_box : input rank-1 array('i') with bounds (nqbx_centers)\n"
"nterms : input int\n"
"source_box_starts : input rank-1 array('i') with bounds (*)\n"
"source_box_lists : input rank-1 array('i') with bounds (*)\n"
"box_source_starts : input rank-1 array('i') with bounds (*)\n"
"box_source_counts_nonchild : input rank-1 array('i') with bounds (*)\n"
"\nOther Parameters\n----------------\n"
"nsources : input int, optional\n    Default: shape(sources,1)\n"
"ntgt_centers : input int, optional\n    Default: len(global_qbx_centers)\n"
"nqbx_centers : input int, optional\n    Default: shape(qbx_centers,0)\n"
"\nReturns\n-------\n"
"ier : int\n"
"expn : rank-2 array('D') with bounds (2 * nterms + 1,nqbx_centers)";
/* extern void F_FUNC_US(h2dformta_qbx,H2DFORMTA_QBX)(int*,complex_double*,int*,double*,complex_double*,int*,int*,double*,int*,double*,int*,int*,int*,int*,int*,int*,complex_double*); */
static PyObject *f2py_rout__internal_h2dformta_qbx(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,complex_double*,int*,double*,complex_double*,int*,int*,double*,int*,double*,int*,int*,int*,int*,int*,int*,complex_double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ier = 0;
  complex_double zk;
  PyObject *zk_capi = Py_None;
  int nsources = 0;
  PyObject *nsources_capi = Py_None;
  double *sources = NULL;
  npy_intp sources_Dims[2] = {-1, -1};
  const int sources_Rank = 2;
  PyArrayObject *capi_sources_tmp = NULL;
  int capi_sources_intent = 0;
  PyObject *sources_capi = Py_None;
  complex_double *charge = NULL;
  npy_intp charge_Dims[1] = {-1};
  const int charge_Rank = 1;
  PyArrayObject *capi_charge_tmp = NULL;
  int capi_charge_intent = 0;
  PyObject *charge_capi = Py_None;
  int ntgt_centers = 0;
  PyObject *ntgt_centers_capi = Py_None;
  int nqbx_centers = 0;
  PyObject *nqbx_centers_capi = Py_None;
  double *qbx_centers = NULL;
  npy_intp qbx_centers_Dims[2] = {-1, -1};
  const int qbx_centers_Rank = 2;
  PyArrayObject *capi_qbx_centers_tmp = NULL;
  int capi_qbx_centers_intent = 0;
  PyObject *qbx_centers_capi = Py_None;
  int *global_qbx_centers = NULL;
  npy_intp global_qbx_centers_Dims[1] = {-1};
  const int global_qbx_centers_Rank = 1;
  PyArrayObject *capi_global_qbx_centers_tmp = NULL;
  int capi_global_qbx_centers_intent = 0;
  PyObject *global_qbx_centers_capi = Py_None;
  double *qbx_expansion_radii = NULL;
  npy_intp qbx_expansion_radii_Dims[1] = {-1};
  const int qbx_expansion_radii_Rank = 1;
  PyArrayObject *capi_qbx_expansion_radii_tmp = NULL;
  int capi_qbx_expansion_radii_intent = 0;
  PyObject *qbx_expansion_radii_capi = Py_None;
  int *qbx_center_to_target_box = NULL;
  npy_intp qbx_center_to_target_box_Dims[1] = {-1};
  const int qbx_center_to_target_box_Rank = 1;
  PyArrayObject *capi_qbx_center_to_target_box_tmp = NULL;
  int capi_qbx_center_to_target_box_intent = 0;
  PyObject *qbx_center_to_target_box_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  int *source_box_starts = NULL;
  npy_intp source_box_starts_Dims[1] = {-1};
  const int source_box_starts_Rank = 1;
  PyArrayObject *capi_source_box_starts_tmp = NULL;
  int capi_source_box_starts_intent = 0;
  PyObject *source_box_starts_capi = Py_None;
  int *source_box_lists = NULL;
  npy_intp source_box_lists_Dims[1] = {-1};
  const int source_box_lists_Rank = 1;
  PyArrayObject *capi_source_box_lists_tmp = NULL;
  int capi_source_box_lists_intent = 0;
  PyObject *source_box_lists_capi = Py_None;
  int *box_source_starts = NULL;
  npy_intp box_source_starts_Dims[1] = {-1};
  const int box_source_starts_Rank = 1;
  PyArrayObject *capi_box_source_starts_tmp = NULL;
  int capi_box_source_starts_intent = 0;
  PyObject *box_source_starts_capi = Py_None;
  int *box_source_counts_nonchild = NULL;
  npy_intp box_source_counts_nonchild_Dims[1] = {-1};
  const int box_source_counts_nonchild_Rank = 1;
  PyArrayObject *capi_box_source_counts_nonchild_tmp = NULL;
  int capi_box_source_counts_nonchild_intent = 0;
  PyObject *box_source_counts_nonchild_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[2] = {-1, -1};
  const int expn_Rank = 2;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
    static char *capi_kwlist[] = {"zk","sources","charge","qbx_centers","global_qbx_centers","qbx_expansion_radii","qbx_center_to_target_box","nterms","source_box_starts","source_box_lists","box_source_starts","box_source_counts_nonchild","nsources","ntgt_centers","nqbx_centers",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOOOO|OOO:_internal.h2dformta_qbx",\
        capi_kwlist,&zk_capi,&sources_capi,&charge_capi,&qbx_centers_capi,&global_qbx_centers_capi,&qbx_expansion_radii_capi,&qbx_center_to_target_box_capi,&nterms_capi,&source_box_starts_capi,&source_box_lists_capi,&box_source_starts_capi,&box_source_counts_nonchild_capi,&nsources_capi,&ntgt_centers_capi,&nqbx_centers_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable ier */
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.h2dformta_qbx() 1st argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable sources */
  sources_Dims[0]=2;
  capi_sources_intent |= F2PY_INTENT_IN;
  capi_sources_tmp = array_from_pyobj(NPY_DOUBLE,sources_Dims,sources_Rank,capi_sources_intent,sources_capi);
  if (capi_sources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `sources' of _internal.h2dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources = (double *)(PyArray_DATA(capi_sources_tmp));

  /* Processing variable charge */
  ;
  capi_charge_intent |= F2PY_INTENT_IN;
  capi_charge_tmp = array_from_pyobj(NPY_CDOUBLE,charge_Dims,charge_Rank,capi_charge_intent,charge_capi);
  if (capi_charge_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `charge' of _internal.h2dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge = (complex_double *)(PyArray_DATA(capi_charge_tmp));

  /* Processing variable global_qbx_centers */
  ;
  capi_global_qbx_centers_intent |= F2PY_INTENT_IN;
  capi_global_qbx_centers_tmp = array_from_pyobj(NPY_INT,global_qbx_centers_Dims,global_qbx_centers_Rank,capi_global_qbx_centers_intent,global_qbx_centers_capi);
  if (capi_global_qbx_centers_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `global_qbx_centers' of _internal.h2dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    global_qbx_centers = (int *)(PyArray_DATA(capi_global_qbx_centers_tmp));

  /* Processing variable qbx_centers */
  qbx_centers_Dims[1]=2;
  capi_qbx_centers_intent |= F2PY_INTENT_IN;
  capi_qbx_centers_tmp = array_from_pyobj(NPY_DOUBLE,qbx_centers_Dims,qbx_centers_Rank,capi_qbx_centers_intent,qbx_centers_capi);
  if (capi_qbx_centers_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `qbx_centers' of _internal.h2dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    qbx_centers = (double *)(PyArray_DATA(capi_qbx_centers_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.h2dformta_qbx() 8th argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable source_box_starts */
  ;
  capi_source_box_starts_intent |= F2PY_INTENT_IN;
  capi_source_box_starts_tmp = array_from_pyobj(NPY_INT,source_box_starts_Dims,source_box_starts_Rank,capi_source_box_starts_intent,source_box_starts_capi);
  if (capi_source_box_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 9th argument `source_box_starts' of _internal.h2dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source_box_starts = (int *)(PyArray_DATA(capi_source_box_starts_tmp));

  /* Processing variable source_box_lists */
  ;
  capi_source_box_lists_intent |= F2PY_INTENT_IN;
  capi_source_box_lists_tmp = array_from_pyobj(NPY_INT,source_box_lists_Dims,source_box_lists_Rank,capi_source_box_lists_intent,source_box_lists_capi);
  if (capi_source_box_lists_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 10th argument `source_box_lists' of _internal.h2dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source_box_lists = (int *)(PyArray_DATA(capi_source_box_lists_tmp));

  /* Processing variable box_source_starts */
  ;
  capi_box_source_starts_intent |= F2PY_INTENT_IN;
  capi_box_source_starts_tmp = array_from_pyobj(NPY_INT,box_source_starts_Dims,box_source_starts_Rank,capi_box_source_starts_intent,box_source_starts_capi);
  if (capi_box_source_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 11st argument `box_source_starts' of _internal.h2dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    box_source_starts = (int *)(PyArray_DATA(capi_box_source_starts_tmp));

  /* Processing variable box_source_counts_nonchild */
  ;
  capi_box_source_counts_nonchild_intent |= F2PY_INTENT_IN;
  capi_box_source_counts_nonchild_tmp = array_from_pyobj(NPY_INT,box_source_counts_nonchild_Dims,box_source_counts_nonchild_Rank,capi_box_source_counts_nonchild_intent,box_source_counts_nonchild_capi);
  if (capi_box_source_counts_nonchild_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 12nd argument `box_source_counts_nonchild' of _internal.h2dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    box_source_counts_nonchild = (int *)(PyArray_DATA(capi_box_source_counts_nonchild_tmp));

  /* Processing variable nsources */
  if (nsources_capi == Py_None) nsources = shape(sources,1); else
    f2py_success = int_from_pyobj(&nsources,nsources_capi,"_internal.h2dformta_qbx() 1st keyword (nsources) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(sources,1)==nsources,"shape(sources,1)==nsources","1st keyword nsources","h2dformta_qbx:nsources=%d",nsources) {
  /* Processing variable ntgt_centers */
  if (ntgt_centers_capi == Py_None) ntgt_centers = len(global_qbx_centers); else
    f2py_success = int_from_pyobj(&ntgt_centers,ntgt_centers_capi,"_internal.h2dformta_qbx() 2nd keyword (ntgt_centers) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(global_qbx_centers)>=ntgt_centers,"len(global_qbx_centers)>=ntgt_centers","2nd keyword ntgt_centers","h2dformta_qbx:ntgt_centers=%d",ntgt_centers) {
  /* Processing variable nqbx_centers */
  if (nqbx_centers_capi == Py_None) nqbx_centers = shape(qbx_centers,0); else
    f2py_success = int_from_pyobj(&nqbx_centers,nqbx_centers_capi,"_internal.h2dformta_qbx() 3rd keyword (nqbx_centers) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(qbx_centers,0)==nqbx_centers,"shape(qbx_centers,0)==nqbx_centers","3rd keyword nqbx_centers","h2dformta_qbx:nqbx_centers=%d",nqbx_centers) {
  /* Processing variable qbx_expansion_radii */
  qbx_expansion_radii_Dims[0]=nqbx_centers;
  capi_qbx_expansion_radii_intent |= F2PY_INTENT_IN;
  capi_qbx_expansion_radii_tmp = array_from_pyobj(NPY_DOUBLE,qbx_expansion_radii_Dims,qbx_expansion_radii_Rank,capi_qbx_expansion_radii_intent,qbx_expansion_radii_capi);
  if (capi_qbx_expansion_radii_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `qbx_expansion_radii' of _internal.h2dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    qbx_expansion_radii = (double *)(PyArray_DATA(capi_qbx_expansion_radii_tmp));

  /* Processing variable qbx_center_to_target_box */
  qbx_center_to_target_box_Dims[0]=nqbx_centers;
  capi_qbx_center_to_target_box_intent |= F2PY_INTENT_IN;
  capi_qbx_center_to_target_box_tmp = array_from_pyobj(NPY_INT,qbx_center_to_target_box_Dims,qbx_center_to_target_box_Rank,capi_qbx_center_to_target_box_intent,qbx_center_to_target_box_capi);
  if (capi_qbx_center_to_target_box_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 7th argument `qbx_center_to_target_box' of _internal.h2dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    qbx_center_to_target_box = (int *)(PyArray_DATA(capi_qbx_center_to_target_box_tmp));

  /* Processing variable expn */
  expn_Dims[0]=2 * nterms + 1,expn_Dims[1]=nqbx_centers;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.h2dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ier,&zk,&nsources,sources,charge,&ntgt_centers,&nqbx_centers,qbx_centers,global_qbx_centers,qbx_expansion_radii,qbx_center_to_target_box,&nterms,source_box_starts,source_box_lists,box_source_starts,box_source_counts_nonchild,expn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("iN",ier,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  if((PyObject *)capi_qbx_center_to_target_box_tmp!=qbx_center_to_target_box_capi) {
    Py_XDECREF(capi_qbx_center_to_target_box_tmp); }
  }  /*if (capi_qbx_center_to_target_box_tmp == NULL) ... else of qbx_center_to_target_box*/
  /* End of cleaning variable qbx_center_to_target_box */
  if((PyObject *)capi_qbx_expansion_radii_tmp!=qbx_expansion_radii_capi) {
    Py_XDECREF(capi_qbx_expansion_radii_tmp); }
  }  /*if (capi_qbx_expansion_radii_tmp == NULL) ... else of qbx_expansion_radii*/
  /* End of cleaning variable qbx_expansion_radii */
  } /*CHECKSCALAR(shape(qbx_centers,0)==nqbx_centers)*/
  } /*if (f2py_success) of nqbx_centers*/
  /* End of cleaning variable nqbx_centers */
  } /*CHECKSCALAR(len(global_qbx_centers)>=ntgt_centers)*/
  } /*if (f2py_success) of ntgt_centers*/
  /* End of cleaning variable ntgt_centers */
  } /*CHECKSCALAR(shape(sources,1)==nsources)*/
  } /*if (f2py_success) of nsources*/
  /* End of cleaning variable nsources */
  if((PyObject *)capi_box_source_counts_nonchild_tmp!=box_source_counts_nonchild_capi) {
    Py_XDECREF(capi_box_source_counts_nonchild_tmp); }
  }  /*if (capi_box_source_counts_nonchild_tmp == NULL) ... else of box_source_counts_nonchild*/
  /* End of cleaning variable box_source_counts_nonchild */
  if((PyObject *)capi_box_source_starts_tmp!=box_source_starts_capi) {
    Py_XDECREF(capi_box_source_starts_tmp); }
  }  /*if (capi_box_source_starts_tmp == NULL) ... else of box_source_starts*/
  /* End of cleaning variable box_source_starts */
  if((PyObject *)capi_source_box_lists_tmp!=source_box_lists_capi) {
    Py_XDECREF(capi_source_box_lists_tmp); }
  }  /*if (capi_source_box_lists_tmp == NULL) ... else of source_box_lists*/
  /* End of cleaning variable source_box_lists */
  if((PyObject *)capi_source_box_starts_tmp!=source_box_starts_capi) {
    Py_XDECREF(capi_source_box_starts_tmp); }
  }  /*if (capi_source_box_starts_tmp == NULL) ... else of source_box_starts*/
  /* End of cleaning variable source_box_starts */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_qbx_centers_tmp!=qbx_centers_capi) {
    Py_XDECREF(capi_qbx_centers_tmp); }
  }  /*if (capi_qbx_centers_tmp == NULL) ... else of qbx_centers*/
  /* End of cleaning variable qbx_centers */
  if((PyObject *)capi_global_qbx_centers_tmp!=global_qbx_centers_capi) {
    Py_XDECREF(capi_global_qbx_centers_tmp); }
  }  /*if (capi_global_qbx_centers_tmp == NULL) ... else of global_qbx_centers*/
  /* End of cleaning variable global_qbx_centers */
  if((PyObject *)capi_charge_tmp!=charge_capi) {
    Py_XDECREF(capi_charge_tmp); }
  }  /*if (capi_charge_tmp == NULL) ... else of charge*/
  /* End of cleaning variable charge */
  if((PyObject *)capi_sources_tmp!=sources_capi) {
    Py_XDECREF(capi_sources_tmp); }
  }  /*if (capi_sources_tmp == NULL) ... else of sources*/
  /* End of cleaning variable sources */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
  /* End of cleaning variable ier */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/**************************** end of h2dformta_qbx ****************************/

/******************************* l3dformta_qbx *******************************/
static char doc_f2py_rout__internal_l3dformta_qbx[] = "\
ier,expn = l3dformta_qbx(sources,charge,qbx_centers,global_qbx_centers,qbx_expansion_radii,qbx_center_to_target_box,nterms,source_box_starts,source_box_lists,box_source_starts,box_source_counts_nonchild,[nsources,ntgt_centers,nqbx_centers])\n\nWrapper for ``l3dformta_qbx``.\
\n\nParameters\n----------\n"
"sources : input rank-2 array('d') with bounds (3,nsources)\n"
"charge : input rank-1 array('D') with bounds (*)\n"
"qbx_centers : input rank-2 array('d') with bounds (nqbx_centers,3)\n"
"global_qbx_centers : input rank-1 array('i') with bounds (ntgt_centers)\n"
"qbx_expansion_radii : input rank-1 array('d') with bounds (nqbx_centers)\n"
"qbx_center_to_target_box : input rank-1 array('i') with bounds (nqbx_centers)\n"
"nterms : input int\n"
"source_box_starts : input rank-1 array('i') with bounds (*)\n"
"source_box_lists : input rank-1 array('i') with bounds (*)\n"
"box_source_starts : input rank-1 array('i') with bounds (*)\n"
"box_source_counts_nonchild : input rank-1 array('i') with bounds (*)\n"
"\nOther Parameters\n----------------\n"
"nsources : input int, optional\n    Default: shape(sources,1)\n"
"ntgt_centers : input int, optional\n    Default: len(global_qbx_centers)\n"
"nqbx_centers : input int, optional\n    Default: shape(qbx_centers,0)\n"
"\nReturns\n-------\n"
"ier : int\n"
"expn : rank-3 array('D') with bounds (nterms + 1,2 * nterms + 1,nqbx_centers)";
/* extern void F_FUNC_US(l3dformta_qbx,L3DFORMTA_QBX)(int*,int*,double*,complex_double*,int*,int*,double*,int*,double*,int*,int*,int*,int*,int*,int*,complex_double*); */
static PyObject *f2py_rout__internal_l3dformta_qbx(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*,complex_double*,int*,int*,double*,int*,double*,int*,int*,int*,int*,int*,int*,complex_double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ier = 0;
  int nsources = 0;
  PyObject *nsources_capi = Py_None;
  double *sources = NULL;
  npy_intp sources_Dims[2] = {-1, -1};
  const int sources_Rank = 2;
  PyArrayObject *capi_sources_tmp = NULL;
  int capi_sources_intent = 0;
  PyObject *sources_capi = Py_None;
  complex_double *charge = NULL;
  npy_intp charge_Dims[1] = {-1};
  const int charge_Rank = 1;
  PyArrayObject *capi_charge_tmp = NULL;
  int capi_charge_intent = 0;
  PyObject *charge_capi = Py_None;
  int ntgt_centers = 0;
  PyObject *ntgt_centers_capi = Py_None;
  int nqbx_centers = 0;
  PyObject *nqbx_centers_capi = Py_None;
  double *qbx_centers = NULL;
  npy_intp qbx_centers_Dims[2] = {-1, -1};
  const int qbx_centers_Rank = 2;
  PyArrayObject *capi_qbx_centers_tmp = NULL;
  int capi_qbx_centers_intent = 0;
  PyObject *qbx_centers_capi = Py_None;
  int *global_qbx_centers = NULL;
  npy_intp global_qbx_centers_Dims[1] = {-1};
  const int global_qbx_centers_Rank = 1;
  PyArrayObject *capi_global_qbx_centers_tmp = NULL;
  int capi_global_qbx_centers_intent = 0;
  PyObject *global_qbx_centers_capi = Py_None;
  double *qbx_expansion_radii = NULL;
  npy_intp qbx_expansion_radii_Dims[1] = {-1};
  const int qbx_expansion_radii_Rank = 1;
  PyArrayObject *capi_qbx_expansion_radii_tmp = NULL;
  int capi_qbx_expansion_radii_intent = 0;
  PyObject *qbx_expansion_radii_capi = Py_None;
  int *qbx_center_to_target_box = NULL;
  npy_intp qbx_center_to_target_box_Dims[1] = {-1};
  const int qbx_center_to_target_box_Rank = 1;
  PyArrayObject *capi_qbx_center_to_target_box_tmp = NULL;
  int capi_qbx_center_to_target_box_intent = 0;
  PyObject *qbx_center_to_target_box_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  int *source_box_starts = NULL;
  npy_intp source_box_starts_Dims[1] = {-1};
  const int source_box_starts_Rank = 1;
  PyArrayObject *capi_source_box_starts_tmp = NULL;
  int capi_source_box_starts_intent = 0;
  PyObject *source_box_starts_capi = Py_None;
  int *source_box_lists = NULL;
  npy_intp source_box_lists_Dims[1] = {-1};
  const int source_box_lists_Rank = 1;
  PyArrayObject *capi_source_box_lists_tmp = NULL;
  int capi_source_box_lists_intent = 0;
  PyObject *source_box_lists_capi = Py_None;
  int *box_source_starts = NULL;
  npy_intp box_source_starts_Dims[1] = {-1};
  const int box_source_starts_Rank = 1;
  PyArrayObject *capi_box_source_starts_tmp = NULL;
  int capi_box_source_starts_intent = 0;
  PyObject *box_source_starts_capi = Py_None;
  int *box_source_counts_nonchild = NULL;
  npy_intp box_source_counts_nonchild_Dims[1] = {-1};
  const int box_source_counts_nonchild_Rank = 1;
  PyArrayObject *capi_box_source_counts_nonchild_tmp = NULL;
  int capi_box_source_counts_nonchild_intent = 0;
  PyObject *box_source_counts_nonchild_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[3] = {-1, -1, -1};
  const int expn_Rank = 3;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
    static char *capi_kwlist[] = {"sources","charge","qbx_centers","global_qbx_centers","qbx_expansion_radii","qbx_center_to_target_box","nterms","source_box_starts","source_box_lists","box_source_starts","box_source_counts_nonchild","nsources","ntgt_centers","nqbx_centers",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOOO|OOO:_internal.l3dformta_qbx",\
        capi_kwlist,&sources_capi,&charge_capi,&qbx_centers_capi,&global_qbx_centers_capi,&qbx_expansion_radii_capi,&qbx_center_to_target_box_capi,&nterms_capi,&source_box_starts_capi,&source_box_lists_capi,&box_source_starts_capi,&box_source_counts_nonchild_capi,&nsources_capi,&ntgt_centers_capi,&nqbx_centers_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable ier */
  /* Processing variable sources */
  sources_Dims[0]=3;
  capi_sources_intent |= F2PY_INTENT_IN;
  capi_sources_tmp = array_from_pyobj(NPY_DOUBLE,sources_Dims,sources_Rank,capi_sources_intent,sources_capi);
  if (capi_sources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 1st argument `sources' of _internal.l3dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources = (double *)(PyArray_DATA(capi_sources_tmp));

  /* Processing variable charge */
  ;
  capi_charge_intent |= F2PY_INTENT_IN;
  capi_charge_tmp = array_from_pyobj(NPY_CDOUBLE,charge_Dims,charge_Rank,capi_charge_intent,charge_capi);
  if (capi_charge_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `charge' of _internal.l3dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge = (complex_double *)(PyArray_DATA(capi_charge_tmp));

  /* Processing variable global_qbx_centers */
  ;
  capi_global_qbx_centers_intent |= F2PY_INTENT_IN;
  capi_global_qbx_centers_tmp = array_from_pyobj(NPY_INT,global_qbx_centers_Dims,global_qbx_centers_Rank,capi_global_qbx_centers_intent,global_qbx_centers_capi);
  if (capi_global_qbx_centers_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `global_qbx_centers' of _internal.l3dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    global_qbx_centers = (int *)(PyArray_DATA(capi_global_qbx_centers_tmp));

  /* Processing variable qbx_centers */
  qbx_centers_Dims[1]=3;
  capi_qbx_centers_intent |= F2PY_INTENT_IN;
  capi_qbx_centers_tmp = array_from_pyobj(NPY_DOUBLE,qbx_centers_Dims,qbx_centers_Rank,capi_qbx_centers_intent,qbx_centers_capi);
  if (capi_qbx_centers_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `qbx_centers' of _internal.l3dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    qbx_centers = (double *)(PyArray_DATA(capi_qbx_centers_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.l3dformta_qbx() 7th argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable source_box_starts */
  ;
  capi_source_box_starts_intent |= F2PY_INTENT_IN;
  capi_source_box_starts_tmp = array_from_pyobj(NPY_INT,source_box_starts_Dims,source_box_starts_Rank,capi_source_box_starts_intent,source_box_starts_capi);
  if (capi_source_box_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 8th argument `source_box_starts' of _internal.l3dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source_box_starts = (int *)(PyArray_DATA(capi_source_box_starts_tmp));

  /* Processing variable source_box_lists */
  ;
  capi_source_box_lists_intent |= F2PY_INTENT_IN;
  capi_source_box_lists_tmp = array_from_pyobj(NPY_INT,source_box_lists_Dims,source_box_lists_Rank,capi_source_box_lists_intent,source_box_lists_capi);
  if (capi_source_box_lists_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 9th argument `source_box_lists' of _internal.l3dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source_box_lists = (int *)(PyArray_DATA(capi_source_box_lists_tmp));

  /* Processing variable box_source_starts */
  ;
  capi_box_source_starts_intent |= F2PY_INTENT_IN;
  capi_box_source_starts_tmp = array_from_pyobj(NPY_INT,box_source_starts_Dims,box_source_starts_Rank,capi_box_source_starts_intent,box_source_starts_capi);
  if (capi_box_source_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 10th argument `box_source_starts' of _internal.l3dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    box_source_starts = (int *)(PyArray_DATA(capi_box_source_starts_tmp));

  /* Processing variable box_source_counts_nonchild */
  ;
  capi_box_source_counts_nonchild_intent |= F2PY_INTENT_IN;
  capi_box_source_counts_nonchild_tmp = array_from_pyobj(NPY_INT,box_source_counts_nonchild_Dims,box_source_counts_nonchild_Rank,capi_box_source_counts_nonchild_intent,box_source_counts_nonchild_capi);
  if (capi_box_source_counts_nonchild_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 11st argument `box_source_counts_nonchild' of _internal.l3dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    box_source_counts_nonchild = (int *)(PyArray_DATA(capi_box_source_counts_nonchild_tmp));

  /* Processing variable nsources */
  if (nsources_capi == Py_None) nsources = shape(sources,1); else
    f2py_success = int_from_pyobj(&nsources,nsources_capi,"_internal.l3dformta_qbx() 1st keyword (nsources) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(sources,1)==nsources,"shape(sources,1)==nsources","1st keyword nsources","l3dformta_qbx:nsources=%d",nsources) {
  /* Processing variable ntgt_centers */
  if (ntgt_centers_capi == Py_None) ntgt_centers = len(global_qbx_centers); else
    f2py_success = int_from_pyobj(&ntgt_centers,ntgt_centers_capi,"_internal.l3dformta_qbx() 2nd keyword (ntgt_centers) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(global_qbx_centers)>=ntgt_centers,"len(global_qbx_centers)>=ntgt_centers","2nd keyword ntgt_centers","l3dformta_qbx:ntgt_centers=%d",ntgt_centers) {
  /* Processing variable nqbx_centers */
  if (nqbx_centers_capi == Py_None) nqbx_centers = shape(qbx_centers,0); else
    f2py_success = int_from_pyobj(&nqbx_centers,nqbx_centers_capi,"_internal.l3dformta_qbx() 3rd keyword (nqbx_centers) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(qbx_centers,0)==nqbx_centers,"shape(qbx_centers,0)==nqbx_centers","3rd keyword nqbx_centers","l3dformta_qbx:nqbx_centers=%d",nqbx_centers) {
  /* Processing variable qbx_expansion_radii */
  qbx_expansion_radii_Dims[0]=nqbx_centers;
  capi_qbx_expansion_radii_intent |= F2PY_INTENT_IN;
  capi_qbx_expansion_radii_tmp = array_from_pyobj(NPY_DOUBLE,qbx_expansion_radii_Dims,qbx_expansion_radii_Rank,capi_qbx_expansion_radii_intent,qbx_expansion_radii_capi);
  if (capi_qbx_expansion_radii_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `qbx_expansion_radii' of _internal.l3dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    qbx_expansion_radii = (double *)(PyArray_DATA(capi_qbx_expansion_radii_tmp));

  /* Processing variable qbx_center_to_target_box */
  qbx_center_to_target_box_Dims[0]=nqbx_centers;
  capi_qbx_center_to_target_box_intent |= F2PY_INTENT_IN;
  capi_qbx_center_to_target_box_tmp = array_from_pyobj(NPY_INT,qbx_center_to_target_box_Dims,qbx_center_to_target_box_Rank,capi_qbx_center_to_target_box_intent,qbx_center_to_target_box_capi);
  if (capi_qbx_center_to_target_box_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `qbx_center_to_target_box' of _internal.l3dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    qbx_center_to_target_box = (int *)(PyArray_DATA(capi_qbx_center_to_target_box_tmp));

  /* Processing variable expn */
  expn_Dims[0]=nterms + 1,expn_Dims[1]=2 * nterms + 1,expn_Dims[2]=nqbx_centers;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.l3dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ier,&nsources,sources,charge,&ntgt_centers,&nqbx_centers,qbx_centers,global_qbx_centers,qbx_expansion_radii,qbx_center_to_target_box,&nterms,source_box_starts,source_box_lists,box_source_starts,box_source_counts_nonchild,expn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("iN",ier,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  if((PyObject *)capi_qbx_center_to_target_box_tmp!=qbx_center_to_target_box_capi) {
    Py_XDECREF(capi_qbx_center_to_target_box_tmp); }
  }  /*if (capi_qbx_center_to_target_box_tmp == NULL) ... else of qbx_center_to_target_box*/
  /* End of cleaning variable qbx_center_to_target_box */
  if((PyObject *)capi_qbx_expansion_radii_tmp!=qbx_expansion_radii_capi) {
    Py_XDECREF(capi_qbx_expansion_radii_tmp); }
  }  /*if (capi_qbx_expansion_radii_tmp == NULL) ... else of qbx_expansion_radii*/
  /* End of cleaning variable qbx_expansion_radii */
  } /*CHECKSCALAR(shape(qbx_centers,0)==nqbx_centers)*/
  } /*if (f2py_success) of nqbx_centers*/
  /* End of cleaning variable nqbx_centers */
  } /*CHECKSCALAR(len(global_qbx_centers)>=ntgt_centers)*/
  } /*if (f2py_success) of ntgt_centers*/
  /* End of cleaning variable ntgt_centers */
  } /*CHECKSCALAR(shape(sources,1)==nsources)*/
  } /*if (f2py_success) of nsources*/
  /* End of cleaning variable nsources */
  if((PyObject *)capi_box_source_counts_nonchild_tmp!=box_source_counts_nonchild_capi) {
    Py_XDECREF(capi_box_source_counts_nonchild_tmp); }
  }  /*if (capi_box_source_counts_nonchild_tmp == NULL) ... else of box_source_counts_nonchild*/
  /* End of cleaning variable box_source_counts_nonchild */
  if((PyObject *)capi_box_source_starts_tmp!=box_source_starts_capi) {
    Py_XDECREF(capi_box_source_starts_tmp); }
  }  /*if (capi_box_source_starts_tmp == NULL) ... else of box_source_starts*/
  /* End of cleaning variable box_source_starts */
  if((PyObject *)capi_source_box_lists_tmp!=source_box_lists_capi) {
    Py_XDECREF(capi_source_box_lists_tmp); }
  }  /*if (capi_source_box_lists_tmp == NULL) ... else of source_box_lists*/
  /* End of cleaning variable source_box_lists */
  if((PyObject *)capi_source_box_starts_tmp!=source_box_starts_capi) {
    Py_XDECREF(capi_source_box_starts_tmp); }
  }  /*if (capi_source_box_starts_tmp == NULL) ... else of source_box_starts*/
  /* End of cleaning variable source_box_starts */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_qbx_centers_tmp!=qbx_centers_capi) {
    Py_XDECREF(capi_qbx_centers_tmp); }
  }  /*if (capi_qbx_centers_tmp == NULL) ... else of qbx_centers*/
  /* End of cleaning variable qbx_centers */
  if((PyObject *)capi_global_qbx_centers_tmp!=global_qbx_centers_capi) {
    Py_XDECREF(capi_global_qbx_centers_tmp); }
  }  /*if (capi_global_qbx_centers_tmp == NULL) ... else of global_qbx_centers*/
  /* End of cleaning variable global_qbx_centers */
  if((PyObject *)capi_charge_tmp!=charge_capi) {
    Py_XDECREF(capi_charge_tmp); }
  }  /*if (capi_charge_tmp == NULL) ... else of charge*/
  /* End of cleaning variable charge */
  if((PyObject *)capi_sources_tmp!=sources_capi) {
    Py_XDECREF(capi_sources_tmp); }
  }  /*if (capi_sources_tmp == NULL) ... else of sources*/
  /* End of cleaning variable sources */
  /* End of cleaning variable ier */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/**************************** end of l3dformta_qbx ****************************/

/******************************* h3dformta_qbx *******************************/
static char doc_f2py_rout__internal_h3dformta_qbx[] = "\
ier,expn = h3dformta_qbx(zk,sources,charge,qbx_centers,global_qbx_centers,qbx_expansion_radii,qbx_center_to_target_box,nterms,source_box_starts,source_box_lists,box_source_starts,box_source_counts_nonchild,[nsources,ntgt_centers,nqbx_centers])\n\nWrapper for ``h3dformta_qbx``.\
\n\nParameters\n----------\n"
"zk : input complex\n"
"sources : input rank-2 array('d') with bounds (3,nsources)\n"
"charge : input rank-1 array('D') with bounds (*)\n"
"qbx_centers : input rank-2 array('d') with bounds (nqbx_centers,3)\n"
"global_qbx_centers : input rank-1 array('i') with bounds (ntgt_centers)\n"
"qbx_expansion_radii : input rank-1 array('d') with bounds (nqbx_centers)\n"
"qbx_center_to_target_box : input rank-1 array('i') with bounds (nqbx_centers)\n"
"nterms : input int\n"
"source_box_starts : input rank-1 array('i') with bounds (*)\n"
"source_box_lists : input rank-1 array('i') with bounds (*)\n"
"box_source_starts : input rank-1 array('i') with bounds (*)\n"
"box_source_counts_nonchild : input rank-1 array('i') with bounds (*)\n"
"\nOther Parameters\n----------------\n"
"nsources : input int, optional\n    Default: shape(sources,1)\n"
"ntgt_centers : input int, optional\n    Default: len(global_qbx_centers)\n"
"nqbx_centers : input int, optional\n    Default: shape(qbx_centers,0)\n"
"\nReturns\n-------\n"
"ier : int\n"
"expn : rank-3 array('D') with bounds (nterms + 1,2 * nterms + 1,nqbx_centers)";
/* extern void F_FUNC_US(h3dformta_qbx,H3DFORMTA_QBX)(int*,complex_double*,int*,double*,complex_double*,int*,int*,double*,int*,double*,int*,int*,int*,int*,int*,int*,complex_double*); */
static PyObject *f2py_rout__internal_h3dformta_qbx(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,complex_double*,int*,double*,complex_double*,int*,int*,double*,int*,double*,int*,int*,int*,int*,int*,int*,complex_double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ier = 0;
  complex_double zk;
  PyObject *zk_capi = Py_None;
  int nsources = 0;
  PyObject *nsources_capi = Py_None;
  double *sources = NULL;
  npy_intp sources_Dims[2] = {-1, -1};
  const int sources_Rank = 2;
  PyArrayObject *capi_sources_tmp = NULL;
  int capi_sources_intent = 0;
  PyObject *sources_capi = Py_None;
  complex_double *charge = NULL;
  npy_intp charge_Dims[1] = {-1};
  const int charge_Rank = 1;
  PyArrayObject *capi_charge_tmp = NULL;
  int capi_charge_intent = 0;
  PyObject *charge_capi = Py_None;
  int ntgt_centers = 0;
  PyObject *ntgt_centers_capi = Py_None;
  int nqbx_centers = 0;
  PyObject *nqbx_centers_capi = Py_None;
  double *qbx_centers = NULL;
  npy_intp qbx_centers_Dims[2] = {-1, -1};
  const int qbx_centers_Rank = 2;
  PyArrayObject *capi_qbx_centers_tmp = NULL;
  int capi_qbx_centers_intent = 0;
  PyObject *qbx_centers_capi = Py_None;
  int *global_qbx_centers = NULL;
  npy_intp global_qbx_centers_Dims[1] = {-1};
  const int global_qbx_centers_Rank = 1;
  PyArrayObject *capi_global_qbx_centers_tmp = NULL;
  int capi_global_qbx_centers_intent = 0;
  PyObject *global_qbx_centers_capi = Py_None;
  double *qbx_expansion_radii = NULL;
  npy_intp qbx_expansion_radii_Dims[1] = {-1};
  const int qbx_expansion_radii_Rank = 1;
  PyArrayObject *capi_qbx_expansion_radii_tmp = NULL;
  int capi_qbx_expansion_radii_intent = 0;
  PyObject *qbx_expansion_radii_capi = Py_None;
  int *qbx_center_to_target_box = NULL;
  npy_intp qbx_center_to_target_box_Dims[1] = {-1};
  const int qbx_center_to_target_box_Rank = 1;
  PyArrayObject *capi_qbx_center_to_target_box_tmp = NULL;
  int capi_qbx_center_to_target_box_intent = 0;
  PyObject *qbx_center_to_target_box_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  int *source_box_starts = NULL;
  npy_intp source_box_starts_Dims[1] = {-1};
  const int source_box_starts_Rank = 1;
  PyArrayObject *capi_source_box_starts_tmp = NULL;
  int capi_source_box_starts_intent = 0;
  PyObject *source_box_starts_capi = Py_None;
  int *source_box_lists = NULL;
  npy_intp source_box_lists_Dims[1] = {-1};
  const int source_box_lists_Rank = 1;
  PyArrayObject *capi_source_box_lists_tmp = NULL;
  int capi_source_box_lists_intent = 0;
  PyObject *source_box_lists_capi = Py_None;
  int *box_source_starts = NULL;
  npy_intp box_source_starts_Dims[1] = {-1};
  const int box_source_starts_Rank = 1;
  PyArrayObject *capi_box_source_starts_tmp = NULL;
  int capi_box_source_starts_intent = 0;
  PyObject *box_source_starts_capi = Py_None;
  int *box_source_counts_nonchild = NULL;
  npy_intp box_source_counts_nonchild_Dims[1] = {-1};
  const int box_source_counts_nonchild_Rank = 1;
  PyArrayObject *capi_box_source_counts_nonchild_tmp = NULL;
  int capi_box_source_counts_nonchild_intent = 0;
  PyObject *box_source_counts_nonchild_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[3] = {-1, -1, -1};
  const int expn_Rank = 3;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
    static char *capi_kwlist[] = {"zk","sources","charge","qbx_centers","global_qbx_centers","qbx_expansion_radii","qbx_center_to_target_box","nterms","source_box_starts","source_box_lists","box_source_starts","box_source_counts_nonchild","nsources","ntgt_centers","nqbx_centers",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOOOO|OOO:_internal.h3dformta_qbx",\
        capi_kwlist,&zk_capi,&sources_capi,&charge_capi,&qbx_centers_capi,&global_qbx_centers_capi,&qbx_expansion_radii_capi,&qbx_center_to_target_box_capi,&nterms_capi,&source_box_starts_capi,&source_box_lists_capi,&box_source_starts_capi,&box_source_counts_nonchild_capi,&nsources_capi,&ntgt_centers_capi,&nqbx_centers_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable ier */
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.h3dformta_qbx() 1st argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable sources */
  sources_Dims[0]=3;
  capi_sources_intent |= F2PY_INTENT_IN;
  capi_sources_tmp = array_from_pyobj(NPY_DOUBLE,sources_Dims,sources_Rank,capi_sources_intent,sources_capi);
  if (capi_sources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `sources' of _internal.h3dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources = (double *)(PyArray_DATA(capi_sources_tmp));

  /* Processing variable charge */
  ;
  capi_charge_intent |= F2PY_INTENT_IN;
  capi_charge_tmp = array_from_pyobj(NPY_CDOUBLE,charge_Dims,charge_Rank,capi_charge_intent,charge_capi);
  if (capi_charge_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `charge' of _internal.h3dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    charge = (complex_double *)(PyArray_DATA(capi_charge_tmp));

  /* Processing variable global_qbx_centers */
  ;
  capi_global_qbx_centers_intent |= F2PY_INTENT_IN;
  capi_global_qbx_centers_tmp = array_from_pyobj(NPY_INT,global_qbx_centers_Dims,global_qbx_centers_Rank,capi_global_qbx_centers_intent,global_qbx_centers_capi);
  if (capi_global_qbx_centers_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `global_qbx_centers' of _internal.h3dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    global_qbx_centers = (int *)(PyArray_DATA(capi_global_qbx_centers_tmp));

  /* Processing variable qbx_centers */
  qbx_centers_Dims[1]=3;
  capi_qbx_centers_intent |= F2PY_INTENT_IN;
  capi_qbx_centers_tmp = array_from_pyobj(NPY_DOUBLE,qbx_centers_Dims,qbx_centers_Rank,capi_qbx_centers_intent,qbx_centers_capi);
  if (capi_qbx_centers_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `qbx_centers' of _internal.h3dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    qbx_centers = (double *)(PyArray_DATA(capi_qbx_centers_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.h3dformta_qbx() 8th argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable source_box_starts */
  ;
  capi_source_box_starts_intent |= F2PY_INTENT_IN;
  capi_source_box_starts_tmp = array_from_pyobj(NPY_INT,source_box_starts_Dims,source_box_starts_Rank,capi_source_box_starts_intent,source_box_starts_capi);
  if (capi_source_box_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 9th argument `source_box_starts' of _internal.h3dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source_box_starts = (int *)(PyArray_DATA(capi_source_box_starts_tmp));

  /* Processing variable source_box_lists */
  ;
  capi_source_box_lists_intent |= F2PY_INTENT_IN;
  capi_source_box_lists_tmp = array_from_pyobj(NPY_INT,source_box_lists_Dims,source_box_lists_Rank,capi_source_box_lists_intent,source_box_lists_capi);
  if (capi_source_box_lists_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 10th argument `source_box_lists' of _internal.h3dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source_box_lists = (int *)(PyArray_DATA(capi_source_box_lists_tmp));

  /* Processing variable box_source_starts */
  ;
  capi_box_source_starts_intent |= F2PY_INTENT_IN;
  capi_box_source_starts_tmp = array_from_pyobj(NPY_INT,box_source_starts_Dims,box_source_starts_Rank,capi_box_source_starts_intent,box_source_starts_capi);
  if (capi_box_source_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 11st argument `box_source_starts' of _internal.h3dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    box_source_starts = (int *)(PyArray_DATA(capi_box_source_starts_tmp));

  /* Processing variable box_source_counts_nonchild */
  ;
  capi_box_source_counts_nonchild_intent |= F2PY_INTENT_IN;
  capi_box_source_counts_nonchild_tmp = array_from_pyobj(NPY_INT,box_source_counts_nonchild_Dims,box_source_counts_nonchild_Rank,capi_box_source_counts_nonchild_intent,box_source_counts_nonchild_capi);
  if (capi_box_source_counts_nonchild_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 12nd argument `box_source_counts_nonchild' of _internal.h3dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    box_source_counts_nonchild = (int *)(PyArray_DATA(capi_box_source_counts_nonchild_tmp));

  /* Processing variable nsources */
  if (nsources_capi == Py_None) nsources = shape(sources,1); else
    f2py_success = int_from_pyobj(&nsources,nsources_capi,"_internal.h3dformta_qbx() 1st keyword (nsources) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(sources,1)==nsources,"shape(sources,1)==nsources","1st keyword nsources","h3dformta_qbx:nsources=%d",nsources) {
  /* Processing variable ntgt_centers */
  if (ntgt_centers_capi == Py_None) ntgt_centers = len(global_qbx_centers); else
    f2py_success = int_from_pyobj(&ntgt_centers,ntgt_centers_capi,"_internal.h3dformta_qbx() 2nd keyword (ntgt_centers) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(global_qbx_centers)>=ntgt_centers,"len(global_qbx_centers)>=ntgt_centers","2nd keyword ntgt_centers","h3dformta_qbx:ntgt_centers=%d",ntgt_centers) {
  /* Processing variable nqbx_centers */
  if (nqbx_centers_capi == Py_None) nqbx_centers = shape(qbx_centers,0); else
    f2py_success = int_from_pyobj(&nqbx_centers,nqbx_centers_capi,"_internal.h3dformta_qbx() 3rd keyword (nqbx_centers) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(qbx_centers,0)==nqbx_centers,"shape(qbx_centers,0)==nqbx_centers","3rd keyword nqbx_centers","h3dformta_qbx:nqbx_centers=%d",nqbx_centers) {
  /* Processing variable qbx_expansion_radii */
  qbx_expansion_radii_Dims[0]=nqbx_centers;
  capi_qbx_expansion_radii_intent |= F2PY_INTENT_IN;
  capi_qbx_expansion_radii_tmp = array_from_pyobj(NPY_DOUBLE,qbx_expansion_radii_Dims,qbx_expansion_radii_Rank,capi_qbx_expansion_radii_intent,qbx_expansion_radii_capi);
  if (capi_qbx_expansion_radii_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `qbx_expansion_radii' of _internal.h3dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    qbx_expansion_radii = (double *)(PyArray_DATA(capi_qbx_expansion_radii_tmp));

  /* Processing variable qbx_center_to_target_box */
  qbx_center_to_target_box_Dims[0]=nqbx_centers;
  capi_qbx_center_to_target_box_intent |= F2PY_INTENT_IN;
  capi_qbx_center_to_target_box_tmp = array_from_pyobj(NPY_INT,qbx_center_to_target_box_Dims,qbx_center_to_target_box_Rank,capi_qbx_center_to_target_box_intent,qbx_center_to_target_box_capi);
  if (capi_qbx_center_to_target_box_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 7th argument `qbx_center_to_target_box' of _internal.h3dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    qbx_center_to_target_box = (int *)(PyArray_DATA(capi_qbx_center_to_target_box_tmp));

  /* Processing variable expn */
  expn_Dims[0]=nterms + 1,expn_Dims[1]=2 * nterms + 1,expn_Dims[2]=nqbx_centers;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.h3dformta_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ier,&zk,&nsources,sources,charge,&ntgt_centers,&nqbx_centers,qbx_centers,global_qbx_centers,qbx_expansion_radii,qbx_center_to_target_box,&nterms,source_box_starts,source_box_lists,box_source_starts,box_source_counts_nonchild,expn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("iN",ier,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  if((PyObject *)capi_qbx_center_to_target_box_tmp!=qbx_center_to_target_box_capi) {
    Py_XDECREF(capi_qbx_center_to_target_box_tmp); }
  }  /*if (capi_qbx_center_to_target_box_tmp == NULL) ... else of qbx_center_to_target_box*/
  /* End of cleaning variable qbx_center_to_target_box */
  if((PyObject *)capi_qbx_expansion_radii_tmp!=qbx_expansion_radii_capi) {
    Py_XDECREF(capi_qbx_expansion_radii_tmp); }
  }  /*if (capi_qbx_expansion_radii_tmp == NULL) ... else of qbx_expansion_radii*/
  /* End of cleaning variable qbx_expansion_radii */
  } /*CHECKSCALAR(shape(qbx_centers,0)==nqbx_centers)*/
  } /*if (f2py_success) of nqbx_centers*/
  /* End of cleaning variable nqbx_centers */
  } /*CHECKSCALAR(len(global_qbx_centers)>=ntgt_centers)*/
  } /*if (f2py_success) of ntgt_centers*/
  /* End of cleaning variable ntgt_centers */
  } /*CHECKSCALAR(shape(sources,1)==nsources)*/
  } /*if (f2py_success) of nsources*/
  /* End of cleaning variable nsources */
  if((PyObject *)capi_box_source_counts_nonchild_tmp!=box_source_counts_nonchild_capi) {
    Py_XDECREF(capi_box_source_counts_nonchild_tmp); }
  }  /*if (capi_box_source_counts_nonchild_tmp == NULL) ... else of box_source_counts_nonchild*/
  /* End of cleaning variable box_source_counts_nonchild */
  if((PyObject *)capi_box_source_starts_tmp!=box_source_starts_capi) {
    Py_XDECREF(capi_box_source_starts_tmp); }
  }  /*if (capi_box_source_starts_tmp == NULL) ... else of box_source_starts*/
  /* End of cleaning variable box_source_starts */
  if((PyObject *)capi_source_box_lists_tmp!=source_box_lists_capi) {
    Py_XDECREF(capi_source_box_lists_tmp); }
  }  /*if (capi_source_box_lists_tmp == NULL) ... else of source_box_lists*/
  /* End of cleaning variable source_box_lists */
  if((PyObject *)capi_source_box_starts_tmp!=source_box_starts_capi) {
    Py_XDECREF(capi_source_box_starts_tmp); }
  }  /*if (capi_source_box_starts_tmp == NULL) ... else of source_box_starts*/
  /* End of cleaning variable source_box_starts */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_qbx_centers_tmp!=qbx_centers_capi) {
    Py_XDECREF(capi_qbx_centers_tmp); }
  }  /*if (capi_qbx_centers_tmp == NULL) ... else of qbx_centers*/
  /* End of cleaning variable qbx_centers */
  if((PyObject *)capi_global_qbx_centers_tmp!=global_qbx_centers_capi) {
    Py_XDECREF(capi_global_qbx_centers_tmp); }
  }  /*if (capi_global_qbx_centers_tmp == NULL) ... else of global_qbx_centers*/
  /* End of cleaning variable global_qbx_centers */
  if((PyObject *)capi_charge_tmp!=charge_capi) {
    Py_XDECREF(capi_charge_tmp); }
  }  /*if (capi_charge_tmp == NULL) ... else of charge*/
  /* End of cleaning variable charge */
  if((PyObject *)capi_sources_tmp!=sources_capi) {
    Py_XDECREF(capi_sources_tmp); }
  }  /*if (capi_sources_tmp == NULL) ... else of sources*/
  /* End of cleaning variable sources */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
  /* End of cleaning variable ier */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/**************************** end of h3dformta_qbx ****************************/

/****************************** l2dformta_dp_qbx ******************************/
static char doc_f2py_rout__internal_l2dformta_dp_qbx[] = "\
ier,expn = l2dformta_dp_qbx(sources,dipstr,qbx_centers,global_qbx_centers,qbx_expansion_radii,qbx_center_to_target_box,nterms,source_box_starts,source_box_lists,box_source_starts,box_source_counts_nonchild,[nsources,ntgt_centers,nqbx_centers])\n\nWrapper for ``l2dformta_dp_qbx``.\
\n\nParameters\n----------\n"
"sources : input rank-2 array('d') with bounds (2,nsources)\n"
"dipstr : input rank-1 array('D') with bounds (*)\n"
"qbx_centers : input rank-2 array('d') with bounds (nqbx_centers,2)\n"
"global_qbx_centers : input rank-1 array('i') with bounds (ntgt_centers)\n"
"qbx_expansion_radii : input rank-1 array('d') with bounds (nqbx_centers)\n"
"qbx_center_to_target_box : input rank-1 array('i') with bounds (nqbx_centers)\n"
"nterms : input int\n"
"source_box_starts : input rank-1 array('i') with bounds (*)\n"
"source_box_lists : input rank-1 array('i') with bounds (*)\n"
"box_source_starts : input rank-1 array('i') with bounds (*)\n"
"box_source_counts_nonchild : input rank-1 array('i') with bounds (*)\n"
"\nOther Parameters\n----------------\n"
"nsources : input int, optional\n    Default: shape(sources,1)\n"
"ntgt_centers : input int, optional\n    Default: len(global_qbx_centers)\n"
"nqbx_centers : input int, optional\n    Default: shape(qbx_centers,0)\n"
"\nReturns\n-------\n"
"ier : int\n"
"expn : rank-2 array('D') with bounds (nterms + 1,nqbx_centers)";
/* extern void F_FUNC_US(l2dformta_dp_qbx,L2DFORMTA_DP_QBX)(int*,int*,double*,complex_double*,int*,int*,double*,int*,double*,int*,int*,int*,int*,int*,int*,complex_double*); */
static PyObject *f2py_rout__internal_l2dformta_dp_qbx(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*,complex_double*,int*,int*,double*,int*,double*,int*,int*,int*,int*,int*,int*,complex_double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ier = 0;
  int nsources = 0;
  PyObject *nsources_capi = Py_None;
  double *sources = NULL;
  npy_intp sources_Dims[2] = {-1, -1};
  const int sources_Rank = 2;
  PyArrayObject *capi_sources_tmp = NULL;
  int capi_sources_intent = 0;
  PyObject *sources_capi = Py_None;
  complex_double *dipstr = NULL;
  npy_intp dipstr_Dims[1] = {-1};
  const int dipstr_Rank = 1;
  PyArrayObject *capi_dipstr_tmp = NULL;
  int capi_dipstr_intent = 0;
  PyObject *dipstr_capi = Py_None;
  int ntgt_centers = 0;
  PyObject *ntgt_centers_capi = Py_None;
  int nqbx_centers = 0;
  PyObject *nqbx_centers_capi = Py_None;
  double *qbx_centers = NULL;
  npy_intp qbx_centers_Dims[2] = {-1, -1};
  const int qbx_centers_Rank = 2;
  PyArrayObject *capi_qbx_centers_tmp = NULL;
  int capi_qbx_centers_intent = 0;
  PyObject *qbx_centers_capi = Py_None;
  int *global_qbx_centers = NULL;
  npy_intp global_qbx_centers_Dims[1] = {-1};
  const int global_qbx_centers_Rank = 1;
  PyArrayObject *capi_global_qbx_centers_tmp = NULL;
  int capi_global_qbx_centers_intent = 0;
  PyObject *global_qbx_centers_capi = Py_None;
  double *qbx_expansion_radii = NULL;
  npy_intp qbx_expansion_radii_Dims[1] = {-1};
  const int qbx_expansion_radii_Rank = 1;
  PyArrayObject *capi_qbx_expansion_radii_tmp = NULL;
  int capi_qbx_expansion_radii_intent = 0;
  PyObject *qbx_expansion_radii_capi = Py_None;
  int *qbx_center_to_target_box = NULL;
  npy_intp qbx_center_to_target_box_Dims[1] = {-1};
  const int qbx_center_to_target_box_Rank = 1;
  PyArrayObject *capi_qbx_center_to_target_box_tmp = NULL;
  int capi_qbx_center_to_target_box_intent = 0;
  PyObject *qbx_center_to_target_box_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  int *source_box_starts = NULL;
  npy_intp source_box_starts_Dims[1] = {-1};
  const int source_box_starts_Rank = 1;
  PyArrayObject *capi_source_box_starts_tmp = NULL;
  int capi_source_box_starts_intent = 0;
  PyObject *source_box_starts_capi = Py_None;
  int *source_box_lists = NULL;
  npy_intp source_box_lists_Dims[1] = {-1};
  const int source_box_lists_Rank = 1;
  PyArrayObject *capi_source_box_lists_tmp = NULL;
  int capi_source_box_lists_intent = 0;
  PyObject *source_box_lists_capi = Py_None;
  int *box_source_starts = NULL;
  npy_intp box_source_starts_Dims[1] = {-1};
  const int box_source_starts_Rank = 1;
  PyArrayObject *capi_box_source_starts_tmp = NULL;
  int capi_box_source_starts_intent = 0;
  PyObject *box_source_starts_capi = Py_None;
  int *box_source_counts_nonchild = NULL;
  npy_intp box_source_counts_nonchild_Dims[1] = {-1};
  const int box_source_counts_nonchild_Rank = 1;
  PyArrayObject *capi_box_source_counts_nonchild_tmp = NULL;
  int capi_box_source_counts_nonchild_intent = 0;
  PyObject *box_source_counts_nonchild_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[2] = {-1, -1};
  const int expn_Rank = 2;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
    static char *capi_kwlist[] = {"sources","dipstr","qbx_centers","global_qbx_centers","qbx_expansion_radii","qbx_center_to_target_box","nterms","source_box_starts","source_box_lists","box_source_starts","box_source_counts_nonchild","nsources","ntgt_centers","nqbx_centers",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOOO|OOO:_internal.l2dformta_dp_qbx",\
        capi_kwlist,&sources_capi,&dipstr_capi,&qbx_centers_capi,&global_qbx_centers_capi,&qbx_expansion_radii_capi,&qbx_center_to_target_box_capi,&nterms_capi,&source_box_starts_capi,&source_box_lists_capi,&box_source_starts_capi,&box_source_counts_nonchild_capi,&nsources_capi,&ntgt_centers_capi,&nqbx_centers_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable ier */
  /* Processing variable sources */
  sources_Dims[0]=2;
  capi_sources_intent |= F2PY_INTENT_IN;
  capi_sources_tmp = array_from_pyobj(NPY_DOUBLE,sources_Dims,sources_Rank,capi_sources_intent,sources_capi);
  if (capi_sources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 1st argument `sources' of _internal.l2dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources = (double *)(PyArray_DATA(capi_sources_tmp));

  /* Processing variable dipstr */
  ;
  capi_dipstr_intent |= F2PY_INTENT_IN;
  capi_dipstr_tmp = array_from_pyobj(NPY_CDOUBLE,dipstr_Dims,dipstr_Rank,capi_dipstr_intent,dipstr_capi);
  if (capi_dipstr_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `dipstr' of _internal.l2dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr = (complex_double *)(PyArray_DATA(capi_dipstr_tmp));

  /* Processing variable global_qbx_centers */
  ;
  capi_global_qbx_centers_intent |= F2PY_INTENT_IN;
  capi_global_qbx_centers_tmp = array_from_pyobj(NPY_INT,global_qbx_centers_Dims,global_qbx_centers_Rank,capi_global_qbx_centers_intent,global_qbx_centers_capi);
  if (capi_global_qbx_centers_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `global_qbx_centers' of _internal.l2dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    global_qbx_centers = (int *)(PyArray_DATA(capi_global_qbx_centers_tmp));

  /* Processing variable qbx_centers */
  qbx_centers_Dims[1]=2;
  capi_qbx_centers_intent |= F2PY_INTENT_IN;
  capi_qbx_centers_tmp = array_from_pyobj(NPY_DOUBLE,qbx_centers_Dims,qbx_centers_Rank,capi_qbx_centers_intent,qbx_centers_capi);
  if (capi_qbx_centers_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `qbx_centers' of _internal.l2dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    qbx_centers = (double *)(PyArray_DATA(capi_qbx_centers_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.l2dformta_dp_qbx() 7th argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable source_box_starts */
  ;
  capi_source_box_starts_intent |= F2PY_INTENT_IN;
  capi_source_box_starts_tmp = array_from_pyobj(NPY_INT,source_box_starts_Dims,source_box_starts_Rank,capi_source_box_starts_intent,source_box_starts_capi);
  if (capi_source_box_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 8th argument `source_box_starts' of _internal.l2dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source_box_starts = (int *)(PyArray_DATA(capi_source_box_starts_tmp));

  /* Processing variable source_box_lists */
  ;
  capi_source_box_lists_intent |= F2PY_INTENT_IN;
  capi_source_box_lists_tmp = array_from_pyobj(NPY_INT,source_box_lists_Dims,source_box_lists_Rank,capi_source_box_lists_intent,source_box_lists_capi);
  if (capi_source_box_lists_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 9th argument `source_box_lists' of _internal.l2dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source_box_lists = (int *)(PyArray_DATA(capi_source_box_lists_tmp));

  /* Processing variable box_source_starts */
  ;
  capi_box_source_starts_intent |= F2PY_INTENT_IN;
  capi_box_source_starts_tmp = array_from_pyobj(NPY_INT,box_source_starts_Dims,box_source_starts_Rank,capi_box_source_starts_intent,box_source_starts_capi);
  if (capi_box_source_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 10th argument `box_source_starts' of _internal.l2dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    box_source_starts = (int *)(PyArray_DATA(capi_box_source_starts_tmp));

  /* Processing variable box_source_counts_nonchild */
  ;
  capi_box_source_counts_nonchild_intent |= F2PY_INTENT_IN;
  capi_box_source_counts_nonchild_tmp = array_from_pyobj(NPY_INT,box_source_counts_nonchild_Dims,box_source_counts_nonchild_Rank,capi_box_source_counts_nonchild_intent,box_source_counts_nonchild_capi);
  if (capi_box_source_counts_nonchild_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 11st argument `box_source_counts_nonchild' of _internal.l2dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    box_source_counts_nonchild = (int *)(PyArray_DATA(capi_box_source_counts_nonchild_tmp));

  /* Processing variable nsources */
  if (nsources_capi == Py_None) nsources = shape(sources,1); else
    f2py_success = int_from_pyobj(&nsources,nsources_capi,"_internal.l2dformta_dp_qbx() 1st keyword (nsources) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(sources,1)==nsources,"shape(sources,1)==nsources","1st keyword nsources","l2dformta_dp_qbx:nsources=%d",nsources) {
  /* Processing variable ntgt_centers */
  if (ntgt_centers_capi == Py_None) ntgt_centers = len(global_qbx_centers); else
    f2py_success = int_from_pyobj(&ntgt_centers,ntgt_centers_capi,"_internal.l2dformta_dp_qbx() 2nd keyword (ntgt_centers) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(global_qbx_centers)>=ntgt_centers,"len(global_qbx_centers)>=ntgt_centers","2nd keyword ntgt_centers","l2dformta_dp_qbx:ntgt_centers=%d",ntgt_centers) {
  /* Processing variable nqbx_centers */
  if (nqbx_centers_capi == Py_None) nqbx_centers = shape(qbx_centers,0); else
    f2py_success = int_from_pyobj(&nqbx_centers,nqbx_centers_capi,"_internal.l2dformta_dp_qbx() 3rd keyword (nqbx_centers) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(qbx_centers,0)==nqbx_centers,"shape(qbx_centers,0)==nqbx_centers","3rd keyword nqbx_centers","l2dformta_dp_qbx:nqbx_centers=%d",nqbx_centers) {
  /* Processing variable qbx_expansion_radii */
  qbx_expansion_radii_Dims[0]=nqbx_centers;
  capi_qbx_expansion_radii_intent |= F2PY_INTENT_IN;
  capi_qbx_expansion_radii_tmp = array_from_pyobj(NPY_DOUBLE,qbx_expansion_radii_Dims,qbx_expansion_radii_Rank,capi_qbx_expansion_radii_intent,qbx_expansion_radii_capi);
  if (capi_qbx_expansion_radii_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `qbx_expansion_radii' of _internal.l2dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    qbx_expansion_radii = (double *)(PyArray_DATA(capi_qbx_expansion_radii_tmp));

  /* Processing variable qbx_center_to_target_box */
  qbx_center_to_target_box_Dims[0]=nqbx_centers;
  capi_qbx_center_to_target_box_intent |= F2PY_INTENT_IN;
  capi_qbx_center_to_target_box_tmp = array_from_pyobj(NPY_INT,qbx_center_to_target_box_Dims,qbx_center_to_target_box_Rank,capi_qbx_center_to_target_box_intent,qbx_center_to_target_box_capi);
  if (capi_qbx_center_to_target_box_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `qbx_center_to_target_box' of _internal.l2dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    qbx_center_to_target_box = (int *)(PyArray_DATA(capi_qbx_center_to_target_box_tmp));

  /* Processing variable expn */
  expn_Dims[0]=nterms + 1,expn_Dims[1]=nqbx_centers;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.l2dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ier,&nsources,sources,dipstr,&ntgt_centers,&nqbx_centers,qbx_centers,global_qbx_centers,qbx_expansion_radii,qbx_center_to_target_box,&nterms,source_box_starts,source_box_lists,box_source_starts,box_source_counts_nonchild,expn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("iN",ier,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  if((PyObject *)capi_qbx_center_to_target_box_tmp!=qbx_center_to_target_box_capi) {
    Py_XDECREF(capi_qbx_center_to_target_box_tmp); }
  }  /*if (capi_qbx_center_to_target_box_tmp == NULL) ... else of qbx_center_to_target_box*/
  /* End of cleaning variable qbx_center_to_target_box */
  if((PyObject *)capi_qbx_expansion_radii_tmp!=qbx_expansion_radii_capi) {
    Py_XDECREF(capi_qbx_expansion_radii_tmp); }
  }  /*if (capi_qbx_expansion_radii_tmp == NULL) ... else of qbx_expansion_radii*/
  /* End of cleaning variable qbx_expansion_radii */
  } /*CHECKSCALAR(shape(qbx_centers,0)==nqbx_centers)*/
  } /*if (f2py_success) of nqbx_centers*/
  /* End of cleaning variable nqbx_centers */
  } /*CHECKSCALAR(len(global_qbx_centers)>=ntgt_centers)*/
  } /*if (f2py_success) of ntgt_centers*/
  /* End of cleaning variable ntgt_centers */
  } /*CHECKSCALAR(shape(sources,1)==nsources)*/
  } /*if (f2py_success) of nsources*/
  /* End of cleaning variable nsources */
  if((PyObject *)capi_box_source_counts_nonchild_tmp!=box_source_counts_nonchild_capi) {
    Py_XDECREF(capi_box_source_counts_nonchild_tmp); }
  }  /*if (capi_box_source_counts_nonchild_tmp == NULL) ... else of box_source_counts_nonchild*/
  /* End of cleaning variable box_source_counts_nonchild */
  if((PyObject *)capi_box_source_starts_tmp!=box_source_starts_capi) {
    Py_XDECREF(capi_box_source_starts_tmp); }
  }  /*if (capi_box_source_starts_tmp == NULL) ... else of box_source_starts*/
  /* End of cleaning variable box_source_starts */
  if((PyObject *)capi_source_box_lists_tmp!=source_box_lists_capi) {
    Py_XDECREF(capi_source_box_lists_tmp); }
  }  /*if (capi_source_box_lists_tmp == NULL) ... else of source_box_lists*/
  /* End of cleaning variable source_box_lists */
  if((PyObject *)capi_source_box_starts_tmp!=source_box_starts_capi) {
    Py_XDECREF(capi_source_box_starts_tmp); }
  }  /*if (capi_source_box_starts_tmp == NULL) ... else of source_box_starts*/
  /* End of cleaning variable source_box_starts */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_qbx_centers_tmp!=qbx_centers_capi) {
    Py_XDECREF(capi_qbx_centers_tmp); }
  }  /*if (capi_qbx_centers_tmp == NULL) ... else of qbx_centers*/
  /* End of cleaning variable qbx_centers */
  if((PyObject *)capi_global_qbx_centers_tmp!=global_qbx_centers_capi) {
    Py_XDECREF(capi_global_qbx_centers_tmp); }
  }  /*if (capi_global_qbx_centers_tmp == NULL) ... else of global_qbx_centers*/
  /* End of cleaning variable global_qbx_centers */
  if((PyObject *)capi_dipstr_tmp!=dipstr_capi) {
    Py_XDECREF(capi_dipstr_tmp); }
  }  /*if (capi_dipstr_tmp == NULL) ... else of dipstr*/
  /* End of cleaning variable dipstr */
  if((PyObject *)capi_sources_tmp!=sources_capi) {
    Py_XDECREF(capi_sources_tmp); }
  }  /*if (capi_sources_tmp == NULL) ... else of sources*/
  /* End of cleaning variable sources */
  /* End of cleaning variable ier */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/************************** end of l2dformta_dp_qbx **************************/

/****************************** h2dformta_dp_qbx ******************************/
static char doc_f2py_rout__internal_h2dformta_dp_qbx[] = "\
ier,expn = h2dformta_dp_qbx(zk,sources,dipstr,dipvec,qbx_centers,global_qbx_centers,qbx_expansion_radii,qbx_center_to_target_box,nterms,source_box_starts,source_box_lists,box_source_starts,box_source_counts_nonchild,[nsources,ntgt_centers,nqbx_centers])\n\nWrapper for ``h2dformta_dp_qbx``.\
\n\nParameters\n----------\n"
"zk : input complex\n"
"sources : input rank-2 array('d') with bounds (2,nsources)\n"
"dipstr : input rank-1 array('D') with bounds (*)\n"
"dipvec : input rank-2 array('d') with bounds (2,*)\n"
"qbx_centers : input rank-2 array('d') with bounds (nqbx_centers,2)\n"
"global_qbx_centers : input rank-1 array('i') with bounds (ntgt_centers)\n"
"qbx_expansion_radii : input rank-1 array('d') with bounds (nqbx_centers)\n"
"qbx_center_to_target_box : input rank-1 array('i') with bounds (nqbx_centers)\n"
"nterms : input int\n"
"source_box_starts : input rank-1 array('i') with bounds (*)\n"
"source_box_lists : input rank-1 array('i') with bounds (*)\n"
"box_source_starts : input rank-1 array('i') with bounds (*)\n"
"box_source_counts_nonchild : input rank-1 array('i') with bounds (*)\n"
"\nOther Parameters\n----------------\n"
"nsources : input int, optional\n    Default: shape(sources,1)\n"
"ntgt_centers : input int, optional\n    Default: len(global_qbx_centers)\n"
"nqbx_centers : input int, optional\n    Default: shape(qbx_centers,0)\n"
"\nReturns\n-------\n"
"ier : int\n"
"expn : rank-2 array('D') with bounds (2 * nterms + 1,nqbx_centers)";
/* extern void F_FUNC_US(h2dformta_dp_qbx,H2DFORMTA_DP_QBX)(int*,complex_double*,int*,double*,complex_double*,double*,int*,int*,double*,int*,double*,int*,int*,int*,int*,int*,int*,complex_double*); */
static PyObject *f2py_rout__internal_h2dformta_dp_qbx(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,complex_double*,int*,double*,complex_double*,double*,int*,int*,double*,int*,double*,int*,int*,int*,int*,int*,int*,complex_double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ier = 0;
  complex_double zk;
  PyObject *zk_capi = Py_None;
  int nsources = 0;
  PyObject *nsources_capi = Py_None;
  double *sources = NULL;
  npy_intp sources_Dims[2] = {-1, -1};
  const int sources_Rank = 2;
  PyArrayObject *capi_sources_tmp = NULL;
  int capi_sources_intent = 0;
  PyObject *sources_capi = Py_None;
  complex_double *dipstr = NULL;
  npy_intp dipstr_Dims[1] = {-1};
  const int dipstr_Rank = 1;
  PyArrayObject *capi_dipstr_tmp = NULL;
  int capi_dipstr_intent = 0;
  PyObject *dipstr_capi = Py_None;
  double *dipvec = NULL;
  npy_intp dipvec_Dims[2] = {-1, -1};
  const int dipvec_Rank = 2;
  PyArrayObject *capi_dipvec_tmp = NULL;
  int capi_dipvec_intent = 0;
  PyObject *dipvec_capi = Py_None;
  int ntgt_centers = 0;
  PyObject *ntgt_centers_capi = Py_None;
  int nqbx_centers = 0;
  PyObject *nqbx_centers_capi = Py_None;
  double *qbx_centers = NULL;
  npy_intp qbx_centers_Dims[2] = {-1, -1};
  const int qbx_centers_Rank = 2;
  PyArrayObject *capi_qbx_centers_tmp = NULL;
  int capi_qbx_centers_intent = 0;
  PyObject *qbx_centers_capi = Py_None;
  int *global_qbx_centers = NULL;
  npy_intp global_qbx_centers_Dims[1] = {-1};
  const int global_qbx_centers_Rank = 1;
  PyArrayObject *capi_global_qbx_centers_tmp = NULL;
  int capi_global_qbx_centers_intent = 0;
  PyObject *global_qbx_centers_capi = Py_None;
  double *qbx_expansion_radii = NULL;
  npy_intp qbx_expansion_radii_Dims[1] = {-1};
  const int qbx_expansion_radii_Rank = 1;
  PyArrayObject *capi_qbx_expansion_radii_tmp = NULL;
  int capi_qbx_expansion_radii_intent = 0;
  PyObject *qbx_expansion_radii_capi = Py_None;
  int *qbx_center_to_target_box = NULL;
  npy_intp qbx_center_to_target_box_Dims[1] = {-1};
  const int qbx_center_to_target_box_Rank = 1;
  PyArrayObject *capi_qbx_center_to_target_box_tmp = NULL;
  int capi_qbx_center_to_target_box_intent = 0;
  PyObject *qbx_center_to_target_box_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  int *source_box_starts = NULL;
  npy_intp source_box_starts_Dims[1] = {-1};
  const int source_box_starts_Rank = 1;
  PyArrayObject *capi_source_box_starts_tmp = NULL;
  int capi_source_box_starts_intent = 0;
  PyObject *source_box_starts_capi = Py_None;
  int *source_box_lists = NULL;
  npy_intp source_box_lists_Dims[1] = {-1};
  const int source_box_lists_Rank = 1;
  PyArrayObject *capi_source_box_lists_tmp = NULL;
  int capi_source_box_lists_intent = 0;
  PyObject *source_box_lists_capi = Py_None;
  int *box_source_starts = NULL;
  npy_intp box_source_starts_Dims[1] = {-1};
  const int box_source_starts_Rank = 1;
  PyArrayObject *capi_box_source_starts_tmp = NULL;
  int capi_box_source_starts_intent = 0;
  PyObject *box_source_starts_capi = Py_None;
  int *box_source_counts_nonchild = NULL;
  npy_intp box_source_counts_nonchild_Dims[1] = {-1};
  const int box_source_counts_nonchild_Rank = 1;
  PyArrayObject *capi_box_source_counts_nonchild_tmp = NULL;
  int capi_box_source_counts_nonchild_intent = 0;
  PyObject *box_source_counts_nonchild_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[2] = {-1, -1};
  const int expn_Rank = 2;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
    static char *capi_kwlist[] = {"zk","sources","dipstr","dipvec","qbx_centers","global_qbx_centers","qbx_expansion_radii","qbx_center_to_target_box","nterms","source_box_starts","source_box_lists","box_source_starts","box_source_counts_nonchild","nsources","ntgt_centers","nqbx_centers",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOOOOO|OOO:_internal.h2dformta_dp_qbx",\
        capi_kwlist,&zk_capi,&sources_capi,&dipstr_capi,&dipvec_capi,&qbx_centers_capi,&global_qbx_centers_capi,&qbx_expansion_radii_capi,&qbx_center_to_target_box_capi,&nterms_capi,&source_box_starts_capi,&source_box_lists_capi,&box_source_starts_capi,&box_source_counts_nonchild_capi,&nsources_capi,&ntgt_centers_capi,&nqbx_centers_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable ier */
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.h2dformta_dp_qbx() 1st argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable sources */
  sources_Dims[0]=2;
  capi_sources_intent |= F2PY_INTENT_IN;
  capi_sources_tmp = array_from_pyobj(NPY_DOUBLE,sources_Dims,sources_Rank,capi_sources_intent,sources_capi);
  if (capi_sources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `sources' of _internal.h2dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources = (double *)(PyArray_DATA(capi_sources_tmp));

  /* Processing variable dipstr */
  ;
  capi_dipstr_intent |= F2PY_INTENT_IN;
  capi_dipstr_tmp = array_from_pyobj(NPY_CDOUBLE,dipstr_Dims,dipstr_Rank,capi_dipstr_intent,dipstr_capi);
  if (capi_dipstr_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `dipstr' of _internal.h2dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr = (complex_double *)(PyArray_DATA(capi_dipstr_tmp));

  /* Processing variable dipvec */
  dipvec_Dims[0]=2;
  capi_dipvec_intent |= F2PY_INTENT_IN;
  capi_dipvec_tmp = array_from_pyobj(NPY_DOUBLE,dipvec_Dims,dipvec_Rank,capi_dipvec_intent,dipvec_capi);
  if (capi_dipvec_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `dipvec' of _internal.h2dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipvec = (double *)(PyArray_DATA(capi_dipvec_tmp));

  /* Processing variable global_qbx_centers */
  ;
  capi_global_qbx_centers_intent |= F2PY_INTENT_IN;
  capi_global_qbx_centers_tmp = array_from_pyobj(NPY_INT,global_qbx_centers_Dims,global_qbx_centers_Rank,capi_global_qbx_centers_intent,global_qbx_centers_capi);
  if (capi_global_qbx_centers_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `global_qbx_centers' of _internal.h2dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    global_qbx_centers = (int *)(PyArray_DATA(capi_global_qbx_centers_tmp));

  /* Processing variable qbx_centers */
  qbx_centers_Dims[1]=2;
  capi_qbx_centers_intent |= F2PY_INTENT_IN;
  capi_qbx_centers_tmp = array_from_pyobj(NPY_DOUBLE,qbx_centers_Dims,qbx_centers_Rank,capi_qbx_centers_intent,qbx_centers_capi);
  if (capi_qbx_centers_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `qbx_centers' of _internal.h2dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    qbx_centers = (double *)(PyArray_DATA(capi_qbx_centers_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.h2dformta_dp_qbx() 9th argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable source_box_starts */
  ;
  capi_source_box_starts_intent |= F2PY_INTENT_IN;
  capi_source_box_starts_tmp = array_from_pyobj(NPY_INT,source_box_starts_Dims,source_box_starts_Rank,capi_source_box_starts_intent,source_box_starts_capi);
  if (capi_source_box_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 10th argument `source_box_starts' of _internal.h2dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source_box_starts = (int *)(PyArray_DATA(capi_source_box_starts_tmp));

  /* Processing variable source_box_lists */
  ;
  capi_source_box_lists_intent |= F2PY_INTENT_IN;
  capi_source_box_lists_tmp = array_from_pyobj(NPY_INT,source_box_lists_Dims,source_box_lists_Rank,capi_source_box_lists_intent,source_box_lists_capi);
  if (capi_source_box_lists_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 11st argument `source_box_lists' of _internal.h2dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source_box_lists = (int *)(PyArray_DATA(capi_source_box_lists_tmp));

  /* Processing variable box_source_starts */
  ;
  capi_box_source_starts_intent |= F2PY_INTENT_IN;
  capi_box_source_starts_tmp = array_from_pyobj(NPY_INT,box_source_starts_Dims,box_source_starts_Rank,capi_box_source_starts_intent,box_source_starts_capi);
  if (capi_box_source_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 12nd argument `box_source_starts' of _internal.h2dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    box_source_starts = (int *)(PyArray_DATA(capi_box_source_starts_tmp));

  /* Processing variable box_source_counts_nonchild */
  ;
  capi_box_source_counts_nonchild_intent |= F2PY_INTENT_IN;
  capi_box_source_counts_nonchild_tmp = array_from_pyobj(NPY_INT,box_source_counts_nonchild_Dims,box_source_counts_nonchild_Rank,capi_box_source_counts_nonchild_intent,box_source_counts_nonchild_capi);
  if (capi_box_source_counts_nonchild_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 13rd argument `box_source_counts_nonchild' of _internal.h2dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    box_source_counts_nonchild = (int *)(PyArray_DATA(capi_box_source_counts_nonchild_tmp));

  /* Processing variable nsources */
  if (nsources_capi == Py_None) nsources = shape(sources,1); else
    f2py_success = int_from_pyobj(&nsources,nsources_capi,"_internal.h2dformta_dp_qbx() 1st keyword (nsources) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(sources,1)==nsources,"shape(sources,1)==nsources","1st keyword nsources","h2dformta_dp_qbx:nsources=%d",nsources) {
  /* Processing variable ntgt_centers */
  if (ntgt_centers_capi == Py_None) ntgt_centers = len(global_qbx_centers); else
    f2py_success = int_from_pyobj(&ntgt_centers,ntgt_centers_capi,"_internal.h2dformta_dp_qbx() 2nd keyword (ntgt_centers) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(global_qbx_centers)>=ntgt_centers,"len(global_qbx_centers)>=ntgt_centers","2nd keyword ntgt_centers","h2dformta_dp_qbx:ntgt_centers=%d",ntgt_centers) {
  /* Processing variable nqbx_centers */
  if (nqbx_centers_capi == Py_None) nqbx_centers = shape(qbx_centers,0); else
    f2py_success = int_from_pyobj(&nqbx_centers,nqbx_centers_capi,"_internal.h2dformta_dp_qbx() 3rd keyword (nqbx_centers) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(qbx_centers,0)==nqbx_centers,"shape(qbx_centers,0)==nqbx_centers","3rd keyword nqbx_centers","h2dformta_dp_qbx:nqbx_centers=%d",nqbx_centers) {
  /* Processing variable qbx_expansion_radii */
  qbx_expansion_radii_Dims[0]=nqbx_centers;
  capi_qbx_expansion_radii_intent |= F2PY_INTENT_IN;
  capi_qbx_expansion_radii_tmp = array_from_pyobj(NPY_DOUBLE,qbx_expansion_radii_Dims,qbx_expansion_radii_Rank,capi_qbx_expansion_radii_intent,qbx_expansion_radii_capi);
  if (capi_qbx_expansion_radii_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 7th argument `qbx_expansion_radii' of _internal.h2dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    qbx_expansion_radii = (double *)(PyArray_DATA(capi_qbx_expansion_radii_tmp));

  /* Processing variable qbx_center_to_target_box */
  qbx_center_to_target_box_Dims[0]=nqbx_centers;
  capi_qbx_center_to_target_box_intent |= F2PY_INTENT_IN;
  capi_qbx_center_to_target_box_tmp = array_from_pyobj(NPY_INT,qbx_center_to_target_box_Dims,qbx_center_to_target_box_Rank,capi_qbx_center_to_target_box_intent,qbx_center_to_target_box_capi);
  if (capi_qbx_center_to_target_box_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 8th argument `qbx_center_to_target_box' of _internal.h2dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    qbx_center_to_target_box = (int *)(PyArray_DATA(capi_qbx_center_to_target_box_tmp));

  /* Processing variable expn */
  expn_Dims[0]=2 * nterms + 1,expn_Dims[1]=nqbx_centers;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.h2dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ier,&zk,&nsources,sources,dipstr,dipvec,&ntgt_centers,&nqbx_centers,qbx_centers,global_qbx_centers,qbx_expansion_radii,qbx_center_to_target_box,&nterms,source_box_starts,source_box_lists,box_source_starts,box_source_counts_nonchild,expn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("iN",ier,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  if((PyObject *)capi_qbx_center_to_target_box_tmp!=qbx_center_to_target_box_capi) {
    Py_XDECREF(capi_qbx_center_to_target_box_tmp); }
  }  /*if (capi_qbx_center_to_target_box_tmp == NULL) ... else of qbx_center_to_target_box*/
  /* End of cleaning variable qbx_center_to_target_box */
  if((PyObject *)capi_qbx_expansion_radii_tmp!=qbx_expansion_radii_capi) {
    Py_XDECREF(capi_qbx_expansion_radii_tmp); }
  }  /*if (capi_qbx_expansion_radii_tmp == NULL) ... else of qbx_expansion_radii*/
  /* End of cleaning variable qbx_expansion_radii */
  } /*CHECKSCALAR(shape(qbx_centers,0)==nqbx_centers)*/
  } /*if (f2py_success) of nqbx_centers*/
  /* End of cleaning variable nqbx_centers */
  } /*CHECKSCALAR(len(global_qbx_centers)>=ntgt_centers)*/
  } /*if (f2py_success) of ntgt_centers*/
  /* End of cleaning variable ntgt_centers */
  } /*CHECKSCALAR(shape(sources,1)==nsources)*/
  } /*if (f2py_success) of nsources*/
  /* End of cleaning variable nsources */
  if((PyObject *)capi_box_source_counts_nonchild_tmp!=box_source_counts_nonchild_capi) {
    Py_XDECREF(capi_box_source_counts_nonchild_tmp); }
  }  /*if (capi_box_source_counts_nonchild_tmp == NULL) ... else of box_source_counts_nonchild*/
  /* End of cleaning variable box_source_counts_nonchild */
  if((PyObject *)capi_box_source_starts_tmp!=box_source_starts_capi) {
    Py_XDECREF(capi_box_source_starts_tmp); }
  }  /*if (capi_box_source_starts_tmp == NULL) ... else of box_source_starts*/
  /* End of cleaning variable box_source_starts */
  if((PyObject *)capi_source_box_lists_tmp!=source_box_lists_capi) {
    Py_XDECREF(capi_source_box_lists_tmp); }
  }  /*if (capi_source_box_lists_tmp == NULL) ... else of source_box_lists*/
  /* End of cleaning variable source_box_lists */
  if((PyObject *)capi_source_box_starts_tmp!=source_box_starts_capi) {
    Py_XDECREF(capi_source_box_starts_tmp); }
  }  /*if (capi_source_box_starts_tmp == NULL) ... else of source_box_starts*/
  /* End of cleaning variable source_box_starts */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_qbx_centers_tmp!=qbx_centers_capi) {
    Py_XDECREF(capi_qbx_centers_tmp); }
  }  /*if (capi_qbx_centers_tmp == NULL) ... else of qbx_centers*/
  /* End of cleaning variable qbx_centers */
  if((PyObject *)capi_global_qbx_centers_tmp!=global_qbx_centers_capi) {
    Py_XDECREF(capi_global_qbx_centers_tmp); }
  }  /*if (capi_global_qbx_centers_tmp == NULL) ... else of global_qbx_centers*/
  /* End of cleaning variable global_qbx_centers */
  if((PyObject *)capi_dipvec_tmp!=dipvec_capi) {
    Py_XDECREF(capi_dipvec_tmp); }
  }  /*if (capi_dipvec_tmp == NULL) ... else of dipvec*/
  /* End of cleaning variable dipvec */
  if((PyObject *)capi_dipstr_tmp!=dipstr_capi) {
    Py_XDECREF(capi_dipstr_tmp); }
  }  /*if (capi_dipstr_tmp == NULL) ... else of dipstr*/
  /* End of cleaning variable dipstr */
  if((PyObject *)capi_sources_tmp!=sources_capi) {
    Py_XDECREF(capi_sources_tmp); }
  }  /*if (capi_sources_tmp == NULL) ... else of sources*/
  /* End of cleaning variable sources */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
  /* End of cleaning variable ier */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/************************** end of h2dformta_dp_qbx **************************/

/****************************** l3dformta_dp_qbx ******************************/
static char doc_f2py_rout__internal_l3dformta_dp_qbx[] = "\
ier,expn = l3dformta_dp_qbx(sources,dipstr,dipvec,qbx_centers,global_qbx_centers,qbx_expansion_radii,qbx_center_to_target_box,nterms,source_box_starts,source_box_lists,box_source_starts,box_source_counts_nonchild,[nsources,ntgt_centers,nqbx_centers])\n\nWrapper for ``l3dformta_dp_qbx``.\
\n\nParameters\n----------\n"
"sources : input rank-2 array('d') with bounds (3,nsources)\n"
"dipstr : input rank-1 array('D') with bounds (*)\n"
"dipvec : input rank-2 array('d') with bounds (3,*)\n"
"qbx_centers : input rank-2 array('d') with bounds (nqbx_centers,3)\n"
"global_qbx_centers : input rank-1 array('i') with bounds (ntgt_centers)\n"
"qbx_expansion_radii : input rank-1 array('d') with bounds (nqbx_centers)\n"
"qbx_center_to_target_box : input rank-1 array('i') with bounds (nqbx_centers)\n"
"nterms : input int\n"
"source_box_starts : input rank-1 array('i') with bounds (*)\n"
"source_box_lists : input rank-1 array('i') with bounds (*)\n"
"box_source_starts : input rank-1 array('i') with bounds (*)\n"
"box_source_counts_nonchild : input rank-1 array('i') with bounds (*)\n"
"\nOther Parameters\n----------------\n"
"nsources : input int, optional\n    Default: shape(sources,1)\n"
"ntgt_centers : input int, optional\n    Default: len(global_qbx_centers)\n"
"nqbx_centers : input int, optional\n    Default: shape(qbx_centers,0)\n"
"\nReturns\n-------\n"
"ier : int\n"
"expn : rank-3 array('D') with bounds (nterms + 1,2 * nterms + 1,nqbx_centers)";
/* extern void F_FUNC_US(l3dformta_dp_qbx,L3DFORMTA_DP_QBX)(int*,int*,double*,complex_double*,double*,int*,int*,double*,int*,double*,int*,int*,int*,int*,int*,int*,complex_double*); */
static PyObject *f2py_rout__internal_l3dformta_dp_qbx(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*,complex_double*,double*,int*,int*,double*,int*,double*,int*,int*,int*,int*,int*,int*,complex_double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ier = 0;
  int nsources = 0;
  PyObject *nsources_capi = Py_None;
  double *sources = NULL;
  npy_intp sources_Dims[2] = {-1, -1};
  const int sources_Rank = 2;
  PyArrayObject *capi_sources_tmp = NULL;
  int capi_sources_intent = 0;
  PyObject *sources_capi = Py_None;
  complex_double *dipstr = NULL;
  npy_intp dipstr_Dims[1] = {-1};
  const int dipstr_Rank = 1;
  PyArrayObject *capi_dipstr_tmp = NULL;
  int capi_dipstr_intent = 0;
  PyObject *dipstr_capi = Py_None;
  double *dipvec = NULL;
  npy_intp dipvec_Dims[2] = {-1, -1};
  const int dipvec_Rank = 2;
  PyArrayObject *capi_dipvec_tmp = NULL;
  int capi_dipvec_intent = 0;
  PyObject *dipvec_capi = Py_None;
  int ntgt_centers = 0;
  PyObject *ntgt_centers_capi = Py_None;
  int nqbx_centers = 0;
  PyObject *nqbx_centers_capi = Py_None;
  double *qbx_centers = NULL;
  npy_intp qbx_centers_Dims[2] = {-1, -1};
  const int qbx_centers_Rank = 2;
  PyArrayObject *capi_qbx_centers_tmp = NULL;
  int capi_qbx_centers_intent = 0;
  PyObject *qbx_centers_capi = Py_None;
  int *global_qbx_centers = NULL;
  npy_intp global_qbx_centers_Dims[1] = {-1};
  const int global_qbx_centers_Rank = 1;
  PyArrayObject *capi_global_qbx_centers_tmp = NULL;
  int capi_global_qbx_centers_intent = 0;
  PyObject *global_qbx_centers_capi = Py_None;
  double *qbx_expansion_radii = NULL;
  npy_intp qbx_expansion_radii_Dims[1] = {-1};
  const int qbx_expansion_radii_Rank = 1;
  PyArrayObject *capi_qbx_expansion_radii_tmp = NULL;
  int capi_qbx_expansion_radii_intent = 0;
  PyObject *qbx_expansion_radii_capi = Py_None;
  int *qbx_center_to_target_box = NULL;
  npy_intp qbx_center_to_target_box_Dims[1] = {-1};
  const int qbx_center_to_target_box_Rank = 1;
  PyArrayObject *capi_qbx_center_to_target_box_tmp = NULL;
  int capi_qbx_center_to_target_box_intent = 0;
  PyObject *qbx_center_to_target_box_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  int *source_box_starts = NULL;
  npy_intp source_box_starts_Dims[1] = {-1};
  const int source_box_starts_Rank = 1;
  PyArrayObject *capi_source_box_starts_tmp = NULL;
  int capi_source_box_starts_intent = 0;
  PyObject *source_box_starts_capi = Py_None;
  int *source_box_lists = NULL;
  npy_intp source_box_lists_Dims[1] = {-1};
  const int source_box_lists_Rank = 1;
  PyArrayObject *capi_source_box_lists_tmp = NULL;
  int capi_source_box_lists_intent = 0;
  PyObject *source_box_lists_capi = Py_None;
  int *box_source_starts = NULL;
  npy_intp box_source_starts_Dims[1] = {-1};
  const int box_source_starts_Rank = 1;
  PyArrayObject *capi_box_source_starts_tmp = NULL;
  int capi_box_source_starts_intent = 0;
  PyObject *box_source_starts_capi = Py_None;
  int *box_source_counts_nonchild = NULL;
  npy_intp box_source_counts_nonchild_Dims[1] = {-1};
  const int box_source_counts_nonchild_Rank = 1;
  PyArrayObject *capi_box_source_counts_nonchild_tmp = NULL;
  int capi_box_source_counts_nonchild_intent = 0;
  PyObject *box_source_counts_nonchild_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[3] = {-1, -1, -1};
  const int expn_Rank = 3;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
    static char *capi_kwlist[] = {"sources","dipstr","dipvec","qbx_centers","global_qbx_centers","qbx_expansion_radii","qbx_center_to_target_box","nterms","source_box_starts","source_box_lists","box_source_starts","box_source_counts_nonchild","nsources","ntgt_centers","nqbx_centers",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOOOO|OOO:_internal.l3dformta_dp_qbx",\
        capi_kwlist,&sources_capi,&dipstr_capi,&dipvec_capi,&qbx_centers_capi,&global_qbx_centers_capi,&qbx_expansion_radii_capi,&qbx_center_to_target_box_capi,&nterms_capi,&source_box_starts_capi,&source_box_lists_capi,&box_source_starts_capi,&box_source_counts_nonchild_capi,&nsources_capi,&ntgt_centers_capi,&nqbx_centers_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable ier */
  /* Processing variable sources */
  sources_Dims[0]=3;
  capi_sources_intent |= F2PY_INTENT_IN;
  capi_sources_tmp = array_from_pyobj(NPY_DOUBLE,sources_Dims,sources_Rank,capi_sources_intent,sources_capi);
  if (capi_sources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 1st argument `sources' of _internal.l3dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources = (double *)(PyArray_DATA(capi_sources_tmp));

  /* Processing variable dipstr */
  ;
  capi_dipstr_intent |= F2PY_INTENT_IN;
  capi_dipstr_tmp = array_from_pyobj(NPY_CDOUBLE,dipstr_Dims,dipstr_Rank,capi_dipstr_intent,dipstr_capi);
  if (capi_dipstr_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `dipstr' of _internal.l3dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr = (complex_double *)(PyArray_DATA(capi_dipstr_tmp));

  /* Processing variable dipvec */
  dipvec_Dims[0]=3;
  capi_dipvec_intent |= F2PY_INTENT_IN;
  capi_dipvec_tmp = array_from_pyobj(NPY_DOUBLE,dipvec_Dims,dipvec_Rank,capi_dipvec_intent,dipvec_capi);
  if (capi_dipvec_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `dipvec' of _internal.l3dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipvec = (double *)(PyArray_DATA(capi_dipvec_tmp));

  /* Processing variable global_qbx_centers */
  ;
  capi_global_qbx_centers_intent |= F2PY_INTENT_IN;
  capi_global_qbx_centers_tmp = array_from_pyobj(NPY_INT,global_qbx_centers_Dims,global_qbx_centers_Rank,capi_global_qbx_centers_intent,global_qbx_centers_capi);
  if (capi_global_qbx_centers_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `global_qbx_centers' of _internal.l3dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    global_qbx_centers = (int *)(PyArray_DATA(capi_global_qbx_centers_tmp));

  /* Processing variable qbx_centers */
  qbx_centers_Dims[1]=3;
  capi_qbx_centers_intent |= F2PY_INTENT_IN;
  capi_qbx_centers_tmp = array_from_pyobj(NPY_DOUBLE,qbx_centers_Dims,qbx_centers_Rank,capi_qbx_centers_intent,qbx_centers_capi);
  if (capi_qbx_centers_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `qbx_centers' of _internal.l3dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    qbx_centers = (double *)(PyArray_DATA(capi_qbx_centers_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.l3dformta_dp_qbx() 8th argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable source_box_starts */
  ;
  capi_source_box_starts_intent |= F2PY_INTENT_IN;
  capi_source_box_starts_tmp = array_from_pyobj(NPY_INT,source_box_starts_Dims,source_box_starts_Rank,capi_source_box_starts_intent,source_box_starts_capi);
  if (capi_source_box_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 9th argument `source_box_starts' of _internal.l3dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source_box_starts = (int *)(PyArray_DATA(capi_source_box_starts_tmp));

  /* Processing variable source_box_lists */
  ;
  capi_source_box_lists_intent |= F2PY_INTENT_IN;
  capi_source_box_lists_tmp = array_from_pyobj(NPY_INT,source_box_lists_Dims,source_box_lists_Rank,capi_source_box_lists_intent,source_box_lists_capi);
  if (capi_source_box_lists_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 10th argument `source_box_lists' of _internal.l3dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source_box_lists = (int *)(PyArray_DATA(capi_source_box_lists_tmp));

  /* Processing variable box_source_starts */
  ;
  capi_box_source_starts_intent |= F2PY_INTENT_IN;
  capi_box_source_starts_tmp = array_from_pyobj(NPY_INT,box_source_starts_Dims,box_source_starts_Rank,capi_box_source_starts_intent,box_source_starts_capi);
  if (capi_box_source_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 11st argument `box_source_starts' of _internal.l3dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    box_source_starts = (int *)(PyArray_DATA(capi_box_source_starts_tmp));

  /* Processing variable box_source_counts_nonchild */
  ;
  capi_box_source_counts_nonchild_intent |= F2PY_INTENT_IN;
  capi_box_source_counts_nonchild_tmp = array_from_pyobj(NPY_INT,box_source_counts_nonchild_Dims,box_source_counts_nonchild_Rank,capi_box_source_counts_nonchild_intent,box_source_counts_nonchild_capi);
  if (capi_box_source_counts_nonchild_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 12nd argument `box_source_counts_nonchild' of _internal.l3dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    box_source_counts_nonchild = (int *)(PyArray_DATA(capi_box_source_counts_nonchild_tmp));

  /* Processing variable nsources */
  if (nsources_capi == Py_None) nsources = shape(sources,1); else
    f2py_success = int_from_pyobj(&nsources,nsources_capi,"_internal.l3dformta_dp_qbx() 1st keyword (nsources) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(sources,1)==nsources,"shape(sources,1)==nsources","1st keyword nsources","l3dformta_dp_qbx:nsources=%d",nsources) {
  /* Processing variable ntgt_centers */
  if (ntgt_centers_capi == Py_None) ntgt_centers = len(global_qbx_centers); else
    f2py_success = int_from_pyobj(&ntgt_centers,ntgt_centers_capi,"_internal.l3dformta_dp_qbx() 2nd keyword (ntgt_centers) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(global_qbx_centers)>=ntgt_centers,"len(global_qbx_centers)>=ntgt_centers","2nd keyword ntgt_centers","l3dformta_dp_qbx:ntgt_centers=%d",ntgt_centers) {
  /* Processing variable nqbx_centers */
  if (nqbx_centers_capi == Py_None) nqbx_centers = shape(qbx_centers,0); else
    f2py_success = int_from_pyobj(&nqbx_centers,nqbx_centers_capi,"_internal.l3dformta_dp_qbx() 3rd keyword (nqbx_centers) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(qbx_centers,0)==nqbx_centers,"shape(qbx_centers,0)==nqbx_centers","3rd keyword nqbx_centers","l3dformta_dp_qbx:nqbx_centers=%d",nqbx_centers) {
  /* Processing variable qbx_expansion_radii */
  qbx_expansion_radii_Dims[0]=nqbx_centers;
  capi_qbx_expansion_radii_intent |= F2PY_INTENT_IN;
  capi_qbx_expansion_radii_tmp = array_from_pyobj(NPY_DOUBLE,qbx_expansion_radii_Dims,qbx_expansion_radii_Rank,capi_qbx_expansion_radii_intent,qbx_expansion_radii_capi);
  if (capi_qbx_expansion_radii_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `qbx_expansion_radii' of _internal.l3dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    qbx_expansion_radii = (double *)(PyArray_DATA(capi_qbx_expansion_radii_tmp));

  /* Processing variable qbx_center_to_target_box */
  qbx_center_to_target_box_Dims[0]=nqbx_centers;
  capi_qbx_center_to_target_box_intent |= F2PY_INTENT_IN;
  capi_qbx_center_to_target_box_tmp = array_from_pyobj(NPY_INT,qbx_center_to_target_box_Dims,qbx_center_to_target_box_Rank,capi_qbx_center_to_target_box_intent,qbx_center_to_target_box_capi);
  if (capi_qbx_center_to_target_box_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 7th argument `qbx_center_to_target_box' of _internal.l3dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    qbx_center_to_target_box = (int *)(PyArray_DATA(capi_qbx_center_to_target_box_tmp));

  /* Processing variable expn */
  expn_Dims[0]=nterms + 1,expn_Dims[1]=2 * nterms + 1,expn_Dims[2]=nqbx_centers;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.l3dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ier,&nsources,sources,dipstr,dipvec,&ntgt_centers,&nqbx_centers,qbx_centers,global_qbx_centers,qbx_expansion_radii,qbx_center_to_target_box,&nterms,source_box_starts,source_box_lists,box_source_starts,box_source_counts_nonchild,expn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("iN",ier,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  if((PyObject *)capi_qbx_center_to_target_box_tmp!=qbx_center_to_target_box_capi) {
    Py_XDECREF(capi_qbx_center_to_target_box_tmp); }
  }  /*if (capi_qbx_center_to_target_box_tmp == NULL) ... else of qbx_center_to_target_box*/
  /* End of cleaning variable qbx_center_to_target_box */
  if((PyObject *)capi_qbx_expansion_radii_tmp!=qbx_expansion_radii_capi) {
    Py_XDECREF(capi_qbx_expansion_radii_tmp); }
  }  /*if (capi_qbx_expansion_radii_tmp == NULL) ... else of qbx_expansion_radii*/
  /* End of cleaning variable qbx_expansion_radii */
  } /*CHECKSCALAR(shape(qbx_centers,0)==nqbx_centers)*/
  } /*if (f2py_success) of nqbx_centers*/
  /* End of cleaning variable nqbx_centers */
  } /*CHECKSCALAR(len(global_qbx_centers)>=ntgt_centers)*/
  } /*if (f2py_success) of ntgt_centers*/
  /* End of cleaning variable ntgt_centers */
  } /*CHECKSCALAR(shape(sources,1)==nsources)*/
  } /*if (f2py_success) of nsources*/
  /* End of cleaning variable nsources */
  if((PyObject *)capi_box_source_counts_nonchild_tmp!=box_source_counts_nonchild_capi) {
    Py_XDECREF(capi_box_source_counts_nonchild_tmp); }
  }  /*if (capi_box_source_counts_nonchild_tmp == NULL) ... else of box_source_counts_nonchild*/
  /* End of cleaning variable box_source_counts_nonchild */
  if((PyObject *)capi_box_source_starts_tmp!=box_source_starts_capi) {
    Py_XDECREF(capi_box_source_starts_tmp); }
  }  /*if (capi_box_source_starts_tmp == NULL) ... else of box_source_starts*/
  /* End of cleaning variable box_source_starts */
  if((PyObject *)capi_source_box_lists_tmp!=source_box_lists_capi) {
    Py_XDECREF(capi_source_box_lists_tmp); }
  }  /*if (capi_source_box_lists_tmp == NULL) ... else of source_box_lists*/
  /* End of cleaning variable source_box_lists */
  if((PyObject *)capi_source_box_starts_tmp!=source_box_starts_capi) {
    Py_XDECREF(capi_source_box_starts_tmp); }
  }  /*if (capi_source_box_starts_tmp == NULL) ... else of source_box_starts*/
  /* End of cleaning variable source_box_starts */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_qbx_centers_tmp!=qbx_centers_capi) {
    Py_XDECREF(capi_qbx_centers_tmp); }
  }  /*if (capi_qbx_centers_tmp == NULL) ... else of qbx_centers*/
  /* End of cleaning variable qbx_centers */
  if((PyObject *)capi_global_qbx_centers_tmp!=global_qbx_centers_capi) {
    Py_XDECREF(capi_global_qbx_centers_tmp); }
  }  /*if (capi_global_qbx_centers_tmp == NULL) ... else of global_qbx_centers*/
  /* End of cleaning variable global_qbx_centers */
  if((PyObject *)capi_dipvec_tmp!=dipvec_capi) {
    Py_XDECREF(capi_dipvec_tmp); }
  }  /*if (capi_dipvec_tmp == NULL) ... else of dipvec*/
  /* End of cleaning variable dipvec */
  if((PyObject *)capi_dipstr_tmp!=dipstr_capi) {
    Py_XDECREF(capi_dipstr_tmp); }
  }  /*if (capi_dipstr_tmp == NULL) ... else of dipstr*/
  /* End of cleaning variable dipstr */
  if((PyObject *)capi_sources_tmp!=sources_capi) {
    Py_XDECREF(capi_sources_tmp); }
  }  /*if (capi_sources_tmp == NULL) ... else of sources*/
  /* End of cleaning variable sources */
  /* End of cleaning variable ier */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/************************** end of l3dformta_dp_qbx **************************/

/****************************** h3dformta_dp_qbx ******************************/
static char doc_f2py_rout__internal_h3dformta_dp_qbx[] = "\
ier,expn = h3dformta_dp_qbx(zk,sources,dipstr,dipvec,qbx_centers,global_qbx_centers,qbx_expansion_radii,qbx_center_to_target_box,nterms,source_box_starts,source_box_lists,box_source_starts,box_source_counts_nonchild,[nsources,ntgt_centers,nqbx_centers])\n\nWrapper for ``h3dformta_dp_qbx``.\
\n\nParameters\n----------\n"
"zk : input complex\n"
"sources : input rank-2 array('d') with bounds (3,nsources)\n"
"dipstr : input rank-1 array('D') with bounds (*)\n"
"dipvec : input rank-2 array('d') with bounds (3,*)\n"
"qbx_centers : input rank-2 array('d') with bounds (nqbx_centers,3)\n"
"global_qbx_centers : input rank-1 array('i') with bounds (ntgt_centers)\n"
"qbx_expansion_radii : input rank-1 array('d') with bounds (nqbx_centers)\n"
"qbx_center_to_target_box : input rank-1 array('i') with bounds (nqbx_centers)\n"
"nterms : input int\n"
"source_box_starts : input rank-1 array('i') with bounds (*)\n"
"source_box_lists : input rank-1 array('i') with bounds (*)\n"
"box_source_starts : input rank-1 array('i') with bounds (*)\n"
"box_source_counts_nonchild : input rank-1 array('i') with bounds (*)\n"
"\nOther Parameters\n----------------\n"
"nsources : input int, optional\n    Default: shape(sources,1)\n"
"ntgt_centers : input int, optional\n    Default: len(global_qbx_centers)\n"
"nqbx_centers : input int, optional\n    Default: shape(qbx_centers,0)\n"
"\nReturns\n-------\n"
"ier : int\n"
"expn : rank-3 array('D') with bounds (nterms + 1,2 * nterms + 1,nqbx_centers)";
/* extern void F_FUNC_US(h3dformta_dp_qbx,H3DFORMTA_DP_QBX)(int*,complex_double*,int*,double*,complex_double*,double*,int*,int*,double*,int*,double*,int*,int*,int*,int*,int*,int*,complex_double*); */
static PyObject *f2py_rout__internal_h3dformta_dp_qbx(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,complex_double*,int*,double*,complex_double*,double*,int*,int*,double*,int*,double*,int*,int*,int*,int*,int*,int*,complex_double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ier = 0;
  complex_double zk;
  PyObject *zk_capi = Py_None;
  int nsources = 0;
  PyObject *nsources_capi = Py_None;
  double *sources = NULL;
  npy_intp sources_Dims[2] = {-1, -1};
  const int sources_Rank = 2;
  PyArrayObject *capi_sources_tmp = NULL;
  int capi_sources_intent = 0;
  PyObject *sources_capi = Py_None;
  complex_double *dipstr = NULL;
  npy_intp dipstr_Dims[1] = {-1};
  const int dipstr_Rank = 1;
  PyArrayObject *capi_dipstr_tmp = NULL;
  int capi_dipstr_intent = 0;
  PyObject *dipstr_capi = Py_None;
  double *dipvec = NULL;
  npy_intp dipvec_Dims[2] = {-1, -1};
  const int dipvec_Rank = 2;
  PyArrayObject *capi_dipvec_tmp = NULL;
  int capi_dipvec_intent = 0;
  PyObject *dipvec_capi = Py_None;
  int ntgt_centers = 0;
  PyObject *ntgt_centers_capi = Py_None;
  int nqbx_centers = 0;
  PyObject *nqbx_centers_capi = Py_None;
  double *qbx_centers = NULL;
  npy_intp qbx_centers_Dims[2] = {-1, -1};
  const int qbx_centers_Rank = 2;
  PyArrayObject *capi_qbx_centers_tmp = NULL;
  int capi_qbx_centers_intent = 0;
  PyObject *qbx_centers_capi = Py_None;
  int *global_qbx_centers = NULL;
  npy_intp global_qbx_centers_Dims[1] = {-1};
  const int global_qbx_centers_Rank = 1;
  PyArrayObject *capi_global_qbx_centers_tmp = NULL;
  int capi_global_qbx_centers_intent = 0;
  PyObject *global_qbx_centers_capi = Py_None;
  double *qbx_expansion_radii = NULL;
  npy_intp qbx_expansion_radii_Dims[1] = {-1};
  const int qbx_expansion_radii_Rank = 1;
  PyArrayObject *capi_qbx_expansion_radii_tmp = NULL;
  int capi_qbx_expansion_radii_intent = 0;
  PyObject *qbx_expansion_radii_capi = Py_None;
  int *qbx_center_to_target_box = NULL;
  npy_intp qbx_center_to_target_box_Dims[1] = {-1};
  const int qbx_center_to_target_box_Rank = 1;
  PyArrayObject *capi_qbx_center_to_target_box_tmp = NULL;
  int capi_qbx_center_to_target_box_intent = 0;
  PyObject *qbx_center_to_target_box_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  int *source_box_starts = NULL;
  npy_intp source_box_starts_Dims[1] = {-1};
  const int source_box_starts_Rank = 1;
  PyArrayObject *capi_source_box_starts_tmp = NULL;
  int capi_source_box_starts_intent = 0;
  PyObject *source_box_starts_capi = Py_None;
  int *source_box_lists = NULL;
  npy_intp source_box_lists_Dims[1] = {-1};
  const int source_box_lists_Rank = 1;
  PyArrayObject *capi_source_box_lists_tmp = NULL;
  int capi_source_box_lists_intent = 0;
  PyObject *source_box_lists_capi = Py_None;
  int *box_source_starts = NULL;
  npy_intp box_source_starts_Dims[1] = {-1};
  const int box_source_starts_Rank = 1;
  PyArrayObject *capi_box_source_starts_tmp = NULL;
  int capi_box_source_starts_intent = 0;
  PyObject *box_source_starts_capi = Py_None;
  int *box_source_counts_nonchild = NULL;
  npy_intp box_source_counts_nonchild_Dims[1] = {-1};
  const int box_source_counts_nonchild_Rank = 1;
  PyArrayObject *capi_box_source_counts_nonchild_tmp = NULL;
  int capi_box_source_counts_nonchild_intent = 0;
  PyObject *box_source_counts_nonchild_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[3] = {-1, -1, -1};
  const int expn_Rank = 3;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
    static char *capi_kwlist[] = {"zk","sources","dipstr","dipvec","qbx_centers","global_qbx_centers","qbx_expansion_radii","qbx_center_to_target_box","nterms","source_box_starts","source_box_lists","box_source_starts","box_source_counts_nonchild","nsources","ntgt_centers","nqbx_centers",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOOOOO|OOO:_internal.h3dformta_dp_qbx",\
        capi_kwlist,&zk_capi,&sources_capi,&dipstr_capi,&dipvec_capi,&qbx_centers_capi,&global_qbx_centers_capi,&qbx_expansion_radii_capi,&qbx_center_to_target_box_capi,&nterms_capi,&source_box_starts_capi,&source_box_lists_capi,&box_source_starts_capi,&box_source_counts_nonchild_capi,&nsources_capi,&ntgt_centers_capi,&nqbx_centers_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable ier */
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.h3dformta_dp_qbx() 1st argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable sources */
  sources_Dims[0]=3;
  capi_sources_intent |= F2PY_INTENT_IN;
  capi_sources_tmp = array_from_pyobj(NPY_DOUBLE,sources_Dims,sources_Rank,capi_sources_intent,sources_capi);
  if (capi_sources_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `sources' of _internal.h3dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sources = (double *)(PyArray_DATA(capi_sources_tmp));

  /* Processing variable dipstr */
  ;
  capi_dipstr_intent |= F2PY_INTENT_IN;
  capi_dipstr_tmp = array_from_pyobj(NPY_CDOUBLE,dipstr_Dims,dipstr_Rank,capi_dipstr_intent,dipstr_capi);
  if (capi_dipstr_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `dipstr' of _internal.h3dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipstr = (complex_double *)(PyArray_DATA(capi_dipstr_tmp));

  /* Processing variable dipvec */
  dipvec_Dims[0]=3;
  capi_dipvec_intent |= F2PY_INTENT_IN;
  capi_dipvec_tmp = array_from_pyobj(NPY_DOUBLE,dipvec_Dims,dipvec_Rank,capi_dipvec_intent,dipvec_capi);
  if (capi_dipvec_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `dipvec' of _internal.h3dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dipvec = (double *)(PyArray_DATA(capi_dipvec_tmp));

  /* Processing variable global_qbx_centers */
  ;
  capi_global_qbx_centers_intent |= F2PY_INTENT_IN;
  capi_global_qbx_centers_tmp = array_from_pyobj(NPY_INT,global_qbx_centers_Dims,global_qbx_centers_Rank,capi_global_qbx_centers_intent,global_qbx_centers_capi);
  if (capi_global_qbx_centers_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `global_qbx_centers' of _internal.h3dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    global_qbx_centers = (int *)(PyArray_DATA(capi_global_qbx_centers_tmp));

  /* Processing variable qbx_centers */
  qbx_centers_Dims[1]=3;
  capi_qbx_centers_intent |= F2PY_INTENT_IN;
  capi_qbx_centers_tmp = array_from_pyobj(NPY_DOUBLE,qbx_centers_Dims,qbx_centers_Rank,capi_qbx_centers_intent,qbx_centers_capi);
  if (capi_qbx_centers_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `qbx_centers' of _internal.h3dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    qbx_centers = (double *)(PyArray_DATA(capi_qbx_centers_tmp));

  /* Processing variable nterms */
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.h3dformta_dp_qbx() 9th argument (nterms) can't be converted to int");
  if (f2py_success) {
  /* Processing variable source_box_starts */
  ;
  capi_source_box_starts_intent |= F2PY_INTENT_IN;
  capi_source_box_starts_tmp = array_from_pyobj(NPY_INT,source_box_starts_Dims,source_box_starts_Rank,capi_source_box_starts_intent,source_box_starts_capi);
  if (capi_source_box_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 10th argument `source_box_starts' of _internal.h3dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source_box_starts = (int *)(PyArray_DATA(capi_source_box_starts_tmp));

  /* Processing variable source_box_lists */
  ;
  capi_source_box_lists_intent |= F2PY_INTENT_IN;
  capi_source_box_lists_tmp = array_from_pyobj(NPY_INT,source_box_lists_Dims,source_box_lists_Rank,capi_source_box_lists_intent,source_box_lists_capi);
  if (capi_source_box_lists_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 11st argument `source_box_lists' of _internal.h3dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    source_box_lists = (int *)(PyArray_DATA(capi_source_box_lists_tmp));

  /* Processing variable box_source_starts */
  ;
  capi_box_source_starts_intent |= F2PY_INTENT_IN;
  capi_box_source_starts_tmp = array_from_pyobj(NPY_INT,box_source_starts_Dims,box_source_starts_Rank,capi_box_source_starts_intent,box_source_starts_capi);
  if (capi_box_source_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 12nd argument `box_source_starts' of _internal.h3dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    box_source_starts = (int *)(PyArray_DATA(capi_box_source_starts_tmp));

  /* Processing variable box_source_counts_nonchild */
  ;
  capi_box_source_counts_nonchild_intent |= F2PY_INTENT_IN;
  capi_box_source_counts_nonchild_tmp = array_from_pyobj(NPY_INT,box_source_counts_nonchild_Dims,box_source_counts_nonchild_Rank,capi_box_source_counts_nonchild_intent,box_source_counts_nonchild_capi);
  if (capi_box_source_counts_nonchild_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 13rd argument `box_source_counts_nonchild' of _internal.h3dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    box_source_counts_nonchild = (int *)(PyArray_DATA(capi_box_source_counts_nonchild_tmp));

  /* Processing variable nsources */
  if (nsources_capi == Py_None) nsources = shape(sources,1); else
    f2py_success = int_from_pyobj(&nsources,nsources_capi,"_internal.h3dformta_dp_qbx() 1st keyword (nsources) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(sources,1)==nsources,"shape(sources,1)==nsources","1st keyword nsources","h3dformta_dp_qbx:nsources=%d",nsources) {
  /* Processing variable ntgt_centers */
  if (ntgt_centers_capi == Py_None) ntgt_centers = len(global_qbx_centers); else
    f2py_success = int_from_pyobj(&ntgt_centers,ntgt_centers_capi,"_internal.h3dformta_dp_qbx() 2nd keyword (ntgt_centers) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(global_qbx_centers)>=ntgt_centers,"len(global_qbx_centers)>=ntgt_centers","2nd keyword ntgt_centers","h3dformta_dp_qbx:ntgt_centers=%d",ntgt_centers) {
  /* Processing variable nqbx_centers */
  if (nqbx_centers_capi == Py_None) nqbx_centers = shape(qbx_centers,0); else
    f2py_success = int_from_pyobj(&nqbx_centers,nqbx_centers_capi,"_internal.h3dformta_dp_qbx() 3rd keyword (nqbx_centers) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(qbx_centers,0)==nqbx_centers,"shape(qbx_centers,0)==nqbx_centers","3rd keyword nqbx_centers","h3dformta_dp_qbx:nqbx_centers=%d",nqbx_centers) {
  /* Processing variable qbx_expansion_radii */
  qbx_expansion_radii_Dims[0]=nqbx_centers;
  capi_qbx_expansion_radii_intent |= F2PY_INTENT_IN;
  capi_qbx_expansion_radii_tmp = array_from_pyobj(NPY_DOUBLE,qbx_expansion_radii_Dims,qbx_expansion_radii_Rank,capi_qbx_expansion_radii_intent,qbx_expansion_radii_capi);
  if (capi_qbx_expansion_radii_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 7th argument `qbx_expansion_radii' of _internal.h3dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    qbx_expansion_radii = (double *)(PyArray_DATA(capi_qbx_expansion_radii_tmp));

  /* Processing variable qbx_center_to_target_box */
  qbx_center_to_target_box_Dims[0]=nqbx_centers;
  capi_qbx_center_to_target_box_intent |= F2PY_INTENT_IN;
  capi_qbx_center_to_target_box_tmp = array_from_pyobj(NPY_INT,qbx_center_to_target_box_Dims,qbx_center_to_target_box_Rank,capi_qbx_center_to_target_box_intent,qbx_center_to_target_box_capi);
  if (capi_qbx_center_to_target_box_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 8th argument `qbx_center_to_target_box' of _internal.h3dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    qbx_center_to_target_box = (int *)(PyArray_DATA(capi_qbx_center_to_target_box_tmp));

  /* Processing variable expn */
  expn_Dims[0]=nterms + 1,expn_Dims[1]=2 * nterms + 1,expn_Dims[2]=nqbx_centers;
  capi_expn_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,Py_None);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn' of _internal.h3dformta_dp_qbx to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ier,&zk,&nsources,sources,dipstr,dipvec,&ntgt_centers,&nqbx_centers,qbx_centers,global_qbx_centers,qbx_expansion_radii,qbx_center_to_target_box,&nterms,source_box_starts,source_box_lists,box_source_starts,box_source_counts_nonchild,expn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("iN",ier,capi_expn_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  if((PyObject *)capi_qbx_center_to_target_box_tmp!=qbx_center_to_target_box_capi) {
    Py_XDECREF(capi_qbx_center_to_target_box_tmp); }
  }  /*if (capi_qbx_center_to_target_box_tmp == NULL) ... else of qbx_center_to_target_box*/
  /* End of cleaning variable qbx_center_to_target_box */
  if((PyObject *)capi_qbx_expansion_radii_tmp!=qbx_expansion_radii_capi) {
    Py_XDECREF(capi_qbx_expansion_radii_tmp); }
  }  /*if (capi_qbx_expansion_radii_tmp == NULL) ... else of qbx_expansion_radii*/
  /* End of cleaning variable qbx_expansion_radii */
  } /*CHECKSCALAR(shape(qbx_centers,0)==nqbx_centers)*/
  } /*if (f2py_success) of nqbx_centers*/
  /* End of cleaning variable nqbx_centers */
  } /*CHECKSCALAR(len(global_qbx_centers)>=ntgt_centers)*/
  } /*if (f2py_success) of ntgt_centers*/
  /* End of cleaning variable ntgt_centers */
  } /*CHECKSCALAR(shape(sources,1)==nsources)*/
  } /*if (f2py_success) of nsources*/
  /* End of cleaning variable nsources */
  if((PyObject *)capi_box_source_counts_nonchild_tmp!=box_source_counts_nonchild_capi) {
    Py_XDECREF(capi_box_source_counts_nonchild_tmp); }
  }  /*if (capi_box_source_counts_nonchild_tmp == NULL) ... else of box_source_counts_nonchild*/
  /* End of cleaning variable box_source_counts_nonchild */
  if((PyObject *)capi_box_source_starts_tmp!=box_source_starts_capi) {
    Py_XDECREF(capi_box_source_starts_tmp); }
  }  /*if (capi_box_source_starts_tmp == NULL) ... else of box_source_starts*/
  /* End of cleaning variable box_source_starts */
  if((PyObject *)capi_source_box_lists_tmp!=source_box_lists_capi) {
    Py_XDECREF(capi_source_box_lists_tmp); }
  }  /*if (capi_source_box_lists_tmp == NULL) ... else of source_box_lists*/
  /* End of cleaning variable source_box_lists */
  if((PyObject *)capi_source_box_starts_tmp!=source_box_starts_capi) {
    Py_XDECREF(capi_source_box_starts_tmp); }
  }  /*if (capi_source_box_starts_tmp == NULL) ... else of source_box_starts*/
  /* End of cleaning variable source_box_starts */
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_qbx_centers_tmp!=qbx_centers_capi) {
    Py_XDECREF(capi_qbx_centers_tmp); }
  }  /*if (capi_qbx_centers_tmp == NULL) ... else of qbx_centers*/
  /* End of cleaning variable qbx_centers */
  if((PyObject *)capi_global_qbx_centers_tmp!=global_qbx_centers_capi) {
    Py_XDECREF(capi_global_qbx_centers_tmp); }
  }  /*if (capi_global_qbx_centers_tmp == NULL) ... else of global_qbx_centers*/
  /* End of cleaning variable global_qbx_centers */
  if((PyObject *)capi_dipvec_tmp!=dipvec_capi) {
    Py_XDECREF(capi_dipvec_tmp); }
  }  /*if (capi_dipvec_tmp == NULL) ... else of dipvec*/
  /* End of cleaning variable dipvec */
  if((PyObject *)capi_dipstr_tmp!=dipstr_capi) {
    Py_XDECREF(capi_dipstr_tmp); }
  }  /*if (capi_dipstr_tmp == NULL) ... else of dipstr*/
  /* End of cleaning variable dipstr */
  if((PyObject *)capi_sources_tmp!=sources_capi) {
    Py_XDECREF(capi_sources_tmp); }
  }  /*if (capi_sources_tmp == NULL) ... else of sources*/
  /* End of cleaning variable sources */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
  /* End of cleaning variable ier */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/************************** end of h3dformta_dp_qbx **************************/

/******************************* l3dtaeval_vec *******************************/
static char doc_f2py_rout__internal_l3dtaeval_vec[] = "\
pot,fld,ier = l3dtaeval_vec(rscale,center,expn,ztarg,iffld,[nterms,nvcount])\n\nWrapper for ``l3dtaeval_vec``.\
\n\nParameters\n----------\n"
"rscale : input float\n"
"center : input rank-1 array('d') with bounds (3)\n"
"expn : input rank-2 array('D') with bounds (nterms + 1,2 * nterms + 1)\n"
"ztarg : input rank-2 array('d') with bounds (3,nvcount)\n"
"iffld : input int\n"
"\nOther Parameters\n----------------\n"
"nterms : input int, optional\n    Default: (shape(expn,0)-1)\n"
"nvcount : input int, optional\n    Default: shape(ztarg,1)\n"
"\nReturns\n-------\n"
"pot : rank-1 array('D') with bounds (nvcount)\n"
"fld : rank-2 array('D') with bounds (3,nvcount)\n"
"ier : rank-1 array('i') with bounds (nvcount)";
/* extern void F_FUNC_US(l3dtaeval_vec,L3DTAEVAL_VEC)(double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,int*); */
static PyObject *f2py_rout__internal_l3dtaeval_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *center = NULL;
  npy_intp center_Dims[1] = {-1};
  const int center_Rank = 1;
  PyArrayObject *capi_center_tmp = NULL;
  int capi_center_intent = 0;
  PyObject *center_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[2] = {-1, -1};
  const int expn_Rank = 2;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
  PyObject *expn_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  double *ztarg = NULL;
  npy_intp ztarg_Dims[2] = {-1, -1};
  const int ztarg_Rank = 2;
  PyArrayObject *capi_ztarg_tmp = NULL;
  int capi_ztarg_intent = 0;
  PyObject *ztarg_capi = Py_None;
  complex_double *pot = NULL;
  npy_intp pot_Dims[1] = {-1};
  const int pot_Rank = 1;
  PyArrayObject *capi_pot_tmp = NULL;
  int capi_pot_intent = 0;
  int iffld = 0;
  PyObject *iffld_capi = Py_None;
  complex_double *fld = NULL;
  npy_intp fld_Dims[2] = {-1, -1};
  const int fld_Rank = 2;
  PyArrayObject *capi_fld_tmp = NULL;
  int capi_fld_intent = 0;
  int *ier = NULL;
  npy_intp ier_Dims[1] = {-1};
  const int ier_Rank = 1;
  PyArrayObject *capi_ier_tmp = NULL;
  int capi_ier_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"rscale","center","expn","ztarg","iffld","nterms","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOO|OO:_internal.l3dtaeval_vec",\
        capi_kwlist,&rscale_capi,&center_capi,&expn_capi,&ztarg_capi,&iffld_capi,&nterms_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.l3dtaeval_vec() 1st argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable center */
  center_Dims[0]=3;
  capi_center_intent |= F2PY_INTENT_IN;
  capi_center_tmp = array_from_pyobj(NPY_DOUBLE,center_Dims,center_Rank,capi_center_intent,center_capi);
  if (capi_center_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `center' of _internal.l3dtaeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center = (double *)(PyArray_DATA(capi_center_tmp));

  /* Processing variable expn */
  ;
  capi_expn_intent |= F2PY_INTENT_IN;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,expn_capi);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `expn' of _internal.l3dtaeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

  /* Processing variable ztarg */
  ztarg_Dims[0]=3;
  capi_ztarg_intent |= F2PY_INTENT_IN;
  capi_ztarg_tmp = array_from_pyobj(NPY_DOUBLE,ztarg_Dims,ztarg_Rank,capi_ztarg_intent,ztarg_capi);
  if (capi_ztarg_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `ztarg' of _internal.l3dtaeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ztarg = (double *)(PyArray_DATA(capi_ztarg_tmp));

  /* Processing variable iffld */
    f2py_success = int_from_pyobj(&iffld,iffld_capi,"_internal.l3dtaeval_vec() 5th argument (iffld) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = shape(ztarg,1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.l3dtaeval_vec() 2nd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(ztarg,1)==nvcount,"shape(ztarg,1)==nvcount","2nd keyword nvcount","l3dtaeval_vec:nvcount=%d",nvcount) {
  /* Processing variable nterms */
  if (nterms_capi == Py_None) nterms = (shape(expn,0)-1); else
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.l3dtaeval_vec() 1st keyword (nterms) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((shape(expn,0)-1)==nterms,"(shape(expn,0)-1)==nterms","1st keyword nterms","l3dtaeval_vec:nterms=%d",nterms) {
  /* Processing variable pot */
  pot_Dims[0]=nvcount;
  capi_pot_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_pot_tmp = array_from_pyobj(NPY_CDOUBLE,pot_Dims,pot_Rank,capi_pot_intent,Py_None);
  if (capi_pot_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `pot' of _internal.l3dtaeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    pot = (complex_double *)(PyArray_DATA(capi_pot_tmp));

  /* Processing variable fld */
  fld_Dims[0]=3,fld_Dims[1]=nvcount;
  capi_fld_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_fld_tmp = array_from_pyobj(NPY_CDOUBLE,fld_Dims,fld_Rank,capi_fld_intent,Py_None);
  if (capi_fld_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `fld' of _internal.l3dtaeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    fld = (complex_double *)(PyArray_DATA(capi_fld_tmp));

  /* Processing variable ier */
  ier_Dims[0]=nvcount;
  capi_ier_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_ier_tmp = array_from_pyobj(NPY_INT,ier_Dims,ier_Rank,capi_ier_intent,Py_None);
  if (capi_ier_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `ier' of _internal.l3dtaeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ier = (int *)(PyArray_DATA(capi_ier_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&rscale,center,expn,&nterms,ztarg,pot,&iffld,fld,ier,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NNN",capi_pot_tmp,capi_fld_tmp,capi_ier_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_ier_tmp == NULL) ... else of ier*/
  /* End of cleaning variable ier */
  }  /*if (capi_fld_tmp == NULL) ... else of fld*/
  /* End of cleaning variable fld */
  }  /*if (capi_pot_tmp == NULL) ... else of pot*/
  /* End of cleaning variable pot */
  } /*CHECKSCALAR((shape(expn,0)-1)==nterms)*/
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  } /*CHECKSCALAR(shape(ztarg,1)==nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  } /*if (f2py_success) of iffld*/
  /* End of cleaning variable iffld */
  if((PyObject *)capi_ztarg_tmp!=ztarg_capi) {
    Py_XDECREF(capi_ztarg_tmp); }
  }  /*if (capi_ztarg_tmp == NULL) ... else of ztarg*/
  /* End of cleaning variable ztarg */
  if((PyObject *)capi_expn_tmp!=expn_capi) {
    Py_XDECREF(capi_expn_tmp); }
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  if((PyObject *)capi_center_tmp!=center_capi) {
    Py_XDECREF(capi_center_tmp); }
  }  /*if (capi_center_tmp == NULL) ... else of center*/
  /* End of cleaning variable center */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/**************************** end of l3dtaeval_vec ****************************/

/******************************* l3dmpeval_vec *******************************/
static char doc_f2py_rout__internal_l3dmpeval_vec[] = "\
pot,fld,ier = l3dmpeval_vec(rscale,center,expn,ztarg,iffld,[nterms,nvcount])\n\nWrapper for ``l3dmpeval_vec``.\
\n\nParameters\n----------\n"
"rscale : input float\n"
"center : input rank-1 array('d') with bounds (3)\n"
"expn : input rank-2 array('D') with bounds (nterms + 1,2 * nterms + 1)\n"
"ztarg : input rank-2 array('d') with bounds (3,nvcount)\n"
"iffld : input int\n"
"\nOther Parameters\n----------------\n"
"nterms : input int, optional\n    Default: (shape(expn,0)-1)\n"
"nvcount : input int, optional\n    Default: shape(ztarg,1)\n"
"\nReturns\n-------\n"
"pot : rank-1 array('D') with bounds (nvcount)\n"
"fld : rank-2 array('D') with bounds (3,nvcount)\n"
"ier : rank-1 array('i') with bounds (nvcount)";
/* extern void F_FUNC_US(l3dmpeval_vec,L3DMPEVAL_VEC)(double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,int*); */
static PyObject *f2py_rout__internal_l3dmpeval_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *center = NULL;
  npy_intp center_Dims[1] = {-1};
  const int center_Rank = 1;
  PyArrayObject *capi_center_tmp = NULL;
  int capi_center_intent = 0;
  PyObject *center_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[2] = {-1, -1};
  const int expn_Rank = 2;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
  PyObject *expn_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  double *ztarg = NULL;
  npy_intp ztarg_Dims[2] = {-1, -1};
  const int ztarg_Rank = 2;
  PyArrayObject *capi_ztarg_tmp = NULL;
  int capi_ztarg_intent = 0;
  PyObject *ztarg_capi = Py_None;
  complex_double *pot = NULL;
  npy_intp pot_Dims[1] = {-1};
  const int pot_Rank = 1;
  PyArrayObject *capi_pot_tmp = NULL;
  int capi_pot_intent = 0;
  int iffld = 0;
  PyObject *iffld_capi = Py_None;
  complex_double *fld = NULL;
  npy_intp fld_Dims[2] = {-1, -1};
  const int fld_Rank = 2;
  PyArrayObject *capi_fld_tmp = NULL;
  int capi_fld_intent = 0;
  int *ier = NULL;
  npy_intp ier_Dims[1] = {-1};
  const int ier_Rank = 1;
  PyArrayObject *capi_ier_tmp = NULL;
  int capi_ier_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"rscale","center","expn","ztarg","iffld","nterms","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOO|OO:_internal.l3dmpeval_vec",\
        capi_kwlist,&rscale_capi,&center_capi,&expn_capi,&ztarg_capi,&iffld_capi,&nterms_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.l3dmpeval_vec() 1st argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable center */
  center_Dims[0]=3;
  capi_center_intent |= F2PY_INTENT_IN;
  capi_center_tmp = array_from_pyobj(NPY_DOUBLE,center_Dims,center_Rank,capi_center_intent,center_capi);
  if (capi_center_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `center' of _internal.l3dmpeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center = (double *)(PyArray_DATA(capi_center_tmp));

  /* Processing variable expn */
  ;
  capi_expn_intent |= F2PY_INTENT_IN;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,expn_capi);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `expn' of _internal.l3dmpeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

  /* Processing variable ztarg */
  ztarg_Dims[0]=3;
  capi_ztarg_intent |= F2PY_INTENT_IN;
  capi_ztarg_tmp = array_from_pyobj(NPY_DOUBLE,ztarg_Dims,ztarg_Rank,capi_ztarg_intent,ztarg_capi);
  if (capi_ztarg_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `ztarg' of _internal.l3dmpeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ztarg = (double *)(PyArray_DATA(capi_ztarg_tmp));

  /* Processing variable iffld */
    f2py_success = int_from_pyobj(&iffld,iffld_capi,"_internal.l3dmpeval_vec() 5th argument (iffld) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = shape(ztarg,1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.l3dmpeval_vec() 2nd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(ztarg,1)==nvcount,"shape(ztarg,1)==nvcount","2nd keyword nvcount","l3dmpeval_vec:nvcount=%d",nvcount) {
  /* Processing variable nterms */
  if (nterms_capi == Py_None) nterms = (shape(expn,0)-1); else
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.l3dmpeval_vec() 1st keyword (nterms) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((shape(expn,0)-1)==nterms,"(shape(expn,0)-1)==nterms","1st keyword nterms","l3dmpeval_vec:nterms=%d",nterms) {
  /* Processing variable pot */
  pot_Dims[0]=nvcount;
  capi_pot_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_pot_tmp = array_from_pyobj(NPY_CDOUBLE,pot_Dims,pot_Rank,capi_pot_intent,Py_None);
  if (capi_pot_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `pot' of _internal.l3dmpeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    pot = (complex_double *)(PyArray_DATA(capi_pot_tmp));

  /* Processing variable fld */
  fld_Dims[0]=3,fld_Dims[1]=nvcount;
  capi_fld_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_fld_tmp = array_from_pyobj(NPY_CDOUBLE,fld_Dims,fld_Rank,capi_fld_intent,Py_None);
  if (capi_fld_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `fld' of _internal.l3dmpeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    fld = (complex_double *)(PyArray_DATA(capi_fld_tmp));

  /* Processing variable ier */
  ier_Dims[0]=nvcount;
  capi_ier_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_ier_tmp = array_from_pyobj(NPY_INT,ier_Dims,ier_Rank,capi_ier_intent,Py_None);
  if (capi_ier_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `ier' of _internal.l3dmpeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ier = (int *)(PyArray_DATA(capi_ier_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&rscale,center,expn,&nterms,ztarg,pot,&iffld,fld,ier,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NNN",capi_pot_tmp,capi_fld_tmp,capi_ier_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_ier_tmp == NULL) ... else of ier*/
  /* End of cleaning variable ier */
  }  /*if (capi_fld_tmp == NULL) ... else of fld*/
  /* End of cleaning variable fld */
  }  /*if (capi_pot_tmp == NULL) ... else of pot*/
  /* End of cleaning variable pot */
  } /*CHECKSCALAR((shape(expn,0)-1)==nterms)*/
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  } /*CHECKSCALAR(shape(ztarg,1)==nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  } /*if (f2py_success) of iffld*/
  /* End of cleaning variable iffld */
  if((PyObject *)capi_ztarg_tmp!=ztarg_capi) {
    Py_XDECREF(capi_ztarg_tmp); }
  }  /*if (capi_ztarg_tmp == NULL) ... else of ztarg*/
  /* End of cleaning variable ztarg */
  if((PyObject *)capi_expn_tmp!=expn_capi) {
    Py_XDECREF(capi_expn_tmp); }
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  if((PyObject *)capi_center_tmp!=center_capi) {
    Py_XDECREF(capi_center_tmp); }
  }  /*if (capi_center_tmp == NULL) ... else of center*/
  /* End of cleaning variable center */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/**************************** end of l3dmpeval_vec ****************************/

/******************************* h3dtaeval_vec *******************************/
static char doc_f2py_rout__internal_h3dtaeval_vec[] = "\
pot,fld,ier = h3dtaeval_vec(zk,rscale,center,expn,ztarg,iffld,[nterms,nvcount])\n\nWrapper for ``h3dtaeval_vec``.\
\n\nParameters\n----------\n"
"zk : input complex\n"
"rscale : input float\n"
"center : input rank-1 array('d') with bounds (3)\n"
"expn : input rank-2 array('D') with bounds (nterms + 1,2 * nterms + 1)\n"
"ztarg : input rank-2 array('d') with bounds (3,nvcount)\n"
"iffld : input int\n"
"\nOther Parameters\n----------------\n"
"nterms : input int, optional\n    Default: (shape(expn,0)-1)\n"
"nvcount : input int, optional\n    Default: shape(ztarg,1)\n"
"\nReturns\n-------\n"
"pot : rank-1 array('D') with bounds (nvcount)\n"
"fld : rank-2 array('D') with bounds (3,nvcount)\n"
"ier : rank-1 array('i') with bounds (nvcount)";
/* extern void F_FUNC_US(h3dtaeval_vec,H3DTAEVAL_VEC)(complex_double*,double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,int*); */
static PyObject *f2py_rout__internal_h3dtaeval_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(complex_double*,double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  complex_double zk;
  PyObject *zk_capi = Py_None;
  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *center = NULL;
  npy_intp center_Dims[1] = {-1};
  const int center_Rank = 1;
  PyArrayObject *capi_center_tmp = NULL;
  int capi_center_intent = 0;
  PyObject *center_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[2] = {-1, -1};
  const int expn_Rank = 2;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
  PyObject *expn_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  double *ztarg = NULL;
  npy_intp ztarg_Dims[2] = {-1, -1};
  const int ztarg_Rank = 2;
  PyArrayObject *capi_ztarg_tmp = NULL;
  int capi_ztarg_intent = 0;
  PyObject *ztarg_capi = Py_None;
  complex_double *pot = NULL;
  npy_intp pot_Dims[1] = {-1};
  const int pot_Rank = 1;
  PyArrayObject *capi_pot_tmp = NULL;
  int capi_pot_intent = 0;
  int iffld = 0;
  PyObject *iffld_capi = Py_None;
  complex_double *fld = NULL;
  npy_intp fld_Dims[2] = {-1, -1};
  const int fld_Rank = 2;
  PyArrayObject *capi_fld_tmp = NULL;
  int capi_fld_intent = 0;
  int *ier = NULL;
  npy_intp ier_Dims[1] = {-1};
  const int ier_Rank = 1;
  PyArrayObject *capi_ier_tmp = NULL;
  int capi_ier_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"zk","rscale","center","expn","ztarg","iffld","nterms","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOO|OO:_internal.h3dtaeval_vec",\
        capi_kwlist,&zk_capi,&rscale_capi,&center_capi,&expn_capi,&ztarg_capi,&iffld_capi,&nterms_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.h3dtaeval_vec() 1st argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.h3dtaeval_vec() 2nd argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable center */
  center_Dims[0]=3;
  capi_center_intent |= F2PY_INTENT_IN;
  capi_center_tmp = array_from_pyobj(NPY_DOUBLE,center_Dims,center_Rank,capi_center_intent,center_capi);
  if (capi_center_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `center' of _internal.h3dtaeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center = (double *)(PyArray_DATA(capi_center_tmp));

  /* Processing variable expn */
  ;
  capi_expn_intent |= F2PY_INTENT_IN;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,expn_capi);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `expn' of _internal.h3dtaeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

  /* Processing variable ztarg */
  ztarg_Dims[0]=3;
  capi_ztarg_intent |= F2PY_INTENT_IN;
  capi_ztarg_tmp = array_from_pyobj(NPY_DOUBLE,ztarg_Dims,ztarg_Rank,capi_ztarg_intent,ztarg_capi);
  if (capi_ztarg_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `ztarg' of _internal.h3dtaeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ztarg = (double *)(PyArray_DATA(capi_ztarg_tmp));

  /* Processing variable iffld */
    f2py_success = int_from_pyobj(&iffld,iffld_capi,"_internal.h3dtaeval_vec() 6th argument (iffld) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = shape(ztarg,1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.h3dtaeval_vec() 2nd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(ztarg,1)==nvcount,"shape(ztarg,1)==nvcount","2nd keyword nvcount","h3dtaeval_vec:nvcount=%d",nvcount) {
  /* Processing variable nterms */
  if (nterms_capi == Py_None) nterms = (shape(expn,0)-1); else
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.h3dtaeval_vec() 1st keyword (nterms) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((shape(expn,0)-1)==nterms,"(shape(expn,0)-1)==nterms","1st keyword nterms","h3dtaeval_vec:nterms=%d",nterms) {
  /* Processing variable pot */
  pot_Dims[0]=nvcount;
  capi_pot_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_pot_tmp = array_from_pyobj(NPY_CDOUBLE,pot_Dims,pot_Rank,capi_pot_intent,Py_None);
  if (capi_pot_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `pot' of _internal.h3dtaeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    pot = (complex_double *)(PyArray_DATA(capi_pot_tmp));

  /* Processing variable fld */
  fld_Dims[0]=3,fld_Dims[1]=nvcount;
  capi_fld_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_fld_tmp = array_from_pyobj(NPY_CDOUBLE,fld_Dims,fld_Rank,capi_fld_intent,Py_None);
  if (capi_fld_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `fld' of _internal.h3dtaeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    fld = (complex_double *)(PyArray_DATA(capi_fld_tmp));

  /* Processing variable ier */
  ier_Dims[0]=nvcount;
  capi_ier_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_ier_tmp = array_from_pyobj(NPY_INT,ier_Dims,ier_Rank,capi_ier_intent,Py_None);
  if (capi_ier_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `ier' of _internal.h3dtaeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ier = (int *)(PyArray_DATA(capi_ier_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&zk,&rscale,center,expn,&nterms,ztarg,pot,&iffld,fld,ier,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NNN",capi_pot_tmp,capi_fld_tmp,capi_ier_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_ier_tmp == NULL) ... else of ier*/
  /* End of cleaning variable ier */
  }  /*if (capi_fld_tmp == NULL) ... else of fld*/
  /* End of cleaning variable fld */
  }  /*if (capi_pot_tmp == NULL) ... else of pot*/
  /* End of cleaning variable pot */
  } /*CHECKSCALAR((shape(expn,0)-1)==nterms)*/
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  } /*CHECKSCALAR(shape(ztarg,1)==nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  } /*if (f2py_success) of iffld*/
  /* End of cleaning variable iffld */
  if((PyObject *)capi_ztarg_tmp!=ztarg_capi) {
    Py_XDECREF(capi_ztarg_tmp); }
  }  /*if (capi_ztarg_tmp == NULL) ... else of ztarg*/
  /* End of cleaning variable ztarg */
  if((PyObject *)capi_expn_tmp!=expn_capi) {
    Py_XDECREF(capi_expn_tmp); }
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  if((PyObject *)capi_center_tmp!=center_capi) {
    Py_XDECREF(capi_center_tmp); }
  }  /*if (capi_center_tmp == NULL) ... else of center*/
  /* End of cleaning variable center */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/**************************** end of h3dtaeval_vec ****************************/

/******************************* h3dmpeval_vec *******************************/
static char doc_f2py_rout__internal_h3dmpeval_vec[] = "\
pot,fld,ier = h3dmpeval_vec(zk,rscale,center,expn,ztarg,iffld,[nterms,nvcount])\n\nWrapper for ``h3dmpeval_vec``.\
\n\nParameters\n----------\n"
"zk : input complex\n"
"rscale : input float\n"
"center : input rank-1 array('d') with bounds (3)\n"
"expn : input rank-2 array('D') with bounds (nterms + 1,2 * nterms + 1)\n"
"ztarg : input rank-2 array('d') with bounds (3,nvcount)\n"
"iffld : input int\n"
"\nOther Parameters\n----------------\n"
"nterms : input int, optional\n    Default: (shape(expn,0)-1)\n"
"nvcount : input int, optional\n    Default: shape(ztarg,1)\n"
"\nReturns\n-------\n"
"pot : rank-1 array('D') with bounds (nvcount)\n"
"fld : rank-2 array('D') with bounds (3,nvcount)\n"
"ier : rank-1 array('i') with bounds (nvcount)";
/* extern void F_FUNC_US(h3dmpeval_vec,H3DMPEVAL_VEC)(complex_double*,double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,int*); */
static PyObject *f2py_rout__internal_h3dmpeval_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(complex_double*,double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  complex_double zk;
  PyObject *zk_capi = Py_None;
  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *center = NULL;
  npy_intp center_Dims[1] = {-1};
  const int center_Rank = 1;
  PyArrayObject *capi_center_tmp = NULL;
  int capi_center_intent = 0;
  PyObject *center_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[2] = {-1, -1};
  const int expn_Rank = 2;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
  PyObject *expn_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  double *ztarg = NULL;
  npy_intp ztarg_Dims[2] = {-1, -1};
  const int ztarg_Rank = 2;
  PyArrayObject *capi_ztarg_tmp = NULL;
  int capi_ztarg_intent = 0;
  PyObject *ztarg_capi = Py_None;
  complex_double *pot = NULL;
  npy_intp pot_Dims[1] = {-1};
  const int pot_Rank = 1;
  PyArrayObject *capi_pot_tmp = NULL;
  int capi_pot_intent = 0;
  int iffld = 0;
  PyObject *iffld_capi = Py_None;
  complex_double *fld = NULL;
  npy_intp fld_Dims[2] = {-1, -1};
  const int fld_Rank = 2;
  PyArrayObject *capi_fld_tmp = NULL;
  int capi_fld_intent = 0;
  int *ier = NULL;
  npy_intp ier_Dims[1] = {-1};
  const int ier_Rank = 1;
  PyArrayObject *capi_ier_tmp = NULL;
  int capi_ier_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"zk","rscale","center","expn","ztarg","iffld","nterms","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOO|OO:_internal.h3dmpeval_vec",\
        capi_kwlist,&zk_capi,&rscale_capi,&center_capi,&expn_capi,&ztarg_capi,&iffld_capi,&nterms_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.h3dmpeval_vec() 1st argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.h3dmpeval_vec() 2nd argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable center */
  center_Dims[0]=3;
  capi_center_intent |= F2PY_INTENT_IN;
  capi_center_tmp = array_from_pyobj(NPY_DOUBLE,center_Dims,center_Rank,capi_center_intent,center_capi);
  if (capi_center_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `center' of _internal.h3dmpeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center = (double *)(PyArray_DATA(capi_center_tmp));

  /* Processing variable expn */
  ;
  capi_expn_intent |= F2PY_INTENT_IN;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,expn_capi);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `expn' of _internal.h3dmpeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

  /* Processing variable ztarg */
  ztarg_Dims[0]=3;
  capi_ztarg_intent |= F2PY_INTENT_IN;
  capi_ztarg_tmp = array_from_pyobj(NPY_DOUBLE,ztarg_Dims,ztarg_Rank,capi_ztarg_intent,ztarg_capi);
  if (capi_ztarg_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `ztarg' of _internal.h3dmpeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ztarg = (double *)(PyArray_DATA(capi_ztarg_tmp));

  /* Processing variable iffld */
    f2py_success = int_from_pyobj(&iffld,iffld_capi,"_internal.h3dmpeval_vec() 6th argument (iffld) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = shape(ztarg,1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.h3dmpeval_vec() 2nd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(ztarg,1)==nvcount,"shape(ztarg,1)==nvcount","2nd keyword nvcount","h3dmpeval_vec:nvcount=%d",nvcount) {
  /* Processing variable nterms */
  if (nterms_capi == Py_None) nterms = (shape(expn,0)-1); else
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.h3dmpeval_vec() 1st keyword (nterms) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((shape(expn,0)-1)==nterms,"(shape(expn,0)-1)==nterms","1st keyword nterms","h3dmpeval_vec:nterms=%d",nterms) {
  /* Processing variable pot */
  pot_Dims[0]=nvcount;
  capi_pot_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_pot_tmp = array_from_pyobj(NPY_CDOUBLE,pot_Dims,pot_Rank,capi_pot_intent,Py_None);
  if (capi_pot_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `pot' of _internal.h3dmpeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    pot = (complex_double *)(PyArray_DATA(capi_pot_tmp));

  /* Processing variable fld */
  fld_Dims[0]=3,fld_Dims[1]=nvcount;
  capi_fld_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_fld_tmp = array_from_pyobj(NPY_CDOUBLE,fld_Dims,fld_Rank,capi_fld_intent,Py_None);
  if (capi_fld_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `fld' of _internal.h3dmpeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    fld = (complex_double *)(PyArray_DATA(capi_fld_tmp));

  /* Processing variable ier */
  ier_Dims[0]=nvcount;
  capi_ier_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_ier_tmp = array_from_pyobj(NPY_INT,ier_Dims,ier_Rank,capi_ier_intent,Py_None);
  if (capi_ier_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `ier' of _internal.h3dmpeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ier = (int *)(PyArray_DATA(capi_ier_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&zk,&rscale,center,expn,&nterms,ztarg,pot,&iffld,fld,ier,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NNN",capi_pot_tmp,capi_fld_tmp,capi_ier_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_ier_tmp == NULL) ... else of ier*/
  /* End of cleaning variable ier */
  }  /*if (capi_fld_tmp == NULL) ... else of fld*/
  /* End of cleaning variable fld */
  }  /*if (capi_pot_tmp == NULL) ... else of pot*/
  /* End of cleaning variable pot */
  } /*CHECKSCALAR((shape(expn,0)-1)==nterms)*/
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  } /*CHECKSCALAR(shape(ztarg,1)==nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  } /*if (f2py_success) of iffld*/
  /* End of cleaning variable iffld */
  if((PyObject *)capi_ztarg_tmp!=ztarg_capi) {
    Py_XDECREF(capi_ztarg_tmp); }
  }  /*if (capi_ztarg_tmp == NULL) ... else of ztarg*/
  /* End of cleaning variable ztarg */
  if((PyObject *)capi_expn_tmp!=expn_capi) {
    Py_XDECREF(capi_expn_tmp); }
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  if((PyObject *)capi_center_tmp!=center_capi) {
    Py_XDECREF(capi_center_tmp); }
  }  /*if (capi_center_tmp == NULL) ... else of center*/
  /* End of cleaning variable center */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/**************************** end of h3dmpeval_vec ****************************/

/******************************* l2dtaeval_vec *******************************/
static char doc_f2py_rout__internal_l2dtaeval_vec[] = "\
pot,grad,hess = l2dtaeval_vec(rscale,center,expn,ztarg,ifgrad,ifhess,[nterms,nvcount])\n\nWrapper for ``l2dtaeval_vec``.\
\n\nParameters\n----------\n"
"rscale : input float\n"
"center : input rank-1 array('d') with bounds (2)\n"
"expn : input rank-1 array('D') with bounds (nterms + 1)\n"
"ztarg : input rank-2 array('d') with bounds (2,nvcount)\n"
"ifgrad : input int\n"
"ifhess : input int\n"
"\nOther Parameters\n----------------\n"
"nterms : input int, optional\n    Default: (len(expn)-1)\n"
"nvcount : input int, optional\n    Default: shape(ztarg,1)\n"
"\nReturns\n-------\n"
"pot : rank-1 array('D') with bounds (nvcount)\n"
"grad : rank-2 array('D') with bounds (2,nvcount)\n"
"hess : rank-2 array('D') with bounds (3,nvcount)";
/* extern void F_FUNC_US(l2dtaeval_vec,L2DTAEVAL_VEC)(double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,complex_double*,int*); */
static PyObject *f2py_rout__internal_l2dtaeval_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,complex_double*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *center = NULL;
  npy_intp center_Dims[1] = {-1};
  const int center_Rank = 1;
  PyArrayObject *capi_center_tmp = NULL;
  int capi_center_intent = 0;
  PyObject *center_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[1] = {-1};
  const int expn_Rank = 1;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
  PyObject *expn_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  double *ztarg = NULL;
  npy_intp ztarg_Dims[2] = {-1, -1};
  const int ztarg_Rank = 2;
  PyArrayObject *capi_ztarg_tmp = NULL;
  int capi_ztarg_intent = 0;
  PyObject *ztarg_capi = Py_None;
  complex_double *pot = NULL;
  npy_intp pot_Dims[1] = {-1};
  const int pot_Rank = 1;
  PyArrayObject *capi_pot_tmp = NULL;
  int capi_pot_intent = 0;
  int ifgrad = 0;
  PyObject *ifgrad_capi = Py_None;
  complex_double *grad = NULL;
  npy_intp grad_Dims[2] = {-1, -1};
  const int grad_Rank = 2;
  PyArrayObject *capi_grad_tmp = NULL;
  int capi_grad_intent = 0;
  int ifhess = 0;
  PyObject *ifhess_capi = Py_None;
  complex_double *hess = NULL;
  npy_intp hess_Dims[2] = {-1, -1};
  const int hess_Rank = 2;
  PyArrayObject *capi_hess_tmp = NULL;
  int capi_hess_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"rscale","center","expn","ztarg","ifgrad","ifhess","nterms","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOO|OO:_internal.l2dtaeval_vec",\
        capi_kwlist,&rscale_capi,&center_capi,&expn_capi,&ztarg_capi,&ifgrad_capi,&ifhess_capi,&nterms_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.l2dtaeval_vec() 1st argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable center */
  center_Dims[0]=2;
  capi_center_intent |= F2PY_INTENT_IN;
  capi_center_tmp = array_from_pyobj(NPY_DOUBLE,center_Dims,center_Rank,capi_center_intent,center_capi);
  if (capi_center_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `center' of _internal.l2dtaeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center = (double *)(PyArray_DATA(capi_center_tmp));

  /* Processing variable expn */
  ;
  capi_expn_intent |= F2PY_INTENT_IN;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,expn_capi);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `expn' of _internal.l2dtaeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

  /* Processing variable ztarg */
  ztarg_Dims[0]=2;
  capi_ztarg_intent |= F2PY_INTENT_IN;
  capi_ztarg_tmp = array_from_pyobj(NPY_DOUBLE,ztarg_Dims,ztarg_Rank,capi_ztarg_intent,ztarg_capi);
  if (capi_ztarg_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `ztarg' of _internal.l2dtaeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ztarg = (double *)(PyArray_DATA(capi_ztarg_tmp));

  /* Processing variable ifgrad */
    f2py_success = int_from_pyobj(&ifgrad,ifgrad_capi,"_internal.l2dtaeval_vec() 5th argument (ifgrad) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ifhess */
    f2py_success = int_from_pyobj(&ifhess,ifhess_capi,"_internal.l2dtaeval_vec() 6th argument (ifhess) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = shape(ztarg,1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.l2dtaeval_vec() 2nd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(ztarg,1)==nvcount,"shape(ztarg,1)==nvcount","2nd keyword nvcount","l2dtaeval_vec:nvcount=%d",nvcount) {
  /* Processing variable nterms */
  if (nterms_capi == Py_None) nterms = (len(expn)-1); else
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.l2dtaeval_vec() 1st keyword (nterms) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((len(expn)-1)>=nterms,"(len(expn)-1)>=nterms","1st keyword nterms","l2dtaeval_vec:nterms=%d",nterms) {
  /* Processing variable pot */
  pot_Dims[0]=nvcount;
  capi_pot_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_pot_tmp = array_from_pyobj(NPY_CDOUBLE,pot_Dims,pot_Rank,capi_pot_intent,Py_None);
  if (capi_pot_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `pot' of _internal.l2dtaeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    pot = (complex_double *)(PyArray_DATA(capi_pot_tmp));

  /* Processing variable grad */
  grad_Dims[0]=2,grad_Dims[1]=nvcount;
  capi_grad_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_grad_tmp = array_from_pyobj(NPY_CDOUBLE,grad_Dims,grad_Rank,capi_grad_intent,Py_None);
  if (capi_grad_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `grad' of _internal.l2dtaeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    grad = (complex_double *)(PyArray_DATA(capi_grad_tmp));

  /* Processing variable hess */
  hess_Dims[0]=3,hess_Dims[1]=nvcount;
  capi_hess_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_hess_tmp = array_from_pyobj(NPY_CDOUBLE,hess_Dims,hess_Rank,capi_hess_intent,Py_None);
  if (capi_hess_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `hess' of _internal.l2dtaeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    hess = (complex_double *)(PyArray_DATA(capi_hess_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&rscale,center,expn,&nterms,ztarg,pot,&ifgrad,grad,&ifhess,hess,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NNN",capi_pot_tmp,capi_grad_tmp,capi_hess_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_hess_tmp == NULL) ... else of hess*/
  /* End of cleaning variable hess */
  }  /*if (capi_grad_tmp == NULL) ... else of grad*/
  /* End of cleaning variable grad */
  }  /*if (capi_pot_tmp == NULL) ... else of pot*/
  /* End of cleaning variable pot */
  } /*CHECKSCALAR((len(expn)-1)>=nterms)*/
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  } /*CHECKSCALAR(shape(ztarg,1)==nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  } /*if (f2py_success) of ifhess*/
  /* End of cleaning variable ifhess */
  } /*if (f2py_success) of ifgrad*/
  /* End of cleaning variable ifgrad */
  if((PyObject *)capi_ztarg_tmp!=ztarg_capi) {
    Py_XDECREF(capi_ztarg_tmp); }
  }  /*if (capi_ztarg_tmp == NULL) ... else of ztarg*/
  /* End of cleaning variable ztarg */
  if((PyObject *)capi_expn_tmp!=expn_capi) {
    Py_XDECREF(capi_expn_tmp); }
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  if((PyObject *)capi_center_tmp!=center_capi) {
    Py_XDECREF(capi_center_tmp); }
  }  /*if (capi_center_tmp == NULL) ... else of center*/
  /* End of cleaning variable center */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/**************************** end of l2dtaeval_vec ****************************/

/******************************* l2dmpeval_vec *******************************/
static char doc_f2py_rout__internal_l2dmpeval_vec[] = "\
pot,grad,hess = l2dmpeval_vec(rscale,center,expn,ztarg,ifgrad,ifhess,[nterms,nvcount])\n\nWrapper for ``l2dmpeval_vec``.\
\n\nParameters\n----------\n"
"rscale : input float\n"
"center : input rank-1 array('d') with bounds (2)\n"
"expn : input rank-1 array('D') with bounds (nterms + 1)\n"
"ztarg : input rank-2 array('d') with bounds (2,nvcount)\n"
"ifgrad : input int\n"
"ifhess : input int\n"
"\nOther Parameters\n----------------\n"
"nterms : input int, optional\n    Default: (len(expn)-1)\n"
"nvcount : input int, optional\n    Default: shape(ztarg,1)\n"
"\nReturns\n-------\n"
"pot : rank-1 array('D') with bounds (nvcount)\n"
"grad : rank-2 array('D') with bounds (2,nvcount)\n"
"hess : rank-2 array('D') with bounds (3,nvcount)";
/* extern void F_FUNC_US(l2dmpeval_vec,L2DMPEVAL_VEC)(double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,complex_double*,int*); */
static PyObject *f2py_rout__internal_l2dmpeval_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,complex_double*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *center = NULL;
  npy_intp center_Dims[1] = {-1};
  const int center_Rank = 1;
  PyArrayObject *capi_center_tmp = NULL;
  int capi_center_intent = 0;
  PyObject *center_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[1] = {-1};
  const int expn_Rank = 1;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
  PyObject *expn_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  double *ztarg = NULL;
  npy_intp ztarg_Dims[2] = {-1, -1};
  const int ztarg_Rank = 2;
  PyArrayObject *capi_ztarg_tmp = NULL;
  int capi_ztarg_intent = 0;
  PyObject *ztarg_capi = Py_None;
  complex_double *pot = NULL;
  npy_intp pot_Dims[1] = {-1};
  const int pot_Rank = 1;
  PyArrayObject *capi_pot_tmp = NULL;
  int capi_pot_intent = 0;
  int ifgrad = 0;
  PyObject *ifgrad_capi = Py_None;
  complex_double *grad = NULL;
  npy_intp grad_Dims[2] = {-1, -1};
  const int grad_Rank = 2;
  PyArrayObject *capi_grad_tmp = NULL;
  int capi_grad_intent = 0;
  int ifhess = 0;
  PyObject *ifhess_capi = Py_None;
  complex_double *hess = NULL;
  npy_intp hess_Dims[2] = {-1, -1};
  const int hess_Rank = 2;
  PyArrayObject *capi_hess_tmp = NULL;
  int capi_hess_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"rscale","center","expn","ztarg","ifgrad","ifhess","nterms","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOO|OO:_internal.l2dmpeval_vec",\
        capi_kwlist,&rscale_capi,&center_capi,&expn_capi,&ztarg_capi,&ifgrad_capi,&ifhess_capi,&nterms_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.l2dmpeval_vec() 1st argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable center */
  center_Dims[0]=2;
  capi_center_intent |= F2PY_INTENT_IN;
  capi_center_tmp = array_from_pyobj(NPY_DOUBLE,center_Dims,center_Rank,capi_center_intent,center_capi);
  if (capi_center_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `center' of _internal.l2dmpeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center = (double *)(PyArray_DATA(capi_center_tmp));

  /* Processing variable expn */
  ;
  capi_expn_intent |= F2PY_INTENT_IN;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,expn_capi);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `expn' of _internal.l2dmpeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

  /* Processing variable ztarg */
  ztarg_Dims[0]=2;
  capi_ztarg_intent |= F2PY_INTENT_IN;
  capi_ztarg_tmp = array_from_pyobj(NPY_DOUBLE,ztarg_Dims,ztarg_Rank,capi_ztarg_intent,ztarg_capi);
  if (capi_ztarg_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `ztarg' of _internal.l2dmpeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ztarg = (double *)(PyArray_DATA(capi_ztarg_tmp));

  /* Processing variable ifgrad */
    f2py_success = int_from_pyobj(&ifgrad,ifgrad_capi,"_internal.l2dmpeval_vec() 5th argument (ifgrad) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ifhess */
    f2py_success = int_from_pyobj(&ifhess,ifhess_capi,"_internal.l2dmpeval_vec() 6th argument (ifhess) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = shape(ztarg,1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.l2dmpeval_vec() 2nd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(ztarg,1)==nvcount,"shape(ztarg,1)==nvcount","2nd keyword nvcount","l2dmpeval_vec:nvcount=%d",nvcount) {
  /* Processing variable nterms */
  if (nterms_capi == Py_None) nterms = (len(expn)-1); else
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.l2dmpeval_vec() 1st keyword (nterms) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((len(expn)-1)>=nterms,"(len(expn)-1)>=nterms","1st keyword nterms","l2dmpeval_vec:nterms=%d",nterms) {
  /* Processing variable pot */
  pot_Dims[0]=nvcount;
  capi_pot_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_pot_tmp = array_from_pyobj(NPY_CDOUBLE,pot_Dims,pot_Rank,capi_pot_intent,Py_None);
  if (capi_pot_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `pot' of _internal.l2dmpeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    pot = (complex_double *)(PyArray_DATA(capi_pot_tmp));

  /* Processing variable grad */
  grad_Dims[0]=2,grad_Dims[1]=nvcount;
  capi_grad_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_grad_tmp = array_from_pyobj(NPY_CDOUBLE,grad_Dims,grad_Rank,capi_grad_intent,Py_None);
  if (capi_grad_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `grad' of _internal.l2dmpeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    grad = (complex_double *)(PyArray_DATA(capi_grad_tmp));

  /* Processing variable hess */
  hess_Dims[0]=3,hess_Dims[1]=nvcount;
  capi_hess_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_hess_tmp = array_from_pyobj(NPY_CDOUBLE,hess_Dims,hess_Rank,capi_hess_intent,Py_None);
  if (capi_hess_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `hess' of _internal.l2dmpeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    hess = (complex_double *)(PyArray_DATA(capi_hess_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&rscale,center,expn,&nterms,ztarg,pot,&ifgrad,grad,&ifhess,hess,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NNN",capi_pot_tmp,capi_grad_tmp,capi_hess_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_hess_tmp == NULL) ... else of hess*/
  /* End of cleaning variable hess */
  }  /*if (capi_grad_tmp == NULL) ... else of grad*/
  /* End of cleaning variable grad */
  }  /*if (capi_pot_tmp == NULL) ... else of pot*/
  /* End of cleaning variable pot */
  } /*CHECKSCALAR((len(expn)-1)>=nterms)*/
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  } /*CHECKSCALAR(shape(ztarg,1)==nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  } /*if (f2py_success) of ifhess*/
  /* End of cleaning variable ifhess */
  } /*if (f2py_success) of ifgrad*/
  /* End of cleaning variable ifgrad */
  if((PyObject *)capi_ztarg_tmp!=ztarg_capi) {
    Py_XDECREF(capi_ztarg_tmp); }
  }  /*if (capi_ztarg_tmp == NULL) ... else of ztarg*/
  /* End of cleaning variable ztarg */
  if((PyObject *)capi_expn_tmp!=expn_capi) {
    Py_XDECREF(capi_expn_tmp); }
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  if((PyObject *)capi_center_tmp!=center_capi) {
    Py_XDECREF(capi_center_tmp); }
  }  /*if (capi_center_tmp == NULL) ... else of center*/
  /* End of cleaning variable center */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/**************************** end of l2dmpeval_vec ****************************/

/******************************* h2dtaeval_vec *******************************/
static char doc_f2py_rout__internal_h2dtaeval_vec[] = "\
pot,grad,hess = h2dtaeval_vec(zk,rscale,center,expn,ztarg,ifgrad,ifhess,[nterms,nvcount])\n\nWrapper for ``h2dtaeval_vec``.\
\n\nParameters\n----------\n"
"zk : input complex\n"
"rscale : input float\n"
"center : input rank-1 array('d') with bounds (2)\n"
"expn : input rank-1 array('D') with bounds (2 * nterms + 1)\n"
"ztarg : input rank-2 array('d') with bounds (2,nvcount)\n"
"ifgrad : input int\n"
"ifhess : input int\n"
"\nOther Parameters\n----------------\n"
"nterms : input int, optional\n    Default: (len(expn)-1)/(2)\n"
"nvcount : input int, optional\n    Default: shape(ztarg,1)\n"
"\nReturns\n-------\n"
"pot : rank-1 array('D') with bounds (nvcount)\n"
"grad : rank-2 array('D') with bounds (2,nvcount)\n"
"hess : rank-2 array('D') with bounds (3,nvcount)";
/* extern void F_FUNC_US(h2dtaeval_vec,H2DTAEVAL_VEC)(complex_double*,double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,complex_double*,int*); */
static PyObject *f2py_rout__internal_h2dtaeval_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(complex_double*,double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,complex_double*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  complex_double zk;
  PyObject *zk_capi = Py_None;
  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *center = NULL;
  npy_intp center_Dims[1] = {-1};
  const int center_Rank = 1;
  PyArrayObject *capi_center_tmp = NULL;
  int capi_center_intent = 0;
  PyObject *center_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[1] = {-1};
  const int expn_Rank = 1;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
  PyObject *expn_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  double *ztarg = NULL;
  npy_intp ztarg_Dims[2] = {-1, -1};
  const int ztarg_Rank = 2;
  PyArrayObject *capi_ztarg_tmp = NULL;
  int capi_ztarg_intent = 0;
  PyObject *ztarg_capi = Py_None;
  complex_double *pot = NULL;
  npy_intp pot_Dims[1] = {-1};
  const int pot_Rank = 1;
  PyArrayObject *capi_pot_tmp = NULL;
  int capi_pot_intent = 0;
  int ifgrad = 0;
  PyObject *ifgrad_capi = Py_None;
  complex_double *grad = NULL;
  npy_intp grad_Dims[2] = {-1, -1};
  const int grad_Rank = 2;
  PyArrayObject *capi_grad_tmp = NULL;
  int capi_grad_intent = 0;
  int ifhess = 0;
  PyObject *ifhess_capi = Py_None;
  complex_double *hess = NULL;
  npy_intp hess_Dims[2] = {-1, -1};
  const int hess_Rank = 2;
  PyArrayObject *capi_hess_tmp = NULL;
  int capi_hess_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"zk","rscale","center","expn","ztarg","ifgrad","ifhess","nterms","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOO|OO:_internal.h2dtaeval_vec",\
        capi_kwlist,&zk_capi,&rscale_capi,&center_capi,&expn_capi,&ztarg_capi,&ifgrad_capi,&ifhess_capi,&nterms_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.h2dtaeval_vec() 1st argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.h2dtaeval_vec() 2nd argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable center */
  center_Dims[0]=2;
  capi_center_intent |= F2PY_INTENT_IN;
  capi_center_tmp = array_from_pyobj(NPY_DOUBLE,center_Dims,center_Rank,capi_center_intent,center_capi);
  if (capi_center_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `center' of _internal.h2dtaeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center = (double *)(PyArray_DATA(capi_center_tmp));

  /* Processing variable expn */
  ;
  capi_expn_intent |= F2PY_INTENT_IN;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,expn_capi);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `expn' of _internal.h2dtaeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

  /* Processing variable ztarg */
  ztarg_Dims[0]=2;
  capi_ztarg_intent |= F2PY_INTENT_IN;
  capi_ztarg_tmp = array_from_pyobj(NPY_DOUBLE,ztarg_Dims,ztarg_Rank,capi_ztarg_intent,ztarg_capi);
  if (capi_ztarg_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `ztarg' of _internal.h2dtaeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ztarg = (double *)(PyArray_DATA(capi_ztarg_tmp));

  /* Processing variable ifgrad */
    f2py_success = int_from_pyobj(&ifgrad,ifgrad_capi,"_internal.h2dtaeval_vec() 6th argument (ifgrad) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ifhess */
    f2py_success = int_from_pyobj(&ifhess,ifhess_capi,"_internal.h2dtaeval_vec() 7th argument (ifhess) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = shape(ztarg,1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.h2dtaeval_vec() 2nd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(ztarg,1)==nvcount,"shape(ztarg,1)==nvcount","2nd keyword nvcount","h2dtaeval_vec:nvcount=%d",nvcount) {
  /* Processing variable nterms */
  if (nterms_capi == Py_None) nterms = (len(expn)-1)/(2); else
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.h2dtaeval_vec() 1st keyword (nterms) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((len(expn)-1)/(2)>=nterms,"(len(expn)-1)/(2)>=nterms","1st keyword nterms","h2dtaeval_vec:nterms=%d",nterms) {
  /* Processing variable pot */
  pot_Dims[0]=nvcount;
  capi_pot_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_pot_tmp = array_from_pyobj(NPY_CDOUBLE,pot_Dims,pot_Rank,capi_pot_intent,Py_None);
  if (capi_pot_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `pot' of _internal.h2dtaeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    pot = (complex_double *)(PyArray_DATA(capi_pot_tmp));

  /* Processing variable grad */
  grad_Dims[0]=2,grad_Dims[1]=nvcount;
  capi_grad_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_grad_tmp = array_from_pyobj(NPY_CDOUBLE,grad_Dims,grad_Rank,capi_grad_intent,Py_None);
  if (capi_grad_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `grad' of _internal.h2dtaeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    grad = (complex_double *)(PyArray_DATA(capi_grad_tmp));

  /* Processing variable hess */
  hess_Dims[0]=3,hess_Dims[1]=nvcount;
  capi_hess_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_hess_tmp = array_from_pyobj(NPY_CDOUBLE,hess_Dims,hess_Rank,capi_hess_intent,Py_None);
  if (capi_hess_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `hess' of _internal.h2dtaeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    hess = (complex_double *)(PyArray_DATA(capi_hess_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&zk,&rscale,center,expn,&nterms,ztarg,pot,&ifgrad,grad,&ifhess,hess,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NNN",capi_pot_tmp,capi_grad_tmp,capi_hess_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_hess_tmp == NULL) ... else of hess*/
  /* End of cleaning variable hess */
  }  /*if (capi_grad_tmp == NULL) ... else of grad*/
  /* End of cleaning variable grad */
  }  /*if (capi_pot_tmp == NULL) ... else of pot*/
  /* End of cleaning variable pot */
  } /*CHECKSCALAR((len(expn)-1)/(2)>=nterms)*/
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  } /*CHECKSCALAR(shape(ztarg,1)==nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  } /*if (f2py_success) of ifhess*/
  /* End of cleaning variable ifhess */
  } /*if (f2py_success) of ifgrad*/
  /* End of cleaning variable ifgrad */
  if((PyObject *)capi_ztarg_tmp!=ztarg_capi) {
    Py_XDECREF(capi_ztarg_tmp); }
  }  /*if (capi_ztarg_tmp == NULL) ... else of ztarg*/
  /* End of cleaning variable ztarg */
  if((PyObject *)capi_expn_tmp!=expn_capi) {
    Py_XDECREF(capi_expn_tmp); }
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  if((PyObject *)capi_center_tmp!=center_capi) {
    Py_XDECREF(capi_center_tmp); }
  }  /*if (capi_center_tmp == NULL) ... else of center*/
  /* End of cleaning variable center */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/**************************** end of h2dtaeval_vec ****************************/

/******************************* h2dmpeval_vec *******************************/
static char doc_f2py_rout__internal_h2dmpeval_vec[] = "\
pot,grad,hess = h2dmpeval_vec(zk,rscale,center,expn,ztarg,ifgrad,ifhess,[nterms,nvcount])\n\nWrapper for ``h2dmpeval_vec``.\
\n\nParameters\n----------\n"
"zk : input complex\n"
"rscale : input float\n"
"center : input rank-1 array('d') with bounds (2)\n"
"expn : input rank-1 array('D') with bounds (2 * nterms + 1)\n"
"ztarg : input rank-2 array('d') with bounds (2,nvcount)\n"
"ifgrad : input int\n"
"ifhess : input int\n"
"\nOther Parameters\n----------------\n"
"nterms : input int, optional\n    Default: (len(expn)-1)/(2)\n"
"nvcount : input int, optional\n    Default: shape(ztarg,1)\n"
"\nReturns\n-------\n"
"pot : rank-1 array('D') with bounds (nvcount)\n"
"grad : rank-2 array('D') with bounds (2,nvcount)\n"
"hess : rank-2 array('D') with bounds (3,nvcount)";
/* extern void F_FUNC_US(h2dmpeval_vec,H2DMPEVAL_VEC)(complex_double*,double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,complex_double*,int*); */
static PyObject *f2py_rout__internal_h2dmpeval_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(complex_double*,double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,complex_double*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  complex_double zk;
  PyObject *zk_capi = Py_None;
  double rscale = 0;
  PyObject *rscale_capi = Py_None;
  double *center = NULL;
  npy_intp center_Dims[1] = {-1};
  const int center_Rank = 1;
  PyArrayObject *capi_center_tmp = NULL;
  int capi_center_intent = 0;
  PyObject *center_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[1] = {-1};
  const int expn_Rank = 1;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
  PyObject *expn_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  double *ztarg = NULL;
  npy_intp ztarg_Dims[2] = {-1, -1};
  const int ztarg_Rank = 2;
  PyArrayObject *capi_ztarg_tmp = NULL;
  int capi_ztarg_intent = 0;
  PyObject *ztarg_capi = Py_None;
  complex_double *pot = NULL;
  npy_intp pot_Dims[1] = {-1};
  const int pot_Rank = 1;
  PyArrayObject *capi_pot_tmp = NULL;
  int capi_pot_intent = 0;
  int ifgrad = 0;
  PyObject *ifgrad_capi = Py_None;
  complex_double *grad = NULL;
  npy_intp grad_Dims[2] = {-1, -1};
  const int grad_Rank = 2;
  PyArrayObject *capi_grad_tmp = NULL;
  int capi_grad_intent = 0;
  int ifhess = 0;
  PyObject *ifhess_capi = Py_None;
  complex_double *hess = NULL;
  npy_intp hess_Dims[2] = {-1, -1};
  const int hess_Rank = 2;
  PyArrayObject *capi_hess_tmp = NULL;
  int capi_hess_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"zk","rscale","center","expn","ztarg","ifgrad","ifhess","nterms","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOO|OO:_internal.h2dmpeval_vec",\
        capi_kwlist,&zk_capi,&rscale_capi,&center_capi,&expn_capi,&ztarg_capi,&ifgrad_capi,&ifhess_capi,&nterms_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.h2dmpeval_vec() 1st argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable rscale */
    f2py_success = double_from_pyobj(&rscale,rscale_capi,"_internal.h2dmpeval_vec() 2nd argument (rscale) can't be converted to double");
  if (f2py_success) {
  /* Processing variable center */
  center_Dims[0]=2;
  capi_center_intent |= F2PY_INTENT_IN;
  capi_center_tmp = array_from_pyobj(NPY_DOUBLE,center_Dims,center_Rank,capi_center_intent,center_capi);
  if (capi_center_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `center' of _internal.h2dmpeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center = (double *)(PyArray_DATA(capi_center_tmp));

  /* Processing variable expn */
  ;
  capi_expn_intent |= F2PY_INTENT_IN;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,expn_capi);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `expn' of _internal.h2dmpeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

  /* Processing variable ztarg */
  ztarg_Dims[0]=2;
  capi_ztarg_intent |= F2PY_INTENT_IN;
  capi_ztarg_tmp = array_from_pyobj(NPY_DOUBLE,ztarg_Dims,ztarg_Rank,capi_ztarg_intent,ztarg_capi);
  if (capi_ztarg_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `ztarg' of _internal.h2dmpeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ztarg = (double *)(PyArray_DATA(capi_ztarg_tmp));

  /* Processing variable ifgrad */
    f2py_success = int_from_pyobj(&ifgrad,ifgrad_capi,"_internal.h2dmpeval_vec() 6th argument (ifgrad) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ifhess */
    f2py_success = int_from_pyobj(&ifhess,ifhess_capi,"_internal.h2dmpeval_vec() 7th argument (ifhess) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = shape(ztarg,1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.h2dmpeval_vec() 2nd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(ztarg,1)==nvcount,"shape(ztarg,1)==nvcount","2nd keyword nvcount","h2dmpeval_vec:nvcount=%d",nvcount) {
  /* Processing variable nterms */
  if (nterms_capi == Py_None) nterms = (len(expn)-1)/(2); else
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.h2dmpeval_vec() 1st keyword (nterms) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((len(expn)-1)/(2)>=nterms,"(len(expn)-1)/(2)>=nterms","1st keyword nterms","h2dmpeval_vec:nterms=%d",nterms) {
  /* Processing variable pot */
  pot_Dims[0]=nvcount;
  capi_pot_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_pot_tmp = array_from_pyobj(NPY_CDOUBLE,pot_Dims,pot_Rank,capi_pot_intent,Py_None);
  if (capi_pot_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `pot' of _internal.h2dmpeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    pot = (complex_double *)(PyArray_DATA(capi_pot_tmp));

  /* Processing variable grad */
  grad_Dims[0]=2,grad_Dims[1]=nvcount;
  capi_grad_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_grad_tmp = array_from_pyobj(NPY_CDOUBLE,grad_Dims,grad_Rank,capi_grad_intent,Py_None);
  if (capi_grad_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `grad' of _internal.h2dmpeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    grad = (complex_double *)(PyArray_DATA(capi_grad_tmp));

  /* Processing variable hess */
  hess_Dims[0]=3,hess_Dims[1]=nvcount;
  capi_hess_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_hess_tmp = array_from_pyobj(NPY_CDOUBLE,hess_Dims,hess_Rank,capi_hess_intent,Py_None);
  if (capi_hess_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `hess' of _internal.h2dmpeval_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    hess = (complex_double *)(PyArray_DATA(capi_hess_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&zk,&rscale,center,expn,&nterms,ztarg,pot,&ifgrad,grad,&ifhess,hess,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NNN",capi_pot_tmp,capi_grad_tmp,capi_hess_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_hess_tmp == NULL) ... else of hess*/
  /* End of cleaning variable hess */
  }  /*if (capi_grad_tmp == NULL) ... else of grad*/
  /* End of cleaning variable grad */
  }  /*if (capi_pot_tmp == NULL) ... else of pot*/
  /* End of cleaning variable pot */
  } /*CHECKSCALAR((len(expn)-1)/(2)>=nterms)*/
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  } /*CHECKSCALAR(shape(ztarg,1)==nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  } /*if (f2py_success) of ifhess*/
  /* End of cleaning variable ifhess */
  } /*if (f2py_success) of ifgrad*/
  /* End of cleaning variable ifgrad */
  if((PyObject *)capi_ztarg_tmp!=ztarg_capi) {
    Py_XDECREF(capi_ztarg_tmp); }
  }  /*if (capi_ztarg_tmp == NULL) ... else of ztarg*/
  /* End of cleaning variable ztarg */
  if((PyObject *)capi_expn_tmp!=expn_capi) {
    Py_XDECREF(capi_expn_tmp); }
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  if((PyObject *)capi_center_tmp!=center_capi) {
    Py_XDECREF(capi_center_tmp); }
  }  /*if (capi_center_tmp == NULL) ... else of center*/
  /* End of cleaning variable center */
  } /*if (f2py_success) of rscale*/
  /* End of cleaning variable rscale */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/**************************** end of h2dmpeval_vec ****************************/

/************************** l3dtaevalhess_1tgtperexp **************************/
static char doc_f2py_rout__internal_l3dtaevalhess_1tgtperexp[] = "\
pot,grad,hess,ier = l3dtaevalhess_1tgtperexp(rscale,center,expn,ztarg,ifgrad,ifhess,[nterms,nvcount])\n\nWrapper for ``l3dtaevalhess_1tgtperexp``.\
\n\nParameters\n----------\n"
"rscale : input rank-1 array('d') with bounds (nvcount)\n"
"center : input rank-2 array('d') with bounds (3,nvcount)\n"
"expn : input rank-3 array('D') with bounds (nterms + 1,2 * nterms + 1,nvcount)\n"
"ztarg : input rank-2 array('d') with bounds (3,nvcount)\n"
"ifgrad : input int\n"
"ifhess : input int\n"
"\nOther Parameters\n----------------\n"
"nterms : input int, optional\n    Default: (shape(expn,0)-1)\n"
"nvcount : input int, optional\n    Default: len(rscale)\n"
"\nReturns\n-------\n"
"pot : rank-1 array('D') with bounds (nvcount)\n"
"grad : rank-2 array('D') with bounds (3,nvcount)\n"
"hess : rank-2 array('D') with bounds (6,nvcount)\n"
"ier : int";
/* extern void F_FUNC_US(l3dtaevalhess_1tgtperexp,L3DTAEVALHESS_1TGTPEREXP)(double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,complex_double*,int*,int*); */
static PyObject *f2py_rout__internal_l3dtaevalhess_1tgtperexp(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,complex_double*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double *rscale = NULL;
  npy_intp rscale_Dims[1] = {-1};
  const int rscale_Rank = 1;
  PyArrayObject *capi_rscale_tmp = NULL;
  int capi_rscale_intent = 0;
  PyObject *rscale_capi = Py_None;
  double *center = NULL;
  npy_intp center_Dims[2] = {-1, -1};
  const int center_Rank = 2;
  PyArrayObject *capi_center_tmp = NULL;
  int capi_center_intent = 0;
  PyObject *center_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[3] = {-1, -1, -1};
  const int expn_Rank = 3;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
  PyObject *expn_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  double *ztarg = NULL;
  npy_intp ztarg_Dims[2] = {-1, -1};
  const int ztarg_Rank = 2;
  PyArrayObject *capi_ztarg_tmp = NULL;
  int capi_ztarg_intent = 0;
  PyObject *ztarg_capi = Py_None;
  complex_double *pot = NULL;
  npy_intp pot_Dims[1] = {-1};
  const int pot_Rank = 1;
  PyArrayObject *capi_pot_tmp = NULL;
  int capi_pot_intent = 0;
  int ifgrad = 0;
  PyObject *ifgrad_capi = Py_None;
  complex_double *grad = NULL;
  npy_intp grad_Dims[2] = {-1, -1};
  const int grad_Rank = 2;
  PyArrayObject *capi_grad_tmp = NULL;
  int capi_grad_intent = 0;
  int ifhess = 0;
  PyObject *ifhess_capi = Py_None;
  complex_double *hess = NULL;
  npy_intp hess_Dims[2] = {-1, -1};
  const int hess_Rank = 2;
  PyArrayObject *capi_hess_tmp = NULL;
  int capi_hess_intent = 0;
  int ier = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"rscale","center","expn","ztarg","ifgrad","ifhess","nterms","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOO|OO:_internal.l3dtaevalhess_1tgtperexp",\
        capi_kwlist,&rscale_capi,&center_capi,&expn_capi,&ztarg_capi,&ifgrad_capi,&ifhess_capi,&nterms_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale */
  ;
  capi_rscale_intent |= F2PY_INTENT_IN;
  capi_rscale_tmp = array_from_pyobj(NPY_DOUBLE,rscale_Dims,rscale_Rank,capi_rscale_intent,rscale_capi);
  if (capi_rscale_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 1st argument `rscale' of _internal.l3dtaevalhess_1tgtperexp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale = (double *)(PyArray_DATA(capi_rscale_tmp));

  /* Processing variable ifgrad */
    f2py_success = int_from_pyobj(&ifgrad,ifgrad_capi,"_internal.l3dtaevalhess_1tgtperexp() 5th argument (ifgrad) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ifhess */
    f2py_success = int_from_pyobj(&ifhess,ifhess_capi,"_internal.l3dtaevalhess_1tgtperexp() 6th argument (ifhess) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ier */
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = len(rscale); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.l3dtaevalhess_1tgtperexp() 2nd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(rscale)>=nvcount,"len(rscale)>=nvcount","2nd keyword nvcount","l3dtaevalhess_1tgtperexp:nvcount=%d",nvcount) {
  /* Processing variable center */
  center_Dims[0]=3,center_Dims[1]=nvcount;
  capi_center_intent |= F2PY_INTENT_IN;
  capi_center_tmp = array_from_pyobj(NPY_DOUBLE,center_Dims,center_Rank,capi_center_intent,center_capi);
  if (capi_center_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `center' of _internal.l3dtaevalhess_1tgtperexp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center = (double *)(PyArray_DATA(capi_center_tmp));

  /* Processing variable expn */
  expn_Dims[2]=nvcount;
  capi_expn_intent |= F2PY_INTENT_IN;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,expn_capi);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `expn' of _internal.l3dtaevalhess_1tgtperexp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

  /* Processing variable nterms */
  if (nterms_capi == Py_None) nterms = (shape(expn,0)-1); else
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.l3dtaevalhess_1tgtperexp() 1st keyword (nterms) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((shape(expn,0)-1)==nterms,"(shape(expn,0)-1)==nterms","1st keyword nterms","l3dtaevalhess_1tgtperexp:nterms=%d",nterms) {
  /* Processing variable ztarg */
  ztarg_Dims[0]=3,ztarg_Dims[1]=nvcount;
  capi_ztarg_intent |= F2PY_INTENT_IN;
  capi_ztarg_tmp = array_from_pyobj(NPY_DOUBLE,ztarg_Dims,ztarg_Rank,capi_ztarg_intent,ztarg_capi);
  if (capi_ztarg_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `ztarg' of _internal.l3dtaevalhess_1tgtperexp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ztarg = (double *)(PyArray_DATA(capi_ztarg_tmp));

  /* Processing variable pot */
  pot_Dims[0]=nvcount;
  capi_pot_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_pot_tmp = array_from_pyobj(NPY_CDOUBLE,pot_Dims,pot_Rank,capi_pot_intent,Py_None);
  if (capi_pot_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `pot' of _internal.l3dtaevalhess_1tgtperexp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    pot = (complex_double *)(PyArray_DATA(capi_pot_tmp));

  /* Processing variable grad */
  grad_Dims[0]=3,grad_Dims[1]=nvcount;
  capi_grad_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_grad_tmp = array_from_pyobj(NPY_CDOUBLE,grad_Dims,grad_Rank,capi_grad_intent,Py_None);
  if (capi_grad_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `grad' of _internal.l3dtaevalhess_1tgtperexp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    grad = (complex_double *)(PyArray_DATA(capi_grad_tmp));

  /* Processing variable hess */
  hess_Dims[0]=6,hess_Dims[1]=nvcount;
  capi_hess_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_hess_tmp = array_from_pyobj(NPY_CDOUBLE,hess_Dims,hess_Rank,capi_hess_intent,Py_None);
  if (capi_hess_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `hess' of _internal.l3dtaevalhess_1tgtperexp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    hess = (complex_double *)(PyArray_DATA(capi_hess_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(rscale,center,expn,&nterms,ztarg,pot,&ifgrad,grad,&ifhess,hess,&ier,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NNNi",capi_pot_tmp,capi_grad_tmp,capi_hess_tmp,ier);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_hess_tmp == NULL) ... else of hess*/
  /* End of cleaning variable hess */
  }  /*if (capi_grad_tmp == NULL) ... else of grad*/
  /* End of cleaning variable grad */
  }  /*if (capi_pot_tmp == NULL) ... else of pot*/
  /* End of cleaning variable pot */
  if((PyObject *)capi_ztarg_tmp!=ztarg_capi) {
    Py_XDECREF(capi_ztarg_tmp); }
  }  /*if (capi_ztarg_tmp == NULL) ... else of ztarg*/
  /* End of cleaning variable ztarg */
  } /*CHECKSCALAR((shape(expn,0)-1)==nterms)*/
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_expn_tmp!=expn_capi) {
    Py_XDECREF(capi_expn_tmp); }
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  if((PyObject *)capi_center_tmp!=center_capi) {
    Py_XDECREF(capi_center_tmp); }
  }  /*if (capi_center_tmp == NULL) ... else of center*/
  /* End of cleaning variable center */
  } /*CHECKSCALAR(len(rscale)>=nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  /* End of cleaning variable ier */
  } /*if (f2py_success) of ifhess*/
  /* End of cleaning variable ifhess */
  } /*if (f2py_success) of ifgrad*/
  /* End of cleaning variable ifgrad */
  if((PyObject *)capi_rscale_tmp!=rscale_capi) {
    Py_XDECREF(capi_rscale_tmp); }
  }  /*if (capi_rscale_tmp == NULL) ... else of rscale*/
  /* End of cleaning variable rscale */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/********************** end of l3dtaevalhess_1tgtperexp **********************/

/**************************** h3dtaeval_1tgtperexp ****************************/
static char doc_f2py_rout__internal_h3dtaeval_1tgtperexp[] = "\
pot,grad,ier = h3dtaeval_1tgtperexp(zk,rscale,center,expn,ztarg,ifgrad,[nterms,nvcount])\n\nWrapper for ``h3dtaeval_1tgtperexp``.\
\n\nParameters\n----------\n"
"zk : input complex\n"
"rscale : input rank-1 array('d') with bounds (nvcount)\n"
"center : input rank-2 array('d') with bounds (3,nvcount)\n"
"expn : input rank-3 array('D') with bounds (nterms + 1,2 * nterms + 1,nvcount)\n"
"ztarg : input rank-2 array('d') with bounds (3,nvcount)\n"
"ifgrad : input int\n"
"\nOther Parameters\n----------------\n"
"nterms : input int, optional\n    Default: (shape(expn,0)-1)\n"
"nvcount : input int, optional\n    Default: len(rscale)\n"
"\nReturns\n-------\n"
"pot : rank-1 array('D') with bounds (nvcount)\n"
"grad : rank-2 array('D') with bounds (3,nvcount)\n"
"ier : int";
/* extern void F_FUNC_US(h3dtaeval_1tgtperexp,H3DTAEVAL_1TGTPEREXP)(complex_double*,double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,int*); */
static PyObject *f2py_rout__internal_h3dtaeval_1tgtperexp(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(complex_double*,double*,double*,complex_double*,int*,double*,complex_double*,int*,complex_double*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  complex_double zk;
  PyObject *zk_capi = Py_None;
  double *rscale = NULL;
  npy_intp rscale_Dims[1] = {-1};
  const int rscale_Rank = 1;
  PyArrayObject *capi_rscale_tmp = NULL;
  int capi_rscale_intent = 0;
  PyObject *rscale_capi = Py_None;
  double *center = NULL;
  npy_intp center_Dims[2] = {-1, -1};
  const int center_Rank = 2;
  PyArrayObject *capi_center_tmp = NULL;
  int capi_center_intent = 0;
  PyObject *center_capi = Py_None;
  complex_double *expn = NULL;
  npy_intp expn_Dims[3] = {-1, -1, -1};
  const int expn_Rank = 3;
  PyArrayObject *capi_expn_tmp = NULL;
  int capi_expn_intent = 0;
  PyObject *expn_capi = Py_None;
  int nterms = 0;
  PyObject *nterms_capi = Py_None;
  double *ztarg = NULL;
  npy_intp ztarg_Dims[2] = {-1, -1};
  const int ztarg_Rank = 2;
  PyArrayObject *capi_ztarg_tmp = NULL;
  int capi_ztarg_intent = 0;
  PyObject *ztarg_capi = Py_None;
  complex_double *pot = NULL;
  npy_intp pot_Dims[1] = {-1};
  const int pot_Rank = 1;
  PyArrayObject *capi_pot_tmp = NULL;
  int capi_pot_intent = 0;
  int ifgrad = 0;
  PyObject *ifgrad_capi = Py_None;
  complex_double *grad = NULL;
  npy_intp grad_Dims[2] = {-1, -1};
  const int grad_Rank = 2;
  PyArrayObject *capi_grad_tmp = NULL;
  int capi_grad_intent = 0;
  int ier = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"zk","rscale","center","expn","ztarg","ifgrad","nterms","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOO|OO:_internal.h3dtaeval_1tgtperexp",\
        capi_kwlist,&zk_capi,&rscale_capi,&center_capi,&expn_capi,&ztarg_capi,&ifgrad_capi,&nterms_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.h3dtaeval_1tgtperexp() 1st argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable rscale */
  ;
  capi_rscale_intent |= F2PY_INTENT_IN;
  capi_rscale_tmp = array_from_pyobj(NPY_DOUBLE,rscale_Dims,rscale_Rank,capi_rscale_intent,rscale_capi);
  if (capi_rscale_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `rscale' of _internal.h3dtaeval_1tgtperexp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale = (double *)(PyArray_DATA(capi_rscale_tmp));

  /* Processing variable ifgrad */
    f2py_success = int_from_pyobj(&ifgrad,ifgrad_capi,"_internal.h3dtaeval_1tgtperexp() 6th argument (ifgrad) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ier */
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = len(rscale); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.h3dtaeval_1tgtperexp() 2nd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(rscale)>=nvcount,"len(rscale)>=nvcount","2nd keyword nvcount","h3dtaeval_1tgtperexp:nvcount=%d",nvcount) {
  /* Processing variable center */
  center_Dims[0]=3,center_Dims[1]=nvcount;
  capi_center_intent |= F2PY_INTENT_IN;
  capi_center_tmp = array_from_pyobj(NPY_DOUBLE,center_Dims,center_Rank,capi_center_intent,center_capi);
  if (capi_center_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `center' of _internal.h3dtaeval_1tgtperexp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center = (double *)(PyArray_DATA(capi_center_tmp));

  /* Processing variable expn */
  expn_Dims[2]=nvcount;
  capi_expn_intent |= F2PY_INTENT_IN;
  capi_expn_tmp = array_from_pyobj(NPY_CDOUBLE,expn_Dims,expn_Rank,capi_expn_intent,expn_capi);
  if (capi_expn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `expn' of _internal.h3dtaeval_1tgtperexp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn = (complex_double *)(PyArray_DATA(capi_expn_tmp));

  /* Processing variable nterms */
  if (nterms_capi == Py_None) nterms = (shape(expn,0)-1); else
    f2py_success = int_from_pyobj(&nterms,nterms_capi,"_internal.h3dtaeval_1tgtperexp() 1st keyword (nterms) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((shape(expn,0)-1)==nterms,"(shape(expn,0)-1)==nterms","1st keyword nterms","h3dtaeval_1tgtperexp:nterms=%d",nterms) {
  /* Processing variable ztarg */
  ztarg_Dims[0]=3,ztarg_Dims[1]=nvcount;
  capi_ztarg_intent |= F2PY_INTENT_IN;
  capi_ztarg_tmp = array_from_pyobj(NPY_DOUBLE,ztarg_Dims,ztarg_Rank,capi_ztarg_intent,ztarg_capi);
  if (capi_ztarg_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `ztarg' of _internal.h3dtaeval_1tgtperexp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ztarg = (double *)(PyArray_DATA(capi_ztarg_tmp));

  /* Processing variable pot */
  pot_Dims[0]=nvcount;
  capi_pot_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_pot_tmp = array_from_pyobj(NPY_CDOUBLE,pot_Dims,pot_Rank,capi_pot_intent,Py_None);
  if (capi_pot_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `pot' of _internal.h3dtaeval_1tgtperexp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    pot = (complex_double *)(PyArray_DATA(capi_pot_tmp));

  /* Processing variable grad */
  grad_Dims[0]=3,grad_Dims[1]=nvcount;
  capi_grad_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_grad_tmp = array_from_pyobj(NPY_CDOUBLE,grad_Dims,grad_Rank,capi_grad_intent,Py_None);
  if (capi_grad_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `grad' of _internal.h3dtaeval_1tgtperexp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    grad = (complex_double *)(PyArray_DATA(capi_grad_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&zk,rscale,center,expn,&nterms,ztarg,pot,&ifgrad,grad,&ier,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NNi",capi_pot_tmp,capi_grad_tmp,ier);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_grad_tmp == NULL) ... else of grad*/
  /* End of cleaning variable grad */
  }  /*if (capi_pot_tmp == NULL) ... else of pot*/
  /* End of cleaning variable pot */
  if((PyObject *)capi_ztarg_tmp!=ztarg_capi) {
    Py_XDECREF(capi_ztarg_tmp); }
  }  /*if (capi_ztarg_tmp == NULL) ... else of ztarg*/
  /* End of cleaning variable ztarg */
  } /*CHECKSCALAR((shape(expn,0)-1)==nterms)*/
  } /*if (f2py_success) of nterms*/
  /* End of cleaning variable nterms */
  if((PyObject *)capi_expn_tmp!=expn_capi) {
    Py_XDECREF(capi_expn_tmp); }
  }  /*if (capi_expn_tmp == NULL) ... else of expn*/
  /* End of cleaning variable expn */
  if((PyObject *)capi_center_tmp!=center_capi) {
    Py_XDECREF(capi_center_tmp); }
  }  /*if (capi_center_tmp == NULL) ... else of center*/
  /* End of cleaning variable center */
  } /*CHECKSCALAR(len(rscale)>=nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  /* End of cleaning variable ier */
  } /*if (f2py_success) of ifgrad*/
  /* End of cleaning variable ifgrad */
  if((PyObject *)capi_rscale_tmp!=rscale_capi) {
    Py_XDECREF(capi_rscale_tmp); }
  }  /*if (capi_rscale_tmp == NULL) ... else of rscale*/
  /* End of cleaning variable rscale */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/************************ end of h3dtaeval_1tgtperexp ************************/

/******************************** l2dmpmp_vec ********************************/
static char doc_f2py_rout__internal_l2dmpmp_vec[] = "\
expn2 = l2dmpmp_vec(rscale1,center1,expn1,rscale2,center2,nterms2,[nterms1,nvcount])\n\nWrapper for ``l2dmpmp_vec``.\
\n\nParameters\n----------\n"
"rscale1 : input rank-1 array('d') with bounds (nvcount)\n"
"center1 : input rank-2 array('d') with bounds (2,nvcount)\n"
"expn1 : input rank-2 array('D') with bounds (nterms1 + 1,nvcount)\n"
"rscale2 : input rank-1 array('d') with bounds (nvcount)\n"
"center2 : input rank-2 array('d') with bounds (2,nvcount)\n"
"nterms2 : input int\n"
"\nOther Parameters\n----------------\n"
"nterms1 : input int, optional\n    Default: (shape(expn1,0)-1)\n"
"nvcount : input int, optional\n    Default: len(rscale1)\n"
"\nReturns\n-------\n"
"expn2 : rank-2 array('D') with bounds (nterms2 + 1,nvcount)";
/* extern void F_FUNC_US(l2dmpmp_vec,L2DMPMP_VEC)(double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,int*); */
static PyObject *f2py_rout__internal_l2dmpmp_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double *rscale1 = NULL;
  npy_intp rscale1_Dims[1] = {-1};
  const int rscale1_Rank = 1;
  PyArrayObject *capi_rscale1_tmp = NULL;
  int capi_rscale1_intent = 0;
  PyObject *rscale1_capi = Py_None;
  double *center1 = NULL;
  npy_intp center1_Dims[2] = {-1, -1};
  const int center1_Rank = 2;
  PyArrayObject *capi_center1_tmp = NULL;
  int capi_center1_intent = 0;
  PyObject *center1_capi = Py_None;
  complex_double *expn1 = NULL;
  npy_intp expn1_Dims[2] = {-1, -1};
  const int expn1_Rank = 2;
  PyArrayObject *capi_expn1_tmp = NULL;
  int capi_expn1_intent = 0;
  PyObject *expn1_capi = Py_None;
  int nterms1 = 0;
  PyObject *nterms1_capi = Py_None;
  double *rscale2 = NULL;
  npy_intp rscale2_Dims[1] = {-1};
  const int rscale2_Rank = 1;
  PyArrayObject *capi_rscale2_tmp = NULL;
  int capi_rscale2_intent = 0;
  PyObject *rscale2_capi = Py_None;
  double *center2 = NULL;
  npy_intp center2_Dims[2] = {-1, -1};
  const int center2_Rank = 2;
  PyArrayObject *capi_center2_tmp = NULL;
  int capi_center2_intent = 0;
  PyObject *center2_capi = Py_None;
  complex_double *expn2 = NULL;
  npy_intp expn2_Dims[2] = {-1, -1};
  const int expn2_Rank = 2;
  PyArrayObject *capi_expn2_tmp = NULL;
  int capi_expn2_intent = 0;
  int nterms2 = 0;
  PyObject *nterms2_capi = Py_None;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"rscale1","center1","expn1","rscale2","center2","nterms2","nterms1","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOO|OO:_internal.l2dmpmp_vec",\
        capi_kwlist,&rscale1_capi,&center1_capi,&expn1_capi,&rscale2_capi,&center2_capi,&nterms2_capi,&nterms1_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale1 */
  ;
  capi_rscale1_intent |= F2PY_INTENT_IN;
  capi_rscale1_tmp = array_from_pyobj(NPY_DOUBLE,rscale1_Dims,rscale1_Rank,capi_rscale1_intent,rscale1_capi);
  if (capi_rscale1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 1st argument `rscale1' of _internal.l2dmpmp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale1 = (double *)(PyArray_DATA(capi_rscale1_tmp));

  /* Processing variable nterms2 */
    f2py_success = int_from_pyobj(&nterms2,nterms2_capi,"_internal.l2dmpmp_vec() 6th argument (nterms2) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = len(rscale1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.l2dmpmp_vec() 2nd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(rscale1)>=nvcount,"len(rscale1)>=nvcount","2nd keyword nvcount","l2dmpmp_vec:nvcount=%d",nvcount) {
  /* Processing variable center1 */
  center1_Dims[0]=2,center1_Dims[1]=nvcount;
  capi_center1_intent |= F2PY_INTENT_IN;
  capi_center1_tmp = array_from_pyobj(NPY_DOUBLE,center1_Dims,center1_Rank,capi_center1_intent,center1_capi);
  if (capi_center1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `center1' of _internal.l2dmpmp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center1 = (double *)(PyArray_DATA(capi_center1_tmp));

  /* Processing variable expn1 */
  expn1_Dims[1]=nvcount;
  capi_expn1_intent |= F2PY_INTENT_IN;
  capi_expn1_tmp = array_from_pyobj(NPY_CDOUBLE,expn1_Dims,expn1_Rank,capi_expn1_intent,expn1_capi);
  if (capi_expn1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `expn1' of _internal.l2dmpmp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn1 = (complex_double *)(PyArray_DATA(capi_expn1_tmp));

  /* Processing variable nterms1 */
  if (nterms1_capi == Py_None) nterms1 = (shape(expn1,0)-1); else
    f2py_success = int_from_pyobj(&nterms1,nterms1_capi,"_internal.l2dmpmp_vec() 1st keyword (nterms1) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((shape(expn1,0)-1)==nterms1,"(shape(expn1,0)-1)==nterms1","1st keyword nterms1","l2dmpmp_vec:nterms1=%d",nterms1) {
  /* Processing variable rscale2 */
  rscale2_Dims[0]=nvcount;
  capi_rscale2_intent |= F2PY_INTENT_IN;
  capi_rscale2_tmp = array_from_pyobj(NPY_DOUBLE,rscale2_Dims,rscale2_Rank,capi_rscale2_intent,rscale2_capi);
  if (capi_rscale2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `rscale2' of _internal.l2dmpmp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale2 = (double *)(PyArray_DATA(capi_rscale2_tmp));

  /* Processing variable center2 */
  center2_Dims[0]=2,center2_Dims[1]=nvcount;
  capi_center2_intent |= F2PY_INTENT_IN;
  capi_center2_tmp = array_from_pyobj(NPY_DOUBLE,center2_Dims,center2_Rank,capi_center2_intent,center2_capi);
  if (capi_center2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `center2' of _internal.l2dmpmp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center2 = (double *)(PyArray_DATA(capi_center2_tmp));

  /* Processing variable expn2 */
  expn2_Dims[0]=nterms2 + 1,expn2_Dims[1]=nvcount;
  capi_expn2_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn2_tmp = array_from_pyobj(NPY_CDOUBLE,expn2_Dims,expn2_Rank,capi_expn2_intent,Py_None);
  if (capi_expn2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn2' of _internal.l2dmpmp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn2 = (complex_double *)(PyArray_DATA(capi_expn2_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(rscale1,center1,expn1,&nterms1,rscale2,center2,expn2,&nterms2,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("N",capi_expn2_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_expn2_tmp == NULL) ... else of expn2*/
  /* End of cleaning variable expn2 */
  if((PyObject *)capi_center2_tmp!=center2_capi) {
    Py_XDECREF(capi_center2_tmp); }
  }  /*if (capi_center2_tmp == NULL) ... else of center2*/
  /* End of cleaning variable center2 */
  if((PyObject *)capi_rscale2_tmp!=rscale2_capi) {
    Py_XDECREF(capi_rscale2_tmp); }
  }  /*if (capi_rscale2_tmp == NULL) ... else of rscale2*/
  /* End of cleaning variable rscale2 */
  } /*CHECKSCALAR((shape(expn1,0)-1)==nterms1)*/
  } /*if (f2py_success) of nterms1*/
  /* End of cleaning variable nterms1 */
  if((PyObject *)capi_expn1_tmp!=expn1_capi) {
    Py_XDECREF(capi_expn1_tmp); }
  }  /*if (capi_expn1_tmp == NULL) ... else of expn1*/
  /* End of cleaning variable expn1 */
  if((PyObject *)capi_center1_tmp!=center1_capi) {
    Py_XDECREF(capi_center1_tmp); }
  }  /*if (capi_center1_tmp == NULL) ... else of center1*/
  /* End of cleaning variable center1 */
  } /*CHECKSCALAR(len(rscale1)>=nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  } /*if (f2py_success) of nterms2*/
  /* End of cleaning variable nterms2 */
  if((PyObject *)capi_rscale1_tmp!=rscale1_capi) {
    Py_XDECREF(capi_rscale1_tmp); }
  }  /*if (capi_rscale1_tmp == NULL) ... else of rscale1*/
  /* End of cleaning variable rscale1 */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/***************************** end of l2dmpmp_vec *****************************/

/******************************** l2dmploc_vec ********************************/
static char doc_f2py_rout__internal_l2dmploc_vec[] = "\
expn2 = l2dmploc_vec(rscale1,center1,expn1,rscale2,center2,nterms2,[nterms1,nvcount])\n\nWrapper for ``l2dmploc_vec``.\
\n\nParameters\n----------\n"
"rscale1 : input rank-1 array('d') with bounds (nvcount)\n"
"center1 : input rank-2 array('d') with bounds (2,nvcount)\n"
"expn1 : input rank-2 array('D') with bounds (nterms1 + 1,nvcount)\n"
"rscale2 : input rank-1 array('d') with bounds (nvcount)\n"
"center2 : input rank-2 array('d') with bounds (2,nvcount)\n"
"nterms2 : input int\n"
"\nOther Parameters\n----------------\n"
"nterms1 : input int, optional\n    Default: (shape(expn1,0)-1)\n"
"nvcount : input int, optional\n    Default: len(rscale1)\n"
"\nReturns\n-------\n"
"expn2 : rank-2 array('D') with bounds (nterms2 + 1,nvcount)";
/* extern void F_FUNC_US(l2dmploc_vec,L2DMPLOC_VEC)(double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,int*); */
static PyObject *f2py_rout__internal_l2dmploc_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double *rscale1 = NULL;
  npy_intp rscale1_Dims[1] = {-1};
  const int rscale1_Rank = 1;
  PyArrayObject *capi_rscale1_tmp = NULL;
  int capi_rscale1_intent = 0;
  PyObject *rscale1_capi = Py_None;
  double *center1 = NULL;
  npy_intp center1_Dims[2] = {-1, -1};
  const int center1_Rank = 2;
  PyArrayObject *capi_center1_tmp = NULL;
  int capi_center1_intent = 0;
  PyObject *center1_capi = Py_None;
  complex_double *expn1 = NULL;
  npy_intp expn1_Dims[2] = {-1, -1};
  const int expn1_Rank = 2;
  PyArrayObject *capi_expn1_tmp = NULL;
  int capi_expn1_intent = 0;
  PyObject *expn1_capi = Py_None;
  int nterms1 = 0;
  PyObject *nterms1_capi = Py_None;
  double *rscale2 = NULL;
  npy_intp rscale2_Dims[1] = {-1};
  const int rscale2_Rank = 1;
  PyArrayObject *capi_rscale2_tmp = NULL;
  int capi_rscale2_intent = 0;
  PyObject *rscale2_capi = Py_None;
  double *center2 = NULL;
  npy_intp center2_Dims[2] = {-1, -1};
  const int center2_Rank = 2;
  PyArrayObject *capi_center2_tmp = NULL;
  int capi_center2_intent = 0;
  PyObject *center2_capi = Py_None;
  complex_double *expn2 = NULL;
  npy_intp expn2_Dims[2] = {-1, -1};
  const int expn2_Rank = 2;
  PyArrayObject *capi_expn2_tmp = NULL;
  int capi_expn2_intent = 0;
  int nterms2 = 0;
  PyObject *nterms2_capi = Py_None;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"rscale1","center1","expn1","rscale2","center2","nterms2","nterms1","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOO|OO:_internal.l2dmploc_vec",\
        capi_kwlist,&rscale1_capi,&center1_capi,&expn1_capi,&rscale2_capi,&center2_capi,&nterms2_capi,&nterms1_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale1 */
  ;
  capi_rscale1_intent |= F2PY_INTENT_IN;
  capi_rscale1_tmp = array_from_pyobj(NPY_DOUBLE,rscale1_Dims,rscale1_Rank,capi_rscale1_intent,rscale1_capi);
  if (capi_rscale1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 1st argument `rscale1' of _internal.l2dmploc_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale1 = (double *)(PyArray_DATA(capi_rscale1_tmp));

  /* Processing variable nterms2 */
    f2py_success = int_from_pyobj(&nterms2,nterms2_capi,"_internal.l2dmploc_vec() 6th argument (nterms2) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = len(rscale1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.l2dmploc_vec() 2nd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(rscale1)>=nvcount,"len(rscale1)>=nvcount","2nd keyword nvcount","l2dmploc_vec:nvcount=%d",nvcount) {
  /* Processing variable center1 */
  center1_Dims[0]=2,center1_Dims[1]=nvcount;
  capi_center1_intent |= F2PY_INTENT_IN;
  capi_center1_tmp = array_from_pyobj(NPY_DOUBLE,center1_Dims,center1_Rank,capi_center1_intent,center1_capi);
  if (capi_center1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `center1' of _internal.l2dmploc_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center1 = (double *)(PyArray_DATA(capi_center1_tmp));

  /* Processing variable expn1 */
  expn1_Dims[1]=nvcount;
  capi_expn1_intent |= F2PY_INTENT_IN;
  capi_expn1_tmp = array_from_pyobj(NPY_CDOUBLE,expn1_Dims,expn1_Rank,capi_expn1_intent,expn1_capi);
  if (capi_expn1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `expn1' of _internal.l2dmploc_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn1 = (complex_double *)(PyArray_DATA(capi_expn1_tmp));

  /* Processing variable nterms1 */
  if (nterms1_capi == Py_None) nterms1 = (shape(expn1,0)-1); else
    f2py_success = int_from_pyobj(&nterms1,nterms1_capi,"_internal.l2dmploc_vec() 1st keyword (nterms1) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((shape(expn1,0)-1)==nterms1,"(shape(expn1,0)-1)==nterms1","1st keyword nterms1","l2dmploc_vec:nterms1=%d",nterms1) {
  /* Processing variable rscale2 */
  rscale2_Dims[0]=nvcount;
  capi_rscale2_intent |= F2PY_INTENT_IN;
  capi_rscale2_tmp = array_from_pyobj(NPY_DOUBLE,rscale2_Dims,rscale2_Rank,capi_rscale2_intent,rscale2_capi);
  if (capi_rscale2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `rscale2' of _internal.l2dmploc_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale2 = (double *)(PyArray_DATA(capi_rscale2_tmp));

  /* Processing variable center2 */
  center2_Dims[0]=2,center2_Dims[1]=nvcount;
  capi_center2_intent |= F2PY_INTENT_IN;
  capi_center2_tmp = array_from_pyobj(NPY_DOUBLE,center2_Dims,center2_Rank,capi_center2_intent,center2_capi);
  if (capi_center2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `center2' of _internal.l2dmploc_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center2 = (double *)(PyArray_DATA(capi_center2_tmp));

  /* Processing variable expn2 */
  expn2_Dims[0]=nterms2 + 1,expn2_Dims[1]=nvcount;
  capi_expn2_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn2_tmp = array_from_pyobj(NPY_CDOUBLE,expn2_Dims,expn2_Rank,capi_expn2_intent,Py_None);
  if (capi_expn2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn2' of _internal.l2dmploc_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn2 = (complex_double *)(PyArray_DATA(capi_expn2_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(rscale1,center1,expn1,&nterms1,rscale2,center2,expn2,&nterms2,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("N",capi_expn2_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_expn2_tmp == NULL) ... else of expn2*/
  /* End of cleaning variable expn2 */
  if((PyObject *)capi_center2_tmp!=center2_capi) {
    Py_XDECREF(capi_center2_tmp); }
  }  /*if (capi_center2_tmp == NULL) ... else of center2*/
  /* End of cleaning variable center2 */
  if((PyObject *)capi_rscale2_tmp!=rscale2_capi) {
    Py_XDECREF(capi_rscale2_tmp); }
  }  /*if (capi_rscale2_tmp == NULL) ... else of rscale2*/
  /* End of cleaning variable rscale2 */
  } /*CHECKSCALAR((shape(expn1,0)-1)==nterms1)*/
  } /*if (f2py_success) of nterms1*/
  /* End of cleaning variable nterms1 */
  if((PyObject *)capi_expn1_tmp!=expn1_capi) {
    Py_XDECREF(capi_expn1_tmp); }
  }  /*if (capi_expn1_tmp == NULL) ... else of expn1*/
  /* End of cleaning variable expn1 */
  if((PyObject *)capi_center1_tmp!=center1_capi) {
    Py_XDECREF(capi_center1_tmp); }
  }  /*if (capi_center1_tmp == NULL) ... else of center1*/
  /* End of cleaning variable center1 */
  } /*CHECKSCALAR(len(rscale1)>=nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  } /*if (f2py_success) of nterms2*/
  /* End of cleaning variable nterms2 */
  if((PyObject *)capi_rscale1_tmp!=rscale1_capi) {
    Py_XDECREF(capi_rscale1_tmp); }
  }  /*if (capi_rscale1_tmp == NULL) ... else of rscale1*/
  /* End of cleaning variable rscale1 */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/**************************** end of l2dmploc_vec ****************************/

/******************************* l2dlocloc_vec *******************************/
static char doc_f2py_rout__internal_l2dlocloc_vec[] = "\
expn2 = l2dlocloc_vec(rscale1,center1,expn1,rscale2,center2,nterms2,[nterms1,nvcount])\n\nWrapper for ``l2dlocloc_vec``.\
\n\nParameters\n----------\n"
"rscale1 : input rank-1 array('d') with bounds (nvcount)\n"
"center1 : input rank-2 array('d') with bounds (2,nvcount)\n"
"expn1 : input rank-2 array('D') with bounds (nterms1 + 1,nvcount)\n"
"rscale2 : input rank-1 array('d') with bounds (nvcount)\n"
"center2 : input rank-2 array('d') with bounds (2,nvcount)\n"
"nterms2 : input int\n"
"\nOther Parameters\n----------------\n"
"nterms1 : input int, optional\n    Default: (shape(expn1,0)-1)\n"
"nvcount : input int, optional\n    Default: len(rscale1)\n"
"\nReturns\n-------\n"
"expn2 : rank-2 array('D') with bounds (nterms2 + 1,nvcount)";
/* extern void F_FUNC_US(l2dlocloc_vec,L2DLOCLOC_VEC)(double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,int*); */
static PyObject *f2py_rout__internal_l2dlocloc_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double *rscale1 = NULL;
  npy_intp rscale1_Dims[1] = {-1};
  const int rscale1_Rank = 1;
  PyArrayObject *capi_rscale1_tmp = NULL;
  int capi_rscale1_intent = 0;
  PyObject *rscale1_capi = Py_None;
  double *center1 = NULL;
  npy_intp center1_Dims[2] = {-1, -1};
  const int center1_Rank = 2;
  PyArrayObject *capi_center1_tmp = NULL;
  int capi_center1_intent = 0;
  PyObject *center1_capi = Py_None;
  complex_double *expn1 = NULL;
  npy_intp expn1_Dims[2] = {-1, -1};
  const int expn1_Rank = 2;
  PyArrayObject *capi_expn1_tmp = NULL;
  int capi_expn1_intent = 0;
  PyObject *expn1_capi = Py_None;
  int nterms1 = 0;
  PyObject *nterms1_capi = Py_None;
  double *rscale2 = NULL;
  npy_intp rscale2_Dims[1] = {-1};
  const int rscale2_Rank = 1;
  PyArrayObject *capi_rscale2_tmp = NULL;
  int capi_rscale2_intent = 0;
  PyObject *rscale2_capi = Py_None;
  double *center2 = NULL;
  npy_intp center2_Dims[2] = {-1, -1};
  const int center2_Rank = 2;
  PyArrayObject *capi_center2_tmp = NULL;
  int capi_center2_intent = 0;
  PyObject *center2_capi = Py_None;
  complex_double *expn2 = NULL;
  npy_intp expn2_Dims[2] = {-1, -1};
  const int expn2_Rank = 2;
  PyArrayObject *capi_expn2_tmp = NULL;
  int capi_expn2_intent = 0;
  int nterms2 = 0;
  PyObject *nterms2_capi = Py_None;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"rscale1","center1","expn1","rscale2","center2","nterms2","nterms1","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOO|OO:_internal.l2dlocloc_vec",\
        capi_kwlist,&rscale1_capi,&center1_capi,&expn1_capi,&rscale2_capi,&center2_capi,&nterms2_capi,&nterms1_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale1 */
  ;
  capi_rscale1_intent |= F2PY_INTENT_IN;
  capi_rscale1_tmp = array_from_pyobj(NPY_DOUBLE,rscale1_Dims,rscale1_Rank,capi_rscale1_intent,rscale1_capi);
  if (capi_rscale1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 1st argument `rscale1' of _internal.l2dlocloc_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale1 = (double *)(PyArray_DATA(capi_rscale1_tmp));

  /* Processing variable nterms2 */
    f2py_success = int_from_pyobj(&nterms2,nterms2_capi,"_internal.l2dlocloc_vec() 6th argument (nterms2) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = len(rscale1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.l2dlocloc_vec() 2nd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(rscale1)>=nvcount,"len(rscale1)>=nvcount","2nd keyword nvcount","l2dlocloc_vec:nvcount=%d",nvcount) {
  /* Processing variable center1 */
  center1_Dims[0]=2,center1_Dims[1]=nvcount;
  capi_center1_intent |= F2PY_INTENT_IN;
  capi_center1_tmp = array_from_pyobj(NPY_DOUBLE,center1_Dims,center1_Rank,capi_center1_intent,center1_capi);
  if (capi_center1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `center1' of _internal.l2dlocloc_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center1 = (double *)(PyArray_DATA(capi_center1_tmp));

  /* Processing variable expn1 */
  expn1_Dims[1]=nvcount;
  capi_expn1_intent |= F2PY_INTENT_IN;
  capi_expn1_tmp = array_from_pyobj(NPY_CDOUBLE,expn1_Dims,expn1_Rank,capi_expn1_intent,expn1_capi);
  if (capi_expn1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `expn1' of _internal.l2dlocloc_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn1 = (complex_double *)(PyArray_DATA(capi_expn1_tmp));

  /* Processing variable nterms1 */
  if (nterms1_capi == Py_None) nterms1 = (shape(expn1,0)-1); else
    f2py_success = int_from_pyobj(&nterms1,nterms1_capi,"_internal.l2dlocloc_vec() 1st keyword (nterms1) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((shape(expn1,0)-1)==nterms1,"(shape(expn1,0)-1)==nterms1","1st keyword nterms1","l2dlocloc_vec:nterms1=%d",nterms1) {
  /* Processing variable rscale2 */
  rscale2_Dims[0]=nvcount;
  capi_rscale2_intent |= F2PY_INTENT_IN;
  capi_rscale2_tmp = array_from_pyobj(NPY_DOUBLE,rscale2_Dims,rscale2_Rank,capi_rscale2_intent,rscale2_capi);
  if (capi_rscale2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `rscale2' of _internal.l2dlocloc_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale2 = (double *)(PyArray_DATA(capi_rscale2_tmp));

  /* Processing variable center2 */
  center2_Dims[0]=2,center2_Dims[1]=nvcount;
  capi_center2_intent |= F2PY_INTENT_IN;
  capi_center2_tmp = array_from_pyobj(NPY_DOUBLE,center2_Dims,center2_Rank,capi_center2_intent,center2_capi);
  if (capi_center2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `center2' of _internal.l2dlocloc_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center2 = (double *)(PyArray_DATA(capi_center2_tmp));

  /* Processing variable expn2 */
  expn2_Dims[0]=nterms2 + 1,expn2_Dims[1]=nvcount;
  capi_expn2_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn2_tmp = array_from_pyobj(NPY_CDOUBLE,expn2_Dims,expn2_Rank,capi_expn2_intent,Py_None);
  if (capi_expn2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn2' of _internal.l2dlocloc_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn2 = (complex_double *)(PyArray_DATA(capi_expn2_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(rscale1,center1,expn1,&nterms1,rscale2,center2,expn2,&nterms2,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("N",capi_expn2_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_expn2_tmp == NULL) ... else of expn2*/
  /* End of cleaning variable expn2 */
  if((PyObject *)capi_center2_tmp!=center2_capi) {
    Py_XDECREF(capi_center2_tmp); }
  }  /*if (capi_center2_tmp == NULL) ... else of center2*/
  /* End of cleaning variable center2 */
  if((PyObject *)capi_rscale2_tmp!=rscale2_capi) {
    Py_XDECREF(capi_rscale2_tmp); }
  }  /*if (capi_rscale2_tmp == NULL) ... else of rscale2*/
  /* End of cleaning variable rscale2 */
  } /*CHECKSCALAR((shape(expn1,0)-1)==nterms1)*/
  } /*if (f2py_success) of nterms1*/
  /* End of cleaning variable nterms1 */
  if((PyObject *)capi_expn1_tmp!=expn1_capi) {
    Py_XDECREF(capi_expn1_tmp); }
  }  /*if (capi_expn1_tmp == NULL) ... else of expn1*/
  /* End of cleaning variable expn1 */
  if((PyObject *)capi_center1_tmp!=center1_capi) {
    Py_XDECREF(capi_center1_tmp); }
  }  /*if (capi_center1_tmp == NULL) ... else of center1*/
  /* End of cleaning variable center1 */
  } /*CHECKSCALAR(len(rscale1)>=nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  } /*if (f2py_success) of nterms2*/
  /* End of cleaning variable nterms2 */
  if((PyObject *)capi_rscale1_tmp!=rscale1_capi) {
    Py_XDECREF(capi_rscale1_tmp); }
  }  /*if (capi_rscale1_tmp == NULL) ... else of rscale1*/
  /* End of cleaning variable rscale1 */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/**************************** end of l2dlocloc_vec ****************************/

/******************************** h2dmpmp_vec ********************************/
static char doc_f2py_rout__internal_h2dmpmp_vec[] = "\
expn2 = h2dmpmp_vec(zk,rscale1,center1,expn1,rscale2,center2,nterms2,[nterms1,nvcount])\n\nWrapper for ``h2dmpmp_vec``.\
\n\nParameters\n----------\n"
"zk : input complex\n"
"rscale1 : input rank-1 array('d') with bounds (nvcount)\n"
"center1 : input rank-2 array('d') with bounds (2,nvcount)\n"
"expn1 : input rank-2 array('D') with bounds (2 * nterms1 + 1,nvcount)\n"
"rscale2 : input rank-1 array('d') with bounds (nvcount)\n"
"center2 : input rank-2 array('d') with bounds (2,nvcount)\n"
"nterms2 : input int\n"
"\nOther Parameters\n----------------\n"
"nterms1 : input int, optional\n    Default: (shape(expn1,0)-1)/(2)\n"
"nvcount : input int, optional\n    Default: len(rscale1)\n"
"\nReturns\n-------\n"
"expn2 : rank-2 array('D') with bounds (2 * nterms2 + 1,nvcount)";
/* extern void F_FUNC_US(h2dmpmp_vec,H2DMPMP_VEC)(complex_double*,double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,int*); */
static PyObject *f2py_rout__internal_h2dmpmp_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(complex_double*,double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  complex_double zk;
  PyObject *zk_capi = Py_None;
  double *rscale1 = NULL;
  npy_intp rscale1_Dims[1] = {-1};
  const int rscale1_Rank = 1;
  PyArrayObject *capi_rscale1_tmp = NULL;
  int capi_rscale1_intent = 0;
  PyObject *rscale1_capi = Py_None;
  double *center1 = NULL;
  npy_intp center1_Dims[2] = {-1, -1};
  const int center1_Rank = 2;
  PyArrayObject *capi_center1_tmp = NULL;
  int capi_center1_intent = 0;
  PyObject *center1_capi = Py_None;
  complex_double *expn1 = NULL;
  npy_intp expn1_Dims[2] = {-1, -1};
  const int expn1_Rank = 2;
  PyArrayObject *capi_expn1_tmp = NULL;
  int capi_expn1_intent = 0;
  PyObject *expn1_capi = Py_None;
  int nterms1 = 0;
  PyObject *nterms1_capi = Py_None;
  double *rscale2 = NULL;
  npy_intp rscale2_Dims[1] = {-1};
  const int rscale2_Rank = 1;
  PyArrayObject *capi_rscale2_tmp = NULL;
  int capi_rscale2_intent = 0;
  PyObject *rscale2_capi = Py_None;
  double *center2 = NULL;
  npy_intp center2_Dims[2] = {-1, -1};
  const int center2_Rank = 2;
  PyArrayObject *capi_center2_tmp = NULL;
  int capi_center2_intent = 0;
  PyObject *center2_capi = Py_None;
  complex_double *expn2 = NULL;
  npy_intp expn2_Dims[2] = {-1, -1};
  const int expn2_Rank = 2;
  PyArrayObject *capi_expn2_tmp = NULL;
  int capi_expn2_intent = 0;
  int nterms2 = 0;
  PyObject *nterms2_capi = Py_None;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"zk","rscale1","center1","expn1","rscale2","center2","nterms2","nterms1","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOO|OO:_internal.h2dmpmp_vec",\
        capi_kwlist,&zk_capi,&rscale1_capi,&center1_capi,&expn1_capi,&rscale2_capi,&center2_capi,&nterms2_capi,&nterms1_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.h2dmpmp_vec() 1st argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable rscale1 */
  ;
  capi_rscale1_intent |= F2PY_INTENT_IN;
  capi_rscale1_tmp = array_from_pyobj(NPY_DOUBLE,rscale1_Dims,rscale1_Rank,capi_rscale1_intent,rscale1_capi);
  if (capi_rscale1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `rscale1' of _internal.h2dmpmp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale1 = (double *)(PyArray_DATA(capi_rscale1_tmp));

  /* Processing variable nterms2 */
    f2py_success = int_from_pyobj(&nterms2,nterms2_capi,"_internal.h2dmpmp_vec() 7th argument (nterms2) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = len(rscale1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.h2dmpmp_vec() 2nd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(rscale1)>=nvcount,"len(rscale1)>=nvcount","2nd keyword nvcount","h2dmpmp_vec:nvcount=%d",nvcount) {
  /* Processing variable center1 */
  center1_Dims[0]=2,center1_Dims[1]=nvcount;
  capi_center1_intent |= F2PY_INTENT_IN;
  capi_center1_tmp = array_from_pyobj(NPY_DOUBLE,center1_Dims,center1_Rank,capi_center1_intent,center1_capi);
  if (capi_center1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `center1' of _internal.h2dmpmp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center1 = (double *)(PyArray_DATA(capi_center1_tmp));

  /* Processing variable expn1 */
  expn1_Dims[1]=nvcount;
  capi_expn1_intent |= F2PY_INTENT_IN;
  capi_expn1_tmp = array_from_pyobj(NPY_CDOUBLE,expn1_Dims,expn1_Rank,capi_expn1_intent,expn1_capi);
  if (capi_expn1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `expn1' of _internal.h2dmpmp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn1 = (complex_double *)(PyArray_DATA(capi_expn1_tmp));

  /* Processing variable nterms1 */
  if (nterms1_capi == Py_None) nterms1 = (shape(expn1,0)-1)/(2); else
    f2py_success = int_from_pyobj(&nterms1,nterms1_capi,"_internal.h2dmpmp_vec() 1st keyword (nterms1) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((shape(expn1,0)-1)/(2)==nterms1,"(shape(expn1,0)-1)/(2)==nterms1","1st keyword nterms1","h2dmpmp_vec:nterms1=%d",nterms1) {
  /* Processing variable rscale2 */
  rscale2_Dims[0]=nvcount;
  capi_rscale2_intent |= F2PY_INTENT_IN;
  capi_rscale2_tmp = array_from_pyobj(NPY_DOUBLE,rscale2_Dims,rscale2_Rank,capi_rscale2_intent,rscale2_capi);
  if (capi_rscale2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `rscale2' of _internal.h2dmpmp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale2 = (double *)(PyArray_DATA(capi_rscale2_tmp));

  /* Processing variable center2 */
  center2_Dims[0]=2,center2_Dims[1]=nvcount;
  capi_center2_intent |= F2PY_INTENT_IN;
  capi_center2_tmp = array_from_pyobj(NPY_DOUBLE,center2_Dims,center2_Rank,capi_center2_intent,center2_capi);
  if (capi_center2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `center2' of _internal.h2dmpmp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center2 = (double *)(PyArray_DATA(capi_center2_tmp));

  /* Processing variable expn2 */
  expn2_Dims[0]=2 * nterms2 + 1,expn2_Dims[1]=nvcount;
  capi_expn2_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn2_tmp = array_from_pyobj(NPY_CDOUBLE,expn2_Dims,expn2_Rank,capi_expn2_intent,Py_None);
  if (capi_expn2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn2' of _internal.h2dmpmp_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn2 = (complex_double *)(PyArray_DATA(capi_expn2_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&zk,rscale1,center1,expn1,&nterms1,rscale2,center2,expn2,&nterms2,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("N",capi_expn2_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_expn2_tmp == NULL) ... else of expn2*/
  /* End of cleaning variable expn2 */
  if((PyObject *)capi_center2_tmp!=center2_capi) {
    Py_XDECREF(capi_center2_tmp); }
  }  /*if (capi_center2_tmp == NULL) ... else of center2*/
  /* End of cleaning variable center2 */
  if((PyObject *)capi_rscale2_tmp!=rscale2_capi) {
    Py_XDECREF(capi_rscale2_tmp); }
  }  /*if (capi_rscale2_tmp == NULL) ... else of rscale2*/
  /* End of cleaning variable rscale2 */
  } /*CHECKSCALAR((shape(expn1,0)-1)/(2)==nterms1)*/
  } /*if (f2py_success) of nterms1*/
  /* End of cleaning variable nterms1 */
  if((PyObject *)capi_expn1_tmp!=expn1_capi) {
    Py_XDECREF(capi_expn1_tmp); }
  }  /*if (capi_expn1_tmp == NULL) ... else of expn1*/
  /* End of cleaning variable expn1 */
  if((PyObject *)capi_center1_tmp!=center1_capi) {
    Py_XDECREF(capi_center1_tmp); }
  }  /*if (capi_center1_tmp == NULL) ... else of center1*/
  /* End of cleaning variable center1 */
  } /*CHECKSCALAR(len(rscale1)>=nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  } /*if (f2py_success) of nterms2*/
  /* End of cleaning variable nterms2 */
  if((PyObject *)capi_rscale1_tmp!=rscale1_capi) {
    Py_XDECREF(capi_rscale1_tmp); }
  }  /*if (capi_rscale1_tmp == NULL) ... else of rscale1*/
  /* End of cleaning variable rscale1 */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/***************************** end of h2dmpmp_vec *****************************/

/******************************** h2dmploc_vec ********************************/
static char doc_f2py_rout__internal_h2dmploc_vec[] = "\
expn2 = h2dmploc_vec(zk,rscale1,center1,expn1,rscale2,center2,nterms2,[nterms1,nvcount])\n\nWrapper for ``h2dmploc_vec``.\
\n\nParameters\n----------\n"
"zk : input complex\n"
"rscale1 : input rank-1 array('d') with bounds (nvcount)\n"
"center1 : input rank-2 array('d') with bounds (2,nvcount)\n"
"expn1 : input rank-2 array('D') with bounds (2 * nterms1 + 1,nvcount)\n"
"rscale2 : input rank-1 array('d') with bounds (nvcount)\n"
"center2 : input rank-2 array('d') with bounds (2,nvcount)\n"
"nterms2 : input int\n"
"\nOther Parameters\n----------------\n"
"nterms1 : input int, optional\n    Default: (shape(expn1,0)-1)/(2)\n"
"nvcount : input int, optional\n    Default: len(rscale1)\n"
"\nReturns\n-------\n"
"expn2 : rank-2 array('D') with bounds (2 * nterms2 + 1,nvcount)";
/* extern void F_FUNC_US(h2dmploc_vec,H2DMPLOC_VEC)(complex_double*,double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,int*); */
static PyObject *f2py_rout__internal_h2dmploc_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(complex_double*,double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  complex_double zk;
  PyObject *zk_capi = Py_None;
  double *rscale1 = NULL;
  npy_intp rscale1_Dims[1] = {-1};
  const int rscale1_Rank = 1;
  PyArrayObject *capi_rscale1_tmp = NULL;
  int capi_rscale1_intent = 0;
  PyObject *rscale1_capi = Py_None;
  double *center1 = NULL;
  npy_intp center1_Dims[2] = {-1, -1};
  const int center1_Rank = 2;
  PyArrayObject *capi_center1_tmp = NULL;
  int capi_center1_intent = 0;
  PyObject *center1_capi = Py_None;
  complex_double *expn1 = NULL;
  npy_intp expn1_Dims[2] = {-1, -1};
  const int expn1_Rank = 2;
  PyArrayObject *capi_expn1_tmp = NULL;
  int capi_expn1_intent = 0;
  PyObject *expn1_capi = Py_None;
  int nterms1 = 0;
  PyObject *nterms1_capi = Py_None;
  double *rscale2 = NULL;
  npy_intp rscale2_Dims[1] = {-1};
  const int rscale2_Rank = 1;
  PyArrayObject *capi_rscale2_tmp = NULL;
  int capi_rscale2_intent = 0;
  PyObject *rscale2_capi = Py_None;
  double *center2 = NULL;
  npy_intp center2_Dims[2] = {-1, -1};
  const int center2_Rank = 2;
  PyArrayObject *capi_center2_tmp = NULL;
  int capi_center2_intent = 0;
  PyObject *center2_capi = Py_None;
  complex_double *expn2 = NULL;
  npy_intp expn2_Dims[2] = {-1, -1};
  const int expn2_Rank = 2;
  PyArrayObject *capi_expn2_tmp = NULL;
  int capi_expn2_intent = 0;
  int nterms2 = 0;
  PyObject *nterms2_capi = Py_None;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"zk","rscale1","center1","expn1","rscale2","center2","nterms2","nterms1","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOO|OO:_internal.h2dmploc_vec",\
        capi_kwlist,&zk_capi,&rscale1_capi,&center1_capi,&expn1_capi,&rscale2_capi,&center2_capi,&nterms2_capi,&nterms1_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.h2dmploc_vec() 1st argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable rscale1 */
  ;
  capi_rscale1_intent |= F2PY_INTENT_IN;
  capi_rscale1_tmp = array_from_pyobj(NPY_DOUBLE,rscale1_Dims,rscale1_Rank,capi_rscale1_intent,rscale1_capi);
  if (capi_rscale1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `rscale1' of _internal.h2dmploc_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale1 = (double *)(PyArray_DATA(capi_rscale1_tmp));

  /* Processing variable nterms2 */
    f2py_success = int_from_pyobj(&nterms2,nterms2_capi,"_internal.h2dmploc_vec() 7th argument (nterms2) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = len(rscale1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.h2dmploc_vec() 2nd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(rscale1)>=nvcount,"len(rscale1)>=nvcount","2nd keyword nvcount","h2dmploc_vec:nvcount=%d",nvcount) {
  /* Processing variable center1 */
  center1_Dims[0]=2,center1_Dims[1]=nvcount;
  capi_center1_intent |= F2PY_INTENT_IN;
  capi_center1_tmp = array_from_pyobj(NPY_DOUBLE,center1_Dims,center1_Rank,capi_center1_intent,center1_capi);
  if (capi_center1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `center1' of _internal.h2dmploc_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center1 = (double *)(PyArray_DATA(capi_center1_tmp));

  /* Processing variable expn1 */
  expn1_Dims[1]=nvcount;
  capi_expn1_intent |= F2PY_INTENT_IN;
  capi_expn1_tmp = array_from_pyobj(NPY_CDOUBLE,expn1_Dims,expn1_Rank,capi_expn1_intent,expn1_capi);
  if (capi_expn1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `expn1' of _internal.h2dmploc_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn1 = (complex_double *)(PyArray_DATA(capi_expn1_tmp));

  /* Processing variable nterms1 */
  if (nterms1_capi == Py_None) nterms1 = (shape(expn1,0)-1)/(2); else
    f2py_success = int_from_pyobj(&nterms1,nterms1_capi,"_internal.h2dmploc_vec() 1st keyword (nterms1) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((shape(expn1,0)-1)/(2)==nterms1,"(shape(expn1,0)-1)/(2)==nterms1","1st keyword nterms1","h2dmploc_vec:nterms1=%d",nterms1) {
  /* Processing variable rscale2 */
  rscale2_Dims[0]=nvcount;
  capi_rscale2_intent |= F2PY_INTENT_IN;
  capi_rscale2_tmp = array_from_pyobj(NPY_DOUBLE,rscale2_Dims,rscale2_Rank,capi_rscale2_intent,rscale2_capi);
  if (capi_rscale2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `rscale2' of _internal.h2dmploc_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale2 = (double *)(PyArray_DATA(capi_rscale2_tmp));

  /* Processing variable center2 */
  center2_Dims[0]=2,center2_Dims[1]=nvcount;
  capi_center2_intent |= F2PY_INTENT_IN;
  capi_center2_tmp = array_from_pyobj(NPY_DOUBLE,center2_Dims,center2_Rank,capi_center2_intent,center2_capi);
  if (capi_center2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `center2' of _internal.h2dmploc_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center2 = (double *)(PyArray_DATA(capi_center2_tmp));

  /* Processing variable expn2 */
  expn2_Dims[0]=2 * nterms2 + 1,expn2_Dims[1]=nvcount;
  capi_expn2_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn2_tmp = array_from_pyobj(NPY_CDOUBLE,expn2_Dims,expn2_Rank,capi_expn2_intent,Py_None);
  if (capi_expn2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn2' of _internal.h2dmploc_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn2 = (complex_double *)(PyArray_DATA(capi_expn2_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&zk,rscale1,center1,expn1,&nterms1,rscale2,center2,expn2,&nterms2,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("N",capi_expn2_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_expn2_tmp == NULL) ... else of expn2*/
  /* End of cleaning variable expn2 */
  if((PyObject *)capi_center2_tmp!=center2_capi) {
    Py_XDECREF(capi_center2_tmp); }
  }  /*if (capi_center2_tmp == NULL) ... else of center2*/
  /* End of cleaning variable center2 */
  if((PyObject *)capi_rscale2_tmp!=rscale2_capi) {
    Py_XDECREF(capi_rscale2_tmp); }
  }  /*if (capi_rscale2_tmp == NULL) ... else of rscale2*/
  /* End of cleaning variable rscale2 */
  } /*CHECKSCALAR((shape(expn1,0)-1)/(2)==nterms1)*/
  } /*if (f2py_success) of nterms1*/
  /* End of cleaning variable nterms1 */
  if((PyObject *)capi_expn1_tmp!=expn1_capi) {
    Py_XDECREF(capi_expn1_tmp); }
  }  /*if (capi_expn1_tmp == NULL) ... else of expn1*/
  /* End of cleaning variable expn1 */
  if((PyObject *)capi_center1_tmp!=center1_capi) {
    Py_XDECREF(capi_center1_tmp); }
  }  /*if (capi_center1_tmp == NULL) ... else of center1*/
  /* End of cleaning variable center1 */
  } /*CHECKSCALAR(len(rscale1)>=nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  } /*if (f2py_success) of nterms2*/
  /* End of cleaning variable nterms2 */
  if((PyObject *)capi_rscale1_tmp!=rscale1_capi) {
    Py_XDECREF(capi_rscale1_tmp); }
  }  /*if (capi_rscale1_tmp == NULL) ... else of rscale1*/
  /* End of cleaning variable rscale1 */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/**************************** end of h2dmploc_vec ****************************/

/******************************* h2dlocloc_vec *******************************/
static char doc_f2py_rout__internal_h2dlocloc_vec[] = "\
expn2 = h2dlocloc_vec(zk,rscale1,center1,expn1,rscale2,center2,nterms2,[nterms1,nvcount])\n\nWrapper for ``h2dlocloc_vec``.\
\n\nParameters\n----------\n"
"zk : input complex\n"
"rscale1 : input rank-1 array('d') with bounds (nvcount)\n"
"center1 : input rank-2 array('d') with bounds (2,nvcount)\n"
"expn1 : input rank-2 array('D') with bounds (2 * nterms1 + 1,nvcount)\n"
"rscale2 : input rank-1 array('d') with bounds (nvcount)\n"
"center2 : input rank-2 array('d') with bounds (2,nvcount)\n"
"nterms2 : input int\n"
"\nOther Parameters\n----------------\n"
"nterms1 : input int, optional\n    Default: (shape(expn1,0)-1)/(2)\n"
"nvcount : input int, optional\n    Default: len(rscale1)\n"
"\nReturns\n-------\n"
"expn2 : rank-2 array('D') with bounds (2 * nterms2 + 1,nvcount)";
/* extern void F_FUNC_US(h2dlocloc_vec,H2DLOCLOC_VEC)(complex_double*,double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,int*); */
static PyObject *f2py_rout__internal_h2dlocloc_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(complex_double*,double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  complex_double zk;
  PyObject *zk_capi = Py_None;
  double *rscale1 = NULL;
  npy_intp rscale1_Dims[1] = {-1};
  const int rscale1_Rank = 1;
  PyArrayObject *capi_rscale1_tmp = NULL;
  int capi_rscale1_intent = 0;
  PyObject *rscale1_capi = Py_None;
  double *center1 = NULL;
  npy_intp center1_Dims[2] = {-1, -1};
  const int center1_Rank = 2;
  PyArrayObject *capi_center1_tmp = NULL;
  int capi_center1_intent = 0;
  PyObject *center1_capi = Py_None;
  complex_double *expn1 = NULL;
  npy_intp expn1_Dims[2] = {-1, -1};
  const int expn1_Rank = 2;
  PyArrayObject *capi_expn1_tmp = NULL;
  int capi_expn1_intent = 0;
  PyObject *expn1_capi = Py_None;
  int nterms1 = 0;
  PyObject *nterms1_capi = Py_None;
  double *rscale2 = NULL;
  npy_intp rscale2_Dims[1] = {-1};
  const int rscale2_Rank = 1;
  PyArrayObject *capi_rscale2_tmp = NULL;
  int capi_rscale2_intent = 0;
  PyObject *rscale2_capi = Py_None;
  double *center2 = NULL;
  npy_intp center2_Dims[2] = {-1, -1};
  const int center2_Rank = 2;
  PyArrayObject *capi_center2_tmp = NULL;
  int capi_center2_intent = 0;
  PyObject *center2_capi = Py_None;
  complex_double *expn2 = NULL;
  npy_intp expn2_Dims[2] = {-1, -1};
  const int expn2_Rank = 2;
  PyArrayObject *capi_expn2_tmp = NULL;
  int capi_expn2_intent = 0;
  int nterms2 = 0;
  PyObject *nterms2_capi = Py_None;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"zk","rscale1","center1","expn1","rscale2","center2","nterms2","nterms1","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOO|OO:_internal.h2dlocloc_vec",\
        capi_kwlist,&zk_capi,&rscale1_capi,&center1_capi,&expn1_capi,&rscale2_capi,&center2_capi,&nterms2_capi,&nterms1_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.h2dlocloc_vec() 1st argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable rscale1 */
  ;
  capi_rscale1_intent |= F2PY_INTENT_IN;
  capi_rscale1_tmp = array_from_pyobj(NPY_DOUBLE,rscale1_Dims,rscale1_Rank,capi_rscale1_intent,rscale1_capi);
  if (capi_rscale1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `rscale1' of _internal.h2dlocloc_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale1 = (double *)(PyArray_DATA(capi_rscale1_tmp));

  /* Processing variable nterms2 */
    f2py_success = int_from_pyobj(&nterms2,nterms2_capi,"_internal.h2dlocloc_vec() 7th argument (nterms2) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = len(rscale1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.h2dlocloc_vec() 2nd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(rscale1)>=nvcount,"len(rscale1)>=nvcount","2nd keyword nvcount","h2dlocloc_vec:nvcount=%d",nvcount) {
  /* Processing variable center1 */
  center1_Dims[0]=2,center1_Dims[1]=nvcount;
  capi_center1_intent |= F2PY_INTENT_IN;
  capi_center1_tmp = array_from_pyobj(NPY_DOUBLE,center1_Dims,center1_Rank,capi_center1_intent,center1_capi);
  if (capi_center1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `center1' of _internal.h2dlocloc_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center1 = (double *)(PyArray_DATA(capi_center1_tmp));

  /* Processing variable expn1 */
  expn1_Dims[1]=nvcount;
  capi_expn1_intent |= F2PY_INTENT_IN;
  capi_expn1_tmp = array_from_pyobj(NPY_CDOUBLE,expn1_Dims,expn1_Rank,capi_expn1_intent,expn1_capi);
  if (capi_expn1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `expn1' of _internal.h2dlocloc_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn1 = (complex_double *)(PyArray_DATA(capi_expn1_tmp));

  /* Processing variable nterms1 */
  if (nterms1_capi == Py_None) nterms1 = (shape(expn1,0)-1)/(2); else
    f2py_success = int_from_pyobj(&nterms1,nterms1_capi,"_internal.h2dlocloc_vec() 1st keyword (nterms1) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((shape(expn1,0)-1)/(2)==nterms1,"(shape(expn1,0)-1)/(2)==nterms1","1st keyword nterms1","h2dlocloc_vec:nterms1=%d",nterms1) {
  /* Processing variable rscale2 */
  rscale2_Dims[0]=nvcount;
  capi_rscale2_intent |= F2PY_INTENT_IN;
  capi_rscale2_tmp = array_from_pyobj(NPY_DOUBLE,rscale2_Dims,rscale2_Rank,capi_rscale2_intent,rscale2_capi);
  if (capi_rscale2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `rscale2' of _internal.h2dlocloc_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale2 = (double *)(PyArray_DATA(capi_rscale2_tmp));

  /* Processing variable center2 */
  center2_Dims[0]=2,center2_Dims[1]=nvcount;
  capi_center2_intent |= F2PY_INTENT_IN;
  capi_center2_tmp = array_from_pyobj(NPY_DOUBLE,center2_Dims,center2_Rank,capi_center2_intent,center2_capi);
  if (capi_center2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `center2' of _internal.h2dlocloc_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center2 = (double *)(PyArray_DATA(capi_center2_tmp));

  /* Processing variable expn2 */
  expn2_Dims[0]=2 * nterms2 + 1,expn2_Dims[1]=nvcount;
  capi_expn2_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn2_tmp = array_from_pyobj(NPY_CDOUBLE,expn2_Dims,expn2_Rank,capi_expn2_intent,Py_None);
  if (capi_expn2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn2' of _internal.h2dlocloc_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn2 = (complex_double *)(PyArray_DATA(capi_expn2_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&zk,rscale1,center1,expn1,&nterms1,rscale2,center2,expn2,&nterms2,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("N",capi_expn2_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_expn2_tmp == NULL) ... else of expn2*/
  /* End of cleaning variable expn2 */
  if((PyObject *)capi_center2_tmp!=center2_capi) {
    Py_XDECREF(capi_center2_tmp); }
  }  /*if (capi_center2_tmp == NULL) ... else of center2*/
  /* End of cleaning variable center2 */
  if((PyObject *)capi_rscale2_tmp!=rscale2_capi) {
    Py_XDECREF(capi_rscale2_tmp); }
  }  /*if (capi_rscale2_tmp == NULL) ... else of rscale2*/
  /* End of cleaning variable rscale2 */
  } /*CHECKSCALAR((shape(expn1,0)-1)/(2)==nterms1)*/
  } /*if (f2py_success) of nterms1*/
  /* End of cleaning variable nterms1 */
  if((PyObject *)capi_expn1_tmp!=expn1_capi) {
    Py_XDECREF(capi_expn1_tmp); }
  }  /*if (capi_expn1_tmp == NULL) ... else of expn1*/
  /* End of cleaning variable expn1 */
  if((PyObject *)capi_center1_tmp!=center1_capi) {
    Py_XDECREF(capi_center1_tmp); }
  }  /*if (capi_center1_tmp == NULL) ... else of center1*/
  /* End of cleaning variable center1 */
  } /*CHECKSCALAR(len(rscale1)>=nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  } /*if (f2py_success) of nterms2*/
  /* End of cleaning variable nterms2 */
  if((PyObject *)capi_rscale1_tmp!=rscale1_capi) {
    Py_XDECREF(capi_rscale1_tmp); }
  }  /*if (capi_rscale1_tmp == NULL) ... else of rscale1*/
  /* End of cleaning variable rscale1 */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/**************************** end of h2dlocloc_vec ****************************/

/****************************** l3dmpmpquadu_vec ******************************/
static char doc_f2py_rout__internal_l3dmpmpquadu_vec[] = "\
expn2,ier = l3dmpmpquadu_vec(rscale1,center1,expn1,rscale2,center2,nterms2,[nterms1,nvcount])\n\nWrapper for ``l3dmpmpquadu_vec``.\
\n\nParameters\n----------\n"
"rscale1 : input rank-1 array('d') with bounds (nvcount)\n"
"center1 : input rank-2 array('d') with bounds (3,nvcount)\n"
"expn1 : input rank-3 array('D') with bounds (nterms1 + 1,2 * nterms1 + 1,nvcount)\n"
"rscale2 : input rank-1 array('d') with bounds (nvcount)\n"
"center2 : input rank-2 array('d') with bounds (3,nvcount)\n"
"nterms2 : input int\n"
"\nOther Parameters\n----------------\n"
"nterms1 : input int, optional\n    Default: (shape(expn1,0)-1)\n"
"nvcount : input int, optional\n    Default: len(rscale1)\n"
"\nReturns\n-------\n"
"expn2 : rank-3 array('D') with bounds (nterms2 + 1,2 * nterms2 + 1,nvcount)\n"
"ier : rank-1 array('i') with bounds (nvcount)";
/* extern void F_FUNC_US(l3dmpmpquadu_vec,L3DMPMPQUADU_VEC)(double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,int*,int*); */
static PyObject *f2py_rout__internal_l3dmpmpquadu_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double *rscale1 = NULL;
  npy_intp rscale1_Dims[1] = {-1};
  const int rscale1_Rank = 1;
  PyArrayObject *capi_rscale1_tmp = NULL;
  int capi_rscale1_intent = 0;
  PyObject *rscale1_capi = Py_None;
  double *center1 = NULL;
  npy_intp center1_Dims[2] = {-1, -1};
  const int center1_Rank = 2;
  PyArrayObject *capi_center1_tmp = NULL;
  int capi_center1_intent = 0;
  PyObject *center1_capi = Py_None;
  complex_double *expn1 = NULL;
  npy_intp expn1_Dims[3] = {-1, -1, -1};
  const int expn1_Rank = 3;
  PyArrayObject *capi_expn1_tmp = NULL;
  int capi_expn1_intent = 0;
  PyObject *expn1_capi = Py_None;
  int nterms1 = 0;
  PyObject *nterms1_capi = Py_None;
  double *rscale2 = NULL;
  npy_intp rscale2_Dims[1] = {-1};
  const int rscale2_Rank = 1;
  PyArrayObject *capi_rscale2_tmp = NULL;
  int capi_rscale2_intent = 0;
  PyObject *rscale2_capi = Py_None;
  double *center2 = NULL;
  npy_intp center2_Dims[2] = {-1, -1};
  const int center2_Rank = 2;
  PyArrayObject *capi_center2_tmp = NULL;
  int capi_center2_intent = 0;
  PyObject *center2_capi = Py_None;
  complex_double *expn2 = NULL;
  npy_intp expn2_Dims[3] = {-1, -1, -1};
  const int expn2_Rank = 3;
  PyArrayObject *capi_expn2_tmp = NULL;
  int capi_expn2_intent = 0;
  int nterms2 = 0;
  PyObject *nterms2_capi = Py_None;
  int *ier = NULL;
  npy_intp ier_Dims[1] = {-1};
  const int ier_Rank = 1;
  PyArrayObject *capi_ier_tmp = NULL;
  int capi_ier_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"rscale1","center1","expn1","rscale2","center2","nterms2","nterms1","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOO|OO:_internal.l3dmpmpquadu_vec",\
        capi_kwlist,&rscale1_capi,&center1_capi,&expn1_capi,&rscale2_capi,&center2_capi,&nterms2_capi,&nterms1_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale1 */
  ;
  capi_rscale1_intent |= F2PY_INTENT_IN;
  capi_rscale1_tmp = array_from_pyobj(NPY_DOUBLE,rscale1_Dims,rscale1_Rank,capi_rscale1_intent,rscale1_capi);
  if (capi_rscale1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 1st argument `rscale1' of _internal.l3dmpmpquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale1 = (double *)(PyArray_DATA(capi_rscale1_tmp));

  /* Processing variable nterms2 */
    f2py_success = int_from_pyobj(&nterms2,nterms2_capi,"_internal.l3dmpmpquadu_vec() 6th argument (nterms2) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = len(rscale1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.l3dmpmpquadu_vec() 2nd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(rscale1)>=nvcount,"len(rscale1)>=nvcount","2nd keyword nvcount","l3dmpmpquadu_vec:nvcount=%d",nvcount) {
  /* Processing variable center1 */
  center1_Dims[0]=3,center1_Dims[1]=nvcount;
  capi_center1_intent |= F2PY_INTENT_IN;
  capi_center1_tmp = array_from_pyobj(NPY_DOUBLE,center1_Dims,center1_Rank,capi_center1_intent,center1_capi);
  if (capi_center1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `center1' of _internal.l3dmpmpquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center1 = (double *)(PyArray_DATA(capi_center1_tmp));

  /* Processing variable expn1 */
  expn1_Dims[2]=nvcount;
  capi_expn1_intent |= F2PY_INTENT_IN;
  capi_expn1_tmp = array_from_pyobj(NPY_CDOUBLE,expn1_Dims,expn1_Rank,capi_expn1_intent,expn1_capi);
  if (capi_expn1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `expn1' of _internal.l3dmpmpquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn1 = (complex_double *)(PyArray_DATA(capi_expn1_tmp));

  /* Processing variable nterms1 */
  if (nterms1_capi == Py_None) nterms1 = (shape(expn1,0)-1); else
    f2py_success = int_from_pyobj(&nterms1,nterms1_capi,"_internal.l3dmpmpquadu_vec() 1st keyword (nterms1) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((shape(expn1,0)-1)==nterms1,"(shape(expn1,0)-1)==nterms1","1st keyword nterms1","l3dmpmpquadu_vec:nterms1=%d",nterms1) {
  /* Processing variable rscale2 */
  rscale2_Dims[0]=nvcount;
  capi_rscale2_intent |= F2PY_INTENT_IN;
  capi_rscale2_tmp = array_from_pyobj(NPY_DOUBLE,rscale2_Dims,rscale2_Rank,capi_rscale2_intent,rscale2_capi);
  if (capi_rscale2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `rscale2' of _internal.l3dmpmpquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale2 = (double *)(PyArray_DATA(capi_rscale2_tmp));

  /* Processing variable center2 */
  center2_Dims[0]=3,center2_Dims[1]=nvcount;
  capi_center2_intent |= F2PY_INTENT_IN;
  capi_center2_tmp = array_from_pyobj(NPY_DOUBLE,center2_Dims,center2_Rank,capi_center2_intent,center2_capi);
  if (capi_center2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `center2' of _internal.l3dmpmpquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center2 = (double *)(PyArray_DATA(capi_center2_tmp));

  /* Processing variable expn2 */
  expn2_Dims[0]=nterms2 + 1,expn2_Dims[1]=2 * nterms2 + 1,expn2_Dims[2]=nvcount;
  capi_expn2_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn2_tmp = array_from_pyobj(NPY_CDOUBLE,expn2_Dims,expn2_Rank,capi_expn2_intent,Py_None);
  if (capi_expn2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn2' of _internal.l3dmpmpquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn2 = (complex_double *)(PyArray_DATA(capi_expn2_tmp));

  /* Processing variable ier */
  ier_Dims[0]=nvcount;
  capi_ier_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_ier_tmp = array_from_pyobj(NPY_INT,ier_Dims,ier_Rank,capi_ier_intent,Py_None);
  if (capi_ier_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `ier' of _internal.l3dmpmpquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ier = (int *)(PyArray_DATA(capi_ier_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(rscale1,center1,expn1,&nterms1,rscale2,center2,expn2,&nterms2,ier,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NN",capi_expn2_tmp,capi_ier_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_ier_tmp == NULL) ... else of ier*/
  /* End of cleaning variable ier */
  }  /*if (capi_expn2_tmp == NULL) ... else of expn2*/
  /* End of cleaning variable expn2 */
  if((PyObject *)capi_center2_tmp!=center2_capi) {
    Py_XDECREF(capi_center2_tmp); }
  }  /*if (capi_center2_tmp == NULL) ... else of center2*/
  /* End of cleaning variable center2 */
  if((PyObject *)capi_rscale2_tmp!=rscale2_capi) {
    Py_XDECREF(capi_rscale2_tmp); }
  }  /*if (capi_rscale2_tmp == NULL) ... else of rscale2*/
  /* End of cleaning variable rscale2 */
  } /*CHECKSCALAR((shape(expn1,0)-1)==nterms1)*/
  } /*if (f2py_success) of nterms1*/
  /* End of cleaning variable nterms1 */
  if((PyObject *)capi_expn1_tmp!=expn1_capi) {
    Py_XDECREF(capi_expn1_tmp); }
  }  /*if (capi_expn1_tmp == NULL) ... else of expn1*/
  /* End of cleaning variable expn1 */
  if((PyObject *)capi_center1_tmp!=center1_capi) {
    Py_XDECREF(capi_center1_tmp); }
  }  /*if (capi_center1_tmp == NULL) ... else of center1*/
  /* End of cleaning variable center1 */
  } /*CHECKSCALAR(len(rscale1)>=nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  } /*if (f2py_success) of nterms2*/
  /* End of cleaning variable nterms2 */
  if((PyObject *)capi_rscale1_tmp!=rscale1_capi) {
    Py_XDECREF(capi_rscale1_tmp); }
  }  /*if (capi_rscale1_tmp == NULL) ... else of rscale1*/
  /* End of cleaning variable rscale1 */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/************************** end of l3dmpmpquadu_vec **************************/

/***************************** l3dmplocquadu_vec *****************************/
static char doc_f2py_rout__internal_l3dmplocquadu_vec[] = "\
expn2,ier = l3dmplocquadu_vec(rscale1,center1,expn1,rscale2,center2,nterms2,[nterms1,nvcount])\n\nWrapper for ``l3dmplocquadu_vec``.\
\n\nParameters\n----------\n"
"rscale1 : input rank-1 array('d') with bounds (nvcount)\n"
"center1 : input rank-2 array('d') with bounds (3,nvcount)\n"
"expn1 : input rank-3 array('D') with bounds (nterms1 + 1,2 * nterms1 + 1,nvcount)\n"
"rscale2 : input rank-1 array('d') with bounds (nvcount)\n"
"center2 : input rank-2 array('d') with bounds (3,nvcount)\n"
"nterms2 : input int\n"
"\nOther Parameters\n----------------\n"
"nterms1 : input int, optional\n    Default: (shape(expn1,0)-1)\n"
"nvcount : input int, optional\n    Default: len(rscale1)\n"
"\nReturns\n-------\n"
"expn2 : rank-3 array('D') with bounds (nterms2 + 1,2 * nterms2 + 1,nvcount)\n"
"ier : rank-1 array('i') with bounds (nvcount)";
/* extern void F_FUNC_US(l3dmplocquadu_vec,L3DMPLOCQUADU_VEC)(double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,int*,int*); */
static PyObject *f2py_rout__internal_l3dmplocquadu_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double *rscale1 = NULL;
  npy_intp rscale1_Dims[1] = {-1};
  const int rscale1_Rank = 1;
  PyArrayObject *capi_rscale1_tmp = NULL;
  int capi_rscale1_intent = 0;
  PyObject *rscale1_capi = Py_None;
  double *center1 = NULL;
  npy_intp center1_Dims[2] = {-1, -1};
  const int center1_Rank = 2;
  PyArrayObject *capi_center1_tmp = NULL;
  int capi_center1_intent = 0;
  PyObject *center1_capi = Py_None;
  complex_double *expn1 = NULL;
  npy_intp expn1_Dims[3] = {-1, -1, -1};
  const int expn1_Rank = 3;
  PyArrayObject *capi_expn1_tmp = NULL;
  int capi_expn1_intent = 0;
  PyObject *expn1_capi = Py_None;
  int nterms1 = 0;
  PyObject *nterms1_capi = Py_None;
  double *rscale2 = NULL;
  npy_intp rscale2_Dims[1] = {-1};
  const int rscale2_Rank = 1;
  PyArrayObject *capi_rscale2_tmp = NULL;
  int capi_rscale2_intent = 0;
  PyObject *rscale2_capi = Py_None;
  double *center2 = NULL;
  npy_intp center2_Dims[2] = {-1, -1};
  const int center2_Rank = 2;
  PyArrayObject *capi_center2_tmp = NULL;
  int capi_center2_intent = 0;
  PyObject *center2_capi = Py_None;
  complex_double *expn2 = NULL;
  npy_intp expn2_Dims[3] = {-1, -1, -1};
  const int expn2_Rank = 3;
  PyArrayObject *capi_expn2_tmp = NULL;
  int capi_expn2_intent = 0;
  int nterms2 = 0;
  PyObject *nterms2_capi = Py_None;
  int *ier = NULL;
  npy_intp ier_Dims[1] = {-1};
  const int ier_Rank = 1;
  PyArrayObject *capi_ier_tmp = NULL;
  int capi_ier_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"rscale1","center1","expn1","rscale2","center2","nterms2","nterms1","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOO|OO:_internal.l3dmplocquadu_vec",\
        capi_kwlist,&rscale1_capi,&center1_capi,&expn1_capi,&rscale2_capi,&center2_capi,&nterms2_capi,&nterms1_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale1 */
  ;
  capi_rscale1_intent |= F2PY_INTENT_IN;
  capi_rscale1_tmp = array_from_pyobj(NPY_DOUBLE,rscale1_Dims,rscale1_Rank,capi_rscale1_intent,rscale1_capi);
  if (capi_rscale1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 1st argument `rscale1' of _internal.l3dmplocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale1 = (double *)(PyArray_DATA(capi_rscale1_tmp));

  /* Processing variable nterms2 */
    f2py_success = int_from_pyobj(&nterms2,nterms2_capi,"_internal.l3dmplocquadu_vec() 6th argument (nterms2) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = len(rscale1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.l3dmplocquadu_vec() 2nd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(rscale1)>=nvcount,"len(rscale1)>=nvcount","2nd keyword nvcount","l3dmplocquadu_vec:nvcount=%d",nvcount) {
  /* Processing variable center1 */
  center1_Dims[0]=3,center1_Dims[1]=nvcount;
  capi_center1_intent |= F2PY_INTENT_IN;
  capi_center1_tmp = array_from_pyobj(NPY_DOUBLE,center1_Dims,center1_Rank,capi_center1_intent,center1_capi);
  if (capi_center1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `center1' of _internal.l3dmplocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center1 = (double *)(PyArray_DATA(capi_center1_tmp));

  /* Processing variable expn1 */
  expn1_Dims[2]=nvcount;
  capi_expn1_intent |= F2PY_INTENT_IN;
  capi_expn1_tmp = array_from_pyobj(NPY_CDOUBLE,expn1_Dims,expn1_Rank,capi_expn1_intent,expn1_capi);
  if (capi_expn1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `expn1' of _internal.l3dmplocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn1 = (complex_double *)(PyArray_DATA(capi_expn1_tmp));

  /* Processing variable nterms1 */
  if (nterms1_capi == Py_None) nterms1 = (shape(expn1,0)-1); else
    f2py_success = int_from_pyobj(&nterms1,nterms1_capi,"_internal.l3dmplocquadu_vec() 1st keyword (nterms1) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((shape(expn1,0)-1)==nterms1,"(shape(expn1,0)-1)==nterms1","1st keyword nterms1","l3dmplocquadu_vec:nterms1=%d",nterms1) {
  /* Processing variable rscale2 */
  rscale2_Dims[0]=nvcount;
  capi_rscale2_intent |= F2PY_INTENT_IN;
  capi_rscale2_tmp = array_from_pyobj(NPY_DOUBLE,rscale2_Dims,rscale2_Rank,capi_rscale2_intent,rscale2_capi);
  if (capi_rscale2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `rscale2' of _internal.l3dmplocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale2 = (double *)(PyArray_DATA(capi_rscale2_tmp));

  /* Processing variable center2 */
  center2_Dims[0]=3,center2_Dims[1]=nvcount;
  capi_center2_intent |= F2PY_INTENT_IN;
  capi_center2_tmp = array_from_pyobj(NPY_DOUBLE,center2_Dims,center2_Rank,capi_center2_intent,center2_capi);
  if (capi_center2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `center2' of _internal.l3dmplocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center2 = (double *)(PyArray_DATA(capi_center2_tmp));

  /* Processing variable expn2 */
  expn2_Dims[0]=nterms2 + 1,expn2_Dims[1]=2 * nterms2 + 1,expn2_Dims[2]=nvcount;
  capi_expn2_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn2_tmp = array_from_pyobj(NPY_CDOUBLE,expn2_Dims,expn2_Rank,capi_expn2_intent,Py_None);
  if (capi_expn2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn2' of _internal.l3dmplocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn2 = (complex_double *)(PyArray_DATA(capi_expn2_tmp));

  /* Processing variable ier */
  ier_Dims[0]=nvcount;
  capi_ier_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_ier_tmp = array_from_pyobj(NPY_INT,ier_Dims,ier_Rank,capi_ier_intent,Py_None);
  if (capi_ier_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `ier' of _internal.l3dmplocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ier = (int *)(PyArray_DATA(capi_ier_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(rscale1,center1,expn1,&nterms1,rscale2,center2,expn2,&nterms2,ier,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NN",capi_expn2_tmp,capi_ier_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_ier_tmp == NULL) ... else of ier*/
  /* End of cleaning variable ier */
  }  /*if (capi_expn2_tmp == NULL) ... else of expn2*/
  /* End of cleaning variable expn2 */
  if((PyObject *)capi_center2_tmp!=center2_capi) {
    Py_XDECREF(capi_center2_tmp); }
  }  /*if (capi_center2_tmp == NULL) ... else of center2*/
  /* End of cleaning variable center2 */
  if((PyObject *)capi_rscale2_tmp!=rscale2_capi) {
    Py_XDECREF(capi_rscale2_tmp); }
  }  /*if (capi_rscale2_tmp == NULL) ... else of rscale2*/
  /* End of cleaning variable rscale2 */
  } /*CHECKSCALAR((shape(expn1,0)-1)==nterms1)*/
  } /*if (f2py_success) of nterms1*/
  /* End of cleaning variable nterms1 */
  if((PyObject *)capi_expn1_tmp!=expn1_capi) {
    Py_XDECREF(capi_expn1_tmp); }
  }  /*if (capi_expn1_tmp == NULL) ... else of expn1*/
  /* End of cleaning variable expn1 */
  if((PyObject *)capi_center1_tmp!=center1_capi) {
    Py_XDECREF(capi_center1_tmp); }
  }  /*if (capi_center1_tmp == NULL) ... else of center1*/
  /* End of cleaning variable center1 */
  } /*CHECKSCALAR(len(rscale1)>=nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  } /*if (f2py_success) of nterms2*/
  /* End of cleaning variable nterms2 */
  if((PyObject *)capi_rscale1_tmp!=rscale1_capi) {
    Py_XDECREF(capi_rscale1_tmp); }
  }  /*if (capi_rscale1_tmp == NULL) ... else of rscale1*/
  /* End of cleaning variable rscale1 */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/************************** end of l3dmplocquadu_vec **************************/

/***************************** l3dloclocquadu_vec *****************************/
static char doc_f2py_rout__internal_l3dloclocquadu_vec[] = "\
expn2,ier = l3dloclocquadu_vec(rscale1,center1,expn1,rscale2,center2,nterms2,[nterms1,nvcount])\n\nWrapper for ``l3dloclocquadu_vec``.\
\n\nParameters\n----------\n"
"rscale1 : input rank-1 array('d') with bounds (nvcount)\n"
"center1 : input rank-2 array('d') with bounds (3,nvcount)\n"
"expn1 : input rank-3 array('D') with bounds (nterms1 + 1,2 * nterms1 + 1,nvcount)\n"
"rscale2 : input rank-1 array('d') with bounds (nvcount)\n"
"center2 : input rank-2 array('d') with bounds (3,nvcount)\n"
"nterms2 : input int\n"
"\nOther Parameters\n----------------\n"
"nterms1 : input int, optional\n    Default: (shape(expn1,0)-1)\n"
"nvcount : input int, optional\n    Default: len(rscale1)\n"
"\nReturns\n-------\n"
"expn2 : rank-3 array('D') with bounds (nterms2 + 1,2 * nterms2 + 1,nvcount)\n"
"ier : rank-1 array('i') with bounds (nvcount)";
/* extern void F_FUNC_US(l3dloclocquadu_vec,L3DLOCLOCQUADU_VEC)(double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,int*,int*); */
static PyObject *f2py_rout__internal_l3dloclocquadu_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double *rscale1 = NULL;
  npy_intp rscale1_Dims[1] = {-1};
  const int rscale1_Rank = 1;
  PyArrayObject *capi_rscale1_tmp = NULL;
  int capi_rscale1_intent = 0;
  PyObject *rscale1_capi = Py_None;
  double *center1 = NULL;
  npy_intp center1_Dims[2] = {-1, -1};
  const int center1_Rank = 2;
  PyArrayObject *capi_center1_tmp = NULL;
  int capi_center1_intent = 0;
  PyObject *center1_capi = Py_None;
  complex_double *expn1 = NULL;
  npy_intp expn1_Dims[3] = {-1, -1, -1};
  const int expn1_Rank = 3;
  PyArrayObject *capi_expn1_tmp = NULL;
  int capi_expn1_intent = 0;
  PyObject *expn1_capi = Py_None;
  int nterms1 = 0;
  PyObject *nterms1_capi = Py_None;
  double *rscale2 = NULL;
  npy_intp rscale2_Dims[1] = {-1};
  const int rscale2_Rank = 1;
  PyArrayObject *capi_rscale2_tmp = NULL;
  int capi_rscale2_intent = 0;
  PyObject *rscale2_capi = Py_None;
  double *center2 = NULL;
  npy_intp center2_Dims[2] = {-1, -1};
  const int center2_Rank = 2;
  PyArrayObject *capi_center2_tmp = NULL;
  int capi_center2_intent = 0;
  PyObject *center2_capi = Py_None;
  complex_double *expn2 = NULL;
  npy_intp expn2_Dims[3] = {-1, -1, -1};
  const int expn2_Rank = 3;
  PyArrayObject *capi_expn2_tmp = NULL;
  int capi_expn2_intent = 0;
  int nterms2 = 0;
  PyObject *nterms2_capi = Py_None;
  int *ier = NULL;
  npy_intp ier_Dims[1] = {-1};
  const int ier_Rank = 1;
  PyArrayObject *capi_ier_tmp = NULL;
  int capi_ier_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"rscale1","center1","expn1","rscale2","center2","nterms2","nterms1","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOO|OO:_internal.l3dloclocquadu_vec",\
        capi_kwlist,&rscale1_capi,&center1_capi,&expn1_capi,&rscale2_capi,&center2_capi,&nterms2_capi,&nterms1_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale1 */
  ;
  capi_rscale1_intent |= F2PY_INTENT_IN;
  capi_rscale1_tmp = array_from_pyobj(NPY_DOUBLE,rscale1_Dims,rscale1_Rank,capi_rscale1_intent,rscale1_capi);
  if (capi_rscale1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 1st argument `rscale1' of _internal.l3dloclocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale1 = (double *)(PyArray_DATA(capi_rscale1_tmp));

  /* Processing variable nterms2 */
    f2py_success = int_from_pyobj(&nterms2,nterms2_capi,"_internal.l3dloclocquadu_vec() 6th argument (nterms2) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = len(rscale1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.l3dloclocquadu_vec() 2nd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(rscale1)>=nvcount,"len(rscale1)>=nvcount","2nd keyword nvcount","l3dloclocquadu_vec:nvcount=%d",nvcount) {
  /* Processing variable center1 */
  center1_Dims[0]=3,center1_Dims[1]=nvcount;
  capi_center1_intent |= F2PY_INTENT_IN;
  capi_center1_tmp = array_from_pyobj(NPY_DOUBLE,center1_Dims,center1_Rank,capi_center1_intent,center1_capi);
  if (capi_center1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `center1' of _internal.l3dloclocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center1 = (double *)(PyArray_DATA(capi_center1_tmp));

  /* Processing variable expn1 */
  expn1_Dims[2]=nvcount;
  capi_expn1_intent |= F2PY_INTENT_IN;
  capi_expn1_tmp = array_from_pyobj(NPY_CDOUBLE,expn1_Dims,expn1_Rank,capi_expn1_intent,expn1_capi);
  if (capi_expn1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `expn1' of _internal.l3dloclocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn1 = (complex_double *)(PyArray_DATA(capi_expn1_tmp));

  /* Processing variable nterms1 */
  if (nterms1_capi == Py_None) nterms1 = (shape(expn1,0)-1); else
    f2py_success = int_from_pyobj(&nterms1,nterms1_capi,"_internal.l3dloclocquadu_vec() 1st keyword (nterms1) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((shape(expn1,0)-1)==nterms1,"(shape(expn1,0)-1)==nterms1","1st keyword nterms1","l3dloclocquadu_vec:nterms1=%d",nterms1) {
  /* Processing variable rscale2 */
  rscale2_Dims[0]=nvcount;
  capi_rscale2_intent |= F2PY_INTENT_IN;
  capi_rscale2_tmp = array_from_pyobj(NPY_DOUBLE,rscale2_Dims,rscale2_Rank,capi_rscale2_intent,rscale2_capi);
  if (capi_rscale2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `rscale2' of _internal.l3dloclocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale2 = (double *)(PyArray_DATA(capi_rscale2_tmp));

  /* Processing variable center2 */
  center2_Dims[0]=3,center2_Dims[1]=nvcount;
  capi_center2_intent |= F2PY_INTENT_IN;
  capi_center2_tmp = array_from_pyobj(NPY_DOUBLE,center2_Dims,center2_Rank,capi_center2_intent,center2_capi);
  if (capi_center2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `center2' of _internal.l3dloclocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center2 = (double *)(PyArray_DATA(capi_center2_tmp));

  /* Processing variable expn2 */
  expn2_Dims[0]=nterms2 + 1,expn2_Dims[1]=2 * nterms2 + 1,expn2_Dims[2]=nvcount;
  capi_expn2_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn2_tmp = array_from_pyobj(NPY_CDOUBLE,expn2_Dims,expn2_Rank,capi_expn2_intent,Py_None);
  if (capi_expn2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn2' of _internal.l3dloclocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn2 = (complex_double *)(PyArray_DATA(capi_expn2_tmp));

  /* Processing variable ier */
  ier_Dims[0]=nvcount;
  capi_ier_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_ier_tmp = array_from_pyobj(NPY_INT,ier_Dims,ier_Rank,capi_ier_intent,Py_None);
  if (capi_ier_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `ier' of _internal.l3dloclocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ier = (int *)(PyArray_DATA(capi_ier_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(rscale1,center1,expn1,&nterms1,rscale2,center2,expn2,&nterms2,ier,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NN",capi_expn2_tmp,capi_ier_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_ier_tmp == NULL) ... else of ier*/
  /* End of cleaning variable ier */
  }  /*if (capi_expn2_tmp == NULL) ... else of expn2*/
  /* End of cleaning variable expn2 */
  if((PyObject *)capi_center2_tmp!=center2_capi) {
    Py_XDECREF(capi_center2_tmp); }
  }  /*if (capi_center2_tmp == NULL) ... else of center2*/
  /* End of cleaning variable center2 */
  if((PyObject *)capi_rscale2_tmp!=rscale2_capi) {
    Py_XDECREF(capi_rscale2_tmp); }
  }  /*if (capi_rscale2_tmp == NULL) ... else of rscale2*/
  /* End of cleaning variable rscale2 */
  } /*CHECKSCALAR((shape(expn1,0)-1)==nterms1)*/
  } /*if (f2py_success) of nterms1*/
  /* End of cleaning variable nterms1 */
  if((PyObject *)capi_expn1_tmp!=expn1_capi) {
    Py_XDECREF(capi_expn1_tmp); }
  }  /*if (capi_expn1_tmp == NULL) ... else of expn1*/
  /* End of cleaning variable expn1 */
  if((PyObject *)capi_center1_tmp!=center1_capi) {
    Py_XDECREF(capi_center1_tmp); }
  }  /*if (capi_center1_tmp == NULL) ... else of center1*/
  /* End of cleaning variable center1 */
  } /*CHECKSCALAR(len(rscale1)>=nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  } /*if (f2py_success) of nterms2*/
  /* End of cleaning variable nterms2 */
  if((PyObject *)capi_rscale1_tmp!=rscale1_capi) {
    Py_XDECREF(capi_rscale1_tmp); }
  }  /*if (capi_rscale1_tmp == NULL) ... else of rscale1*/
  /* End of cleaning variable rscale1 */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/************************* end of l3dloclocquadu_vec *************************/

/****************************** h3dmpmpquadu_vec ******************************/
static char doc_f2py_rout__internal_h3dmpmpquadu_vec[] = "\
expn2,ier = h3dmpmpquadu_vec(zk,rscale1,center1,expn1,rscale2,center2,nterms2,radius,xnodes,wts,[nterms1,nquad,nvcount])\n\nWrapper for ``h3dmpmpquadu_vec``.\
\n\nParameters\n----------\n"
"zk : input complex\n"
"rscale1 : input rank-1 array('d') with bounds (nvcount)\n"
"center1 : input rank-2 array('d') with bounds (3,nvcount)\n"
"expn1 : input rank-3 array('D') with bounds (nterms1 + 1,2 * nterms1 + 1,nvcount)\n"
"rscale2 : input rank-1 array('d') with bounds (nvcount)\n"
"center2 : input rank-2 array('d') with bounds (3,nvcount)\n"
"nterms2 : input int\n"
"radius : input rank-1 array('d') with bounds (nvcount)\n"
"xnodes : input rank-1 array('d') with bounds (nquad)\n"
"wts : input rank-1 array('d') with bounds (nquad)\n"
"\nOther Parameters\n----------------\n"
"nterms1 : input int, optional\n    Default: (shape(expn1,0)-1)\n"
"nquad : input int, optional\n    Default: len(xnodes)\n"
"nvcount : input int, optional\n    Default: len(rscale1)\n"
"\nReturns\n-------\n"
"expn2 : rank-3 array('D') with bounds (nterms2 + 1,2 * nterms2 + 1,nvcount)\n"
"ier : rank-1 array('i') with bounds (nvcount)";
/* extern void F_FUNC_US(h3dmpmpquadu_vec,H3DMPMPQUADU_VEC)(complex_double*,double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,double*,double*,double*,int*,int*,int*); */
static PyObject *f2py_rout__internal_h3dmpmpquadu_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(complex_double*,double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,double*,double*,double*,int*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  complex_double zk;
  PyObject *zk_capi = Py_None;
  double *rscale1 = NULL;
  npy_intp rscale1_Dims[1] = {-1};
  const int rscale1_Rank = 1;
  PyArrayObject *capi_rscale1_tmp = NULL;
  int capi_rscale1_intent = 0;
  PyObject *rscale1_capi = Py_None;
  double *center1 = NULL;
  npy_intp center1_Dims[2] = {-1, -1};
  const int center1_Rank = 2;
  PyArrayObject *capi_center1_tmp = NULL;
  int capi_center1_intent = 0;
  PyObject *center1_capi = Py_None;
  complex_double *expn1 = NULL;
  npy_intp expn1_Dims[3] = {-1, -1, -1};
  const int expn1_Rank = 3;
  PyArrayObject *capi_expn1_tmp = NULL;
  int capi_expn1_intent = 0;
  PyObject *expn1_capi = Py_None;
  int nterms1 = 0;
  PyObject *nterms1_capi = Py_None;
  double *rscale2 = NULL;
  npy_intp rscale2_Dims[1] = {-1};
  const int rscale2_Rank = 1;
  PyArrayObject *capi_rscale2_tmp = NULL;
  int capi_rscale2_intent = 0;
  PyObject *rscale2_capi = Py_None;
  double *center2 = NULL;
  npy_intp center2_Dims[2] = {-1, -1};
  const int center2_Rank = 2;
  PyArrayObject *capi_center2_tmp = NULL;
  int capi_center2_intent = 0;
  PyObject *center2_capi = Py_None;
  complex_double *expn2 = NULL;
  npy_intp expn2_Dims[3] = {-1, -1, -1};
  const int expn2_Rank = 3;
  PyArrayObject *capi_expn2_tmp = NULL;
  int capi_expn2_intent = 0;
  int nterms2 = 0;
  PyObject *nterms2_capi = Py_None;
  double *radius = NULL;
  npy_intp radius_Dims[1] = {-1};
  const int radius_Rank = 1;
  PyArrayObject *capi_radius_tmp = NULL;
  int capi_radius_intent = 0;
  PyObject *radius_capi = Py_None;
  double *xnodes = NULL;
  npy_intp xnodes_Dims[1] = {-1};
  const int xnodes_Rank = 1;
  PyArrayObject *capi_xnodes_tmp = NULL;
  int capi_xnodes_intent = 0;
  PyObject *xnodes_capi = Py_None;
  double *wts = NULL;
  npy_intp wts_Dims[1] = {-1};
  const int wts_Rank = 1;
  PyArrayObject *capi_wts_tmp = NULL;
  int capi_wts_intent = 0;
  PyObject *wts_capi = Py_None;
  int nquad = 0;
  PyObject *nquad_capi = Py_None;
  int *ier = NULL;
  npy_intp ier_Dims[1] = {-1};
  const int ier_Rank = 1;
  PyArrayObject *capi_ier_tmp = NULL;
  int capi_ier_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"zk","rscale1","center1","expn1","rscale2","center2","nterms2","radius","xnodes","wts","nterms1","nquad","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOO|OOO:_internal.h3dmpmpquadu_vec",\
        capi_kwlist,&zk_capi,&rscale1_capi,&center1_capi,&expn1_capi,&rscale2_capi,&center2_capi,&nterms2_capi,&radius_capi,&xnodes_capi,&wts_capi,&nterms1_capi,&nquad_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.h3dmpmpquadu_vec() 1st argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable rscale1 */
  ;
  capi_rscale1_intent |= F2PY_INTENT_IN;
  capi_rscale1_tmp = array_from_pyobj(NPY_DOUBLE,rscale1_Dims,rscale1_Rank,capi_rscale1_intent,rscale1_capi);
  if (capi_rscale1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `rscale1' of _internal.h3dmpmpquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale1 = (double *)(PyArray_DATA(capi_rscale1_tmp));

  /* Processing variable nterms2 */
    f2py_success = int_from_pyobj(&nterms2,nterms2_capi,"_internal.h3dmpmpquadu_vec() 7th argument (nterms2) can't be converted to int");
  if (f2py_success) {
  /* Processing variable xnodes */
  ;
  capi_xnodes_intent |= F2PY_INTENT_IN;
  capi_xnodes_tmp = array_from_pyobj(NPY_DOUBLE,xnodes_Dims,xnodes_Rank,capi_xnodes_intent,xnodes_capi);
  if (capi_xnodes_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 9th argument `xnodes' of _internal.h3dmpmpquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    xnodes = (double *)(PyArray_DATA(capi_xnodes_tmp));

  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = len(rscale1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.h3dmpmpquadu_vec() 3rd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(rscale1)>=nvcount,"len(rscale1)>=nvcount","3rd keyword nvcount","h3dmpmpquadu_vec:nvcount=%d",nvcount) {
  /* Processing variable center1 */
  center1_Dims[0]=3,center1_Dims[1]=nvcount;
  capi_center1_intent |= F2PY_INTENT_IN;
  capi_center1_tmp = array_from_pyobj(NPY_DOUBLE,center1_Dims,center1_Rank,capi_center1_intent,center1_capi);
  if (capi_center1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `center1' of _internal.h3dmpmpquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center1 = (double *)(PyArray_DATA(capi_center1_tmp));

  /* Processing variable expn1 */
  expn1_Dims[2]=nvcount;
  capi_expn1_intent |= F2PY_INTENT_IN;
  capi_expn1_tmp = array_from_pyobj(NPY_CDOUBLE,expn1_Dims,expn1_Rank,capi_expn1_intent,expn1_capi);
  if (capi_expn1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `expn1' of _internal.h3dmpmpquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn1 = (complex_double *)(PyArray_DATA(capi_expn1_tmp));

  /* Processing variable nterms1 */
  if (nterms1_capi == Py_None) nterms1 = (shape(expn1,0)-1); else
    f2py_success = int_from_pyobj(&nterms1,nterms1_capi,"_internal.h3dmpmpquadu_vec() 1st keyword (nterms1) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((shape(expn1,0)-1)==nterms1,"(shape(expn1,0)-1)==nterms1","1st keyword nterms1","h3dmpmpquadu_vec:nterms1=%d",nterms1) {
  /* Processing variable rscale2 */
  rscale2_Dims[0]=nvcount;
  capi_rscale2_intent |= F2PY_INTENT_IN;
  capi_rscale2_tmp = array_from_pyobj(NPY_DOUBLE,rscale2_Dims,rscale2_Rank,capi_rscale2_intent,rscale2_capi);
  if (capi_rscale2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `rscale2' of _internal.h3dmpmpquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale2 = (double *)(PyArray_DATA(capi_rscale2_tmp));

  /* Processing variable center2 */
  center2_Dims[0]=3,center2_Dims[1]=nvcount;
  capi_center2_intent |= F2PY_INTENT_IN;
  capi_center2_tmp = array_from_pyobj(NPY_DOUBLE,center2_Dims,center2_Rank,capi_center2_intent,center2_capi);
  if (capi_center2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `center2' of _internal.h3dmpmpquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center2 = (double *)(PyArray_DATA(capi_center2_tmp));

  /* Processing variable expn2 */
  expn2_Dims[0]=nterms2 + 1,expn2_Dims[1]=2 * nterms2 + 1,expn2_Dims[2]=nvcount;
  capi_expn2_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn2_tmp = array_from_pyobj(NPY_CDOUBLE,expn2_Dims,expn2_Rank,capi_expn2_intent,Py_None);
  if (capi_expn2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn2' of _internal.h3dmpmpquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn2 = (complex_double *)(PyArray_DATA(capi_expn2_tmp));

  /* Processing variable radius */
  radius_Dims[0]=nvcount;
  capi_radius_intent |= F2PY_INTENT_IN;
  capi_radius_tmp = array_from_pyobj(NPY_DOUBLE,radius_Dims,radius_Rank,capi_radius_intent,radius_capi);
  if (capi_radius_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 8th argument `radius' of _internal.h3dmpmpquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    radius = (double *)(PyArray_DATA(capi_radius_tmp));

  /* Processing variable nquad */
  if (nquad_capi == Py_None) nquad = len(xnodes); else
    f2py_success = int_from_pyobj(&nquad,nquad_capi,"_internal.h3dmpmpquadu_vec() 2nd keyword (nquad) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(xnodes)>=nquad,"len(xnodes)>=nquad","2nd keyword nquad","h3dmpmpquadu_vec:nquad=%d",nquad) {
  /* Processing variable ier */
  ier_Dims[0]=nvcount;
  capi_ier_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_ier_tmp = array_from_pyobj(NPY_INT,ier_Dims,ier_Rank,capi_ier_intent,Py_None);
  if (capi_ier_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `ier' of _internal.h3dmpmpquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ier = (int *)(PyArray_DATA(capi_ier_tmp));

  /* Processing variable wts */
  wts_Dims[0]=nquad;
  capi_wts_intent |= F2PY_INTENT_IN;
  capi_wts_tmp = array_from_pyobj(NPY_DOUBLE,wts_Dims,wts_Rank,capi_wts_intent,wts_capi);
  if (capi_wts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 10th argument `wts' of _internal.h3dmpmpquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    wts = (double *)(PyArray_DATA(capi_wts_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&zk,rscale1,center1,expn1,&nterms1,rscale2,center2,expn2,&nterms2,radius,xnodes,wts,&nquad,ier,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NN",capi_expn2_tmp,capi_ier_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_wts_tmp!=wts_capi) {
    Py_XDECREF(capi_wts_tmp); }
  }  /*if (capi_wts_tmp == NULL) ... else of wts*/
  /* End of cleaning variable wts */
  }  /*if (capi_ier_tmp == NULL) ... else of ier*/
  /* End of cleaning variable ier */
  } /*CHECKSCALAR(len(xnodes)>=nquad)*/
  } /*if (f2py_success) of nquad*/
  /* End of cleaning variable nquad */
  if((PyObject *)capi_radius_tmp!=radius_capi) {
    Py_XDECREF(capi_radius_tmp); }
  }  /*if (capi_radius_tmp == NULL) ... else of radius*/
  /* End of cleaning variable radius */
  }  /*if (capi_expn2_tmp == NULL) ... else of expn2*/
  /* End of cleaning variable expn2 */
  if((PyObject *)capi_center2_tmp!=center2_capi) {
    Py_XDECREF(capi_center2_tmp); }
  }  /*if (capi_center2_tmp == NULL) ... else of center2*/
  /* End of cleaning variable center2 */
  if((PyObject *)capi_rscale2_tmp!=rscale2_capi) {
    Py_XDECREF(capi_rscale2_tmp); }
  }  /*if (capi_rscale2_tmp == NULL) ... else of rscale2*/
  /* End of cleaning variable rscale2 */
  } /*CHECKSCALAR((shape(expn1,0)-1)==nterms1)*/
  } /*if (f2py_success) of nterms1*/
  /* End of cleaning variable nterms1 */
  if((PyObject *)capi_expn1_tmp!=expn1_capi) {
    Py_XDECREF(capi_expn1_tmp); }
  }  /*if (capi_expn1_tmp == NULL) ... else of expn1*/
  /* End of cleaning variable expn1 */
  if((PyObject *)capi_center1_tmp!=center1_capi) {
    Py_XDECREF(capi_center1_tmp); }
  }  /*if (capi_center1_tmp == NULL) ... else of center1*/
  /* End of cleaning variable center1 */
  } /*CHECKSCALAR(len(rscale1)>=nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  if((PyObject *)capi_xnodes_tmp!=xnodes_capi) {
    Py_XDECREF(capi_xnodes_tmp); }
  }  /*if (capi_xnodes_tmp == NULL) ... else of xnodes*/
  /* End of cleaning variable xnodes */
  } /*if (f2py_success) of nterms2*/
  /* End of cleaning variable nterms2 */
  if((PyObject *)capi_rscale1_tmp!=rscale1_capi) {
    Py_XDECREF(capi_rscale1_tmp); }
  }  /*if (capi_rscale1_tmp == NULL) ... else of rscale1*/
  /* End of cleaning variable rscale1 */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/************************** end of h3dmpmpquadu_vec **************************/

/***************************** h3dmplocquadu_vec *****************************/
static char doc_f2py_rout__internal_h3dmplocquadu_vec[] = "\
expn2,ier = h3dmplocquadu_vec(zk,rscale1,center1,expn1,rscale2,center2,nterms2,radius,xnodes,wts,[nterms1,nquad,nvcount])\n\nWrapper for ``h3dmplocquadu_vec``.\
\n\nParameters\n----------\n"
"zk : input complex\n"
"rscale1 : input rank-1 array('d') with bounds (nvcount)\n"
"center1 : input rank-2 array('d') with bounds (3,nvcount)\n"
"expn1 : input rank-3 array('D') with bounds (nterms1 + 1,2 * nterms1 + 1,nvcount)\n"
"rscale2 : input rank-1 array('d') with bounds (nvcount)\n"
"center2 : input rank-2 array('d') with bounds (3,nvcount)\n"
"nterms2 : input int\n"
"radius : input rank-1 array('d') with bounds (nvcount)\n"
"xnodes : input rank-1 array('d') with bounds (nquad)\n"
"wts : input rank-1 array('d') with bounds (nquad)\n"
"\nOther Parameters\n----------------\n"
"nterms1 : input int, optional\n    Default: (shape(expn1,0)-1)\n"
"nquad : input int, optional\n    Default: len(xnodes)\n"
"nvcount : input int, optional\n    Default: len(rscale1)\n"
"\nReturns\n-------\n"
"expn2 : rank-3 array('D') with bounds (nterms2 + 1,2 * nterms2 + 1,nvcount)\n"
"ier : rank-1 array('i') with bounds (nvcount)";
/* extern void F_FUNC_US(h3dmplocquadu_vec,H3DMPLOCQUADU_VEC)(complex_double*,double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,double*,double*,double*,int*,int*,int*); */
static PyObject *f2py_rout__internal_h3dmplocquadu_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(complex_double*,double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,double*,double*,double*,int*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  complex_double zk;
  PyObject *zk_capi = Py_None;
  double *rscale1 = NULL;
  npy_intp rscale1_Dims[1] = {-1};
  const int rscale1_Rank = 1;
  PyArrayObject *capi_rscale1_tmp = NULL;
  int capi_rscale1_intent = 0;
  PyObject *rscale1_capi = Py_None;
  double *center1 = NULL;
  npy_intp center1_Dims[2] = {-1, -1};
  const int center1_Rank = 2;
  PyArrayObject *capi_center1_tmp = NULL;
  int capi_center1_intent = 0;
  PyObject *center1_capi = Py_None;
  complex_double *expn1 = NULL;
  npy_intp expn1_Dims[3] = {-1, -1, -1};
  const int expn1_Rank = 3;
  PyArrayObject *capi_expn1_tmp = NULL;
  int capi_expn1_intent = 0;
  PyObject *expn1_capi = Py_None;
  int nterms1 = 0;
  PyObject *nterms1_capi = Py_None;
  double *rscale2 = NULL;
  npy_intp rscale2_Dims[1] = {-1};
  const int rscale2_Rank = 1;
  PyArrayObject *capi_rscale2_tmp = NULL;
  int capi_rscale2_intent = 0;
  PyObject *rscale2_capi = Py_None;
  double *center2 = NULL;
  npy_intp center2_Dims[2] = {-1, -1};
  const int center2_Rank = 2;
  PyArrayObject *capi_center2_tmp = NULL;
  int capi_center2_intent = 0;
  PyObject *center2_capi = Py_None;
  complex_double *expn2 = NULL;
  npy_intp expn2_Dims[3] = {-1, -1, -1};
  const int expn2_Rank = 3;
  PyArrayObject *capi_expn2_tmp = NULL;
  int capi_expn2_intent = 0;
  int nterms2 = 0;
  PyObject *nterms2_capi = Py_None;
  double *radius = NULL;
  npy_intp radius_Dims[1] = {-1};
  const int radius_Rank = 1;
  PyArrayObject *capi_radius_tmp = NULL;
  int capi_radius_intent = 0;
  PyObject *radius_capi = Py_None;
  double *xnodes = NULL;
  npy_intp xnodes_Dims[1] = {-1};
  const int xnodes_Rank = 1;
  PyArrayObject *capi_xnodes_tmp = NULL;
  int capi_xnodes_intent = 0;
  PyObject *xnodes_capi = Py_None;
  double *wts = NULL;
  npy_intp wts_Dims[1] = {-1};
  const int wts_Rank = 1;
  PyArrayObject *capi_wts_tmp = NULL;
  int capi_wts_intent = 0;
  PyObject *wts_capi = Py_None;
  int nquad = 0;
  PyObject *nquad_capi = Py_None;
  int *ier = NULL;
  npy_intp ier_Dims[1] = {-1};
  const int ier_Rank = 1;
  PyArrayObject *capi_ier_tmp = NULL;
  int capi_ier_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"zk","rscale1","center1","expn1","rscale2","center2","nterms2","radius","xnodes","wts","nterms1","nquad","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOO|OOO:_internal.h3dmplocquadu_vec",\
        capi_kwlist,&zk_capi,&rscale1_capi,&center1_capi,&expn1_capi,&rscale2_capi,&center2_capi,&nterms2_capi,&radius_capi,&xnodes_capi,&wts_capi,&nterms1_capi,&nquad_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.h3dmplocquadu_vec() 1st argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable rscale1 */
  ;
  capi_rscale1_intent |= F2PY_INTENT_IN;
  capi_rscale1_tmp = array_from_pyobj(NPY_DOUBLE,rscale1_Dims,rscale1_Rank,capi_rscale1_intent,rscale1_capi);
  if (capi_rscale1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `rscale1' of _internal.h3dmplocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale1 = (double *)(PyArray_DATA(capi_rscale1_tmp));

  /* Processing variable nterms2 */
    f2py_success = int_from_pyobj(&nterms2,nterms2_capi,"_internal.h3dmplocquadu_vec() 7th argument (nterms2) can't be converted to int");
  if (f2py_success) {
  /* Processing variable xnodes */
  ;
  capi_xnodes_intent |= F2PY_INTENT_IN;
  capi_xnodes_tmp = array_from_pyobj(NPY_DOUBLE,xnodes_Dims,xnodes_Rank,capi_xnodes_intent,xnodes_capi);
  if (capi_xnodes_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 9th argument `xnodes' of _internal.h3dmplocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    xnodes = (double *)(PyArray_DATA(capi_xnodes_tmp));

  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = len(rscale1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.h3dmplocquadu_vec() 3rd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(rscale1)>=nvcount,"len(rscale1)>=nvcount","3rd keyword nvcount","h3dmplocquadu_vec:nvcount=%d",nvcount) {
  /* Processing variable center1 */
  center1_Dims[0]=3,center1_Dims[1]=nvcount;
  capi_center1_intent |= F2PY_INTENT_IN;
  capi_center1_tmp = array_from_pyobj(NPY_DOUBLE,center1_Dims,center1_Rank,capi_center1_intent,center1_capi);
  if (capi_center1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `center1' of _internal.h3dmplocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center1 = (double *)(PyArray_DATA(capi_center1_tmp));

  /* Processing variable expn1 */
  expn1_Dims[2]=nvcount;
  capi_expn1_intent |= F2PY_INTENT_IN;
  capi_expn1_tmp = array_from_pyobj(NPY_CDOUBLE,expn1_Dims,expn1_Rank,capi_expn1_intent,expn1_capi);
  if (capi_expn1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `expn1' of _internal.h3dmplocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn1 = (complex_double *)(PyArray_DATA(capi_expn1_tmp));

  /* Processing variable nterms1 */
  if (nterms1_capi == Py_None) nterms1 = (shape(expn1,0)-1); else
    f2py_success = int_from_pyobj(&nterms1,nterms1_capi,"_internal.h3dmplocquadu_vec() 1st keyword (nterms1) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((shape(expn1,0)-1)==nterms1,"(shape(expn1,0)-1)==nterms1","1st keyword nterms1","h3dmplocquadu_vec:nterms1=%d",nterms1) {
  /* Processing variable rscale2 */
  rscale2_Dims[0]=nvcount;
  capi_rscale2_intent |= F2PY_INTENT_IN;
  capi_rscale2_tmp = array_from_pyobj(NPY_DOUBLE,rscale2_Dims,rscale2_Rank,capi_rscale2_intent,rscale2_capi);
  if (capi_rscale2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `rscale2' of _internal.h3dmplocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale2 = (double *)(PyArray_DATA(capi_rscale2_tmp));

  /* Processing variable center2 */
  center2_Dims[0]=3,center2_Dims[1]=nvcount;
  capi_center2_intent |= F2PY_INTENT_IN;
  capi_center2_tmp = array_from_pyobj(NPY_DOUBLE,center2_Dims,center2_Rank,capi_center2_intent,center2_capi);
  if (capi_center2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `center2' of _internal.h3dmplocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center2 = (double *)(PyArray_DATA(capi_center2_tmp));

  /* Processing variable expn2 */
  expn2_Dims[0]=nterms2 + 1,expn2_Dims[1]=2 * nterms2 + 1,expn2_Dims[2]=nvcount;
  capi_expn2_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn2_tmp = array_from_pyobj(NPY_CDOUBLE,expn2_Dims,expn2_Rank,capi_expn2_intent,Py_None);
  if (capi_expn2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn2' of _internal.h3dmplocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn2 = (complex_double *)(PyArray_DATA(capi_expn2_tmp));

  /* Processing variable radius */
  radius_Dims[0]=nvcount;
  capi_radius_intent |= F2PY_INTENT_IN;
  capi_radius_tmp = array_from_pyobj(NPY_DOUBLE,radius_Dims,radius_Rank,capi_radius_intent,radius_capi);
  if (capi_radius_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 8th argument `radius' of _internal.h3dmplocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    radius = (double *)(PyArray_DATA(capi_radius_tmp));

  /* Processing variable nquad */
  if (nquad_capi == Py_None) nquad = len(xnodes); else
    f2py_success = int_from_pyobj(&nquad,nquad_capi,"_internal.h3dmplocquadu_vec() 2nd keyword (nquad) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(xnodes)>=nquad,"len(xnodes)>=nquad","2nd keyword nquad","h3dmplocquadu_vec:nquad=%d",nquad) {
  /* Processing variable ier */
  ier_Dims[0]=nvcount;
  capi_ier_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_ier_tmp = array_from_pyobj(NPY_INT,ier_Dims,ier_Rank,capi_ier_intent,Py_None);
  if (capi_ier_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `ier' of _internal.h3dmplocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ier = (int *)(PyArray_DATA(capi_ier_tmp));

  /* Processing variable wts */
  wts_Dims[0]=nquad;
  capi_wts_intent |= F2PY_INTENT_IN;
  capi_wts_tmp = array_from_pyobj(NPY_DOUBLE,wts_Dims,wts_Rank,capi_wts_intent,wts_capi);
  if (capi_wts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 10th argument `wts' of _internal.h3dmplocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    wts = (double *)(PyArray_DATA(capi_wts_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&zk,rscale1,center1,expn1,&nterms1,rscale2,center2,expn2,&nterms2,radius,xnodes,wts,&nquad,ier,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NN",capi_expn2_tmp,capi_ier_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_wts_tmp!=wts_capi) {
    Py_XDECREF(capi_wts_tmp); }
  }  /*if (capi_wts_tmp == NULL) ... else of wts*/
  /* End of cleaning variable wts */
  }  /*if (capi_ier_tmp == NULL) ... else of ier*/
  /* End of cleaning variable ier */
  } /*CHECKSCALAR(len(xnodes)>=nquad)*/
  } /*if (f2py_success) of nquad*/
  /* End of cleaning variable nquad */
  if((PyObject *)capi_radius_tmp!=radius_capi) {
    Py_XDECREF(capi_radius_tmp); }
  }  /*if (capi_radius_tmp == NULL) ... else of radius*/
  /* End of cleaning variable radius */
  }  /*if (capi_expn2_tmp == NULL) ... else of expn2*/
  /* End of cleaning variable expn2 */
  if((PyObject *)capi_center2_tmp!=center2_capi) {
    Py_XDECREF(capi_center2_tmp); }
  }  /*if (capi_center2_tmp == NULL) ... else of center2*/
  /* End of cleaning variable center2 */
  if((PyObject *)capi_rscale2_tmp!=rscale2_capi) {
    Py_XDECREF(capi_rscale2_tmp); }
  }  /*if (capi_rscale2_tmp == NULL) ... else of rscale2*/
  /* End of cleaning variable rscale2 */
  } /*CHECKSCALAR((shape(expn1,0)-1)==nterms1)*/
  } /*if (f2py_success) of nterms1*/
  /* End of cleaning variable nterms1 */
  if((PyObject *)capi_expn1_tmp!=expn1_capi) {
    Py_XDECREF(capi_expn1_tmp); }
  }  /*if (capi_expn1_tmp == NULL) ... else of expn1*/
  /* End of cleaning variable expn1 */
  if((PyObject *)capi_center1_tmp!=center1_capi) {
    Py_XDECREF(capi_center1_tmp); }
  }  /*if (capi_center1_tmp == NULL) ... else of center1*/
  /* End of cleaning variable center1 */
  } /*CHECKSCALAR(len(rscale1)>=nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  if((PyObject *)capi_xnodes_tmp!=xnodes_capi) {
    Py_XDECREF(capi_xnodes_tmp); }
  }  /*if (capi_xnodes_tmp == NULL) ... else of xnodes*/
  /* End of cleaning variable xnodes */
  } /*if (f2py_success) of nterms2*/
  /* End of cleaning variable nterms2 */
  if((PyObject *)capi_rscale1_tmp!=rscale1_capi) {
    Py_XDECREF(capi_rscale1_tmp); }
  }  /*if (capi_rscale1_tmp == NULL) ... else of rscale1*/
  /* End of cleaning variable rscale1 */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/************************** end of h3dmplocquadu_vec **************************/

/***************************** h3dloclocquadu_vec *****************************/
static char doc_f2py_rout__internal_h3dloclocquadu_vec[] = "\
expn2,ier = h3dloclocquadu_vec(zk,rscale1,center1,expn1,rscale2,center2,nterms2,radius,xnodes,wts,[nterms1,nquad,nvcount])\n\nWrapper for ``h3dloclocquadu_vec``.\
\n\nParameters\n----------\n"
"zk : input complex\n"
"rscale1 : input rank-1 array('d') with bounds (nvcount)\n"
"center1 : input rank-2 array('d') with bounds (3,nvcount)\n"
"expn1 : input rank-3 array('D') with bounds (nterms1 + 1,2 * nterms1 + 1,nvcount)\n"
"rscale2 : input rank-1 array('d') with bounds (nvcount)\n"
"center2 : input rank-2 array('d') with bounds (3,nvcount)\n"
"nterms2 : input int\n"
"radius : input rank-1 array('d') with bounds (nvcount)\n"
"xnodes : input rank-1 array('d') with bounds (nquad)\n"
"wts : input rank-1 array('d') with bounds (nquad)\n"
"\nOther Parameters\n----------------\n"
"nterms1 : input int, optional\n    Default: (shape(expn1,0)-1)\n"
"nquad : input int, optional\n    Default: len(xnodes)\n"
"nvcount : input int, optional\n    Default: len(rscale1)\n"
"\nReturns\n-------\n"
"expn2 : rank-3 array('D') with bounds (nterms2 + 1,2 * nterms2 + 1,nvcount)\n"
"ier : rank-1 array('i') with bounds (nvcount)";
/* extern void F_FUNC_US(h3dloclocquadu_vec,H3DLOCLOCQUADU_VEC)(complex_double*,double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,double*,double*,double*,int*,int*,int*); */
static PyObject *f2py_rout__internal_h3dloclocquadu_vec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(complex_double*,double*,double*,complex_double*,int*,double*,double*,complex_double*,int*,double*,double*,double*,int*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  complex_double zk;
  PyObject *zk_capi = Py_None;
  double *rscale1 = NULL;
  npy_intp rscale1_Dims[1] = {-1};
  const int rscale1_Rank = 1;
  PyArrayObject *capi_rscale1_tmp = NULL;
  int capi_rscale1_intent = 0;
  PyObject *rscale1_capi = Py_None;
  double *center1 = NULL;
  npy_intp center1_Dims[2] = {-1, -1};
  const int center1_Rank = 2;
  PyArrayObject *capi_center1_tmp = NULL;
  int capi_center1_intent = 0;
  PyObject *center1_capi = Py_None;
  complex_double *expn1 = NULL;
  npy_intp expn1_Dims[3] = {-1, -1, -1};
  const int expn1_Rank = 3;
  PyArrayObject *capi_expn1_tmp = NULL;
  int capi_expn1_intent = 0;
  PyObject *expn1_capi = Py_None;
  int nterms1 = 0;
  PyObject *nterms1_capi = Py_None;
  double *rscale2 = NULL;
  npy_intp rscale2_Dims[1] = {-1};
  const int rscale2_Rank = 1;
  PyArrayObject *capi_rscale2_tmp = NULL;
  int capi_rscale2_intent = 0;
  PyObject *rscale2_capi = Py_None;
  double *center2 = NULL;
  npy_intp center2_Dims[2] = {-1, -1};
  const int center2_Rank = 2;
  PyArrayObject *capi_center2_tmp = NULL;
  int capi_center2_intent = 0;
  PyObject *center2_capi = Py_None;
  complex_double *expn2 = NULL;
  npy_intp expn2_Dims[3] = {-1, -1, -1};
  const int expn2_Rank = 3;
  PyArrayObject *capi_expn2_tmp = NULL;
  int capi_expn2_intent = 0;
  int nterms2 = 0;
  PyObject *nterms2_capi = Py_None;
  double *radius = NULL;
  npy_intp radius_Dims[1] = {-1};
  const int radius_Rank = 1;
  PyArrayObject *capi_radius_tmp = NULL;
  int capi_radius_intent = 0;
  PyObject *radius_capi = Py_None;
  double *xnodes = NULL;
  npy_intp xnodes_Dims[1] = {-1};
  const int xnodes_Rank = 1;
  PyArrayObject *capi_xnodes_tmp = NULL;
  int capi_xnodes_intent = 0;
  PyObject *xnodes_capi = Py_None;
  double *wts = NULL;
  npy_intp wts_Dims[1] = {-1};
  const int wts_Rank = 1;
  PyArrayObject *capi_wts_tmp = NULL;
  int capi_wts_intent = 0;
  PyObject *wts_capi = Py_None;
  int nquad = 0;
  PyObject *nquad_capi = Py_None;
  int *ier = NULL;
  npy_intp ier_Dims[1] = {-1};
  const int ier_Rank = 1;
  PyArrayObject *capi_ier_tmp = NULL;
  int capi_ier_intent = 0;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"zk","rscale1","center1","expn1","rscale2","center2","nterms2","radius","xnodes","wts","nterms1","nquad","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOO|OOO:_internal.h3dloclocquadu_vec",\
        capi_kwlist,&zk_capi,&rscale1_capi,&center1_capi,&expn1_capi,&rscale2_capi,&center2_capi,&nterms2_capi,&radius_capi,&xnodes_capi,&wts_capi,&nterms1_capi,&nquad_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.h3dloclocquadu_vec() 1st argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable rscale1 */
  ;
  capi_rscale1_intent |= F2PY_INTENT_IN;
  capi_rscale1_tmp = array_from_pyobj(NPY_DOUBLE,rscale1_Dims,rscale1_Rank,capi_rscale1_intent,rscale1_capi);
  if (capi_rscale1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `rscale1' of _internal.h3dloclocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale1 = (double *)(PyArray_DATA(capi_rscale1_tmp));

  /* Processing variable nterms2 */
    f2py_success = int_from_pyobj(&nterms2,nterms2_capi,"_internal.h3dloclocquadu_vec() 7th argument (nterms2) can't be converted to int");
  if (f2py_success) {
  /* Processing variable xnodes */
  ;
  capi_xnodes_intent |= F2PY_INTENT_IN;
  capi_xnodes_tmp = array_from_pyobj(NPY_DOUBLE,xnodes_Dims,xnodes_Rank,capi_xnodes_intent,xnodes_capi);
  if (capi_xnodes_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 9th argument `xnodes' of _internal.h3dloclocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    xnodes = (double *)(PyArray_DATA(capi_xnodes_tmp));

  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = len(rscale1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.h3dloclocquadu_vec() 3rd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(rscale1)>=nvcount,"len(rscale1)>=nvcount","3rd keyword nvcount","h3dloclocquadu_vec:nvcount=%d",nvcount) {
  /* Processing variable center1 */
  center1_Dims[0]=3,center1_Dims[1]=nvcount;
  capi_center1_intent |= F2PY_INTENT_IN;
  capi_center1_tmp = array_from_pyobj(NPY_DOUBLE,center1_Dims,center1_Rank,capi_center1_intent,center1_capi);
  if (capi_center1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `center1' of _internal.h3dloclocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center1 = (double *)(PyArray_DATA(capi_center1_tmp));

  /* Processing variable expn1 */
  expn1_Dims[2]=nvcount;
  capi_expn1_intent |= F2PY_INTENT_IN;
  capi_expn1_tmp = array_from_pyobj(NPY_CDOUBLE,expn1_Dims,expn1_Rank,capi_expn1_intent,expn1_capi);
  if (capi_expn1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `expn1' of _internal.h3dloclocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn1 = (complex_double *)(PyArray_DATA(capi_expn1_tmp));

  /* Processing variable nterms1 */
  if (nterms1_capi == Py_None) nterms1 = (shape(expn1,0)-1); else
    f2py_success = int_from_pyobj(&nterms1,nterms1_capi,"_internal.h3dloclocquadu_vec() 1st keyword (nterms1) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((shape(expn1,0)-1)==nterms1,"(shape(expn1,0)-1)==nterms1","1st keyword nterms1","h3dloclocquadu_vec:nterms1=%d",nterms1) {
  /* Processing variable rscale2 */
  rscale2_Dims[0]=nvcount;
  capi_rscale2_intent |= F2PY_INTENT_IN;
  capi_rscale2_tmp = array_from_pyobj(NPY_DOUBLE,rscale2_Dims,rscale2_Rank,capi_rscale2_intent,rscale2_capi);
  if (capi_rscale2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `rscale2' of _internal.h3dloclocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale2 = (double *)(PyArray_DATA(capi_rscale2_tmp));

  /* Processing variable center2 */
  center2_Dims[0]=3,center2_Dims[1]=nvcount;
  capi_center2_intent |= F2PY_INTENT_IN;
  capi_center2_tmp = array_from_pyobj(NPY_DOUBLE,center2_Dims,center2_Rank,capi_center2_intent,center2_capi);
  if (capi_center2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `center2' of _internal.h3dloclocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center2 = (double *)(PyArray_DATA(capi_center2_tmp));

  /* Processing variable expn2 */
  expn2_Dims[0]=nterms2 + 1,expn2_Dims[1]=2 * nterms2 + 1,expn2_Dims[2]=nvcount;
  capi_expn2_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_expn2_tmp = array_from_pyobj(NPY_CDOUBLE,expn2_Dims,expn2_Rank,capi_expn2_intent,Py_None);
  if (capi_expn2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `expn2' of _internal.h3dloclocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn2 = (complex_double *)(PyArray_DATA(capi_expn2_tmp));

  /* Processing variable radius */
  radius_Dims[0]=nvcount;
  capi_radius_intent |= F2PY_INTENT_IN;
  capi_radius_tmp = array_from_pyobj(NPY_DOUBLE,radius_Dims,radius_Rank,capi_radius_intent,radius_capi);
  if (capi_radius_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 8th argument `radius' of _internal.h3dloclocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    radius = (double *)(PyArray_DATA(capi_radius_tmp));

  /* Processing variable nquad */
  if (nquad_capi == Py_None) nquad = len(xnodes); else
    f2py_success = int_from_pyobj(&nquad,nquad_capi,"_internal.h3dloclocquadu_vec() 2nd keyword (nquad) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(xnodes)>=nquad,"len(xnodes)>=nquad","2nd keyword nquad","h3dloclocquadu_vec:nquad=%d",nquad) {
  /* Processing variable ier */
  ier_Dims[0]=nvcount;
  capi_ier_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_ier_tmp = array_from_pyobj(NPY_INT,ier_Dims,ier_Rank,capi_ier_intent,Py_None);
  if (capi_ier_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting hidden `ier' of _internal.h3dloclocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ier = (int *)(PyArray_DATA(capi_ier_tmp));

  /* Processing variable wts */
  wts_Dims[0]=nquad;
  capi_wts_intent |= F2PY_INTENT_IN;
  capi_wts_tmp = array_from_pyobj(NPY_DOUBLE,wts_Dims,wts_Rank,capi_wts_intent,wts_capi);
  if (capi_wts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 10th argument `wts' of _internal.h3dloclocquadu_vec to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    wts = (double *)(PyArray_DATA(capi_wts_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&zk,rscale1,center1,expn1,&nterms1,rscale2,center2,expn2,&nterms2,radius,xnodes,wts,&nquad,ier,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NN",capi_expn2_tmp,capi_ier_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_wts_tmp!=wts_capi) {
    Py_XDECREF(capi_wts_tmp); }
  }  /*if (capi_wts_tmp == NULL) ... else of wts*/
  /* End of cleaning variable wts */
  }  /*if (capi_ier_tmp == NULL) ... else of ier*/
  /* End of cleaning variable ier */
  } /*CHECKSCALAR(len(xnodes)>=nquad)*/
  } /*if (f2py_success) of nquad*/
  /* End of cleaning variable nquad */
  if((PyObject *)capi_radius_tmp!=radius_capi) {
    Py_XDECREF(capi_radius_tmp); }
  }  /*if (capi_radius_tmp == NULL) ... else of radius*/
  /* End of cleaning variable radius */
  }  /*if (capi_expn2_tmp == NULL) ... else of expn2*/
  /* End of cleaning variable expn2 */
  if((PyObject *)capi_center2_tmp!=center2_capi) {
    Py_XDECREF(capi_center2_tmp); }
  }  /*if (capi_center2_tmp == NULL) ... else of center2*/
  /* End of cleaning variable center2 */
  if((PyObject *)capi_rscale2_tmp!=rscale2_capi) {
    Py_XDECREF(capi_rscale2_tmp); }
  }  /*if (capi_rscale2_tmp == NULL) ... else of rscale2*/
  /* End of cleaning variable rscale2 */
  } /*CHECKSCALAR((shape(expn1,0)-1)==nterms1)*/
  } /*if (f2py_success) of nterms1*/
  /* End of cleaning variable nterms1 */
  if((PyObject *)capi_expn1_tmp!=expn1_capi) {
    Py_XDECREF(capi_expn1_tmp); }
  }  /*if (capi_expn1_tmp == NULL) ... else of expn1*/
  /* End of cleaning variable expn1 */
  if((PyObject *)capi_center1_tmp!=center1_capi) {
    Py_XDECREF(capi_center1_tmp); }
  }  /*if (capi_center1_tmp == NULL) ... else of center1*/
  /* End of cleaning variable center1 */
  } /*CHECKSCALAR(len(rscale1)>=nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  if((PyObject *)capi_xnodes_tmp!=xnodes_capi) {
    Py_XDECREF(capi_xnodes_tmp); }
  }  /*if (capi_xnodes_tmp == NULL) ... else of xnodes*/
  /* End of cleaning variable xnodes */
  } /*if (f2py_success) of nterms2*/
  /* End of cleaning variable nterms2 */
  if((PyObject *)capi_rscale1_tmp!=rscale1_capi) {
    Py_XDECREF(capi_rscale1_tmp); }
  }  /*if (capi_rscale1_tmp == NULL) ... else of rscale1*/
  /* End of cleaning variable rscale1 */
  }  /*if (f2py_success) of zk frompyobj*/
  /* End of cleaning variable zk */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/************************* end of h3dloclocquadu_vec *************************/

/******************************* l2dmpmp_imany *******************************/
static char doc_f2py_rout__internal_l2dmpmp_imany[] = "\
expn2 = l2dmpmp_imany(rscale1,rscale1_offsets,rscale1_starts,center1,center1_offsets,center1_starts,expn1,expn1_offsets,expn1_starts,rscale2,center2,expn2,[nterms1,nterms2,nvcount])\n\nWrapper for ``l2dmpmp_imany``.\
\n\nParameters\n----------\n"
"rscale1 : input rank-1 array('d') with bounds (*)\n"
"rscale1_offsets : input rank-1 array('i') with bounds (*)\n"
"rscale1_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"center1 : input rank-2 array('d') with bounds (2,*)\n"
"center1_offsets : input rank-1 array('i') with bounds (*)\n"
"center1_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"expn1 : input rank-2 array('D') with bounds (nterms1 + 1,*)\n"
"expn1_offsets : input rank-1 array('i') with bounds (*)\n"
"expn1_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"rscale2 : input rank-1 array('d') with bounds (nvcount)\n"
"center2 : input rank-2 array('d') with bounds (2,nvcount)\n"
"expn2 : input rank-2 array('D') with bounds (nterms2 + 1,nvcount)\n"
"\nOther Parameters\n----------------\n"
"nterms1 : input int, optional\n    Default: (shape(expn1,0)-1)\n"
"nterms2 : input int, optional\n    Default: (shape(expn2,0)-1)\n"
"nvcount : input int, optional\n    Default: (len(rscale1_starts)-1)\n"
"\nReturns\n-------\n"
"expn2 : rank-2 array('D') with bounds (nterms2 + 1,nvcount)";
/* extern void F_FUNC_US(l2dmpmp_imany,L2DMPMP_IMANY)(double*,int*,int*,double*,int*,int*,complex_double*,int*,int*,int*,double*,double*,complex_double*,int*,int*); */
static PyObject *f2py_rout__internal_l2dmpmp_imany(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,int*,double*,int*,int*,complex_double*,int*,int*,int*,double*,double*,complex_double*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double *rscale1 = NULL;
  npy_intp rscale1_Dims[1] = {-1};
  const int rscale1_Rank = 1;
  PyArrayObject *capi_rscale1_tmp = NULL;
  int capi_rscale1_intent = 0;
  PyObject *rscale1_capi = Py_None;
  int *rscale1_offsets = NULL;
  npy_intp rscale1_offsets_Dims[1] = {-1};
  const int rscale1_offsets_Rank = 1;
  PyArrayObject *capi_rscale1_offsets_tmp = NULL;
  int capi_rscale1_offsets_intent = 0;
  PyObject *rscale1_offsets_capi = Py_None;
  int *rscale1_starts = NULL;
  npy_intp rscale1_starts_Dims[1] = {-1};
  const int rscale1_starts_Rank = 1;
  PyArrayObject *capi_rscale1_starts_tmp = NULL;
  int capi_rscale1_starts_intent = 0;
  PyObject *rscale1_starts_capi = Py_None;
  double *center1 = NULL;
  npy_intp center1_Dims[2] = {-1, -1};
  const int center1_Rank = 2;
  PyArrayObject *capi_center1_tmp = NULL;
  int capi_center1_intent = 0;
  PyObject *center1_capi = Py_None;
  int *center1_offsets = NULL;
  npy_intp center1_offsets_Dims[1] = {-1};
  const int center1_offsets_Rank = 1;
  PyArrayObject *capi_center1_offsets_tmp = NULL;
  int capi_center1_offsets_intent = 0;
  PyObject *center1_offsets_capi = Py_None;
  int *center1_starts = NULL;
  npy_intp center1_starts_Dims[1] = {-1};
  const int center1_starts_Rank = 1;
  PyArrayObject *capi_center1_starts_tmp = NULL;
  int capi_center1_starts_intent = 0;
  PyObject *center1_starts_capi = Py_None;
  complex_double *expn1 = NULL;
  npy_intp expn1_Dims[2] = {-1, -1};
  const int expn1_Rank = 2;
  PyArrayObject *capi_expn1_tmp = NULL;
  int capi_expn1_intent = 0;
  PyObject *expn1_capi = Py_None;
  int *expn1_offsets = NULL;
  npy_intp expn1_offsets_Dims[1] = {-1};
  const int expn1_offsets_Rank = 1;
  PyArrayObject *capi_expn1_offsets_tmp = NULL;
  int capi_expn1_offsets_intent = 0;
  PyObject *expn1_offsets_capi = Py_None;
  int *expn1_starts = NULL;
  npy_intp expn1_starts_Dims[1] = {-1};
  const int expn1_starts_Rank = 1;
  PyArrayObject *capi_expn1_starts_tmp = NULL;
  int capi_expn1_starts_intent = 0;
  PyObject *expn1_starts_capi = Py_None;
  int nterms1 = 0;
  PyObject *nterms1_capi = Py_None;
  double *rscale2 = NULL;
  npy_intp rscale2_Dims[1] = {-1};
  const int rscale2_Rank = 1;
  PyArrayObject *capi_rscale2_tmp = NULL;
  int capi_rscale2_intent = 0;
  PyObject *rscale2_capi = Py_None;
  double *center2 = NULL;
  npy_intp center2_Dims[2] = {-1, -1};
  const int center2_Rank = 2;
  PyArrayObject *capi_center2_tmp = NULL;
  int capi_center2_intent = 0;
  PyObject *center2_capi = Py_None;
  complex_double *expn2 = NULL;
  npy_intp expn2_Dims[2] = {-1, -1};
  const int expn2_Rank = 2;
  PyArrayObject *capi_expn2_tmp = NULL;
  int capi_expn2_intent = 0;
  PyObject *expn2_capi = Py_None;
  int nterms2 = 0;
  PyObject *nterms2_capi = Py_None;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"rscale1","rscale1_offsets","rscale1_starts","center1","center1_offsets","center1_starts","expn1","expn1_offsets","expn1_starts","rscale2","center2","expn2","nterms1","nterms2","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOOOO|OOO:_internal.l2dmpmp_imany",\
        capi_kwlist,&rscale1_capi,&rscale1_offsets_capi,&rscale1_starts_capi,&center1_capi,&center1_offsets_capi,&center1_starts_capi,&expn1_capi,&expn1_offsets_capi,&expn1_starts_capi,&rscale2_capi,&center2_capi,&expn2_capi,&nterms1_capi,&nterms2_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale1 */
  ;
  capi_rscale1_intent |= F2PY_INTENT_IN;
  capi_rscale1_tmp = array_from_pyobj(NPY_DOUBLE,rscale1_Dims,rscale1_Rank,capi_rscale1_intent,rscale1_capi);
  if (capi_rscale1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 1st argument `rscale1' of _internal.l2dmpmp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale1 = (double *)(PyArray_DATA(capi_rscale1_tmp));

  /* Processing variable rscale1_offsets */
  ;
  capi_rscale1_offsets_intent |= F2PY_INTENT_IN;
  capi_rscale1_offsets_tmp = array_from_pyobj(NPY_INT,rscale1_offsets_Dims,rscale1_offsets_Rank,capi_rscale1_offsets_intent,rscale1_offsets_capi);
  if (capi_rscale1_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `rscale1_offsets' of _internal.l2dmpmp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale1_offsets = (int *)(PyArray_DATA(capi_rscale1_offsets_tmp));

  /* Processing variable rscale1_starts */
  ;
  capi_rscale1_starts_intent |= F2PY_INTENT_IN;
  capi_rscale1_starts_tmp = array_from_pyobj(NPY_INT,rscale1_starts_Dims,rscale1_starts_Rank,capi_rscale1_starts_intent,rscale1_starts_capi);
  if (capi_rscale1_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `rscale1_starts' of _internal.l2dmpmp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale1_starts = (int *)(PyArray_DATA(capi_rscale1_starts_tmp));

  /* Processing variable center1 */
  center1_Dims[0]=2;
  capi_center1_intent |= F2PY_INTENT_IN;
  capi_center1_tmp = array_from_pyobj(NPY_DOUBLE,center1_Dims,center1_Rank,capi_center1_intent,center1_capi);
  if (capi_center1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `center1' of _internal.l2dmpmp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center1 = (double *)(PyArray_DATA(capi_center1_tmp));

  /* Processing variable center1_offsets */
  ;
  capi_center1_offsets_intent |= F2PY_INTENT_IN;
  capi_center1_offsets_tmp = array_from_pyobj(NPY_INT,center1_offsets_Dims,center1_offsets_Rank,capi_center1_offsets_intent,center1_offsets_capi);
  if (capi_center1_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `center1_offsets' of _internal.l2dmpmp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center1_offsets = (int *)(PyArray_DATA(capi_center1_offsets_tmp));

  /* Processing variable expn1 */
  ;
  capi_expn1_intent |= F2PY_INTENT_IN;
  capi_expn1_tmp = array_from_pyobj(NPY_CDOUBLE,expn1_Dims,expn1_Rank,capi_expn1_intent,expn1_capi);
  if (capi_expn1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 7th argument `expn1' of _internal.l2dmpmp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn1 = (complex_double *)(PyArray_DATA(capi_expn1_tmp));

  /* Processing variable expn1_offsets */
  ;
  capi_expn1_offsets_intent |= F2PY_INTENT_IN;
  capi_expn1_offsets_tmp = array_from_pyobj(NPY_INT,expn1_offsets_Dims,expn1_offsets_Rank,capi_expn1_offsets_intent,expn1_offsets_capi);
  if (capi_expn1_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 8th argument `expn1_offsets' of _internal.l2dmpmp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn1_offsets = (int *)(PyArray_DATA(capi_expn1_offsets_tmp));

  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = (len(rscale1_starts)-1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.l2dmpmp_imany() 3rd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((len(rscale1_starts)-1)>=nvcount,"(len(rscale1_starts)-1)>=nvcount","3rd keyword nvcount","l2dmpmp_imany:nvcount=%d",nvcount) {
  /* Processing variable center1_starts */
  center1_starts_Dims[0]=nvcount + 1;
  capi_center1_starts_intent |= F2PY_INTENT_IN;
  capi_center1_starts_tmp = array_from_pyobj(NPY_INT,center1_starts_Dims,center1_starts_Rank,capi_center1_starts_intent,center1_starts_capi);
  if (capi_center1_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `center1_starts' of _internal.l2dmpmp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center1_starts = (int *)(PyArray_DATA(capi_center1_starts_tmp));

  /* Processing variable expn1_starts */
  expn1_starts_Dims[0]=nvcount + 1;
  capi_expn1_starts_intent |= F2PY_INTENT_IN;
  capi_expn1_starts_tmp = array_from_pyobj(NPY_INT,expn1_starts_Dims,expn1_starts_Rank,capi_expn1_starts_intent,expn1_starts_capi);
  if (capi_expn1_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 9th argument `expn1_starts' of _internal.l2dmpmp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn1_starts = (int *)(PyArray_DATA(capi_expn1_starts_tmp));

  /* Processing variable nterms1 */
  if (nterms1_capi == Py_None) nterms1 = (shape(expn1,0)-1); else
    f2py_success = int_from_pyobj(&nterms1,nterms1_capi,"_internal.l2dmpmp_imany() 1st keyword (nterms1) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((shape(expn1,0)-1)==nterms1,"(shape(expn1,0)-1)==nterms1","1st keyword nterms1","l2dmpmp_imany:nterms1=%d",nterms1) {
  /* Processing variable rscale2 */
  rscale2_Dims[0]=nvcount;
  capi_rscale2_intent |= F2PY_INTENT_IN;
  capi_rscale2_tmp = array_from_pyobj(NPY_DOUBLE,rscale2_Dims,rscale2_Rank,capi_rscale2_intent,rscale2_capi);
  if (capi_rscale2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 10th argument `rscale2' of _internal.l2dmpmp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale2 = (double *)(PyArray_DATA(capi_rscale2_tmp));

  /* Processing variable center2 */
  center2_Dims[0]=2,center2_Dims[1]=nvcount;
  capi_center2_intent |= F2PY_INTENT_IN;
  capi_center2_tmp = array_from_pyobj(NPY_DOUBLE,center2_Dims,center2_Rank,capi_center2_intent,center2_capi);
  if (capi_center2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 11st argument `center2' of _internal.l2dmpmp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center2 = (double *)(PyArray_DATA(capi_center2_tmp));

  /* Processing variable expn2 */
  expn2_Dims[1]=nvcount;
  capi_expn2_intent |= F2PY_INTENT_IN|F2PY_INTENT_OUT;
  capi_expn2_tmp = array_from_pyobj(NPY_CDOUBLE,expn2_Dims,expn2_Rank,capi_expn2_intent,expn2_capi);
  if (capi_expn2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 12nd argument `expn2' of _internal.l2dmpmp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn2 = (complex_double *)(PyArray_DATA(capi_expn2_tmp));

  /* Processing variable nterms2 */
  if (nterms2_capi == Py_None) nterms2 = (shape(expn2,0)-1); else
    f2py_success = int_from_pyobj(&nterms2,nterms2_capi,"_internal.l2dmpmp_imany() 2nd keyword (nterms2) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((shape(expn2,0)-1)==nterms2,"(shape(expn2,0)-1)==nterms2","2nd keyword nterms2","l2dmpmp_imany:nterms2=%d",nterms2) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(rscale1,rscale1_offsets,rscale1_starts,center1,center1_offsets,center1_starts,expn1,expn1_offsets,expn1_starts,&nterms1,rscale2,center2,expn2,&nterms2,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("N",capi_expn2_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*CHECKSCALAR((shape(expn2,0)-1)==nterms2)*/
  } /*if (f2py_success) of nterms2*/
  /* End of cleaning variable nterms2 */
  }  /*if (capi_expn2_tmp == NULL) ... else of expn2*/
  /* End of cleaning variable expn2 */
  if((PyObject *)capi_center2_tmp!=center2_capi) {
    Py_XDECREF(capi_center2_tmp); }
  }  /*if (capi_center2_tmp == NULL) ... else of center2*/
  /* End of cleaning variable center2 */
  if((PyObject *)capi_rscale2_tmp!=rscale2_capi) {
    Py_XDECREF(capi_rscale2_tmp); }
  }  /*if (capi_rscale2_tmp == NULL) ... else of rscale2*/
  /* End of cleaning variable rscale2 */
  } /*CHECKSCALAR((shape(expn1,0)-1)==nterms1)*/
  } /*if (f2py_success) of nterms1*/
  /* End of cleaning variable nterms1 */
  if((PyObject *)capi_expn1_starts_tmp!=expn1_starts_capi) {
    Py_XDECREF(capi_expn1_starts_tmp); }
  }  /*if (capi_expn1_starts_tmp == NULL) ... else of expn1_starts*/
  /* End of cleaning variable expn1_starts */
  if((PyObject *)capi_center1_starts_tmp!=center1_starts_capi) {
    Py_XDECREF(capi_center1_starts_tmp); }
  }  /*if (capi_center1_starts_tmp == NULL) ... else of center1_starts*/
  /* End of cleaning variable center1_starts */
  } /*CHECKSCALAR((len(rscale1_starts)-1)>=nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  if((PyObject *)capi_expn1_offsets_tmp!=expn1_offsets_capi) {
    Py_XDECREF(capi_expn1_offsets_tmp); }
  }  /*if (capi_expn1_offsets_tmp == NULL) ... else of expn1_offsets*/
  /* End of cleaning variable expn1_offsets */
  if((PyObject *)capi_expn1_tmp!=expn1_capi) {
    Py_XDECREF(capi_expn1_tmp); }
  }  /*if (capi_expn1_tmp == NULL) ... else of expn1*/
  /* End of cleaning variable expn1 */
  if((PyObject *)capi_center1_offsets_tmp!=center1_offsets_capi) {
    Py_XDECREF(capi_center1_offsets_tmp); }
  }  /*if (capi_center1_offsets_tmp == NULL) ... else of center1_offsets*/
  /* End of cleaning variable center1_offsets */
  if((PyObject *)capi_center1_tmp!=center1_capi) {
    Py_XDECREF(capi_center1_tmp); }
  }  /*if (capi_center1_tmp == NULL) ... else of center1*/
  /* End of cleaning variable center1 */
  if((PyObject *)capi_rscale1_starts_tmp!=rscale1_starts_capi) {
    Py_XDECREF(capi_rscale1_starts_tmp); }
  }  /*if (capi_rscale1_starts_tmp == NULL) ... else of rscale1_starts*/
  /* End of cleaning variable rscale1_starts */
  if((PyObject *)capi_rscale1_offsets_tmp!=rscale1_offsets_capi) {
    Py_XDECREF(capi_rscale1_offsets_tmp); }
  }  /*if (capi_rscale1_offsets_tmp == NULL) ... else of rscale1_offsets*/
  /* End of cleaning variable rscale1_offsets */
  if((PyObject *)capi_rscale1_tmp!=rscale1_capi) {
    Py_XDECREF(capi_rscale1_tmp); }
  }  /*if (capi_rscale1_tmp == NULL) ... else of rscale1*/
  /* End of cleaning variable rscale1 */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/**************************** end of l2dmpmp_imany ****************************/

/******************************* l2dmploc_imany *******************************/
static char doc_f2py_rout__internal_l2dmploc_imany[] = "\
expn2 = l2dmploc_imany(rscale1,rscale1_offsets,rscale1_starts,center1,center1_offsets,center1_starts,expn1,expn1_offsets,expn1_starts,rscale2,center2,expn2,[nterms1,nterms2,nvcount])\n\nWrapper for ``l2dmploc_imany``.\
\n\nParameters\n----------\n"
"rscale1 : input rank-1 array('d') with bounds (*)\n"
"rscale1_offsets : input rank-1 array('i') with bounds (*)\n"
"rscale1_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"center1 : input rank-2 array('d') with bounds (2,*)\n"
"center1_offsets : input rank-1 array('i') with bounds (*)\n"
"center1_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"expn1 : input rank-2 array('D') with bounds (nterms1 + 1,*)\n"
"expn1_offsets : input rank-1 array('i') with bounds (*)\n"
"expn1_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"rscale2 : input rank-1 array('d') with bounds (nvcount)\n"
"center2 : input rank-2 array('d') with bounds (2,nvcount)\n"
"expn2 : input rank-2 array('D') with bounds (nterms2 + 1,nvcount)\n"
"\nOther Parameters\n----------------\n"
"nterms1 : input int, optional\n    Default: (shape(expn1,0)-1)\n"
"nterms2 : input int, optional\n    Default: (shape(expn2,0)-1)\n"
"nvcount : input int, optional\n    Default: (len(rscale1_starts)-1)\n"
"\nReturns\n-------\n"
"expn2 : rank-2 array('D') with bounds (nterms2 + 1,nvcount)";
/* extern void F_FUNC_US(l2dmploc_imany,L2DMPLOC_IMANY)(double*,int*,int*,double*,int*,int*,complex_double*,int*,int*,int*,double*,double*,complex_double*,int*,int*); */
static PyObject *f2py_rout__internal_l2dmploc_imany(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,int*,double*,int*,int*,complex_double*,int*,int*,int*,double*,double*,complex_double*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double *rscale1 = NULL;
  npy_intp rscale1_Dims[1] = {-1};
  const int rscale1_Rank = 1;
  PyArrayObject *capi_rscale1_tmp = NULL;
  int capi_rscale1_intent = 0;
  PyObject *rscale1_capi = Py_None;
  int *rscale1_offsets = NULL;
  npy_intp rscale1_offsets_Dims[1] = {-1};
  const int rscale1_offsets_Rank = 1;
  PyArrayObject *capi_rscale1_offsets_tmp = NULL;
  int capi_rscale1_offsets_intent = 0;
  PyObject *rscale1_offsets_capi = Py_None;
  int *rscale1_starts = NULL;
  npy_intp rscale1_starts_Dims[1] = {-1};
  const int rscale1_starts_Rank = 1;
  PyArrayObject *capi_rscale1_starts_tmp = NULL;
  int capi_rscale1_starts_intent = 0;
  PyObject *rscale1_starts_capi = Py_None;
  double *center1 = NULL;
  npy_intp center1_Dims[2] = {-1, -1};
  const int center1_Rank = 2;
  PyArrayObject *capi_center1_tmp = NULL;
  int capi_center1_intent = 0;
  PyObject *center1_capi = Py_None;
  int *center1_offsets = NULL;
  npy_intp center1_offsets_Dims[1] = {-1};
  const int center1_offsets_Rank = 1;
  PyArrayObject *capi_center1_offsets_tmp = NULL;
  int capi_center1_offsets_intent = 0;
  PyObject *center1_offsets_capi = Py_None;
  int *center1_starts = NULL;
  npy_intp center1_starts_Dims[1] = {-1};
  const int center1_starts_Rank = 1;
  PyArrayObject *capi_center1_starts_tmp = NULL;
  int capi_center1_starts_intent = 0;
  PyObject *center1_starts_capi = Py_None;
  complex_double *expn1 = NULL;
  npy_intp expn1_Dims[2] = {-1, -1};
  const int expn1_Rank = 2;
  PyArrayObject *capi_expn1_tmp = NULL;
  int capi_expn1_intent = 0;
  PyObject *expn1_capi = Py_None;
  int *expn1_offsets = NULL;
  npy_intp expn1_offsets_Dims[1] = {-1};
  const int expn1_offsets_Rank = 1;
  PyArrayObject *capi_expn1_offsets_tmp = NULL;
  int capi_expn1_offsets_intent = 0;
  PyObject *expn1_offsets_capi = Py_None;
  int *expn1_starts = NULL;
  npy_intp expn1_starts_Dims[1] = {-1};
  const int expn1_starts_Rank = 1;
  PyArrayObject *capi_expn1_starts_tmp = NULL;
  int capi_expn1_starts_intent = 0;
  PyObject *expn1_starts_capi = Py_None;
  int nterms1 = 0;
  PyObject *nterms1_capi = Py_None;
  double *rscale2 = NULL;
  npy_intp rscale2_Dims[1] = {-1};
  const int rscale2_Rank = 1;
  PyArrayObject *capi_rscale2_tmp = NULL;
  int capi_rscale2_intent = 0;
  PyObject *rscale2_capi = Py_None;
  double *center2 = NULL;
  npy_intp center2_Dims[2] = {-1, -1};
  const int center2_Rank = 2;
  PyArrayObject *capi_center2_tmp = NULL;
  int capi_center2_intent = 0;
  PyObject *center2_capi = Py_None;
  complex_double *expn2 = NULL;
  npy_intp expn2_Dims[2] = {-1, -1};
  const int expn2_Rank = 2;
  PyArrayObject *capi_expn2_tmp = NULL;
  int capi_expn2_intent = 0;
  PyObject *expn2_capi = Py_None;
  int nterms2 = 0;
  PyObject *nterms2_capi = Py_None;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"rscale1","rscale1_offsets","rscale1_starts","center1","center1_offsets","center1_starts","expn1","expn1_offsets","expn1_starts","rscale2","center2","expn2","nterms1","nterms2","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOOOO|OOO:_internal.l2dmploc_imany",\
        capi_kwlist,&rscale1_capi,&rscale1_offsets_capi,&rscale1_starts_capi,&center1_capi,&center1_offsets_capi,&center1_starts_capi,&expn1_capi,&expn1_offsets_capi,&expn1_starts_capi,&rscale2_capi,&center2_capi,&expn2_capi,&nterms1_capi,&nterms2_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale1 */
  ;
  capi_rscale1_intent |= F2PY_INTENT_IN;
  capi_rscale1_tmp = array_from_pyobj(NPY_DOUBLE,rscale1_Dims,rscale1_Rank,capi_rscale1_intent,rscale1_capi);
  if (capi_rscale1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 1st argument `rscale1' of _internal.l2dmploc_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale1 = (double *)(PyArray_DATA(capi_rscale1_tmp));

  /* Processing variable rscale1_offsets */
  ;
  capi_rscale1_offsets_intent |= F2PY_INTENT_IN;
  capi_rscale1_offsets_tmp = array_from_pyobj(NPY_INT,rscale1_offsets_Dims,rscale1_offsets_Rank,capi_rscale1_offsets_intent,rscale1_offsets_capi);
  if (capi_rscale1_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `rscale1_offsets' of _internal.l2dmploc_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale1_offsets = (int *)(PyArray_DATA(capi_rscale1_offsets_tmp));

  /* Processing variable rscale1_starts */
  ;
  capi_rscale1_starts_intent |= F2PY_INTENT_IN;
  capi_rscale1_starts_tmp = array_from_pyobj(NPY_INT,rscale1_starts_Dims,rscale1_starts_Rank,capi_rscale1_starts_intent,rscale1_starts_capi);
  if (capi_rscale1_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `rscale1_starts' of _internal.l2dmploc_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale1_starts = (int *)(PyArray_DATA(capi_rscale1_starts_tmp));

  /* Processing variable center1 */
  center1_Dims[0]=2;
  capi_center1_intent |= F2PY_INTENT_IN;
  capi_center1_tmp = array_from_pyobj(NPY_DOUBLE,center1_Dims,center1_Rank,capi_center1_intent,center1_capi);
  if (capi_center1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `center1' of _internal.l2dmploc_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center1 = (double *)(PyArray_DATA(capi_center1_tmp));

  /* Processing variable center1_offsets */
  ;
  capi_center1_offsets_intent |= F2PY_INTENT_IN;
  capi_center1_offsets_tmp = array_from_pyobj(NPY_INT,center1_offsets_Dims,center1_offsets_Rank,capi_center1_offsets_intent,center1_offsets_capi);
  if (capi_center1_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `center1_offsets' of _internal.l2dmploc_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center1_offsets = (int *)(PyArray_DATA(capi_center1_offsets_tmp));

  /* Processing variable expn1 */
  ;
  capi_expn1_intent |= F2PY_INTENT_IN;
  capi_expn1_tmp = array_from_pyobj(NPY_CDOUBLE,expn1_Dims,expn1_Rank,capi_expn1_intent,expn1_capi);
  if (capi_expn1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 7th argument `expn1' of _internal.l2dmploc_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn1 = (complex_double *)(PyArray_DATA(capi_expn1_tmp));

  /* Processing variable expn1_offsets */
  ;
  capi_expn1_offsets_intent |= F2PY_INTENT_IN;
  capi_expn1_offsets_tmp = array_from_pyobj(NPY_INT,expn1_offsets_Dims,expn1_offsets_Rank,capi_expn1_offsets_intent,expn1_offsets_capi);
  if (capi_expn1_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 8th argument `expn1_offsets' of _internal.l2dmploc_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn1_offsets = (int *)(PyArray_DATA(capi_expn1_offsets_tmp));

  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = (len(rscale1_starts)-1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.l2dmploc_imany() 3rd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((len(rscale1_starts)-1)>=nvcount,"(len(rscale1_starts)-1)>=nvcount","3rd keyword nvcount","l2dmploc_imany:nvcount=%d",nvcount) {
  /* Processing variable center1_starts */
  center1_starts_Dims[0]=nvcount + 1;
  capi_center1_starts_intent |= F2PY_INTENT_IN;
  capi_center1_starts_tmp = array_from_pyobj(NPY_INT,center1_starts_Dims,center1_starts_Rank,capi_center1_starts_intent,center1_starts_capi);
  if (capi_center1_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `center1_starts' of _internal.l2dmploc_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center1_starts = (int *)(PyArray_DATA(capi_center1_starts_tmp));

  /* Processing variable expn1_starts */
  expn1_starts_Dims[0]=nvcount + 1;
  capi_expn1_starts_intent |= F2PY_INTENT_IN;
  capi_expn1_starts_tmp = array_from_pyobj(NPY_INT,expn1_starts_Dims,expn1_starts_Rank,capi_expn1_starts_intent,expn1_starts_capi);
  if (capi_expn1_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 9th argument `expn1_starts' of _internal.l2dmploc_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn1_starts = (int *)(PyArray_DATA(capi_expn1_starts_tmp));

  /* Processing variable nterms1 */
  if (nterms1_capi == Py_None) nterms1 = (shape(expn1,0)-1); else
    f2py_success = int_from_pyobj(&nterms1,nterms1_capi,"_internal.l2dmploc_imany() 1st keyword (nterms1) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((shape(expn1,0)-1)==nterms1,"(shape(expn1,0)-1)==nterms1","1st keyword nterms1","l2dmploc_imany:nterms1=%d",nterms1) {
  /* Processing variable rscale2 */
  rscale2_Dims[0]=nvcount;
  capi_rscale2_intent |= F2PY_INTENT_IN;
  capi_rscale2_tmp = array_from_pyobj(NPY_DOUBLE,rscale2_Dims,rscale2_Rank,capi_rscale2_intent,rscale2_capi);
  if (capi_rscale2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 10th argument `rscale2' of _internal.l2dmploc_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale2 = (double *)(PyArray_DATA(capi_rscale2_tmp));

  /* Processing variable center2 */
  center2_Dims[0]=2,center2_Dims[1]=nvcount;
  capi_center2_intent |= F2PY_INTENT_IN;
  capi_center2_tmp = array_from_pyobj(NPY_DOUBLE,center2_Dims,center2_Rank,capi_center2_intent,center2_capi);
  if (capi_center2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 11st argument `center2' of _internal.l2dmploc_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center2 = (double *)(PyArray_DATA(capi_center2_tmp));

  /* Processing variable expn2 */
  expn2_Dims[1]=nvcount;
  capi_expn2_intent |= F2PY_INTENT_IN|F2PY_INTENT_OUT;
  capi_expn2_tmp = array_from_pyobj(NPY_CDOUBLE,expn2_Dims,expn2_Rank,capi_expn2_intent,expn2_capi);
  if (capi_expn2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 12nd argument `expn2' of _internal.l2dmploc_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn2 = (complex_double *)(PyArray_DATA(capi_expn2_tmp));

  /* Processing variable nterms2 */
  if (nterms2_capi == Py_None) nterms2 = (shape(expn2,0)-1); else
    f2py_success = int_from_pyobj(&nterms2,nterms2_capi,"_internal.l2dmploc_imany() 2nd keyword (nterms2) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((shape(expn2,0)-1)==nterms2,"(shape(expn2,0)-1)==nterms2","2nd keyword nterms2","l2dmploc_imany:nterms2=%d",nterms2) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(rscale1,rscale1_offsets,rscale1_starts,center1,center1_offsets,center1_starts,expn1,expn1_offsets,expn1_starts,&nterms1,rscale2,center2,expn2,&nterms2,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("N",capi_expn2_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*CHECKSCALAR((shape(expn2,0)-1)==nterms2)*/
  } /*if (f2py_success) of nterms2*/
  /* End of cleaning variable nterms2 */
  }  /*if (capi_expn2_tmp == NULL) ... else of expn2*/
  /* End of cleaning variable expn2 */
  if((PyObject *)capi_center2_tmp!=center2_capi) {
    Py_XDECREF(capi_center2_tmp); }
  }  /*if (capi_center2_tmp == NULL) ... else of center2*/
  /* End of cleaning variable center2 */
  if((PyObject *)capi_rscale2_tmp!=rscale2_capi) {
    Py_XDECREF(capi_rscale2_tmp); }
  }  /*if (capi_rscale2_tmp == NULL) ... else of rscale2*/
  /* End of cleaning variable rscale2 */
  } /*CHECKSCALAR((shape(expn1,0)-1)==nterms1)*/
  } /*if (f2py_success) of nterms1*/
  /* End of cleaning variable nterms1 */
  if((PyObject *)capi_expn1_starts_tmp!=expn1_starts_capi) {
    Py_XDECREF(capi_expn1_starts_tmp); }
  }  /*if (capi_expn1_starts_tmp == NULL) ... else of expn1_starts*/
  /* End of cleaning variable expn1_starts */
  if((PyObject *)capi_center1_starts_tmp!=center1_starts_capi) {
    Py_XDECREF(capi_center1_starts_tmp); }
  }  /*if (capi_center1_starts_tmp == NULL) ... else of center1_starts*/
  /* End of cleaning variable center1_starts */
  } /*CHECKSCALAR((len(rscale1_starts)-1)>=nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  if((PyObject *)capi_expn1_offsets_tmp!=expn1_offsets_capi) {
    Py_XDECREF(capi_expn1_offsets_tmp); }
  }  /*if (capi_expn1_offsets_tmp == NULL) ... else of expn1_offsets*/
  /* End of cleaning variable expn1_offsets */
  if((PyObject *)capi_expn1_tmp!=expn1_capi) {
    Py_XDECREF(capi_expn1_tmp); }
  }  /*if (capi_expn1_tmp == NULL) ... else of expn1*/
  /* End of cleaning variable expn1 */
  if((PyObject *)capi_center1_offsets_tmp!=center1_offsets_capi) {
    Py_XDECREF(capi_center1_offsets_tmp); }
  }  /*if (capi_center1_offsets_tmp == NULL) ... else of center1_offsets*/
  /* End of cleaning variable center1_offsets */
  if((PyObject *)capi_center1_tmp!=center1_capi) {
    Py_XDECREF(capi_center1_tmp); }
  }  /*if (capi_center1_tmp == NULL) ... else of center1*/
  /* End of cleaning variable center1 */
  if((PyObject *)capi_rscale1_starts_tmp!=rscale1_starts_capi) {
    Py_XDECREF(capi_rscale1_starts_tmp); }
  }  /*if (capi_rscale1_starts_tmp == NULL) ... else of rscale1_starts*/
  /* End of cleaning variable rscale1_starts */
  if((PyObject *)capi_rscale1_offsets_tmp!=rscale1_offsets_capi) {
    Py_XDECREF(capi_rscale1_offsets_tmp); }
  }  /*if (capi_rscale1_offsets_tmp == NULL) ... else of rscale1_offsets*/
  /* End of cleaning variable rscale1_offsets */
  if((PyObject *)capi_rscale1_tmp!=rscale1_capi) {
    Py_XDECREF(capi_rscale1_tmp); }
  }  /*if (capi_rscale1_tmp == NULL) ... else of rscale1*/
  /* End of cleaning variable rscale1 */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/*************************** end of l2dmploc_imany ***************************/

/****************************** l2dlocloc_imany ******************************/
static char doc_f2py_rout__internal_l2dlocloc_imany[] = "\
expn2 = l2dlocloc_imany(rscale1,rscale1_offsets,rscale1_starts,center1,center1_offsets,center1_starts,expn1,expn1_offsets,expn1_starts,rscale2,center2,expn2,[nterms1,nterms2,nvcount])\n\nWrapper for ``l2dlocloc_imany``.\
\n\nParameters\n----------\n"
"rscale1 : input rank-1 array('d') with bounds (*)\n"
"rscale1_offsets : input rank-1 array('i') with bounds (*)\n"
"rscale1_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"center1 : input rank-2 array('d') with bounds (2,*)\n"
"center1_offsets : input rank-1 array('i') with bounds (*)\n"
"center1_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"expn1 : input rank-2 array('D') with bounds (nterms1 + 1,*)\n"
"expn1_offsets : input rank-1 array('i') with bounds (*)\n"
"expn1_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"rscale2 : input rank-1 array('d') with bounds (nvcount)\n"
"center2 : input rank-2 array('d') with bounds (2,nvcount)\n"
"expn2 : input rank-2 array('D') with bounds (nterms2 + 1,nvcount)\n"
"\nOther Parameters\n----------------\n"
"nterms1 : input int, optional\n    Default: (shape(expn1,0)-1)\n"
"nterms2 : input int, optional\n    Default: (shape(expn2,0)-1)\n"
"nvcount : input int, optional\n    Default: (len(rscale1_starts)-1)\n"
"\nReturns\n-------\n"
"expn2 : rank-2 array('D') with bounds (nterms2 + 1,nvcount)";
/* extern void F_FUNC_US(l2dlocloc_imany,L2DLOCLOC_IMANY)(double*,int*,int*,double*,int*,int*,complex_double*,int*,int*,int*,double*,double*,complex_double*,int*,int*); */
static PyObject *f2py_rout__internal_l2dlocloc_imany(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,int*,double*,int*,int*,complex_double*,int*,int*,int*,double*,double*,complex_double*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double *rscale1 = NULL;
  npy_intp rscale1_Dims[1] = {-1};
  const int rscale1_Rank = 1;
  PyArrayObject *capi_rscale1_tmp = NULL;
  int capi_rscale1_intent = 0;
  PyObject *rscale1_capi = Py_None;
  int *rscale1_offsets = NULL;
  npy_intp rscale1_offsets_Dims[1] = {-1};
  const int rscale1_offsets_Rank = 1;
  PyArrayObject *capi_rscale1_offsets_tmp = NULL;
  int capi_rscale1_offsets_intent = 0;
  PyObject *rscale1_offsets_capi = Py_None;
  int *rscale1_starts = NULL;
  npy_intp rscale1_starts_Dims[1] = {-1};
  const int rscale1_starts_Rank = 1;
  PyArrayObject *capi_rscale1_starts_tmp = NULL;
  int capi_rscale1_starts_intent = 0;
  PyObject *rscale1_starts_capi = Py_None;
  double *center1 = NULL;
  npy_intp center1_Dims[2] = {-1, -1};
  const int center1_Rank = 2;
  PyArrayObject *capi_center1_tmp = NULL;
  int capi_center1_intent = 0;
  PyObject *center1_capi = Py_None;
  int *center1_offsets = NULL;
  npy_intp center1_offsets_Dims[1] = {-1};
  const int center1_offsets_Rank = 1;
  PyArrayObject *capi_center1_offsets_tmp = NULL;
  int capi_center1_offsets_intent = 0;
  PyObject *center1_offsets_capi = Py_None;
  int *center1_starts = NULL;
  npy_intp center1_starts_Dims[1] = {-1};
  const int center1_starts_Rank = 1;
  PyArrayObject *capi_center1_starts_tmp = NULL;
  int capi_center1_starts_intent = 0;
  PyObject *center1_starts_capi = Py_None;
  complex_double *expn1 = NULL;
  npy_intp expn1_Dims[2] = {-1, -1};
  const int expn1_Rank = 2;
  PyArrayObject *capi_expn1_tmp = NULL;
  int capi_expn1_intent = 0;
  PyObject *expn1_capi = Py_None;
  int *expn1_offsets = NULL;
  npy_intp expn1_offsets_Dims[1] = {-1};
  const int expn1_offsets_Rank = 1;
  PyArrayObject *capi_expn1_offsets_tmp = NULL;
  int capi_expn1_offsets_intent = 0;
  PyObject *expn1_offsets_capi = Py_None;
  int *expn1_starts = NULL;
  npy_intp expn1_starts_Dims[1] = {-1};
  const int expn1_starts_Rank = 1;
  PyArrayObject *capi_expn1_starts_tmp = NULL;
  int capi_expn1_starts_intent = 0;
  PyObject *expn1_starts_capi = Py_None;
  int nterms1 = 0;
  PyObject *nterms1_capi = Py_None;
  double *rscale2 = NULL;
  npy_intp rscale2_Dims[1] = {-1};
  const int rscale2_Rank = 1;
  PyArrayObject *capi_rscale2_tmp = NULL;
  int capi_rscale2_intent = 0;
  PyObject *rscale2_capi = Py_None;
  double *center2 = NULL;
  npy_intp center2_Dims[2] = {-1, -1};
  const int center2_Rank = 2;
  PyArrayObject *capi_center2_tmp = NULL;
  int capi_center2_intent = 0;
  PyObject *center2_capi = Py_None;
  complex_double *expn2 = NULL;
  npy_intp expn2_Dims[2] = {-1, -1};
  const int expn2_Rank = 2;
  PyArrayObject *capi_expn2_tmp = NULL;
  int capi_expn2_intent = 0;
  PyObject *expn2_capi = Py_None;
  int nterms2 = 0;
  PyObject *nterms2_capi = Py_None;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"rscale1","rscale1_offsets","rscale1_starts","center1","center1_offsets","center1_starts","expn1","expn1_offsets","expn1_starts","rscale2","center2","expn2","nterms1","nterms2","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOOOO|OOO:_internal.l2dlocloc_imany",\
        capi_kwlist,&rscale1_capi,&rscale1_offsets_capi,&rscale1_starts_capi,&center1_capi,&center1_offsets_capi,&center1_starts_capi,&expn1_capi,&expn1_offsets_capi,&expn1_starts_capi,&rscale2_capi,&center2_capi,&expn2_capi,&nterms1_capi,&nterms2_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable rscale1 */
  ;
  capi_rscale1_intent |= F2PY_INTENT_IN;
  capi_rscale1_tmp = array_from_pyobj(NPY_DOUBLE,rscale1_Dims,rscale1_Rank,capi_rscale1_intent,rscale1_capi);
  if (capi_rscale1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 1st argument `rscale1' of _internal.l2dlocloc_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale1 = (double *)(PyArray_DATA(capi_rscale1_tmp));

  /* Processing variable rscale1_offsets */
  ;
  capi_rscale1_offsets_intent |= F2PY_INTENT_IN;
  capi_rscale1_offsets_tmp = array_from_pyobj(NPY_INT,rscale1_offsets_Dims,rscale1_offsets_Rank,capi_rscale1_offsets_intent,rscale1_offsets_capi);
  if (capi_rscale1_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `rscale1_offsets' of _internal.l2dlocloc_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale1_offsets = (int *)(PyArray_DATA(capi_rscale1_offsets_tmp));

  /* Processing variable rscale1_starts */
  ;
  capi_rscale1_starts_intent |= F2PY_INTENT_IN;
  capi_rscale1_starts_tmp = array_from_pyobj(NPY_INT,rscale1_starts_Dims,rscale1_starts_Rank,capi_rscale1_starts_intent,rscale1_starts_capi);
  if (capi_rscale1_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `rscale1_starts' of _internal.l2dlocloc_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale1_starts = (int *)(PyArray_DATA(capi_rscale1_starts_tmp));

  /* Processing variable center1 */
  center1_Dims[0]=2;
  capi_center1_intent |= F2PY_INTENT_IN;
  capi_center1_tmp = array_from_pyobj(NPY_DOUBLE,center1_Dims,center1_Rank,capi_center1_intent,center1_capi);
  if (capi_center1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `center1' of _internal.l2dlocloc_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center1 = (double *)(PyArray_DATA(capi_center1_tmp));

  /* Processing variable center1_offsets */
  ;
  capi_center1_offsets_intent |= F2PY_INTENT_IN;
  capi_center1_offsets_tmp = array_from_pyobj(NPY_INT,center1_offsets_Dims,center1_offsets_Rank,capi_center1_offsets_intent,center1_offsets_capi);
  if (capi_center1_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `center1_offsets' of _internal.l2dlocloc_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center1_offsets = (int *)(PyArray_DATA(capi_center1_offsets_tmp));

  /* Processing variable expn1 */
  ;
  capi_expn1_intent |= F2PY_INTENT_IN;
  capi_expn1_tmp = array_from_pyobj(NPY_CDOUBLE,expn1_Dims,expn1_Rank,capi_expn1_intent,expn1_capi);
  if (capi_expn1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 7th argument `expn1' of _internal.l2dlocloc_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn1 = (complex_double *)(PyArray_DATA(capi_expn1_tmp));

  /* Processing variable expn1_offsets */
  ;
  capi_expn1_offsets_intent |= F2PY_INTENT_IN;
  capi_expn1_offsets_tmp = array_from_pyobj(NPY_INT,expn1_offsets_Dims,expn1_offsets_Rank,capi_expn1_offsets_intent,expn1_offsets_capi);
  if (capi_expn1_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 8th argument `expn1_offsets' of _internal.l2dlocloc_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn1_offsets = (int *)(PyArray_DATA(capi_expn1_offsets_tmp));

  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = (len(rscale1_starts)-1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.l2dlocloc_imany() 3rd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((len(rscale1_starts)-1)>=nvcount,"(len(rscale1_starts)-1)>=nvcount","3rd keyword nvcount","l2dlocloc_imany:nvcount=%d",nvcount) {
  /* Processing variable center1_starts */
  center1_starts_Dims[0]=nvcount + 1;
  capi_center1_starts_intent |= F2PY_INTENT_IN;
  capi_center1_starts_tmp = array_from_pyobj(NPY_INT,center1_starts_Dims,center1_starts_Rank,capi_center1_starts_intent,center1_starts_capi);
  if (capi_center1_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `center1_starts' of _internal.l2dlocloc_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center1_starts = (int *)(PyArray_DATA(capi_center1_starts_tmp));

  /* Processing variable expn1_starts */
  expn1_starts_Dims[0]=nvcount + 1;
  capi_expn1_starts_intent |= F2PY_INTENT_IN;
  capi_expn1_starts_tmp = array_from_pyobj(NPY_INT,expn1_starts_Dims,expn1_starts_Rank,capi_expn1_starts_intent,expn1_starts_capi);
  if (capi_expn1_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 9th argument `expn1_starts' of _internal.l2dlocloc_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn1_starts = (int *)(PyArray_DATA(capi_expn1_starts_tmp));

  /* Processing variable nterms1 */
  if (nterms1_capi == Py_None) nterms1 = (shape(expn1,0)-1); else
    f2py_success = int_from_pyobj(&nterms1,nterms1_capi,"_internal.l2dlocloc_imany() 1st keyword (nterms1) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((shape(expn1,0)-1)==nterms1,"(shape(expn1,0)-1)==nterms1","1st keyword nterms1","l2dlocloc_imany:nterms1=%d",nterms1) {
  /* Processing variable rscale2 */
  rscale2_Dims[0]=nvcount;
  capi_rscale2_intent |= F2PY_INTENT_IN;
  capi_rscale2_tmp = array_from_pyobj(NPY_DOUBLE,rscale2_Dims,rscale2_Rank,capi_rscale2_intent,rscale2_capi);
  if (capi_rscale2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 10th argument `rscale2' of _internal.l2dlocloc_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale2 = (double *)(PyArray_DATA(capi_rscale2_tmp));

  /* Processing variable center2 */
  center2_Dims[0]=2,center2_Dims[1]=nvcount;
  capi_center2_intent |= F2PY_INTENT_IN;
  capi_center2_tmp = array_from_pyobj(NPY_DOUBLE,center2_Dims,center2_Rank,capi_center2_intent,center2_capi);
  if (capi_center2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 11st argument `center2' of _internal.l2dlocloc_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center2 = (double *)(PyArray_DATA(capi_center2_tmp));

  /* Processing variable expn2 */
  expn2_Dims[1]=nvcount;
  capi_expn2_intent |= F2PY_INTENT_IN|F2PY_INTENT_OUT;
  capi_expn2_tmp = array_from_pyobj(NPY_CDOUBLE,expn2_Dims,expn2_Rank,capi_expn2_intent,expn2_capi);
  if (capi_expn2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 12nd argument `expn2' of _internal.l2dlocloc_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn2 = (complex_double *)(PyArray_DATA(capi_expn2_tmp));

  /* Processing variable nterms2 */
  if (nterms2_capi == Py_None) nterms2 = (shape(expn2,0)-1); else
    f2py_success = int_from_pyobj(&nterms2,nterms2_capi,"_internal.l2dlocloc_imany() 2nd keyword (nterms2) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((shape(expn2,0)-1)==nterms2,"(shape(expn2,0)-1)==nterms2","2nd keyword nterms2","l2dlocloc_imany:nterms2=%d",nterms2) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(rscale1,rscale1_offsets,rscale1_starts,center1,center1_offsets,center1_starts,expn1,expn1_offsets,expn1_starts,&nterms1,rscale2,center2,expn2,&nterms2,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("N",capi_expn2_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*CHECKSCALAR((shape(expn2,0)-1)==nterms2)*/
  } /*if (f2py_success) of nterms2*/
  /* End of cleaning variable nterms2 */
  }  /*if (capi_expn2_tmp == NULL) ... else of expn2*/
  /* End of cleaning variable expn2 */
  if((PyObject *)capi_center2_tmp!=center2_capi) {
    Py_XDECREF(capi_center2_tmp); }
  }  /*if (capi_center2_tmp == NULL) ... else of center2*/
  /* End of cleaning variable center2 */
  if((PyObject *)capi_rscale2_tmp!=rscale2_capi) {
    Py_XDECREF(capi_rscale2_tmp); }
  }  /*if (capi_rscale2_tmp == NULL) ... else of rscale2*/
  /* End of cleaning variable rscale2 */
  } /*CHECKSCALAR((shape(expn1,0)-1)==nterms1)*/
  } /*if (f2py_success) of nterms1*/
  /* End of cleaning variable nterms1 */
  if((PyObject *)capi_expn1_starts_tmp!=expn1_starts_capi) {
    Py_XDECREF(capi_expn1_starts_tmp); }
  }  /*if (capi_expn1_starts_tmp == NULL) ... else of expn1_starts*/
  /* End of cleaning variable expn1_starts */
  if((PyObject *)capi_center1_starts_tmp!=center1_starts_capi) {
    Py_XDECREF(capi_center1_starts_tmp); }
  }  /*if (capi_center1_starts_tmp == NULL) ... else of center1_starts*/
  /* End of cleaning variable center1_starts */
  } /*CHECKSCALAR((len(rscale1_starts)-1)>=nvcount)*/
  } /*if (f2py_success) of nvcount*/
  /* End of cleaning variable nvcount */
  if((PyObject *)capi_expn1_offsets_tmp!=expn1_offsets_capi) {
    Py_XDECREF(capi_expn1_offsets_tmp); }
  }  /*if (capi_expn1_offsets_tmp == NULL) ... else of expn1_offsets*/
  /* End of cleaning variable expn1_offsets */
  if((PyObject *)capi_expn1_tmp!=expn1_capi) {
    Py_XDECREF(capi_expn1_tmp); }
  }  /*if (capi_expn1_tmp == NULL) ... else of expn1*/
  /* End of cleaning variable expn1 */
  if((PyObject *)capi_center1_offsets_tmp!=center1_offsets_capi) {
    Py_XDECREF(capi_center1_offsets_tmp); }
  }  /*if (capi_center1_offsets_tmp == NULL) ... else of center1_offsets*/
  /* End of cleaning variable center1_offsets */
  if((PyObject *)capi_center1_tmp!=center1_capi) {
    Py_XDECREF(capi_center1_tmp); }
  }  /*if (capi_center1_tmp == NULL) ... else of center1*/
  /* End of cleaning variable center1 */
  if((PyObject *)capi_rscale1_starts_tmp!=rscale1_starts_capi) {
    Py_XDECREF(capi_rscale1_starts_tmp); }
  }  /*if (capi_rscale1_starts_tmp == NULL) ... else of rscale1_starts*/
  /* End of cleaning variable rscale1_starts */
  if((PyObject *)capi_rscale1_offsets_tmp!=rscale1_offsets_capi) {
    Py_XDECREF(capi_rscale1_offsets_tmp); }
  }  /*if (capi_rscale1_offsets_tmp == NULL) ... else of rscale1_offsets*/
  /* End of cleaning variable rscale1_offsets */
  if((PyObject *)capi_rscale1_tmp!=rscale1_capi) {
    Py_XDECREF(capi_rscale1_tmp); }
  }  /*if (capi_rscale1_tmp == NULL) ... else of rscale1*/
  /* End of cleaning variable rscale1 */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/*************************** end of l2dlocloc_imany ***************************/

/******************************* h2dmpmp_imany *******************************/
static char doc_f2py_rout__internal_h2dmpmp_imany[] = "\
expn2 = h2dmpmp_imany(zk,rscale1,rscale1_offsets,rscale1_starts,center1,center1_offsets,center1_starts,expn1,expn1_offsets,expn1_starts,rscale2,center2,expn2,[nterms1,nterms2,nvcount])\n\nWrapper for ``h2dmpmp_imany``.\
\n\nParameters\n----------\n"
"zk : input complex\n"
"rscale1 : input rank-1 array('d') with bounds (*)\n"
"rscale1_offsets : input rank-1 array('i') with bounds (*)\n"
"rscale1_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"center1 : input rank-2 array('d') with bounds (2,*)\n"
"center1_offsets : input rank-1 array('i') with bounds (*)\n"
"center1_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"expn1 : input rank-2 array('D') with bounds (2 * nterms1 + 1,*)\n"
"expn1_offsets : input rank-1 array('i') with bounds (*)\n"
"expn1_starts : input rank-1 array('i') with bounds (nvcount + 1)\n"
"rscale2 : input rank-1 array('d') with bounds (nvcount)\n"
"center2 : input rank-2 array('d') with bounds (2,nvcount)\n"
"expn2 : input rank-2 array('D') with bounds (2 * nterms2 + 1,nvcount)\n"
"\nOther Parameters\n----------------\n"
"nterms1 : input int, optional\n    Default: (shape(expn1,0)-1)/(2)\n"
"nterms2 : input int, optional\n    Default: (shape(expn2,0)-1)/(2)\n"
"nvcount : input int, optional\n    Default: (len(rscale1_starts)-1)\n"
"\nReturns\n-------\n"
"expn2 : rank-2 array('D') with bounds (2 * nterms2 + 1,nvcount)";
/* extern void F_FUNC_US(h2dmpmp_imany,H2DMPMP_IMANY)(complex_double*,double*,int*,int*,double*,int*,int*,complex_double*,int*,int*,int*,double*,double*,complex_double*,int*,int*); */
static PyObject *f2py_rout__internal_h2dmpmp_imany(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(complex_double*,double*,int*,int*,double*,int*,int*,complex_double*,int*,int*,int*,double*,double*,complex_double*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  complex_double zk;
  PyObject *zk_capi = Py_None;
  double *rscale1 = NULL;
  npy_intp rscale1_Dims[1] = {-1};
  const int rscale1_Rank = 1;
  PyArrayObject *capi_rscale1_tmp = NULL;
  int capi_rscale1_intent = 0;
  PyObject *rscale1_capi = Py_None;
  int *rscale1_offsets = NULL;
  npy_intp rscale1_offsets_Dims[1] = {-1};
  const int rscale1_offsets_Rank = 1;
  PyArrayObject *capi_rscale1_offsets_tmp = NULL;
  int capi_rscale1_offsets_intent = 0;
  PyObject *rscale1_offsets_capi = Py_None;
  int *rscale1_starts = NULL;
  npy_intp rscale1_starts_Dims[1] = {-1};
  const int rscale1_starts_Rank = 1;
  PyArrayObject *capi_rscale1_starts_tmp = NULL;
  int capi_rscale1_starts_intent = 0;
  PyObject *rscale1_starts_capi = Py_None;
  double *center1 = NULL;
  npy_intp center1_Dims[2] = {-1, -1};
  const int center1_Rank = 2;
  PyArrayObject *capi_center1_tmp = NULL;
  int capi_center1_intent = 0;
  PyObject *center1_capi = Py_None;
  int *center1_offsets = NULL;
  npy_intp center1_offsets_Dims[1] = {-1};
  const int center1_offsets_Rank = 1;
  PyArrayObject *capi_center1_offsets_tmp = NULL;
  int capi_center1_offsets_intent = 0;
  PyObject *center1_offsets_capi = Py_None;
  int *center1_starts = NULL;
  npy_intp center1_starts_Dims[1] = {-1};
  const int center1_starts_Rank = 1;
  PyArrayObject *capi_center1_starts_tmp = NULL;
  int capi_center1_starts_intent = 0;
  PyObject *center1_starts_capi = Py_None;
  complex_double *expn1 = NULL;
  npy_intp expn1_Dims[2] = {-1, -1};
  const int expn1_Rank = 2;
  PyArrayObject *capi_expn1_tmp = NULL;
  int capi_expn1_intent = 0;
  PyObject *expn1_capi = Py_None;
  int *expn1_offsets = NULL;
  npy_intp expn1_offsets_Dims[1] = {-1};
  const int expn1_offsets_Rank = 1;
  PyArrayObject *capi_expn1_offsets_tmp = NULL;
  int capi_expn1_offsets_intent = 0;
  PyObject *expn1_offsets_capi = Py_None;
  int *expn1_starts = NULL;
  npy_intp expn1_starts_Dims[1] = {-1};
  const int expn1_starts_Rank = 1;
  PyArrayObject *capi_expn1_starts_tmp = NULL;
  int capi_expn1_starts_intent = 0;
  PyObject *expn1_starts_capi = Py_None;
  int nterms1 = 0;
  PyObject *nterms1_capi = Py_None;
  double *rscale2 = NULL;
  npy_intp rscale2_Dims[1] = {-1};
  const int rscale2_Rank = 1;
  PyArrayObject *capi_rscale2_tmp = NULL;
  int capi_rscale2_intent = 0;
  PyObject *rscale2_capi = Py_None;
  double *center2 = NULL;
  npy_intp center2_Dims[2] = {-1, -1};
  const int center2_Rank = 2;
  PyArrayObject *capi_center2_tmp = NULL;
  int capi_center2_intent = 0;
  PyObject *center2_capi = Py_None;
  complex_double *expn2 = NULL;
  npy_intp expn2_Dims[2] = {-1, -1};
  const int expn2_Rank = 2;
  PyArrayObject *capi_expn2_tmp = NULL;
  int capi_expn2_intent = 0;
  PyObject *expn2_capi = Py_None;
  int nterms2 = 0;
  PyObject *nterms2_capi = Py_None;
  int nvcount = 0;
  PyObject *nvcount_capi = Py_None;
    static char *capi_kwlist[] = {"zk","rscale1","rscale1_offsets","rscale1_starts","center1","center1_offsets","center1_starts","expn1","expn1_offsets","expn1_starts","rscale2","center2","expn2","nterms1","nterms2","nvcount",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOOOOO|OOO:_internal.h2dmpmp_imany",\
        capi_kwlist,&zk_capi,&rscale1_capi,&rscale1_offsets_capi,&rscale1_starts_capi,&center1_capi,&center1_offsets_capi,&center1_starts_capi,&expn1_capi,&expn1_offsets_capi,&expn1_starts_capi,&rscale2_capi,&center2_capi,&expn2_capi,&nterms1_capi,&nterms2_capi,&nvcount_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable zk */
    f2py_success = complex_double_from_pyobj(&zk,zk_capi,"_internal.h2dmpmp_imany() 1st argument (zk) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable rscale1 */
  ;
  capi_rscale1_intent |= F2PY_INTENT_IN;
  capi_rscale1_tmp = array_from_pyobj(NPY_DOUBLE,rscale1_Dims,rscale1_Rank,capi_rscale1_intent,rscale1_capi);
  if (capi_rscale1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 2nd argument `rscale1' of _internal.h2dmpmp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale1 = (double *)(PyArray_DATA(capi_rscale1_tmp));

  /* Processing variable rscale1_offsets */
  ;
  capi_rscale1_offsets_intent |= F2PY_INTENT_IN;
  capi_rscale1_offsets_tmp = array_from_pyobj(NPY_INT,rscale1_offsets_Dims,rscale1_offsets_Rank,capi_rscale1_offsets_intent,rscale1_offsets_capi);
  if (capi_rscale1_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 3rd argument `rscale1_offsets' of _internal.h2dmpmp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale1_offsets = (int *)(PyArray_DATA(capi_rscale1_offsets_tmp));

  /* Processing variable rscale1_starts */
  ;
  capi_rscale1_starts_intent |= F2PY_INTENT_IN;
  capi_rscale1_starts_tmp = array_from_pyobj(NPY_INT,rscale1_starts_Dims,rscale1_starts_Rank,capi_rscale1_starts_intent,rscale1_starts_capi);
  if (capi_rscale1_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 4th argument `rscale1_starts' of _internal.h2dmpmp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale1_starts = (int *)(PyArray_DATA(capi_rscale1_starts_tmp));

  /* Processing variable center1 */
  center1_Dims[0]=2;
  capi_center1_intent |= F2PY_INTENT_IN;
  capi_center1_tmp = array_from_pyobj(NPY_DOUBLE,center1_Dims,center1_Rank,capi_center1_intent,center1_capi);
  if (capi_center1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 5th argument `center1' of _internal.h2dmpmp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center1 = (double *)(PyArray_DATA(capi_center1_tmp));

  /* Processing variable center1_offsets */
  ;
  capi_center1_offsets_intent |= F2PY_INTENT_IN;
  capi_center1_offsets_tmp = array_from_pyobj(NPY_INT,center1_offsets_Dims,center1_offsets_Rank,capi_center1_offsets_intent,center1_offsets_capi);
  if (capi_center1_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 6th argument `center1_offsets' of _internal.h2dmpmp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center1_offsets = (int *)(PyArray_DATA(capi_center1_offsets_tmp));

  /* Processing variable expn1 */
  ;
  capi_expn1_intent |= F2PY_INTENT_IN;
  capi_expn1_tmp = array_from_pyobj(NPY_CDOUBLE,expn1_Dims,expn1_Rank,capi_expn1_intent,expn1_capi);
  if (capi_expn1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 8th argument `expn1' of _internal.h2dmpmp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn1 = (complex_double *)(PyArray_DATA(capi_expn1_tmp));

  /* Processing variable expn1_offsets */
  ;
  capi_expn1_offsets_intent |= F2PY_INTENT_IN;
  capi_expn1_offsets_tmp = array_from_pyobj(NPY_INT,expn1_offsets_Dims,expn1_offsets_Rank,capi_expn1_offsets_intent,expn1_offsets_capi);
  if (capi_expn1_offsets_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 9th argument `expn1_offsets' of _internal.h2dmpmp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn1_offsets = (int *)(PyArray_DATA(capi_expn1_offsets_tmp));

  /* Processing variable nvcount */
  if (nvcount_capi == Py_None) nvcount = (len(rscale1_starts)-1); else
    f2py_success = int_from_pyobj(&nvcount,nvcount_capi,"_internal.h2dmpmp_imany() 3rd keyword (nvcount) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((len(rscale1_starts)-1)>=nvcount,"(len(rscale1_starts)-1)>=nvcount","3rd keyword nvcount","h2dmpmp_imany:nvcount=%d",nvcount) {
  /* Processing variable center1_starts */
  center1_starts_Dims[0]=nvcount + 1;
  capi_center1_starts_intent |= F2PY_INTENT_IN;
  capi_center1_starts_tmp = array_from_pyobj(NPY_INT,center1_starts_Dims,center1_starts_Rank,capi_center1_starts_intent,center1_starts_capi);
  if (capi_center1_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 7th argument `center1_starts' of _internal.h2dmpmp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center1_starts = (int *)(PyArray_DATA(capi_center1_starts_tmp));

  /* Processing variable expn1_starts */
  expn1_starts_Dims[0]=nvcount + 1;
  capi_expn1_starts_intent |= F2PY_INTENT_IN;
  capi_expn1_starts_tmp = array_from_pyobj(NPY_INT,expn1_starts_Dims,expn1_starts_Rank,capi_expn1_starts_intent,expn1_starts_capi);
  if (capi_expn1_starts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 10th argument `expn1_starts' of _internal.h2dmpmp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn1_starts = (int *)(PyArray_DATA(capi_expn1_starts_tmp));

  /* Processing variable nterms1 */
  if (nterms1_capi == Py_None) nterms1 = (shape(expn1,0)-1)/(2); else
    f2py_success = int_from_pyobj(&nterms1,nterms1_capi,"_internal.h2dmpmp_imany() 1st keyword (nterms1) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((shape(expn1,0)-1)/(2)==nterms1,"(shape(expn1,0)-1)/(2)==nterms1","1st keyword nterms1","h2dmpmp_imany:nterms1=%d",nterms1) {
  /* Processing variable rscale2 */
  rscale2_Dims[0]=nvcount;
  capi_rscale2_intent |= F2PY_INTENT_IN;
  capi_rscale2_tmp = array_from_pyobj(NPY_DOUBLE,rscale2_Dims,rscale2_Rank,capi_rscale2_intent,rscale2_capi);
  if (capi_rscale2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 11st argument `rscale2' of _internal.h2dmpmp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rscale2 = (double *)(PyArray_DATA(capi_rscale2_tmp));

  /* Processing variable center2 */
  center2_Dims[0]=2,center2_Dims[1]=nvcount;
  capi_center2_intent |= F2PY_INTENT_IN;
  capi_center2_tmp = array_from_pyobj(NPY_DOUBLE,center2_Dims,center2_Rank,capi_center2_intent,center2_capi);
  if (capi_center2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 12nd argument `center2' of _internal.h2dmpmp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    center2 = (double *)(PyArray_DATA(capi_center2_tmp));

  /* Processing variable expn2 */
  expn2_Dims[1]=nvcount;
  capi_expn2_intent |= F2PY_INTENT_IN|F2PY_INTENT_OUT;
  capi_expn2_tmp = array_from_pyobj(NPY_CDOUBLE,expn2_Dims,expn2_Rank,capi_expn2_intent,expn2_capi);
  if (capi_expn2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _internal_error,"failed in converting 13rd argument `expn2' of _internal.h2dmpmp_imany to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    expn2 = (complex_double *)(PyArray_DATA(capi_expn2_tmp));

  /* Processing variable nterms2 */
  if (nterms2_capi == Py_None) nterms2 = (shape(expn2,0)-1)/(2); else
    f2py_success = int_from_pyobj(&nterms2,nterms2_capi,"_internal.h2dmpmp_imany() 2nd keyword (nterms2) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((shape(expn2,0)-1)/(2)==nterms2,"(shape(expn2,0)-1)/(2)==nterms2","2nd keyword nterms2","h2dmpmp_imany:nterms2=%d",nterms2) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&zk,rscale1,rscale1_offsets,rscale1_starts,center1,center1_offsets,center1_starts,expn1,expn1_offsets,expn1_starts,&nterms1,rscale2,center2,expn2,&nterms2,&nvcount);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("N",capi_expn2_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*CHECKSCALAR((shape(expn2,0)-1)/(2)==nterms2)*/
  } /*if (f2py_success) of nterms2*/
  /* End of cleaning variable nterms2 */
  }  /*if (capi_expn2_tmp == NULL) ... else of expn2*/
  /* End of cleaning variable expn2 */
  if((PyObject *)capi_center2_tmp!=center2_capi) {
    Py_XDECREF(capi_center2_tmp); }
  }  /*if (capi_center2_tmp == NULL) ... else of center2*/
  /* End of cleaning variable center2 */
  if((PyObject *)capi_rscale2_tmp!=rscale2_capi) {
    Py_XDECREF(capi_rscale2_tmp); }
  }  /*if (capi_rscale2_tmp == NULL) ... else of rscale2*/
  /* End of cleaning variable rscale2 */
  } /*CHECKSCA