"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const aws_cdk_lib_1 = require("aws-cdk-lib");
const kinesis = require("aws-cdk-lib/aws-kinesis");
const lib_1 = require("../lib");
const core_1 = require("@aws-solutions-constructs/core");
const aws_kinesis_1 = require("aws-cdk-lib/aws-kinesis");
// Setup
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, core_1.generateIntegStackName(__filename));
stack.templateOptions.description = 'Integration Test for aws-iot-kinesisstreams';
// Definitions
const existingKinesisStream = new kinesis.Stream(stack, `existing-stream`, {
    shardCount: 2,
    retentionPeriod: aws_cdk_lib_1.Duration.hours(25),
    encryption: aws_kinesis_1.StreamEncryption.MANAGED
});
const props = {
    iotTopicRuleProps: {
        topicRulePayload: {
            description: "sends data to kinesis streams",
            sql: "SELECT * FROM 'solutions/constructs'",
            actions: []
        },
    },
    existingStreamObj: existingKinesisStream
};
new lib_1.IotToKinesisStreams(stack, 'test-iot-kinesisstreams', props);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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