"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IotToKinesisStreams = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iot = require("aws-cdk-lib/aws-iot");
const iam = require("aws-cdk-lib/aws-iam");
const constructs_1 = require("constructs");
const defaults = require("@aws-solutions-constructs/core");
class IotToKinesisStreams extends constructs_1.Construct {
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the IotToKinesisFirehoseToS3 class.
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        // Set up the Kinesis Stream
        this.kinesisStream = defaults.buildKinesisStream(this, {
            existingStreamObj: props.existingStreamObj,
            kinesisStreamProps: props.kinesisStreamProps,
        });
        // Setup the IAM Role for IoT Actions
        this.iotActionsRole = new iam.Role(this, 'IotActionsRole', {
            assumedBy: new iam.ServicePrincipal('iot.amazonaws.com'),
        });
        // Setup the IAM policy for IoT Actions
        const iotActionsPolicy = new iam.Policy(this, 'IotActionsPolicy', {
            statements: [new iam.PolicyStatement({
                    actions: [
                        'kinesis:PutRecord'
                    ],
                    resources: [this.kinesisStream.streamArn]
                })
            ]
        });
        // Attach policy to role
        iotActionsPolicy.attachToRole(this.iotActionsRole);
        // Create IoT Rule Props
        const defaultIotTopicProps = defaults.DefaultCfnTopicRuleProps([{
                kinesis: {
                    streamName: this.kinesisStream.streamName,
                    roleArn: this.iotActionsRole.roleArn
                }
            }]);
        const iotTopicProps = defaults.overrideProps(defaultIotTopicProps, props.iotTopicRuleProps, true);
        // Create the IoT topic rule
        this.iotTopicRule = new iot.CfnTopicRule(this, 'IotTopic', iotTopicProps);
        if (props.createCloudWatchAlarms === undefined || props.createCloudWatchAlarms) {
            // Deploy best practices CW Alarms for Kinesis Stream
            this.cloudwatchAlarms = defaults.buildKinesisStreamCWAlarms(this);
        }
    }
}
exports.IotToKinesisStreams = IotToKinesisStreams;
_a = JSII_RTTI_SYMBOL_1;
IotToKinesisStreams[_a] = { fqn: "@aws-solutions-constructs/aws-iot-kinesisstreams.IotToKinesisStreams", version: "2.0.0-rc.1" };
//# sourceMappingURL=data:application/json;base64,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