# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['flayyer']

package_data = \
{'': ['*']}

install_requires = \
['PyJWT>=2.0.1,<3.0.0', 'typing-extensions>=3.7.4,<4.0.0']

setup_kwargs = {
    'name': 'flayyer',
    'version': '1.2.0',
    'description': 'FLAYYER.com helper classes and methods',
    'long_description': '# flayyer-python\n\n![PyPI - Version](https://img.shields.io/pypi/v/flayyer) ![PyPI - Downloads](https://img.shields.io/pypi/dm/flayyer)\n\nThe AI-powered preview system built from your website (no effort required).\n\n![Flayyer live image](https://github.com/flayyer/create-flayyer-app/blob/master/.github/assets/website-to-preview.png?raw=true&v=1)\n\n**This module is agnostic to any Python framework.**\n\n## Index\n\n- [Get started (5 minutes)](#get-started-5-minutes)\n- [Advanced usage](#advanced-usage)\n- [Flayyer.io](#flayyerio)\n- [Development](#development)\n- [Test](#test)\n\n## Get started (5 minutes)\n\nHaven\'t registered your website yet? Go to [Flayyer.com](https://flayyer.com?ref=flayyer-python) and create a project (e.g. `website-com`).\n\n### 1. Install the library\n\nThis module requires Python >= 3.6.\n\nInstall it with [Poetry](https://python-poetry.org/).\n\n```sh\npoetry add flayyer\n```\n\nOr install it with [pip](https://pip.pypa.io/en/stable/).\n\n```sh\npip install flayyer\n```\n\n### 2. Get your Flayyer.ai smart image link\n\nIn your website code (e.g. your landing or product/post view file), set the following:\n\n```python\nfrom flayyer import FlayyerAI\n\nflayyer = FlayyerAI(\n  # Your project slug\n  project="website-com",\n  # The current path of your website\n  path="/path/to/product", # In Django you can use {{ request.get_full_path }}\n)\n\n# Check:\nprint(flayyer.href())\n# > https://flayyer.ai/v2/website-com/_/__v=1618281823/path/to/product\n```\n\n### 3. Put your smart image link in your `<head>` tags\n\nYou\'ll get the best results like this:\n\n```python\n<meta property="og:image" content="{{ flayyer.href() }}">\n<meta name="twitter:image" content="{{ flayyer.href() }}">\n<meta name="twitter:card" content="summary_large_image">\n```\n\n### 4. Create a `rule` for your project\n\nLogin at [Flayyer.com](https://flayyer.com?ref=flayyer-python) > Go to your Dashboard > Manage rules and create a rule like the following:\n\n[![Flayyer basic rule example](https://github.com/flayyer/create-flayyer-app/blob/master/.github/assets/rule-example.png?raw=true&v=1)](https://flayyer.com/dashboard)\n\nVoilà!\n\n## Advanced usage\n\nAdvanced features include:\n\n- Custom variables: additional information for your preview that is not present in your website. [Note: if you need customization you should take a look at [Flayyer.io](#flayyerio)]\n- Custom metadata: set custom width, height, resolution, and more (see example).\n- Signed URLs.\n\nHere you have a detailed full example for project `website-com` and path `/path/to/product`.\n\n```python\nfrom flayyer import FlayyerAI, FlayyerMeta\n\nflayyer = FlayyerAI(\n  # [Required] Your project slug, find it in your dashboard https://flayyer.com/dashboard/.\n  project="website-com",\n  # [Recommended] The current path of your website (by default it\'s `/`).\n  path="/path/to/product",\n  # [Optional] In case you want to provide information that is not present in your page set it here.\n  variables={\n    "title": "Product name",\n    "img": "https://flayyer.com/img/marketplace/flayyer-banner.png",\n  },\n  # [Optional] Custom metadata for rendering the image. ID is recommended so we provide you with better statistics.\n  meta=FlayyerMeta(\n    id="jeans-123", # recommended for better stats\n    v="12369420123", # specific handler version, by default it\'s a random number to circumvent platforms\' cache,\n    width=1200,\n    height=600,\n    resolution=0.9, # from 0.0 to 1.0\n    agent="whatsapp", # force dimensions for specific platform\n  ),\n)\n\n# Check:\nprint(flayyer.href())\n# > https://flayyer.ai/v2/website-com/_/__v=1618281823/path/to/product\n```\n\nFor signed URLs, just provide your secret (find it in Dashboard > Project > Advanced settings) and choose a strategy (`HMAC` or `JWT`).\n\n```python\nflayyer = FlayyerAI(\n  project="website-com",\n  path="/path/to/product",\n  secret="your-secret-key",\n  strategy="JWT", # or \'HMAC\'\n)\n\nprint(flayyer.href())\n# > https://flayyer.ai/v2/website-com/jwt-eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJwYXJhbXMiOnsiX19pZCI6ImplYW5zLTEyMyJ9LCJwYXRoIjoiXC9wYXRoXC90b1wvcHJvZHVjdCJ9.X8Vs5SGEA1-3M6bH-h24jhQnbwH95V_G0f-gPhTBTzE?__v=1618283086\n```\n\n## Flayyer.io\n\nAs you probably realized, Flayyer.ai uses the [rules defined on your dashboard](https://flayyer.com/dashboard/_/projects) to decide how to handle every image based on path patterns. It fetches and analyse your website for obtaining information and then rendering a content-rich image increasing the click-through-rate with no effort. Let\'s say _"FlayyerAI render images based on the content of this route"_.\n\nFlayyer.io instead requires you to explicitly declare template and variables for the images to render, **giving you more control for customization**. Let\'s say _"FlayyerIO render an image using this template and these explicit variables"_.\n\n```python\nfrom flayyer import Flayyer\n\nflayyer = Flayyer(\n    tenant="tenant",\n    deck="deck",\n    template="template",\n    variables={"title": "Hello world!"},\n)\n\n# Use this image in your <head/> tags\nurl = flayyer.href()\n# > https://flayyer.io/v2/tenant/deck/template.jpeg?__v=1596906866&title=Hello+world%21\n```\n\nVariables can be complex arrays and hashes.\n\n```python\nfrom flayyer import Flayyer, FlayyerMeta\n\nflayyer = Flayyer(\n    tenant="tenant",\n    deck="deck",\n    template="template",\n    variables={\n        "items": [\n            { "text": "Oranges", "count": 12 },\n            { "text": "Apples", "count": 14 },\n        ],\n    },\n    meta=FlayyerMeta(\n        id="slug-or-id", # To identify the resource in our analytics report\n    ),\n)\n```\n\n**IMPORTANT: variables must be serializable.**\n\nTo decode the URL for debugging purposes:\n\n```python\nfrom urllib.parse import unquote\n\nprint(unquote(url))\n# > https://flayyer.io/v2/tenant/deck/template.jpeg?title=Hello+world!&__v=123\n```\n\n## Development\n\nPrepare the local environment:\n\n```sh\npoetry install\n```\n\n```sh\npoetry shell\n```\n\nDeploy with:\n\n```sh\n# Set API Token\npoetry config pypi-token.pypi pypi-TOKEN\n\npoetry version X.Y.Z\npoetry build\npoetry publish\n```\n\n## Test\n\nRun tests with pytest:\n\n```sh\npoetry run pytest\n```\n\nRun [black](https://github.com/psf/black) linter:\n\n```sh\nblack .\n```\n',
    'author': 'Patricio López Juri',
    'author_email': 'patricio@flayyer.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://flayyer.com/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
