# Sample Applications Overview

- [Fraud Graph](#Fraud-Graph)
- [Knowledge Graph](#Knowledge-Graph)
- [Identity Graph](#Identity-Graph)


## [Fraud Graph](./01-Fraud-Graphs/01-Building-a-Fraud-Graph-Application.ipynb)

Fraud hides itself in isolation. It exploits our failure to assess a transaction in the context of other recent transactions: patterns of fraudulent behaviour emerge only when we connect many seemingly discrete data points and events.

A fraud graph connects the entities participating in retail and financial transactions: entities such as accounts, transactions and merchants. By relating accounts and connecting transactions we improve our chances to detect and prevent fraud. With Amazon Neptune we can connect account and transaction information and query it whenever a new account or transaction is submitted to the system. Using queries that find patterns in our data that we know to be indicative of fraud, we can evaluate each transaction in the context of other transactions and accounts, and thereby determine whether constellations of data in the fraud graph represent fraudulent activity.

The examples in this notebook show how we can identify fraud rings (first-party fraud) and instances of identity theft (third-party fraud) in a credit card dataset.

## [Knowledge Graph](./02-Knowledge-Graphs/01-Building-a-Knowledge-Graph-Application.ipynb)

Modern knowledge graphs are the result of connections of data from multiple different sources. These sources can either be multiple different databases, different data silos, or data extracted from within entities stored in one or more of these options. Knowledge graphs come in many different forms but the unifying aspect of them is that they organize data using the entities and connections (known as semantics) familiar to a particular domain. It represents these semantics as definitions of concepts, their properties, relations between them, and the expected logical constraints. Logic built into such a model allows us to infer understanding and connections about the information contained within the model.

Knowledge graphs consolidate and integrate an organization’s information assets and make them more readily available to all members of the organization. There are many applications and use cases that are enabled by knowledge graphs. Information from disparate data sources can be linked and made accessible to answer questions you may not even have thought of yet. Information and entities can be extracted not only from structured sources (e.g., relational databases) but also from semi-structured sources (e.g., media, metadata, and spreadsheets) and unstructured sources (e.g., text documents, email, and news articles).

The examples in this notebook show how we can use our blog knowledge graph to demonstrate how we can use the connected nature of our knowledge graph to provide contextually relevant answers to search questions.

## [Identity Graph](./03-Identity-Graphs/01-Building-an-Identity-Graph-Application.ipynb)

An identity graph provides a single unified view of customers and prospects by linking multiple identifiers such as cookies, device identifiers, IP addresses, email IDs, and internal enterprise IDs to a known person or anonymous profile using privacy-compliant methods. Typically, identity graphs are part of a larger identity resolution architecture. Identity resolution is the process of matching human identity across a set of devices used by the same person or a household of persons for the purposes of building a representative identity, or known attributes, for targeted advertising.

The examples in this notebook shows a sample identity graph solution using an open dataset as well as data visualizations that allow one to better understand the structure of an identity graph.