import * as cdk from '@aws-cdk/core';
import { Construct } from 'constructs';
import { IMesh } from './mesh';
import { Route, RouteBaseProps } from './route';
import { VirtualRouterListener } from './virtual-router-listener';
/**
 * (experimental) Interface which all VirtualRouter based classes MUST implement.
 *
 * @experimental
 */
export interface IVirtualRouter extends cdk.IResource {
    /**
     * (experimental) The name of the VirtualRouter.
     *
     * @experimental
     * @attribute true
     */
    readonly virtualRouterName: string;
    /**
     * (experimental) The Amazon Resource Name (ARN) for the VirtualRouter.
     *
     * @experimental
     * @attribute true
     */
    readonly virtualRouterArn: string;
    /**
     * (experimental) The Mesh which the VirtualRouter belongs to.
     *
     * @experimental
     */
    readonly mesh: IMesh;
    /**
     * (experimental) Add a single route to the router.
     *
     * @experimental
     */
    addRoute(id: string, props: RouteBaseProps): Route;
}
/**
 * (experimental) Interface with base properties all routers willl inherit.
 *
 * @experimental
 */
export interface VirtualRouterBaseProps {
    /**
     * (experimental) Listener specification for the VirtualRouter.
     *
     * @default - A listener on HTTP port 8080
     * @experimental
     */
    readonly listeners?: VirtualRouterListener[];
    /**
     * (experimental) The name of the VirtualRouter.
     *
     * @default - A name is automatically determined
     * @experimental
     */
    readonly virtualRouterName?: string;
}
declare abstract class VirtualRouterBase extends cdk.Resource implements IVirtualRouter {
    /**
     * The name of the VirtualRouter
     */
    abstract readonly virtualRouterName: string;
    /**
     * The Amazon Resource Name (ARN) for the VirtualRouter
     */
    abstract readonly virtualRouterArn: string;
    /**
     * The Mesh which the VirtualRouter belongs to
     */
    abstract readonly mesh: IMesh;
    /**
     * (experimental) Add a single route to the router.
     *
     * @experimental
     */
    addRoute(id: string, props: RouteBaseProps): Route;
}
/**
 * (experimental) The properties used when creating a new VirtualRouter.
 *
 * @experimental
 */
export interface VirtualRouterProps extends VirtualRouterBaseProps {
    /**
     * (experimental) The Mesh which the VirtualRouter belongs to.
     *
     * @experimental
     */
    readonly mesh: IMesh;
}
/**
 * @experimental
 */
export declare class VirtualRouter extends VirtualRouterBase {
    /**
     * (experimental) Import an existing VirtualRouter given an ARN.
     *
     * @experimental
     */
    static fromVirtualRouterArn(scope: Construct, id: string, virtualRouterArn: string): IVirtualRouter;
    /**
     * (experimental) Import an existing VirtualRouter given attributes.
     *
     * @experimental
     */
    static fromVirtualRouterAttributes(scope: Construct, id: string, attrs: VirtualRouterAttributes): IVirtualRouter;
    /**
     * (experimental) The name of the VirtualRouter.
     *
     * @experimental
     */
    readonly virtualRouterName: string;
    /**
     * (experimental) The Amazon Resource Name (ARN) for the VirtualRouter.
     *
     * @experimental
     */
    readonly virtualRouterArn: string;
    /**
     * (experimental) The Mesh which the VirtualRouter belongs to.
     *
     * @experimental
     */
    readonly mesh: IMesh;
    private readonly listeners;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: VirtualRouterProps);
    /**
     * Add port mappings to the router
     */
    private addListener;
}
/**
 * (experimental) Interface with properties ncecessary to import a reusable VirtualRouter.
 *
 * @experimental
 */
export interface VirtualRouterAttributes {
    /**
     * (experimental) The name of the VirtualRouter.
     *
     * @experimental
     */
    readonly virtualRouterName: string;
    /**
     * (experimental) The Mesh which the VirtualRouter belongs to.
     *
     * @experimental
     */
    readonly mesh: IMesh;
}
export {};
