/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.LineLocationImpl;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.style.AutomaticCounter;
import net.sourceforge.plantuml.style.Context;
import net.sourceforge.plantuml.style.NoStyleAvailableException;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.ValueImpl;

public class StyleLoader {
    private final SkinParam skinParam;
    private StyleBuilder styleBuilder;
    private static final String KEYNAMES = "[\\w(), ]+?";
    private static final Pattern2 keyName = MyPattern.cmpile("^[.:]?([\\w(), ]+?)([%s]+\\*)?[%s]*\\{$");
    private static final Pattern2 propertyAndValue = MyPattern.cmpile("^([\\w]+):?[%s]+(.*?);?$");
    private static final Pattern2 closeBracket = MyPattern.cmpile("^\\}$");

    public StyleLoader(SkinParam skinParam) {
        this.skinParam = skinParam;
    }

    public StyleBuilder loadSkin(String filename) throws IOException {
        this.styleBuilder = new StyleBuilder(this.skinParam);
        InputStream internalIs = null;
        SFile localFile = new SFile(filename);
        Log.info("Trying to load style " + filename);
        if (!localFile.exists()) {
            localFile = FileSystem.getInstance().getFile(filename);
        }
        if (localFile.exists()) {
            Log.info("File found : " + localFile.getPrintablePath());
            internalIs = localFile.openFile();
        } else {
            Log.info("File not found : " + localFile.getPrintablePath());
            String res = "/skin/" + filename;
            internalIs = StyleLoader.class.getResourceAsStream(res);
            if (internalIs != null) {
                Log.info("... but " + filename + " found inside the .jar");
            }
        }
        if (internalIs == null) {
            Log.error("No .skin file seems to be available");
            throw new NoStyleAvailableException();
        }
        BlocLines lines2 = BlocLines.load(internalIs, (LineLocation)new LineLocationImpl(filename, null));
        this.loadSkinInternal(lines2);
        if (this.styleBuilder == null) {
            Log.error("No .skin file seems to be available");
            throw new NoStyleAvailableException();
        }
        return this.styleBuilder;
    }

    private void loadSkinInternal(BlocLines lines) {
        for (Style newStyle : StyleLoader.getDeclaredStyles(lines, this.styleBuilder)) {
            this.styleBuilder.loadInternal(newStyle.getSignature(), newStyle);
        }
    }

    public static Collection<Style> getDeclaredStyles(BlocLines lines, AutomaticCounter counter) {
        lines = lines.eventuallyMoveAllEmptyBracket();
        ArrayList<Style> result = new ArrayList<Style>();
        Context context = new Context();
        ArrayList maps = new ArrayList();
        boolean inComment = false;
        for (StringLocated s : lines) {
            Matcher2 mKeyNames;
            String trimmed = s.getTrimmed().getString();
            if (trimmed.startsWith("/*") || trimmed.endsWith("*/") || trimmed.startsWith("/'") || trimmed.endsWith("'/")) continue;
            if (trimmed.startsWith("/*") || trimmed.startsWith("/'")) {
                inComment = true;
                continue;
            }
            if (trimmed.endsWith("*/") || trimmed.endsWith("'/")) {
                inComment = false;
                continue;
            }
            if (inComment) continue;
            int x = trimmed.lastIndexOf("//");
            if (x != -1) {
                trimmed = trimmed.substring(0, x).trim();
            }
            if ((mKeyNames = keyName.matcher(trimmed)).find()) {
                boolean isRecurse;
                String names = mKeyNames.group(1).replace(" ", "");
                boolean bl = isRecurse = mKeyNames.group(2) != null;
                if (isRecurse) {
                    names = names + "*";
                }
                context = context.push(names);
                maps.add(new EnumMap(PName.class));
                continue;
            }
            Matcher2 mPropertyAndValue = propertyAndValue.matcher(trimmed);
            if (mPropertyAndValue.find()) {
                PName key = PName.getFromName(mPropertyAndValue.group(1));
                String value = mPropertyAndValue.group(2);
                if (key == null || maps.size() <= 0) continue;
                ((Map)maps.get(maps.size() - 1)).put(key, new ValueImpl(value, counter));
                continue;
            }
            Matcher2 mCloseBracket = closeBracket.matcher(trimmed);
            if (!mCloseBracket.find() || context.size() <= 0) continue;
            Collection<StyleSignature> signatures = context.toSignatures();
            for (StyleSignature signature : signatures) {
                Style style = new Style(signature, (Map)maps.get(maps.size() - 1));
                result.add(style);
            }
            context = context.pop();
            maps.remove(maps.size() - 1);
        }
        return Collections.unmodifiableList(result);
    }
}

