/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.style.StyleSignature;

class Context {
    private final List<String> data = new ArrayList<String>();

    Context() {
    }

    public Context push(String newString) {
        Context result = new Context();
        result.data.addAll(this.data);
        result.data.add(newString);
        return result;
    }

    public Context pop() {
        if (this.size() == 0) {
            throw new IllegalStateException();
        }
        Context result = new Context();
        result.data.addAll(this.data.subList(0, this.data.size() - 1));
        return result;
    }

    public String toString() {
        return this.data.toString();
    }

    public int size() {
        return this.data.size();
    }

    public Collection<StyleSignature> toSignatures() {
        ArrayList<StyleSignature> results = new ArrayList<StyleSignature>(Collections.singletonList(StyleSignature.empty()));
        boolean star = false;
        for (String s : this.data) {
            if (s.endsWith("*")) {
                star = true;
                s = s.substring(0, s.length() - 1);
            }
            String[] names = s.split(",");
            ArrayList<StyleSignature> tmp = new ArrayList<StyleSignature>();
            for (StyleSignature ss : results) {
                for (String name : names) {
                    tmp.add(ss.add(name));
                }
            }
            results = tmp;
        }
        if (star) {
            Iterator<String> it = results.listIterator();
            while (it.hasNext()) {
                StyleSignature tmp = ((StyleSignature)it.next()).addStar();
                it.set((String)((Object)tmp));
            }
        }
        return Collections.unmodifiableCollection(results);
    }
}

