/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.legacy;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.BackSlash;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.creole.atom.AbstractAtom;
import net.sourceforge.plantuml.creole.atom.Atom;
import net.sourceforge.plantuml.creole.legacy.AtomTextUtils;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorAutomatic;
import net.sourceforge.plantuml.ugraphic.color.HColorAutomaticLegacy;
import net.sourceforge.plantuml.ugraphic.color.HColorSimple;
import net.sourceforge.plantuml.utils.CharHidder;

public final class AtomText
extends AbstractAtom
implements Atom {
    private final FontConfiguration fontConfiguration;
    private final String text;
    private final DelayedDouble marginLeft;
    private final DelayedDouble marginRight;
    private final Url url;
    private final boolean manageSpecialChars;
    private TextBlock visibility;

    protected AtomText(String text, FontConfiguration style, Url url, DelayedDouble marginLeft, DelayedDouble marginRight, boolean manageSpecialChars) {
        if (text.contains("" + BackSlash.hiddenNewLine())) {
            throw new IllegalArgumentException(text);
        }
        this.marginLeft = marginLeft;
        this.marginRight = marginRight;
        String s = CharHidder.unhide(text);
        if (manageSpecialChars) {
            s = StringUtils.showComparatorCharacters(s);
            s = StringUtils.manageAmpDiese(s);
            s = StringUtils.manageUnicodeNotationUplus(s);
            s = StringUtils.manageTildeArobaseStart(s);
            s = StringUtils.manageEscapedTabs(s);
        }
        this.manageSpecialChars = manageSpecialChars;
        this.text = s;
        this.fontConfiguration = style;
        this.url = url;
    }

    private AtomText withText(String text) {
        return new AtomText(text, this.fontConfiguration, this.url, this.marginLeft, this.marginRight, this.manageSpecialChars);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D rect = stringBounder.calculateDimension(this.fontConfiguration.getFont(), this.text);
        Log.debug("g2d=" + rect);
        Log.debug("Size for " + this.text + " is " + rect);
        double h = rect.getHeight();
        if (h < 10.0) {
            h = 10.0;
        }
        double width = this.text.indexOf("\t") == -1 ? rect.getWidth() : this.getWidth(stringBounder, this.text);
        double left = this.marginLeft.getDouble(stringBounder);
        double right = this.marginRight.getDouble(stringBounder);
        if (this.visibility != null) {
            width += this.visibility.calculateDimension(stringBounder).getWidth();
        }
        return new Dimension2DDouble(width + left + right, h);
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        if (ug.matchesProperty("SPECIALTXT")) {
            ug.draw(this);
        } else {
            if (this.visibility != null) {
                this.visibility.drawU(ug.apply(UTranslate.dy(2.0)));
                double width = this.visibility.calculateDimension(ug.getStringBounder()).getWidth();
                ug = ug.apply(UTranslate.dx(width));
            }
            HColor textColor = this.fontConfiguration.getColor();
            FontConfiguration useFontConfiguration = this.fontConfiguration;
            if (textColor instanceof HColorAutomaticLegacy && ug.getParam().getBackcolor() != null) {
                textColor = ((HColorSimple)ug.getParam().getBackcolor()).opposite();
                useFontConfiguration = this.fontConfiguration.changeColor(textColor);
            }
            if (textColor instanceof HColorAutomatic) {
                HColor backcolor = ug.getParam().getBackcolor();
                if (backcolor == null) {
                    backcolor = ug.getDefaultBackground();
                }
                textColor = ((HColorAutomatic)textColor).getAppropriateColor(backcolor);
                useFontConfiguration = this.fontConfiguration.changeColor(textColor);
            }
            if (this.marginLeft != AtomTextUtils.ZERO) {
                ug = ug.apply(UTranslate.dx(this.marginLeft.getDouble(ug.getStringBounder())));
            }
            StringTokenizer tokenizer = new StringTokenizer(this.text, "\t", true);
            Dimension2D rect = ug.getStringBounder().calculateDimension(this.fontConfiguration.getFont(), this.text);
            double descent = this.getDescent(ug.getStringBounder());
            double ypos = rect.getHeight() - descent;
            double x = 0.0;
            if (tokenizer.hasMoreTokens()) {
                double tabSize = this.getTabSize(ug.getStringBounder());
                while (tokenizer.hasMoreTokens()) {
                    String s = tokenizer.nextToken();
                    if (s.equals("\t")) {
                        double remainder = x % tabSize;
                        x += tabSize - remainder;
                        continue;
                    }
                    Dimension2D dim = ug.getStringBounder().calculateDimension(this.fontConfiguration.getFont(), s);
                    UText utext = new UText(s, useFontConfiguration);
                    ug.apply(new UTranslate(x, ypos)).draw(utext);
                    x += dim.getWidth();
                }
            }
        }
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    private double getWidth(StringBounder stringBounder, String text) {
        StringTokenizer tokenizer = new StringTokenizer(text, "\t", true);
        double tabSize = this.getTabSize(stringBounder);
        double x = 0.0;
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            if (s.equals("\t")) {
                double remainder = x % tabSize;
                x += tabSize - remainder;
                continue;
            }
            Dimension2D dim = stringBounder.calculateDimension(this.fontConfiguration.getFont(), s);
            x += dim.getWidth();
        }
        return x;
    }

    private String tabString() {
        int nb = this.fontConfiguration.getTabSize();
        if (nb >= 1 && nb < 7) {
            return "        ".substring(0, nb);
        }
        return "        ";
    }

    private double getDescent(StringBounder stringBounder) {
        return stringBounder.getDescent(this.fontConfiguration.getFont(), this.text);
    }

    private double getTabSize(StringBounder stringBounder) {
        return stringBounder.calculateDimension(this.fontConfiguration.getFont(), this.tabString()).getWidth();
    }

    private final Collection<String> splitted() {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder pending = new StringBuilder();
        for (int i = 0; i < this.text.length(); ++i) {
            char ch = this.text.charAt(i);
            if (this.isSeparator(ch)) {
                if (pending.length() > 0) {
                    result.add(pending.toString());
                }
                result.add("" + ch);
                pending.setLength(0);
                continue;
            }
            if (this.isChineseSentenceBoundary(ch)) {
                pending.append(ch);
                result.add(pending.toString());
                pending.setLength(0);
                continue;
            }
            pending.append(ch);
        }
        if (pending.length() > 0) {
            result.add(pending.toString());
        }
        return result;
    }

    private final Collection<String> splittedOld() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.text.length(); ++i) {
            char ch = this.text.charAt(i);
            if (this.isSeparator(ch)) {
                result.add("" + this.text.charAt(i));
                continue;
            }
            StringBuilder tmp = new StringBuilder();
            tmp.append(ch);
            while (i + 1 < this.text.length() && !this.isSeparator(this.text.charAt(i + 1))) {
                tmp.append(this.text.charAt(++i));
            }
            result.add(tmp.toString());
        }
        return result;
    }

    public List<Atom> getSplitted(StringBounder stringBounder, LineBreakStrategy maxWidthAsString) {
        double maxWidth = maxWidthAsString.getMaxWidth();
        if (maxWidth == 0.0) {
            throw new IllegalStateException();
        }
        ArrayList<AtomText> result = new ArrayList<AtomText>();
        StringTokenizer st = new StringTokenizer(this.text, " ", true);
        StringBuilder currentLine = new StringBuilder();
        while (st.hasMoreTokens()) {
            String token1 = st.nextToken();
            for (String tmp : Arrays.asList(token1)) {
                double w = this.getWidth(stringBounder, currentLine + tmp);
                if (w > maxWidth) {
                    result.add(this.withText(currentLine.toString()));
                    currentLine.setLength(0);
                    if (tmp.startsWith(" ")) continue;
                    currentLine.append(tmp);
                    continue;
                }
                currentLine.append(tmp);
            }
        }
        result.add(this.withText(currentLine.toString()));
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Atom> splitInTwo(StringBounder stringBounder, double width) {
        StringBuilder tmp = new StringBuilder();
        for (String token : this.splitted()) {
            if (tmp.length() > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                if (this.getWidth(stringBounder, stringBuilder.append(tmp.toString()).append(token).toString()) > width) {
                    AtomText part1 = this.withText(tmp.toString());
                    String remain = this.text.substring(tmp.length());
                    while (remain.startsWith(" ")) {
                        remain = remain.substring(1);
                    }
                    AtomText part2 = this.withText(remain);
                    return Arrays.asList(part1, part2);
                }
            }
            tmp.append(token);
        }
        return Collections.singletonList(this);
    }

    private boolean isSeparator(char ch) {
        return Character.isWhitespace(ch);
    }

    private boolean isChineseSentenceBoundary(char ch) {
        return ch == '\uff01' || ch == '\uff0c' || ch == '\uff1a' || ch == '\uff1b' || ch == '\uff1f' || ch == '\u3002';
    }

    public final String getText() {
        return this.text;
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return this.fontConfiguration.getSpace();
    }

    public String toString() {
        return this.text + " " + this.fontConfiguration;
    }

    public FontConfiguration getFontConfiguration() {
        return this.fontConfiguration;
    }

    protected static interface DelayedDouble {
        public double getDouble(StringBounder var1);
    }
}

