# Generated by Django 2.2 on 2020-09-09 22:06

from django.db import migrations, models
import django.db.models.deletion
import djangoldp.fields


class Migration(migrations.Migration):

    dependencies = [
        ('djangoldp', '0013_auto_20200624_1709'),
    ]

    operations = [
        migrations.CreateModel(
            name='ScheduledActivity',
            fields=[
                ('activity_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='djangoldp.Activity')),
                ('failed_attempts', models.PositiveIntegerField(default=0, help_text='a log of how many failed retries have been made sending the activity')),
            ],
            options={
                'abstract': False,
                'default_permissions': ('add', 'change', 'delete', 'view', 'control'),
            },
            bases=('djangoldp.activity',),
        ),
        migrations.AlterField(
            model_name='activity',
            name='created_at',
            field=models.DateTimeField(auto_now_add=True),
        ),
        migrations.AlterField(
            model_name='activity',
            name='local_id',
            field=djangoldp.fields.LDPUrlField(help_text='/inbox or /outbox url (local - this server)'),
        ),
        migrations.AlterField(
            model_name='activity',
            name='payload',
            field=models.BinaryField(),
        ),
        migrations.AddField(
            model_name='activity',
            name='success',
            field=models.BooleanField(default=False,
                                      help_text='set to True when an Activity is successfully delivered'),
        ),
        migrations.AddField(
            model_name='activity',
            name='type',
            field=models.CharField(blank=True, help_text='the ActivityStreams type of the Activity', max_length=64,
                                   null=True),
        ),
        migrations.AddField(
            model_name='activity',
            name='is_finished',
            field=models.BooleanField(default=True),
        ),
        migrations.AddField(
            model_name='activity',
            name='response_code',
            field=models.CharField(blank=True, help_text='Response code sent by receiver', max_length=8, null=True),
        ),
        migrations.AddField(
            model_name='activity',
            name='response_location',
            field=djangoldp.fields.LDPUrlField(blank=True, help_text='Location saved activity can be found', null=True),
        ),
        migrations.AddField(
            model_name='activity',
            name='response_body',
            field=models.BinaryField(null=True),
        ),
        migrations.AddField(
            model_name='activity',
            name='external_id',
            field=djangoldp.fields.LDPUrlField(help_text='the /inbox or /outbox url (from the sender or receiver)',
                                               null=True),
        ),
        migrations.RemoveField(
            model_name='activity',
            name='aid',
        ),
    ]
