import * as codepipeline from '@aws-cdk/aws-codepipeline';
/**
 * Low-level class for generic CodePipeline Actions.
 *
 * If you're implementing your own IAction,
 * prefer to use the Action class from the codepipeline module.
 *
 * @stability stable
 */
export declare abstract class Action extends codepipeline.Action {
    /**
     * This is a renamed version of the {@link IAction.actionProperties} property.
     *
     * @stability stable
     */
    protected readonly providedActionProperties: codepipeline.ActionProperties;
    /**
     * @stability stable
     */
    protected constructor(actionProperties: codepipeline.ActionProperties);
}
