import { OptionalArgument } from '../../helpers';
import type { AppID, CursorPaginationEnabled, TokenOverridable } from '../common';
interface RequestID {
    /** @description The id of the request. */
    request_id: string;
}
type AppOrRequestID = (AppID & {
    request_id?: never;
}) | (RequestID & {
    app_id?: never;
});
interface EnterpriseID {
    /** @description The ID of the enterprise. */
    enterprise_id: string;
}
interface TeamID {
    /** @description The ID of the workspace. */
    team_id: string;
}
type TeamOrEnterpriseID = (EnterpriseID & {
    team_id?: never;
}) | (TeamID & {
    enterprise_id?: never;
});
interface Certified {
    /**
     * @description Include certified apps. Defaults to `false`.
     */
    certified?: boolean;
}
export type AdminAppsActivitiesListArguments = OptionalArgument<Partial<AppID> & Partial<TeamID> & TokenOverridable & CursorPaginationEnabled & {
    /**
     * @description The component ID of log events to be returned. Will be `FnXXXXXX` for functions,
     * and `WfXXXXXX` for worflows.
     */
    component_id?: string;
    /** @description The component type of log events to be returned. */
    component_type?: 'events_api' | 'workflows' | 'functions' | 'tables';
    /** @description The event type of log events to be returned. */
    log_event_type?: string;
    /** @description The latest timestamp of the log to retrieve (epoch microseconds). */
    max_date_created?: number;
    /** @description The earliest timestamp of the log to retrieve (epoch microseconds). */
    min_date_created?: number;
    /** @description The minimum log level of the log events to be returned. Defaults to `info`. */
    min_log_level?: 'trace' | 'debug' | 'info' | 'warn' | 'error' | 'fatal';
    /** @description The direction you want the data sorted by (always by timestamp). */
    sort_direction?: 'asc' | 'desc';
    /** @description The source of log events to be returned. */
    source?: 'slack' | 'developer';
    /** @description The trace ID of log events to be returned. */
    trace_id?: string;
}>;
export type AdminAppsApproveArguments = AppOrRequestID & TeamOrEnterpriseID & TokenOverridable;
export type AdminAppsApprovedListArguments = Partial<TeamOrEnterpriseID> & TokenOverridable & CursorPaginationEnabled & Certified;
export type AdminAppsClearResolutionArguments = AppID & TeamOrEnterpriseID & TokenOverridable;
export interface AdminAppsConfigLookupArguments extends TokenOverridable {
    /** @description An array of app IDs to get app configs for. */
    app_ids: string[];
}
export interface AdminAppsConfigSetArguments extends AppID, TokenOverridable {
    /** @description Domain restrictions for the app. */
    domain_restrictions?: {
        /** @description Sets allowed URLs for the app. */
        urls?: string[];
        /** @description Sets emails for connector authorization. */
        emails?: string[];
    };
    /** @description The workflow auth permission. */
    workflow_auth_strategy?: 'builder_choice' | 'end_user_only';
}
export type AdminAppsRequestsCancelArguments = RequestID & TeamOrEnterpriseID & TokenOverridable;
export type AdminAppsRequestsListArguments = TeamOrEnterpriseID & Certified & TokenOverridable & CursorPaginationEnabled;
export type AdminAppsRestrictArguments = AppOrRequestID & TeamOrEnterpriseID & TokenOverridable;
export type AdminAppsRestrictedListArguments = TeamOrEnterpriseID & Certified & TokenOverridable & CursorPaginationEnabled;
export type AdminAppsUninstallArguments = AppID & TeamOrEnterpriseID & TokenOverridable;
export {};
//# sourceMappingURL=apps.d.ts.map